Ext.define('TrafficWidgetModel', {
    extend: 'Ext.data.Model',
    fields: [
        { name:'state', type:'string' },
        { name:'heading', type:'string' },
        { name:'value', type:'string' },
		{ name:'legend', type:'string' },
		{ name:'graphID', type:'string' },
		{ name:'dd_url', type:'string' },
		{ name:'graphData' }
    ]
});

// .stateIconRumAppFlowHealthy, .stateIconRumAppFlowMinor, .stateIconRumAppFlowMajor, .stateRumAppFlowNotOk

//<div  class="font_bold18" style="display:inline-block">{value}</div><div class="font_normal11" style="vertical-align:top;display:inline-block"> {legend}</div>
 Ext.define('RumAppFlow.view.TrafficWidget', {
		extend: 'Ext.container.Container',
		alias:'widget.trafficwidget',
		cls:'widgetcon',
		ui:'appflowtraffic',
		autoDestroy:true,
		initComponenet:function(){
			var me = this;
			me.callParent();
		},
		updateData:function(data){
				var me = this;
				Ext.getCmp('dataview_'+this.id).store.loadRawData(data);
				try
				{
					if(!Ext.isEmpty(data.graphData) && data.graphData.trim().toLowerCase() == "no data found"){
						$('#graph-traffic').html('<div style="display:table;height:100%;width:100%;text-align:center;font-size:10px;margin-top:25px !important">-</div>');
					}
					else
						$('#graph-traffic').highcharts(getTrafficWidgPanelJson(data));
					
				}
				catch (ee)
				{
					$('#graph-traffic').highcharts(getTrafficWidgPanelJson(data));
				}				
		},
		listeners:{
		 'afterrender':function(e){
			var trafficWidgTpl = new Ext.XTemplate(
				'<div class="widgetholders">',
				'<tpl for=".">',
					'<div class="s_box">',
					 '<div class="font_bold12 div_center trim_text" style="float:left;width:40%"><img style="vertical-align:sub" src="/final/images/clear.png" class="stateSymbol_{state}" /> <span data-qtip="{heading}">{heading}</ span></div>',
					 '<div style="float:right;width:60%;text-align:right;padding-right:15px" class="div_center"><div class="font_bold20" style="border:0px solid green !important;margin-right:3px;text-align:right;display:inline-block;line-height:18px"><a style="border:0px solid green !important;" href="javascript:void(0);" onclick=\'javascript:showDDPopup("{dd_url}") \' >{value}</a></div><div class="font_normal10" style="text-transform:lowercase;line-height:9px;display:inline-block;text-align:left;vertical-align:top;width:51px">{legend}</div></div>',
					 '<div style="clear:both"></div>',
					 '</div>',
					'<div class="b_box">',
					  '<div class="font_bold12"><img style="vertical-align:sub" src="/final/images/clear.png" class="stateSymbol_{state}" /> <span data-qtip="{heading}">{heading}</ span></div>',
						'<div class="font_normal31 d_m_t20" style="border:0px solid red !important;text-align:center"><a href="javascript:void(0);" onclick=\'javascript:showDDPopup("{dd_url}") \' style="border:0px solid red !important;">{value}</a></div>',
						'<div class="font_normal11 legendLabel" style="text-align:center">{legend}</div>',
						'<div id="graph-traffic" class="appflow_rum_graph" style="width:110px;height:35px;min-width:90px;"></div>',
					'</div>',
				'</tpl>',
				'</div>'
			);
			var trafficWidg = this.getTrafficWidgPanel(this.data,this,trafficWidgTpl);
			this.add(trafficWidg);
		 }
		},
		getTrafficWidgPanel:function(data1,thisObje,tplDes){
			var item = {
				xtype:'dataview',
				padding:'5 0 5 5',
				id:'dataview_'+this.id,
				//store: Ext.data.StoreManager.lookup('trafficWidget_model_id'),
				store: Ext.create('Ext.data.Store', {
					id:'trafficWidget_model_id',
					model: 'TrafficWidgetModel',
					autoLoad:true,
					data:data1
				}),
				tpl:tplDes,
				listeners:{
				
					viewready:function(x){
						var me = this;
						try
						{
							if(!Ext.isEmpty(data1.graphData) && data1.graphData.trim().toLowerCase() == "no data found"){
								$('#graph-traffic').html('<div style="display:table;height:100%;width:100%;text-align:center;font-size:10px;margin-top:25px !important">-</div>');
							}
							else
								$('#graph-traffic').highcharts(getTrafficWidgPanelJson(data1));
						}
						catch (ee)
						{
							$('#graph-traffic').highcharts(getTrafficWidgPanelJson(data1));
						}
						
					}
				}
			}
			return item;

		},		
		items:[]
		
		
 });
 /*
 .stateSymbol_HIGH, .stateSymbol_INTERMEDIATE, .stateSymbol_LOW, .stateSymbol_UNKNOWN, .stateSymbol_GOOD, .stateSymbol_GRAY
 */


function getTrafficWidgPanelJson(dataforGraph){
	var jsonDataArray = dataforGraph.graphData;
	var sum = 0;
	var maxVal = null;
	//For displaying Zero Values in area Chart
	for(var t=0; t< jsonDataArray.length;t++){
		sum += jsonDataArray[t];
	}
	if(sum == 0){
		for(var t=0; t< jsonDataArray.length;t++){
			jsonDataArray[t] = 1;
		}	
		maxVal = 10;
	}
	var jsonData = 
		{
			credits: {
				enabled: false
			},
			chart: {
				type: 'area',
				spacingBottom: 0,
				spacingTop: 0,
				spacingLeft: 0,
				spacingRight: 0,
				width: 120,
				height: 35,
				backgroundColor: null
			},
			exporting: {
				enabled: false
			},
			title: {
				text: ''
			},
			tooltip: {
					enabled: false
				},

			xAxis: {
				allowDecimals: false,
				reversed:true,
				visible: false,
				minorGridLineWidth: 0,
				minorTickLength: 0,
				tickLength: 0,
				lineColor: 'transparent',
				labels: {
					enabled: false
				},

			},
			yAxis: {
				max:maxVal,
				minorGridLineWidth: 0,
				visible: false,
				lineColor: 'transparent',
				gridLineColor: 'transparent',
				minorTickLength: 0,
				tickLength: 0,
				
				labels: {
					enabled: false
				}
			},

			plotOptions: {
				area: {
					marker: {
						enabled: false,
						symbol: 'circle',
						states: {
							hover: {
								enabled: true
							}
						}
					}
				}
			},
			series: [{
				showInLegend: false,
				color: '#D19FC9',
				lineColor:'transparent',
				// @ updatinig the data
				data: jsonDataArray
			}]
		}
	jsonData= jQuery.extend(true,jsonData,getUserThemeFor(strSkin));
	return jsonData;
};