Ext.define('UniqueSessionsModel', {
    extend: 'Ext.data.Model',
    fields: [{
            name: 'state',
            type: 'string'
        },
        {
            name: 'heading',
            type: 'string'
        },
        {
            name: 'text',
            type: 'string'
        },
        {
            name: 'value',
            type: 'string'
        },
		{
            name: 'y',
            type: 'string'
        },
        {
            name: 'legend',
            type: 'string'
        },
        {
            name: 'dd_url',
            type: 'string'
        },
        {
            name: 'sessions'
        },
        {
            name: 'graphID',
            type: 'string'
        }
    ]
});

// .stateIconRumAppFlowHealthy, .stateIconRumAppFlowMinor, .stateIconRumAppFlowMajor, .stateRumAppFlowNotOk

Ext.define('RumAppFlow.view.UniqueSessionsWidget', {
    extend: 'Ext.container.Container',
    alias: 'widget.uniquesessionswidget',
    cls: 'widgetcon',
    ui: 'uniqueSessions',
    autoDestroy: true,
	updateData:function(data){
			var me = this;
			Ext.getCmp('dataview_'+this.id).store.loadRawData(data);
			var jsonDatae = getUniqueSessionWidgPanelJson(data);	
			$('#uniquesessions-graph').highcharts(jsonDatae);
	},
	listeners:{
		'afterrender':function(e){
			var uniqueSessionsTpl = new Ext.XTemplate(
				'<tpl for=".">',
				'<div>',				
					'<div class="s_box">',
						'<div class="font_bold12 div_center" style="float:left;width:60%"><img style="position: absolute;top: 0;bottom: 0;margin: auto;" src="/final/images/clear.png" class="stateSymbol_{state}" /><span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:20px;padding-top:2px;" data-qtip="{heading}">{heading}</span></div>',
						'<div style="float:right;text-align:right;padding-right:10px" class="div_center"><div><span class="font_bold20"  style="line-height:20px"><a style="border:0px solid green !important;" href="javascript:void(0);" onclick=\'javascript:showDDPopup("{dd_url}") \' >{value}</a></span><span class="font_normal10 trim_text" style="text-transform:lowercase;text-align:right;width:20%"> {legend}</span></div></div>',
					'<div style="clear:both"></div>',
					'</div>',
					'<div class="b_box">',
					  '<div class="font_bold12 trim_text"><img style="vertical-align:sub" src="/final/images/clear.png" class="stateSymbol_{state}" /> <span data-qtip="{heading}">{heading}</ span></div>',
						'<table style="width:100%;margin:-10px auto auto auto;border:0px solid blue !important"><tr>',
						//'<td style="border:0px solid blue !important;" onclick=\'javascript:showDDPopup("{dd_url}") \'>',
						//'<div class="font_normal31" style="text-align:right;margin-top:27px;">{value}</div>',
						//'<div class="font_normal11 legendLabel d_m_t20" style="text-align:center">{footer}</div>',
						//'</div></td>',
						'<td  style="text-align:center;vertical-align:middle"><div style="height:130px;width:110px;text-align:center;margin: 0px 0px 0px 0px;"  id="uniquesessions-graph"></div></td>',
						'<td style="text-align:left;vertical-align:middle;width:50%">',
						'<div class="sessions_legends">',
						'<table style="width:100%;margin:20px 0px 0px 0px;border:0px solid indigo !important" >',
						'<tpl for="sessions">',
							'<tpl if="text !=&quot;&quot;">',
								'<tr style="width:100%;border:0px solid blue" >',
								'<td class="font_normal11 max-col" style="text-align:left;vertical-align:middle" data-qtip="{text} ({y})">',
								'<img onclick=\'javascript:showDDPopup("{dd_url}") \'  data-qclass="yellowTip" style="vertical-align:sub;margin:0px 4px;" src="/final/images/clear.png" class="{name} iconSeries" />{text} </td><td class="font_normal11" style="vertical-align: bottom;">({y})</td></tr>',
							'</tpl>',
						'</tpl>',
						'</table>',
						'</div></td></tr></table>',
					//'</div>',
				'</div>',
				'</tpl>'
			);
			/*var uniqueSessionsTpl = new Ext.XTemplate(
				'<div class="widgetholders">',
				'<tpl for=".">',
				'<div class="s_box">',
				'<div class="font_bold12 div_center" style="float:left;width:60%"><img style="position: absolute;top: 0;bottom: 0;margin: auto;" src="/final/images/clear.png" class="stateSymbol_{state}" /><span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:20px;padding-top:2px;" data-qtip="{heading}">{heading}</span></div>',
				'<div style="float:right;text-align:right;padding-right:10px" class="div_center"><div><span class="font_bold20"  style="line-height:20px"><a style="border:0px solid green !important;" href="javascript:void(0);" onclick=\'javascript:showDDPopup("{dd_url}") \' >{value}</a></span><span class="font_normal10 trim_text" style="text-transform:lowercase;text-align:right;width:20%"> {legend}</span></div></div>',
				'<div style="clear:both"></div>',
				'</div>',
				'<div class="b_box ">',
				'<div class="font_bold12 trim_text"><img style="vertical-align:sub" src="/final/images/clear.png" class="stateSymbol_{state}" /> <span data-qtip="{heading}">{heading}</ span></div>',
				'<div>',
				'<div style="width:50%;float:left">',
				'<div class="font_normal31" style="margin-top:24px;text-align:right"><a style="border:0px solid green !important;" href="javascript:void(0);" onclick=\'javascript:showDDPopup("{dd_url}")\'>{value}</a></div>',
				//'<div class="font_normal11 legendLabel" style="text-align:right">{legend}</div>',
				'</div>',
				'<div  style="text-align:center;width:60px;height:60px;float:left" id="uniquesessions-graph"></div>',
				'<div style="clear:both"></div>',
				'</div>',
				'<div class="sessions_legends">',
				'<tpl for="sessions">',
				'<span><img href="javascript:void(0);" onclick=\'javascript:showDDPopup("{dd_url}") \' data-qtip="{value}" data-qclass="yellowTip" style="vertical-align:sub" src="/final/images/clear.png" class="{name} iconSeries" />{text} ({value})</span>',
				'</tpl>',
				'</div>',
				'</div>',
				'</tpl>',
				'</div>'
			);*/
			var uniqueSessionWidg = this.getUniqueSessionPanel(this.data,this,uniqueSessionsTpl);
			this.add(uniqueSessionWidg);

		}

	},
	getUniqueSessionPanel:function(data1,thisObje,tplUS){
		var item =
		{
			xtype: 'dataview',
				padding:'5 5 5 10',
			id:'dataview_'+this.id,
			store: Ext.create('Ext.data.Store', {
				 id: 'UniqueSessions_model_id',
				model: 'UniqueSessionsModel',
				autoLoad:true,
				data:data1
			}),
			tpl: tplUS,
			listeners:{
				viewready:function(x){
					var me = this;
					$('#uniquesessions-graph').highcharts(getUniqueSessionWidgPanelJson(data1));
				}
			}

		}
		return item;

	},
    items: []
});


function getUniqueSessionWidgPanelJson(dataforGraph){
	var value = dataforGraph.value;
	var datarray = dataforGraph.sessions;
	var greyDonutNeeded = true;
	if(strRumSkin == "Dark")
		var borderColor = '#404040';
	else
		var borderColor = '#fff';
	try
	{
		for(var y=0;y<datarray.length;y++){
			if(!Ext.isEmpty(datarray[y].value) && datarray[y].value.trim() != "-"){
				greyDonutNeeded = false;
				break;
			}			
		}	
	}
	catch (ert)
	{
		greyDonutNeeded = false;	
	}
	
	if(greyDonutNeeded){
		borderColor = null;
		if(strRumSkin == "Dark")
			datarray = [{'name':'dummy','color':'#6a6a6a','y':1}];
		else
			datarray = [{'name':'dummy','color':'#e3e3e3','y':1}];
	}

	var jsonData = {
		chart: {
			type: 'pie',
			marginTop: 29,
			spacing:[10, 10, 10, 10],
			width: null,
			height: null,
			backgroundColor: null
		},
		tooltip: {
			enabled: false
		},
		title: {
			useHTML:true,
			text:'<a style="margin-left:-2px;margin-top:-3px;display:block;" class="ctxMouse">'+value+'</a>',
			offset: '',
			margin: 0,
			y:18,
			style:
			{
				textAlign:'center',
				//color:barStyleAttrbs['capFontClr'],
				fontFamily:'Arial',
				fontSize:'22px',
				//letterSpacing:'-0.13em'
			},
			verticalAlign: 'middle',
			floating: true,
			zIndex:'-10000'
		},
		exporting: {
			enabled: false
		},
		credits: {
			enabled: false
		},
		plotOptions: {
			pie: {
				borderColor: borderColor,
				borderWidth: 1,
				size: "150%",
				allowPointSelect: false,
				cursor: "",
				innerSize: "70%",
				dataLabels: {
					softConnector: false,
					enabled: false,
					distance: 7,
					style: {
						fontSize: "11px",
						textOutline: false,
						textShadow: false
					}
				},
				showInLegend: false,
				tooltip: {
					valueDecimals: 4,
					pointFormat: '<span style=\color:{point.color}\>{point.y}</span>' 
				},
				point: {
					events: {}
				}
			},
			series: {
				shadow: false,
				stacking: "normal",
				groupPadding: 0.2,
				pointPadding: 0.4,
				dataLabels: {
					enabled: false,
					inside: false,
					textOutline: false,
					textShadow: false
				},
				states: {
					hover: {
						enabled: true,
						halo: {
							size: 4
						}
					}
				},
				minPointLength: 0,
				cursor: "",
				point: {
					events: {}
				}
			}
		},
		series: [{
			data: datarray
		}]
	}
	//jsonData= jQuery.extend(true,jsonData,getUserThemeFor(strSkin));
	return jsonData;
};