Ext.define('RumAppFlow.view.UriBox', {
    extend: 'Ext.form.field.Trigger',
	//id:'uritriggerID',
	alias: ['widget.uribox'],
    width: 95,
	value:'All URLs',
	
	initComponent: function() {
        var me = this;
        me.callParent(arguments);
    },
	selectedURL:["All URLs"], // setting to default all
	setNumberURL:function(str,data){
		var me = this;
		var length = 0;
		if(!Ext.isEmpty(data) && data != undefined)
			length = data.length - 1;
		if(str == 0){
				me.setValue("All URLs");	
				me.selectedURL = ["All URLs"];
		}else{
			if(length != 0)
				me.setValue("URLs "+str+" of "+length);
		}
	},
	ui:'triggerbox',
	autoDestroy:true,
	labelSeparator:'',
	loadGrid:function(){
		var me = this;
		var grid = new Ext.create('Ext.grid.Panel', {
			selModel:{
				mode: 'MULTI'
			},
			border: true,
			autoDestroy:true,
			flex:1,
			ui:'gridURI',
			title:"",
			cls:'animation_box',
			id:me.id+'_grid',
			viewConfig:{
				overItemCls:'gridURI-over',
				//emptyText: '<div style="display:block;height:'+(Ext.getBody().getViewSize().height - 360)+';width:100%;position:relative" id="nodata"><div style="display:table-cell;vertical-align:middle;text-align:center;position:absolute;bottom:0;top:0;left:0;right:0;margin:auto;height:20px"><div style="margin:auto;" class="iconExclamation"></div><div>No Data Found!</div></div></div>',
				emptyText: '<div style="display:block;height:85%;width:100%;position:relative" id="nodata"><div style="display:table-cell;vertical-align:middle;text-align:center;position:absolute;bottom:0;top:0;left:0;right:0;margin:auto;height:20px"><div style="margin:auto;" class="iconInformation"></div><div>No Data Found!</div></div></div>',
				deferEmptyText: false,

			},
			hideHeaders: true, 
			tools:[
			{
				xtype:'toolbar',
				padding:'5 5 5 5',
				items:[
				{
					xtype:'trigger',
					width:215,
					style:{'float':'right'},
					fieldLabel:'',
					cls: 'whitedropdown_search',
					emptyText:'Search',
					id : 'searchBox',
					name : 'searchBox',					
					enableKeyEvents: true,
					listeners:{
						keyup: function(field,event){
							if(field == null || field == undefined || field.value == null || field.value == undefined)
								return;
							if(Ext.String.trim(field.value).length > 0 && (Ext.String.trim(field.value) != '' || Ext.String.trim(field.value) != null))
							{
								if(field.value == '*')
								{
									Ext.getCmp(me.id+'_grid').getStore().clearFilter();
								}
								else if(field.value == '(' || field.value == ')' || field.value == '\\' || field.value == '?' || field.value == '[')
								{
									Ext.MessageBox.show({
										title: 'Alert',
										msg: 'Please enter the valid search pattern',
										buttons: Ext.MessageBox.OK,
										icon: Ext.MessageBox.WARNING
									});
									Ext.getCmp(me.id+'_grid').getStore().clearFilter();
								}
								else
								{
									var regex = RegExp(field.value, 'i');
									var cGrid = Ext.getCmp(me.id+'_grid').getStore();
									cGrid.clearFilter(true);
									cGrid.filter(new Ext.util.Filter({
										caseSensitive:true,
										filterFn: function (object) {
											var match = false;
											Ext.Object.each(object.data, function (property, value) {

												match = match || regex.test(String(value));

											});

											return match;
										  }
									}));
								}
							}
							else{
								Ext.getCmp(me.id+'_grid').getStore().clearFilter();			
							}
							field.focus();
						}
					}
				}
				]
			}
			],
			listeners:{
				viewready:function(cmp){
					var cmp = this,
					grid = Ext.getCmp(me.id+'_grid'),
					selection = grid.getSelectionModel().getSelection();
					records = Ext.Array.filter(grid.store.data.items,
					function(rec) {
						/*
						* @me.selectedURL default to index of 1
						* @me.selectedURL updating the array in apply button
						*/
						return me.selectedURL.indexOf(''+rec.get('url')) !== -1;
					});
					grid.getSelectionModel().select(records);
		
				}
			},
			columns: [{
				dataIndex:'url',	
				flex:1,
				sortable: false, 
				menuDisabled: true 
			}],    
			store: new Ext.create('Ext.data.Store', {
				fields:[{name:'url',type:String}],
				data:me.data
			})
		});
		return grid;
	},
	setSelection:function(selection){
		return selection;
	},
	getSelection:function(){
		var me = this;
		return me.setSelection();
	},
	onTriggerClick:function(){
		var me = this;			
		var windowEl= 	Ext.create('Ext.window.Window', {
			title: 'Select URLS',
			autoDestroy:true,
			closeAction:'destroy',
			layout:{
					type:'vbox',
					align:'stretch',
					pack:'center'
				 },
			selected :[],
			tempSelect:null,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				padding:'10 0',
				ui:'footer',
				items: [
				'->',
				{
					xtype: 'button', 
					cls:'button20',
					padding:'0 10',
					text: 'Apply',
					handler: function () {
						// getting the selection from the grid
						var selection = Ext.getCmp(me.id+'_grid').getSelectionModel().getSelection();
						me.selection = selection;
						var expandedLayout = false;
						if(!Ext.isEmpty(me.expandedL) && me.expandedL != undefined && me.expandedL != null && me.expandedL)
							expandedLayout = true;

						if(expandedLayout){							
							if(requestParams.selectedTab=='page_views')
								RumAppFlow.app.getController("Main").doPageViewAction(me);
							else
								RumAppFlow.app.getController("Main").changeTopologyEx(me);	
						}else{
							if(requestParams.selectedTab=='page_views')
								RumAppFlow.app.getController("Main").doPageViewAction(me);
							else
								RumAppFlow.app.getController("Main").changeTopology(me);
						}

						//Ext.destroy(windowEl);
						windowEl.close();
					}
				},
				'->'
				]
			}],
			height: 335,
			width: 260,
			layout: 'fit',
			modal:true,
			bodyPadding:'0 10 0 10',
			resizable:false,
			ui:'eg-new-window',
			ghost:false,
			items:[me.loadGrid()],		
			listeners: {
				show: function(win) {
					if (this.modal) {
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.get(dom[0]);
						el.addCls('windowModal');
					}
				},
				hide:  function(win) {
					if (this.modal) {
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.get(dom[0]);
						el.removeCls('windowModal');
					}
				}
			}
		}).show();		
	}
});
