
Ext.define("RumRequestFlow.view.AdditionalResourceDetails", {
	extend: "Ext.form.Panel",
	alias: "widget.additionalResourceDetails",
	id: "additionalResourceDetails",
	flex:1,
	layout:
	{
		type: 'vbox',
		align: 'stretch'
	},
	ard:null,
	items: [],
	listeners:
	{
		'afterrender':function()
		{
			mappingNameData = data.rumTopology.mappingName_Info;
			if(this.ard != null)
			{
				try
				{
					var index = this.ard.S_No;
					var r_n = this.ard['Resource_Name'];
					var r_t = this.ard['Resource_Time'];
					var a_w_t = this.ard['actual_work_time'];
					var b_w_t = this.ard['total_block_wait_time'];
					var detailsArray = this.ard['detailsArray'];

					Ext.create('Ext.data.Store', {
						storeId: 'additionalResourceDetailsStore',
						fields: ['details','duration'],
						data: detailsArray
					});
					
					if(a_w_t  == 'Not Applicable' || a_w_t == 'Not Available')
						a_w_t = 'N/A';
					if(b_w_t  == 'Not Applicable' || b_w_t == 'Not Available')
						b_w_t = 'N/A';

					this.add(
					{
						xtype:'container',
						ui:'simpleContainer',
						layout:'hbox',
						height:95,
						border:true,
						padding:'10 10 20 10',
						margin:'0 2 15 0',		
						items:[{
							xtype:'container',
							width:300,
							baseCls:'resourceHighlight',
							height:73,
							id:'resHigh',
							padding:'15 0 0 0',
							listeners:{
								'resize':function(cont){	
										var winW;
										if (screen.width<=1366)
										{
											winW=Ext.getBody().getViewSize().width-650;
											r_n_el = Ext.util.Format.ellipsis(r_n, 50);
										}
										if (screen.width>1366)
										{
											winW=Ext.getBody().getViewSize().width-1350;
											r_n_el = Ext.util.Format.ellipsis(r_n, 80);
										}
										cont.setWidth(winW);		
										cont.update('<table align="center"><tr><td colspan="3" class="f14-bold" style="text-align:center;padding-bottom:10px">'+mappingNameData['RESOURCE_NAME']+'</td></tr><tr><td class="f13-normal" style="text-align:center;">#'+index+'</td><td>&nbsp;&nbsp;<span class="rum_splitter" style="width:2px;height:15px">&nbsp;</span>&nbsp;</td><td data-qclass="yellowTip" data-qtip="'+r_n+'">'+r_n_el+'</td></tr></table>')
								}
							}
						},{
							xtype:'container',
							ui:'newPlainPanel',
							flex:0.23,
							cls:'rumPlainPanelDivider',
							height:73,
							html:'<table align="center"><tr><td colspan="2" class="f14-bold" style="text-align:center;padding-bottom:15px">'+mappingNameData['DURATION']+'<span class="f12-bold">&nbsp;('+mappingNameData['MILLISEC']+')</span></td></tr><tr><td style="text-align:center"><span><img class="icon_Rum_Duration" src="/final/images/clear.png"></span><span class="f28-light" style="padding-left:10px;top:-6px;position:relative">'+r_t+'</span></td></tr></table>',
						},{
							xtype:'container',
							ui:'newPlainPanel',
							flex:0.23,
							cls:'rumPlainPanelDivider',
							height:73,
							html:'<table align="center"><tr><td class="f14-bold" style="text-align:center;padding-bottom:15px">'+mappingNameData['ACTUAL_WORK_TIME']+'<span class="f12-bold">&nbsp;('+mappingNameData['MILLISEC']+')</span></td></tr><tr><td style="text-align:center"><span><img class="icon_Rum_Worktime" src="/final/images/clear.png"></span><span class="f28-light" style="padding-left:10px;top:-6px;position:relative">'+a_w_t+'</span></td></tr></table>',
						},{
							xtype:'container',
							ui:'newPlainPanel',
							cls:'rumPlainPanelDivider',
							flex:0.23,
							cls:'center',
							height:73,
							html:'<table align="center"><tr><td colspan="2" class="f14-bold" style="text-align:center;padding-bottom:15px">'+mappingNameData['BLOCk_WAIT_TIME']+'<span class="f12-bold">&nbsp;('+mappingNameData['MILLISEC']+')</span></td></tr><tr><td style="text-align:center"><span><img class="icon_Rum_PageLoadtime" src="/final/images/clear.png"></span><span class="f28-light" style="padding-left:10px;top:-6px;position:relative">'+b_w_t+'</span></td></tr></table>',
						}]
					
					},
					{
						xtype: 'grid',
						autoScroll : true,
						scroll : true,
						height: 350,
						ui:'newGridPanel',
						title: '<span class="f15-bold">'+mappingNameData['BROWSER_NAVIGATION_FLOW']+'</span>',
						store: Ext.data.StoreManager.lookup('additionalResourceDetailsStore'),
						listeners:{
							'resize':function(gpanel){
								var width = Ext.getBody().getViewSize().width - 40;
								var height = Ext.getBody().getViewSize().height - 215;

								gpanel.setSize(width, height);
							}
						},
						columns: [{
							text: '<span style="text-transform: uppercase">'+mappingNameData['SPLIT_OF_DURATION']+'</span>',
							dataIndex: 'details',
							flex: 0.6
						},
						{
							text: '<span style="text-transform: uppercase">'+mappingNameData['DURATION']+'</span><span style="text-transform: lowercase">&nbsp;('+mappingNameData['MILLISEC']+')</span>',
							dataIndex: 'duration',
							flex: 0.2
						},
						{
							text: '<span style="text-transform: uppercase">'+mappingNameData['PERCENTAGE_TIME_SPLIT']+'</span>',
							dataIndex: 'duration',
							width:510,
							renderer: function(value, metaData, record, row, col, store, gridView){
								var succeedPercentage = 0;
								succeedPercentage = (value/r_t)*100;
								succeedPercentage = Math.round(succeedPercentage);
								if(value  == 'Not Applicable' || value == 0 || value == 'Not Available' || !succeedPercentage)
								{
									succeedPercentage = 0;
									value ="<table><tbody><tr><td><table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" height=\"6\" class=\"prog_border\" style=\"width:435px\"><tbody><tr><td align=\"left\" width=\"100%\" height=\"6\" class=\"prog_line\"><table width=\""+succeedPercentage+"%\" height=\"6\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td class=\"progress_GOOD\" width=\"100%\"></td></tr></tbody></table></td></tr></tbody></table></td><td><table width=\"60\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td class='f11-normal' style=\"text-align:center\">&nbsp;&nbsp;-</td></tr></tbody></table></td></tr></tbody></table>";

								}
								else
								{
									value ="<table><tbody><tr><td><table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" height=\"6\" class=\"prog_border\" style=\"width:435px\"><tbody><tr><td align=\"left\" width=\"100%\" height=\"6\" class=\"prog_line\"><table width=\""+succeedPercentage+"%\" height=\"6\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td class=\"progress_GOOD\" width=\"100%\"></td></tr></tbody></table></td></tr></tbody></table></td><td><table width=\"60\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td class='f11-normal' style=\"text-align:center\">&nbsp;&nbsp;"+succeedPercentage+"<span class='f9-normal'>%</span></td></tr></tbody></table></td></tr></tbody></table>";
								}
								return value;
							},
						}]
					});
				}
				catch (e)
				{
				}

				
			}
			
		}
	}
});

