
Ext.create('Ext.data.Store', {
    storeId:'resourceDetailsStore1',
    fields:['resources', 'domain', 'type', 'duration'],
    data:{'items':[
        { 'resources': '/citrix-eg.png',  "domain":"www.eginnovations.com", "type":"img.jpg", "duration":"5709"  },
        { 'resources': '/webinar.png',  "domain":"www.eginnovations.com/webinar", "type":"img.png", "duration":"5549" },
        { 'resources': '/white-paper.png', "domain":"www.eginnovations.com/white-paper", "type":"img.jpg", "duration":"5410" },
        { 'resources': '/java-app.jpg', "domain":"www.eginnovations.com/close.jpg", "type":"img.png", "duration":"5345"  }
    ]},
    proxy: {
        type: 'memory',
        reader: {
            type: 'json',
            root: 'items'
        }
    }
});


Ext.create('Ext.data.Store', {
	 storeId: 'resourceDetailsStore',
	 fields: ['S_No','Resource_Name', 'Resource_Domain', 'Resource_Type', 'content_time','Resource_Time','actual_work_time','total_block_wait_time','transfer_size','detailsArray','Resource_offset'],
	data: data.gridData
});

var imageTpl = new Ext.XTemplate(
    '<tpl for=".">',
        '<div style="margin-bottom: 10px;" class="thumb-wrap">',
          '<span>Title</span>',
        '</div>',
    '</tpl>'
);

Ext.define("RumRequestFlow.view.ResourceDetails", {
	extend: "Ext.form.Panel",
	alias: "widget.resourceDetails",
	id: "resourceDetails",
	//cls:'outerpanel',
	flex:1,
	//margin:'8 8 0 8',
	//title:"Resource Details",
	requires: [
		'utilities.ScrollCombo'
	],
	//header:{cls:'textUpper'},
	layout:
	{
		type: 'vbox',
		align: 'stretch'
	},
	items: [],
	listeners:
	{
		'afterrender':function()
		{
			var url = data.rumTopology.header_Info.URL,
			urlRquestDataTime = data.rumTopology.header_Info.REQUEST_DATE,
			urlZone = data.rumTopology.header_Info.REQUEST_TIME_ZONE,
			userDataCountry = data.rumTopology.user_Info.COUNTRY,
			userDataOs = data.rumTopology.user_Info.OS,
			userDataIp = data.rumTopology.user_Info.IP,
			userDataCity = data.rumTopology.user_Info.CITY,
			mappingNameData = data.rumTopology.mappingName_Info,
			RESOURCE_DETAILS_NOT_FOUND = data.resourceText.RESOURCE_DETAILS_NOT_FOUND;
			var plt = data.rumTopology.user_Info.PAGE_LOAD_TIME;
			var dclt = data.rumTopology.user_Info.DOCUMENT_CONTENT_LOADED;
			
			var stringCountyText = "";
			if(userDataCity != null && userDataCity.toLowerCase() != "unknown")
				stringCountyText = " , from "+userDataCity;
			if(userDataCity != null && userDataCity.toLowerCase() != "unknown")
				stringCountyText+= ", "+userDataCountry+" ";

			var nodataPanel = false;
			try
			{
				if(Ext.isEmpty(data.gridData) || data.gridData.length == 0)
					nodataPanel = true;
			}
			catch (e)
			{
				nodataPanel = true;
			}
			
			if(nodataPanel)
			{
				this.add({
					xtype:'dataview',
					bodyPadding: '0 10',
					tpl: [
					'<div class="" style="margin-top:8px; margin-bottom:20px;">',
						'<div style="text-align:center;margin-top:20%">',
							'<div class="iconInformation" style="margin:0px auto"></div>',
							'<div> '+RESOURCE_DETAILS_NOT_FOUND+' </div>',
						'</div>',
					'</div>',	
					],
				});
			}
			else
			{
				var totalTransferSize = data.resourceSize.totalTransferSize;

				var totalTransferSize_unit= totalTransferSize.substring(totalTransferSize.indexOf(" ")+1);
				totalTransferSize= totalTransferSize.substring(0,totalTransferSize.indexOf(" "));
				this.add({
					xtype:'dataview',
					bodyPadding: '0 10',
					tpl: [
					'<div  style="text-align:center;margin-top:8px; margin-bottom:20px;">',
						'<div class="f15-bold" style="position:static; margin-top:0px;">',
							'<span class="outerBg">',
							'<span >'+mappingNameData['RESOURCE_DOWNLOAD']+' </span>',
							'<span class="f15-normal">'+trimString(url,50,50)+'</span>',
							'<span class="f15-bold"> '+mappingNameData['ON']+'&nbsp;</span><span class="f15-normal">'+urlRquestDataTime+'&nbsp;'+urlZone+'</span><span>',
						'</div>',
						'<div class="f13-normal" style="text-align:center; line-height:19px; margin-top:10px">',
						'<span><span class="f13-bold">'+mappingNameData['CLIENT_INFORMATION']+': </span> Using '+userDataOs+' with IP '+userDataIp+'',
						' '+stringCountyText+' </span>',
						'</div>',
					'</div>',	
					],
				},
				{
					xtype:'container',
					ui:'simpleContainer',
					height:104,
					layout:{type:'hbox',align:'stretch'},
					border:true,
					padding:'15 0 15 0',
					margin:'0 2 20 2',					
					items:[
						{
							xtype:'container',
							ui:'newPlainPanel',
							cls:'rumPlainPanelDivider',
							flex:0.25,
							height:75,
							header:false,
							//header:{cls:'f14-bold'},
							//title: 'Requests',
							html:'<table align="center"><tr><td class="f14-bold" style="text-align:center;padding-bottom:15px">'+mappingNameData['REQUESTS']+'</td></tr><tr><td style="text-align:center"><span><img class="icon_Rum_Requests" src="/final/images/clear.png"></span><span class="f28-light" style="padding-left:10px;top:-6px;position:relative">'+data.gridData.length+'</span></td></tr></table>',
							//html:'<div style="text-align:center;"><img class="icon_Rum_Requests" src="/final/images/clear.png"><span class="f28-normal">'+data.gridData.length+'</span></div>',
						},
						{
							xtype:'container',
							ui:'newPlainPanel',
							cls:'rumPlainPanelDivider',
							flex:0.25,
							height:75,
							header:false,
							//title: 'Transferred',
							html:'<table align="center"><tr><td class="f14-bold" style="text-align:center;padding-bottom:15px">'+mappingNameData['TRANSFERRED']+'</td></tr><tr><td style="text-align:center"><span><img class="icon_Rum_Transferred" src="/final/images/clear.png"></span><span class="f28-light" style="padding-left:10px;top:-6px;position:relative">'+totalTransferSize+'&nbsp;<span class="f15-normal">'+totalTransferSize_unit+'</span></span></td></tr></table>',
							//html:'<div style="text-align:center;"><img class="icon_Rum_Transferred" src="/final/images/clear.png"><span style="font-weight:normal !important;" class="f28-normal">'+totalTransferSize+'</span></div>'
						},
						{
							xtype:'container',
							ui:'newPlainPanel',
							cls:'rumPlainPanelDivider',
							flex:0.25,
							height:75,
							header:false,
							//titleAlign:'center',
							//title: 'Document Content Loaded',
							html:'<table align="center"><tr><td class="f14-bold" style="text-align:center;padding-bottom:15px">'+mappingNameData['DOCUMENT_CONTENT_LOADED']+'</td></tr><tr><td style="text-align:center"><span><img class="icon_Rum_Document" src="/final/images/clear.png"></span><span class="f28-light" style="padding-left:10px;top:-3px;position:relative">'+dclt+'&nbsp;<span class="f15-normal">'+mappingNameData['MILLISEC']+'</span></span></td></tr></table>',
							//html:'<div style="text-align:center;"><img class="icon_Rum_Document" src="/final/images/clear.png"><span style="font-weight:normal !important;" class="f28-normal">'+dclt+'</span></div>'
						},
						{
							xtype:'container',
							ui:'newPlainPanel',
							flex:0.25,
							height:75,
							header:false,
							//titleAlign:'center',
							//title: 'Page Load Time',
							html:'<table align="center"><tr><td class="f14-bold" style="text-align:center;padding-bottom:15px">'+mappingNameData['PAGE_LOAD_TIME']+'</td></tr><tr><td style="text-align:center"><span><img class="icon_Rum_PageLoadtime" src="/final/images/clear.png"></span><span class="f28-light" style="padding-left:10px;top:-6px;position:relative">'+plt+'&nbsp;<span class="f15-normal">'+mappingNameData['MILLISEC']+'</span></span></td></tr></table>',
							//html:'<div style="text-align:center;"><img class="icon_Rum_PageLoadtime" src="/final/images/clear.png"><span style="font-weight:normal !important;" class="f28-normal">'+plt+'</span></div>'
						}
					]
				},
				{
					xtype: 'grid',
					//cls:'gridSkin',
					autoScroll : true,
					scroll : true,
					height: 350,
					ui:'newGridPanel',
					//title: 'ResourceDetailsStore',
					store: Ext.data.StoreManager.lookup('resourceDetailsStore'),
					listeners:{
						'resize':function(gpanel){
							var width = Ext.getBody().getViewSize().width - 40;
							var height = Ext.getBody().getViewSize().height - 306;

							gpanel.setSize(width, height);
						}
					},
					columns: [{
						text: '<span style="text-transform: uppercase">#</span>',
						dataIndex: 'S_No',
						width:40
					},{
						text: '<span style="text-transform: uppercase">'+mappingNameData['RESOURCES']+'</span>',
						dataIndex: 'Resource_Name',
						flex: 1.5,
						renderer: function(value, metaData, record, row, col, store, gridView,idx){
							value = "<span class='mouse'> <img class='iconDiagnosis' src='/final/images/clear.png' style='vertical-align:middle;margin:0 5px'> </span> <span class='f16 mouse' data-qclass='yellowTip' data-qtip='"+value+"'>"+value+"</span>";
							return value;

							 
						},
						listeners:{
							'click':function(grid, rowIndex, columnIndex, e){
								try
								{
									var row_data = grid.getStore().getAt(columnIndex).getData();
									Ext.getCmp('resourceDetails').hide();
									var r_tab = Ext.getCmp('resourceTab');
									r_tab.add({
										xtype:'additionalResourceDetails',
										ard:row_data
									});
									Ext.getCmp('rumbackbt').setVisible(true);
								}
								catch (e)
								{
								}
							}
						}
						
					},{
						text: '<span style="text-transform: uppercase">'+mappingNameData['DOMAIN']+'</span>',
						dataIndex: 'Resource_Domain',
						flex: 0.4
					},{
						text: '<span style="text-transform: uppercase">'+mappingNameData['TYPE']+'</span>',
						dataIndex: 'Resource_Type',
						flex: 0.4
					}, {
						text: '<span style="text-transform: uppercase">'+mappingNameData['RELATIVE_START_TIME']+'</span><span style="text-transform: lowercase">&nbsp;('+mappingNameData['MILLISEC']+')</span>',
						flex: 0.6,
						dataIndex: 'Resource_offset'
					}, {
						text: '<span style="text-transform: uppercase">'+mappingNameData['DURATION']+'</span><span style="text-transform: lowercase"><br>('+mappingNameData['MILLISEC']+')</span>',
						flex: 0.4,
						dataIndex: 'Resource_Time'
					},
					{
						text: '<span style="text-transform: uppercase">'+mappingNameData['SPLIT_OF_DURATION']+'</span><span style="text-transform: lowercase">&nbsp;('+mappingNameData['MILLISEC']+')</span>',
						flex:0.7,
						columns: [{
							text: '<span style="text-transform: uppercase">'+mappingNameData['ACTUAL_WORK']+'</span>',
							dataIndex: 'actual_work_time'
						}, {
							text: '<span style="text-transform: uppercase">'+mappingNameData['BLOCK_WAIT']+'</span>',
							dataIndex: 'total_block_wait_time'
						}]
					},
					{
						text: '<span style="text-transform: uppercase">'+mappingNameData['TRANSFER_SIZE']+'</span>',
						flex: 0.3,
						dataIndex: 'transfer_size'
					}]			
				});
			}
		}
	}
});



