Ext.define('SAPMetric.view.Main',{
	extend:'utilities.OuterPanel',
	alias:'widget.main',
	scroll:false,
	autoScroll:false,
	cls:'outerpanel',
	title:'SAP METRIC',
	layout:{
			type:'vbox',
			align:'stretch'
		},
	//style:{'border':'1px solid yellow'},
	requires:['Ext.ux.form.MultiSelect','utilities.TimeLine','utilities.ScrollCombo','Ext.selection.CheckboxModel','utilities.Settings','utilities.EmptyPanel','utilities.DefaultPanel'],
	items:[],
	initComponent:function(){
		var me = this;
		me.addListener('afterrender',me.resizeWindow,me);
		me.callParent();
		/*var alert_win = {
		
		bodyPadding:0,
		layout:{
			type:'vbox',
			align:'stretch'
		},
	};*/
		treeData ={
				xtype:'outerPanel',
				title:treePanelLabel,
				cls:'dataPanel',
				id:'treepanel',
				scroll:false,
				//height:315,
				flex:1.0,
				autoScroll:true,
				border:false,
				frame:true,
				//style:{'border':'1px solid red'},
				margin:'0 10 10 10',
				layout: {
					type: 'hbox',
					align: 'stretch', 
					//pack  : 'start'
				},
				items:[{
					xtype:'panel',
					id:'default',					
					layout:{
					type:'vbox',
					align:'center'
					},					
					border:false,
					hidden:false,
					scroll:false,
					autoScroll:false,
					flex:1.0,
					html:'<table width="100%"><tr><td align="center" valign="middle"><div class="iconInformation" style="margin:12% auto 0% auto"></div><div class="font_normal12">Please choose required parameters for performance attributes tree<div></td></tr></table>',
				},{
					xtype:'panel',
					flex:1.0,
					hidden:true,
					id:'treeDD',
					itemId:'treeDD'
				}]
			};
	mainForm = {
		bodyPadding:5,
		//margin:'0 0 5 0',
		margin:10,
		buttonAlign:'center',
		cls:'formOuter',
		//layout:'anchor',
		height:'auto',
		 //style:{'border':'1px solid blue'},
		items:[
			{
				xtype:'fieldcontainer',
				columnWidth:1,
				layout:'column',
				defaults:{
					labelAlign:'top',
					labelSeparator:'',
					margin:'1 15 5 5'
				},
				items:[{
						xtype:'scrollcombo',
						cls:'dropdown',
						name:'compName',
						id:'compName',
						editable:false,
						fieldLabel:componentLabel,
						displayField:'displayField',
						queryMode:'local',
						store:Ext.create('Ext.data.Store',{
							fields:['displayField','valueField'],
							data:componentsListObject,
						}),
						listeners:{
							change:this.comboChange,
							afterrender:function(combo){
								var value = combo.getStore().first();
								combo.setValue(value);
							}
						}
					},{
						fieldLabel:monitorSetValue,
						xtype:'scrollcombo',
						width:240,
						editable:false,
						name:'Monitorset_value',
						id:'Monitorset_value',
						cls:'dropdown',
						displayField:'displayField',
						valueField:'valueField',
						queryMode:'local',
						store:Ext.create('Ext.data.Store',{
							fields:['displayField','valueField'],
							data:monitorSetListData,
						}),
						listeners:{
							change:this.comboChange,
							afterrender:function(combo){
								var value = combo.getStore().first();
								combo.setValue(value);
							}
						}
					},{
						xtype:'container',
						items:[{
							xtype:'label',
							text:monitorsValue,
							margin:'0 0 5 0'
						},{
							xtype:'multiselect',
							name:'Monitors_sel',
							id:'Monitors_sel',
							width:250,
							margin:'5 0 5 0',
							displayField:'displayField',
							valueField:'valueField',
							queryMode:'local',
							store:Ext.create('Ext.data.Store',{
								fields:['displayField','valueField'],
								data:monitorSetListValues,
							}),
							height:70,
							listeners:{
								change:this.comboChange,
								afterrender:function(combo){
								var value = combo.getStore().first();
								combo.setValue(value);
							 }
							}
						}]
					},
					{
					xtype:'button',
					margin:'22 10 5 5',
					text:submitButton,
					cls:'button20',					
					handler:this.comboChange
					}]
				}
				
			]/* ,
			dockedItems:[
						{				
						xtype:'toolbar',
						dock:'bottom',
						style:{'background-color':'#F7F7F7'},
						layout:{
							type:'hbox',
							align:'stretch',
							pack:'center'
						},
						items:[
						{
								text:submitButton,
								cls:'button20',
								margin:'0 0 0 0',
								handler:this.comboChange
							}
						]
						}
					] */
				
			/*buttons:[
				{
					text:'Submit',
					cls:'button20',
					margin:'0 0 0 0',
					handler:this.comboChange
				}
			]*/
		};
		me.add(mainForm);
		me.add(treeData);
	},
	resizeWindow:function(){
			var dataID=Ext.getCmp('treepanel');
			Ext.EventManager.onWindowResize(function () {
			var width = Ext.getBody().getViewSize().width - 160;
			var height = Ext.getBody().getViewSize().height - 225;
			dataID.setSize(width, height);
		});
	},
	comboChange:function(combo,newValue,oldValue,opts){
		var me = this;
		var url;

		if(combo.id == 'compName'){
			url = '/final/monitor/egSAPAlarmPro.jsp?fromSelect=comp&compName='+newValue;
		}
		else if(combo.id == 'Monitorset_value'){
			url = '/final/monitor/egSAPAlarmPro.jsp?fromSelect=Monitorset&Monitorset_value='+newValue+'&compName='+Ext.getCmp('compName').value;
		}
		else if(combo.xtype == 'button'){
			
			var multiselectValue = Ext.getCmp('Monitors_sel').getValue();
				if(Ext.getCmp('compName').value == defaultComp){
					Ext.Msg.show({
						 title:'Alert',
						 msg: 'Please choose a component',
						 buttons: Ext.Msg.OK,
						 icon: Ext.Msg.WARNING
					});
					return false;
				}
				else if(Ext.getCmp('Monitorset_value').value == -1){
					Ext.Msg.show({
						 title:'Alert',
						 msg: 'Please choose a Monitor set',
						 buttons: Ext.Msg.OK,
						 icon: Ext.Msg.WARNING
					});
					return false;
				}
				else if(Ext.isEmpty(multiselectValue)){
						Ext.Msg.show({
						 title:'Alert',
						 msg: 'Please choose a one or more monitors',
						 buttons: Ext.Msg.OK,
						 icon: Ext.Msg.WARNING
					});
					return false;
				}
			Ext.getCmp('treepanel').setLoading(true,true);
			url = '/final/monitor/egSAPAlarmPro.jsp?Monitorset_value='+Ext.getCmp('Monitorset_value').value+'&Monitors_sel='+multiselectValue+'&compName='+Ext.getCmp('compName').value+'&from_page=sap_metric';
		}
		else{
			return false;
		}

		//if(Ext.getCmp('compName').value > 0)
		if(!Ext.isEmpty(Ext.getCmp('compName')) && !Ext.isEmpty(Ext.getCmp('compName').value))
		{
			Ext.Ajax.request({
				url:url,
				success:function(response){
					var json = "";
					try
					{
						json = Ext.decode(response.responseText);
					}
					catch (ex)
					{
						window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
						self.close();
					}
					if(!Ext.isEmpty(json.filters.monitorSet)){
						var monSetStore = Ext.getCmp('Monitorset_value').getStore();
						monSetStore.loadRawData(json.filters.monitorSet);
						Ext.getCmp('Monitorset_value').setValue(-1);
					}
					if(!Ext.isEmpty(json.filters.monitorSelect)){
						var monSelStore = Ext.getCmp('Monitors_sel').getStore();
						monSelStore.removeAll();
						monSelStore.loadRawData(json.filters.monitorSelect);
					}
					if(!Ext.isEmpty(json.treeData)){
						var monTree = Ext.getCmp('treeDD');
						var defaultPanel=Ext.getCmp('default');

						if(!Ext.isEmpty(monTree))
						{
							monTree.addCls('treemenu');
							monTree.show();
							defaultPanel.hide();
							monTree.update(parseScript(json.treeData));
							Ext.getCmp('treepanel').setLoading(false);
						}
						else
						{
							monTree.hide();
							defaultPanel.show();
						}
					}
					else if(Ext.isEmpty(json.treeData))
					{
						var monTree = Ext.getCmp('treeDD');
						var defaultPanel=Ext.getCmp('default');

						if(!Ext.isEmpty(monTree))
							monTree.hide();
						if(!Ext.isEmpty(defaultPanel))
							defaultPanel.show();
					}

				}
				/*failure:function(){
					alert('Failure in SAPMetric');
				}*/
			});
		}
	}
});