Ext.define('SAPPlatform.controller.Main', {
    extend: 'Ext.app.Controller',
	requries:['SAPPlatform.view.Main','SAPPlatform.view.Availability','SAPPlatform.view.TrexSearchesperMinute', 'SAPPlatform.view.IndicesResourceUsage','SAPPlatform.view.InstanceThroughPut','SAPPlatform.view.JavaActiveTransanctions','SAPPlatform.view.DestinationsPercentageLoad','SAPPlatform.view.ProtocolConnectionsTimes', 'SAPPlatform.view.JavaAliases','SAPPlatform.view.JavaWatingTasks','SAPPlatform.view.HanaInstances','SAPPlatform.view.SwapMemoryBusyInstances','SAPPlatform.view.UsageServiceVsHost'],
    init: function() {
		setInterval("execute()",refreshFrequency);
		//setInterval("execute()",10000);
        this.control({
            "viewport": {
                'afterrender' : this.onPanelRendered
            },
			'main': {
				'afterrender' : this.hideMainMask
			}
        });
    },
	hideMainMask : function()
	{
		Ext.get('SapPlatformDashboardMask').remove();
	},
	refresh:function(currObj)
	{
		if(selectedAccordionBlock == null || Ext.isEmpty(selectedAccordionBlock) || selectedAccordionBlock == '')
		{
			selectedAccordionBlock='ABAPSystems';
		}

		var URLparams = 'action=loadSapPlatformDashboard&selectedBlock='+selectedAccordionBlock;
		if(selectedAccordionBlock != null && selectedAccordionBlock=='TREX_Instances')
		{
			var trexResUsage_combo = Ext.getCmp('trexResUsageCombo');
			var selectedResUsage = trexResUsage_combo.getValue();

			var trexThroughput_combo = Ext.getCmp('trexThroughputCombo');
			var selectedThroughput = trexThroughput_combo.getValue();
			
			URLparams +='&trexResUsageSortBy='+encodeURIComponent(selectedResUsage)+'&trexThroughputSortBy='+encodeURIComponent(selectedThroughput);

		}
		else if(selectedAccordionBlock != null && selectedAccordionBlock=='Java_Instances')
		{
			var watingTasks_combo = Ext.getCmp('watingTasks_Combo');
			var selectedWaitingTask = watingTasks_combo.getValue();

			URLparams +='&waitingTaskSortBy='+encodeURIComponent(selectedWaitingTask);
		}else if(selectedAccordionBlock != null && selectedAccordionBlock=='SAP_Hana')
		{
			var usageServicevsHost_combo = Ext.getCmp('usageServicevsHostCombo');
			var selectedUsage = usageServicevsHost_combo.getValue();

			URLparams +='&hanaResUsageSortBy='+encodeURIComponent(selectedUsage);
		}
		else if(selectedAccordionBlock != null && selectedAccordionBlock=='BO_Nodes')
		{
			var boenodeResource_Combo_Obj = Ext.getCmp('boenodeResource_Combo');
			var selectedResource = boenodeResource_Combo_Obj.getValue();
			URLparams +='&boeNodeResourceSortBy='+encodeURIComponent(selectedResource);
			
		}
		else if(selectedAccordionBlock != null && selectedAccordionBlock=='ABAPSystems')
		{
			var abapWorkProcess_Combo_Obj = Ext.getCmp('abapWorkProcess_Combo');
			var selectedResource = abapWorkProcess_Combo_Obj.getValue();
			URLparams +='&abapWorkProcessSortBy='+encodeURIComponent(selectedResource);
		}

		defaultSapPlatformDashboardParams="action=loadSapPlatformDashboard&selectedBlock="+selectedAccordionBlock+"&scrollPosition="+scrollPosition;
		
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.egSapPlaformDBController',
			scope: this,
			params :URLparams,
			method : 'POST',
			success: function(response)
			{
				var jsonData = Ext.decode(response.responseText);
				if(jsonData.errorMsg != '-'){					
					this.loadSAPDashBoard(jsonData);
				}
			}
		});
	},

    onPanelRendered: function() {

		this.loadSAPDashBoard(pubJson);		
	},
	
	loadSAPDashBoard:function(jsonData)
	{
		//-----------------FIRST-ROW-DATA-STARTS----------------------//
		var availability_Chart_Obj = Ext.getCmp('availability_Chart');
		availability_Chart_Obj.setChartData(jsonData['AvailabilityData']);
		
		if(!Ext.isEmpty(jsonData['KeyPerformanceIndicatorJson']))
		{
			var gridDataValues = jsonData['KeyPerformanceIndicatorJson'];
			var gridData = gridDataValues['gridData'];
		
			var throughputgrid = Ext.getCmp('throughput_grid');
			throughputgrid.getStore().removeAll();
			throughputgrid.store.loadData(gridData);
		}		

		var performance_Chart_Obj = Ext.getCmp('performance_Chart');
		performance_Chart_Obj.setChartData(jsonData['PerformanceAlertData']);

		//---*****************---FIRST-ROW-DATA-ENDS----*******************-----//

		//-----------------DefaultGrid-Load-STARTS---------------------//
		var gridDataValues1 = jsonData['defaultGridData'];
		var gridContainerId_Obj = Ext.getCmp('gridContainerId');
		Ext.suspendLayouts();
		gridContainerId_Obj.getStore().removeAll();
		gridContainerId_Obj.store.loadData(gridDataValues1);

		gridContainerId_Obj.loadChartData();
		Ext.resumeLayouts(true);


		//----*********-----END-OF-DefaultGrid-Load-----***********-----//

		/************************FOR ACCORDION BLOCK REFRESH*******************/

		if(selectedAccordionBlock==''){
			selectedAccordionBlock='ABAPSystems';
		}
		this.loadDataForCorrespondingAccordion(selectedAccordionBlock,jsonData);	

		/************************----------------------------*******************/

	},
			
	loadAccordionData:function(selectedView)
	{
		var mask = new Ext.LoadMask(Ext.getCmp('accordionBlock'), {msg:"Loading..."});
        	mask.show();
		var URLparams = "action=loadAccordionView&accordionPage="+encodeURIComponent(selectedView);
		
		if(selectedView != null && selectedView=='TREX_Instances')
		{
			var trexResUsage_combo = Ext.getCmp('trexResUsageCombo');
			var selectedResUsage = trexResUsage_combo.getValue();

			var trexThroughput_combo = Ext.getCmp('trexThroughputCombo');
			var selectedThroughput = trexThroughput_combo.getValue();

			URLparams +='&trexResUsageSortBy='+selectedResUsage+'&trexThroughputSortBy='+selectedThroughput;
		}
		else if(selectedView != null && selectedView=='Java_Instances')
		{
			var watingTasks_combo = Ext.getCmp('watingTasks_Combo');
			var selectedWaitingTask = watingTasks_combo.getValue();

			URLparams +='&waitingTaskSortBy='+encodeURIComponent(selectedWaitingTask);
		}
		else if(selectedView != null && selectedView=='SAP_Hana')
		{
			var usageServicevsHost_combo = Ext.getCmp('usageServicevsHostCombo');
			var selectedUsage = usageServicevsHost_combo.getValue();

			URLparams +='&hanaResUsageSortBy='+encodeURIComponent(selectedUsage);
			
		}
		else if(selectedView != null && selectedView=='BO_Nodes')
		{
			var boenodeResource_Combo_Obj = Ext.getCmp('boenodeResource_Combo');
			var selectedUsage = boenodeResource_Combo_Obj.getValue();
			URLparams +='&boeNodeResourceSortBy='+encodeURIComponent(selectedUsage);
			
		}
		defaultSapPlatformDashboardParams="action=loadSapPlatformDashboard&selectedBlock="+selectedView+"&scrollPosition="+scrollPosition;
		
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.egSapPlaformDBController',
			scope: this,
			params :URLparams,
			method : 'POST',
			success: function(response)
			{
				var jsonData = Ext.decode(response.responseText);
				if(jsonData.errorMsg != '-'){
					this.loadDataForCorrespondingAccordion(selectedView,jsonData);			
					if (mask != undefined) 
					{
						 mask.hide();
					}
				}
			}
		});
	},

	loadComboChangeEventData:function(accordionName,chartName,selectedCombo)
	{
		var URLparams = "action=comboChange&accordionName="+encodeURIComponent(accordionName)+"&chartName="+encodeURIComponent(chartName)+"&selectedCombo="+encodeURIComponent(selectedCombo);
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.egSapPlaformDBController',
			scope: this,
			params :URLparams,
			method : 'POST',
			success: function(response)
			{
				var jsonData = Ext.decode(response.responseText);
				if(jsonData.errorMsg != '-'){
					
					if(accordionName != null && accordionName=='TREX_Instances')
					{
						if(chartName != null && chartName=='indicesResourceUsage')
						{		
							var resourceUsageData = jsonData['TrexResourceUsageJsonData'];
							var gridData = resourceUsageData['gridData'];
							var gridColumns = resourceUsageData['gridColumns'];
							
							var resourceUsageGrid = Ext.getCmp('trexResourceUsageGrid');

							
							if(gridColumns!=null && !Ext.isEmpty(gridColumns))
							{
								var updatedColumn = gridColumns.Column_3;
							}

							Ext.each(Ext.getCmp('trexResourceUsageGrid').columns,function(d){
								if(d.dataIndex != null && d.dataIndex =='Column_3')
								{
									d.setText(updatedColumn);					
								}			
							}); 

							if(!Ext.isEmpty(gridData))
							{
								Ext.each(Ext.getCmp('trexResourceUsageGrid').columns,function(d){
									this.hidden =  false;
								}); 
								Ext.get('trexResourceUsageGrid').removeCls('hideBodyTopBorder');
								resourceUsageGrid.getStore().removeAll();
								resourceUsageGrid.store.loadData(gridData);
							}else{
								Ext.each(Ext.getCmp('trexResourceUsageGrid').columns,function(d){
									this.hidden =  true;
								}); 
								Ext.get('trexResourceUsageGrid').addCls('hideBodyTopBorder');
								resourceUsageGrid.getStore().removeAll();
								resourceUsageGrid.store.loadData('');	
							}	
						}
						else if(chartName != null && chartName=='instanceThroughput')
						{
							var trexThroughputData = jsonData['TrexThroughputJsonData'];


							var instanceThroughput_Obj = Ext.getCmp('instanceThroughput_Chart');
							if(!Ext.isEmpty(instanceThroughput_Obj))
							{
								instanceThroughput_Obj.removeAll();
								instanceThroughput_Obj.setChartData(trexThroughputData);
							}
						}
					}
					else if(accordionName != null && accordionName=='Java_Instances')
					{
						if(chartName != null && chartName=='javaWatingTasks')
						{		
							var javaWatingTasks_Obj = Ext.getCmp('javaWatingTasks_Chart');
							javaWatingTasks_Obj.removeAll();
							javaWatingTasks_Obj.setChartData(jsonData['SapWasWatingTaskJsonData']);
						}
					}
					else if(accordionName != null && accordionName=='SAP_Hana')
					{
						if(chartName != null && chartName=='usageServicevsHost')
						{		
							var usageServicevsHost_Obj = Ext.getCmp('usageServicevsHost_Chart');
							usageServicevsHost_Obj.removeAll();
							usageServicevsHost_Obj.setChartData(jsonData['CPUUsageVScpuTotalTimeJsonData']);
						}
					}
					else if(accordionName != null && accordionName=='BO_Nodes')
					{
						var boenodeResourceUsage_Obj = Ext.getCmp('boenodeResourceUsage_Chart');
						boenodeResourceUsage_Obj.removeAll();
						boenodeResourceUsage_Obj.setChartData(jsonData['BONodeResourceUsageJsonData']);
					}
					else if(accordionName != null && accordionName=='ABAPSystems')
					{
						if(chartName != null && chartName=='Trfc')
						{	
							var abapTrfcTraffic_Obj = Ext.getCmp('abapTrfcTraffic_Chart');
							abapTrfcTraffic_Obj.removeAll();
							abapTrfcTraffic_Obj.setChartData(jsonData['trfcTrafficJsonData']);
						}
						else if(chartName != null && chartName=='abapWorkProcess')
						{	
							var abapWorkProcess_Obj = Ext.getCmp('abapWorkProcess_Chart');
							abapWorkProcess_Obj.removeAll();
							abapWorkProcess_Obj.setChartData(jsonData['systemWorkProcessJsonData']);
						}
					}
				}
			}
		});
	},				

	loadDataForCorrespondingAccordion:function(selectedView,jsonData)
	{
		Ext.defer(function(){

			if(selectedView != null && selectedView=='TREX_Instances')
			{				
				Ext.getCmp('accordionBlock').items.items[4].expand();	
				if (jsonData.hasOwnProperty('accordianTrexData'))
				{
					jsonData=jsonData['accordianTrexData'];
					var trexSearch_Obj = Ext.getCmp('trexSearch_Chart');
					if(!Ext.isEmpty(trexSearch_Obj))
					{
						trexSearch_Obj.setChartData(jsonData['TrexSearchesJsonData']);
					}

					var resourceUsageData = jsonData['TrexResourceUsageJsonData'];
					var resourceUsageGridData = resourceUsageData['gridData'];
					var gridColumns = resourceUsageData['gridColumns'];

					if(gridColumns!=null && !Ext.isEmpty(gridColumns))
					{
						var updatedColumn = gridColumns.Column_3;
					}

					var resourceUsageGrid = Ext.getCmp('trexResourceUsageGrid');

					Ext.each(Ext.getCmp('trexResourceUsageGrid').columns,function(d){
						if(d.dataIndex != null && d.dataIndex =='Column_3')
						{
							d.setText(updatedColumn);					
						}			
					}); 
								
					if(!Ext.isEmpty(resourceUsageGridData))
					{
						Ext.each(Ext.getCmp('trexResourceUsageGrid').columns,function(d){
							this.hidden =  false;
						}); 
						Ext.get('trexResourceUsageGrid').removeCls('hideBodyTopBorder');
						resourceUsageGrid.getStore().removeAll();
						resourceUsageGrid.store.loadData(resourceUsageGridData);
						
					}else{
						Ext.each(Ext.getCmp('trexResourceUsageGrid').columns,function(d){
							this.hidden =  true;
						}); 
						Ext.get('trexResourceUsageGrid').addCls('hideBodyTopBorder');
						resourceUsageGrid.getStore().removeAll();
						resourceUsageGrid.store.loadData('');	
					}			

					var trexThroughputData = jsonData['TrexThroughputJsonData'];
				
					var instanceThroughput_Obj = Ext.getCmp('instanceThroughput_Chart');
					if(!Ext.isEmpty(instanceThroughput_Obj))
					{
						instanceThroughput_Obj.removeAll();
						instanceThroughput_Obj.setChartData(trexThroughputData);
					}
				}
				
			}else if(selectedView != null && selectedView=='Java_Instances')
			{
				Ext.getCmp('accordionBlock').items.items[1].expand();
				if (jsonData.hasOwnProperty('accordianJavaData'))
				{
					jsonData=jsonData['accordianJavaData'];
					var javaActiveTrans_Obj = Ext.getCmp('javaActiveTrans_Chart');
					if(!Ext.isEmpty(javaActiveTrans_Obj))
					{
						javaActiveTrans_Obj.setChartData(jsonData['SapWasActiveTransJsonData']);
					}

					var aliasesjsonData = jsonData['SapWasAliasesJsonData'];
					var gridData = aliasesjsonData['gridData'];
								
					var javaAliasesGrid = Ext.getCmp('javaAliases_Grid');
					if(!Ext.isEmpty(gridData))
					{
						Ext.each(Ext.getCmp('javaAliases_Grid').columns,function(d){
							this.hidden =  false;
						}); 
						Ext.get('javaAliases_Grid').removeCls('hideBodyTopBorder');
						javaAliasesGrid.getStore().removeAll();
						javaAliasesGrid.store.loadData(gridData);
					}else{
						Ext.each(Ext.getCmp('javaAliases_Grid').columns,function(d){
							this.hidden =  true;
						}); 
						Ext.get('javaAliases_Grid').addCls('hideBodyTopBorder');
						javaAliasesGrid.getStore().removeAll();
						javaAliasesGrid.store.loadData('');	
					}
					
					var javaWatingTasks_Obj = Ext.getCmp('javaWatingTasks_Chart');
					if(!Ext.isEmpty(javaWatingTasks_Obj))
					{
						javaWatingTasks_Obj.setChartData(jsonData['SapWasWatingTaskJsonData']);
					}
				}
			}else if(selectedView != null && selectedView=='Web_Dispatcher')
			{
				Ext.getCmp('accordionBlock').items.items[3].expand();
				if (jsonData.hasOwnProperty('accordianWebDispData'))
				{
					jsonData=jsonData['accordianWebDispData'];
								
					var percentLoad_Obj = Ext.getCmp('percentLoad_Chart');
					if(!Ext.isEmpty(percentLoad_Obj))
					{
						percentLoad_Obj.setChartData(jsonData['SapWebDispDestinationJsonData']);
					}

					var workloadGridjsonData = jsonData['SapWebDispWorkloadJsonData'];
					var gridData = workloadGridjsonData['gridData'];
					
					var dispWorkLoadGrid = Ext.getCmp('dispWorkLoad_Grid');
					if(!Ext.isEmpty(gridData))
					{
						Ext.each(Ext.getCmp('dispWorkLoad_Grid').columns,function(d){
							this.hidden =  false;
						}); 
						dispWorkLoadGrid.removeCls('hideBodyTopBorder');
						dispWorkLoadGrid.getStore().removeAll();
						dispWorkLoadGrid.store.loadData(gridData);
						
					}else{
						Ext.each(Ext.getCmp('dispWorkLoad_Grid').columns,function(d){
							this.hidden =  true;
						}); 
						Ext.get('dispWorkLoad_Grid').addCls('hideBodyTopBorder');
						dispWorkLoadGrid.getStore().removeAll();
						dispWorkLoadGrid.store.loadData('');	
					}

					var protocolConnectTimes_Obj = Ext.getCmp('protocolConnectTimes_Chart');
					if(!Ext.isEmpty(protocolConnectTimes_Obj))
					{
						protocolConnectTimes_Obj.setChartData(jsonData['SapWebDispconTimeJsonData']);	
					}
				}
			}
			else if(selectedView != null && selectedView=='SAP_Hana')
			{	
				Ext.getCmp('accordionBlock').items.items[5].expand();
				if (jsonData.hasOwnProperty('accordianHanaData'))
				{
					jsonData=jsonData['accordianHanaData'];
								
					var hanaInstances_Obj = Ext.getCmp('hanaInstances_Chart');
					if(!Ext.isEmpty(hanaInstances_Obj))
					{
						hanaInstances_Obj.setChartData(jsonData['responseTimeVSexecRateJsonData']);
					}

					var gridJson = jsonData['execRateVSfreeSwapSpaceJsonData'];
					var gridData = gridJson['gridData'];

					var swapMemoryBusyInst_Obj = Ext.getCmp('swapMemoryBusyInst_Chart');
					if(!Ext.isEmpty(gridData))
					{
						Ext.each(Ext.getCmp('swapMemoryBusyInst_Chart').columns,function(d){
							this.hidden =  false;
						}); 
						Ext.get('swapMemoryBusyInst_Chart').removeCls('hideBodyTopBorder');
						swapMemoryBusyInst_Obj.getStore().removeAll();
						swapMemoryBusyInst_Obj.store.loadData(gridData);
					}else{
						Ext.each(Ext.getCmp('swapMemoryBusyInst_Chart').columns,function(d){
							this.hidden =  true;
						}); 
						Ext.get('swapMemoryBusyInst_Chart').addCls('hideBodyTopBorder');
						swapMemoryBusyInst_Obj.getStore().removeAll();
						swapMemoryBusyInst_Obj.store.loadData('');	
					}

					var usageServicevsHost_Obj = Ext.getCmp('usageServicevsHost_Chart');
					if(!Ext.isEmpty(usageServicevsHost_Obj))
					{
						usageServicevsHost_Obj.setChartData(jsonData['CPUUsageVScpuTotalTimeJsonData']);
					}
				}
			}
			else if(selectedView != null && selectedView=='ABAPSystems')
			{
				Ext.getCmp('accordionBlock').items.getAt(0).expand();
				if (jsonData.hasOwnProperty('accordianABAPSystemData'))
				{
					jsonData=jsonData['accordianABAPSystemData'];
					
					var abapWorkProcess_Obj = Ext.getCmp('abapWorkProcess_Chart');
					if(!Ext.isEmpty(abapWorkProcess_Obj))
					{
						abapWorkProcess_Obj.removeAll();
						abapWorkProcess_Obj.setChartData(jsonData['systemWorkProcessJsonData']);
					}

					var abapTrfcTraffic_Obj = Ext.getCmp('abapTrfcTraffic_Chart');
					if(!Ext.isEmpty(abapTrfcTraffic_Obj))
					{
						abapTrfcTraffic_Obj.removeAll();
						abapTrfcTraffic_Obj.setChartData(jsonData['trfcTrafficJsonData']);
					}

					var ABAPInstancesTransaction_Obj = Ext.getCmp('ABAPInstancesTransaction_Chart');
					if(!Ext.isEmpty(ABAPInstancesTransaction_Obj))
					{
						ABAPInstancesTransaction_Obj.removeAll();
						ABAPInstancesTransaction_Obj.setChartData(jsonData['slowTransactionInstanceJsonData']);
					}
				}
			}
			else if(selectedView != null && selectedView=='BO_Nodes')
			{
				Ext.getCmp('accordionBlock').items.items[2].expand();
				if (jsonData.hasOwnProperty('accordianBONodeData'))
				{
					jsonData=jsonData['accordianBONodeData'];
					
					var boenodeResourceUsage_Obj = Ext.getCmp('boenodeResourceUsage_Chart');
					if(!Ext.isEmpty(boenodeResourceUsage_Obj))
					{
						boenodeResourceUsage_Obj.removeAll();
						boenodeResourceUsage_Obj.setChartData(jsonData['BONodeResourceUsageJsonData']);
					}

					boeNodeActiveFilecConnections_Obj = Ext.getCmp('boeNodeActiveFilecConnections');
					if(!Ext.isEmpty(boeNodeActiveFilecConnections_Obj))
					{
						boeNodeActiveFilecConnections_Obj.removeAll();
						boeNodeActiveFilecConnections_Obj.setChartData(jsonData['BONodeActiveConnectionsJsonData']);
					}

					var BONodeErrorMsgRateJsonData = jsonData['BONodeErrorMsgRateJsonData'];
								
					if(BONodeErrorMsgRateJsonData!=null && !Ext.isEmpty(BONodeErrorMsgRateJsonData))
					{
						var gridColumns = BONodeErrorMsgRateJsonData.gridColumns;
						var gridData = BONodeErrorMsgRateJsonData.gridData;					
						var gridColsLogs = gridColumns;
						var colsArrLogs = [];
						var fields2StoreLogs = [];

						for (var colVal in gridColsLogs) 
						{
							var colName = gridColsLogs[colVal];
											
							fields2StoreLogs.push({
								name : colVal,
								type : 'FLOATORSTRING'
							});
							fields2StoreLogs.push({
								name : colVal+"_url",
								type : 'string'
							});
							
							if(colVal=='Column_0'){
								colsArrLogs.push({
									text: colName,
									dataIndex: colVal,
									minWidth:125,
									flex:1,
									renderer : function(value, metaData, record, row, col, store, gridView) {
										var value = '<span class="font_bold11" style="cursor:default; white-space:normal;word-wrap: break-word;" data-qtip="' + value + '">' + value + '</span>';
										return value; 							
									}
								});
							}else{
								colsArrLogs.push({
									text: colName,
									dataIndex: colVal,
									minWidth:50,
									align:'center',
									renderer : function(value, metaData, record, row, col, store, gridView) {
										if(row!=0){
											var href = record.get("Column_" + col + '_url');
											href=decodeURI(href);
											value = '<a data-qtip="' + value + '" href=\'javascript:goToLayerModel("' + href + '")\'>' + value + '</a>';
											return value; 	
										}else{
											return value; 
										}
									}
								});
							}
						}
						
						var boeErrorLogMessagesGrid = Ext.getCmp('boeErrorLogMessages_Grid');					
						if(!Ext.isEmpty(gridData))
						{
							boeErrorLogMessagesGrid.getStore().removeAll();

							Ext.each(Ext.getCmp('boeErrorLogMessages_Grid').columns,function(d){
								this.hidden =  false;
							});
							Ext.get('boeErrorLogMessages_Grid').removeCls('hideBodytopborder');
							var storeVal = Ext.create('Ext.data.Store',{
								fields:fields2StoreLogs,
								data:gridData,
							});

							boeErrorLogMessagesGrid.reconfigure(storeVal,colsArrLogs);
							boeErrorLogMessagesGrid.store.loadData(gridData);	

						}else{

							Ext.each(Ext.getCmp('boeErrorLogMessages_Grid').columns,function(d){
								this.hidden =  true;
							}); 
							Ext.get('boeErrorLogMessages_Grid').addCls('hideBodytopborder');
							boeErrorLogMessagesGrid.getStore().removeAll();
							boeErrorLogMessagesGrid.store.loadData('');	
						}
						
					}else{

						Ext.each(Ext.getCmp('boeErrorLogMessages_Grid').columns,function(d){
							this.hidden =  true;
						}); 
						Ext.get('boeErrorLogMessages_Grid').addCls('hideBodyTopBorder')
						boeErrorLogMessagesGrid.getStore().removeAll();
						boeErrorLogMessagesGrid.store.loadData('');	
					}
				}
			}
			Ext.getCmp('mainView').body.scrollTo('top',scrollPosition); 
		},1000);	
	},

	openAvailabilityPopup:function(serverType,state)
	{
		var stateForTitle = state;
		if(state=='Good')
		{
			stateForTitle = 'Normal';
		}

		var URLparams = "action=loadAvailabilityPopup&serverType="+encodeURIComponent(serverType)+"&state="+encodeURIComponent(state);
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.egSapPlaformDBController',
			scope: this,
			params :URLparams,
			method : 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				if(jsonText != null && jsonText != '')
				{
					var jsonData = Ext.decode(jsonText);
					var compDataList = jsonData.componetDetails;	
					
					var availibilityWindowObj = Ext.getCmp('availibilityWindow');
					if(Ext.isEmpty(availibilityWindowObj))
					{
						availibilityWindowObj = Ext.create("utilities.GenericWindow", {
							height:strSkin == "Light" ? 200 : 200,
							width:strSkin == "Light" ? 426 : 426,
							header:{
								height:33,
								padding:'0 10',
								margin:0
							},
							ghost:false,
							cls:'myDashboardwindow sapHeader',
							frame:true,
							padding:0,
							border:true,
							modal:true,
							closable:true,
							draggable:true,
							resizable:false,
							id:'availibilityWindow',
							title:serverType+' - '+stateForTitle,
							scroll:true,
							autoScroll:true,
							closeAction:'destroy',
							buttonAlign :'center',
							layout: {
								type: 'vbox',
								align: 'stretch'
							},
							listeners:{
								'afterrender':function(){
										var dataview = Ext.create('Ext.view.View', {
											store: Ext.create('Ext.data.Store', {
												id: 'datastore',
												fields: [{name: 'name'},{name: 'componentUrl'},{name: 'state'}],
												proxy: {
													type:'memory',
													reader: {
														type:'json',
														root: 'compList'
													}
												},
												data: compDataList
											}),
											tpl:  new Ext.XTemplate(
												
												'<div style="width: 100%;padding:10px 10px 10px 10px;" class="thumb-wrap" >',
													'<fieldset class="fieldSetDivSapHeader" >',
													 '<ul style="padding:0px 10px 5px 2px;overflow:auto;height:120px; ">',
														'<tpl for=".">',
															'<li style="float:left; width:175px; margin-bottom:7px;"><div ><img src="../images/clear.png" class="stateEffect_{state}" /><span style="vertical-align:top; margin: 3px 5px 0 2px;display:inline-block;    display: inline-block;width: 145px;overflow: hidden;    text-overflow: ellipsis;white-space: nowrap;"  data-qtip="{name}"><a href="javascript:void(0);" onclick="javascript:goToLayerModel(\'{componentUrl}\');">{name}</a></span></div>',
															'</li>',
														'</tpl>',
													 '</ul>',
													 '<fieldset>',
												'</div>'
												
											),
											itemSelector: 'div.thumb-wrap',
											emptyText: noDataFoundMsg
										});
									this.add(dataview)
								}
							}
						});
						availibilityWindowObj.show();
					}
				}
			}
		});
	},

	loadAlarmDetails : function(compType,alertState)
	{
		var serverDispName = compType;

		if(compType == 'SAP_system')
		{
			var serverDispName ='ABAP Systems';
		}
		else if(compType == 'SAPWAS_server')
		{
			var serverDispName ='Java Instances';
		}
		else if(compType == 'SAP_BOBI')
		{
			var serverDispName = 'BO Nodes';
		}
		else if(compType == 'SAP_TREX')
		{
			var serverDispName = 'TREX Instances';
		}
		else if(compType == 'SAP_WEB_DISP')
		{
			var serverDispName = 'Web Dispatcher';
		}
		else if(compType == 'SAP_HANA')
		{
			var serverDispName = 'SAP Hana';
		}
				
		var paramsForData ='action=loadDetailAlerts&compType='+encodeURIComponent(compType)+'&alertState='+encodeURIComponent(alertState);
		
		Ext.Ajax.request({
				url : '/final/servlet/com.eg.egSapPlaformDBController',
				method : 'POST',
				params : paramsForData,
				scope : this,
				success : function(response) {
					var jsonText = response.responseText;
					if (jsonText != null && jsonText != '') {
						var jsonData=Ext.decode(jsonText);
						var gridCols = jsonData['compAlarmDetails']['gridColumns'];
						var gridData = jsonData['compAlarmDetails']['gridArrayData'];
						var colsArr = new Array();
						var fields2Store = new Array();
						var widthForEachColumn = 105;
						for ( var colVal in gridCols) {
							var colName = gridCols[colVal];
							fields2Store.push({
								name : colVal,
								type : 'FLOATORSTRING'
							});
							
							var flex_Val=0;
							var flex_Width=0;
							

							if(colName!=null && (colVal=='alertStatus' || colVal=='measureGrpUrl' || colVal=='ddUrl'))
							{
								flex_Width=40;
							}
							else if(colVal!=null && (colVal=='layerModelUrl'))
							{
								continue;
							}
							else if(colVal!=null && (colVal=='Description'))
							{
								flex_Val=0.5;
								flex_Width=0;

							}
							else if(colVal!=null && (colVal=='StartTime'))
							{
								flex_Width=140;
							}


							colsArr
								.push({
										header : colName,
										dataIndex : colVal,
										flex : flex_Val,
										width:flex_Width,
										headerCls:'header_col',
										tdCls : 'gridCellWrap',
										renderer : function(value, metaData, record, row, col, store, gridView) {
											var gcolumn = gridView.getHeaderAtIndex(col);
											var dataIndexVal = gcolumn.dataIndex;
											if (dataIndexVal != null && dataIndexVal == "alertStatus") {
													return '<span><img style="vertical-align:middle;display:inline-block;margin-right:0px" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="'
															+ record.get('alertStatus') + '"/></span>';

											}
											else if(dataIndexVal != null && (dataIndexVal == "ddUrl")) 
											{
												var ddUrl=record.get('ddUrl');
												ddUrl=decodeURI(ddUrl);

												var detailUrl=ddUrl.substring(0,ddUrl.indexOf("?"));
												var ddUrlParams=ddUrl.substring(ddUrl.indexOf("?")+1);
												
												if(ddUrlParams.indexOf("\\")>0)
												{
													ddUrlParams=ddUrlParams.replace("\\","\\\\");
													ddUrl=detailUrl+"?"+ddUrlParams;
												}

												if(ddUrl!="-")
												if(ddUrl!="-")
												{
													return '<span data-qclass="yellowTip" data-qtip="DIAGNOSIS"><a href=\'javascript:loadVmLinkPopup("' + ddUrl + '")\'><img style="vertical-align:middle;display:inline-block;margin-right:0px" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconDiagnosis" /></a></span>';
												}
												else
												{
													return "";
												}
											}
											else if(dataIndexVal != null && (dataIndexVal == "measureGrpUrl"))
											{
												var measGrpUrl=record.get('measureGrpUrl');
												measGrpUrl=decodeURI(measGrpUrl);
												var measureUrl=measGrpUrl.substring(0,measGrpUrl.indexOf("?"));
												var measUrlParams=measGrpUrl.substring(measGrpUrl.indexOf("?")+1);
												
												if(measUrlParams.indexOf("\\")>0)
												{
													measUrlParams=measUrlParams.replace("\\","\\\\");
													measGrpUrl=measureUrl+"?"+measUrlParams;
												}

												if(measGrpUrl!="-")
												{
													return '<span data-qclass="yellowTip" data-qtip="GRAPH"><a href=\'javascript:loadVmLinkPopup("' + measGrpUrl + '")\'><img style="vertical-align:middle;display:inline-block;margin-right:0px" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconLineChart" /></a></span>';
												}
												else
												{
													return "";
												}
											}
											else if(dataIndexVal != null && (dataIndexVal == "Description")){
												var layerModelUrl=record.get('layerModelUrl');
												layerModelUrl=decodeURI(layerModelUrl);

												if(layerModelUrl!="-")
												{
													return '<span data-qclass="yellowTip" data-qtip="' + value + '"><a href=\'javascript:goToLayerModel("' + layerModelUrl + '")\'>' + value + '</a></span>';
												}
												else
												{
													return '<div data-qclass="yellowTip" data-qtip="' + value + '">' + value + '</div>';
												}

											}
											 else {
												return '<div data-qclass="yellowTip" data-qtip="' + value + '">' + value + '</div>';
											}
										}
									});
								}

							var alarmDetailsWindowObj = Ext.getCmp('alarmDetailsWindow');
							if(Ext.isEmpty(alarmDetailsWindowObj))
							{
								alarmDetailsWindowObj = Ext.create('utilities.GenericWindow', {
								title : alarmsPopupTitle+' '+serverDispName+' - '+alertState,
								cls:'myDashboardwindow',
								id:'alarmDetailsWindow',
								header:{
									height:32,
									margin:0,
								},
								width : 900,
								height : 370,
								frame:false,
								padding:0,
								margin:0,
								resizable:false,
								border:false,
								layout : 'fit',
								modal:true,
								ghost:false,
								closeAction : 'destroy',
								items : {
									xtype : 'grid',
									menuDisabled : true,
									enableColumnHide : true,
									margin : 10,
									padding:0,
									store : Ext.data.Store({
										fields : fields2Store,
										data : gridData,
										sortOnLoad : true,
										sorters : {
											property : 'COLUMN_0',
											direction : 'ASC'
										}
									}),
									border : false,
									frame:false,
									autoScroll : true,
									stripeRows : false,
									cls : 'gridSkin gridShadow',
									flex : 1,
									shrinkWrap : 0,
									columns : colsArr,
									id :'alarmDetails_Grid'
								},
								listeners:{
									'show' : function(win)
										{
											if (this.modal) {
												var dom = Ext.dom.Query.select('.x-mask');
												var el = Ext.fly(dom[0]);
												el.addCls('windowModal');
											}
										},
										'hide':  function(win) {
											if (this.modal) {
												var dom = Ext.dom.Query.select('.x-mask');
												var el = Ext.fly(dom[0]);
												el.removeCls('windowModal');
											}
										}
								}
							});
						}
						alarmDetailsWindowObj.show();
					}
				},
				failure : function(response, opts) {

				}
		});
	},


	openDDPopup:function(compName,info)
	{
		var URLparams = "action=loadDDPopup&compName="+encodeURIComponent(compName)+"&info="+encodeURIComponent(info);
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.egSapPlaformDBController',
			scope: this,
			params :URLparams,
			method : 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				if(jsonText != null && jsonText != '')
				{
					var jsonData = Ext.decode(jsonText);
				
					var colsArr = [];
					var fields2Store = [];
					var gridJson =[];

					var isEmptyData=true;
					var jsonDataRoot = jsonData.DDInfos;

					if (jsonDataRoot.hasOwnProperty('gridJson'))
					{
						isEmptyData=false;

						var gridColumns = jsonData.DDInfos.gridColumns;
						gridJson = jsonData.DDInfos.gridJson;

						for (var colVal in gridColumns) 
						{
							var colName = gridColumns[colVal];
										
							fields2Store.push({
								name : colVal,
								type : 'FLOATORSTRING'
							});

						
							if(colVal=='Column_0'){
								colsArr.push({
									header: colName,
									dataIndex: colVal,
									width:100,
									renderer : function(value, metaData, record, row, col, store, gridView) {
										var value = '<span style="cursor:default;"data-qtip="' + value + '">' + value + '</span>';
										return value; 								
									}
								});
							}else if(colVal=='Column_1'){
								colsArr.push({
									header: colName,
									dataIndex: colVal,
									width:100,
									renderer : function(value, metaData, record, row, col, store, gridView) {
										var value = '<span style="cursor:default;"data-qtip="' + value + '">' + value + '</span>';
										return value; 								
									}
								});
							}else if(colVal=='Column_2'){
								colsArr.push({
									header: colName,
									dataIndex: colVal,
									width:150,
									renderer : function(value, metaData, record, row, col, store, gridView) {
										var value = '<span style="cursor:default;"data-qtip="' + value + '">' + value + '</span>';
										return value; 								
									}
								});
							}else if(colVal=='Column_3'){
								colsArr.push({
									header: colName,
									dataIndex: colVal,
									width:110,
									renderer : function(value, metaData, record, row, col, store, gridView) {
										var value = '<span style="cursor:default;"data-qtip="' + value + '">' + value + '</span>';
										return value; 								
									}	
								});
							}
							else {
								colsArr.push({
									header: colName,
									dataIndex: colVal,
									width:100,
									renderer : function(value, metaData, record, row, col, store, gridView) {
										var value = '<span style="cursor:default;"data-qtip="' + value + '">' + value + '</span>';
										return value; 								
									}
								});
							}
						}
					}

					var noDataArr =[];
					noDataArr.push({
							xtype : 'container',
							margin : '0 0 0 0',
							html : '<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Detailed Measures Available!</div></div></div>'
					});

						var DDPopupWindowObj = Ext.getCmp('DDPopupWindow');
						if(Ext.isEmpty(DDPopupWindowObj))
						{
						
							DDPopupWindowObj = Ext.create('utilities.GenericWindow', {
							title : 'Top slow steps for '+compName+' '+'{'+info+'}',
							cls:'myDashboardwindow',
							id:'DDPopupWindow',
							header:{
								height:32,
								margin:0,
							},
							width : 900,
							height : 370,
							frame:false,
							padding:0,
							margin:0,
							resizable:false,
							border:false,
							layout : 'fit',
							modal:true,
							ghost:false,
							closeAction : 'destroy',
							items : {
								xtype : 'grid',
								menuDisabled : true,
								enableColumnHide : true,
								margin : 10,
								padding:0,
								store : Ext.data.Store({
									fields : fields2Store,
									data : gridJson,
									sortOnLoad : true,
									sorters : {
										property : 'COLUMN_0',
										direction : 'ASC'
									}
								}),
								border : false,
								frame:false,
								autoScroll : true,
								stripeRows : false,
								ui:'newGridPanel bodyTextWrap headerTextWrap',
								flex : 1,
								shrinkWrap : 0,
								columns : colsArr,
								id :' DD_Grid',
								emptyText:noDataFoundMsg
							},
							listeners:{
								'show' : function(win)
								{
									if (this.modal) {
										var dom = Ext.dom.Query.select('.x-mask');
										var el = Ext.fly(dom[0]);
										el.addCls('windowModal');
									}
									if(isEmptyData)
									{
										this.removeAll();
										this.add(noDataArr);
										this.doComponentLayout();
									}
									
								},
								'hide':  function(win) {
									if (this.modal) {
										var dom = Ext.dom.Query.select('.x-mask');
										var el = Ext.fly(dom[0]);
										el.removeCls('windowModal');
									}
								}
							}
							});
						}
					DDPopupWindowObj.show();
					}
				}
		});
	}
		
});