Ext.define('SAPPlatform.view.ABAPInstances', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.abapinstances',
	id:'ABAPInstancesTransaction_Chart',
    initComponent: function() {
        var me = this;
        me.callParent();
    },
    padding: '0',
    ui: 'newGraphPanel',
    itemSelector: 'div.thumb-wrap',
			
	setChartData: function(data) {
		var me = this;
		if(!Ext.isEmpty(data) && data['isChartAvailable']){
				$('#'+me.id+'-body').highcharts(me.chartProps(data));
				var width = $('#'+me.id+'-body').width();
				var height = $('#'+me.id+'-body').height();			
		}else{
			$('#'+me.id+'-body').html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>'+noMeasuresFoundMsg+'</div></div></div>');
		}
    },

	chartProps:function(data){
		var me = this;
		var series = data['series'];
		var categories = data['xLabel'];
		var colors = data['colors'];
		var unit = data['unit'];
		var chartType = data['chartType'];
		var chartProps = {
			  chart: {
					type: 'bar',
					marginTop:40,
				},
				title: {
					text: ''
				},
				colors:['#9cc9cc', '#f8e4c6',  '#fb9e87','#ffcd84','#68cbe7','#6074a7'],
				xAxis: {     
					categories: categories,     
					labels:{
					style:{
						color: strSkin=="Dark"?"#c0c0c0":"#969696",
						fontSize:'11px',
						fontWeight:'normal',
					},
					},
					tickWidth: 0,
					lineWidth: 0,
					minorGridLineWidth: 1,
					gridLineWidth: 0,
					gridLineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
					lineColor: strSkin=="Dark"?"#666666":"#e5e5e5"
				},
				tooltip:{
					split:false,
					distance:30,
					 padding:5,
					 headerFormat:'<b>{point.x}</b><br/>',
					pointFormat:'{series.name}: {point.y}'
				},

				yAxis: {
					minRange: 2,
					min:0,
					visible: true,
					labels: {
					   enabled: true,
					   style:{
							color: strSkin=="Dark"?"#c0c0c0":"#969696",
							fontSize:'11px',
							fontWeight:'normal'
					  },
					},
					title: {
						text: unit,
						style: {
							fontSize: '11px',
							color: strSkin=="Dark"?"#c0c0c0":"#969696"
						}
					},
					lineWidth: 1,
					minorGridLineWidth: 1,
					gridLineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
					lineColor: strSkin=="Dark"?"#666666":"#e5e5e5"
				},
				legend:{
					reversed: true,
					align:'center',
					x:-5,
					verticalAlign:'top',
					y:-10,
					floating:true,
					borderColor:'#cccccc',
					borderWidth:0,
					shadow:false,
					itemStyle:{
					  color: strSkin=="Dark"?"#c0c0c0":"#707070",
					  fontSize:'11px',
					  fontWeight:'normal',
					  textOverflow:'ellipsis',
				},
				itemHoverStyle:{
				  color:strSkin=="Dark"?"#c0c0c0":"#707070",
				},
				itemDistance:10,
				squareSymbol:false,
				symbolWidth:6,
				symbolHeight:6,
				symbolRadius:3,
			  },
				
				exporting: {
					enabled: false
				},
				credits: {
					enabled: false
				},
				plotOptions: {
					series: {
						stacking: 'normal',
						pointWidth: 12,
						borderColor: strSkin=="Dark"?"#404040":"#ffffff",
					},
					dataLabels: {
						enabled: false
					},
					bar:{
						cursor:'pointer',
						stacking:'normal',
						point: {
							events: {
								click: function(e) {
									if(!Ext.isEmpty(e.point))
									{
										var serverName = e.point.category;
										var serverNameVal=serverName.split("(");
										var compName = serverNameVal[0];
										var infoVal = serverNameVal[1];
										var infoValue=infoVal.split(")");
										var info = infoValue[0];
										SAPPlatform.app.getController('Main').openDDPopup(compName,info);
									}
								}
							}
						}
					}
				},
				series: series				 
			};
			return chartProps;
	},
	listeners: {
		resize: {
			fn: function(el) {
				var availID = Ext.getCmp('ABAPInstancesTransaction_Chart').id;
				if (!Ext.isEmpty( 'availID')){
					if( availID != undefined && $('#'+availID+'-body').highcharts()!= undefined){
						$('#'+availID+'-body').highcharts().reflow();
					}
				}
			}
		}
    }

});