Ext.define('SAPPlatform.view.ABAPWorkProcess', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.abapworkprocess',
	id:'abapWorkProcess_Chart',
    initComponent: function() {
        var me = this;
        me.callParent();
    },
    padding: '0 0px 0 0',
    title:'',
    itemSelector: 'div.thumb-wrap',

	setChartData: function(data) {
		var me = this;
		if(!Ext.isEmpty(data) && data['isChartAvailable'])
		{
			$('#'+me.id+'-body').highcharts(me.chartProps(data));
			
		}else{
			$('#'+me.id+'-body').html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>'+noMeasuresFoundMsg+'</div></div></div>');
		}
    },

	chartProps:function(data){
		var me = this;
		var series = data['chartData']['DataSet'];
		var categories = data['chartData']['xAxisLabel'];
		var unit = data['chartData']['unit'];

		var chartProps = {
			chart: {
                    type: 'column',
                    marginTop: 30,
                },
                title: {
                    text: ''
                },
                reflow: true,
                subtitle: {
                    text: ''
                },
                xAxis: {
					categories:categories,
                    minorTickLength: 0,
                    tickLength: 0,
                    labels: {
                        align: 'right',
                        enabled: true,
                        rotation: -45,
                        x: 0,
                        y: 10,
                        style: {
                            color: strSkin=="Dark"?"#c0c0c0":"#969696",
                            fontSize: '10px',
                            fontWeight: 'normal',
                            lineHeight: '1.5em',
                        },
                    },
                    gridLineWidth: 0,
                    gridLineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
                    lineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
                    lineWidth: 1,
                },

                yAxis: [{
					minRange: 2,
                    min: 0,
					title: {
						text: unit,
						 style: {
							color: strSkin=="Dark"?"#c0c0c0":"#969696"
						}

					},
                    labels: {
                        style: {
                            color: strSkin=="Dark"?"#c0c0c0":"#969696",
                            fontSize: '11px',
                            fontWeight: 'normal',
                            lineHeight: '1.5em',
                        },
                    },
                    stackLabels: {
                        enabled: false,
                        style: {
                            fontWeight: 'bold',
                            color: (Highcharts.theme && Highcharts.theme.textColor) || 'gray'
                        }
                    },
                    gridLineWidth: 1,
                    gridLineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
                    lineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
                    lineWidth: 1,
                }, {
                    title: {
                        text: ''
                    },
                    opposite: true,
                    gridLineWidth: 1,
                    gridLineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
                    lineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
                    lineWidth: 1,
                }],
                colors: ['#fac090'],
                exporting: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },
                legend: {
                    enabled: false
                },
                navigator: {
                    enabled: false
                },
                legend: {
                    enabled: false,
                    align: 'left',
                    x: -5,
                    verticalAlign: 'top',
                    y: -5,
                    floating: true,
                    borderColor: '#cccccc',
                    borderWidth: 0,
                    shadow: false,
                    itemStyle: {
                        color: '#707070',
                        fontSize: '10px',
                        fontWeight: 'normal',
                        textOverflow: 'ellipsis',
                    },
                    itemHoverStyle: {
                        color: '#707070'
                    },
                    itemDistance: 10,
                    squareSymbol: false,
                    symbolWidth: 6,
                    symbolHeight: 6,
                    symbolRadius: 3,
                },
                tooltip: {
                    split: false,
                    distance: 30,
                    padding: 5,
                    headerFormat: '<b>{point.x}</b>:{point.y}',
                    pointFormat: ''
                },
                plotOptions: {
                    column: {
                        stacking: 'normal',
                        borderWidth: 0,
                        dataLabels: {
                            enabled: false,
                            shadow: false,
                            color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'black',
                            style: {
                                color: 'contrast',
                                fontSize: '11px',
                                fontFamily: 'arial',
                                fontWeight: 'normal',
                                textOutline: '0px contrast',
                            }
                        }
                    },
                    series: {
						minPointLength: 2,
                        stacking: 'normal',
                        maxPointWidth: 25,
                        pointWidth: 14, 
                    },
                },
                series: series
		};
		return chartProps;
	},

	listeners: {
		resize: {
			fn: function(el) {
				var availID = Ext.getCmp('abapWorkProcess_Chart').id;
				if (!Ext.isEmpty( 'availID')){
					if( availID != undefined && $('#'+availID+'-body').highcharts()!= undefined){
						$('#'+availID+'-body').highcharts().reflow();
					}
				}
			}
		}
    }

});