Ext.define('SAPPlatform.view.Availability', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.availability',
	id: 'availability_Chart',
    initComponent: function() {
        var me = this;
        me.callParent();
    },
    layout:"fit",
    padding: '0 0px 0 0',   
	setChartData: function(data) {
		var me = this;
		if(!Ext.isEmpty(data) && data['isContainData']){
			Ext.defer(function(){
				$('#'+me.id+'-body').highcharts(me.chartProps(data));
				var width = $('#'+me.id+'-body').width();
				var height = $('#'+me.id+'-body').height();
			},500)
			
		}else{
			$('#'+me.id+'-body').html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>'+noMeasuresFoundMsg+'</div></div></div>');
		}
    },
	chartProps:function(data){
		var me = this;
		var series = data['series'];
		var categories = data['xLabel'];
		var colors = data['colors'];
		var title = data['Title'];
		var chartType = data['chartType'];
		var chartProps = {
			chart:{
				type:'column',
				marginTop:32,
				width:me.body.width,
				height:me.body.height
				},
			title: {
				text:''
			},
			reflow:true,
			subtitle:{
				text:''
			},
			xAxis:{
				categories:categories,
				minorTickLength:0,
				tickLength:0,
				labels:{
					align:'right',
					enabled:true,
					rotation:-45,
					x:0,
					y:10,
					style:{
						color:strSkin=="Dark"?"#c0c0c0":"#969696",
						fontSize:'11px',
						fontFamily:'arial',
						fontWeight:'normal',
						lineHeight:'1.5em',
					},
				},
				gridLineWidth:0,
				gridLineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
				lineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
			},
			
			yAxis:[{
				min:0,
				title:{
					text:''
				},
				labels:{
					style:{
						color:strSkin=="Dark"?"#c0c0c0":"#969696",
						fontSize:'11px',
						fontFamily:'arial',
						fontWeight:'normal',
						lineHeight:'1.5em',
					},
				},
				stackLabels:{
					enabled:false,
					style:{
						fontWeight:'bold',
						color:strSkin=="Dark"?"#666666":"#e5e5e5",
					}
				},
				gridLineWidth:1,
				gridLineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
				lineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
				lineWidth:1,
			},{
				title:{
					text:''
				},
				opposite:true,
				gridLineWidth:1,
				gridLineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
				lineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
				lineWidth:1,
			}],
			colors:colors,
			exporting:{
				enabled:false
			},
			credits:{
				enabled:false
			},
			navigator:{
				enabled:false
			},
			legend:{
				enabled:false,
				align:'left',
				x:-5,
				verticalAlign:'top',
				y:-18,
				floating:true,
				borderColor:strSkin=="Dark"?"#c3c3c3":"#cccccc",
				borderWidth:0,
				shadow:false,
				className: 'font_normal11',
				itemStyle:{
					color:strSkin=="Dark"?"#c0c0c0":"#707070",
					fontSize:'11px',
					fontWeight:'normal',
					textOverflow:'ellipsis',
				},
				itemHoverStyle:{
					color:strSkin=="Dark"?"#c3c3c3":"#969696",
				},
				itemDistance:10,
				squareSymbol:false,
				symbolWidth:6,
				symbolHeight:6,
				symbolRadius:3,
			},
			tooltip:{
				split:false,
				distance:30,
				padding:5,
				headerFormat:'<b>{point.x}</b><br/>',
				pointFormat:'{series.name}: {point.y}'
			},
			plotOptions:{
				column:{
					cursor:'pointer',
					stacking:'normal',
					borderWidth:0,
					dataLabels:{
						enabled:true,
						shadow:false,
						color:strSkin=="Dark"?"#ffffff":"#ffffff",
						style:{
							color:'contrast',
							fontSize:'11px',
							fontFamily:'arial',
							fontWeight:'normal',
							textOutline:'0px contrast',
						},
						formatter:function() {
							if(this.y != 0) {
							  return this.y;
							}
						}
					},
					point: {
						events: {
							click: function(e) {
								if(!Ext.isEmpty(e.point))
								{
									var serverType = e.point.category;
									var color = e.point.color;
									var state ='';
									if(color=='#cd0f0f')
									{
										state='Critical';
									}
									else if(color=='#fa9d1c')
									{
										state='Major';
									}
									else if(color=='#ccc100')
									{
										state='Minor';
									}
									else if(color=='#0c9a12')
									{
										state='Good';
									}
									
									SAPPlatform.app.getController('Main').openAvailabilityPopup(serverType,state);
								}
							}
						}
					},
					series: {
						stacking: 'normal',
						maxPointWidth: 25,
					}
				},
				series: {
					pointWidth: 17,

				},
			},
			series:series
		}
		return chartProps;
	},
	listeners: {
		resize: {
			fn: function(el) {
				var width = $('#'+this.id+'-body').width();
				var height = $('#'+this.id+'-body').height();
				this.height=height;
				Ext.defer(function(){
					var availID = Ext.getCmp('availability_Chart').id;
					if (!Ext.isEmpty( 'availID')){
						if( availID != undefined && $('#'+availID+'-body').highcharts()!= undefined){
							$('#'+availID+'-body').highcharts().reflow();
						}
					}
				},1500)
			}
		}
    }
});