Ext.define('SAPPlatform.view.DestinationsPercentageLoad', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.destinationspercentageload',
	id: 'percentLoad_Chart',

    initComponent: function() {
        var me = this;
        me.callParent();
    },
    padding: '0 0px 0 10px',
    title:'',
    itemSelector: 'div.thumb-wrap',
	setChartData: function(data) {
		var me = this;
		if(!Ext.isEmpty(data) && data['isChartAvailable']){
			$('#'+me.id+'-body').highcharts(me.chartProps(data['chartData']));
		}else{
			$('#'+me.id+'-body').html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>'+noMeasuresFoundMsg+'</div></div></div>');
		}
    },
	chartProps:function(data){
		var me = this;
		var series = data['DataSet'];
		var categories = data['xAxisLabel'];
		var title = data['Title'];
		var unit = data['unit'];

		var chartProps = {
				
			chart: {
				type: 'column',
				marginTop: 11,
			},
			title: {
				text: ''
			},
			reflow: true,
			subtitle: {
				text: ''
			},
			xAxis: {
				categories: categories,
				minorTickLength: 0,
				tickLength: 0,
				labels: {
					align: 'right',
					enabled: true,
					rotation: -45,
					x: 0,
					y: 10,
					style: {
						color:  strSkin=="Dark"?"#c0c0c0":"#969696",
						fontSize: '11px',
						fontWeight: 'normal',
						lineHeight: '1.5em',
					},
				},
				gridLineWidth: 0,
				gridLineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
				lineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
			},

			yAxis: [{
				min: 0,
				minRange: 2,
				title: {
					text: unit,
					style: {
							color: strSkin=="Dark"?"#c0c0c0":"#969696",
							fontSize: '11px',
							fontFamily: 'arial',
							fontWeight: 'normal',
							lineHeight: '1.5em',
						},
				},
				labels: {
					style: {
						color:  strSkin=="Dark"?"#c0c0c0":"#969696",
						fontSize: '11px',
						fontWeight: 'normal',
						lineHeight: '1.5em'
					},
				},
				stackLabels: {
					enabled: false,
					style: {
						fontWeight: 'bold',
						color: (Highcharts.theme && Highcharts.theme.textColor) || 'gray'
					}
				},
				gridLineWidth: 1,
				gridLineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
				lineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
				lineWidth: 1,
			}],
			exporting: {
				enabled: false
			},
			credits: {
				enabled: false
			},
			legend: {
				enabled: false
			},
			navigator: {
				enabled: false
			},
			legend: {
				enabled: false,
				align: 'left',
				x: -5,
				verticalAlign: 'top',
				y: -5,
				floating: true,
				borderColor: '#cccccc',
				borderWidth: 0,
				shadow: false,
				itemStyle: {
					color: '#707070',
					fontSize: '10px',
					fontWeight: 'normal',
					textOverflow: 'ellipsis',
				},
				itemHoverStyle: {
					color: '#707070'
				},
				itemDistance: 10,
				squareSymbol: false,
				symbolWidth: 6,
				symbolHeight: 6,
				symbolRadius: 3,
			},
			tooltip: {
				split: false,
				distance: 30,
				padding: 5,
				headerFormat: '<b>{point.x}</b>: {point.y}',
				pointFormat: ''
			},
			plotOptions: {
				column: {
					stacking: 'normal',
					borderWidth: 0,
					dataLabels: {
						enabled: false,
						shadow: false,
						color: strSkin=="Dark"?"#c0c0c0":"#2a292a",
						style: {
							fontSize: '11px',
							fontFamily: 'arial',
							fontWeight: 'normal',
							textOutline: '0px contrast',
							textShadow: false
						}
					}
				},
				series: {
					stacking: 'normal',
					pointWidth: 14
				}
			},
			series: series
		}
		return chartProps;
	},

	listeners: {
		resize: {
			fn: function(el) {
				var availID = Ext.getCmp('percentLoad_Chart').id;
				if (!Ext.isEmpty( 'availID')){
					if( availID != undefined && $('#'+availID+'-body').highcharts()!= undefined){
						$('#'+availID+'-body').highcharts().reflow();
					}
				}
			}
		}
    }

});