Ext.define('SAPPlatform.view.HanaInstances', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.hanainstances',
	id:'hanaInstances_Chart',

    initComponent: function() {
        var me = this;
        me.callParent();
    },
    padding: '0 0px 0 0' ,   
    itemSelector: 'div.thumb-wrap',

	setChartData: function(data) {
		var me = this;
		if(!Ext.isEmpty(data) && data['isChartAvailable']){
				$('#'+me.id+'-body').highcharts(me.chartProps(data['chartData']));
			
		}else{
			$('#'+me.id+'-body').html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>'+noMeasuresFoundMsg+'</div></div></div>');
		}
    },
	chartProps:function(data){
		var me = this;
		var series = data['DataSet'];
		var categories = data['xAxisLabel'];
		var colors = data['colors'];
		var title = data['Title'];
		var chartType = data['chartType'];

		var chartProps = {
			chart:{
				type:'column',
				marginTop:50,
			},
			title: {
				text:''
			},
			reflow:true,
			subtitle:{
				text:''
			},
			xAxis:{
				categories:categories,
				minorTickLength:0,
				tickLength:0,
				labels:{
					align:'right',
					enabled:true,
					rotation:-45,
					x:0,
					y:10,
					style:{
						color: strSkin=="Dark"?"#c0c0c0":"#969696",
						fontSize:'11px',
						fontFamily:'arial',
						fontWeight:'normal',
						lineHeight:'1.5em',
					},
				},
				gridLineWidth:0,
				gridLineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
				lineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
			},
			
			yAxis:[{
				min:0,
				minRange: 2,
				title:{
					text:''
				},
				labels:{
					style:{
						color: strSkin=="Dark"?"#c0c0c0":"#969696",
						fontSize:'11px',
						fontFamily:'arial',
						fontWeight:'normal',
						lineHeight:'1.5em',
					},
				},
				stackLabels:{
					enabled:false,
					style:{
						color:strSkin=="Dark"?"#c0c0c0":"#969696",
						fontSize:'11px',
						fontWeight:'normal'
					}
				},
				gridLineWidth:1,
				gridLineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
				lineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
				lineWidth:1,
			},{
				title:{
					text:''
				},
				opposite:true,
				gridLineWidth:1,
				gridLineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
				lineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
				lineWidth:1,
			}],
			exporting:{
				enabled:false
			},
			credits:{
				enabled:false
			},
			legend:{
				enabled:true
			},
			navigator:{
				enabled:false
			},
			legend:{
				align:'center',
				x:-5,
				verticalAlign:'top',
				y:-5,
				floating:true,
				borderColor:'#cccccc',
				borderWidth:0,
				shadow:false,
				itemStyle:{
					color:strSkin=="Dark"?"#c0c0c0":"#707070",
					fontSize:'11px',
					fontWeight:'normal',
					textOverflow:'ellipsis',
				},
				itemHoverStyle:{
					color:strSkin=="Dark"?"#c0c0c0":"#707070",
				},
				itemDistance:10,
				squareSymbol:false,
				symbolWidth:6,
				symbolHeight:6,
				symbolRadius:3,
			},
			tooltip:{
				split:false,
				distance:30,
				padding:5,
				headerFormat:'<b>{point.x}</b><br/>',
				pointFormat:'{series.name}: {point.y}'
			},
			plotOptions:{
				column: {
					pointPadding: 0,
					borderWidth: 0,
					dataLabels: {
						enabled: true,
							align: 'right',
							x:5,
							shadow: false,
						style: {
							color: strSkin=="Dark"?"#c0c0c0":"#969696",
							fontSize:'11px',
							fontFamily:'arial',
							fontWeight:'normal',
						},
					}
				}
			},
			series:series
		}
		return chartProps;
	},
	listeners: {
		resize: {
			fn: function(el) {
				var availID = Ext.getCmp('hanaInstances_Chart').id;
				if (!Ext.isEmpty( 'availID')){
					if( availID != undefined && $('#'+availID+'-body').highcharts()!= undefined){
						$('#'+availID+'-body').highcharts().reflow();
					}
				}
			}
		}
    }
  
});