Ext.define('SAPPlatform.view.InstanceThroughPut', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.instancethroughput',
	id: 'instanceThroughput_Chart',
	padding: '0 0px 0 0',

	setChartData: function(data) {
		var me = this;
		if(!Ext.isEmpty(data) && data['isChartAvailable']){
			$('#'+me.id+'-body').highcharts(me.chartProps(data['chartData']));			
		}else{
			$('#'+me.id+'-body').html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div class="newFont_normal11">'+noMeasuresFoundMsg+'</div></div></div>');
		}
    },
	chartProps:function(data){

		var me = this;
		var series = data['DataSet'];
		var categories = data['xAxisLabel'];
		var colors = data['colors'];
		var title = data['Title'];
		var chartType = data['chartType'];
		var unit = data['unit'];
		
		var chartProps = {
			chart: {
				type: 'bar',
				marginTop: 10
			},
			title: {
					text: ''
				},
				reflow: true,
				subtitle: {
					text: ''
				},
			xAxis: {
					categories: categories,
					minorTickLength: 0,
					tickLength: 0,
					labels: {
						style: {
							align:'center',
							color:  strSkin=="Dark"?"#c0c0c0":"#969696",
							fontSize: '11px',
							fontWeight: 'normal',
							whiteSpace: 'nowrap',
							overflow: 'hidden',
							textOverflow:'ellipsis'
						},
					},
					lineWidth: 0,
					gridLineWidth: 0,
					minorGridLineWidth: 0,
					tickWidth: 0,
					gridLineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
					lineColor: strSkin=="Dark"?"#666666":"#e5e5e5",

				}, 
			yAxis: [{
					minRange: 2,
					min: 0,
					title: {
						text: unit,
						 style: {
							color: strSkin=="Dark"?"#c0c0c0":"#969696"
						}

					},
					labels: {
						style: {
							color:  strSkin=="Dark"?"#c0c0c0":"#969696",
							fontSize: '11px',
							fontFamily: 'arial',
							fontWeight: 'normal',
							lineHeight: '1.5em',
						},
					},
					gridLineWidth: 1,
					minorGridLineWidth: 0,
					lineWidth: 1,
					gridLineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
					lineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
					minorGridLineWidth: 1,
					tickWidth: 0,
				}, {
					title: {
						text: ''
					},
					opposite: true,
					gridLineWidth: 1,
					gridLineColor: '#e5e5e5',
					lineColor: '#e5e5e5',
					lineWidth: 0,
				}],
				exporting: {
					enabled: false
				},
				credits: {
					enabled: false
				},
				legend: {
					enabled: false
				},
				navigator: {
					enabled: false
				},
				
				tooltip: {
					split: false,
					distance: 30,
					padding: 5,
					headerFormat: '<b>{point.x}</b>: {point.y}',
					pointFormat: ''
				},
				plotOptions: {
					bar: {
						cursor:'pointer',
						colorByPoint: true,     
						stacking: 'normal',
						borderWidth: 0,
						dataLabels: {
							enabled: true,
							align: 'right',
							x:35,
							shadow: false,
							color: strSkin=="Dark"?"#c0c0c0":"#2a2a2a",
							style: {
								color: 'contrast',
								fontSize: '11px',
								fontFamily: 'arial',
								fontWeight: 'normal',
								textOutline: '0px contrast',
							}
						},
						formatter: function() {
							if (this.y < 1) {
								return 5;
							} else {
								return this.y;
							}
						},
						point:{
							events: {	
								click : function(e) {
									if(!Ext.isEmpty(e.point))
									{
										var QString=e.point.linkUrl;
										goToLayerModel(QString);
									}
								}
							}
						}
					},
					series: {
						minPointLength: 2,
						maxPointWidth: 25,
						pointWidth: 13,
					},
			},
			legend: {
				enabled:false,
				layout: 'vertical',
				align: 'right',
				verticalAlign: 'top',
				x: -40,
				y: 80,
				floating: true,
				borderWidth: 1,
				backgroundColor: ((Highcharts.theme && Highcharts.theme.legendBackgroundColor) || '#FFFFFF'),
				shadow: true
			},
			credits: {
				enabled: false
			},
			 series: series
		}
		return chartProps;
	},

	listeners: {
		resize: {
			fn: function(el) {
				var availID = Ext.getCmp('instanceThroughput_Chart').id;
				if (!Ext.isEmpty( 'availID')){
					if( availID != undefined && $('#'+availID+'-body').highcharts()!= undefined){
						$('#'+availID+'-body').highcharts().reflow();
					}
				}
			}
		}
    }
     
});
