function chartabapCpu(id,chartData) {
	if(!Ext.isEmpty(chartData) && chartData['isChartAvailable'] )
	{
		var chartDataVal = chartData['DataSet'];
		var data=chartDataVal[0].data;
		var activityValData=[];
		for(i=0;i<data.length;i++)
		{
			activityValData.push({
				outerRadius: data[i].radius,
				innerRadius: data[i].innerRadius,
				shape: 'arc',
				backgroundColor: Highcharts.Color('#cccccc')
					.setOpacity(0.3)
					.get(),
				borderWidth: 0,
			});
		}
		var xAxisLabel = chartData['xAxisLabel'];
		var unit = chartData['unit'];
		Highcharts.chart(id, {
			chart: {
				type: 'solidgauge',
				marginBottom: 4 ,
			},
			title: {
				text: ''
			},
			subtitle: {
				text: ''
			},
			exporting: {
				enabled: false
			},
			credits: {
				enabled: false
			},
			legend: {
				enabled: false
			},
			navigator: {
				enabled: false
			},
			tooltip: {
				enabled: false,
				borderWidth: 0,
				backgroundColor: 'none',
				shadow: false,
				style: {
					fontSize: '16px'
				},
				pointFormat: '{series.name}<br><span style="font-size:1em; color: {point.color}; font-weight: bold">{point.y}%</span>',
				positioner: function(labelWidth) {
					var midPositionX = this.chart.plotSizeX;
					var midPositionY = this.chart.plotSizeY;
					return {
						x: (midPositionX / 2) - (labelWidth / 4),
						y: (midPositionY / 2) - 5,
					};
				}
			},
			pane: {
				startAngle: -180,
				endAngle: 90,
				background:activityValData,
			},
			yAxis: {
				min: 0,
				max: 100,
				startAngle: -180,
				endAngle: 90,
				lineWidth: 0,
				tickPositions: [],
			},
			plotOptions: {
				solidgauge: {
					dataLabels: {
						enabled: false
					},
					linecap: 'square',
					stickyTracking: false,
					rounded: false
				},
				series: {
					cursor: 'pointer',
					point: {
						events: {
							click: function() {
								var QString=this.options;
								if(QString!=null && QString.hasOwnProperty('layerTesturl'))
								{
									 var layerTesturl=QString['layerTesturl'];
									 if(layerTesturl!=null && layerTesturl!="-")
									 {					
										 goToLayerModel(layerTesturl);
									 }
								}
							}
						}
					}
				}
			},
			series:chartDataVal
		}, function callback() {

			var pos1 = this.axes[0].pane.center[0] + 10;
			var pos2 = this.axes[0].pane.center[1];
			
			var skinColor;

			if(strSkin=="Dark")
			{
			   skinColor = "#c0c0c0";
			}
			else
			{
				skinColor = "#969696";
			}

			var k=data.length;
			var topPosition=[];
			for(i=0; i<k;i++)
			{
				var self = this;
				topPosition[k-i] = (self.series[0].points[i].startR) + pos2;
				self.renderer.text('<span style="white-space:nowrap; text-overflow:ellipsis; overflow:hidden;color:'+skinColor+'">'+ self.series[0].data[i].name+'    '+self.series[0].data[i].value+'</span>')
				.attr({
					'font-size': '10px',
					'font-family': 'Arial',
					'color': '#969696',
					'data-qclass':'yellowTip',
					'zIndex': 10,
					'cursor':'default'
				})
				.translate(pos1, topPosition[k-i])
				.add(self.series[0].group);
			}
			topPosition=null;
		});
	}
	else{
		$('#abap_cpu').html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div class="f11-normal">'+noMeasuresFoundMsg+'</div></div></div>');
	}    
}

function chartabapMemory(id,chartData){
	
	if(!Ext.isEmpty(chartData) && chartData['isChartAvailable'] )
	{
		var xAxisLabel = chartData['xAxisLabel'];
		var unit = chartData['unit'];
		Highcharts.chart(id, {
			chart: {
				type: 'bar',
				marginTop: 28,
				marginBottom: 43
			},
			title: {
				text: ''
			},
			// colors: ['#6074a7', '#68cce6', '#fa9e87', '#f8e5c7', '#9cc9cc'],
			colors: ['#68cbe8', '#6074a7', '#fa9e87', '#f8e5c7', '#9cc9cc'],
			xAxis: {
				categories: xAxisLabel,
				lineColor:strSkin=="Dark"?"#c3c3c3":"#e1e1e1",
				labels: {
					style: {
						color: strSkin=="Dark"?"#c0c0c0":"#969696" ,
						fontSize: '10px',
						fontFamily: 'arial',
						fontWeight: 'normal',
					},
				},
				tickWidth: 0,
				minorGridLineWidth: 1,
			gridLineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
			lineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
			},
			tooltip: {
				split: false,
				distance: 30,
				padding: 5,
				headerFormat: '',
				pointFormat: '{point.name}: {point.y}'
			},

			yAxis: {
				min: 0,
				minRange: 2,
			   lineColor:strSkin=="Dark"?"#c3c3c3":"#e1e1e1",
				className: 'sapMemoryHighchartyaxis',
				visible: true,
				labels: {
					enabled: true,
					style: {
						color: strSkin=="Dark"?"#c3c3c3":"#969696",
						fontSize: '10px'
					},
					className: 'font_normal10',
				},
				 title: {
					text: unit,
					style: {
						fontSize: '11px',
						color: strSkin=="Dark"?"#c0c0c0":"#969696"
					}
				},
				lineWidth: 1,
				minorGridLineWidth: 1,
				gridLineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
				lineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
			},
			legend: {
				enabled: false
			},
			exporting: {
				enabled: false
			},
			credits: {
				enabled: false
			},
			plotOptions: {
				 series: {
					stacking: 'normal',
					borderColor: strSkin=="Dark"?"#404040":"#ffffff",
					pointWidth: 11,
					minPointLength: 5,
					cursor: 'pointer',
					point: {
						events: {
							click: function() {
								var QString=this.options;
								if(QString!=null && QString.hasOwnProperty('layerTesturl'))
								{
									 var layerTesturl=QString['layerTesturl'];
									 if(layerTesturl!=null && layerTesturl!="-")
									 {
										goToLayerModel(layerTesturl);
									 }
								}
							}
						}
					}
				},
				bar: {
					colorByPoint: true,
				}
			},
			series:chartData['DataSet']
		});
	}
	else{
		$('#abap_memory').html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div class="newFont_normal11">'+noMeasuresFoundMsg+'</div></div></div>');
	}
}

function chartabapStorage(id,chartData){

	if(!Ext.isEmpty(chartData) && chartData['isChartAvailable'] )
	{
		var xAxisLabel = chartData['xAxisLabel'];
		var unit = chartData['unit'];
		Highcharts.chart(id, {
			chart: {
				type: 'column',
				marginTop: 20,
				marginBottom:85
			},
			title: {
				text: ''
			},
			reflow: true,
			subtitle: {
				text: ''
			},
			xAxis: {
				categories:xAxisLabel,
				minorTickLength: 0,
				tickLength: 0,
				labels: {
					align: 'right',
					enabled: true,
					rotation: -45,
					x: 0,
					y: 10,
					 style: {
						color: strSkin=="Dark"?"#c3c3c3":"#969696",
						fontSize: '10px'
					},
					className: 'font_normal10',
				},
				lineWidth: 0,
				gridLineWidth: 0,
				minorGridLineWidth: 0,
				tickWidth: 0,

			},
			yAxis: [{
				min: 0,
				minRange: 2,
				title: {
					text: unit,
					 style: {
						fontSize: '11px',
						color: strSkin=="Dark"?"#c0c0c0":"#969696"
					}
				},
				labels: {
					 style: {
						color: strSkin=="Dark"?"#c3c3c3":"#969696",
						fontSize: '11px'
					},
					className: 'font_normal10',
				},
				stackLabels: {
					enabled: false,
					style: {
						fontWeight: 'bold',
						color: (Highcharts.theme && Highcharts.theme.textColor) || 'gray'
					}
				},
				gridLineWidth: 1,
				gridLineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
				minorGridLineWidth: 0,
				lineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
				lineWidth: 0,
				tickWidth: 0,
			}],
			colors: ['#94ccdb'],
			exporting: {
				enabled: false
			},
			credits: {
				enabled: false
			},
			legend: {
				enabled: false
			},
			navigator: {
				enabled: false
			},
			tooltip: {
				split: false,
				distance: 30,
				padding: 5,
				headerFormat: '',
				pointFormat: '{point.name}: {point.y}'
			},
			plotOptions: {
				column: {
					stacking: 'normal',
					borderWidth: 0,
					dataLabels: {
						enabled: false,
						shadow: false,
						color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'black',
						style: {
							color: 'contrast',
							fontSize: '11px',
							fontFamily: 'arial',
							fontWeight: 'normal',
							textOutline: '0px contrast',
						}
					}
				},
				series: {
					stacking: 'normal',
					maxPointWidth: 25,
					pointWidth: 15,
					/*cursor: 'pointer',
					point: {
						events: {
							click: function() {
								var QString=this.options;
								if(QString!=null && QString.hasOwnProperty('linkUrl'))
								{
									 var layerTesturl=QString['linkUrl'];
									 if(layerTesturl!=null && layerTesturl!="-")
									 {
										goToCompListPage(layerTesturl);
									 }
								}
							}
						}
					}*/
				},
			},
			series:chartData['DataSet']
		});
	}
	else{
		$('#abap_storage').html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div class="newFont_normal11">'+noMeasuresFoundMsg+'</div></div></div>');
	}
}

function chartjavaCpu(id,chartData) {

	if(!Ext.isEmpty(chartData) && chartData['isChartAvailable'] )
	{
		var chartDataVal = chartData['DataSet'];
		var data=chartDataVal[0].data;
		var activityValData=[];
		for(i=0;i<data.length;i++)
		{
			activityValData.push({
				outerRadius: data[i].radius,
				innerRadius: data[i].innerRadius,
				shape: 'arc',
				backgroundColor: Highcharts.Color('#cccccc')
					.setOpacity(0.3)
					.get(),
				borderWidth: 0,
			});
		}
		var xAxisLabel = chartData['xAxisLabel'];
		var unit = chartData['unit'];
		Highcharts.chart(id, {
			chart: {
				type: 'solidgauge',
				marginBottom: 4 ,
			},
			title: {
				text: ''
			},
			subtitle: {
				text: ''
			},
			exporting: {
				enabled: false
			},
			credits: {
				enabled: false
			},
			legend: {
				enabled: false
			},
			navigator: {
				enabled: false
			},
			tooltip: {
				enabled: false,
				borderWidth: 0,
				backgroundColor: 'none',
				shadow: false,
				style: {
					fontSize: '16px'
				},
				pointFormat: '{series.name}<br><span style="font-size:1em; color: {point.color}; font-weight: bold">{point.y}%</span>',
				positioner: function(labelWidth) {
					var midPositionX = this.chart.plotSizeX;
					var midPositionY = this.chart.plotSizeY;
					return {
						x: (midPositionX / 2) - (labelWidth / 4),
						y: (midPositionY / 2) - 5,
					};
				}
			},
			pane: {
				startAngle: -180,
				endAngle: 90,
				background:activityValData,
			},
			yAxis: {
				min: 0,
				max: 100,
				startAngle: -180,
				endAngle: 90,
				lineWidth: 0,
				tickPositions: [],
			},
			plotOptions: {
				solidgauge: {
					dataLabels: {
						enabled: false
					},
					linecap: 'square',
					stickyTracking: false,
					rounded: false
				},
				series: {
					cursor: 'pointer',
					point: {
						events: {
							click: function() {
								var QString=this.options;
								if(QString!=null && QString.hasOwnProperty('layerTesturl'))
								{
									 var layerTesturl=QString['layerTesturl'];
									 if(layerTesturl!=null && layerTesturl!="-")
									 {
										 goToLayerModel(layerTesturl);
									 }
								}
							}
						}
					}
				}
			},
			series:chartDataVal
		}, function callback() {

			var pos1 = this.axes[0].pane.center[0] + 10;
			var pos2 = this.axes[0].pane.center[1];
			
			var skinColor;

			if(strSkin=="Dark")
			{
			   skinColor = "#c0c0c0";
			}
			else
			{
				skinColor = "#969696";
			}

			var k=data.length;
			var topPosition=[];
			for(i=0; i<k;i++)
			{
				 topPosition[k-i] = (this.series[0].points[i].startR) + pos2;
				  this.renderer.text('<span style="white-space:nowrap; text-overflow:ellipsis; overflow:hidden;color:'+skinColor+'">'+ this.series[0].data[i].name+'    '+this.series[0].data[i].value+'</span>')
				.attr({
					'font-size': '10px',
					'font-family': 'Arial',
					'color': '#969696',
					'data-qclass':'yellowTip',
					'zIndex': 10,
					'cursor':'default'
				})
				.translate(pos1, topPosition[k-i])
				.add(this.series[0].group);
			}
			topPosition=null;
		});
	}
	else{
		$('#java_cpu').html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div class="f11-normal">'+noMeasuresFoundMsg+'</div></div></div>');
	}
}

function chartjavaMemory(id,chartData) {
	
	if(!Ext.isEmpty(chartData) && chartData['isChartAvailable'] )
	{
		var xAxisLabel = chartData['xAxisLabel'];
		var unit = chartData['unit'];
		Highcharts.chart(id, {
			chart: {
				type: 'bar',
				marginTop: 28,
				marginBottom: 43
			},
			title: {
				text: ''
			},
			//colors: ['#6074a7', '#68cce6', '#fa9e87', '#f8e5c7', '#9cc9cc'],
			colors: ['#68cbe8', '#6074a7', '#fa9e87', '#f8e5c7', '#9cc9cc'],
			xAxis: {
				categories: xAxisLabel,
				lineColor:strSkin=="Dark"?"#c3c3c3":"#e1e1e1",
				labels: {
					style: {
						color: strSkin=="Dark"?"#c0c0c0":"#969696" ,
						fontSize: '10px',
						fontFamily: 'arial',
						fontWeight: 'normal',
					},
				},
				tickWidth: 0,
				minorGridLineWidth: 1,
				gridLineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
				lineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
			},
			tooltip: {
				split: false,
				distance: 30,
				padding: 5,
				headerFormat: '',
				pointFormat: '{point.name}: {point.y}'
			},
			yAxis: {
				min: 0,
				minRange: 2,
				lineColor:strSkin=="Dark"?"#c3c3c3":"#e1e1e1",
				className: 'sapMemoryHighchartyaxis',
				visible: true,
				labels: {
					enabled: true,
					style: {
						color: strSkin=="Dark"?"#c3c3c3":"#969696",
						fontSize: '10px'
					},
					className: 'font_normal10',
				},
				 title: {
					text: unit,
					 style: {
						 fontSize: '11px',
						color: strSkin=="Dark"?"#c0c0c0":"#969696"
					}
				},
				lineWidth: 1,
				minorGridLineWidth: 1,
				gridLineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
				lineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
			},
			legend: {
				enabled: false
			},
			exporting: {
				enabled: false
			},
			credits: {
				enabled: false
			},
			plotOptions: {
				 series: {
					stacking: 'normal',
					borderColor: strSkin=="Dark"?"#404040":"#ffffff",
					pointWidth: 11,
					minPointLength: 5,
					/*cursor: 'pointer',
					point: {
						events: {
							click: function() {
								var QString=this.options;
								if(QString!=null && QString.hasOwnProperty('layerTesturl'))
								{
									 var layerTesturl=QString['layerTesturl'];
									 if(layerTesturl!=null && layerTesturl!="-")
									 {
										goToLayerModel(layerTesturl);
									 }
								}
							}
						}
					}*/
				},
				bar: {
					colorByPoint: true,
				}
			},
			series:chartData['DataSet']
		});
	}
	else{
		$('#java_memory').html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div class="newFont_normal11" >'+noMeasuresFoundMsg+'</div></div></div>');
	}
}

function chartjavaStorage(id,chartData) {

	if(!Ext.isEmpty(chartData) && chartData['isChartAvailable'] )
	{
		var xAxisLabel = chartData['xAxisLabel'];
		var unit = chartData['unit'];
		Highcharts.chart(id, {
			chart: {
				type: 'column',
				marginTop: 20,
				marginBottom:75
				
			},
			title: {
				text: ''
			},
			reflow: true,
			subtitle: {
				text: ''
			},
			xAxis: {
				categories:xAxisLabel,
				minorTickLength: 0,
				tickLength: 0,
				labels: {
					align: 'right',
					enabled: true,
					rotation: -45,
					x: 0,
					y: 10,
					 style: {
						color: strSkin=="Dark"?"#c3c3c3":"#969696",
						fontSize: '10px'
					},
					className: 'font_normal10',
				},
				lineWidth: 0,
				gridLineWidth: 0,
				minorGridLineWidth: 0,
				tickWidth: 0,
			},
			yAxis: [{
				min: 0,
				minRange: 2,
				title: {
					text: unit,
					 style: {
						fontSize: '11px',
						color: strSkin=="Dark"?"#c0c0c0":"#969696"
					}
				},
				labels: {
					 style: {
						color: strSkin=="Dark"?"#c3c3c3":"#969696",
						fontSize: '11px'
					},
					className: 'font_normal10',
				},
				stackLabels: {
					enabled: false,
					style: {
						fontWeight: 'bold',
						color: (Highcharts.theme && Highcharts.theme.textColor) || 'gray'
					}
				},
				gridLineWidth: 1,
				gridLineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
				minorGridLineWidth: 0,
				lineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
				lineWidth: 0,
				tickWidth: 0,
			}],
			colors: ['#94ccdb'],
			exporting: {
				enabled: false
			},
			credits: {
				enabled: false
			},
			legend: {
				enabled: false
			},
			navigator: {
				enabled: false
			},
			tooltip: {
				split: false,
				distance: 30,
				padding: 5,
				headerFormat: '',
				pointFormat: '{point.name}: {point.y}'
			},
			plotOptions: {
				column: {
					stacking: 'normal',
					borderWidth: 0,
					dataLabels: {
						enabled: false,
						shadow: false,
						color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'black',
						style: {
							color: 'contrast',
							fontSize: '11px',
							fontFamily: 'arial',
							fontWeight: 'normal',
							textOutline: '0px contrast',
						}
					}
				},
				series: {
					stacking: 'normal',
					maxPointWidth: 25,
					pointWidth: 15,
					/*cursor: 'pointer',
					point: {
						events: {
							click: function() {
								var QString=this.options;
								if(QString!=null && QString.hasOwnProperty('linkUrl'))
								{
									 var layerTesturl=QString['linkUrl'];
									 if(layerTesturl!=null && layerTesturl!="-")
									 {
										goToCompListPage(layerTesturl);
									 }
								}
							}
						}
					}*/
				},
			},
			series:chartData['DataSet']
		});
	}
	else{
		$('#java_storage').html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div class="newFont_normal11" >'+noMeasuresFoundMsg+'</div></div></div>');
	}
}

function chartbusinessCpu(id,chartData) {

	if(!Ext.isEmpty(chartData) && chartData['isChartAvailable'] )
	{
		var chartDataVal = chartData['DataSet'];
		var data=chartDataVal[0].data;
		var activityValData=[];
		for(i=0;i<data.length;i++)
		{
			activityValData.push({
				outerRadius: data[i].radius,
				innerRadius: data[i].innerRadius,
				shape: 'arc',
				backgroundColor: Highcharts.Color('#cccccc')
					.setOpacity(0.3)
					.get(),
				borderWidth: 0,
			});
		}
		var xAxisLabel = chartData['xAxisLabel'];
		var unit = chartData['unit'];
		Highcharts.chart(id, {
			chart: {
				type: 'solidgauge',
				marginBottom: 4 ,
			},
			title: {
				text: ''
			},
			subtitle: {
				text: ''
			},
			exporting: {
				enabled: false
			},
			credits: {
				enabled: false
			},
			legend: {
				enabled: false
			},
			navigator: {
				enabled: false
			},
			tooltip: {
				enabled: false,
				borderWidth: 0,
				backgroundColor: 'none',
				shadow: false,
				style: {
					fontSize: '16px'
				},
				pointFormat: '{series.name}<br><span style="font-size:1em; color: {point.color}; font-weight: bold">{point.y}%</span>',
				positioner: function(labelWidth) {
					var midPositionX = this.chart.plotSizeX;
					var midPositionY = this.chart.plotSizeY;
					return {
						x: (midPositionX / 2) - (labelWidth / 4),
						y: (midPositionY / 2) - 5,
					};
				}
			},
			pane: {
				startAngle: -180,
				endAngle: 90,
				background:activityValData,
			},
			yAxis: {
				min: 0,
				max: 100,
				startAngle: -180,
				endAngle: 90,
				lineWidth: 0,
				tickPositions: [],
			},
			plotOptions: {
				solidgauge: {
					dataLabels: {
						enabled: false
					},
					linecap: 'square',
					stickyTracking: false,
					rounded: false
				},
				series: {
					cursor: 'pointer',
					point: {
						events: {
							click: function() {
								var QString=this.options;
								if(QString!=null && QString.hasOwnProperty('layerTesturl'))
								{
									 var layerTesturl=QString['layerTesturl'];
									 if(layerTesturl!=null && layerTesturl!="-")
									 {
										 goToLayerModel(layerTesturl);
									 }
								}
							}
						}
					}
				}
			},
			series:chartDataVal
		}, function callback() {

			var pos1 = this.axes[0].pane.center[0] + 10;
			var pos2 = this.axes[0].pane.center[1];
			
			var skinColor;

			if(strSkin=="Dark")
			{
			   skinColor = "#c0c0c0";
			}
			else
			{
				skinColor = "#969696";
			}

			var k=data.length;
			var topPosition=[];
			for(i=0; i<k;i++)
			{
				 topPosition[k-i] = (this.series[0].points[i].startR) + pos2;
				 this.renderer.text('<span style="white-space:nowrap; text-overflow:ellipsis; overflow:hidden;color:'+skinColor+'">'+ this.series[0].data[i].name+'    '+this.series[0].data[i].value+'</span>')
				.attr({
					'font-size': '10px',
					'font-family': 'Arial',
					'color': '#969696',
					'data-qclass':'yellowTip',
					'zIndex': 10,
					'cursor':'default'
				})
				.translate(pos1, topPosition[k-i])
				.add(this.series[0].group);
			}
			topPosition=null;
		});
	}
	else{
		$('#business_cpu').html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div class="f11-normal" >'+noMeasuresFoundMsg+'</div></div></div>');
	}
}

function chartbusinessMemory(id,chartData){

	if(!Ext.isEmpty(chartData) && chartData['isChartAvailable'] )
	{
		var xAxisLabel = chartData['xAxisLabel'];
		var unit = chartData['unit'];
		Highcharts.chart(id, {
			chart: {
				type: 'bar',
				marginTop: 28,
				marginBottom: 43
			},
			title: {
				text: ''
			},
			colors: ['#6074a7', '#68cce6', '#fa9e87', '#f8e5c7', '#9cc9cc'],
			xAxis: {
				categories: xAxisLabel,
				labels: {
					style: {
						color: strSkin=="Dark"?"#c0c0c0":"#969696" ,
						fontSize: '10px',
						fontFamily: 'arial',
						fontWeight: 'normal',
					},
				},
				tickWidth: 0,
				minorGridLineWidth: 1,
				gridLineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
				lineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
			},
			tooltip: {
				split: false,
				distance: 30,
				padding: 5,
				headerFormat: '',
				pointFormat: '{point.name}: {point.y}'
			},
			yAxis: {
				minRange: 2,
				align: 'left',
				min: 0,
				minPadding:0.05,
				className: 'sapMemoryHighchartyaxis',
				visible: true,
				labels: {
					enabled: true,
					style: {
						color: strSkin=="Dark"?"#c3c3c3":"#969696",
						fontSize: '10px',
						align: 'left'
					},
					className: 'font_normal10',
				},
				title: {
					text: unit,
					style: {
						align: 'left',
						fontSize: '11px',
						color: strSkin=="Dark"?"#c0c0c0":"#969696"
					}
				},
				lineWidth: 1,
				minorGridLineWidth: 1,
				gridLineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
				lineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
				 
			},
			legend: {
				enabled: false
			},
			exporting: {
				enabled: false
			},
			credits: {
				enabled: false
			},
			plotOptions: {
					
				 series: {
					stacking: 'normal',
					borderColor: strSkin=="Dark"?"#404040":"#ffffff",
					pointWidth: 11,
					minPointLength: 5,
					style: { align: 'left'},
					/*cursor: 'pointer',
					point: {
						events: {
							click: function() {
								var QString=this.options;
								if(QString!=null && QString.hasOwnProperty('layerTesturl'))
								{
									 var layerTesturl=QString['layerTesturl'];
									 if(layerTesturl!=null && layerTesturl!="-")
									 {
										goToLayerModel(layerTesturl);
									 }
								}
							}
						}
					}*/
				},
				bar: {
					colorByPoint: true
				}
			},
			series:chartData['DataSet']
		});
	}
	else{
		$('#business_memory').html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div class="newFont_normal11" >'+noMeasuresFoundMsg+'</div></div></div>');
	}
}

function chartbusinessStorage(id,chartData) {
	if(!Ext.isEmpty(chartData) && chartData['isChartAvailable'] )
	{
		var xAxisLabel = chartData['xAxisLabel'];
		var unit = chartData['unit'];
		Highcharts.chart(id, {
			chart: {
				type: 'column',
				marginTop: 20,
				marginBottom:75
			},
			title: {
				text: ''
			},
			reflow: true,
			subtitle: {
				text: ''
			},
			xAxis: {
				categories:xAxisLabel,
				minorTickLength: 0,
				tickLength: 0,
				labels: {
					align: 'right',
					enabled: true,
					rotation: -45,

					x: 0,
					y: 10,
					 style: {
						color: strSkin=="Dark"?"#c3c3c3":"#969696",
						fontSize: '10px'
					},
					className: 'font_normal10',
				},
				lineWidth: 0,
				gridLineWidth: 0,
				minorGridLineWidth: 0,
				tickWidth: 0,
			},
			yAxis: [{
				min: 0,
				minRange: 2,
				title: {
					text: unit,
					 style: {
						fontSize: '11px',
						color: strSkin=="Dark"?"#c0c0c0":"#969696"
					}
				},
				labels: {
					 style: {
						color: strSkin=="Dark"?"#c3c3c3":"#969696",
						fontSize: '11px'
					},
					className: 'font_normal10',
				},
				stackLabels: {
					enabled: false,
					style: {
						fontWeight: 'bold',
						color: (Highcharts.theme && Highcharts.theme.textColor) || 'gray'
					}
				},
				gridLineWidth: 1,
				gridLineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
				minorGridLineWidth: 0,
				lineColor: strSkin=="Dark"?"#666666":"#e5e5e5",
				lineWidth: 0,
				tickWidth: 0,
			}],
			colors: ['#94ccdb'],
			exporting: {
				enabled: false
			},
			credits: {
				enabled: false
			},
			legend: {
				enabled: false
			},
			navigator: {
				enabled: false
			},
			tooltip: {
				split: false,
				distance: 30,
				padding: 5,
				headerFormat: '',
				pointFormat: '{point.name}: {point.y}'
			},
			plotOptions: {
				column: {
					stacking: 'normal',
					borderWidth: 0,
					dataLabels: {
						enabled: false,
						shadow: false,
						color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'black',
						style: {
							color: 'contrast',
							fontSize: '11px',
							fontFamily: 'arial',
							fontWeight: 'normal',
							textOutline: '0px contrast',
						}
					}
				},
				series: {
					stacking: 'normal',
					maxPointWidth: 25,
					pointWidth: 15,
					/*cursor: 'pointer',
					point: {
						events: {
							click: function() {
								var QString=this.options;
								if(QString!=null && QString.hasOwnProperty('linkUrl'))
								{
									 var layerTesturl=QString['linkUrl'];
									 if(layerTesturl!=null && layerTesturl!="-")
									 {
										goToCompListPage(layerTesturl);
									 }
								}
							}
						}
					}*/
				},
			},
			series:chartData['DataSet']
		});
	}
	else{
		$('#business_storage').html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div class="newFont_normal11" >'+noMeasuresFoundMsg+'</div></div></div>');
	}
}


Ext.require('Ext.grid.column.Template', function() {
    Ext.override(Ext.grid.column.Template, {
        constructor: function(cfg) {
            this.callParent(arguments);
            var tpl = (!Ext.isPrimitive(this.tpl) && this.tpl.compile) ? this.tpl : new Ext.XTemplate(this.tpl);
            this.renderer = function(value, p, r, rowIndex, colIndex) {
                var newData = Ext.apply({
                    rowIndex: rowIndex,
                    colIndex: colIndex
                }, r.data);
                return tpl.apply(newData);
            };

            this.tpl = tpl;

        }
    })
});

Ext.define('SAPPlatform.view.LoadGridContainer', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.loadgridcontainer',
	id:'gridContainerId',
    enableCtxMenu: false,  // turn off header context menu
    enableColumnMove: false,  // turn off column reorder drag drop
    enableColumnResize: false,  // turn off column resize for whole grid
	loadChartData: function() {

        var me = this;
		var data = me.store.data.items;
		 Ext.Array.each(data, function(name, index, data) {

			if (!Ext.isEmpty(name.data.abapsystems[0]['chartId'])) {

				if (name.data.abapsystems[0]['chartId'] != undefined) {

					if (name.data.abapsystems[0]['chartId'] == "abap_cpu") {
		
						var chartNameCPU = name.data.abapsystems[0]['chartId']; 
						var chartDataCPU = name.data.abapsystems[0]['gaugeData'][0];
						Ext.defer(function(){
							chartabapCpu(chartNameCPU,chartDataCPU);
						},50);
					}
					if (name.data.abapsystems[0]['chartId'] == "abap_memory") {
						
						var chartName1 = name.data.abapsystems[0]['chartId']; 
						var chartData1 = name.data.abapsystems[0]['chartData'];
						
						Ext.defer(function(){
							chartabapMemory(chartName1,chartData1);
						},50);
					}
					if (name.data.abapsystems[0]['chartId'] == "abap_storage") {

						var chartNameS = name.data.abapsystems[0]['chartId']; 
						var chartDataS = name.data.abapsystems[0]['chartData'];

						Ext.defer(function(){
							chartabapStorage(chartNameS,chartDataS);
						},50);
					}
				}
			}
			if (!Ext.isEmpty(name.data.javainstances[0]['chartId'])) {

				if (name.data.javainstances[0]['chartId'] != undefined) {

					if (name.data.javainstances[0]['chartId'] == "java_cpu") {

						var javaChartName = name.data.javainstances[0]['chartId']; 
						var javaChartData = name.data.javainstances[0]['gaugeData'][0];
						
						Ext.defer(function(){
							chartjavaCpu(javaChartName,javaChartData);
						},50);
					}
					if (name.data.javainstances[0]['chartId'] == "java_memory") {
						
						var chartName = name.data.javainstances[0]['chartId']; 
						var chartData = name.data.javainstances[0]['chartData']; 

						 Ext.defer(function(){
							  chartjavaMemory(chartName,chartData);
							},50);
					}
					if (name.data.javainstances[0]['chartId'] == "java_storage") {
						
						var chartNamej = name.data.javainstances[0]['chartId']; 
						var chartDataj = name.data.javainstances[0]['chartData'];

						Ext.defer(function(){
							chartjavaStorage(chartNamej,chartDataj);
						},50);
					}
				}
			}
			
			if (!Ext.isEmpty(name.data.businessobjects[0]['chartId'])) {

				if (name.data.businessobjects[0]['chartId'] != undefined) {

					if (name.data.businessobjects[0]['chartId'] == "business_cpu") {

						var BoEChartName = name.data.businessobjects[0]['chartId']; 
						var BoEChartData = name.data.businessobjects[0]['gaugeData'][0];
						
						Ext.defer(function(){
							chartbusinessCpu(BoEChartName,BoEChartData);
						},50);
					}
					
					if (name.data.businessobjects[0]['chartId'] == "business_memory") {

						var chartNameB = name.data.businessobjects[0]['chartId']; 
						var chartDataB = name.data.businessobjects[0]['chartData']; 

						Ext.defer(function(){
							chartbusinessMemory(chartNameB,chartDataB);
						},50);
					}
					
					if (name.data.businessobjects[0]['chartId'] == "business_storage") {

						var chartName5 = name.data.businessobjects[0]['chartId']; 
						var chartData5 = name.data.businessobjects[0]['chartData']; 

						Ext.defer(function(){
							chartbusinessStorage(chartName5,chartData5);
						},50);
					}
				}
			}
		})
	},
    initComponent: function() {
        var me = this;
		me.mon(me, 'resize', function() {
			var data = me.store.data.items;
			 Ext.Array.each(data, function(name, index, data) {

				if (!Ext.isEmpty(name.data.abapsystems[0]['chartId'])) {

					if (name.data.abapsystems[0]['chartId'] != undefined) {

						if (name.data.abapsystems[0]['chartId'] == "abap_cpu") {
			
							var chartNameCPU = name.data.abapsystems[0]['chartId']; 
							var chartDataCPU = name.data.abapsystems[0]['gaugeData'][0];
							Ext.defer(function(){
								chartabapCpu(chartNameCPU,chartDataCPU);
							},50);
						}
						if (name.data.abapsystems[0]['chartId'] == "abap_memory") {
							
							var chartName1 = name.data.abapsystems[0]['chartId']; 
							var chartData1 = name.data.abapsystems[0]['chartData'];
							
							Ext.defer(function(){
								chartabapMemory(chartName1,chartData1);
							},50);
						}
						if (name.data.abapsystems[0]['chartId'] == "abap_storage") {

							var chartNameS = name.data.abapsystems[0]['chartId']; 
							var chartDataS = name.data.abapsystems[0]['chartData'];

							Ext.defer(function(){
								chartabapStorage(chartNameS,chartDataS);
							},50);
						}
					}
				}
				if (!Ext.isEmpty(name.data.javainstances[0]['chartId'])) {

					if (name.data.javainstances[0]['chartId'] != undefined) {

						if (name.data.javainstances[0]['chartId'] == "java_cpu") {

							var javaChartName = name.data.javainstances[0]['chartId']; 
							var javaChartData = name.data.javainstances[0]['gaugeData'][0];
							
							Ext.defer(function(){
								chartjavaCpu(javaChartName,javaChartData);
							},50);
						}
						if (name.data.javainstances[0]['chartId'] == "java_memory") {
							
							var chartName = name.data.javainstances[0]['chartId']; 
							var chartData = name.data.javainstances[0]['chartData']; 

							 Ext.defer(function(){
								  chartjavaMemory(chartName,chartData);
								},50);
						}
						if (name.data.javainstances[0]['chartId'] == "java_storage") {
							
							var chartNamej = name.data.javainstances[0]['chartId']; 
							var chartDataj = name.data.javainstances[0]['chartData'];

							Ext.defer(function(){
								chartjavaStorage(chartNamej,chartDataj);
							},50);
						}
					}
				}
				
				if (!Ext.isEmpty(name.data.businessobjects[0]['chartId'])) {

					if (name.data.businessobjects[0]['chartId'] != undefined) {

						if (name.data.businessobjects[0]['chartId'] == "business_cpu") {

							var BoEChartName = name.data.businessobjects[0]['chartId']; 
							var BoEChartData = name.data.businessobjects[0]['gaugeData'][0];
							
							Ext.defer(function(){
								chartbusinessCpu(BoEChartName,BoEChartData);
							},50);
						}
						
						if (name.data.businessobjects[0]['chartId'] == "business_memory") {

							var chartNameB = name.data.businessobjects[0]['chartId']; 
							var chartDataB = name.data.businessobjects[0]['chartData']; 

							Ext.defer(function(){
								chartbusinessMemory(chartNameB,chartDataB);
							},50);
						}
						
						if (name.data.businessobjects[0]['chartId'] == "business_storage") {

							var chartName5 = name.data.businessobjects[0]['chartId']; 
							var chartData5 = name.data.businessobjects[0]['chartData']; 

							Ext.defer(function(){
								chartbusinessStorage(chartName5,chartData5);
							},50);
						}
					}
				}
			});
        },me)
        me.callParent();
    },
    cls: '',
    width: '100%',
    padding: "0 10px 10px 10px",
    margin: 0,
    ui: ' headerTextWrap  LoadGridContainer',
    title: '',
    columnLines: true,
    disableSelection: true,
    viewConfig:{
    },
    store: Ext.create('Ext.data.Store', {
        fields: ['abapsystems', 'javainstances', 'businessobjects'],
        data: []
    }),
    columns: [
        {
            text: '<div class="font_bold11" style="text-align:left; padding-left:14px; ">'+ABAP_SYSTEMS+'</div>',
            minWidth: 66,
             menuDisabled :true,
             resizable : false,
             sortable : false,
            dataIndex: 'abapsystems',
            align: 'center',
            xtype: 'templatecolumn',
            tdCls:'templategridColumn bgGrid',

            tpl: new Ext.XTemplate(
                '<div >',
                '<tpl for="abapsystems">',
                '<tpl if="typex == \'table\'">',
                
                '<tpl if="tableabapdata">',
                '<tpl for="header">',
                '<div class="sapLoadHeaderTitle">',
                    '<div class="sapLoadTitleBox">',
                        '<div class="{iconimage}" ></div>',
                        '<div style="position:relative;">',
                            '<div class="newFont_bold13 sapLoadIconText">{iconText}</div>',
                            '<div class="sapLoadBorderLine"></div>',
                        '</div>',
                    '</div>',
                '</div>',
                '</tpl>',
					'<tpl if="tableabapdata == \'-\'">',
						'<div style="padding: 14px 6px 6px 6px;">',
							'<div class="innerLoad-table" style="position:relative">',
								'<span class="sapLoadBorder"></span>',
									'<div class="newFont_normal12" style="text-align:left;margin-bottom:5px;">{title}</div>',
								'<div style="height:126px;" class="abapsystems"  >',
									'<table border="1" style="width:100%;" class="sapResponseTable">',
										'<div style="height:100%;width:100%;display:table">',
											'<div  class="msgFont" style="display:table-cell;vertical-align:middle">',
												'<div class="iconInformation" style="margin:0px auto"></div>',
												'<div style="text-align:center" class="newFont_normal11">'+noMeasuresFoundMsg+'</div>',
											'</div>',
										'</div>',
									'</table>',
								'</div>',
							'</div>',
					'</div>',
				'<tpl else>',
					'<div style="padding: 14px 6px 6px 6px;">',
						'<div class="innerLoad-table" style="position:relative">',
							'<span class="sapLoadBorder"></span>',
								'<div class="newFont_normal12" style="text-align:left;margin-bottom:5px;">{title}</div>',
								'<div style="height:126px;" class="abapsystems" >',
								'<table border="1" style="width:100%;" class="sapResponseTable">',
									'<tpl for="tableabapdata">',
				'<tr><td class="font_bold11 sapRightBorder" style="padding:7px 7px 7px 10px; border-right:0px; ">{name}</td><td  class="font_bold11"  style="padding:7px 7px 7px 10px;border-left:0px;" align="right"><tpl if="serverResponseTime != \'-\'">',
				'<a href="javascript:void(0);" onclick=\'javascript:goToLayerModel("{layerTesturl}");\'  >{serverResponseTime}</a><tpl else>',
					'{serverResponseTime}</tpl></td></tr>',
									'</tpl>',
								'</table>',
							'</div>',
						'</div>',
					'</div>',
				'</tpl>',
                '<tpl elseif="tablejavadata">',
                    '<div style="padding: 14px 6px 6px 6px" >',
                        '<div class="innerLoad-table" style="position:relative">',
                            '<span class="sapLoadBorder"></span>',
                             '<div class="newFont_normal12" style="text-align:left;margin-bottom:5px;">{title}</div>',
                            '<div style="height:126px;" class="abapsystems">',
                                '<table border="1" style="width:100%;" class="sapResponseTable">',
                                '<tpl for="tablejavadata">',
                                '<tr><td class="font_bold11" style="padding:7px 7px 7px 10px; border-right:0px; ">{name}</td><td  class="font_bold11"  style="padding:7px 7px 7px 10px;border-left:0px;" align="right">{serverResponseTime}</td></tr>',
                                '</tpl>',
                                '</table>',
                            '</div>',
                        '</div>',
                    '</div>',
                '<tpl elseif="tablebusinessdata">',   
                    '<div style="padding: 14px 6px 6px 6px" >',
                        '<div class="innerLoad-table" style="position:relative">',
                            '<span class="sapLoadBorder"></span>',
                            '<div class="newFont_normal12" style="text-align:left;margin-bottom:5px;">{title}</div>',
                            '<div style="height:126px;" class="abapsystems">',
                                '<table border="1" style="width:100%;" class="sapResponseTable">',
                                '<tpl for="tablebusinessdata">',
                                '<tr><td class="font_bold11" style="padding:7px 7px 7px 10px; border-right:0px; ">{name}</td><td  class="font_bold11"  style="padding:7px 7px 7px 10px;border-left:0px;" align="right">{serverResponseTime}</td></tr>',
                                '</tpl>',
                                '</table>',
                            '</div>',
                        '</div>',
                    '</div>',
                '</tpl>',
                '<tpl elseif="typex == \'guagechart\'">',
                 '<tpl for="header">',
                '<div class="sapLoadHeaderTitle">',
                    '<div class="sapLoadTitleBox">',
                        '<div class="{iconimage}" ></div>',
                        '<div style="position:relative;">',
                            '<div class="newFont_bold13 sapLoadIconText">{iconText}</div>',
                            '<div class="sapLoadBorderLine"></div>',
                        '</div>',
                    '</div>',
                '</div>',
                '</tpl>',
                '<div style="padding:0">',
                    '<div style="position:relative">',
                        '<div id={chartId} style="height:172px"></div>',
                            '<div class="sapLoadBorder1" >',
                                '<div style="position:relative; padding: 15px 0; height:100%;" >',
                                        '<span class="sapLoadGauageBorder" ></span>',
                                '</div>',
                            '</div>',
                    '</div>',
                '</div>', 
                 '<tpl elseif="typex == \'columnchart\'">',
                '<tpl for="header">',
                '<div class="sapLoadHeaderTitle">',
                    '<div class="sapLoadTitleBox">',
                        '<div class="{iconimage}" ></div>',
                        '<div style="position:relative;">',
                            '<div class="newFont_bold13 sapLoadIconText">{iconText}</div>',
                            '<div class="sapLoadBorderLine"></div>',
                        '</div>',
                    '</div>',
                '</div>',
                '</tpl>',
                '<div style="padding:0 0 4px 0">',
                    '<div style="position:relative">',
                        '<div id={chartId} style="height:172px"></div>',
                            '<div class="sapLoadBorder1" >',
                                '<div style="position:relative; padding: 27px 0; height:100%;" >',
                                        '<span class="sapLoadColumnBorder" ></span>',
                                '</div>',
                            '</div>',
                    '</div>',
                '<tpl elseif="typex == \'barchart\'">',
                '<tpl for="header">',
                '<div class="sapLoadHeaderTitle">',
                    '<div class="sapLoadTitleBox">',
                        '<div class="{iconimage}" ></div>',
                        '<div style="position:relative;">',
                            '<div class="newFont_bold13 sapLoadIconText">{iconText}</div>',
                            '<div class="sapLoadBorderLine"></div>',
                        '</div>',
                    '</div>',
                '</div>',
                '</tpl>', 
                '<div style="padding:0">',
                    '<div style="position:relative">',
                        '<div id={chartId} style="height:226px"></div>',
                            '<div class="sapLoadBorder1" >',
                                '<div style="position:relative; padding: 20px 0; height:100%;" >',
                                        '<span class="sapLoadBarBorder" ></span>',
                                '</div>',
                            '</div>',
                    '</div>',
                 '</div>',
                '</tpl>',
                '</tpl>',
                '</div>'
            ),
            flex: 1
        },
        {
            text: '<div class="font_bold11" style="text-align:left;  padding-left:8px;">'+JAVA_INSTANCES+'</div>',
            minWidth: 80,
            dataIndex: 'javainstances',
            align: 'center',
             menuDisabled :true,
             resizable : false,
             sortable : false,
            xtype: 'templatecolumn',
            tdCls:'templategridColumn bgGrid',
            tpl: new Ext.XTemplate(
                '<div >',
                '<tpl for="javainstances">',
                '<tpl if="typex == \'table\'">',
                '<tpl if="tableabapdata">',
                '<tpl for="header">',
                '<div class="{iconimage}" ></div><div><div class="newFont_bold13 sapLoadIconText">{iconText}</div><div class="sapLoadBorderLine"></div></div></div>',
                '</div>',
                '</tpl>',
                '<div style="padding: 14px 6px 6px 6px">',
                '<div class="innerLoad-table" style="position:relative">',
                '<span class="sapLoadBorder"></span>',
                '<div class="newFont_normal12" style="text-align:left;margin-bottom:5px;">{title}</div>',
                '<div style="" class="abapsystems">',
                
                '<table border="1" style="width:100%;" class="sapResponseTable">',
                '<tpl for="tableabapdata">',
                '<tr><td class="font_bold11 SAPSystemsborder" style="padding:7px 7px 7px 10px; border-right:0px; ">{name}</td><td  class="font_bold11"  style="padding:7px 7px 7px 10px;border-left:0px;" align="right">{serverResponseTime}</td></tr>',
                '</tpl>',
                '</table>',
                '</div>',
                '</div>',
                '</div>',
                '<tpl elseif="tablejavadata">',
					'<tpl if="tablejavadata == \'-\'">',
						'<div style="padding: 14px 6px 6px 6px;">',
							'<div class="innerLoad-table" style="position:relative">',
								'<span class="sapLoadBorder"></span>',
									'<div class="newFont_normal12" style="text-align:left;margin-bottom:5px;">{title}</div>',
								'<div style="height:126px;" class="abapsystems"  >',
									'<table border="1" style="width:100%;" class="sapResponseTable">',
										'<div style="height:100%;width:100%;display:table">',
											'<div  class="msgFont" style="display:table-cell;vertical-align:middle">',
												'<div class="iconInformation" style="margin:0px auto"></div>',
												'<div style="text-align:center" class="newFont_normal11">'+noMeasuresFoundMsg+'</div>',
											'</div>',
										'</div>',
									'</table>',
								'</div>',
							'</div>',
						'</div>',
                 '<tpl else>',
                '<div style="padding: 14px 6px 6px 6px">',
                '<div class="innerLoad-table" style="position:relative">',
                '<span class="sapLoadBorder"></span>',
                '<div class="newFont_normal12" style="text-align:left;margin-bottom:5px;">{title}</div>',
                '<div style="height:126px;" class="abapsystems">',
                '<table border="1" style="width:100%;" class="sapResponseTable">',
                '<tpl for="tablejavadata">',
                '<tr><td class="font_bold11" style="padding:7px 7px 7px 10px; border-right:0px; ">{name}</td><td  class="font_bold11"  style="padding:7px 7px 7px 10px;border-left:0px;" align="right"><tpl if="layerTesturl != \'-\'">',
				'<tpl if="serverResponseTime != \'-\'">',
				'<a href="javascript:void(0);" onclick=\'javascript:goToLayerModel("{layerTesturl}");\'  >{serverResponseTime}</a><tpl else>',
					'{serverResponseTime}</tpl></td></tr>',
					'<tpl else>',
					'{serverResponseTime}</tpl></td></tr>',
                '</tpl>',           
                '</table>',
                '</div>',
                '</div>',
                '</div>',
				'</tpl>',
                '<tpl elseif="tablebusinessdata">',
                '<div style="padding: 14px 6px 6px 6px">',
                '<div class="innerLoad-table" style="position:relative">',
                '<span class="sapLoadBorder"></span>',
                '<div class="newFont_normal12" style="text-align:left;margin-bottom:5px;">{title}</div>',
                '<div style="" class="abapsystems">',
                '<table border="1" style="width:100%;" class="sapResponseTable">',
                '<tpl for="tablebusinessdata">',
                '<tr><td class="font_bold11" style="padding:7px 7px 7px 10px; border-right:0px; ">{name}</td><td  class="font_bold11"  style="padding:7px 7px 7px 10px;border-left:0px;" align="right">{serverResponseTime}</td></tr>',
                '</tpl>',
                '</table>',
                '</div>',
                '</div>',
                '</div>',
                '</tpl>',
                '<tpl elseif="typex == \'guagechart\'">',
                '<div style="padding:0">',
                    '<div style="position:relative">',
                        '<div id={chartId} style="height:172px"></div>',
                            '<div class="sapLoadBorder1" >',
                                '<div style="position:relative; padding: 15px 0; height:100%;" >',
                                        '<span class="sapLoadGauageBorder" ></span>',
                                '</div>',
                            '</div>',
                    '</div>',
                '</div>',
                '<tpl elseif="typex == \'columnchart\'">',
                '<div style="padding:0 0 4px 0">',
                    '<div style="position:relative">',
                        '<div id={chartId} style="height:172px"></div>',
                            '<div class="sapLoadBorder1" >',
                                '<div style="position:relative; padding: 27px 0; height:100%;" >',
                                        '<span class="sapLoadColumnBorder" ></span>',
                                '</div>',
                            '</div>',
                    '</div>',
                '</div>',
                '<tpl elseif="typex == \'barchart\'">',
                '<div style="padding:0">',
                    '<div style="position:relative">',
                        '<div id={chartId} style="height:226px"></div>',
                            '<div class="sapLoadBorder1" >',
                                '<div style="position:relative; padding: 20px 0; height:100%;" >',
                                        '<span class="sapLoadBarBorder" ></span>',
                                '</div>',
                            '</div>',
                    '</div>',
                 '</div>',
                '</tpl>',
                '</tpl>',
                '</div>'
            ),
            flex: 1
        },
        {
            text: '<div class="font_bold11" style="text-align:left;  padding-left:8px;">'+BUSINESS_OBJECTS_NODES+'</div>',
            minWidth: 100,
            dataIndex: 'businessobjects',
            align: 'center',
             menuDisabled :true,
             resizable : false,
             sortable : false,  
            xtype: 'templatecolumn',
            tdCls:'templategridColumn bgGrid',
            tpl: new Ext.XTemplate(
                '<div>',
                '<tpl for="businessobjects">',
                '<tpl if="typex == \'table\'">',
                '<tpl if="tableabapdata">',
                '<div style="padding: 14px 6px 6px 6px">',
                '<div class="newFont_normal12" style="text-align:left;margin-bottom:5px;">{title}</div>',
                '<div style="" class="abapsystems">',
                '<table border="1" style="width:100%;" class="sapResponseTable">',
                '<tpl for="tableabapdata">',
                '<tr><td class="font_bold11" style="padding:7px 7px 7px 10px; border-right:0px; ">{name}</td><td  class="font_bold11"  style="padding:7px 7px 7px 10px;border-left:0px;" align="right">{serverResponseTime}</td></tr>',
                '</tpl>',
                '</table>',
                '</div>',
                '</div>',
                '<tpl elseif="tablejavadata">',
                '<div style="padding: 14px 6px 6px 6px">',
                '<div class="newFont_normal12" style="text-align:left;margin-bottom:5px;">{title}</div>',
                '<div style="height:126px;" class="abapsystems">',
                '<table border="1" style="width:100%;" class="sapResponseTable">',
                '<tpl for="tablejavadata">',
                '<tr><td class="font_bold11" style="padding:7px 7px 7px 10px; border-right:0px; ">{name}</td><td  class="font_bold11"  style="padding:7px 7px 7px 10px;border-left:0px;" align="right">{serverResponseTime}</td></tr>',
                '</tpl>',
                '</table>',
                '</div>',
                '</div>',
                '<tpl elseif="tablebusinessdata">',
					'<tpl if="tablebusinessdata == \'-\'">',
						'<div style="padding: 14px 6px 6px 6px;">',
							'<div class="innerLoad-table" style="position:relative">',
								 '<div class="newFont_normal12" style="text-align:left;margin-bottom:5px;">{title}</div>',
								'<div style="height:126px;" class="abapsystems"  >',
									'<table border="1" style="width:100%;" class="sapResponseTable">',
										'<div style="height:100%;width:100%;display:table">',
											'<div  class="msgFont" style="display:table-cell;vertical-align:middle">',
												'<div class="iconInformation" style="margin:0px auto"></div>',
												'<div style="text-align:center" class="newFont_normal11" >'+noMeasuresFoundMsg+'</div>',
											'</div>',
										'</div>',
									'</table>',
								'</div>',
							'</div>',
						'</div>',
					'<tpl else>',
                '<div style="padding: 14px 6px 6px 6px">',
                '<div class="newFont_normal12" style="text-align:left;margin-bottom:5px;">{title}</div>',
                '<div style="height:126px;" class="abapsystems">',
                '<table border="1" style="width:100%;" class="sapResponseTable">',
                '<tpl for="tablebusinessdata">',
                '<tr><td class="font_bold11" style="padding:7px 7px 7px 20px; border-right:0px; ">{name}</td><td  class="font_bold11"  style="padding:7px 7px 7px 20px;border-left:0px;" align="right"><tpl if="layerTesturl != \'-\'">',
				'<tpl if="serverResponseTime != \'-\'">',
				'<a href="javascript:void(0);" onclick=\'javascript:goToLayerModel("{layerTesturl}");\'  >{serverResponseTime}</a><tpl else>',
					'{serverResponseTime}</tpl></td></tr>',
				'<tpl else>',
					'{serverResponseTime}</tpl></td></tr>',
                '</tpl>',
                '</table>',
                '</div>',
                '</div>',
                '</tpl>',
				'</tpl>',
                '<tpl elseif="typex == \'guagechart\'">',
                '<div style="padding:0">',
                '<div id={chartId} style="height:172px"></div></div>',
                '<tpl elseif="typex == \'columnchart\'">',
                '<div style="padding:0 0 4px 0">',
                    '<div style="position:relative">',
                        '<div id={chartId} style="height:172px"></div>',   
                    '</div>',
                '<tpl elseif="typex == \'barchart\'">',
                '<div style="padding:0">',
                    '<div style="position:relative">',
                        '<div id={chartId} style="height:226px"></div>',    
                    '</div>',
                 '</div>',
                '</tpl>',
                '</tpl>',
                '</div>'
            ),
            flex: 1
        }
    ]
	
});

