Ext.define('SAPPlatform.view.TrexSearchesperMinute', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.trexsearchesperminute',
	id: 'trexSearch_Chart',
    initComponent: function() {
        var me = this;
        me.callParent();
    },
    padding: '0 10px 0px 10px',
    title:'',
    itemSelector: 'div.thumb-wrap',
    setChartData: function(data) {
		var me = this;
		if(!Ext.isEmpty(data)){
				$('#'+me.id+'-body').highcharts(me.chartProps(data));
		}else{
			$('#'+me.id+'-body').html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>'+noMeasuresFoundMsg+'</div></div></div>');
		}
	},

	chartProps:function(data){
		var me = this;
		var series = data['pieDataJsonData']['DataSet'];
		var isDataLableEnabled = data['needDataLable'];
		var chartProps = {
			chart: {
				renderTo: 'container',
				type: 'pie'
			},
			title : '',
			exporting: {
				enabled: false
			},
			credits: {
				enabled: false
			},
			tooltip: {
				enabled: isDataLableEnabled,
				pointFormat: ': <span style="color:{point.color}">{point.y}</span> '
			},
			plotOptions: {
				pie: {
					borderColor:  strSkin=="Dark"?"#404040":"#ffffff",
					borderWidth: 2,
					size: '95%',
					innerSize: '73%',
					dataLabels: {
						distance: 10,
						enabled:isDataLableEnabled,
						format: '{point.name} <br /> {point.percentage:.1f} %',
						connectorColor: strSkin=="Dark"?"#909090":"#969696",
						style: {
							color:  strSkin=="Dark"?"#c0c0c0":"#969696",
							fontWeight: 'normal',
							fontSize: '10px',
							textShadow: false,
							textOutline : '0px contrast' 
						}
					},
					tooltip: {
						valueDecimals: 4,
						pointFormat: '<span style="color:{point.color}">{point.percentage:.1f}</span> '
				   }
				}
			},   
			series: series
		}
		return chartProps;
	},
	listeners: {
		resize: {
			fn: function(el) {
				var availID = Ext.getCmp('trexSearch_Chart').id;
				if (!Ext.isEmpty( 'availID')){
					if( availID != undefined && $('#'+availID+'-body').highcharts()!= undefined){
						$('#'+availID+'-body').highcharts().reflow();
					}
				}
			}
		}
    }

});