	Ext.define('SystemList.view.Main', {
		extend: 'Ext.panel.Panel',
		//extend: 'utilities.OuterPanel',
		alias: 'widget.main',
		margin: '8 8 0 8',
		frame: true,
		//padding: '0',
		cls: 'outerpanel',
		//bodyPadding: '0',
		autoScroll: false,
		requires: [
				'utilities.Utilities',
				'utilities.EmptyPanel',
				'utilities.Settings',
				'utilities.CommonPanel',
				'utilities.ScrollCombo',
				'utilities.CommonBackButton',
				'SystemList.view.SystemListForm',
				'SystemList.view.SystemListTree',
				'SystemList.view.SystemComponent',
				'SystemList.view.Paging',
				'SystemList.view.ConfigWindow'
		],
		config: {
			emptyPanel: null
		},
		manageMargins:false,
		layout: {
			type: 'fit'
		},
		initComponent: function () {
			this.callParent();
			this.initConfig();
			},
		tools: [
			{
				xtype: 'button',
				id:'settingIconId',
				//cls:'iconBg dashboard-settings-btn',
				//iconCls:'iconDashboardSettings',
				cls:'dashboard-settings-btn',
				iconCls:'iconSettings',
				action: 'configsetting',
				margin:'3 5 0 0',
				hidden:!isAllComponentAccess
				
			},
			{
				xtype: 'button',
				id:'listButId',
				cls:'iconCompListviewSelect',
				margin:0,
				padding:0,
				style:{'border':'0px !important'},
				hidden:!isAllComponentAccess,
				listeners: {
					'afterrender':function(){
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: listTitle
						});
					},
					click: function (btn) {
						//window.location.href='/final/servlet/com.eg.EgMonitorController?monCmd=boxList&from=MainDashboard&action=box&isFromMenu=true';
						//btn.removeCls('iconCompListview');
						//btn.addCls('iconCompListviewSelect');

						//var url_val="/final/servlet/com.eg.EgMonitorController?monCmd=boxList&from=boxList&action=box";
						var url_val="/final/servlet/com.eg.EgMonitorController?monCmd=boxList&from=boxList&action=search&searchStateString=All%20States&searchNameString=&selTypeString=AllServers&searchTypeString=&componentListRefresh=yes";
						//http://192.168.8.127:7077/final/servlet/com.eg.EgMonitorController?monCmd=boxList&from=boxList&action=search&searchStateString=All%20States&searchNameString=&selTypeString=AllServers&searchTypeString=&componentListRefresh=yes&_dc=1467375677984

						SystemList.app.getController("Main").loadListView(url_val);

						btn.removeCls('iconCompListview');
						btn.addCls('iconCompListviewSelect');

						Ext.getCmp('settingIconId').disable();

						Ext.getCmp('GridButId').removeCls('iconCompGridviewSelect');
						Ext.getCmp('GridButId').addCls('iconCompGridview');
					}
				}
			},
			{
				xtype: 'button',
				id:'GridButId',
				cls:'iconCompGridview',
				style:{'border':'0px !important'},
				listeners: {
					'afterrender':function(){
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: metricsTitle
						});
					},
					click: function (btn) {
						//document.getElementById("GridButId").style.backgroundColor = "Gray";
						//window.location.href='/final/monitor/comparisonDashboard.jsp?treeTitle=system';
						//btn.removeCls('iconCompGridviewSelect');
						//btn.addCls('iconCompGridview');
						var url_val="/final/monitor/comparisonSystem.jsp?treeTitle=System&componentType="+componentType+"&filterBy="+filterBy+"&subFilter="+subFilter+"&componentNameSearch="+componentNameSearch;

						SystemList.app.getController("Main").loadMetricsView(url_val,pgTitle,"system");

						btn.removeCls('iconCompGridview');
						btn.addCls('iconCompGridviewSelect');

						if(isAllComponentAccess!=null && isAllComponentAccess==true)
						{
							Ext.getCmp('settingIconId').enable();
						}
						else
						{
							Ext.getCmp('settingIconId').disable();
						}
						
						Ext.getCmp('listButId').removeCls('iconCompListviewSelect');
						Ext.getCmp('listButId').addCls('iconCompListview');
					}
				}
			},
			{
				xtype : 'button',
				cls:'iconAutomaticScrollRun',
				id:'iconAutomaticScrollRun',
				//text:'Click to Automatic Scroll 111',
				margin: '0px 4px 0px 4px',
				ui: 'action',
				hidden:true,
				border:true,
				style: {
					border: '0px'
				},
				handler:function(){
					scrollFlag=true;
					pageScroll();
					Ext.getCmp('iconAutomaticScrollRun').hide();
					//Ext.getCmp('iconAutomaticScrollStop').show();
				},
				listeners: {
					afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							autoDestroy:true,
							html: 'Auto Scroll'
						});
					}
				}
			},
			{
				xtype : 'button',
				cls:'iconAutomaticScrollStop',
				id:'iconAutomaticScrollStop',
				margin: '0px 4px 0px 4px',
				ui: 'action',
				hidden:true,
				style: {
					border: '0px'
				},
				handler:function(){
					scrollFlag=false;
					stopScroll();
					Ext.getCmp('iconAutomaticScrollStop').hide();
					//Ext.getCmp('iconAutomaticScrollRun').show();
				},
				listeners: {
					afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							autoDestroy:true,
							html: 'Pause'
						});
					}
				}
			},
			{
				xtype:'tbseparator',
				cls:'removeLineForTvMode',
				hidden:true,
			},
			{
				xtype : 'button',
				cls:'iconAutomaticScrollJumpToTop',
				id:'iconAutomaticScrollJumpToTop',
				margin: '0px 4px 0px 4px',
				ui: 'action',
				hidden:true,
				style: {
					border: '0px'
				},
				handler:function(){
					scrollFlag=false;
					jumpScroll();
					Ext.getCmp('iconAutomaticScrollStop').hide();
					//Ext.getCmp('iconAutomaticScrollRun').show();
				},
				listeners: {
					afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							autoDestroy:true,		//
							html: 'Jump to top'
						});
					}
				}
			},
			{
				xtype:'tbseparator',
				cls:'removeLineForTvMode',
				hidden:true,
			},
			{
				xtype: 'commonbackbutton',
				hidden: hideBackButton
			}
		],
		title:pgTitle,
		//title:pageTitle,
		id:'centerP',
		itemId:'centerPanel',
		layout:{
			type:'vbox',
			align:'stretch'
		},
		items: [{
			xtype: 'systemlistForm',
			url : '/final/monitor/boxListData.jsp?'+requestParams.sessionURL
		},
		{
			xtype:'systemcomponent',
			flex:1
		}],
		listeners:{
			render:function(panel){

				if(requestParams.view!=null && requestParams.view!=undefined && (requestParams.view=='metric' || requestParams.view=='Metric'))
				{
					var url_val="/final/monitor/comparisonSystem.jsp?treeTitle=System&componentType="+componentType+"&filterBy="+filterBy+"&subFilter="+subFilter+"&componentNameSearch="+componentNameSearch;
					SystemList.app.getController("Main").loadMetricsView(url_val,pgTitle,"system");
					if(Ext.getCmp('settingIconId')!=null && Ext.getCmp('settingIconId')!=undefined)
					{
						if(isAllComponentAccess!=null && isAllComponentAccess==true)
						{
							Ext.getCmp('settingIconId').enable();
						}
						else
						{
							Ext.getCmp('settingIconId').disable();
						}
					}
				}
				else
				{
					Ext.getCmp('settingIconId').disable();
				}
			}
		}
		//cls: 'Pcenter'
	});


	/*  Script for automatic scroll options start here   */

var divCount = 2;
var gettingComponentDivId=0;
var scrolldelay, divArray;

function getDivArray(){
	divArray = Ext.getCmp('systemcomponent').items.items;
	if(!Ext.isEmpty(divArray) && divArray!=null && divArray!=undefined)
		divArrayLength = divArray[0].getHeight();
}

function pageScroll(){
	var pane=Ext.getCmp('systemcomponent');
	if(!Ext.isEmpty(pane))
	{
		if (divArray == null || divArray == undefined)
		{
			getDivArray();
		}
		var getMainBody = pane.body;
		var divHeight=0;
		for (i=1;i<=divCount;i++ )
		{
			if(!Ext.isEmpty(divArray) && divArray!=null && divArray!=undefined)
				divHeight+=divArray[gettingComponentDivId].getHeight();
			gettingComponentDivId++;
		}
		getMainBody.scrollBy(0,divHeight);
		scrolldelay = setTimeout('pageScroll()', 3000);
		if($('#systemcomponent-body').scrollTop()+$('#systemcomponent-body').innerHeight() >= $('#systemcomponent-body')[0].scrollHeight)
		{
			gettingComponentDivId=0;
			if (window.parent.tvModePlayAction!=undefined && window.parent.tvModePlayAction=='pause')
			{
				stopScroll();
				setTimeout('startTvModePlayAction()',3000);
			}
			else
			{
				clearTimeout(scrolldelay);
				scrolldelay=setTimeout('beforeContinueScroll()',3000);
			}
		}
	}
}

function startTvModePlayAction(){
	jumpScroll();
	window.parent.startTvModePlayAction();
}

function beforeContinueScroll(){
	var pane=Ext.getCmp('systemcomponent');
	if (!Ext.isEmpty(pane))
	{
		$('#systemcomponent-body').scrollTop(0);
		scrolldelay = setTimeout('pageScroll()',3000);
	}
}

function stopScroll(){
	clearTimeout(scrolldelay);
}

function jumpScroll(){
	var pane=Ext.getCmp('systemcomponent');
	if (!Ext.isEmpty(pane))
	{
		clearTimeout(scrolldelay);
		gettingComponentDivId=0;
		$('#systemcomponent-body').scrollTop(0); // horizontal and vertical scroll targets
	}
}

	scrolldelay = null;
	delete scrolldelay;


/*  Script for automatic scroll options  end here   */

