
Ext.define('TemplateBuilder.controller.Main',
{
	extend : 'Ext.app.Controller',
	requires : ['TemplateBuilder.view.ListView','TemplateBuilder.view.CreateTemplate','TemplateBuilder.view.UserDefinedWidgetWindow','TemplateBuilder.view.ConfigLayout',
				'TemplateBuilder.view.TemplateLayout','utilities.gridstackPanel','TemplateBuilder.view.TemplateGeneralSettings',
				'TemplateBuilder.view.TemplateTools','TemplateBuilder.view.Portlet',
				'TemplateBuilder.view.ComparisonTable','TemplateBuilder.view.WidgetLibrary','TemplateBuilder.view.IconLibrary','utilities.gridstackPanel','TemplateBuilder.view.AddWidgetWindowNew'
				],
	refs : [ {
		ref : 'main',
		selector : 'main'
	},{
        ref: 'viewport',
        selector: 'viewport'
    },
	{
		ref : 'templateBuilderList',
		selector : 'templateBuilderList'
	},{
		ref : 'createTemplate',
		selector : 'createTemplate'
	},{
		ref : 'userDefinedWidgetWindow',
		selector : 'userDefinedWidgetWindow'
	},
	{
		ref : 'widgetLibrary',
		selector : 'widgetLibrary'
	},
	{
		ref : 'templatetools',
		selector : 'templatetools'
	},
	{
		ref : 'templategeneralsettings',
		selector : 'templategeneralsettings'
	},
	{
		ref : 'portlet',
		selector : 'portlet'
	},
	{
		ref : 'comparisontable',
		selector : 'comparisontable'
	},
	{
		ref:'gridstackpanel',
		selector:'gridstackpanel'
	},
	{
		ref:'excludeincludeconfiguration',
		selector:'excludeincludeconfiguration'
	},
	{
		ref : 'addwidgetwindownew',
		selector : 'addwidgetwindownew'
	}
	],
	init : function() {
		var thiscontroller = this;
		Ext.getBody().on('click', function() {
					Ext.getCmp('WidgetNametextField').show();
					var widgtName = $('#userDefinedWidgetNameLbl').text();
					Ext.getCmp('WidgetNametextField').setValue(widgtName);
					Ext.getCmp('userDefinedWidgetNameLbl').setText('');
					Ext.getCmp('userDefinedWidgetNameLbl').hide();
					$('#iconRename').hide();
				}, null, {
					delegate : '#iconRename'
				});
				Ext.getBody().on('click', function() {
					thiscontroller.createWidget();
					Ext.defer(function(){
						configPopup('block'+maxBlockId,'addWidget',loginUser);
					},100)
					var widgetLibWindObj=thiscontroller.getWidgetLibrary();
					if (Ext.isEmpty(widgetLibWindObj))
					widgetLibWindObj = Ext.widget('widgetLibrary');

					if(widgetLibWindObj!=null && !Ext.isEmpty(widgetLibWindObj))
					{
						widgetLibWindObj.close();
					}
				}, null, {
					delegate : '#addWidgtFrmWidgtLib'
				});
		this.control({
			'main' : {
				'boxready' : this.loadDefaultView
			},
			'main checkbox[id="selectAllTemplates"]': {
				'change':this.checkboxClick
			},
			'main button[id="DeleteListOfTemplates"]': {
				'click':this.deleteSelectedTemplates
			},
			'main button[id="createTemplateButton"]': {
				'click':this.createTemplateView
			},
			'templatetools button[id="addTemplate"]': {
				'click':this.createTemplateView
			},
			'createTemplate  button[buttonId="selectExpand"]' : {
				'click' : this.expandMe
			},
			'createTemplate  combo[id="infraTypeCombo"]' : {
			'select' : this.getOptionsForType
			},
			'templategeneralsettings button[buttonId="Delete Template"]' : {
				'click' : this.deleteTemplate
			},
			'templategeneralsettings button[buttonId="Clone Template"]' : {
				'click' : this.cloneMyTemplate
			},
			'templategeneralsettings button[buttonId="AddWidget"]' : {
				'click' : this.createWidget
			},
			'templategeneralsettings button[buttonId="ModifyTemplate"]' : {
				'click' : this.editMyTemplate
			},
			'createTemplate  button[id="CreateTemplateBtn"]' : {
			'click' : this.saveTemplate
			},
			'templatetools  button[id="listBtn"]' : {
			'click' : this.goToTemplateListPage
			},
				'main combo[id="templateListCombo"]' : {
				'select' : this.showSelectedTemplate
			},
			'userDefinedWidgetWindow radiogroup[id="addToWidgetLibRadioBtn"]' : {
				'change' : this.addToWidgetLibRadioEvent
			},
			'userDefinedWidgetWindow combo[id="widgetGrpCombo"]' : {
				'change' : this.onWidgetGrpComboChange
			},
			'userDefinedWidgetWindow combo[id="testCombo"]' : {
				'change' : this.onTestComboChange
			},
			'userDefinedWidgetWindow radiogroup[id="showAggOpt"]' : {
			'change' : this.showAggOptions
			},
			'userDefinedWidgetWindow radiogroup[id="ChartDistribution"]' : {
			'change' : this.chartDistributionEvent
			},
			'userDefinedWidgetWindow button[id="addtoGridBtn"]' : {
			'click' : this.addMeasuresToGrid
			},
			'userDefinedWidgetWindow combo[id="GraphicalType"]' : {
				'change' : this.doTopNEvent
			},
			'userDefinedWidgetWindow combo[id="measureListCombo"]' : {
				'change' : this.loadDDColumns
			},
			'templategeneralsettings button[buttonId="Widgets_Gallery"]' : {
				'click' : this.showWidgetGallery
			},
			'userDefinedWidgetWindow checkbox[id="ChartSummaryEnabled"]' : {
				'change' : this.enableChartTypes
			},'userDefinedWidgetWindow checkbox[id="ShowIcon"]' : {
				'change' : this.showIconControl
			},
			'userDefinedWidgetWindow combo[id="Duration"]' : {
			'select' : this.durationComboOnChange
			},
			'userDefinedWidgetWindow checkboxgroup[id="Stacked"]':
			{
				'change' : this.showStackedChart
			},
			'createTemplate  combo[id="compTypeFilterComboObj"]' :
			{
				'select' : this.loadComponentsForSelection
			},
			'createTemplate  combo[id="templateInfraElementsSingleCombo"]' :
			{
				'select' : this.loadComponentsForSelection
			},
			'createTemplate  button[id="excludeServers"]' :
			{
				'click' : this.excludeComponents
			},
			'userDefinedWidgetWindow checkbox[id="EnableMeasureStateColor"]' :
			{
				'change' : this.enableStateColorOnChange
			},
			'userDefinedWidgetWindow combo[id="categoryOpts"]' :
			{
				'select' : this.categoryOnChange
			},
			'userDefinedWidgetWindow combo[id="healthCenterCompTypeCombo"]' :
			{
				'select' : this.changeHealthCenterCompTypeScrollCombo
			},
			'userDefinedWidgetWindow combo[id="healthCenterTestScrollCombo"]' :
			{
				'select' : this.changeHealthCenterTestScrollCombo
			},
			'userDefinedWidgetWindow combo[id="graphicalTypeId"]' : {
				'select' : this.onChangeDDChartType
			}
		});
	},
	categoryOnChange : function(combo)	
	{
		var selectedCategory = combo.getValue();
		var healthCenterTestScrollComboObj = Ext.getCmp('healthCenterTestScrollCombo');
		var healthCenterCompContineroObj = Ext.getCmp('healthCenterCompContiner');
		var healthCenterCompTypeComboObj = Ext.getCmp('healthCenterCompTypeCombo');
		var healthCenterComponentComboLblObj = Ext.getCmp('healthCenterComponentComboLbl');

		var templateLayoutObj = Ext.getCmp('templateLayoutObj');
		var templateName = templateLayoutObj.profileName;

		if(selectedCategory!= null && selectedCategory == '-1')
		{
			Ext.getCmp('selectionDetailsLbl').hide();
			Ext.getCmp('addtoGridBtn').hide();
			Ext.getCmp('configTableGrid').hide();
			if(!Ext.isEmpty(healthCenterTestScrollComboObj))
			{
				healthCenterTestScrollComboObj.hide();
			}
			if(!Ext.isEmpty(healthCenterCompContineroObj))
			{
				healthCenterCompContineroObj.hide();	
			}
			if(!Ext.isEmpty(healthCenterCompTypeComboObj))
			{
				healthCenterCompTypeComboObj.hide();	
			}
		}
		else if(selectedCategory == 'vms|desktop|users')
		{

			Ext.getCmp('selectionDetailsLbl').hide();
			Ext.getCmp('addtoGridBtn').hide();
			Ext.getCmp('configTableGrid').hide();
			this. loadHealthCenterCompType(selectedCategory);
			healthCenterComponentComboLblObj.setText('Components');
			if(!Ext.isEmpty(healthCenterTestScrollComboObj))
			{
				healthCenterTestScrollComboObj.hide();
			}
			if(!Ext.isEmpty(healthCenterCompContineroObj))
			{
				healthCenterCompContineroObj.hide();	
			}
			if(!Ext.isEmpty(healthCenterCompTypeComboObj))
			{
				healthCenterCompTypeComboObj.show();	
			}

		}
		else if(selectedCategory!= null && (selectedCategory == 'Zone' || selectedCategory == 'Segment' || selectedCategory == 'Service'))
		{
			Ext.getCmp('selectionDetailsLbl').hide();
			Ext.getCmp('addtoGridBtn').hide();
			Ext.getCmp('configTableGrid').hide();
			if(!Ext.isEmpty(healthCenterTestScrollComboObj))
			{
				healthCenterTestScrollComboObj.hide();
			}
			if(!Ext.isEmpty(healthCenterCompContineroObj))
			{
				healthCenterCompContineroObj.show();	
			}
			if(!Ext.isEmpty(healthCenterCompTypeComboObj))
			{
				healthCenterCompTypeComboObj.hide();	
			}

			var selectedCategoryTemplate = selectedCategory +':Template';
			var paramsForRc = 'C=true&P0={' + encodeURIComponent(selectedCategoryTemplate) + '}&P1={' + encodeURIComponent(templateName) + '}&calljson=true&F=getCategoryOptionsForTypeJSON';
			
			var meC = this;
			Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgMonRemoteScriptingServlet',
				method : 'POST',
				params : paramsForRc,
				scope : this,
				async : true,
				success : function(response) {
					var jsonText = response.responseText;
					if (jsonText != null && jsonText != '') {
						var jsonData = Ext.decode(jsonText);
						var healthCenterComponentComboObj = Ext.getCmp('healthCenterComponentCombo');

						if(!Ext.isEmpty(healthCenterComponentComboObj))
						{
							healthCenterComponentComboObj.suspendEvents(true);
							healthCenterComponentComboObj.getStore().removeAll();
							healthCenterComponentComboObj.getStore().loadRawData(jsonData['optionsForType']);
							healthCenterComponentComboObj.resumeEvents();
							healthCenterComponentComboObj.setValue(jsonData['selectedTypeValue']);
							healthCenterComponentComboLblObj.setText(selectedCategory+'s');
						}
						jsonData=null;
						delete jsonData;
					}
					jsonText=null;
					delete jsonText;
				}
			});
		}
		else if(selectedCategory!= null && selectedCategory == 'Components')
		{
			Ext.getCmp('selectionDetailsLbl').hide();
			Ext.getCmp('addtoGridBtn').hide();
			Ext.getCmp('configTableGrid').hide();
			this. loadHealthCenterCompType(selectedCategory);
			healthCenterComponentComboLblObj.setText('Components');
			if(!Ext.isEmpty(healthCenterTestScrollComboObj))
			{
				healthCenterTestScrollComboObj.hide();
			}
			if(!Ext.isEmpty(healthCenterCompContineroObj))
			{
				healthCenterCompContineroObj.hide();	
			}
			if(!Ext.isEmpty(healthCenterCompTypeComboObj))
			{
				healthCenterCompTypeComboObj.show();	
			}
		}
		else if(selectedCategory!= null && selectedCategory == 'Descriptors')
		{
			Ext.getCmp('addtoGridBtn').hide();
			Ext.getCmp('configTableGrid').show();
			Ext.getCmp('selectionDetailsLbl').show();
			this. loadHealthCenterCompType(selectedCategory);
			healthCenterComponentComboLblObj.setText('Descriptors');
			if(!Ext.isEmpty(healthCenterCompTypeComboObj))
			{
				healthCenterCompTypeComboObj.show();	
			}
			if(!Ext.isEmpty(healthCenterTestScrollComboObj))
			{
				healthCenterTestScrollComboObj.hide();
			}
			if(!Ext.isEmpty(healthCenterCompContineroObj))
			{
				healthCenterCompContineroObj.hide();	
			}	
			var containsComponentType = false;
			var containsDescriptors = false;
			var gridObj = Ext.getCmp('configTableGrid');
			for(var indexvar = 1; indexvar < gridObj.columns.length; indexvar++)
			{
				if(gridObj.columns[indexvar].text == 'Component Type')
				{
					containsComponentType = true;
				}
				if(gridObj.columns[indexvar].text == 'Descriptor' )
				{
					containsDescriptors = true;
				}
			}
				
			if(!containsComponentType)
			{
				var column1 = Ext.create('Ext.grid.column.Column', {
					text: 'Component Type',
					dataIndex:'componentType',
					flex:.4,
					hidden:false,
					renderer: function(value, metaData) {
						metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
						return value;
					}
				});

				gridObj.headerCt.insert(
					1, 
					column1);
			}

			for(var indexvar = 1; indexvar < gridObj.columns.length; indexvar++)
			{
				if(gridObj.columns[indexvar].text == 'Measure')
				{
					gridObj.headerCt.remove(indexvar);
					gridObj.getView().refresh();
					break;
				}
			}

			if(!containsDescriptors)
			{
				var column3 = Ext.create('Ext.grid.column.Column', {
					text: 'Descriptor',
					dataIndex:'Descriptor',
					flex:.4,
					hidden:false,
					renderer: function(value, metaData) {
						metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
						return value;
					}
				});

				gridObj.headerCt.insert(
				3, 
				column3);
			}	
			gridObj.getView().refresh();
		}
	},
	
	loadHealthCenterCompType : function(selectedCategory)
	{
		var templateLayoutObj = Ext.getCmp('templateLayoutObj');
		var templateName = templateLayoutObj.profileName;

		var param="comesFrom=myDashboard&action=loadComponentTypesForTemplateDataHealth&profileName="+templateName+"&selectedCategory="+encodeURIComponent(selectedCategory);
		Ext.Ajax.request(
		{
			url: '/final/servlet/com.eg.EgMonitorRequestDispatcher',
			params: param,
			scope: this,
			method: 'POST',
			success: function(response)
			{
				var jsontext = response.responseText;
				var jsonData = Ext.decode(jsontext);
				if (!Ext.isEmpty(jsonData))
				{
					if(jsonData != null && jsonData.hasOwnProperty('comptypes'))
					{
						var jsonDataCompTypes = jsonData['comptypes'];
						
						if(jsonDataCompTypes != null && jsonDataCompTypes.hasOwnProperty('availCompTypes'))
						{	
							var healthCenterCompTypeComboObj = Ext.getCmp('healthCenterCompTypeCombo');
							healthCenterCompTypeComboObj.suspendEvents(true);				
							healthCenterCompTypeComboObj.getStore().loadRawData(jsonDataCompTypes['availCompTypes']);
							var compTypeStore = healthCenterCompTypeComboObj.getStore();

							var categoryOptsObj = Ext.getCmp('categoryOpts');
													
							if(selectedCategory != 'Descriptors')
							{
								compTypeStore.insert(1,{
									displayField:'All types',
									valueField: 'allServers'
								});
							}
							healthCenterCompTypeComboObj.setValue('-1');
							healthCenterCompTypeComboObj.resumeEvents();
						}
						else
						{
							if(selectedCategory == 'vms|desktop|users')
							{
								var healthCenterCompTypeComboObj = Ext.getCmp('healthCenterCompTypeCombo');
								healthCenterCompTypeComboObj.suspendEvents(true);				
								healthCenterCompTypeComboObj.getStore().loadRawData(jsonDataCompTypes);
								var compTypeStore = healthCenterCompTypeComboObj.getStore();

								if (jsonDataCompTypes.length == 0)
								{
									compTypeStore.insert(0,{
										displayField:notApplicable,
										valueField: '-1'
									});
								}
								else
								{
									compTypeStore.insert(0,{
										displayField:compTypAlertMsg,
										valueField: '-1'
									});
								}

								healthCenterCompTypeComboObj.setValue('-1');
								healthCenterCompTypeComboObj.resumeEvents();
							}
						}
					}	
					else
					{
						var healthCenterCompTypeComboObj = Ext.getCmp('healthCenterCompTypeCombo');
						healthCenterCompTypeComboObj.suspendEvents(true);				
						var compTypeStore = healthCenterCompTypeComboObj.getStore();
						compTypeStore.removeAll();

						compTypeStore.insert(0,{
							displayField:compTypAlertMsg,
							valueField: '-1'
						});
						healthCenterCompTypeComboObj.setValue('-1');
						healthCenterCompTypeComboObj.resumeEvents();
					}					
				}
			}
		});
	},

	changeHealthCenterCompTypeScrollCombo : function(compTypeScrollComboObj)
	{
		var categoryOptsObj = Ext.getCmp('categoryOpts');
		var selectedCategory = categoryOptsObj.getValue();
		//if(selectedCategory != null && (selectedCategory == 'Components' || selectedCategory == 'vms|desktop|users'))
		if(selectedCategory != null && selectedCategory == 'Components')
		{
			return;
		}
		else if(selectedCategory != null && selectedCategory == 'vms|desktop|users')
		{
			this.loadVms();
			return;
		}

		var selectedTypeCompValue = compTypeScrollComboObj.getValue();
		var healthCenterTestCombo = Ext.getCmp('healthCenterTestScrollCombo');

		if (selectedTypeCompValue != "-1") {
			var paramsForRc = 'C=true&F=getTestsForComponentJSON&P0={' + selectedTypeCompValue + '}&calljson=true';
			
			var meC = this;
			Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgMonRemoteScriptingServlet',
				method : 'POST',
				params : paramsForRc,
				scope : this,
				async : true,
				success : function(response) {
					var jsonText = response.responseText;
					if (jsonText != null && jsonText != '') {
						var jsonData = Ext.decode(jsonText);				
						if(!Ext.isEmpty(healthCenterTestCombo))
						{
							healthCenterTestCombo.suspendEvents(true);
							healthCenterTestCombo.getStore().removeAll();
							healthCenterTestCombo.getStore().loadRawData(jsonData['TEST_VALUES']);
							healthCenterTestCombo.resumeEvents();
							healthCenterTestCombo.setValue('-1');
						}
						jsonData=null;
						delete jsonData;
					}
					jsonText=null;
					delete jsonText;
				}
			});
			healthCenterTestCombo.show();
		} 
		else
		{
			if (!Ext.isEmpty(healthCenterTestCombo))
			{
				healthCenterTestCombo.suspendEvents(true);				
				var testStore = healthCenterTestCombo.getStore();
				testStore.removeAll();

				testStore.insert(0,{
					displayField:notApplicable,
					valueField: '-1'
				});
				healthCenterTestCombo.setValue('-1');
				healthCenterTestCombo.resumeEvents();
				healthCenterTestCombo.show();
			}
		}
	},

	loadVms : function()
	{
		var categoryOptsObj = Ext.getCmp('categoryOpts');
		var selectedCategory = categoryOptsObj.getValue();
		var healthCenterCompContineroObj = Ext.getCmp('healthCenterCompContiner');
		var healthCenterComponentComboLblObj = Ext.getCmp('healthCenterComponentComboLbl');

		if(!Ext.isEmpty(healthCenterCompContineroObj))
		{
			healthCenterCompContineroObj.show();	
		}

		var componentType = Ext.getCmp('healthCenterCompTypeCombo');
		var selectedCompType = componentType.getValue();
		if (selectedCompType != "-1") {
			var paramsForRc = 'C=true&F=getVmsForSelectedHyperVisorType&P0={' + selectedCompType + '}&calljson=true';

			var selectedVMs = ''; 
			if(componentType != null && componentType.hasOwnProperty('vmData'))
			{
				var selectedItems = componentType['vmData'];
				if(selectedItems != null && selectedItems.hasOwnProperty('selectedVMs'))
				{
					selectedVMs = selectedItems['selectedVMs'];
				}
			}

			var meC = this;
			Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgMonRemoteScriptingServlet',
				method : 'POST',
				params : paramsForRc,
				scope : this,
				async : true,
				success : function(response) {
					var jsonText = response.responseText;
					if (jsonText != null && jsonText != '') {
						var jsonData = Ext.decode(jsonText);
						
						if (jsonData != null && jsonData.hasOwnProperty('descriptorsList'))
						{
							var healthCenterComponentComboObj = Ext.getCmp('healthCenterComponentCombo');

							if(!Ext.isEmpty(healthCenterComponentComboObj))
							{
								healthCenterComponentComboObj.suspendEvents(true);
								healthCenterComponentComboObj.getStore().removeAll();
								healthCenterComponentComboObj.getStore().loadRawData(jsonData['descriptorsList']);
								healthCenterComponentComboObj.getStore().insert(0, {
									displayField : allVms,
									valueField : 'allVms'
								});
								healthCenterComponentComboObj.resumeEvents();
								//healthCenterComponentComboObj.setValue(jsonData['selectedTypeValue']);
								healthCenterComponentComboLblObj.setText('VM');
							}
						}
						
						jsonData=null;
						delete jsonData;
					}
					jsonText=null;
					delete jsonText;
				}
			});
			
		} else {

			var healthCenterComponentComboObj = Ext.getCmp('healthCenterComponentCombo');

			if(!Ext.isEmpty(healthCenterComponentComboObj))
			{
				healthCenterComponentComboObj.suspendEvents(true);
				healthCenterComponentComboObj.getStore().removeAll();

				healthCenterComponentComboObj.getStore().insert(0, {
					displayField : notApplicable,
					valueField : '-1'
				});
				healthCenterComponentComboObj.resumeEvents();
				healthCenterComponentComboObj.setValue('-1');
				healthCenterComponentComboLblObj.setText('VM');
			}
		}
		
	},

	changeHealthCenterTestScrollCombo : function(testScrollComboObj)
	{
		var selectedTestValue = testScrollComboObj.getValue();
		var categoryOptsObj = Ext.getCmp('categoryOpts');
		var selectedCategory = categoryOptsObj.getValue();

		var healthCenterCompTypeComboObj = Ext.getCmp('healthCenterCompTypeCombo');
		var selectedCompType = healthCenterCompTypeComboObj.getValue();
		var compNames = ''; 

		if (selectedCompType != "-1") {
			var paramsForRc = 'C=true&F=getComponentsForType&P0={' + selectedCompType + '}&calljson=true';
			
			var meC = this;
			Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgMonRemoteScriptingServlet',
				method : 'POST',
				params : paramsForRc,
				scope : this,
				async : true,
				success : function(response) {
					var jsonText = response.responseText;
					if (jsonText != null && jsonText != '') {
						var jsonData = Ext.decode(jsonText);
						if(jsonData!=null && jsonData.hasOwnProperty('compOptsJson'))
						{
							var compNameArray = jsonData['compOptsJson'];
						}

						for(var i in compNameArray)
						{
							var compName = compNameArray[i].valueField;
							if(compName != null && compName.indexOf(':')==-1)
							{
								compName = compName+':'+'NULL';								
							}
							compName = selectedCompType+':'+compName;
							compNames = compNames+','+compName;
						}
						if(compNames != null && compNames.indexOf(',')==0)
						{
							compNames = compNames.substring(compNames.indexOf(',')+1);
						}
						this.loadDescriptorsForTest(selectedCompType,compNames,selectedTestValue);

						jsonData=null;
						delete jsonData;
					}
					jsonText=null;
					delete jsonText;
				}
			});
		} 
	},

	loadDescriptorsForTest : function(compType,compNames,selectedTestValue)
	{
		var healthCenterCompContineroObj = Ext.getCmp('healthCenterCompContiner');

		var paramsForRc = 'C=true&F=getDescriptorsForServersJSON&P0={' + compType + '}&P1={' + compNames + '}&P2={' + selectedTestValue + '}&calljson=true';

		var meC = this;
		Ext.Ajax.request({
			url : '/final/servlet/com.eg.EgMonRemoteScriptingServlet',
			method : 'POST',
			params : paramsForRc,
			scope : this,
			async : true,
			success : function(response) {
				var jsonText = response.responseText;
				if (jsonText != null && jsonText != '') {
					var jsonData = Ext.decode(jsonText);
					if(jsonData!=null && jsonData.hasOwnProperty('descriptorsList'))
					{
						Ext.getCmp('addtoGridBtn').show();
						if(!Ext.isEmpty(healthCenterCompContineroObj))
						{
							healthCenterCompContineroObj.show();	
						}	
						var healthCenterComponentComboObj = Ext.getCmp('healthCenterComponentCombo');

						if(!Ext.isEmpty(healthCenterComponentComboObj))
						{
							if (jsonData['descriptorsList'].length == 1 && jsonData['descriptorsList'][0].valueField == '-1')
							{
								healthCenterComponentComboObj.suspendEvents(true);
								healthCenterComponentComboObj.getStore().removeAll();
								healthCenterComponentComboObj.getStore().loadRawData(jsonData['descriptorsList']);
								healthCenterComponentComboObj.resumeEvents();
								healthCenterComponentComboObj.setValue('-1');
							}
							else
							{
								healthCenterComponentComboObj.suspendEvents(true);
								healthCenterComponentComboObj.getStore().removeAll();
								healthCenterComponentComboObj.getStore().loadRawData(jsonData['descriptorsList']);
								healthCenterComponentComboObj.getStore().insert(0, {
									displayField : allDescriptors,
									valueField : 'allDescriptors'
								});
								healthCenterComponentComboObj.resumeEvents();
								healthCenterComponentComboObj.setValue('-1');
							}
						}
					}
					jsonData=null;
					delete jsonData;
				}
				jsonText=null;
				delete jsonText;
			}
		});
	},

	reloadAdvanceOptions : function(chartType)	
	{	
		var aggFunctionObj = Ext.getCmp('Aggregation_Function');

		if(chartType!= null && !Ext.isEmpty(aggFunctionObj) && (chartType=='TopNGaugeChart' || chartType=='TopNDigitalChart'))
		{
			var testName='';
			var gridObj = this.getComparisontable();
			var gridStore = gridObj.getStore();
			var gridRecordCount = gridObj.getStore().getCount();
			if (gridRecordCount != 0) {

				for ( var i = 0; i < gridRecordCount; i++) {
					var measuresHidVal = gridObj.getStore().getAt(i).get('hidVal');
					var test = measuresHidVal.substr(0, measuresHidVal.indexOf(":"));
					testName=test;		  
				}
			}
			if(testName!=null && (testName.endsWith("_ag") || testName.endsWith("_agx")))
			{
				if(!Ext.isEmpty(aggFunctionObj))
				{
					aggFunctionObj.hide();
				}
			}
			else
			{
				if(!Ext.isEmpty(aggFunctionObj))
				{
					aggFunctionObj.show();
				}
			}
		}
	},

	loadExcludeIncludeDefaultData : function(jsonData,dispType)
	{	
		var serverDescripCombo=jsonData['excludeIncludeOptions'];	 
		var serverdescripComboObj=Ext.getCmp('serverdescripCombo');

		if(!Ext.isEmpty(serverdescripComboObj))
		{			
			serverdescripComboObj.suspendEvents(true);
			serverdescripComboObj.getStore().removeAll();
			serverdescripComboObj.getStore().loadRawData(serverDescripCombo);
			serverdescripComboObj.resumeEvents();
			serverdescripComboObj.setValue('None');
		}

		var compTypeComboObj = Ext.getCmp('compTypeCombo');
		if(!Ext.isEmpty(compTypeComboObj))
		{
			var optsArr=[];
			optsArr.push({
				'displayField' : 'Not Available',
				'valueField': '-1'
			});  			
			compTypeComboObj.getStore().removeAll();
			compTypeComboObj.getStore().loadRawData(optsArr);
			compTypeComboObj.setValue('-1');
		}	
		
		var componentsFilterObj=Ext.getCmp('compFilterItmSel');
		if(!Ext.isEmpty(componentsFilterObj))
		{
			componentsFilterObj.suspendEvents(true);
			componentsFilterObj.getStore().removeAll();
			componentsFilterObj.reset();
		}

		var excIncludeRadioOptObj=Ext.getCmp('excIncludeRadioOpt');
		if(!Ext.isEmpty(excIncludeRadioOptObj))
		{			
			excIncludeRadioOptObj.hide();
		}

		var descMultiselectObj=Ext.getCmp('descMultiselect');
		if(!Ext.isEmpty(descMultiselectObj))
		{
			descMultiselectObj.suspendEvents(true);
			descMultiselectObj.getStore().removeAll();
			descMultiselectObj.reset();
		}

		var descriptorItemSelObj=Ext.getCmp('descriptorItemSel');
		if(!Ext.isEmpty(descriptorItemSelObj))
		{
			descriptorItemSelObj.hide();
		}
		if(!Ext.isEmpty(componentsFilterObj))
		{
			componentsFilterObj.show();
		}
		var updateExcludeIncludeObj=Ext.getCmp('updateExcludeInclude');
		if(!Ext.isEmpty(updateExcludeIncludeObj))
		{
			updateExcludeIncludeObj.setText(screenLabelsObj['Exclude']+'&#47;'+screenLabelsObj['Include']);
		}

		var testComboObj=Ext.getCmp('testComboValue');
		if(!Ext.isEmpty(testComboObj))
		{			
			testComboObj.hide();
		}
	},	

	onTypeCombochange: function(combo)
	{
		var userdefinedWidgetWindowObj = this.getUserDefinedWidgetWindow();
		if (Ext.isEmpty(userdefinedWidgetWindowObj))
			userdefinedWidgetWindowObj = Ext.widget('userDefinedWidgetWindow');
		
		var chartType=userdefinedWidgetWindowObj.chartType;
		if(chartType=='')
		{
			chartType = userdefinedWidgetWindowObj.configuredDataValue.DisplayType;
		}
		if(chartType=='' || chartType==undefined)
		{
			chartType='TopNGaugeChart';
		}
		
		var comboVal = combo.getValue();

		if(comboVal == 'Descriptor' && (chartType == 'TopNGaugeChart' || chartType == 'TopNDigitalChart' || chartType == 'TopN' || chartType == 'TopNTabularView' || chartType == 'TopNBarChart' || chartType == 'liveMeasuresBox'))
		{
			var compFilterItmSelObj = Ext.getCmp('compFilterItmSel');
			if(!Ext.isEmpty(compFilterItmSelObj))
			{
				compFilterItmSelObj.hide();
			}
			var descriptorItemSelObj = Ext.getCmp('descriptorItemSel');
			if(!Ext.isEmpty(descriptorItemSelObj))
			{
				descriptorItemSelObj.show();
			}

			this.loadDescriptorsForTopNWidgets();

		}else if(comboVal == 'Descriptor'){

			var compTypeComboObj = Ext.getCmp('compTypeCombo');
			compTypeComboObj.hide();
			var componentsFilterObj=Ext.getCmp('compFilterItmSel');
			if(!Ext.isEmpty(componentsFilterObj))
			{
				componentsFilterObj.suspendEvents(true);
				componentsFilterObj.getStore().removeAll();
				componentsFilterObj.reset();
			}

			if(!Ext.isEmpty(componentsFilterObj))
			{
				componentsFilterObj.hide();
			}
			var descriptorItemSelObj = Ext.getCmp('descriptorItemSel');
			if(!Ext.isEmpty(descriptorItemSelObj))
			{
				descriptorItemSelObj.show();
			}
			
			var descMultiselectObj=Ext.getCmp('descMultiselect');
			if(!Ext.isEmpty(descMultiselectObj))
			{
				descMultiselectObj.suspendEvents(true);
				descMultiselectObj.getStore().removeAll();
				descMultiselectObj.reset();
			}
			//*********

			var gridObj = this.getComparisontable();
			var gridStore = gridObj.getStore();
			var gridRecordCount = gridObj.getStore().getCount();
			if (gridRecordCount == 0) {
			Ext.Msg.show({
					title : templatesAlertLbl,
					msg : measureAlertMsg,
					buttons : Ext.MessageBox.OK,
					icon : Ext.MessageBox.WARNING
				});
				return;
			}

			var selectedTest = '';
			
			for ( var i = 0; i < gridRecordCount; i++) {
				var measuresHidVal = gridObj.getStore().getAt(i).get('hidVal');
				var testName = measuresHidVal.substr(0, measuresHidVal.indexOf(":")); 
				
				if(selectedTest=='')
				{
					selectedTest = selectedTest+testName;
				}
				else
				{
					selectedTest = selectedTest+','+testName;
				}				
			}
		
			this.loadDescriptorsForTopNWidgets(selectedTest);

			//**********

			//this.loadConfiguredTests();


		}
		else{
			var compTypeComboObj = Ext.getCmp('compTypeCombo');
			compTypeComboObj.show();
			var componentsFilterObj=Ext.getCmp('compFilterItmSel');
			if(!Ext.isEmpty(componentsFilterObj))
			{
				componentsFilterObj.suspendEvents(true);
				componentsFilterObj.getStore().removeAll();
				componentsFilterObj.reset();
			}

			if(!Ext.isEmpty(componentsFilterObj))
			{
				componentsFilterObj.show();
			}
			var descriptorItemSelObj = Ext.getCmp('descriptorItemSel');
			if(!Ext.isEmpty(descriptorItemSelObj))
			{
				descriptorItemSelObj.hide();
			}
			var excIncludeRadioOptObj = Ext.getCmp('excIncludeRadioOpt');
			if(!Ext.isEmpty(excIncludeRadioOptObj))
			{
				excIncludeRadioOptObj.hide();
			}

			var descMultiselectObj=Ext.getCmp('descMultiselect');
			if(!Ext.isEmpty(descMultiselectObj))
			{
				descMultiselectObj.suspendEvents(true);
				descMultiselectObj.getStore().removeAll();
				descMultiselectObj.reset();
			}
			var updateExcludeIncludeObj=Ext.getCmp('updateExcludeInclude');
			if(!Ext.isEmpty(updateExcludeIncludeObj))
			{
				updateExcludeIncludeObj.setText(screenLabelsObj['Exclude']+'&#47;'+screenLabelsObj['Include']);
			}
			this.loadDefaultExcludeIncludeConfig(combo);
		}

	},
		
	loadDefaultExcludeIncludeConfig: function(combo)
	{
		var comboVal = combo.getValue();		
		if(comboVal == 'Component' || comboVal =='None')
		{
			var testComboObj=Ext.getCmp('testComboValue');
			if(!Ext.isEmpty(testComboObj))
			{
				testComboObj.getStore().removeAll();
				testComboObj.hide();
			}
		}

		var componentsFilterObj=Ext.getCmp('compFilterItmSel');

		if(!Ext.isEmpty(componentsFilterObj))
		{
			componentsFilterObj.suspendEvents(true);
			componentsFilterObj.getStore().removeAll();
			componentsFilterObj.reset();
		}

		var compTypeComboObj = Ext.getCmp('compTypeCombo');
		if(!Ext.isEmpty(compTypeComboObj))
		{
			var optsArr=[];
			optsArr.push({
				'displayField' : 'Not Available',
				'valueField': '-1'
			});  			
			compTypeComboObj.getStore().removeAll();
			compTypeComboObj.getStore().loadRawData(optsArr);
			compTypeComboObj.setValue('-1');
		}	

		var param= '';
		if(comboVal == 'Component' || comboVal == 'Descriptor')
		{
			 param= param+'action=loadComponentTypeCombo';
		}else{
			return;
		}
	
		var templateLayoutObj = Ext.getCmp('templateLayoutObj');
		var templateName = templateLayoutObj.profileName;
	
		if(!Ext.isEmpty(templateName))
		{
			param=param+'&profileName='+encodeURIComponent(templateName);
		}		 
		var comboVal = combo.getValue();
		
		if (comboVal != null && comboVal == '')
		{
			param=param+'&selectType='+comboVal;
		}

		var gridObj = this.getComparisontable();
		var gridStore = gridObj.getStore();
		var gridRecordCount = gridObj.getStore().getCount();
		if (gridRecordCount == 0) {
		Ext.Msg.show({
					title : templatesAlertLbl,
					msg : measureAlertMsg,
					buttons : Ext.MessageBox.OK,
					icon : Ext.MessageBox.WARNING
				});
				return;
			}

		var testList=[];
		for ( var i = 0; i < gridRecordCount; i++) {
			var measuresHidVal = gridObj.getStore().getAt(i).get('hidVal');
			var test = measuresHidVal.substr(0, measuresHidVal.indexOf(":"));
			testList[i]=test;		  
		}
	
		if(!Ext.isEmpty(testList))
		{
			param=param+'&testList='+encodeURIComponent(testList);
		}	
	
		Ext.Ajax.request({
			url : '/final/servlet/com.eg.EgTemplateBuilderController',
			params: param,
			scope: this,
			method: 'POST',
			success: function(response)
			{
				var jsontext = response.responseText;
				var jsonData = Ext.decode(jsontext);
				if (!Ext.isEmpty(jsonData))
				{
					var rootJson =  jsonData['componentTypeComboData'];
					var compTypeJson=rootJson['availCompTypes'];
					var compTypeComboObj=Ext.getCmp('compTypeCombo');
					if(!Ext.isEmpty(compTypeComboObj) && compTypeJson !=null  && compTypeJson !='')
					{
						compTypeComboObj.suspendEvents(true);
						compTypeComboObj.getStore().removeAll();
						compTypeComboObj.getStore().loadRawData(compTypeJson);
						compTypeComboObj.setValue('-1');
						compTypeComboObj.resumeEvents();		
					}										
				}
			}
		});
	},

	loadComponentsForCompType : function(combo)
	{	
		var serverdescripComboObj=Ext.getCmp('serverdescripCombo');
		var serverdescripComboVal = serverdescripComboObj.getValue(); 
		
		if(combo.getValue()=="-1")
		{
			var componentsFilterObj=Ext.getCmp('compFilterItmSel');

			if(!Ext.isEmpty(componentsFilterObj))
			{
				componentsFilterObj.suspendEvents(true);
				componentsFilterObj.getStore().removeAll();
				componentsFilterObj.reset();
			}
			return;
		}
		
		var componentsFilterObj=Ext.getCmp('compFilterItmSel');

		if(!Ext.isEmpty(componentsFilterObj))
		{
			componentsFilterObj.suspendEvents(true);
			componentsFilterObj.getStore().removeAll();
			componentsFilterObj.reset();
		}
			
		var widgetName = '';
		widgetName = Ext.getCmp('WidgetNametextField').getValue();
		var widgetLbl = Ext.getCmp('userDefinedWidgetNameLbl');
		if(widgetLbl!=null && widgetLbl.isVisible())
		{
			widgetName = $('#userDefinedWidgetNameLbl').text();
		}
		widgetName.trim();
		
		var paramsForRc = 'action=getExcludeAndIncludeServers&selectedCompType=' + combo.getValue();
		var templateLayoutObj = Ext.getCmp('templateLayoutObj');
		var templateName = templateLayoutObj.profileName;
		if(!Ext.isEmpty(templateName))
		{
			paramsForRc=paramsForRc+'&profileName='+encodeURIComponent(templateName);
		}

		if(!Ext.isEmpty(serverdescripComboVal))
		{
			  	paramsForRc=paramsForRc+'&selectedType='+encodeURIComponent(serverdescripComboVal);
		}

		if(!Ext.isEmpty(widgetName))
		{
			paramsForRc=paramsForRc+'&widgetName='+encodeURIComponent(widgetName);
		}
		
		Ext.Ajax.request(
		{
			url : '/final/servlet/com.eg.EgTemplateBuilderController',
			params: paramsForRc,
			scope: this,
			method: 'POST',
			success: function(response)
			{
				var jsontext = response.responseText;
				var jsonData = Ext.decode(jsontext);
				if (!Ext.isEmpty(jsonData))
				{
					var serverOptJson=jsonData['serverOptsJson'];
					if(!Ext.isEmpty(serverOptJson))
					{
						if(serverdescripComboVal=="Component"){
							var componentsFilterObj=Ext.getCmp('compFilterItmSel');
	
							if(!Ext.isEmpty(componentsFilterObj))
							{
								componentsFilterObj.suspendEvents(true);
								componentsFilterObj.getStore().removeAll();
								componentsFilterObj.reset();
		
								componentsFilterObj.getStore().loadRawData(serverOptJson['componentsOptsJson']);
								componentsFilterObj.setValue(serverOptJson['excludedComponents']);
								componentsFilterObj.resumeEvents();
								preExcludedComponents=serverOptJson['excludedComponents'];
							}
						}else{
							
							if(!Ext.isEmpty(componentsComboFilterObj))
							{
								componentsComboFilterObj.suspendEvents(true);
								componentsComboFilterObj.getStore().removeAll();
								componentsComboFilterObj.getStore().loadRawData(serverOptJson['componentsOptsJson']);
								componentsComboFilterObj.setValue('-1');
								componentsComboFilterObj.resumeEvents();		
							}
						}
					}
				}
				jsonData=null;
				jsontext=null;
				componentsFilterObj	=null;
			}
		});
	
	},

	saveExcludeIncludeWidgetConfig : function()
	{	
		var userdefinedWidgetWindowObj1 = this.getUserDefinedWidgetWindow();
			if (Ext.isEmpty(userdefinedWidgetWindowObj1))
				userdefinedWidgetWindowObj1 = Ext.widget('userDefinedWidgetWindow');

		/*if (Ext.getCmp('compFilterItmSel').toField.getStore().getCount() <= 0 && Ext.getCmp('compFilterItmSel').fromField.getStore().getCount() <= 0 ) {
			Ext.Msg.show({
				title : templatesAlertLbl,
				msg : excludeServerAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});
			return;
		}*/
		var widgetName = '';
		widgetName = Ext.getCmp('WidgetNametextField').getValue();
		var widgetLbl = Ext.getCmp('userDefinedWidgetNameLbl');
		if(widgetLbl!=null && widgetLbl.isVisible())
		{
			widgetName = $('#userDefinedWidgetNameLbl').text();
		}
		widgetName.trim();

		if(Ext.isEmpty(widgetName))
		{
			Ext.Msg.show({
				title : templatesAlertLbl,
				msg : widgetBlankNameAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});
			return;
		}
		
		var paramsForRc = '';

		var serverdescripComboObj=Ext.getCmp('serverdescripCombo');
		var serverdescripComboVal = serverdescripComboObj.getValue(); 

		if(serverdescripComboVal=="Component")
		{
			paramsForRc = 'action=saveExcludeIncludeComponentConfig';
			var templateLayoutObj = Ext.getCmp('templateLayoutObj');
			var templateName = templateLayoutObj.profileName;
			if(!Ext.isEmpty(templateName))
			{
				paramsForRc=paramsForRc+'&profileName='+encodeURIComponent(templateName);
			}

			if(!Ext.isEmpty(widgetName))
			{
				paramsForRc=paramsForRc+'&widgetName='+encodeURIComponent(widgetName);
			}	 
			var compTypeComboObj = Ext.getCmp('compTypeCombo');
			var compType = compTypeComboObj.getValue(); 

			if(!Ext.isEmpty(compType))
			{
				paramsForRc=paramsForRc+'&compType='+encodeURIComponent(compType);
			}

			var excludedComponent ='';
			var excludedComponents = Ext.getCmp('compFilterItmSel').getValue();
			if(!reGenerateCompsFromExclude)
			{
				var preExcludedComponentsArr = preExcludedComponents.split(',');
				if(preExcludedComponentsArr.length == excludedComponents.length)
				{
					for ( var i = 0; i < excludedComponents.length; i++) 
					{
						if(!preExcludedComponentsArr.includes(excludedComponents[i]))
						{
							reGenerateCompsFromExclude = true;
							break;
						}
					}
				}
				else
				{
					reGenerateCompsFromExclude = true;
				}
			}
			if(excludedComponents!=null && !Ext.isEmpty(excludedComponents) && excludedComponents!='')
			{
					paramsForRc = paramsForRc + "&excludedComponents="+encodeURIComponent(excludedComponents);
			}else{
				paramsForRc = paramsForRc + "&excludedComponents=";
			}
			
			var records =  Ext.getCmp('compFilterItmSel').fromField.getStore().getRange();
			var availableItems=[];
			Ext.each(records, function(item, idx) {
				availableItems[idx]=item.getData().valueField;
			});

			if(availableItems=='-1' || excludedComponents=='-1')
			{	 
				Ext.Msg.show({
						title : templatesAlertLbl,
						msg : noElementsAvail,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
				});
				return;	
			}

			var userdefinedWidgetWindowObj = this.getUserDefinedWidgetWindow();
			if (Ext.isEmpty(userdefinedWidgetWindowObj))
				userdefinedWidgetWindowObj = Ext.widget('userDefinedWidgetWindow');

			var actionOnWidget = '';
			actionOnWidget =userdefinedWidgetWindowObj.widgetAction;
			
			if(actionOnWidget == 'modify Widget')
			{
				var prevWidgetName = userdefinedWidgetWindowObj.internalId;
				if(prevWidgetName!=null && prevWidgetName!='')
				{
					paramsForRc = paramsForRc + "&prevWidgetName="+ encodeURIComponent(prevWidgetName);
				}
			}
			paramsForRc = paramsForRc + "&actionOnWidget="+ encodeURIComponent(actionOnWidget);

			var measList=[];
			var j=0;
			for ( var i = 0; i < gridRecordCount; i++) {

				var measuresHidVal = gridObj.getStore().getAt(i).get('hidVal');
				var test = measuresHidVal.substr(0, measuresHidVal.indexOf(":"));
				var measConfTemp = measuresHidVal.substr(0,measuresHidVal.indexOf("!!!"));
				var measConf = measConfTemp.substr(measConfTemp.indexOf(":")+1);
				var measure = '';

				if(measConf.indexOf('$!')>-1)
				{
					var measureVal = measConf.split('$!');
					for ( var measVal in measureVal) {
						var measure = measureVal[measVal];
						if(selectedTest ==	test)
						{ 
							measList[j]=measure;
							j++
						}
					}
				}else{
					measure = measConf;
					if(selectedTest ==	test)
					{ 
						measList[j]=measure;
						j++
					}
				}				
			}
			paramsForRc = paramsForRc + "&measList="+encodeURIComponent(measList);

		}else if(serverdescripComboVal=="Descriptor")
		{	
			var gridObj = this.getComparisontable();
			var gridStore = gridObj.getStore();
			var gridRecordCount = gridObj.getStore().getCount();
			if (gridRecordCount == 0) {
				Ext.Msg.show({
						title : templatesAlertLbl,
						msg : measureAlertMsg,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
				});
				return;
			}
			var userdefinedWidgetWindowObj = this.getUserDefinedWidgetWindow();
			if (Ext.isEmpty(userdefinedWidgetWindowObj))
				userdefinedWidgetWindowObj = Ext.widget('userDefinedWidgetWindow');
			
			var chartType=userdefinedWidgetWindowObj.chartType;
			if(chartType=='')
			{
				chartType = userdefinedWidgetWindowObj.configuredDataValue.DisplayType;
			}
			if(chartType=='' || chartType==undefined)
			{
				chartType='TopNGaugeChart';
			}
				
			paramsForRc = 'action=saveExcludeIncludeTopNDescriptorConfig';

			//var excludedDesc = Ext.getCmp('compFilterItmSel').getValue();
			var excludedIncDesc = Ext.getCmp('descMultiselect').getValue();

			/*var records =  Ext.getCmp('compFilterItmSel').fromField.getStore().getRange();
			var availableItems=[];
			Ext.each(records, function(item, idx) {
				availableItems[idx]=item.getData().valueField;
			});*/
			
			if(!reGenerateCompsFromExclude)
			{
				if(preExcludedDescriptors.length == excludedIncDesc.length)
				{
					for ( var i in excludedIncDesc) 
					{
						if(!preExcludedDescriptors.includes(excludedIncDesc[i]))
						{
							reGenerateCompsFromExclude = true;
							break;
						}
					}
				}
				else
				{
					reGenerateCompsFromExclude = true;
				}
			}

			var needToSkipNone = false;
			var needToSkipAllDesc = false;
			for(var desc in excludedIncDesc)
			{
				var descVal = excludedIncDesc[desc];
				if(descVal == 'None' && excludedIncDesc.length>1)
				{
					needToSkipNone = true;
				}
				if(descVal == 'allDescriptors' && excludedIncDesc.length>1)
				{
					needToSkipAllDesc = true;
				}
			}

			if(needToSkipAllDesc)
			{	
				Ext.Msg.show({
							title : templatesAlertLbl,
							msg : allDescAlertMsg,
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING
					});
					return;
			}

			if(needToSkipNone)
			{	
				Ext.Msg.show({
							title : templatesAlertLbl,
							msg : noneDescAlertMsg,
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING
					});
					return;
			}
			
			var actionOnDescriptors = '';
			var excIncludeRadioOptObj=Ext.getCmp('excIncludeRadioOpt');
			if(!Ext.isEmpty(excIncludeRadioOptObj))
			{			
				actionOnDescriptors = excIncludeRadioOptObj.getValue().descOpt;
				paramsForRc=paramsForRc+'&actionOnDescriptors='+actionOnDescriptors;
			}

			if(excludedIncDesc == null || excludedIncDesc == -1 || excludedIncDesc.length==0)
			{	 
				Ext.Msg.show({
						title : templatesAlertLbl,
						msg : noElementsAvail,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
				});
				return;
			}

			var templateLayoutObj = Ext.getCmp('templateLayoutObj');
			var templateName = templateLayoutObj.profileName;
			if(!Ext.isEmpty(templateName))
			{
				paramsForRc=paramsForRc+'&profileName='+encodeURIComponent(templateName);
			}
			widgetName=this.filterEncode(widgetName);
			if(!Ext.isEmpty(widgetName))
			{
				paramsForRc=paramsForRc+'&widgetName='+encodeURIComponent(widgetName);
			}
			excludedIncDesc=this.filterEncode(excludedIncDesc);
			if(excludedIncDesc!=null && !Ext.isEmpty(excludedIncDesc) && excludedIncDesc!='' && excludedIncDesc!='-1')
			{
					paramsForRc = paramsForRc + "&descriptorsForUpdate="+encodeURIComponent(excludedIncDesc);
			}else{
				paramsForRc = paramsForRc + "&descriptorsForUpdate=";
			}	 

			var actionOnWidget = '';
			actionOnWidget =userdefinedWidgetWindowObj.widgetAction;
		
			if(actionOnWidget == 'modify Widget')
			{
				var prevWidgetName = userdefinedWidgetWindowObj.internalId;
				if(prevWidgetName!=null && prevWidgetName!='')
				{
					paramsForRc = paramsForRc + "&prevWidgetName="+ encodeURIComponent(prevWidgetName);
				}
			}
			paramsForRc = paramsForRc + "&actionOnWidget="+ encodeURIComponent(actionOnWidget);
			paramsForRc = paramsForRc + "&chartType="+ encodeURIComponent(chartType);


			var gridObj = this.getComparisontable();
			var gridStore = gridObj.getStore();
			var gridRecordCount = gridObj.getStore().getCount();
			if (gridRecordCount == 0) {
			Ext.Msg.show({
					title : templatesAlertLbl,
					msg : measureAlertMsg,
					buttons : Ext.MessageBox.OK,
					icon : Ext.MessageBox.WARNING
				});
				return;
			}

			/*var testComboValObj = Ext.getCmp('testComboValue');
			var selectedTest = '';
			if(!Ext.isEmpty(testComboValObj))
			{
				selectedTest=testComboValObj.getValue();
			}


			if(selectedTest=='' || selectedTest==undefined || selectedTest=='-1'){
				for ( var i = 0; i < gridRecordCount; i++) {
					var measuresHidVal = gridObj.getStore().getAt(i).get('hidVal');
					selectedTest = measuresHidVal.substr(0, measuresHidVal.indexOf(":"));  
				}
			}

			if(selectedTest!=null && !Ext.isEmpty(selectedTest))
			{
				 paramsForRc=paramsForRc+'&test='+encodeURIComponent(selectedTest);
			}*/	
		}
	
		Ext.Ajax.request(
		{
			url : '/final/servlet/com.eg.EgTemplateBuilderController',
			params: paramsForRc,
			scope: this,
			method: 'POST',
			success: function(response)
			{
				var jsontext = response.responseText;
				var jsonData = Ext.decode(jsontext);
				if (!Ext.isEmpty(jsonData))
				{
					var isUpdated = jsonData['updated'] ;
					if(isUpdated){
							Ext.Msg.show({
							title : templatesAlertLbl,
							msg : 'Exclude/Include Element Saved Successfuly',
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING
						});
					}
					var descriptorItemSelObj=Ext.getCmp('descriptorItemSel');
					descriptorItemSelObj.settedValues=excludedIncDesc;
				}
				jsonData=null;
				jsontext=null;
				componentsFilterObj	=null;
			}
		});
	},	

	loadDescForSelectedTest : function(combo)
	{
		var test=combo.getValue();
		if(	test=='-1')
		{
			var componentsFilterObj=Ext.getCmp('compFilterItmSel');
			if(!Ext.isEmpty(componentsFilterObj))
			{
				componentsFilterObj.suspendEvents(true);
				componentsFilterObj.getStore().removeAll();
				componentsFilterObj.reset();
			}

			var descMultiselectObj=Ext.getCmp('descMultiselect');
			if(!Ext.isEmpty(descMultiselectObj))
			{
				descMultiselectObj.suspendEvents(true);
				descMultiselectObj.getStore().removeAll();
				descMultiselectObj.reset();
			}
			return;
		}	
		//this.loadDescriptorsForTopNWidgets(test);
	},

	loadDescriptorsForTopNWidgets: function(test)
	{
		var compTypeComboObj = Ext.getCmp('compTypeCombo');
		compTypeComboObj.hide();	
		
		var componentsFilterObj=Ext.getCmp('compFilterItmSel');

		if(!Ext.isEmpty(componentsFilterObj))
		{
			componentsFilterObj.suspendEvents(true);
			componentsFilterObj.getStore().removeAll();
			componentsFilterObj.reset();
		}

		var descMultiselectObj=Ext.getCmp('descMultiselect');
		if(!Ext.isEmpty(descMultiselectObj))
		{
			descMultiselectObj.suspendEvents(true);
			descMultiselectObj.getStore().removeAll();
			descMultiselectObj.reset();
		}

		var gridObj = this.getComparisontable();
		var gridStore = gridObj.getStore();
		var gridRecordCount = gridObj.getStore().getCount();
		if (gridRecordCount == 0) {
		Ext.Msg.show({
				title : templatesAlertLbl,
				msg : measureAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});
			return;
		}

		if(test=='' || test==undefined){
			for ( var i = 0; i < gridRecordCount; i++) {
				var measuresHidVal = gridObj.getStore().getAt(i).get('hidVal');
				test = measuresHidVal.substr(0, measuresHidVal.indexOf(":"));  
			}
		}
		
		var templateLayoutObj = Ext.getCmp('templateLayoutObj');
		var templateName = templateLayoutObj.profileName;

		var widgetName = '';
		widgetName = Ext.getCmp('WidgetNametextField').getValue();
		var widgetLbl = Ext.getCmp('userDefinedWidgetNameLbl');
		if(widgetLbl!=null && widgetLbl.isVisible())
		{
			widgetName = $('#userDefinedWidgetNameLbl').text();
		}
		widgetName.trim();

	 	var paramsForRc = 'C=true&F=getDescriptorsForTBTopNWidget&P0={' + test + '}&P1={' + templateName + '}&P2={' + widgetName + '}&calljson=true';

		Ext.Ajax.request({
			url : '/final/servlet/com.eg.EgMonRemoteScriptingServlet',
			method : 'POST',
			params : paramsForRc + '&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
			scope : this,
			async : true,
			success : function(response) {
				var jsonText = response.responseText;
				if (jsonText != null && jsonText != '') {
					var jsonData = Ext.decode(jsonText);
						
					var descMultiselectObj=Ext.getCmp('descMultiselect');

					if(!Ext.isEmpty(descMultiselectObj) && !Ext.isEmpty(jsonData['descriptorsList'])  )
					{
						descMultiselectObj.suspendEvents(true);
						descMultiselectObj.getStore().removeAll();
						descMultiselectObj.reset();

						descMultiselectObj.getStore().loadRawData(jsonData['descriptorsList']);
						descMultiselectObj.setValue(jsonData['selectedDescriptor']);
						descMultiselectObj.resumeEvents();
						
						var descriptorItemSelObj=Ext.getCmp('descriptorItemSel');
						descriptorItemSelObj.settedValues=jsonData['selectedDescriptor'];
						preExcludedDescriptors=jsonData['selectedDescriptor'];

						/*var value = descMultiselectObj.getStore().getAt(0).data.displayField;
						console.log('value==>  ',value);
						if(value !=null && value !='Not Applicable')
						{
							descMultiselectObj.getStore().insert(0, {
								displayField : 'All Descriptors',
								valueField : 'allDescriptors'
							});
						}*/
					}

					var actionOnDesc = jsonData.actionOnDesc;
					
					var updateExcludeIncludeObj=Ext.getCmp('updateExcludeInclude');
					if(!Ext.isEmpty(updateExcludeIncludeObj))
					{
						if(actionOnDesc=='Include')
						{
							updateExcludeIncludeObj.setText(screenLabelsObj['Include']);
						}
						else if(actionOnDesc=='Exclude')
						{
							updateExcludeIncludeObj.setText(screenLabelsObj['Exclude']);
						}
					}

					var excIncludeRadioOptObj = Ext.getCmp('excIncludeRadioOpt');
					if(!Ext.isEmpty(excIncludeRadioOptObj))
					{
						excIncludeRadioOptObj.suspendEvents(false);						
						excIncludeRadioOptObj.setValue({
							descOpt : actionOnDesc
						});						
						excIncludeRadioOptObj.resumeEvents();
						excIncludeRadioOptObj.show();
						excIncludeRadioOptObj=null;
						delete excIncludeRadioOptObj; 
					}
				}
			}
		});	
	},

	loadConfiguredTests: function()
	{
		var gridObj = this.getComparisontable();
		var gridStore = gridObj.getStore();
		var gridRecordCount = gridObj.getStore().getCount();
		if (gridRecordCount == 0) {
		Ext.Msg.show({
				title : templatesAlertLbl,
				msg : measureAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});
			return;
		}

		var testList=[];
		for ( var i = 0; i < gridRecordCount; i++) {
			var measuresHidVal = gridObj.getStore().getAt(i).get('hidVal');
			var test = measuresHidVal.substr(0, measuresHidVal.indexOf(":"));
			testList[i]=test;		  
		}

		var param = 'action=getDataForTestCombo';

		if(!Ext.isEmpty(testList))
		{
			param=param+'&testList='+encodeURIComponent(testList);
		}	
			Ext.Ajax.request({
			url : '/final/servlet/com.eg.EgTemplateBuilderController',
			method : 'POST',
			params : param,
			scope : this,
			async : true,
			success : function(response) {
				var jsonText = response.responseText;
				if (jsonText != null && jsonText != '') {
					var jsonData = Ext.decode(jsonText);

					var testComboValObj = Ext.getCmp('testComboValue');
					var testJsonData = jsonData['defaultTestComboData'];
					if(!Ext.isEmpty(testComboValObj))
					{
						testComboValObj.suspendEvents(true);
						testComboValObj.getStore().removeAll();
						testComboValObj.getStore().loadRawData(testJsonData['availTests']);
						testComboValObj.setValue('-1');
						testComboValObj.resumeEvents();
						testComboValObj.show();
					}
				}
			}
		});	


	},

	loadComponentTypeFilter : function(combo)
	{
		var multiSelectComboVal=combo.getValue();
		var infraTypeComboObj=Ext.getCmp('infraTypeCombo');

		if(Ext.isEmpty(multiSelectComboVal))
		{
			var optsArr=[];
			optsArr.push({
				'displayField' : 'Not Available',
				'valueField': '-1'
			});
			var compTypeFilterComboObj=Ext.getCmp('compTypeFilterComboObj');
			if(!Ext.isEmpty(compTypeFilterComboObj))
			{
				compTypeFilterComboObj.getStore().removeAll();
				compTypeFilterComboObj.getStore().loadRawData(optsArr);
				compTypeFilterComboObj.setValue('-1');
			}
		}
		else
		{
			var selectedInfraType=infraTypeComboObj.getValue();
			if(selectedInfraType!=null && selectedInfraType=='components')
			{
				var multiSelectComboStore=combo.getStore();
				var compTypesForSave='';
				var optsArr=[];
				optsArr.push({
						'displayField' : 'Please choose a component type',
						'valueField': '-1'
					});
				for ( var comp in multiSelectComboVal) {
					var selectedComp = multiSelectComboVal[comp];
					var measRecord = multiSelectComboStore.findRecord(combo.valueField, selectedComp, 0, false, true, true);
					optsArr.push({
						'displayField' : measRecord.get('displayField'),
						'valueField': selectedComp
					});
				}
				var compTypeFilterComboObj=Ext.getCmp('compTypeFilterComboObj');
				
				if(!Ext.isEmpty(compTypeFilterComboObj))
				{
					compTypeFilterComboObj.suspendEvents(true);
					compTypeFilterComboObj.getStore().removeAll();
					compTypeFilterComboObj.getStore().loadRawData(optsArr);
					compTypeFilterComboObj.setValue('-1');
					compTypeFilterComboObj.resumeEvents();
				}
			}
			else
			{
				var paramsForRc = 'action=getServersForInfraType&selectedInfraType='+infraTypeComboObj.getValue()+'&selectedElements=' + combo.getValue();
				var profileName = Ext.getCmp('templateName').getValue();
				if(!Ext.isEmpty(profileName))
				{
					paramsForRc=paramsForRc+'&profileName='+encodeURIComponent(profileName);
				}
				Ext.Ajax.request(
				{
					url : '/final/servlet/com.eg.EgTemplateBuilderController',
					params: paramsForRc,
					scope: this,
					method: 'POST',
					success: function(response)
					{
						var jsontext = response.responseText;
						var jsonData = Ext.decode(jsontext);
						if (!Ext.isEmpty(jsonData))
						{
							var compTypeJson=jsonData['compTypeJson'];
							var compTypeFilterComboObj=Ext.getCmp('compTypeFilterComboObj');
							if(!Ext.isEmpty(compTypeFilterComboObj))
							{
								compTypeFilterComboObj.suspendEvents(true);
								compTypeFilterComboObj.getStore().removeAll();
								compTypeFilterComboObj.getStore().loadRawData(compTypeJson);
								compTypeFilterComboObj.resumeEvents();
							}
						}
					}
				});
			}
		}
	},
	loadComponentsForSelection : function(combo)
	{
		var paramsForRc = 'action=getServersForType&selectedCompType=' + combo.getValue();
		var profileName = Ext.getCmp('templateName').getValue();
		if(!Ext.isEmpty(profileName))
		{
			paramsForRc=paramsForRc+'&profileName='+encodeURIComponent(profileName);
		}
		if(combo.getValue()=="-1")
		{
			return;
		}
		Ext.Ajax.request(
		{
			url : '/final/servlet/com.eg.EgTemplateBuilderController',
			params: paramsForRc,
			scope: this,
			method: 'POST',
			success: function(response)
			{
				var jsontext = response.responseText;
				var jsonData = Ext.decode(jsontext);
				if (!Ext.isEmpty(jsonData))
				{
					var compOptJson=jsonData['compOptsJson'];
					if(!Ext.isEmpty(compOptJson))
					{
						var componentsFilterObj=Ext.getCmp('componentsFilterItmSel');
						if(!Ext.isEmpty(componentsFilterObj))
						{
							componentsFilterObj.suspendEvents(true);
						//	componentsFilterObj.fromField.getStore().removeAll();
						//	componentsFilterObj.toField.getStore().removeAll();
							componentsFilterObj.getStore().removeAll();
							componentsFilterObj.reset();
						//s	componentsFilterObj.getStore().load();
						
							componentsFilterObj.getStore().loadRawData(compOptJson['componentsOptsJson']);
							componentsFilterObj.setValue(compOptJson['excludedServers']);
							componentsFilterObj.resumeEvents();
	
						}
					}
				}
				jsonData=null;
				jsontext=null;
			}
		});
	},
	excludeComponents : function(itemSelObj)
	{
		
		var profileName = Ext.getCmp('templateName').getValue();
		if(Ext.isEmpty(profileName))
		{
			Ext.Msg.show({
				title : templatesAlertLbl,
				msg : templateBlankNameAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});
			return;
		}
		var excludedComponents = Ext.getCmp('componentsFilterItmSel').getValue();
			if (Ext.getCmp('componentsFilterItmSel').toField.getStore().getCount() <= 0) {
				Ext.Msg.show({
					title : templatesAlertLbl,
					msg : excludeServerAlertMsgs,
					buttons : Ext.MessageBox.OK,
					icon : Ext.MessageBox.WARNING
				});
				return;
			}
		var paramsForRc = 'action=saveExcludeServer&excludedComponents=' + encodeURIComponent(excludedComponents)+'&profileName='+encodeURIComponent(profileName);
		
		Ext.Ajax.request(
		{
			url : '/final/servlet/com.eg.EgTemplateBuilderController',
			params: paramsForRc,
			scope: this,
			method: 'POST',
			success: function(response)
			{
				var jsontext = response.responseText;
				var jsonData = Ext.decode(jsontext);
				if (!Ext.isEmpty(jsonData))
				{
					if(jsonData['update'] == 'success')
					{
						Ext.Msg.show({
							title : templatesAlertLbl,
							msg : "Components excluded successfully",
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING
						});
					}
				}
			}
		});
	},
	showStackedChart : function(chkBoxObj)
	{
	
		if(!Ext.isEmpty(chkBoxObj))
		{
			var userDefinedWidgetWindowObj = this.getUserDefinedWidgetWindow();
			var configForm = userDefinedWidgetWindowObj.getComponent('configForm').getForm();
			var stackedAreachartOpt = chkBoxObj.getChecked();
			if(!Ext.isEmpty(stackedAreachartOpt))
			{
				var isStacked = stackedAreachartOpt[0].inputValue;
				if(isStacked!=null && isStacked=='Yes') {
					var aggOptObj=configForm.findField('showAggOpt');
					if(!Ext.isEmpty(aggOptObj))
					{
						configForm.findField('showAggOpt').hide();
						configForm.findField('AggrfnCombo').show();
						var aggFnValue=configForm.findField('AggrfnCombo').getValue();
						if(Ext.isEmpty(aggFnValue))
						{
							configForm.findField('AggrfnCombo').setValue('avg');
						}
					}
				} else {
					var aggOptObj=configForm.findField('showAggOpt');
					if(!Ext.isEmpty(aggOptObj))
					{
						var showAggOptObj=aggOptObj.getChecked();
						var showAggOpt = showAggOptObj[0].inputValue;
						if (showAggOpt != null && showAggOpt == 'yes') {
							configForm.findField('AggrfnCombo').show();
							var selectedAggFnVal=configForm.findField('AggrfnCombo').getValue();
							if(Ext.isEmpty(selectedAggFnVal))
							{
								configForm.findField('AggrfnCombo').setValue('avg');
							}
						} else {
							configForm.findField('AggrfnCombo').hide();

						}
						aggOptObj.show();
					}
				}
			}
		}
	},
	durationComboOnChange : function(periodComboObj)
	{
		var obj = Ext.getCmp('Timeline');
		var periodVal=periodComboObj.getValue();
		var timeline = obj.getValue();
		if ( periodVal!=null && periodVal.toLowerCase()==("h") )
		{
			timeline="24 hours";
		}
		else if ( periodVal!=null && periodVal.toLowerCase()==("d") )
		{
			timeline="1 week";
		}
		else if ( periodVal!=null && periodVal.toLowerCase()==("m") )
		{
			timeline="6 months";
		}
		var param="comesFrom=templateBuilder&action=TrendDurationChanged&time="+timeline+"&period="+periodVal;
		Ext.Ajax.request(
		{
			url: '/final/servlet/com.eg.EgMonitorRequestDispatcher',
			params: param,
			scope: this,
			method: 'POST',
			success: function(response)
			{
				var jsontext = response.responseText;
				var jsonData = Ext.decode(jsontext);
				if (!Ext.isEmpty(jsonData))
				{
					var timelineComboObj = Ext.getCmp('Timeline');
					timelineComboObj.getStore().loadRawData(jsonData['timelinedetails']['timeline']);
					timelineComboObj.setValue(timeline);
				}
			}
		});
	},
	createWidget: function()
	{
		var meC =this;
		var sizeX = 4;
		var sizeY = 5;
		var count = 0;
		var templateConfigDetails = publicJson['templateConfigDetails'];
		var layoutchoosen = templateConfigDetails['layout'];
		var widResize=true;
		if(widgetsforTemplateView > 0)
		{
			if(layoutchoosen!=null && layoutchoosen == 'Tabular')
			{
				if(widgetsforTemplateView%2 == 1)
				{
					sizeX = 9;
				}
				else
				{
					sizeX = 4;
				}
			}
			else if(layoutchoosen!=null && layoutchoosen == 'Relative')
			{
				sizeX = 12;
			}
		}
		else if(layoutchoosen!=null && layoutchoosen == 'Relative')
		{
			sizeX = 12;
		}
		if(layoutchoosen!=null && layoutchoosen == 'Custom')
		{
			widResize=false;
		}
		widgetsforTemplateView = parseInt(widgetsforTemplateView);
		widgetsforTemplateView = widgetsforTemplateView+1;
		maxBlockId = parseInt(maxBlockId);
		maxBlockId = maxBlockId+1;

		var templateConfigDetails=publicJson['templateConfigDetails'];
		if(templateConfigDetails!=null && templateConfigDetails.hasOwnProperty('dashboardLayoutType'))
		{
			if(templateConfigDetails['dashboardLayoutType']!=null && templateConfigDetails['dashboardLayoutType']=="Custom")
			{
				sizeX=null;
			}
		}
		var newWidget = {
							'x'  :   0,
							'y'  :   0,
							'width'  :   sizeX,
							'height'  :   sizeY,
							'id':'block'+maxBlockId,
							'widgetType':'',
							'noResize':widResize,
							'internalId' : '',
							'widget_name' : 'block'+maxBlockId,
							 'widgetNum' : 'Widget '+maxBlockId,
							'autoPosition'  :  true
		};
		$('.grid-stack').data('gridstack').batchUpdate();
		Ext.getCmp('gridstackpanelObj')._addWidget(newWidget,'addWidget','Widget '+maxBlockId, 'configureWidgetDefaultIcon', 'configureWidgetDefaultIcon');
		$('.grid-stack').data('gridstack').commit();
	},
	loadDDColumns : function(combo)
	{
		this.loadManualDDColumns(combo,'','');
	},
	
	loadManualDDColumns : function(combo,selectedDDValues,selectedSummarizedDDValues)
	{
		if(combo.isManualLoading && selectedDDValues == '' && selectedSummarizedDDValues== '')
		{
			combo.isManualLoading = false;
			return;
		}
		if(tempSelectedGraph!=null && tempSelectedGraph == 'DDTable')
		{
			var thisController = this;
			var selectedTest = Ext.getCmp('testCombo').getValue();
			var selectedMeasure = combo.getValue();
			var ddMeasureCols = Ext.getCmp('ddcolumnsMultiSelect');
			var graphicalTypeObj = Ext.getCmp('graphicalTypeId');
			var summarizeDDColumnComboObj = Ext.getCmp('summarizeDDColumnCombo');
			if (selectedMeasure != null && selectedTest!=null && selectedTest!='-1' && selectedMeasure!='-1')
			{
				Ext.Ajax.request({
							url : '/final/servlet/com.eg.EgTemplateBuilderController',
							method : 'POST',
							params : 'action=getDDColumnsJSON&selectedTest='+encodeURIComponent(selectedTest)+'&selectedMeasure='+selectedMeasure,
							scope : this,
							success : function(response) {
								var jsonText = response.responseText;
								if (jsonText != null && jsonText != '') {
									var jsonDtaforDDCols = Ext.decode(jsonText);
									var ddcolumns = jsonDtaforDDCols['DDColumns']['ddColumns'];
									if(ddcolumns!=null && !Ext.isEmpty(ddcolumns))
									{
										var ddMeasureColsComboStore = ddMeasureCols.getStore();
										ddMeasureColsComboStore.removeAll();
										ddMeasureColsComboStore.loadRawData(ddcolumns);
										if(selectedDDValues!=null && selectedDDValues != '')
										{
											combo.isManualLoading = false;
											ddMeasureCols.setValue(selectedDDValues);
										}
										if(combo.isVisible())
										{
											Ext.getCmp('ddcolumnsLbl').show();
											ddMeasureCols.show();
										}
										
										if(!Ext.isEmpty(graphicalTypeObj))
										{
											if(!Ext.isEmpty(summarizeDDColumnComboObj))
											{
												var summarizeDDColumnComboStore = summarizeDDColumnComboObj.getStore();
												summarizeDDColumnComboStore.removeAll();
												summarizeDDColumnComboStore.loadRawData(ddcolumns);
												summarizeDDColumnComboStore.insert(0, {
													displayField : 'Please choose a dd column',
													valueField : '-1'
												});
												if(selectedSummarizedDDValues!=null && selectedSummarizedDDValues != '')
												{
													summarizeDDColumnComboObj.setValue(selectedSummarizedDDValues);
												}
												else
												{
													summarizeDDColumnComboObj.setValue('-1');
												}
											}
											var selectedChartType = graphicalTypeObj.getValue();
											if(selectedChartType != null && selectedChartType != 'Table')
											{
												summarizeDDColumnComboObj.show();
											}
										}
									}
									else if(Ext.isEmpty(ddcolumns))
									{
										var ddMeasureColsComboStore = ddMeasureCols.getStore();
										ddMeasureColsComboStore.removeAll();
										ddMeasureColsComboStore.insert(0, {
										displayField : notApplicable,
										valueField : '-1'
										});
										ddMeasureCols.setValue('-1');
										if(combo.isVisible())
										{
											Ext.getCmp('ddcolumnsLbl').show();
											ddMeasureCols.show();
										}
							
										if(!Ext.isEmpty(summarizeDDColumnComboObj))
										{
											var summarizeDDColumnComboStore = summarizeDDColumnComboObj.getStore();
											summarizeDDColumnComboStore.removeAll();
											summarizeDDColumnComboStore.insert(0, {
												displayField : notApplicable,
												valueField : '-1'
											});
											summarizeDDColumnComboObj.setValue('-1');
										}
									}
								}
							}
						});
			}
			else
			{
				var ddMeasureColsComboStore = ddMeasureCols.getStore();
				ddMeasureColsComboStore.removeAll();
				ddMeasureColsComboStore.insert(0, {
				displayField : notApplicable,
				valueField : '-1'
				});
				ddMeasureCols.setValue('-1');
				if(combo.isVisible())
				{
					Ext.getCmp('ddcolumnsLbl').show();
					ddMeasureCols.show();
				}
							
				if(!Ext.isEmpty(summarizeDDColumnComboObj))
				{
					var summarizeDDColumnComboStore = summarizeDDColumnComboObj.getStore();
					summarizeDDColumnComboStore.removeAll();
					summarizeDDColumnComboStore.insert(0, {
						displayField : notApplicable,
						valueField : '-1'
					});
					summarizeDDColumnComboObj.setValue('-1');
				}
			}
		}
	},
	showAggOptions : function(radioBtnObj) {
		var showAggOptObj = radioBtnObj.getChecked();
		var showAggOpt = showAggOptObj[0].inputValue;
		if (showAggOpt != null && showAggOpt == 'yes') {
			Ext.getCmp('AggrfnCombo').show();
			Ext.getCmp('AggrfnCombo').setValue('avg');
			if(tempSelectedGraph!=null && tempSelectedGraph == 'TabularView')
			{
				if(!Ext.isEmpty(Ext.getCmp('EnableMeasureStateColor')))
				{
					Ext.getCmp('EnableMeasureStateColor').hide();
					Ext.getCmp('SetStateColorOn').hide();
				}
			}
		} else {
			Ext.getCmp('AggrfnCombo').hide();
			if(tempSelectedGraph!=null && tempSelectedGraph == 'TabularView')
			{
				if(!Ext.isEmpty(Ext.getCmp('EnableMeasureStateColor')))
				{
					Ext.getCmp('EnableMeasureStateColor').show();
					var enableColorVal = Ext.getCmp('EnableMeasureStateColor').getValue();
					if(enableColorVal!=null && enableColorVal==true)
					{
						Ext.getCmp('SetStateColorOn').setDisabled(false);
						Ext.getCmp('SetStateColorOn').show();
					}
					else
					{
						Ext.getCmp('SetStateColorOn').setDisabled(true);
						Ext.getCmp('SetStateColorOn').hide();
					}
				}
			}
		}
	},
	chartDistributionEvent : function(radioBtnObj) {
		var distribOptObj = radioBtnObj.getChecked();
		var distribOpt = distribOptObj[0].inputValue;
		if (distribOpt != null && distribOpt == 'Multiple') {
			Ext.getCmp('showAggOpt').hide();
			Ext.getCmp('AggrfnCombo').hide();
			Ext.getCmp('Legend Display').hide();
		} else {
				Ext.getCmp('showAggOpt').show();
				Ext.getCmp('showAggOpt').setValue({
									showAgg: 'no'
								});
				Ext.getCmp('Legend Display').show();
		}
	},
	showWidgetGallery : function(btn)
	{
		var addwidgetwindownew=this.getAddwidgetwindownew();
		if (Ext.isEmpty(addwidgetwindownew))
			addwidgetwindownew = Ext.widget('addwidgetwindownew');

		addwidgetwindownew.show();
		addwidgetwindownew=null;
					
		delete addwidgetwindownew;
	},
	widgetToogleFn : function(btnEvent,widgetName,widgetId,template_name,displayType,widgetBtnId,widgetTabType)
	{
		
		if(btnEvent!=null && btnEvent=='AddWidget')
		{
			return this.addWidgetFromWidgetGallery(widgetName,template_name,displayType,widgetBtnId,true,widgetTabType);
		}
		else
		{
			return this.deleteTemplateWidget(widgetId,widgetBtnId,template_name,true,widgetTabType);
		}
	},
	showAddWidgetGallerysWindow : function(btn)
	{
		var templateLayoutObj = Ext.getCmp('templateLayoutObj');
		var templateName = templateLayoutObj.profileName;
		var paramsForWidgetConfig='comesFrom=templateBuilder&action=loadWidgetGallery&profileName='+encodeURIComponent(templateName);
		var meC = this;
		Ext.Ajax.request({
			url : '/final/servlet/com.eg.EgMonitorRequestDispatcher',
			method : 'POST',
			params : paramsForWidgetConfig,
			scope : this,
			success : function(response) {
				var jsonText = response.responseText;
				if (jsonText != null && jsonText != '') {
					var jsonData = Ext.decode(jsonText);
						widGallerywindow = Ext.create('TemplateBuilder.view.WidgetLibrary',{
							windowMode:'small',
							url:'/final/servlet/com.eg.EgTemplateBuilderController?action=loadWidgetGalleryData&fromPaging=true&profileName='+encodeURIComponent(templateName)
						}).show();
				}
			},
			failure : function(response, opts) {
				console.log("Exception loading widget Gallery");
				}
			}
		);
		//widGallerywindow=null;
		//delete widGallerywindow;
	},
	loadDefaultView : function()
	{
		var meC = this;
		var mainPageView = this.getMain();
		var defaultAction = publicJson['action'];
		if (defaultAction == null || defaultAction == '' || defaultAction == 'null')
			defaultAction = 'loadMyTemplateListPage';
		
		var gridStackObj=Ext.getCmp('gridstackpanelObj');//_'+profName);
		if(!Ext.isEmpty(gridStackObj))
		{
			gridStackObj._removeAllWidget();
		}

		if (defaultAction != null && defaultAction == "loadMyTemplateListPage") {
			meC.loadListPage();
		}
		else if (defaultAction != null && defaultAction == "loadTemplateConfigView") {
			if(!isMonitorHome)
			{
				Ext.getCmp('templateListCombo').show();
				this.loadTemplateListCombo(publicJson['templateComboList'],publicJson['templateConfigDetails']['profileName']);
				Ext.getCmp('listPageHeaderMenu').hide();
			}
			Ext.getCmp('searchTemplate').hide();
			var templateConfigDetails = publicJson['templateConfigDetails'];
			mainPageView.setTitle('');
			mainPageView.add({
								xtype : 'templateLayout',
								profileName : publicJson['templateConfigDetails']['profileName'],
								isSharedTemplate : (publicJson['templateConfigDetails']['isSharedTemplate'] == "true"),
								isDefaultTemplate : (publicJson['templateConfigDetails']['isDefaultTemplate'] == "true"),
								layoutchoosen: publicJson['templateConfigDetails']['layout']
							});
			var templateConfigTools=this.getTemplategeneralsettings();
			if(publicJson['templateConfigDetails']['isSharedTemplate'] == "false" && !isMonitorHome)
			{
				if(publicJson['templateConfigDetails']['isDefaultTemplate'] == "false")
				{
					Ext.getCmp('templateConfigTools').show();
				}
			}
			else
			{
				Ext.getCmp('templateConfigTools').hide();
			}
			var templateTools = this.getTemplatetools();
			templateTools.show();
			templateTools.getComponent('listBtnContainer').show();
			templateTools=null;
			delete templateTools;
			mainPageView.doLayout();
			this.loadTemplateConfigurationView();
		}
	},
	fluidWindowModifyClick : function(c,action)
	{
		var portalPanlId = c;
		var internalId = Ext.getCmp(portalPanlId).internalId;
		var conftitle = portalPanlId;
		if(action == 'addWidget')
		{
			if(portalPanlId!=null)
			{
				var blocknum = portalPanlId.substring(portalPanlId.indexOf("block")+5);
				//conftitle ='widget '+blocknum;
				conftitle =screenLabelsObj['Widget'];
			}
		}
		if(internalId!=null && internalId!='')
		{
			conftitle = internalId;
		}
		if(conftitle!=null && conftitle.indexOf('|GRP|')>0)
		{
			conftitle = conftitle.substring(0,conftitle.indexOf('|GRP|'));
		}
		 conftitle= conftitle+' '+screenLabelsObj['Configuration'];
		 if(action == 'loadWidget')
		{
			action = 'modify Widget';
		}
		// var win = null;
		var userdefinedWidgetWindowObj = this.getUserDefinedWidgetWindow();
		if(!Ext.isEmpty(userdefinedWidgetWindowObj))
		{
			Ext.EventManager.removeAll('userDefinedWindowaa');
			userdefinedWidgetWindowObj.destroy();
			userdefinedWidgetWindowObj=null;
		}

		 userdefinedWidgetWindowObj = Ext.widget('userDefinedWidgetWindow', {
					blockId : portalPanlId,
					internalId : internalId,
					widgetAction :action,
					isFluidWindowConfigPopup : true
				});
		if (userdefinedWidgetWindowObj != null) {
					userdefinedWidgetWindowObj.setTitle(conftitle);
					userdefinedWidgetWindowObj.show();
			//win.setTitle(conftitle);
			//win.show();
		}

	},
	removeWidgetFromGroup : function(widgetInternalId,templateName)
	{
		if(widgetInternalId!=null && widgetInternalId!='' && templateName!=null)
		{
			var widgetLibWindObj=this.getWidgetLibrary();
			if (Ext.isEmpty(widgetLibWindObj))
			widgetLibWindObj = Ext.widget('widgetLibrary');

			Ext.Msg.show({
				title : templatesAlertLbl,
				msg : widgetDelAlertMsg,
				buttons : Ext.Msg.YESNO,
				icon : 'iconConfirmation',
				fn:function(buttonId)
				{
					if(buttonId == 'yes')
					{
						Ext.Ajax.request({
						url : '/final/servlet/com.eg.EgTemplateBuilderController',
						method : 'POST',
						params : 'action=deleteWidgetFromGrp&internalId='+widgetInternalId+'&templateName='+templateName,
						scope : this,
						success : function(response) {
								var jsonText = response.responseText;
								if (jsonText != null && jsonText != '') {
									var jsonDta = Ext.decode(jsonText);
									if(jsonDta['updated'] == 'true')
									{
										Ext.Msg.show({
											title : templatesAlertLbl,
											msg : "widget removed from Group successfully",
											buttons : Ext.MessageBox.OK,
											icon : Ext.MessageBox.WARNING
										});
										if(widgetLibWindObj!=null && !Ext.isEmpty(widgetLibWindObj))
										{
											widgetLibWindObj.close();
										}
									}
								}
								jsonText=null;
								delete jsonText;
							}
						});
					}
					else
					{
						return;
					}
				}
			});
		}
	},
	deleteWidgetGroup : function(grpName,grpOwner)
	{
		if(grpName!=null && grpName!='' && grpOwner!=null && grpOwner!='')
		{
			var widgetLibWindObj=this.getWidgetLibrary();
			if (Ext.isEmpty(widgetLibWindObj))
			widgetLibWindObj = Ext.widget('widgetLibrary');

			Ext.Msg.show({
				title : templatesAlertLbl,
				msg : widgetGrpDeleteAlertMsg,
				buttons : Ext.Msg.YESNO,
				icon : 'iconConfirmation',
				fn:function(buttonId)
				{
					if(buttonId == 'yes')
					{
						Ext.Ajax.request({
						url : '/final/servlet/com.eg.EgTemplateBuilderController',
						method : 'POST',
						params : 'action=deleteWidgetGrp&groupName='+grpName+'&groupOwner='+grpOwner,
						scope : this,
						success : function(response) {
								var jsonText = response.responseText;
								if (jsonText != null && jsonText != '') {
									var jsonDta = Ext.decode(jsonText);
									if(jsonDta['updated'] == 'true')
									{
										Ext.Msg.show({
											title : templatesAlertLbl,
											msg : "Group removed successfully",
											buttons : Ext.MessageBox.OK,
											icon : Ext.MessageBox.WARNING
										});
										if(widgetLibWindObj!=null && !Ext.isEmpty(widgetLibWindObj))
										{
											widgetLibWindObj.close();
										}
									}
								}
								jsonText=null;
								delete jsonText;
							}
						});
					}
					else
					{
						return;
					}
				}
			});
		}
	},
	addToWidgetLibRadioEvent : function(radioComp)
	{
		radioComp.suspendEvents(true);
		var addToWidgetLibRadioBtnObj = radioComp.getChecked();
		var addToWidgetLibRadioBtnOpt = addToWidgetLibRadioBtnObj[0].inputValue;
		var userDefinedWidgetWindowObj = this.getUserDefinedWidgetWindow();
		var configForm = userDefinedWidgetWindowObj.getComponent('configForm').getForm();
		var widgetgrpFieldCont =  Ext.getCmp('WidgetGrpFieldCont');
		if(addToWidgetLibRadioBtnOpt!=null && addToWidgetLibRadioBtnOpt=="yes")
		{
			widgetgrpFieldCont.show();
			var widgetGrpCombo = configForm.findField('widgetGrpCombo');
			widgetGrpCombo.suspendEvents(true);
			widgetGrpCombo.getStore().removeAll();
			/*widgetGrpCombo.getStore().insert(0, {
			displayField : 'Not Applicable',
			valueField : '-1'
			});
			widgetGrpCombo.setValue('-1');*/
			Ext.Ajax.request({
						url : '/final/servlet/com.eg.EgTemplateBuilderController',
						method : 'POST',
						params : 'action=getAvailbleWidgetGrps&comesFrom=widgetConfiguration',
						scope : this,
						success : function(response) {
							var jsonText = response.responseText;
							if (jsonText != null && jsonText != '') {
								var jsonDtaForGrps = Ext.decode(jsonText);
								widgtgrpArr = jsonDtaForGrps['AvailWidgetGrps'];
								if(widgtgrpArr!=null && !Ext.isEmpty(widgtgrpArr))
								{
									widgetGrpCombo.getStore().loadRawData(widgtgrpArr);
									if(associatedGrp!=null && associatedGrp!='')
									{
										widgetGrpCombo.setValue(associatedGrp);
									}
									else
									{
										widgetGrpCombo.setValue('-1');
									}
								}
							}
							jsonText=null;
							delete jsonText;
						}
					});
					widgetGrpCombo.resumeEvents();
					//widgetGrpCombo =null;
					//delete widgetGrpCombo;
		}
		else if(addToWidgetLibRadioBtnOpt!=null && addToWidgetLibRadioBtnOpt=="no")
		{
			widgetgrpFieldCont.hide();
		}
		radioComp.resumeEvents();
		radioComp =null;
		delete radioComp;
		widgetgrpFieldCont =null;
		delete widgetgrpFieldCont;
	},
	onWidgetGrpComboChange :function(combo)
	{
		combo.suspendEvents(true);
		var userDefinedWidgetWindowObj = this.getUserDefinedWidgetWindow();
		var configForm = userDefinedWidgetWindowObj.getComponent('configForm').getForm();
		var newGrptxtField = configForm.findField('NewGrptxtField');
		var grpVal = combo.getValue();
		 if (grpVal != null && grpVal != "undefined") {
			if(grpVal == "Other")
			{
				newGrptxtField.show();
			}
			else
			{
				newGrptxtField.hide();
			}
		 }
		 combo.resumeEvents();
		 userDefinedWidgetWindowObj = null;
		 delete userDefinedWidgetWindowObj;
		 configForm = null;
		 delete configForm;
		 newGrptxtField =null;
		 delete newGrptxtField;
	},
	onTestComboChange : function(combo)
	{
		//combo.isModification = false;
		this.onDefaultTestComboChange(combo);
	},

	onDefaultTestComboChange : function(combo)
	{
		var selectedTest = combo.getValue();
		var isModification = combo.isModification;
		var measureMultiselect = Ext.getCmp('measureListCombo');
		var measurelistCombo = Ext.getCmp('measurelist');
//		combo.on('beforeselect', function(combo, record, index, eOpts ) {
//				if(tempSelectedGraph!=null && tempSelectedGraph == '')
//				{
//					Ext.Msg.show({
//									title: templatesAlertLbl,
//									msg: 'plese select Graphical Type',
//									buttons: Ext.MessageBox.OK,
//									icon: Ext.MessageBox.WARNING
//								});
//						return false;
//				}
//			});

		var userDefinedWidgetWindowObj = this.getUserDefinedWidgetWindow();
		var configForm = userDefinedWidgetWindowObj.getComponent('configForm').getForm();
		if(selectedTest!=null)
		{
			if(selectedTest != "-1") {
				Ext.Ajax.request({
						url : '/final/servlet/com.eg.EgTemplateBuilderController',
						method : 'POST',
						params : 'action=getMeasuresForTest&comesFrom=widgetConfiguration&selectedTest='+encodeURIComponent(selectedTest)+'&selectedGraph='+tempSelectedGraph,
						scope : this,
						success : function(response) {
							var jsonText = response.responseText;
							if (jsonText != null && jsonText != '') {
								var jsonDtaForMeas = Ext.decode(jsonText);
								var measuresList = null;
								if(tempSelectedGraph!=null && tempSelectedGraph == 'DDTable')
								{
									measuresList = jsonDtaForMeas['Measures']['ddMeasureOpts'];
								}
								else
								{
									measuresList = jsonDtaForMeas['Measures']['measureOpts'];
								}
								if(measuresList!=null && !Ext.isEmpty(measuresList))
								{
									if(tempSelectedGraph!=null && tempSelectedGraph!='')
									{
										if(tempSelectedGraph == 'DDTable')
										{
											Ext.getCmp('addtoGridBtn').hide();
										}
										else
										{
											
											Ext.getCmp('addtoGridBtn').show();
										}
										Ext.getCmp('measureLbl').show();

										if(tempSelectedGraph == 'TopNGaugeChart' || tempSelectedGraph == 'TopNDigitalChart' || tempSelectedGraph == 'DDTable' || tempSelectedGraph == 'TopN')
										{
											configForm.findField('measurelist').hide();
											configForm.findField('metricsSearchTextBox').hide();
											var measureCombo = configForm.findField('measureListCombo');
											measureCombo.suspendEvents(true);
											var measureComboStore = measureCombo.getStore();
											measureComboStore.removeAll();
											measureComboStore.loadRawData(measuresList);
											measureComboStore.insert(0, {
											displayField : 'Please Choose Measure',
											valueField : '-1'
										});
											if(tempSelectedGraph == 'DDTable')
											{
												if(!isModification)
												{
													measureCombo.setValue('-1');
													measureComboStore.resumeEvents();
													measureCombo.show();
												}
											}
											else
											{
												measureCombo.setValue('-1');
												measureComboStore.resumeEvents();
												measureCombo.show();
											}
											combo.isModification = false;
										}
										else
										{
											configForm.findField('measureListCombo').hide();
											var measureMultiCombo = configForm.findField('measurelist');
											measureMultiCombo.suspendEvents(true);
											var measureMultiComboStore = measureMultiCombo.getStore();
											measureMultiComboStore.removeAll();
											measureMultiComboStore.loadRawData(measuresList);
											measureMultiCombo.resumeEvents();
											measureMultiCombo.show();
											configForm.findField('metricsSearchTextBox').show();
										}
									}
								}
								else
								{
									if(tempSelectedGraph!=null && tempSelectedGraph == 'DDTable')
									{
										Ext.getCmp('measureLbl').show();
										//Ext.getCmp('addtoGridBtn').show();
										var measureCombo  = configForm.findField('measureListCombo');
										measureCombo.suspendEvents(true);
										var measureComboStore = measureCombo.getStore();
										measureComboStore.removeAll();
										measureComboStore.insert(0, {
											displayField : notApplicable,
											valueField : '-1'
										});
										if(!isModification)
										{
											measureCombo.setValue('-1');
											measureCombo.resumeEvents();
											measureCombo.show();
										}
										combo.isModification = false;
										
										var ddcolumnsCombo  = configForm.findField('ddcolumnsMultiSelect');
										ddcolumnsCombo.suspendEvents(true);
										var ddcolumnsComboStore = ddcolumnsCombo.getStore();
										ddcolumnsComboStore.removeAll();
										ddcolumnsComboStore.insert(0, {
											displayField : notApplicable,
											valueField : '-1'
										});
										ddcolumnsCombo.setValue('-1');
										ddcolumnsCombo.resumeEvents();
										//ddcolumnsCombo.show();
									}
								}
							}
						}
					});
			}
			else
			{
				var measureMultiCombo = configForm.findField('measurelist');
				measureMultiCombo.suspendEvents(true);
				var measureMultiComboStore = measureMultiCombo.getStore();
				measureMultiComboStore.removeAll();
				measureMultiComboStore.insert(0, {
					displayField : notApplicable,
					valueField : '-1'
				});
				measureMultiCombo.setValue('-1');
				measureMultiCombo.resumeEvents();
			}
		}
		userDefinedWidgetWindowObj =null;
		delete userDefinedWidgetWindowObj;
	},
	doTopNEvent : function(combo)
	{
		var topNgraphType = combo.getValue();
		if(topNgraphType!=null && topNgraphType!='')
		{
			if(topNgraphType == 'TopNTabularView')
			{
				var legendDisplay = Ext.getCmp("Legend Display");
				var colorpalt = Ext.getCmp("colorPlt");
				var ViewType = Ext.getCmp("ViewType");
				if(ViewType!=null && !Ext.isEmpty(ViewType) && ViewType!='undefined')
				{
					Ext.getCmp('advancedOptionWidgetSlider').remove(ViewType);
				}
				if(legendDisplay!=null && !Ext.isEmpty(legendDisplay) && legendDisplay!='undefined')
				{
					Ext.getCmp('advancedOptionWidgetSlider').remove(legendDisplay);
				}
				if(colorpalt!=null && !Ext.isEmpty(colorpalt) && colorpalt!='undefined')
				{
					Ext.getCmp('advancedOptionWidgetSlider').remove(colorpalt);
				}
			}
			else if(topNgraphType == 'TopNBarChart')
			{
				var display = Ext.getCmp("Display");
				if(display!=null && !Ext.isEmpty(display) && display!='undefined')
				{
					Ext.getCmp('advancedOptionWidgetSlider').remove(display);
				}
			}
			Ext.Ajax.request({
							url : '/final/servlet/com.eg.EgTemplateBuilderController',
							method : 'POST',
							params : 'action=getTopNOptionsForGraph&&selectedGraph='+encodeURIComponent(topNgraphType),
							scope : this,
							success : function(response) {
								var jsonText = response.responseText;
								if (jsonText != null && jsonText != '') {
									var jsonDtaForTopN = Ext.decode(jsonText);
									var AdvancedControls = jsonDtaForTopN['TopNOptions']['advanceControls'];
									if(AdvancedControls!=null && !Ext.isEmpty(AdvancedControls))
									{
										Ext.getCmp('advancedOptionWidgetSlider').add(this.createFilters(AdvancedControls));
										Ext.getCmp('advancedOptionWidgetSlider').doLayout();
									}
									jsonDtaForTopN=null;
									delete jsonDtaForTopN;
								}
								jsonText=null;
								delete jsonText;
							}
				}
				);
			}
	},
	enableChartTypes : function()
	{
		var ChartSwitchVal = Ext.getCmp('ChartSummaryEnabled').getValue();
		if(ChartSwitchVal!=null && ChartSwitchVal==true)
		{
			Ext.getCmp('SummaryGraphType').setDisabled(false);
			Ext.getCmp('ShowIcon').setDisabled(false);
		}
		else
		{
			Ext.getCmp('SummaryGraphType').setDisabled(true);
			Ext.getCmp('ShowIcon').setDisabled(true);
			Ext.getCmp('ShowIcon').setValue(false);
		}
	},

	enableStateColorOnChange : function()
	{
		var 	enableColorVal = Ext.getCmp('EnableMeasureStateColor').getValue();
		if(enableColorVal!=null && enableColorVal==true)
		{
			Ext.getCmp('SetStateColorOn').setDisabled(false);
			Ext.getCmp('SetStateColorOn').show();
		}
		else
		{
			Ext.getCmp('SetStateColorOn').setDisabled(true);
			Ext.getCmp('SetStateColorOn').hide();
		}
	},
	
	showIconControl : function()
	{
		var ShowIconVal = Ext.getCmp('ShowIcon').getValue();
		if(ShowIconVal!=null && ShowIconVal==true)
		{
			Ext.getCmp('imgIcon').setDisabled(false);
		}else{
			Ext.getCmp('imgIcon').setDisabled(true);
		}
	},
	loadListPage : function()
	{
		var mainPageView = this.getMain();
		mainPageView.removeAll();
		var templateListJson = publicJson['myTemplateList'];
		var dataforView = templateListJson['personalSharingData'];
		Ext.getCmp('listPageHeaderMenu').show();
		//dataforView = null;
		var errormessage ="No Templates available"
		if(dataforView != null && dataforView!= '-')
		{
			Ext.getCmp('selectAllTemplates').show();
			Ext.getCmp('searchTemplate').show();
			//Ext.getCmp('tmplheadrtab').show();
			mainPageView.add({
					xtype : 'templateBuilderList',
					autoscroll : true,
					scroll : true,
					height : (mainPageView.getHeight() - 55),
					dataforView: dataforView
				});
				mainPageView.doLayout();
		}
		else
		{
			Ext.getCmp('selectAllTemplates').hide();
			Ext.getCmp('searchTemplate').hide();
			//Ext.getCmp('tmplheadrtab').hide();
			mainPageView.add({
				xtype : 'container',
				autoscroll : true,
				scroll : true,
				height : (mainPageView.getHeight() - 55),
				//html: '<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconExclamation" style="margin:0px auto"></div><div style="text-align:center">'+publicJson['myTemplateList']['errorMsg']+'</div></div></div>'
				html: '<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">'+errormessage+'</div></div></div>'

			})
		}
	},
	uploadIconImage: function(profileName,isFromTemplateList)
	{
		var fromTemplateList = "No";
		if(isFromTemplateList!=null && isFromTemplateList)
		{
			fromTemplateList = "yes";
		}
		var fileName1 = Ext.getCmp('FILE_1').getValue();
		var fileHidObj=Ext.getCmp('hiddenFile_dstFile');
		var meC=this;
		var fileName1 = Ext.getCmp('FILE_1').getValue();
		if(fileName1!=null && fileName1!="undefined")
			fileName1=fileName1.toLowerCase();

		if(fileName1.lastIndexOf(".png") == -1 && fileName1.lastIndexOf(".jpg") == -1 && fileName1.lastIndexOf(".gif") == -1)
		{
			Ext.Msg.show({
				title: templatesAlertLbl,
				msg: invalidImageTypeAlert,
				buttons: Ext.Msg.OK,
				icon: Ext.Msg.WARNING
			});
			Ext.getCmp('FILE_1').reset();
			Ext.getCmp('FILE_1').focus();
			return;
		}
		Ext.Msg.show({
			title:templatesAlertLbl,
			msg:uploadProfileMsgAlert+"?",
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn:function(buttonId)
			{
				if(buttonId =="yes")
				{
					var fileName = Ext.getCmp('FILE_1').getValue();
					var frmMain = Ext.getCmp('fileUploadFormId').getForm();
					if (frmMain.isValid())
					{
						if(fileName!=null && fileName.lastIndexOf("/")>0)
						{
							fileName=fileName.substring(fileName.lastIndexOf("/")+1);
						}
						else if(fileName!=null && fileName.lastIndexOf("\\")>0)
						{
							fileName=fileName.substring(fileName.lastIndexOf("\\")+1);
						}
						var fileHidObj=Ext.getCmp('FILE_1_dstFile');
						if(fileHidObj!=null)
						{
							fileHidObj.setValue("manager/tomcat/webapps/final/images/icon-library/"+loginUser+"/"+fileName);
						}
						var urlForFile ="/final/servlet/com.eg.EgFileUpload?title=Uploading Template Background&dispCaption=MyTemplate Bg Image&requestFrom=EgTemplateList.jsp&uploadFor=MyTemplateImg&uploadDir=manager/tomcat/webapps/final/images/icon-library/"+loginUser+"/"+fileName+"&fileExt=jpg&fileUpload=yes&profileName="+encodeURIComponent(profileName)+"&isFromTemplateList="+fromTemplateList;
						Ext.getCmp('fileUploadFormId').submit({
							url: urlForFile,
							method: 'POST',
							success: function (form, action) {
								var windowIdObj=Ext.getCmp('windowId');
								if(!Ext.isEmpty(windowIdObj))
								{
									windowIdObj.destroy();
									windowIdObj=null;
									delete windowIdObj;
								}
								var iconLibwindowIdObj=Ext.getCmp('iconLibWindow');
								if(!Ext.isEmpty(iconLibwindowIdObj))
								{
									iconLibwindowIdObj.destroy();
									iconLibwindowIdObj=null;
									delete iconLibwindowIdObj;
								}
								var jsonText = action.response.responseText;
								if (fileName.indexOf(' ')>0)
								{
									for (var i = 0; i < fileName.length; i++) {
										fileName= fileName.replace(' ', '');
								   }
								}
								var jsonText = action.response.responseText;
								if (fileName.indexOf(' ')>0)
								{
									for (var i = 0; i < fileName.length; i++) {
										fileName= fileName.replace(' ', '');
								   }
								}
								var tempicon = "/final/images/icon-library/"+loginUser+"/"+fileName;
								if(fromTemplateList == "No")
								{
									Ext.getCmp('imgcont').update('<div id="listViewImgDefault" class="listViewImgDefault"><div style="width:64px;height:64px;overflow:hidden;position: absolute;top:0%;left: 0%;right: 0%;margin: auto;bottom: 0%;"><img id="templateImageIcon"  src="'+tempicon+'" style="position: absolute;top:0%;left: 0%;right: 0%;margin: auto;bottom: 0%;" border="0px"/><div id="settingOver" class="settingOver"></div></div></div>');
								}
								/*var templateImageIconObj=$('#templateImageIcon');
								if(templateImageIconObj!=null && !Ext.isEmpty(templateImageIconObj) && !isFromTemplateList)
								{
									templateImageIconObj[0].src="/final/images/icon-library/"+loginUser+"/"+fileName;
									//dashboardImageIconObj=null;
									//delete dashboardImageIconObj;
								}*/
								var fileUploadFormObj=Ext.getCmp('fileUploadFormId');
								if(fromTemplateList == 'yes')
								{
									var panelViewId = Ext.getCmp('templateBuilderListPageView');
									if(panelViewId!=null && !Ext.isEmpty(panelViewId) )
									{
										panelViewId.removeAll();
										panelViewId.setLoading(false);
										panelViewId.doLayout();
									}
									meC.goToTemplateListPage();
								}
							},
							failure: function(form, action) // if result page doest not contain success:true, this method fires
							{

							}
						});
					}
				}
			}});
	},
	editMyTemplate :function()
	{
		var profileName = Ext.getCmp('templateLayoutObj').profileName;
		var modifytempUrl = "comesFrom=templateBuilder&action=modifyTemplateSettings&profileName="+encodeURIComponent(profileName);
		this.loadCreateTemplateViewPopup('modifyTemplate',modifytempUrl);
		modifytempUrl=null;
		delete modifytempUrl;
	},
	checkboxClick: function(obj,newValue,oldValue,eOpts)
	{
		var renderCheckBox = Ext.query('div.addCheckBox');
		//var renderCheckBox = getCmp('div.addCheckBox')
		var checked = obj.getValue();

		if(checked)
		{
			Ext.getCmp('tmplheadrtab').show();
			for (var i = 0; i < renderCheckBox.length; i++ )
			{
				var chkBoxObj=Ext.getCmp('cc_'+i);
				var isshared = chkBoxObj.SharedData;
				var isdefaultData = chkBoxObj.defaultData
				if(isshared == 'false' && isdefaultData == 'false')
				{
					chkBoxObj.setValue(true);
					chkBoxObj.show();
				}
			}
			Ext.getCmp('DeleteListOfTemplates').show();
		}
		else
		{
			Ext.getCmp('tmplheadrtab').hide();
			for (var i = 0; i < renderCheckBox.length; i++ )
			{
				var chkBoxObj=Ext.getCmp('cc_'+i);
				chkBoxObj.setValue(false);
				chkBoxObj.hide();
			}
			Ext.getCmp('DeleteListOfTemplates').hide();
		}

	},
	goToTemplateListPage: function()
	{
		var listPageUrl = "/final/servlet/com.eg.EgMonitorRequestDispatcher?comesFrom=templateBuilder&action=loadMyTemplateListPage";
		this.goToPage(listPageUrl, 'loadMyTemplateListPage');
	},
	editTemplateSettings: function(url)
	{
		this.loadCreateTemplateViewPopup('modifyTemplate',url);
	},
	goToPage : function(url, actionParam)
	{
		if (url != null && url.indexOf("?") > 0)
			url = url.substr(url.indexOf("?") + 1);

		Ext.getCmp('custom_layouts').defaultState();

		if (actionParam == 'modifyTemplateSettings') {
			this.editTemplateSettings(url);
		}
		else
		{
			if (isAnonymousUserAccess) {
					url = url + '&anonymousUser=true';
				}
				else if(isMonitorHome)
				{
					url=url+"&setMonitorHome=true";
				}
				var meC = this;
				var mainPageView = this.getMain();
				Ext.getCmp('templateMainPanel').getHeader().show();
				Ext.Ajax.request({
					url : '/final/servlet/com.eg.EgMonitorRequestDispatcher',
					method : 'POST',
					params : url + '&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
					scope : this,
					success : function(response) {
						var jsonText = response.responseText;
						if (!Ext.isEmpty(jsonText)) {
							publicJson = Ext.decode(jsonText);
							if (actionParam != null) {
								if(actionParam == 'loadMyTemplateListPage')
								{
									var gridStackObj=Ext.getCmp('gridstackpanelObj');//_'+profName);
									if(!Ext.isEmpty(gridStackObj))
									{
										gridStackObj._removeAllWidget();
									}
									mainPageView.remove('templateBuilderListPageView',true);
									mainPageView.remove('dataViewId',true);
									mainPageView.removeAll('dataViewId',true);
									mainPageView.clearManagedListeners();
									mainPageView.remove('templateLayout',true);
									mainPageView.remove('templateLayoutObj',true);
									Ext.EventManager.removeAll('templateLayoutObj');
									Ext.EventManager.removeAll('templateBuilderListPageView');
									Ext.EventManager.removeAll('dataViewId');
									Ext.getCmp('selectAllTemplates').setValue(false);
									Ext.getCmp('templateListCombo').hide();
									Ext.getCmp('templateConfigTools').hide();
									var templateTools = this.getTemplatetools();
									templateTools.hide();
									meC.loadListPage();
								}
								else if(actionParam == 'loadTemplateConfigView')
								{
									var templateconfigurationObj=this.getCreateTemplate();
									if (Ext.isEmpty(templateconfigurationObj))
										templateconfigurationObj = Ext.widget('createTemplate');

									if(templateconfigurationObj!=null && !Ext.isEmpty(templateconfigurationObj))
									{
										templateconfigurationObj.close();
									}
									publicJson['action'] = 'loadTemplateConfigView';
									var isShared = publicJson['templateConfigDetails']['isSharedTemplate'];
									if(isShared!=null && isShared == 'true')
									{
										isShared = true;
									}
									else
									{
										isShared = false;
									}
									var isDefault = publicJson['templateConfigDetails']['isDefaultTemplate'];

									if(isDefault!=null && isDefault == 'true')
									{
										isDefault = true;
									}
									else
									{
										isDefault = false;
									}
									var gridStackObj=Ext.getCmp('gridstackpanelObj');//_'+profName);
									if(!Ext.isEmpty(gridStackObj))
									{
										gridStackObj._removeAllWidget();
									}
									Ext.getCmp('listPageHeaderMenu').hide();
									Ext.getCmp('searchTemplate').hide();
									mainPageView.remove('templateBuilderListPageView',true);
									mainPageView.remove('dataViewId',true);
									mainPageView.clearManagedListeners();
									mainPageView.removeAll('dataViewId',true);
									mainPageView.remove('templateLayout',true);
									mainPageView.remove('templateLayoutObj',true);
									Ext.EventManager.removeAll('templateLayoutObj');
									Ext.EventManager.removeAll('templateBuilderListPageView');
									Ext.EventManager.removeAll('dataViewId');
									mainPageView.add({
									xtype : 'templateLayout',
									profileName : publicJson['templateConfigDetails']['profileName'],
									isSharedTemplate : isShared,
									isDefaultTemplate : isDefault,
									layoutchoosen: publicJson['templateConfigDetails']['layout']
								});
									Ext.getCmp('templateListCombo').show();
									Ext.getCmp('templateConfigTools').hide();
									var templateConfigTools=this.getTemplategeneralsettings();
									if(publicJson['templateConfigDetails']['isSharedTemplate'] == "false" && !isMonitorHome)
									{
										if(!isDefault)
										{
											Ext.getCmp('templateConfigTools').show();
										}
									}
									else
									{
										Ext.getCmp('templateConfigTools').hide();
									}
									var templateTools = this.getTemplatetools();
									templateTools.show();
									templateTools.getComponent('listBtnContainer').show();
									templateTools=null;
									delete templateTools;
									this.loadTemplateListCombo(publicJson['templateComboList'],publicJson['templateConfigDetails']['profileName']);
									mainPageView.doLayout();
									this.loadTemplateConfigurationView();
								}
							}
						}
					}
				});
		}
	},
	replaceHtmlTag: function (templateName,replaceCharc,charcReplace)
	{
        if (templateName.indexOf(replaceCharc)>0)
        {
            for (var i = 0; i < templateName.length; i++) {
                templateName= templateName.replace(replaceCharc, charcReplace);
           }
        }
        if (templateName.indexOf(replaceCharc)>0)
        {
            for (var i = 0; i < templateName.length; i++) {
                templateName= templateName.replace(replaceCharc, charcReplace);
           }
        }
        return templateName;
    },
	loadDataForBlock : function(configPanl, profileName, blockId, internalId) {
		var meC = this;
		configPanl.setLoading(true, Ext.get(blockId));
		var paramsForData = '&action=loadBlockData&profileName=' + profileName + '&blockId=' + internalId;
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.EgTemplateBuilderController',
			method: 'POST',
			params: paramsForData,
			scope: this,
			success: function (response) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				if(jsonData!=null)
				{
					meC.showDataForBlock(configPanl,jsonData,blockId);
				}
				jsonData = null;
				delete jsonData;
				jsonText =null;
				delete jsonText;
			}
		}
		);
	},
	loadTemplateConfigurationView : function() {

		return loadTemplateConfigurationView('','','');
	},
	loadTemplateConfigurationView :function(actionParam,selectedLayout,selectedLayoutConfig)
	{
		var meC = this;
		var myDashboardCols = null;
		var isResizeablePanel = false;
		var isPreview=false;
		var percentLeft = '';
		var percentTop = '';
		tempblockid = '';
		widgetsforTemplateView = 0;
		var dragLayout = Ext.getCmp('templateLayoutObj');
		dragLayout.suspendEvents(true);
		var templateConfigDetails = publicJson['templateConfigDetails'];
		var istemplateConfigured = templateConfigDetails['templateconfigured'];
		var isShareTemplate = templateConfigDetails['isSharedTemplate'];
		var isDefaultTemplate = templateConfigDetails['isDefaultTemplate'];
		var isDefTemplate=false;
		if(isDefaultTemplate!=null && (isDefaultTemplate==true || isDefaultTemplate=='true' || isDefaultTemplate=='yes'))
		{
			isDefTemplate=true;
		}
		var isSharedTemplate=false;
		if(isShareTemplate!=null && (isShareTemplate==true || isShareTemplate=='true' || isShareTemplate=='yes'))
		{
			isSharedTemplate=true;
		}
		currWidgetsForUser = templateConfigDetails['widgetsForUserArr'];
		var configIds = templateConfigDetails['configIds'];
		var gridStackObj=Ext.getCmp('gridstackpanelObj');
		if(!Ext.isEmpty(gridStackObj))
		{
			gridStackObj._removeAllWidget();
		}
		var isPreDefinedLayout=false;
		var isChangePreDefinedLayout=false;
		if (actionParam!=null && actionParam == 'changePreDefinedLayout') {
			isChangePreDefinedLayout=true;
			isPreDefinedLayout=true;
		}
		var widResize=true;
		var layoutchoosen=publicJson['templateConfigDetails']['layout'];
		if(layoutchoosen!=null && layoutchoosen == 'Custom')
		{
			widResize=false;
		}
		if(isDefTemplate)
		{
			widResize=true;
		}
		var isCustomDashboardLayout=false;
		
		if(!isChangePreDefinedLayout && (templateConfigDetails!=null && templateConfigDetails.hasOwnProperty('dashboardLayoutType')))
		{
			if(templateConfigDetails['dashboardLayoutType']!=null && templateConfigDetails['dashboardLayoutType']=="Custom")
			{
				isCustomDashboardLayout=true;
			}
			else if(templateConfigDetails['dashboardLayoutType']!=null && templateConfigDetails['dashboardLayoutType']=="Pre-defined")
			{
				isPreDefinedLayout=true;
			}
		}
		if((istemplateConfigured != null && istemplateConfigured == "true" && !Ext.isEmpty(configIds))  || isPreDefinedLayout || isCustomDashboardLayout)
		{
			var actioOnWidget = 'loadWidget';
			var blockPositionArr=templateConfigDetails['blockPositionsArr'];
			var blockPositionsMapping=templateConfigDetails['blockPositionsMapping'];
			maxBlockId = templateConfigDetails['maxBlockId'];
			maxBlockId = parseInt(maxBlockId);
			var no_of_widgets=0;
			var isAutoPositionRequired=false;
			if(blockPositionArr!=null)
			{
				widgetsforTemplateView = blockPositionArr.length;
				no_of_widgets=widgetsforTemplateView;
				blockPositionArr = _.sortBy(blockPositionArr, 'row'); 
			}

				if(!isChangePreDefinedLayout && (templateConfigDetails!=null && templateConfigDetails.hasOwnProperty('dashboardLayoutType')))
				{
					if(templateConfigDetails['dashboardLayoutType']!=null && templateConfigDetails['dashboardLayoutType']=="Custom")
					{
						//TODO
						var selectedLayoutStyle = publicJson['templateConfigDetails']['customLayoutColumn'];
						Ext.getCmp('gridstackpanelObj').selectTemplate = selectedLayoutStyle;
						gridStackObj.gridStackObjRef().setGridWidth(templateConfigDetails['customLayoutColumn'],false);
						isAutoPositionRequired=true;

						/*if(!Ext.isEmpty(Ext.getCmp(selectedLayoutStyle))){
							console.log('------------------>',publicJson['templateConfigDetails']['customLayoutColumn']);
							
							Ext.getCmp(selectedLayoutStyle).setValue(true);
						}*/
						//Ext.getCmp('CustomLayoutCnt').value=;
						//incObj.setValue(parseInt(publicJson['templateConfigDetails']['customLayoutColumn']));
						//Ext.getCmp('custom-layout-image').setSrc('../images/'+strSkin+'/ds-column-layout-'+publicJson['templateConfigDetails']['customLayoutColumn']+'.png');
					}
					else if(templateConfigDetails['dashboardLayoutType']!=null && templateConfigDetails['dashboardLayoutType']=="Pre-defined")
					{
						gridStackObj.gridStackObjRef().setGridWidth(12,false);
						//TODO
						var selectedLayoutStyle = publicJson['templateConfigDetails']['preDefinedLayout'];
						Ext.getCmp('gridstackpanelObj').selectTemplate = selectedLayoutStyle;
						/*if(!Ext.isEmpty(Ext.getCmp(selectedLayoutStyle))){
							console.log('------------else------>',publicJson['templateConfigDetails']['preDefinedLayout']);
							
							Ext.getCmp(selectedLayoutStyle).setValue(true);
						}*/
						//incObj.setValue(parseInt(publicJson['templateConfigDetails']['preDefinedLayout']));
						//Ext.getCmp('custom-layout-image').setSrc('../images/'+strSkin+'/ds-column-layout-'+publicJson['templateConfigDetails']['customLayoutColumn']+'.png');
					}
				}

				if(isChangePreDefinedLayout==true)
				{
					gridStackObj.gridStackObjRef().setGridWidth(12,false);
					selectedLayoutArr=_.sortBy(selectedLayoutConfig, 'y');
					//selectedLayoutArr=selectedLayoutConfig;//.split('|');
					var selectedLayoutWidgets=selectedLayoutArr.length;
					if(no_of_widgets<selectedLayoutWidgets)
					{
						maxBlockId=selectedLayoutArr.length;
						for(var l=0;l<selectedLayoutWidgets;l++)
						{
							var widgetPosConfig=selectedLayoutArr[l];
							if(!Ext.isEmpty(widgetPosConfig))
							{
							/*	var cPanlId = widgetPosConfig.substr(0,widgetPosConfig.indexOf(":"));
								widgetPosConfig=widgetPosConfig.substr(widgetPosConfig.indexOf(":")+1);
								
								var widgetConfArr=widgetPosConfig.split(',');*/
								var cPanlId = widgetPosConfig['widgetID'];
								var pnlColPos=0,pnlRowPos=0,sizeX=0,sizeY=0;
								var configPanlTitle ='';
								  
								if(l<no_of_widgets)
								{
									var pnlConfigObj=blockPositionArr[l];
									if(!Ext.isEmpty(pnlConfigObj))
									{
										pnlColPos=pnlConfigObj['col'];
										pnlRowPos=pnlConfigObj['row'];
										sizeX=pnlConfigObj['size_x'];
										sizeY=pnlConfigObj['size_y'];
										cPanlId = blockPositionsMapping[pnlColPos+","+pnlRowPos+":"+sizeX+","+sizeY];
										//configPanlTitle = configBlocksTitleConfig[cPanlId];
									}
								}

								pnlColPos=widgetPosConfig['x'];
								pnlRowPos=widgetPosConfig['y'];
								sizeX=widgetPosConfig['width'];
								sizeY=widgetPosConfig['height'];
								
								var internalId = configIds[cPanlId];
								var widgetName = cPanlId;
								var widAction='addWidget';
								var widIcon='configureWidgetDefaultIcon';
								if(internalId!=null && internalId != 'undefined' && internalId !='')
								{
									widgetName = internalId;
									widAction='loadWidget';
									widIcon='';
								}

								var isDefWidget=false;
							
								var defWidgetArr= ['currentalarms','tierhealth','servicehealth','networkhealth','news','weather','USEREXPERIENCE','Citrix-USERLATENCY','VMAlerts'];
								for(var df in defWidgetArr)
								{
									var defWid=defWidgetArr[df];
									if(internalId!=null && internalId==defWid)
									{
										isDefWidget=true;
										break;
									}
								}
								if(isDefTemplate)
								{
									isDefWidget=true;
								}
								var isAutoPosition=false;
								if(isLayoutChanged)
								{
									pnlColPos=0;
									pnlRowPos=0;
									isAutoPosition=true;
								}
								if(isCustomDashboardLayout)
								{
									
									sizeX=null;
									//TODO
									//isAutoPositionRequired = true;
								}
								var newWidget = {
													'x'  :   pnlColPos,
													'y'  :   pnlRowPos,
													'width'  :   sizeX,
													'height'  :   sizeY,
													'id':cPanlId,
													'widgetType':widgetName,
													'widgetNum' : '',
													'widget_name' : widgetName,
													'noResize':widResize,
													'internalId' : internalId,
													'isDefaultWidget':isDefWidget,
													'autoPosition'  :  isAutoPosition
								};
								$('.grid-stack').data('gridstack').batchUpdate();	
								Ext.getCmp('gridstackpanelObj')._addWidget(newWidget,widAction,'', '',widIcon);
								$('.grid-stack').data('gridstack').commit();
							}
						}
					}
					else
					{
						maxBlockId=blockPositionArr.length;
						var layCnt=0;
						var isLayoutWidgetLengthExceeded=false;
						var extraWidgetBlock=false;
						var extraBlocksArr=[];
						for ( var tc in blockPositionArr) {
							var pnlConfigObj=blockPositionArr[tc];
							var pnlColPos=pnlConfigObj['col'];
							var pnlRowPos=pnlConfigObj['row'];
							var sizeX=pnlConfigObj['size_x'];
							var sizeY=pnlConfigObj['size_y'];
							var cPanlId = blockPositionsMapping[pnlColPos+","+pnlRowPos+":"+sizeX+","+sizeY];
						//	var configPanlTitle = configBlocksTitleConfig[cPanlId];

							if(layCnt<selectedLayoutWidgets)
							{
								var widgetPosConfig=selectedLayoutArr[layCnt];
								if(!Ext.isEmpty(widgetPosConfig))
								{
									//var cPanlId = widgetPosConfig.substr(0,widgetPosConfig.indexOf(":"));
									//widgetPosConfig=widgetPosConfig.substr(widgetPosConfig.indexOf(":")+1);
									//var widgetConfArr=widgetPosConfig.split(',');

									if(isLayoutWidgetLengthExceeded)
									{
										pnlColPos=0;
										pnlRowPos=0;
										sizeX='default';
										sizeY='default';
										isAutoPositionRequired=true;

										extraWidgetBlock=true;
									}
									else
									{
										pnlColPos=widgetPosConfig['x'];
										pnlRowPos=widgetPosConfig['y'];
										sizeX=widgetPosConfig['width'];
										sizeY=widgetPosConfig['height'];
									}
									layCnt++;

									if(layCnt>selectedLayoutWidgets)
									{
										layCnt=0;
										isLayoutWidgetLengthExceeded=true;
									}
								}
							}
							var internalId = configIds[cPanlId];
							var widgetName = cPanlId;
							var widAction='addWidget';
							var widIcon='configureWidgetDefaultIcon';
							if(internalId!=null && internalId != 'undefined' && internalId !='')
							{
								widgetName = internalId;
								widAction='loadWidget';
								widIcon='';
							}

							var isDefWidget=false;
						
							var defWidgetArr= ['currentalarms','tierhealth','servicehealth','networkhealth','news','weather','USEREXPERIENCE','Citrix-USERLATENCY','VMAlerts'];
							for(var df in defWidgetArr)
							{
								var defWid=defWidgetArr[df];
								if(internalId!=null && internalId==defWid)
								{
									isDefWidget=true;
									break;
								}
							}
							if(isDefTemplate)
							{
								isDefWidget=true;
							}
							var isAutoPosition=false;
							if(isLayoutChanged)
							{
								pnlColPos=0;
								pnlRowPos=0;
								isAutoPosition=true;
							}
							if(isCustomDashboardLayout)
							{
								
								sizeX=null;
								//TODO
								//isAutoPositionRequired = true;
							}
							var newWidget = {
												'x'  :   pnlColPos,
												'y'  :   pnlRowPos,
												'width'  :   sizeX,
												'height'  :   sizeY,
												'id':cPanlId,
												'widgetType':widgetName,
												'widgetNum' : '',
												'widget_name' : widgetName,
												'noResize':widResize,
												'internalId' : internalId,
												'isDefaultWidget':isDefWidget,
												'autoPosition'  :  isAutoPosition
							};
							
							if(extraWidgetBlock)
							{
								extraBlocksArr.push(newWidget);
							}
							else
							{
								//meC.getGridster().addGridsterWidget(blkType,'','',configPanlTitle,cPanlId,sizeX,sizeY,pnlColPos,pnlRowPos,'loadWidget');
								$('.grid-stack').data('gridstack').batchUpdate();	
								Ext.getCmp('gridstackpanelObj')._addWidget(newWidget,widAction,'', '',widIcon);
								$('.grid-stack').data('gridstack').commit();
							}
						}
						if(!Ext.isEmpty(extraBlocksArr))
						{
							for(var v in extraBlocksArr)
							{
								var widConf=extraBlocksArr[v];
								var configPanlTitle = configBlocksTitleConfig[widConf.id];
								$('.grid-stack').data('gridstack').batchUpdate();	
								gridStackObj._addWidget(widConf,'loadWidget',configPanlTitle, '', '');
								$('.grid-stack').data('gridstack').commit();
							}
						}
					}
				}
				else
				{
					for ( var tc in blockPositionArr) {
						var pnlConfigObj=blockPositionArr[tc];
						var pnlColPos=pnlConfigObj['col'];
						var pnlRowPos=pnlConfigObj['row'];
						var sizeX=pnlConfigObj['size_x'];
						var sizeY=pnlConfigObj['size_y'];
						var cPanlId = blockPositionsMapping[pnlColPos+","+pnlRowPos+":"+sizeX+","+sizeY];
						var internalId = configIds[cPanlId];
						var widgetName = cPanlId;
						var widAction='addWidget';
						var widIcon='configureWidgetDefaultIcon';
						if(internalId!=null && internalId != 'undefined' && internalId !='')
						{
							widgetName = internalId;
							widAction='loadWidget';
							widIcon='';
						}

						var isDefWidget=false;
					
						var defWidgetArr= ['currentalarms','tierhealth','servicehealth','networkhealth','news','weather','USEREXPERIENCE','Citrix-USERLATENCY','VMAlerts'];
						for(var df in defWidgetArr)
						{
							var defWid=defWidgetArr[df];
							if(internalId!=null && internalId==defWid)
							{
								isDefWidget=true;
								break;
							}
						}
						if(isDefTemplate)
						{
							isDefWidget=true;
						}
						if(isCustomDashboardLayout)
						{
							sizeX = null;
						}
						var isAutoPosition=false;
						if(isLayoutChanged || isAutoPositionRequired)
						{
							pnlColPos=0;
							pnlRowPos=0;
							isAutoPosition=true;
						}
						var newWidget = {
											'x'  :   pnlColPos,
											'y'  :   pnlRowPos,
											'width'  :   sizeX,
											'height'  :   sizeY,
											'id':cPanlId,
											'widgetType':widgetName,
											'widgetNum' : '',
											'widget_name' : widgetName,
											'noResize':widResize,
											'internalId' : internalId,
											'isDefaultWidget':isDefWidget,
											'autoPosition'  :  isAutoPosition
						};
						
						Ext.getCmp('gridstackpanelObj')._addWidget(newWidget,widAction,'', '',widIcon);
						//meC.getGridster().addGridsterWidget(blkType,'','',configPanlTitle,cPanlId,sizeX,sizeY,pnlColPos,pnlRowPos,'loadWidget');
					}
				}
			if(isLayoutChanged)
			{
				var templateLayoutObj = Ext.getCmp('templateLayoutObj');
				var templateName = templateLayoutObj.profileName;
				var gridStackObj1=Ext.getCmp('gridstackpanelObj');
				var pnlPositions=gridStackObj1.getTBPanelPositions();
				meC.saveFluidTemplateWindowResizeConfig(templateName, pnlPositions);
			}
			if((isShareTemplate != null && isShareTemplate == "false") || (isDefaultTemplate != null && isDefaultTemplate == "false"))
			{
				var extraBlockPositionsMapping=templateConfigDetails['extraBlockPositionsMapping'];
				if(extraBlockPositionsMapping!=null && !Ext.isEmpty(extraBlockPositionsMapping))
				{
					widgetsforTemplateView = parseInt(widgetsforTemplateView);
					widgetsforTemplateView = widgetsforTemplateView + extraBlockPositionsMapping.length;
					var internId = '';
					for(var bpm in extraBlockPositionsMapping)
					{
						var pnlmatchObj=extraBlockPositionsMapping[bpm];
						if(pnlmatchObj!=null && pnlmatchObj.indexOf('$')>0)
						{
							var panelId = pnlmatchObj.substring(0,pnlmatchObj.indexOf('$'));
							var dimStr = pnlmatchObj.substring(pnlmatchObj.indexOf('$')+1);
							if(dimStr!=null && dimStr!='' )
							{
								var dimarray = dimStr.split(",");
								var dimsizeX = dimarray[0];
								dimsizeX = parseInt(dimsizeX);
								var dimsizeY = dimarray[1];
								dimsizeY = parseInt(dimsizeY);
								var newWidget = {
									'x'  :   0,
									'y'  :   0,
									'width'  :   sizeX,
									'height'  :   sizeY,
									'id':panelId,
									'widgetType':'',
									'widget_name' : panelId,
									'widgetNum':'',
									'noResize':widResize,
									'internalId' : internId,
									'autoPosition'  :  true
								};
								Ext.getCmp('gridstackpanelObj')._addWidget(newWidget,'addWidget',panelId, 'configureWidgetDefaultIcon', 'configureWidgetDefaultIcon');
							}
						}
					}
				}
			}
		}
		else if(istemplateConfigured != null && istemplateConfigured == "false")
		{
			var interrnalid ='';
			if((isShareTemplate != null && isShareTemplate == "false") || (isDefaultTemplate != null && isDefaultTemplate == "false"))
			{
				var blockPositionsMapping=templateConfigDetails['blockPositionsMapping'];
				var layoutchoosen = templateConfigDetails['layout'];
				maxBlockId = templateConfigDetails['maxBlockId'];
				maxBlockId = parseInt(maxBlockId);
				if(blockPositionsMapping!=null && !Ext.isEmpty(blockPositionsMapping))
				{
					var count = Object.keys(blockPositionsMapping).length;
					widgetsforTemplateView = count;
					for(var i=1;i<=count;i++)
					{
						var dimensionstr = blockPositionsMapping['widget_'+i];
						if(dimensionstr!=null && dimensionstr!='' )
						{
							var dimensionarray = dimensionstr.split(",");
							var sizeX = dimensionarray[0];
							sizeX = parseInt(sizeX);
							var sizeY = dimensionarray[1];
							sizeY = parseInt(sizeY);
							var newWidget = {
									'x'  :   0,
									'y'  :   0,
									'width'  :   sizeX,
									'height'  :   sizeY,
									'id':'block'+i,
									'widgetType':'',
									'widget_name' : 'block'+i,
									'noResize':widResize,
									'internalId' : interrnalid,
									 'widgetNum' : 'widgetNum_'+i,
									'autoPosition'  :  true
							};
							Ext.getCmp('gridstackpanelObj')._addWidget(newWidget,'addWidget','block'+i, '', 'configureWidgetDefaultIcon');
						}
					}
				}
			}
		}
		dragLayout.resumeEvents();
	},
	showSelectedTemplate : function(combo){
            if (combo.getValue() != null && combo.getValue() != "undefined") {
			 var defaultAction = publicJson['action'];
						var defaultAction = publicJson['action'];
						if (defaultAction != null && defaultAction == 'loadTemplateConfigView'){
			               /*var viewUrl = "/final/servlet/com.eg.EgMonitorRequestDispatcher?comesFrom=myDashboard&action=showMyDashboard&profileName="
					            + encodeURIComponent(combo.getValue());*/
								var viewUrl = "/final/servlet/com.eg.EgMonitorRequestDispatcher?comesFrom=templateBuilder&action=loadTemplateConfigView&profileName="+encodeURIComponent(combo.getValue());
			               this.goToPage(viewUrl, 'loadTemplateConfigView');
						}
		}
	},
	loadTemplateListCombo : function(combolist,profileName){
		var comb=Ext.getCmp('templateListCombo');
		var persTemplateList=combolist['personaTemplate'];
		var sharTemplateList=combolist['sharedTemplate'];
		var defaultTemplateList=combolist['defaultTemplate'];
		 if(combolist['sharingDataAvailable'] == 'true' ){
			 if(combolist['defaultDataAvailable'] == 'true')
			 {
				sharTemplateList =  sharTemplateList.concat(defaultTemplateList);
			 }
			 var templateObj=null;
			 if(persTemplateList!=null && persTemplateList!='undefined'){
			 if(persTemplateList.length>0){
				  templateObj = persTemplateList.concat(sharTemplateList);
			 }
			 else{
					templateObj=sharTemplateList;
			 }
			}else{
				  templateObj=sharTemplateList;
			}
			comb.getStore().loadRawData(templateObj);
			if(profileName!=null && profileName!='undefined'){
			   comb.setValue(profileName);
			}
			else{
				comb.setValue("");
			}
		 }
		 else if(combolist['defaultDataAvailable'] == 'true' ){
			 if(combolist['sharingDataAvailable'] == 'true')
			 {
				defaultTemplateList =  defaultTemplateList.concat(sharTemplateList);
			 }
			 var templateObj=null;
			 if(persTemplateList!=null && persTemplateList!='undefined'){
			 if(persTemplateList.length>0){
				  templateObj = persTemplateList.concat(defaultTemplateList);
			 }
			 else{
					templateObj=defaultTemplateList;
			 }
			}else{
				  templateObj=defaultTemplateList;
			}
			comb.getStore().loadRawData(templateObj);
			if(profileName!=null && profileName!='undefined'){
			   comb.setValue(profileName);
			}
			else{
				   comb.setValue("");
			}
		 }
		 else{
			comb.getStore().loadRawData(persTemplateList);
			if(profileName!=null && profileName!='undefined'){
			   comb.setValue(profileName);
			}
			else{
				   comb.setValue("");
			}
		}
	},
	deleteSingleTemplate :function(profileName,event)
	{
		var meC=this;
		var dataViewId = Ext.getCmp('dataViewId');
		var profileName = profileName;
		Ext.Msg.show({
		title:templatesAlertLbl,
		msg:deleteTemplateMsg+"?",
		buttons: Ext.Msg.YESNO,
		icon: 'iconConfirmation',
		fn:function(buttonId)
		{
			if(buttonId =="yes")
			{
			   var selectedTemplate = profileName;
			   Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgTemplateBuilderController',
				method: 'POST',
				params: 'action=DeleteTemplate&profileNames=' + encodeURIComponent(selectedTemplate)+'&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
				scope: this,
				success: function (response) {
							var jsonText = response.responseText;
							Ext.Msg.show({
								title: templatesAlertLbl,
								msg: singleTemplateDeleteMsg,
								buttons: Ext.MessageBox.OK,
								icon: Ext.MessageBox.WARNING
							});
							meC.goToTemplateListPage();
						},
				failure : function (response)
				   {
					console.log("failed");
				   }
				});
			}
		}
	});
	},
	deleteTemplate :function()
	{
		var meC=this;
		var profileName = Ext.getCmp('templateLayoutObj').profileName;
		Ext.Msg.show({
		title:templatesAlertLbl,
		msg:deleteTemplateMsg+"?",
		buttons: Ext.Msg.YESNO,
		icon: 'iconConfirmation',
		fn:function(buttonId)
		{
			if(buttonId =="yes")
			{
			    var selectedTemplate = profileName;
			   Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgTemplateBuilderController',
				method: 'POST',
				params: 'action=DeleteTemplate&profileNames=' + encodeURIComponent(selectedTemplate)+'&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
				scope: this,
				success: function (response) {
					var jsonText = response.responseText;
					if (!Ext.isEmpty(jsonText)) {

						Ext.Msg.show({
								title: templatesAlertLbl,
								msg: singleTemplateDeleteMsg,
								buttons: Ext.MessageBox.OK,
								icon: Ext.MessageBox.WARNING
							});
							meC.goToTemplateListPage();
				   }
				}
				});
			}
			else if(buttonId =="no" || buttonId =="cancel" ) {
				Ext.getCmp('deleteTemplate').defaultState(); 
			}
		}
	});
	},
	deleteSelectedTemplates : function()
	{

		var panelViewId = Ext.getCmp('templateBuilderListPageView');
		var meC = this;
		var selectedTemplates = '';
		var renderCheckBox = Ext.query('div.addCheckBox');

		for (var i = 0; i < renderCheckBox.length; i++ )
		{
			var ccc = Ext.getCmp('cc_'+i);
			if(ccc.checked)
			{
				selectedTemplates +='+'+ccc.data;
			}
			if(selectedTemplates!=null && selectedTemplates.indexOf('+')==0)
			{
				selectedTemplates = selectedTemplates.substr(1);
			}
		}
		if(selectedTemplates.length > 0)
		{
			var delMsg = deleteTemplateMsg;
			if (selectedTemplates.length > 1)
			{
				delMsg = deleteMultiTemplateMsg;
			}
			Ext.Msg.show({
				title:templatesAlertLbl,
				msg:delMsg+"?",
				buttons: Ext.Msg.YESNO,
				icon: 'iconConfirmation',
				fn:function(buttonId)
				{
					if(buttonId =="yes")
					{
						Ext.Ajax.request({
							url: '/final/servlet/com.eg.EgTemplateBuilderController',
							method: 'POST',
							params: 'action=DeleteTemplate&profileNames=' + encodeURIComponent(selectedTemplates),
							scope: this,
							success: function (response) {
								var jsonText = response.responseText;
								Ext.getCmp('selectAllTemplates').setValue(false);
								panelViewId.removeAll();
								panelViewId.setLoading(false);
								panelViewId.doLayout();
								meC.goToTemplateListPage();
								}
							});
					}
				}
			});
		}
		else
		{
			Ext.Msg.show({
				title : templatesAlertLbl,
				msg : deleteAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});
			return;
		}
	},
	saveWidgetConfiguration : function(blockId)
	{
		mec = this;
		//alert(blockId);
		var userdefinedWidgetWindowObj = mec.getUserDefinedWidgetWindow();
		if (Ext.isEmpty(userdefinedWidgetWindowObj))
			userdefinedWidgetWindowObj = Ext.widget('userDefinedWidgetWindow');

		var profileName = '';
		profileName = Ext.getCmp('templateLayoutObj').profileName;
		var widgetName = '';
		widgetName = Ext.getCmp('WidgetNametextField').getValue();
		var widgetLbl = Ext.getCmp('userDefinedWidgetNameLbl');
		if(widgetLbl!=null && widgetLbl.isVisible())
		{
			widgetName = $('#userDefinedWidgetNameLbl').text();
		}
		widgetName = widgetName.trim();
		 if (this.checkBlankSpc(widgetName)) {

			var msg = Ext.Msg;
			msg.show({
				title : templatesAlertLbl,
				msg : widgetBlankNameAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});

			//Ext.get('createWidgetMain').stopAnimation();
			return;
		}
		if (this.checkSpace(widgetName)) {

			var msg = Ext.Msg;
			msg.show({
				title : templatesAlertLbl,
				msg : widgetBlankNameAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});

			//Ext.get('createWidgetMain').stopAnimation();
			return;
		}
	/*	if (widgetName != null && widgetName.length > 32) {
			Ext.Msg.show({
				title : templatesAlertLbl,
				msg : maxWidgetLengthAlert,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});
			return;
		}*/
		if(widgetName != null && widgetName.indexOf(' ') == 0 )
		{
			Ext.Msg.show({
				title : templatesAlertLbl,
				msg : widgetNameStartsWithSpacMsg,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});
			return;
		}
		if (this.checkSpecialCharacter(widgetName)) {
			Ext.Msg.show({
				title : templatesAlertLbl,
				msg : widgetSplCharacterAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});
			return;
		}
		var gridStackPnlArr=[];
		gridStackPnlArr = mec.getGridstackpanel()._serialization();
		var prevnameToCompre = userdefinedWidgetWindowObj.internalId;
		if(prevnameToCompre!=null && prevnameToCompre.indexOf("|GRP|")>0)
		{
			prevnameToCompre = prevnameToCompre.substring(0, prevnameToCompre.indexOf("|GRP|"));
		}
		if(currWidgetsForUser!=null && currWidgetsForUser!='' && currWidgetsForUser.indexOf(widgetName) > -1)
		{
			if(userdefinedWidgetWindowObj.widgetAction=='modify Widget')
			{
				if(prevnameToCompre!=widgetName)
				{
					 Ext.Msg.show({
						title: templatesAlertLbl,
						msg: widgetExistAlertMsg,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
						});
						return;
				}
			}
			else
			{
				Ext.Msg.show({
						title: templatesAlertLbl,
						msg: widgetExistAlertMsg,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
						});
						return;
			}
		}
		var paramsForSave = '';
		var numberOfWidgets = gridStackPnlArr.length;
		var numwidgets = numberOfWidgets.toString();
		paramsForSave ="gridsterLength="+numwidgets;
		var widgetImageIconObj=$('#widgetImageIcon');
		var fileName = widgetImageIconObj[0].src;
		var filepath = null;
		if(fileName!=null && fileName.lastIndexOf("/")>0 && fileName.lastIndexOf("clear.png") == -1)
		{
			filepath = fileName.substring(0,fileName.lastIndexOf("/"));
			fileName=fileName.substring(fileName.lastIndexOf("/")+1);
		}
		else if(fileName!=null && fileName.lastIndexOf("\\")>0 && fileName.lastIndexOf("clear.png") == -1)
		{
			filepath = fileName.substring(0,fileName.lastIndexOf("\\"));
			fileName=fileName.substring(fileName.lastIndexOf("\\")+1);
		}
		else
		{
			fileName = widgetImageIconObj[0].className;
		}
		var addToWidgetLibRadioBtnObj = Ext.getCmp('addToWidgetLibRadioBtn').getChecked();
		addToWidgetLibr = addToWidgetLibRadioBtnObj[0].inputValue;
		var grpName = '';
		if(addToWidgetLibr != null && addToWidgetLibr == 'yes')
		{
			var widgetGrpComboVal = Ext.getCmp('widgetGrpCombo').getValue();
			if(widgetGrpComboVal!=null && widgetGrpComboVal == 'Other')
			{
				grpName = Ext.getCmp('NewGrptxtField').getValue();
				grpName.trim();
				 if (this.checkBlankSpc(grpName)) {
					Ext.Msg.show({
						title : templatesAlertLbl,
						msg : widgetGrpBlankNameAlertMsg,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
					});
					return;
				}
				if (this.checkSpace(grpName)) {
					Ext.Msg.show({
						title : templatesAlertLbl,
						msg : widgetGrpBlankNameAlertMsg,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
					});
					return;
				}
				if(grpName != null && grpName.indexOf(' ') == 0 )
				{
					Ext.Msg.show({
						title : templatesAlertLbl,
						msg : grpNameStartsWithSpacMsg,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
					});
					return;
				}
				if (this.checkSpecialCharacter(grpName)) {
					Ext.Msg.show({
						title : templatesAlertLbl,
						msg : widgetGrpSplCharacterAlertMsg,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
					});
					return;
				}
				if(widgtgrpArr!=null && !Ext.isEmpty(widgtgrpArr))
				{
					for(var c=0;c<defaultWidgetsArr.length;c++)
					{
						var grp = defaultWidgetsArr[c];
						if(grp['valueField'] == grpName)
						{
							Ext.Msg.show({
							title : templatesAlertLbl,
							msg : grpNameExistsMsg,
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING
							});
							return;
						}
					}
					for(var c=0;c<widgtgrpArr.length;c++)
					{
						var grp = widgtgrpArr[c];
						if(grp['valueField'] == grpName)
						{
							Ext.Msg.show({
							title : templatesAlertLbl,
							msg : grpNameExistsMsg,
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING
							});
							return;
						}
					}
					
				}
			}
			else
			{
				grpName = widgetGrpComboVal;
				if(grpName != null && grpName == '-1')
				{
					Ext.Msg.show({
						title : templatesAlertLbl,
						msg : widgetGrpAlertMsg,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
					});
					return;
				}
			}
		}
		var widgetForCompare = widgetName
		if(grpName!=null && grpName!='')
		{
			var widgetsArr ='';
			if(widgtgrpArr!=null && !Ext.isEmpty(widgtgrpArr))
			{
				for(var g=0;g<widgtgrpArr.length;g++)
				{
					var grpInfo = widgtgrpArr[g];
					if(grpInfo['valueField'] == grpName)
					{
						widgetsArr =  grpInfo[grpName];
						break;
					}
				}
				
			}
			widgetName = widgetName+'|GRP|'+loginUser+"#"+grpName;
		}
		widgetName=this.filterEncode(widgetName);
		paramsForSave = paramsForSave+"&action=saveWidgetConfig&profileName=" + encodeURIComponent(profileName)+"&widgetName="+widgetName;

		var configuredMeasures = '';
		var configuredDDChartType = '';
		var configuredDDTest = '';
		var configuredDDMeasure = '';
		var configuredDDSummaryColumn = '';
		var configuredDDColumn = '';
		
		if(tempSelectedGraph != null && tempSelectedGraph != 'servicehealth' && tempSelectedGraph != 'DDTable')
		{
			var gridObj = mec.getComparisontable();
			var gridStore = gridObj.getStore();
			
			var gridRecordCount = gridObj.getStore().getCount();
			if (gridRecordCount == 0) {
			Ext.Msg.show({
					title : templatesAlertLbl,
					msg : measureAlertMsg,
					buttons : Ext.MessageBox.OK,
					icon : Ext.MessageBox.WARNING
				});
				return;
			}
			for ( var i = 0; i < gridRecordCount; i++) {
				var measuresHidVal = gridObj.getStore().getAt(i).get('hidVal');
				configuredMeasures = configuredMeasures+","+measuresHidVal;
				if(tempSelectedGraph!=null && tempSelectedGraph == 'CombinationChart')
				{
					var chartType = gridObj.getStore().getAt(i).get('chartType');
					configuredMeasures = configuredMeasures+"~^~"+chartType;
				}
				else if(tempSelectedGraph!=null && tempSelectedGraph == 'DDTable')
				{
					var ddVal = gridObj.getStore().getAt(i).get('ddHidVal');
					configuredMeasures = configuredMeasures+"|"+ddVal;
				}
			}
			if(configuredMeasures!=null && configuredMeasures.indexOf(',') == 0)
			{
				configuredMeasures = configuredMeasures.substring(1);
			}
		}
		else
		{
			if(tempSelectedGraph != null && tempSelectedGraph == 'DDTable')
			{
				var testComboObj =  Ext.getCmp('testCombo');
				var measurelistObj =  Ext.getCmp('measureListCombo');
				var summarizeDDColumnComboObj =  Ext.getCmp('summarizeDDColumnCombo');
				var ddcolumnsMultiSelectObj =  Ext.getCmp('ddcolumnsMultiSelect');
				
				var chartTypeCombo =  Ext.getCmp('graphicalTypeId');
				var selectedChartType = chartTypeCombo.getValue();

				var selectedTest = "";
				var selectedMeas = "";
				var selectedSummarizedColumn = "";
				var selectedDDColumn = "";

				if (!Ext.isEmpty(testComboObj))
				{
					selectedTest = testComboObj.getValue();
				}
				if (!Ext.isEmpty(measurelistObj))
				{
					selectedMeas = measurelistObj.getValue();
				}
				if (!Ext.isEmpty(summarizeDDColumnComboObj))
				{
					selectedSummarizedColumn = summarizeDDColumnComboObj.getValue();
				}
				if (!Ext.isEmpty(ddcolumnsMultiSelectObj))
				{
					selectedDDColumn = ddcolumnsMultiSelectObj.getValue();
				}

				if (selectedTest != null && selectedTest == '-1') {
					Ext.Msg.show({
						title : templatesAlertLbl,
						msg : testAlertMsg,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
					});
					return;
				} else if (selectedMeas != null && (selectedMeas == '' || selectedMeas == '-1')) {
					Ext.Msg.show({
						title : templatesAlertLbl,
						msg : measureAlertMsg,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
					});
					return;
				}else if (selectedDDColumn != null && selectedDDColumn == '-1' ) {
					Ext.Msg.show({
						title : templatesAlertLbl,
						msg : ddColsnotApplicableAlertMsg,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
					});
					return;
				}else if (selectedDDColumn != null && selectedDDColumn == '' ) {
					Ext.Msg.show({
						title : templatesAlertLbl,
						msg : noDDColSelectedAlertMsg,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
					});
					return;
				}
				
				if(selectedChartType !=null && selectedChartType == 'Table')
				{				
					var configVal = '';
					if (!Ext.isEmpty(measurelistObj))
					{
						var measureComboStore = measurelistObj.getStore();
						var measRecord = measureComboStore.findRecord(measurelistObj.valueField, selectedMeas, 0, false, true, true);
						var mIdx = measureComboStore.indexOf(measRecord);
						var dispMeas = measureComboStore.getAt(mIdx).get('displayField');
						configVal = selectedTest + ":" + selectedMeas ;
						configVal = configVal +"!!!"+dispMeas;
					}

					var dispDDColumns = '';
					var ddColumnVals = '';
					for ( var ddcol in selectedDDColumn) {
						var selectedDDCol = selectedDDColumn[ddcol];
						var ddColsComboStore = ddcolumnsMultiSelectObj.getStore();
						var ddColRecord = ddColsComboStore.findRecord(ddcolumnsMultiSelectObj.valueField, selectedDDCol, 0, false, true, true);
						var mIdx = ddColsComboStore.indexOf(ddColRecord);
						var dispDDCol = ddColsComboStore.getAt(mIdx).get('displayField');
						dispDDColumns = dispDDColumns + "," + dispDDCol ;
						ddColumnVals = ddColumnVals + "," + selectedDDCol + ":" + dispDDCol;
					}
					if (ddColumnVals != null && ddColumnVals.indexOf(',') == 0) {
						ddColumnVals = ddColumnVals.substr(1);
					}
					if (dispDDColumns != null && dispDDColumns.indexOf(',') == 0) {
						dispDDColumns = dispDDColumns.substr(1);
					}

					var DDConfig = configVal +"|"+ ddColumnVals;
					configuredMeasures = selectedChartType +"$"+ DDConfig;

					configuredDDChartType = selectedChartType;
					configuredDDTest = selectedTest;
					configuredDDMeasure = selectedMeas;
					configuredDDSummaryColumn = '';
					configuredDDColumn = ddColumnVals;
				}
				else
				{
					if (selectedSummarizedColumn != null && (selectedSummarizedColumn == '' || selectedSummarizedColumn == '-1')) {
						Ext.Msg.show({
							title : templatesAlertLbl,
							msg : measureAlertMsg,
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING
						});
						return;
					}

					var configVal = '';
					if (!Ext.isEmpty(measurelistObj))
					{
						var measureComboStore = measurelistObj.getStore();
						var measRecord = measureComboStore.findRecord(measurelistObj.valueField, selectedMeas, 0, false, true, true);
						var mIdx = measureComboStore.indexOf(measRecord);
						var dispMeas = measureComboStore.getAt(mIdx).get('displayField');
						configVal = selectedTest + ":" + selectedMeas ;
						configVal = configVal +"!!!"+dispMeas;
					}
					var actualDDColumnVals = '';
					var dispDDColumns = '';
					var ddColumnVals = '';
					for ( var ddcol in selectedDDColumn) {
						var selectedDDCol = selectedDDColumn[ddcol];
						var ddColsComboStore = ddcolumnsMultiSelectObj.getStore();
						var ddColRecord = ddColsComboStore.findRecord(ddcolumnsMultiSelectObj.valueField, selectedDDCol, 0, false, true, true);
						var mIdx = ddColsComboStore.indexOf(ddColRecord);
						var dispDDCol = ddColsComboStore.getAt(mIdx).get('displayField');
						dispDDColumns = dispDDColumns + "," + dispDDCol ;
						actualDDColumnVals = actualDDColumnVals + "," + selectedDDCol;
						ddColumnVals = ddColumnVals + "," + selectedDDCol + ":" + dispDDCol;
					}
					if (ddColumnVals != null && ddColumnVals.indexOf(',') == 0) {
						ddColumnVals = ddColumnVals.substr(1);
					}
					if (dispDDColumns != null && dispDDColumns.indexOf(',') == 0) {
						dispDDColumns = dispDDColumns.substr(1);
					}
					if (actualDDColumnVals != null && actualDDColumnVals.indexOf(',') == 0) {
						actualDDColumnVals = actualDDColumnVals.substr(1);
					}
					var actualSelectedSummarizedColumn = selectedSummarizedColumn;

					var summarizeDDColumnsDisp = summarizeDDColumnComboObj.getRawValue();
					selectedSummarizedColumn = selectedSummarizedColumn + ":" + summarizeDDColumnsDisp;
			

					var DDConfig = configVal +"|"+ ddColumnVals +"|^|"+ selectedSummarizedColumn;
					configuredMeasures = selectedChartType +"$"+ DDConfig;

					configuredDDChartType = selectedChartType;
					configuredDDTest = selectedTest;
					configuredDDMeasure = selectedMeas;
					configuredDDSummaryColumn = actualSelectedSummarizedColumn;
					configuredDDColumn = actualDDColumnVals;

					var ddColumnValues=ddColumnVals.split(',');
					for(var col in ddColumnValues)
					{
						var column = ddColumnValues[col];
						if(column==selectedSummarizedColumn)
						{
							Ext.Msg.show({
								title : templatesAlertLbl,
								msg : alreadyExistLbl,
								buttons : Ext.MessageBox.OK,
								icon : Ext.MessageBox.WARNING
							});
							return;
						}
					}
				}
			}
			else
			{
				var categoryOptsObj = Ext.getCmp('categoryOpts');
				var categoryOptsVal = '';
				if(!Ext.isEmpty(categoryOptsObj))
				{
					categoryOptsVal = categoryOptsObj.getValue();
				}

				if(categoryOptsVal =='-1')
				{
					var gridObj = mec.getComparisontable();
					var gridStore = gridObj.getStore();
					
					var gridRecordCount = gridObj.getStore().getCount();
					if (gridRecordCount > 0) {
						categoryOptsVal = 'Descriptors';
					}
				}

				if(categoryOptsVal != null && (categoryOptsVal == 'Zone' || categoryOptsVal == 'Segment' || categoryOptsVal == 'Service'))
				{
					var healthCenterComponentComboValue = Ext.getCmp('healthCenterComponentCombo').getValue();

					if(Ext.isEmpty(healthCenterComponentComboValue) || healthCenterComponentComboValue == '' || healthCenterComponentComboValue == '-1')
					{
						Ext.Msg.show({
							title : templatesAlertLbl,
							msg : 'Please choose '+categoryOptsVal,
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING
						});
						return;
					}

					if(healthCenterComponentComboValue.includes('ALL') && healthCenterComponentComboValue.length > 1)
					{
						Ext.Msg.show({
							title : templatesAlertLbl,
							msg : 'Individual '+ categoryOptsVal +'s cannot be added if ALL option selected',
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING
						});
						return;
					}
								
					configuredMeasures = categoryOptsVal+'|$|'+healthCenterComponentComboValue;
				}
				else if(categoryOptsVal != null && categoryOptsVal == 'Components')
				{
					var healthCenterCompTypeComboValue = '';
					var healthCenterCompTypeComboObj = Ext.getCmp('healthCenterCompTypeCombo');
					
					if(!Ext.isEmpty(healthCenterCompTypeComboObj))
					{
						healthCenterCompTypeComboValue = healthCenterCompTypeComboObj.getValue();
					}
			
					if (healthCenterCompTypeComboValue != null && healthCenterCompTypeComboValue == '-1') 
					{
						Ext.Msg.show({
							title : templatesAlertLbl,
							msg : compTypAlertMsg,
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING
						});
						return;
					}
					configuredMeasures = categoryOptsVal+'|$|'+healthCenterCompTypeComboValue;
				}
				else if(categoryOptsVal != null && categoryOptsVal == 'Descriptors')
				{
					var gridObj = mec.getComparisontable();
					var gridStore = gridObj.getStore();
					
					var gridRecordCount = gridObj.getStore().getCount();
					if (gridRecordCount == 0) {
					Ext.Msg.show({
							title : templatesAlertLbl,
							msg : descriptorAddAlertMsg,
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING
						});
						return;
					}
					for ( var i = 0; i < gridRecordCount; i++) {
						var measuresHidVal = gridObj.getStore().getAt(i).get('hidVal');
						configuredMeasures = configuredMeasures+","+measuresHidVal;
					}
					if(configuredMeasures!=null && configuredMeasures.indexOf(',') == 0)
					{
						configuredMeasures = configuredMeasures.substring(1);
					}
				}
				else if(categoryOptsVal != null && categoryOptsVal == 'vms|desktop|users')
				{
					var healthCenterCompTypeComboValue = '';
					var healthCenterCompTypeComboObj = Ext.getCmp('healthCenterCompTypeCombo');

					var healthCenterComponentComboValue = Ext.getCmp('healthCenterComponentCombo').getValue();
					
					if(!Ext.isEmpty(healthCenterCompTypeComboObj))
					{
						healthCenterCompTypeComboValue = healthCenterCompTypeComboObj.getValue();
					}
			
					if (healthCenterCompTypeComboValue != null && healthCenterCompTypeComboValue == '-1') 
					{
						Ext.Msg.show({
							title : templatesAlertLbl,
							msg : compTypAlertMsg,
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING
						});
						return;
					}				

					if(Ext.isEmpty(healthCenterComponentComboValue) || healthCenterComponentComboValue == '' || healthCenterComponentComboValue == '-1')
					{
						Ext.Msg.show({
							title : templatesAlertLbl,
							msg : 'Please choose vm.',
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING
						});
						return;
					}

					if(healthCenterComponentComboValue.includes('allVms') && healthCenterComponentComboValue.length > 1)
					{
						Ext.Msg.show({
							title : templatesAlertLbl,
							msg : 'Individual vm\'s cannot be added if \'All VMs\' option selected.',
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING
						});
						return;
					}
								
					configuredMeasures = 'vms|$|'+healthCenterCompTypeComboValue+'!^!'+healthCenterComponentComboValue;
				}
				else
				{
					Ext.Msg.show({
						title : templatesAlertLbl,
						msg : categoryAlertMsg,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
					});
					return;
				}
			}

		}
		configuredMeasures=this.filterEncode(configuredMeasures);
		paramsForSave = paramsForSave + "&configuredMeasures="+ encodeURIComponent(configuredMeasures);
		var actionOnWidget = '';
		actionOnWidget =userdefinedWidgetWindowObj.widgetAction;
		var needRegenerateWidgetCompAssociation=false;
		var isEditWidgetMode=false;
		var configuredDataValue ={};
		var isCombinationChart = false;
		if(tempSelectedGraph!=null && tempSelectedGraph == 'CombinationChart')
		{
			isCombinationChart = true;
		}
		if(actionOnWidget == 'modify Widget')
		{
			isEditWidgetMode=true;
			var needToReGenerate = false;
			var userDefinedWidgetWindowObj = this.getUserDefinedWidgetWindow();
			configuredDataValue =userDefinedWidgetWindowObj.configuredDataValue;
			var configuredGridData = configuredDataValue['gridData'];
			if(configuredGridData!=null && !Ext.isEmpty(configuredGridData))
			{
				if(configuredGridData.length!=gridRecordCount)
				{
					needToReGenerate = true;
				}
				else{
					
					var currentDataArray = new Array();
					var configuredDataArray = new Array();				
					var configuredChartTypeArray = new Array();				
					var defaultChartTypeArray = new Array();				
					for ( var i = 0; i < gridRecordCount; i++) {
						var measuresHidVal = gridObj.getStore().getAt(i).get('hidVal');
						currentDataArray.push(measuresHidVal);	
						if(isCombinationChart)
						{
							var chartType = gridObj.getStore().getAt(i).get('chartType');
							configuredChartTypeArray.push(chartType);	

						}
					}

					for ( var i = 0; i < configuredGridData.length; i++) {
						var configuredMeasuresHidVal = configuredGridData[i].hidVal;		
						configuredDataArray.push(configuredMeasuresHidVal);		
						if(isCombinationChart)
						{
							var defChartType = configuredGridData[i].chartType;	
							defaultChartTypeArray.push(defChartType);
						}
					}
					var needToBreak = false;
					for ( var i = 0; i < currentDataArray.length; i++) {

						var currentConfigValue = currentDataArray[i];
						//var currentChartType = configuredChartTypeArray[i]; 

						if(needToBreak)
						{
							break;
						}
						
						for ( var j = 0; j < configuredDataArray.length; j++) {
							
							var configuredValue = configuredDataArray[j];
							//var defChartType = defaultChartTypeArray[j];
							if(currentConfigValue==configuredValue)
							{
								if(isCombinationChart)
								{
									var currentChartType = configuredChartTypeArray[i];
									var defChartType = defaultChartTypeArray[j]; 
									if(currentChartType == defChartType)
									{
										break;
									}
								}
								else
								{
									break;
								}
							}
							
							if(configuredDataArray.length-1 == j)
							{
								needToReGenerate = true;
								needToBreak = true;
							}
						}
					}
				}
			}
			
			if(tempSelectedGraph == 'DDTable')
			{				
				var selectedChartTypeVal = configuredDataValue['selectedChartType'];
				var selectedTestVal = configuredDataValue['selectedTest'];
				var selectedMeasureVal = configuredDataValue['selectedMeasure'];
				var selectedDDColumnsVal = configuredDataValue['selectedDDColumns'];
				var summarizedDDColumnVal = configuredDataValue['summarizedDDColumn'];

				if((configuredDDChartType != selectedChartTypeVal) || (configuredDDTest != selectedTestVal) || (configuredDDMeasure != selectedMeasureVal) || (configuredDDColumn != selectedDDColumnsVal) || (configuredDDSummaryColumn != summarizedDDColumnVal))
				{
					needToReGenerate=true;
				}
			}

			if(needToReGenerate==true)
			{
				needRegenerateWidgetCompAssociation=true;
			}
			else
			{
				if(reGenerateCompsFromExclude)
					needRegenerateWidgetCompAssociation=true;
			}

			var prevWidgetName = userdefinedWidgetWindowObj.internalId;
			if(prevWidgetName!=null && prevWidgetName!='')
			{
				paramsForSave = paramsForSave + "&prevWidgetName="+ encodeURIComponent(prevWidgetName);
			}
		}
		paramsForSave = paramsForSave + "&actionOnWidget="+ encodeURIComponent(actionOnWidget);
		var widgetSettings = '';
		if(filepath!=null && !filepath.endsWith("/final/images/"+strSkin))
		{
			widgetSettings = widgetSettings+'Custom#'+fileName;
		}
		else if(filepath == null)
		{
			widgetSettings = widgetSettings+'Default#'+fileName;
		}
		var showAggOptVal = 'no';
		if(tempSelectedGraph!=null && tempSelectedGraph!='')
		{
			//widgetSettings = widgetSettings+','+'DisplayType#'+tempSelectedGraph;
			if(tempSelectedGraph == 'TabularView')
			{
				var showValueOpt = Ext.getCmp('ShowValues').getChecked();
				if(showValueOpt!=null && !Ext.isEmpty(showValueOpt))
				{
					showValueOptVal = showValueOpt[0].inputValue;
					if(showValueOptVal != null)
					{
						widgetSettings = widgetSettings +','+'ShowValues#'+showValueOptVal;
					}
				}
			}
			var topNGraphType = '';
			if(tempSelectedGraph == 'TopN')
			{
				topNGraphType = Ext.getCmp('GraphicalType').getValue();
				if(topNGraphType!=null && topNGraphType!='')
				{
					widgetSettings = widgetSettings+','+'DisplayType#'+topNGraphType;
				}
			}
			/* CODE FOR CHECKING GRAPH OF WIDGET CHANGE */
			if(actionOnWidget == 'modify Widget')
			{
				if(isTopNWidget && topNGraphType!='')
				{
					if(topNVal!=null && topNVal!= '' && topNVal != topNGraphType)
					{
						paramsForSave = paramsForSave + "&graphicalTypeChanged=yes";
					}
				}
				else if(grapForWidget != '' && tempSelectedGraph != grapForWidget)
				{
					paramsForSave = paramsForSave + "&graphicalTypeChanged=yes";
				}
			}
			grapForWidget = '';
			isTopNWidget = false;
			
			topNVal = '';
			/* CODE END FOR CHECKING GRAPH OF WIDGET CHANGE */
			if(widgetSettings.indexOf('DisplayType#') < 0)
			{
				widgetSettings = widgetSettings+','+'DisplayType#'+tempSelectedGraph;
			}
			var aggrComp = Ext.getCmp('showAggOpt');
			if(aggrComp!=null && !Ext.isEmpty(aggrComp) && aggrComp.isVisible())
			{
				var showAggOpt = aggrComp.getChecked();
				 showAggOptVal = showAggOpt[0].inputValue;
				if(showAggOptVal!=null && showAggOptVal == 'yes')
				{
					var AggrfnCombo = Ext.getCmp('AggrfnCombo');
					var aggrFunction = AggrfnCombo.getValue();
					if(aggrFunction!=null && aggrFunction!='')
					{
						widgetSettings = widgetSettings +','+'Aggregation#Yes|'+aggrFunction;
						if(isEditWidgetMode && !Ext.isEmpty(configuredDataValue['AggregateOptions']) && configuredDataValue['AggregateOptions'].hasOwnProperty('AggrConfiguration'))
						{
							var configuredAggOpt=configuredDataValue['AggregateOptions']['AggrConfiguration']['isAaggregationEnabled'];
							if(configuredAggOpt!=null && ('Yes|'+aggrFunction)!=configuredAggOpt)
							{
								needRegenerateWidgetCompAssociation=true;
							}
						}
					}
				}
				else
				{
					widgetSettings = widgetSettings +','+'Aggregation#No';
					if(isEditWidgetMode && !Ext.isEmpty(configuredDataValue['AggregateOptions']) && configuredDataValue['AggregateOptions'].hasOwnProperty('AggrConfiguration'))
						{
							var configuredAggOpt=configuredDataValue['AggregateOptions']['AggrConfiguration']['isAaggregationEnabled'];
							if(configuredAggOpt!=null && configuredAggOpt.startsWith("Yes|"))
							{
								needRegenerateWidgetCompAssociation=true;
							}
						}
				}
			}
			if(tempSelectedGraph == 'TopNGaugeChart' || tempSelectedGraph == 'TopNDigitalChart')
			{
				var testName='';
				if (gridRecordCount != 0) {
					for ( var i = 0; i < gridRecordCount; i++) {
						var measuresHidVal = gridObj.getStore().getAt(i).get('hidVal');
						var test = measuresHidVal.substr(0, measuresHidVal.indexOf(":"));
						testName=test;		  
					}
				}
				if(testName!=null && (testName.endsWith("_ag") || testName.endsWith("_agx")))
				{
					var AggregateFunction = Ext.getCmp('Aggregation_Function');
					var aggFnVal='avg';
					if(!Ext.isEmpty(AggregateFunction))
					{
						var selAggFnVal=AggregateFunction.getValue();
						if(!Ext.isEmpty(selAggFnVal))
						{
							aggFnVal=selAggFnVal;
						}
					}
					widgetSettings = widgetSettings +','+'Aggregation#No|'+aggFnVal;
				}
				else
				{
					var AggregateFunction = Ext.getCmp('Aggregation_Function');
					var aggFnVal='avg';
					if(!Ext.isEmpty(AggregateFunction))
					{
						var selAggFnVal=AggregateFunction.getValue();
						if(!Ext.isEmpty(selAggFnVal))
						{
							aggFnVal=selAggFnVal;
						}
					}
					widgetSettings = widgetSettings +','+'Aggregation#Yes|'+aggFnVal;
					if(isEditWidgetMode && !Ext.isEmpty(configuredDataValue['AggregateOptions']) && configuredDataValue['AggregateOptions'].hasOwnProperty('AggrConfiguration'))
					{
						var configuredAggOpt=configuredDataValue['AggregateOptions']['AggrConfiguration']['isAaggregationEnabled'];
						if(configuredAggOpt!=null && ('Yes|'+aggrFunction)!=configuredAggOpt)
						{
							needRegenerateWidgetCompAssociation=true;
						}
					}
				}
			}
		/*	if(tempSelectedGraph!=null && (tempSelectedGraph=='liveMeasuresBox' || tempSelectedGraph=='TopNGaugeChart' || tempSelectedGraph=='TopN' || tempSelectedGraph=='HeatMapChart' || tempSelectedGraph=='TopNDigitalChart' || tempSelectedGraph=='TopNTabularView' || tempSelectedGraph=='TopNBarChart' || tempSelectedGraph=='PieChart'))
			{
				var actionOnDescCombo = Ext.getCmp('actionOnDescCombo');
				var actionOnDesc = actionOnDescCombo.getValue();
				var descriptorVal = Ext.getCmp('descriptorTextField').getValue();
				if(descriptorVal!=null && descriptorVal == '')
				{
					descriptorVal = 'None';
				}
				if(descriptorVal!=null && descriptorVal.indexOf(",") > 0 )
				{
					descriptorVal = descriptorVal.replace(/,/g ,"$!");
				}
			}			*/
			
			/*if(actionOnDesc!=null && actionOnDesc == 'Exclude' && descriptorVal!=null && (descriptorVal.indexOf('*')>-1 || descriptorVal.indexOf('*.*')>-1))
			{
				Ext.Msg.show({
							title : templatesAlertLbl,
							msg : descriptorExcludeAlertMsg,
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING
							});
							return;
			}*/
			/*if(tempSelectedGraph!=null && (tempSelectedGraph=='liveMeasuresBox' || tempSelectedGraph=='TopNGaugeChart' || tempSelectedGraph=='TopN' || tempSelectedGraph=='HeatMapChart' || tempSelectedGraph=='TopNDigitalChart' || tempSelectedGraph=='TopNTabularView' || tempSelectedGraph=='TopNBarChart' || tempSelectedGraph=='PieChart'))
			{
				if(actionOnDesc!=null && actionOnDesc == 'Exclude')
				{
					widgetSettings = widgetSettings +',Exclude#'+descriptorVal+',Include#*';
				}
				else if(actionOnDesc!=null && actionOnDesc == 'Include')
				{
					widgetSettings = widgetSettings +',Include#'+descriptorVal+',Exclude#None';
				}
			}		   */

			var showDescOpt = Ext.getCmp('DescriptorsOpt');
			var showDescOptVal ='no'
			var showServersOptVal = 'no';
			if(showDescOpt!=null && !Ext.isEmpty(showDescOpt))
			{
				var showDescOptObj=showDescOpt.getValue();

				if(showDescOptObj!=null && showDescOptObj==true)
				{
					showDescOptVal='yes';
				}
			}
			var showserversOpt = Ext.getCmp('ServersOpt');
			if(showserversOpt!=null && !Ext.isEmpty(showserversOpt))
			{
				var showServersOptObj=showserversOpt.getValue();

				if(showServersOptObj!=null && showServersOptObj==true)
				{
					showServersOptVal='yes';
				}
			}
			var legendDisplayStr = '';
			if(showDescOptVal == 'yes')
			{
				legendDisplayStr = legendDisplayStr+'$'+'Descriptors';
			}
			if(showServersOptVal == 'yes')
			{
				legendDisplayStr = legendDisplayStr+'$'+'Servers';
			}
			if(legendDisplayStr!=null && legendDisplayStr.indexOf('$') == 0)
			{
				legendDisplayStr = legendDisplayStr.substring(1);
			}
			if(tempSelectedGraph == 'TopN')
			{
				var timelineOpt  = Ext.getCmp('Timeline');
				if(timelineOpt!=null && timelineOpt!='undefined' && !Ext.isEmpty(timelineOpt))
				{
					var TimelineVal = Ext.getCmp('Timeline').getValue();
					if(TimelineVal!=null && TimelineVal!='')
					{
						widgetSettings = widgetSettings +','+'Timeline#'+TimelineVal;
					}
				}
				var priority = Ext.getCmp('Priority').getValue();
				if(priority!=null && priority!='')
				{
						widgetSettings = widgetSettings+','+'Priority#'+priority;
				}
				var weightedAvgOptVal = 'no';
				var weightedAvgComp = Ext.getCmp('WeightedAverage').getChecked();
				if(weightedAvgComp!=null && !Ext.isEmpty(weightedAvgComp))
				{
					weightedAvgOptVal = weightedAvgComp[0].inputValue;
					if(weightedAvgOptVal != null)
					{
						widgetSettings = widgetSettings +','+'WeightedAverage#'+weightedAvgOptVal;
					}
				}
			}
			if(tempSelectedGraph == 'TabularView' || tempSelectedGraph == 'TopN' || tempSelectedGraph == 'BarChart')
			{
				if(legendDisplayStr!=null && legendDisplayStr == '')
				{
					Ext.Msg.show({
						title : templatesAlertLbl,
						msg : displayTypeAlertMsg,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
					});
					return;
				}
				if(tempSelectedGraph == 'BarChart' || topNGraphType == 'TopNBarChart')
				{
					widgetSettings = widgetSettings +','+'Legend Display#'+legendDisplayStr;
				}
				else
				{
					widgetSettings = widgetSettings +','+'Display#'+legendDisplayStr;
				}
				if(topNGraphType == 'TopNBarChart')
				{
					var colorpalleteCombo = $('#palleteID');
					if(colorpalleteCombo != null && colorpalleteCombo != 'undefined' &&  !Ext.isEmpty(colorpalleteCombo))
					{
						var commboValIdx = colorpalleteCombo[0];
						if(commboValIdx != null && commboValIdx != 'undefined')
						{
							var selectedColorpallete = commboValIdx.value;
							widgetSettings = widgetSettings+','+'ColorPalette#'+selectedColorpallete;
						}
					}
				}
			}
			else
			{
				var showMetricsOpt = Ext.getCmp('MetricsOpt');
				var showMetricsOptVal ='no'
				if(showMetricsOpt!=null && !Ext.isEmpty(showMetricsOpt))
				{
					var showMetricsOptObj=showMetricsOpt.getValue();

					if(showMetricsOptObj!=null && showMetricsOptObj==true)
					{
						showMetricsOptVal='yes';
					}
				}
				if(showServersOptVal == 'no' && showDescOptVal == 'no')
				{
					var showSummaryOpt = Ext.getCmp('YesOpt');
					if(showSummaryOpt!=null && !Ext.isEmpty(showSummaryOpt))
					{
						var showSummaryVal = showSummaryOpt.getValue();
						if(showSummaryVal!=null && showSummaryVal==true)
						{
							showMetricsOptVal='yes';
						}
					}
				}
				if(showMetricsOptVal == 'yes')
				{
					legendDisplayStr = legendDisplayStr+'$'+'Metrics';
					if(legendDisplayStr!=null && legendDisplayStr.indexOf('$') == 0)
					{
						legendDisplayStr = legendDisplayStr.substring(1);
					}
					if(legendDisplayStr!=null && legendDisplayStr == '')
					{
						Ext.Msg.show({
							title : templatesAlertLbl,
							msg : displayTypeAlertMsg,
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING
						});
						return;
					}
				}
				var saveLegend  = false;
				var legend = Ext.getCmp('Legend Display');
				if(legend!=null && !Ext.isEmpty(legend) && legend.isVisible())
				{
					saveLegend = true;
				}

				if(tempSelectedGraph == 'PieChart' || tempSelectedGraph == 'activityChart')
				{
					if(legendDisplayStr==null || legendDisplayStr=='')
					{
						legendDisplayStr = 'Metrics';
					}
					saveLegend = true;
				}
				if(legendDisplayStr!=null && legendDisplayStr!='')
				{
					if(saveLegend)
					{
					  widgetSettings = widgetSettings +','+'Legend Display#'+legendDisplayStr;
					}
					else
					{
						widgetSettings = widgetSettings +','+'Legend Display#none';
					}
				}
				else
				{
					widgetSettings = widgetSettings +','+'Legend Display#none';
				}
			}
			
			if(tempSelectedGraph == 'liveMeasuresBox' || topNGraphType=='TopNBarChart' || tempSelectedGraph=='BarChart')
			{
				if(tempSelectedGraph == 'liveMeasuresBox' )
				{
					var viewTypeOpt = 'Vertical';
					var ApplyStateColor = Ext.getCmp('UseStateColorForBackground').getValue();
					//var resizeFont = Ext.getCmp('ResizeFont').getValue();
					var useStateColorForBackground='no';
					//var resizeFontVal='no';
					if(viewTypeOpt!=null && !Ext.isEmpty(viewTypeOpt))
					{
						var viewTypeOptVal = viewTypeOpt[0].inputValue;
						if(viewTypeOptVal != null)
						{
							widgetSettings = widgetSettings +','+'ViewType#'+viewTypeOptVal;
						}
					}
					if(ApplyStateColor!=null && ApplyStateColor==true)
					{
						useStateColorForBackground='yes';
					}
					/*if(resizeFont!=null && resizeFont==true)
					{
						resizeFontVal='yes';
					}*/
					widgetSettings = widgetSettings +','+'UseStateColorForBackground#'+useStateColorForBackground;
					//widgetSettings = widgetSettings +','+'ResizeFont#'+resizeFontVal;
				}
				else
				{
					var viewTypeOpt = Ext.getCmp('ViewType').getChecked();
					if(viewTypeOpt!=null && !Ext.isEmpty(viewTypeOpt))
					{
						var viewTypeOptVal = viewTypeOpt[0].inputValue;
						if(viewTypeOptVal != null)
						{
							widgetSettings = widgetSettings +','+'ViewType#'+viewTypeOptVal;
						}
					}
				}
			}
			if(tempSelectedGraph == 'AreaChart'  || tempSelectedGraph=='BarChart')
			{
				var stackedAreachartOpt = Ext.getCmp('Stacked').getChecked();
				if(stackedAreachartOpt!=null && !Ext.isEmpty(stackedAreachartOpt))
				{
					var stackedAreachartOptVal = stackedAreachartOpt[0].inputValue;
					if(stackedAreachartOptVal != null)
					{
						widgetSettings = widgetSettings +','+'Stacked#'+stackedAreachartOptVal;
						if(tempSelectedGraph=='BarChart' && stackedAreachartOptVal=="Yes")
						{
							var AggrfnCombo = Ext.getCmp('AggrfnCombo');
							var aggrFunction = AggrfnCombo.getValue();
							if(aggrFunction!=null && aggrFunction!='')
							{
								widgetSettings = widgetSettings +','+'Aggregation#Yes|'+aggrFunction;
								if(isEditWidgetMode && !Ext.isEmpty(configuredDataValue['AggregateOptions']) && configuredDataValue['AggregateOptions'].hasOwnProperty('AggrConfiguration'))
								{
									var configuredAggOpt=configuredDataValue['AggregateOptions']['AggrConfiguration']['isAaggregationEnabled'];
									if(configuredAggOpt!=null && ('Yes|'+aggrFunction)!=configuredAggOpt)
									{
										needRegenerateWidgetCompAssociation=true;
									}
								}
							}
						}
					}
				}
			}
			if(tempSelectedGraph == 'TimelineChart' || tempSelectedGraph == 'TrendGraph')
			{
				var chartTypeOpt = Ext.getCmp('Chart Type').getValue();
				if(chartTypeOpt!=null && !Ext.isEmpty(chartTypeOpt))
				{
						widgetSettings = widgetSettings +','+'chartType#'+chartTypeOpt;
				}
			}
			if(tempSelectedGraph == 'TrendGraph')
			{
				var statisticsVal = Ext.getCmp('Statistics').getValue();
				if(statisticsVal!=null && !Ext.isEmpty(statisticsVal))
				{
						widgetSettings = widgetSettings +','+'graph#'+statisticsVal;
				}
				var durationVal = Ext.getCmp('Duration').getValue();
				if(durationVal!=null && !Ext.isEmpty(durationVal))
				{
						widgetSettings = widgetSettings +','+'period#'+durationVal;
				}
			}
			if(tempSelectedGraph == 'TimelineChart' || tempSelectedGraph == 'TrendGraph' || tempSelectedGraph == 'AreaChart' || tempSelectedGraph == 'CombinationChart')
			{
				var showSummaryValue = 'No';
				var showSummaryOpt = Ext.getCmp('YesOpt');
				if(showSummaryOpt!=null && !Ext.isEmpty(showSummaryOpt))
				{
					var showSummaryVal = showSummaryOpt.getValue();
					if(showSummaryVal!=null && showSummaryVal==true)
					{
						showSummaryValue='Yes';
					}
				}
				widgetSettings = widgetSettings +','+'showChartSummary#'+showSummaryValue;
			}
			if(tempSelectedGraph == 'PieChart' || tempSelectedGraph == 'activityChart')
			{
				/*var showLegendStyle = Ext.getCmp('showLegendStyle').getChecked();
				if(showLegendStyle!=null && !Ext.isEmpty(showLegendStyle))
				{
					var showLegendStyleVal = showLegendStyle[0].inputValue;
					if(showLegendStyleVal != null)
					{
						widgetSettings = widgetSettings +','+'showLegendStyle#'+showLegendStyleVal;
					}
				}*/
				var showDistprcnt = Ext.getCmp('showDistprcnt').getChecked();
				if(showDistprcnt!=null && !Ext.isEmpty(showDistprcnt))
				{
					var showDistprcntVal = showDistprcnt[0].inputValue;
					if(showDistprcntVal != null)
					{
						widgetSettings = widgetSettings +','+'showDistprcnt#'+showDistprcntVal;
					}
				} 
				var chartDistribution = Ext.getCmp('ChartDistribution').getChecked();
				if(chartDistribution!=null && !Ext.isEmpty(chartDistribution))
				{
					var chartDistributionVal = chartDistribution[0].inputValue;
					if(chartDistributionVal!=null && chartDistributionVal == "Multiple")
					{
						widgetSettings = widgetSettings +','+'Aggregation#Yes|avg';
					}
					if(chartDistributionVal != null)
					{
						widgetSettings = widgetSettings +','+'ChartDistribution#'+chartDistributionVal;
					}
					
					if(isEditWidgetMode && !Ext.isEmpty(configuredDataValue['advanceControlArr']))
					{
						var chartDistDataObj= configuredDataValue['advanceControlArr'][2];
						var configChartDistribution=chartDistDataObj['selectedValue'];
						if(configChartDistribution!=null && configChartDistribution!=chartDistributionVal)
						{
							needRegenerateWidgetCompAssociation=true;
						}
					}
				} 
			}
			if(tempSelectedGraph == 'TopNDigitalChart')
			{
				var SummaryChartTypeVal = Ext.getCmp('SummaryGraphType').getValue();
				var ChartSwitchVal = Ext.getCmp('ChartSummaryEnabled').getValue();
				var ShowIconVal = Ext.getCmp('ShowIcon').getValue();
				var ApplyStateColor = Ext.getCmp('UseStateColorForFonts').getValue();
			//	var resizeFont = Ext.getCmp('ResizeFont').getValue();
				if(ShowIconVal!=null && ShowIconVal==true)
				{
					var digitalChartImgIconObj=$('#digitalChartImgIcon');
					var fileName = digitalChartImgIconObj[0].src;
					var filepath = null;
					if(fileName!=null && fileName.lastIndexOf("/")>0)
					{
						filepath = fileName.substring(0,fileName.lastIndexOf("/"));
						fileName=fileName.substring(fileName.lastIndexOf("/")+1);
					}
					else if(fileName!=null && fileName.lastIndexOf("\\")>0)
					{
						filepath = fileName.substring(0,fileName.lastIndexOf("\\"));
						fileName=fileName.substring(fileName.lastIndexOf("\\")+1);
					}
					else
					{
						fileName = digitalChartImgIconObj[0].className;
					}
				}
				var ChartSwitchValue = 'no';
				var ShowIconValue = 'no';
				var useStateColorForFonts='no';
			//	var resizeFontVal='no';
				if(ChartSwitchVal!=null && ChartSwitchVal==true)
				{
					ChartSwitchValue='yes';
				}else{
					SummaryChartTypeVal='None'
				}
				if(ShowIconVal!=null && ShowIconVal==true)
				{
					ShowIconValue='yes';
				}
				if(ApplyStateColor!=null && ApplyStateColor==true)
				{
					useStateColorForFonts='yes';
				}
		/*		if(resizeFont!=null && resizeFont==true)
				{
					resizeFontVal='yes';
				}*/
				widgetSettings = widgetSettings +','+'ChartSummaryEnabled#'+ChartSwitchValue;
				widgetSettings = widgetSettings +','+'SummaryGraphType#'+SummaryChartTypeVal;
				widgetSettings = widgetSettings +','+'ShowIcon#'+ShowIconValue;
				if(ShowIconVal!=null && ShowIconVal==true)
				{
					if(filepath!=null && !filepath.endsWith("/final/images/"+strSkin))
					{
						widgetSettings = widgetSettings +','+'imgIcon#'+'Custom#'+fileName;
					}
					else if(filepath == null)
					{
						widgetSettings = widgetSettings +','+'imgIcon#'+'Default#'+fileName;
					}
				}else{
					widgetSettings = widgetSettings +','+'imgIcon#'+'';
				}
				widgetSettings = widgetSettings +','+'UseStateColorForFonts#'+useStateColorForFonts;
			//	widgetSettings = widgetSettings +','+'ResizeFont#'+resizeFontVal;
			}
			if(tempSelectedGraph == 'TopNGaugeChart')
			{
				var ShowGaugeCircle = Ext.getCmp('ShowGaugeCircle').getValue();
				if(ShowGaugeCircle!=null && !Ext.isEmpty(ShowGaugeCircle) && ShowGaugeCircle==true)
				{
					ShowGaugeCircle='yes';
				}
				else
				{
					ShowGaugeCircle='no';
				}
				widgetSettings = widgetSettings +','+'ShowGaugeCircle#'+ShowGaugeCircle;

				var UseStateColorForGauge = Ext.getCmp('UseStateColorForGauge').getValue();
				if(UseStateColorForGauge!=null && !Ext.isEmpty(UseStateColorForGauge) && UseStateColorForGauge==true)
				{
					UseStateColorForGauge='yes';
				}
				else
				{
					UseStateColorForGauge='no';
				}
				widgetSettings = widgetSettings +','+'UseStateColorForGauge#'+UseStateColorForGauge;
			}
			if(tempSelectedGraph != 'TopN')
			{
				if(tempSelectedGraph != 'DDTable')
				{
					var timelineOpt  = Ext.getCmp('Timeline');
					if(timelineOpt!=null && timelineOpt!='undefined' && !Ext.isEmpty(timelineOpt))
					{
						var TimelineVal = Ext.getCmp('Timeline').getValue();
						if(TimelineVal!=null && TimelineVal!='')
						{
							widgetSettings = widgetSettings +','+'Timeline#'+TimelineVal;
						}
					}
				}
				var colorpalleteCombo = $('#palleteID');
				if(colorpalleteCombo != null && colorpalleteCombo != 'undefined' &&  !Ext.isEmpty(colorpalleteCombo))
				{
					var commboValIdx = colorpalleteCombo[0];
					if(commboValIdx != null && commboValIdx != 'undefined')
					{
						var selectedColorpallete = commboValIdx.value;
						if(tempSelectedGraph == 'TopNGaugeChart')
						{
							widgetSettings = widgetSettings+','+'selectedGaugeColor#'+selectedColorpallete;
						}
						else
						{
							widgetSettings = widgetSettings+','+'ColorPalette#'+selectedColorpallete;
						}
					}
				}
			}
		
			if(tempSelectedGraph == 'TabularView')
			{
				var EnableStateColor = Ext.getCmp('EnableMeasureStateColor').getValue();
				
				var enableMeasureStateColor='no';
				
				if(EnableStateColor!=null && EnableStateColor==true)
				{
					enableMeasureStateColor='yes';
				}
				widgetSettings = widgetSettings +','+'EnableMeasureStateColor#'+enableMeasureStateColor;	

				if(enableMeasureStateColor!=null && enableMeasureStateColor == 'yes')
				{
					var setStateAsCombo = Ext.getCmp('SetStateColorOn');
					var setStateInValue = setStateAsCombo.getValue();
					if(setStateInValue!=null && setStateInValue!='')
					{
						widgetSettings = widgetSettings +','+'SetStateColorOn#'+setStateInValue;
					}
				}
				else
				{
					widgetSettings = widgetSettings +','+'SetStateColorOn#None';
				}				  
			}

			if(tempSelectedGraph == 'servicehealth')
			{
				var enableLegendOptObj = Ext.getCmp('enableLegendOpt');
				var enableLegendOption='';
				if(enableLegendOptObj != null && enableLegendOptObj != "" && enableLegendOptObj != undefined)
				{
					enableLegendOption=enableLegendOptObj.getValue();
				}
				var showLegends='';
				if(enableLegendOption != null && enableLegendOption == true)
				{
					showLegends="yes";
				}
				else
				{
					showLegends="no";
				}
				widgetSettings = widgetSettings+',showLegends#'+ encodeURIComponent(showLegends);
			}

			if(tempSelectedGraph == 'DDTable')
			{
				var selectedChartType = '';
				var graphicalOptsObj = Ext.getCmp('graphicalTypeId');
				if(!Ext.isEmpty(graphicalOptsObj))
				{
					selectedChartType = graphicalOptsObj.getValue();

				}

				if(selectedChartType!=null && selectedChartType =='Bar Chart')
				{
					var viewTypeOpt = Ext.getCmp('ViewType').getChecked();
					if(viewTypeOpt!=null && !Ext.isEmpty(viewTypeOpt))
					{
						var viewTypeOptVal = viewTypeOpt[0].inputValue;
						if(viewTypeOptVal != null)
						{
							widgetSettings = widgetSettings +','+'ViewType#'+viewTypeOptVal;
						}
					}
				}
				else if(selectedChartType!=null && (selectedChartType =='Time Line' || selectedChartType =='Area'))
				{
					var timelineOpt  = Ext.getCmp('Timeline');
					if(timelineOpt!=null && timelineOpt!='undefined' && !Ext.isEmpty(timelineOpt))
					{
						var TimelineVal = Ext.getCmp('Timeline').getValue();
						if(TimelineVal!=null && TimelineVal!='')
						{
							widgetSettings = widgetSettings +','+'Timeline#'+TimelineVal;
						}
					}

					var showSummaryValue = 'No';
					var showSummaryOpt = Ext.getCmp('YesOpt');
					if(showSummaryOpt!=null && !Ext.isEmpty(showSummaryOpt))
					{
						var showSummaryVal = showSummaryOpt.getValue();
						if(showSummaryVal!=null && showSummaryVal==true)
						{
							showSummaryValue='Yes';
						}
					}
					widgetSettings = widgetSettings +','+'showChartSummary#'+showSummaryValue;
				}
			}
						
			var widgetDescription = Ext.getCmp('widgetDescrText').getValue();
			widgetDescription.trim();
			if (!this.checkBlankSpc(widgetDescription) && !this.checkSpace(widgetDescription)) 
			{
				if (this.checkSpecialCharacter(widgetDescription)) {
				Ext.Msg.show({
					title : templatesAlertLbl,
					msg : widgetDescSplCharacterAlertMsg,
					buttons : Ext.MessageBox.OK,
					icon : Ext.MessageBox.WARNING
				});
				return;
				}
			}
		/*	if (widgetDescription != null && widgetDescription.length > 32) {
			Ext.Msg.show({
				title : templatesAlertLbl,
				msg : maxWidgetDescripLengthAlert,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
				});
				return;
			}*/
			widgetSettings = widgetSettings+','+'Description#'+widgetDescription;
		}
		else
		{

			Ext.Msg.show({
							title: templatesAlertLbl,
							msg: 'plese select Graphical Type',
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
						return ;
		}
		if(widgetSettings!=null && widgetSettings.indexOf(',')==0)
		{
			widgetSettings = widgetSettings.substring(1);
		}
		if(widgetSettings!=null && widgetSettings.endsWith(','))
		{
			widgetSettings = widgetSettings.substring(0,widgetSettings.lastIndexOf(','));
		}
		paramsForSave = paramsForSave + "&widgetSettings="+ encodeURIComponent(widgetSettings);

		if(isEditWidgetMode)
		{
			if(needRegenerateWidgetCompAssociation)
			{
				paramsForSave = paramsForSave + "&reConfigAssociatedComponents=yes";
			}
			else
			{
				paramsForSave = paramsForSave + "&reConfigAssociatedComponents=no";
			}
		}

		var gridStackObj=mec.getGridstackpanel();
		var posStrVal=gridStackObj.getTBPanelPositions();
		var blockPosMatch = blockId+':'+widgetName;
		if(posStrVal!=null && posStrVal!='')
		{
			paramsForSave=paramsForSave+'&layoutConfig='+encodeURIComponent(posStrVal)+'&blockPosMatch='+encodeURIComponent(blockPosMatch);
		}
		gridStackObj=null;
		delete gridStackObj;
		var panelId = userdefinedWidgetWindowObj.blockId;
		var configPanl = Ext.getCmp(panelId);
		//userdefinedWidgetWindowObj.close();

		configPanl.setLoading(true, true);
		var idx = -1;
		if(widgetsArr!=null && widgetsArr!='' && !Ext.isEmpty(widgetsArr))
		{
				var widgtArray = new Array();
				for(var a = 0; a<widgetsArr.length; a++)
				{
					var widgetWithAssTemplate = widgetsArr[a];
					if(widgetWithAssTemplate!=null && widgetWithAssTemplate.indexOf("$")>0)
					{
						var template = widgetWithAssTemplate.substring(0,widgetWithAssTemplate.indexOf("$"));
						var nameForwidget = widgetWithAssTemplate.substring(widgetWithAssTemplate.indexOf("$")+1);
						if(template!=null && template != profileName)
						{
							widgtArray.push(nameForwidget);
						}
					}
				}
				if(widgtArray!=null && !Ext.isEmpty(widgtArray))
				{
					idx = widgtArray.indexOf(widgetForCompare);
				}
		}
		if(idx > -1)
		{
			Ext.Msg.show({
			title : templatesAlertLbl,
			msg : widgetExistInGrpAlert,
			buttons : Ext.Msg.YESNO,
			icon : 'iconConfirmation',
			fn:function(buttonId)
			{
				if(buttonId == 'yes')
				{
					Ext.Ajax.request({
						url: '/final/servlet/com.eg.EgTemplateBuilderController',
						method: 'POST',
						params: paramsForSave,
						scope: this,
						success: function (response) {
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);
							var userDefinedwindowIdObj=Ext.getCmp('userDefinedWindowaa');
							mec.showDataForBlock(configPanl,jsonData,panelId);

							// Sumbitting the form and calling the animation
							Ext.getCmp('form_sumbit_button').addAnimation();
							var getWindowObj = Ext.get('createWidgetMain');
							var length = mec.getGridstackpanel()._serialization().length;

							var blocknum = blockId.substring(blockId.length-1);
							temparray = new Array();
							for(var i=0;i<gridStackPnlArr.length;i++)
							{
								var widgetid1 = gridStackPnlArr[i]['id'];
								var blockid1 = widgetid1;
								if(widgetid1!=null && widgetid1.indexOf("_")>0)
								{
									blockid1=widgetid1.substring(0,widgetid1.indexOf("_"));
								}
								var configpanl1 = Ext.getCmp(blockid1);
								var internalid1 = configpanl1.internalId;
								if(internalid1 == null || internalid1 == '')
								{
									temparray.push(blockid1)
								}
							}
							var tempblockid;
							for(var i=0;i<gridStackPnlArr.length;i++)
							{
								var widgetid = gridStackPnlArr[i]['id'];
								var blockid = widgetid;
								if(widgetid!=null && widgetid.indexOf("_")>0)
								{
									blockid=widgetid.substring(0,widgetid.indexOf("_"));
								}
								var configpanl = Ext.getCmp(blockid);
								var internalid = configpanl.internalId;

								var winObj = userDefinedwindowIdObj;
								if(internalid == null || internalid == '')
								{
									var conftitle ='';
									if(blockid!=null)
									{
										var blocknum = blockid.substring(blockid.indexOf("block")+5);
										//conftitle ='widget '+blocknum;
										conftitle ='Widget';
									}

									config = {
												blockId : blockid,
												internalId : internalid,
												title:conftitle,
												widgetAction :'addWidget',
												isFluidWindowConfigPopup : false
										};
									tempblockid=blockid;
									Ext.apply(winObj,config);
									userDefinedwindowIdObj.setTitle(conftitle+' Configuration');
									winObj.fireEvent('render',winObj);
										break;
								}
							}
						}
					});
				}
				else
				{
					configPanl.setLoading(false);
					return;
				}
			}
			});
		}
		else
		{
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgTemplateBuilderController',
				method: 'POST',
				params: paramsForSave,
				scope: this,
				success: function (response) {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var userDefinedwindowIdObj=Ext.getCmp('userDefinedWindowaa');
					mec.showDataForBlock(configPanl,jsonData,panelId);

					// Sumbitting the form and calling the animation
					Ext.getCmp('form_sumbit_button').addAnimation();
					var getWindowObj = Ext.get('createWidgetMain');
					var length = mec.getGridstackpanel()._serialization().length;

					var blocknum = blockId.substring(blockId.length-1);
					temparray = new Array();
					for(var i=0;i<gridStackPnlArr.length;i++)
					{
						var widgetid1 = gridStackPnlArr[i]['id'];
						var blockid1 = widgetid1;
						if(widgetid1!=null && widgetid1.indexOf("_")>0)
						{
							blockid1=widgetid1.substring(0,widgetid1.indexOf("_"));
						}
						var configpanl1 = Ext.getCmp(blockid1);
						var internalid1 = configpanl1.internalId;
						if(internalid1 == null || internalid1 == '')
						{
							temparray.push(blockid1)
						}
					}
					var tempblockid;
					for(var i=0;i<gridStackPnlArr.length;i++)
					{
						var widgetid = gridStackPnlArr[i]['id'];
						var blockid = widgetid;
						if(widgetid!=null && widgetid.indexOf("_")>0)
						{
							blockid=widgetid.substring(0,widgetid.indexOf("_"));
						}
						var configpanl = Ext.getCmp(blockid);
						var internalid = configpanl.internalId;

						var winObj = userDefinedwindowIdObj;
						if(internalid == null || internalid == '')
						{
							var conftitle ='';
							if(blockid!=null)
							{
								var blocknum = blockid.substring(blockid.indexOf("block")+5);
								//conftitle ='widget '+blocknum;
								conftitle ='Widget';
							}

							config = {
										blockId : blockid,
										internalId : internalid,
										title:conftitle,
										widgetAction :'addWidget',
										isFluidWindowConfigPopup : false
								};
							tempblockid=blockid;
							Ext.apply(winObj,config);
							userDefinedwindowIdObj.setTitle(conftitle+' Configuration');
							winObj.fireEvent('render',winObj);
								break;
						}
					}
				}
			});
		}

	},
	saveFluidTemplateWindowResizeConfig : function(profileName, layoutConfig)
	{
		mec = this;
		var gridStackPnlArr=[];
		gridStackPnlArr = mec.getGridstackpanel()._serialization();
		var numberOfWidgets = gridStackPnlArr.length;
		Ext.Ajax.request({
			url : '/final/servlet/com.eg.EgTemplateBuilderController',
			method : 'POST',
			params : '&action=saveLayoutConfig&profileName=' + encodeURIComponent(profileName)+"&gridsterLength="+ encodeURIComponent(numberOfWidgets)
					+ '&layoutConfig=' + encodeURIComponent(layoutConfig),
			scope : this,
			success : function(response) {
				var jsonText = response.responseText;
				if (jsonText != null && jsonText != '') {
					// var jsonData = Ext.decode(jsonText);
				}
			}
		});
	},
	showDataForBlock : function(configPanl,jsonData,panelId)
	{
		configPanl.setLoading(false); 
		//configPanl.setTitle(jsonData['resultData']['widgetName']);
		configPanl.removeAll();
		configPanl.suspendEvents(true);
		var htmlvar = '';
		var action = 'loadWidget';
		var user = jsonData['resultData']['userName'];
		if(jsonData['resultData']['imgClassname']!=null && jsonData['resultData']['imgClassname']!='')
		{
			imgClassname = jsonData['resultData']['imgClassname'];
			if(configPanl.isDefaultWidget)
			{
				if(imgClassname.indexOf(":")>0 && imgClassname.startsWith("Default"))
				{
					imgClassname = imgClassname.substring(imgClassname.indexOf(":")+1);
				}
				else
				{
					imgClassname = '/final/images/icon-library/'+user+'/'+imgClassname;
				}
				var blockTitle=jsonData['resultData']['dispWidgetName'];
				if (blockTitle != null && blockTitle == "currentalarms") {
					blockTitle=alertsTitle;
				} else if (blockTitle != null && blockTitle == "tierhealth") {
					blockTitle=tierHealthTitle;
				} else if (blockTitle != null && blockTitle == "servicehealth") {
					blockTitle=healthPieChartTitle;
				}
				else if (blockTitle != null && blockTitle == "networkhealth") {
					blockTitle=networkhealthPieChartTitle;
				}
				 else if (blockTitle != null && blockTitle == "news") {
					blockTitle=newsTitle;
				}
				else if (blockTitle != null && blockTitle == "weather") {
					blockTitle=weatherTitle;
				}
				htmlvar = '<div style="height:100%;width:100%;display:table;"><div style="display:table-cell;vertical-align:middle;text-align:center;" align="center" ><img src="/final/images/spacer.gif" width="42px" height="42px" border="0px" class="'+imgClassname+'" /><div style="text-align:center;margin-top:10px"><span class="textView  font_normal13">'+blockTitle+'</span></div></div>';
			}
			else
			{
				if(imgClassname.indexOf(":")>0 && imgClassname.startsWith("Default"))
				{
					imgClassname = imgClassname.substring(imgClassname.indexOf(":")+1);
					htmlvar = '<div style="height:100%;width:100%;display:table;"><div style="display:table-cell;vertical-align:middle;text-align:center;" align="center" ><img src="/final/images/spacer.gif" width="42px" height="42px" border="0px" class="'+imgClassname+' mouse" onclick="javascript:configPopup(\''+panelId+'\',\''+action+'\',\''+user+'\');" /><div style="text-align:center;margin-top:10px"><span class="widgetName mouse newFont_normal13"><a onclick="javascript:configPopup(\''+panelId+'\',\''+action+'\',\''+user+'\');">'+jsonData['resultData']['widgetName']+'</a></span></div></div>';
				}
				else
				{
					if(user!=null && user!='')
					{
						imgClassname = '/final/images/icon-library/'+user+'/'+imgClassname;
						htmlvar = '<div style="height:100%;width:100%;display:table;"><div style="display:table-cell;vertical-align:middle;text-align:center;" align="center" ><img src="'+imgClassname+'" width="42px" height="42px" border="0px" class="mouse" onclick="javascript:configPopup(\''+panelId+'\',\''+action+'\',\''+user+'\');" /><div style="text-align:center;margin-top:10px"><span class="widgetName mouse newFont_normal13"><a onclick="javascript:configPopup(\''+panelId+'\',\''+action+'\',\''+user+'\');">'+jsonData['resultData']['widgetName']+'</a></span></div></div></div>';
					}
				}
			}
		}
		else
		{
			if(configPanl.isDefaultWidget)
			{
				imgClassname = 'configureWidgetDefaultIcon';
				var blockTitle=jsonData['resultData']['dispWidgetName'];
				if (blockTitle != null && blockTitle == "currentalarms") {
					blockTitle=alertsTitle;
				} else if (blockTitle != null && blockTitle == "tierhealth") {
					blockTitle=tierHealthTitle;
				} else if (blockTitle != null && blockTitle == "servicehealth") {
					blockTitle=healthPieChartTitle;
				}
				else if (blockTitle != null && blockTitle == "networkhealth") {
					blockTitle=networkhealthPieChartTitle;
				}
				 else if (blockTitle != null && blockTitle == "news") {
					blockTitle=newsTitle;
				}
				else if (blockTitle != null && blockTitle == "weather") {
					blockTitle=weatherTitle;
				}
				htmlvar = '<div style="height:100%;width:100%;display:table;"><div style="display:table-cell;vertical-align:middle;text-align:center;" align="center" ><img src="/final/images/spacer.gif" width="42px" height="42px" border="0px" class="'+imgClassname+'" /><div style="text-align:center;margin-top:10px"><span class="textView font_normal13">'+blockTitle+'</span></div></div>';
			}
			else
			{
				imgClassname = '/final/images/'+strSkin+'/userDefinedWidgetIstamName.png';
				htmlvar = '<div style="height:100%;width:100%;display:table;"><div style="display:table-cell;vertical-align:middle;text-align:center;" align="center" ><img src="'+imgClassname+'" width="42px" height="42px" border="0px" class="mouse" onclick="javascript:configPopup(\''+panelId+'\',\''+action+'\',\''+user+'\');" /><div style="text-align:center;margin-top:10px"><span class="widgetName mouse newFont_normal13"><a onclick="javascript:configPopup(\''+panelId+'\',\''+action+'\',\''+user+'\');">'+jsonData['resultData']['dispWidgetName']+'</a></span></div></div></div>';
			}
		}
		configPanl.add({
					xtype: 'container',
					baseCls: 'OneClickConfigButton',
					action: 'configmeAction',
					flex: 1,
					html : htmlvar

					//html: '<div style="height:100%;width:100%;display:table"><div style="text-align:center;margin-top:40px;vertical-align:middle;display:table-cell;cursor:pointer" onclick="javascript:configPopup(\''+configPanl.id+'\');"><h1 style="line-height:90px;font-family:digital-7regular;font-size:70px;font-weight:normal;color:#35c8c2" class="count">'+measureValue+'</h1><div>';


					/*handler: function() {
						tempBuilderApp.getController("Main").fluidWindowModifyClick(panelId,'loadWidget');
					}*/
				});
				if(jsonData['resultData']['internalID']!=null && jsonData['resultData']['internalID']!='')
				{
					configPanl.internalId = jsonData['resultData']['internalID'];
				}
				configPanl.action = 'loadWidget';
				configPanl.resumeEvents();
				configPanl.doComponentLayout();
		if(jsonData['resultData']['widgetsForUserArr']!=null && !Ext.isEmpty(jsonData['resultData']['widgetsForUserArr']))
		{
			currWidgetsForUser = jsonData['resultData']['widgetsForUserArr'];
		}
	},
	cloneMyTemplate : function()
	{
		var profileName = Ext.getCmp('templateLayoutObj').profileName;
		this.callClone(profileName,false);
	},
	cloneSharedTemplate :  function(templateDispName,internalTempName)
	{
		var meC=this;
		var existingTemplateName = templateDispName;
		var title = templateDispName+"_Clone";
		var createClone = Ext.create("Ext.window.Window", {
					//height:175,
					height:strSkin == "Light" ? 185 : 175,
					width:strSkin == "Light" ? 345 : 325,
					//bodyBorder:true,
					header:{
						height:33,
						padding:'0 10',
						margin:0
					},
					ghost:false,
					ui:'newPopupWindow newplainHeader_border',
					frame:true,
					padding:0,
					border:true,
					modal:true,
					closable:true,
					draggable:true,
					resizable:false,
					id:'callCloneWindow',
					timeFilterConfig:'',
					title:cloneTemplateLbl,
					scroll:true,
					autoScroll:true,
					closeAction:'destroy',
					buttonAlign :'center',
					layout:'hbox',
					items : [
						{
							xtype:'image',
							imgCls:'clone_arrow',
							width:21,
							height:33,
							margin:'15 0 5 10',
							src:'/final/images/'+strSkin+'/clone_arrow.png',
						},{
							xtype:'container',
							layout:'vbox',
					defaults:{
						labelAlign:'top',
					},
							flex:1,
							items:[
								{
						xtype : 'label',
									margin:'10 20 5 2',
						html: '<div class="font_bold13">'+templateDispName+'</div>',
					},{
						xtype:'textfield',
						id : 'clone_templatename',
						name:'clone_templatename',
						cls: 'textbox',
						width:'100%',
									margin:'10 10 10 2',
						labelWidth:152,
						fieldLabel:templateNameLbl,
						labelSeparator:'',
						value : title
								}
							]
						}
					],
					dockedItems: [{
						xtype: 'toolbar',
						dock: 'bottom',
						cls:'egFooter',
						items: [
							'->',
						{
							xtype : 'button',
							buttonAlign:'center',
							text : screenLabelsObj['Clone'],
							margin:6,
							padding:'0 10 0 10',
							cls : 'buttonNewBig',
							buttonAlign : 'center',
							handler : function(btn)
							{
								var clone_templatename=Ext.getCmp('clone_templatename').getValue();
								meC.cloneTemplate(clone_templatename,internalTempName,btn,false,true);
							}
						},'->'
						]
					}],
					listeners: {        
						'close':function(win){
										Ext.getCmp('cloneTemplate').defaultState();
									  
								  }
					}
				});
				createClone.show();
	},
	callClone:function(profileName,isDefaultTemplate)
	{
		var meC=this;
		var existingTemplateName = profileName;
		var title = profileName+"_Clone";
		var createClone = Ext.create("Ext.window.Window", {
					//height:175,
					height:strSkin == "Light" ? 185 : 175,
					width:strSkin == "Light" ? 345 : 325,
					//bodyBorder:true,
					header:{
						height:33,
						padding:'0 10',
						margin:0
					},
					ghost:false,
					ui:'newPopupWindow newplainHeader_border',
					frame:true,
					padding:0,
					border:true,
					modal:true,
					closable:true,
					draggable:true,
					resizable:false,
					id:'callCloneWindow',
					timeFilterConfig:'',
					title:cloneTemplateLbl,
					scroll:true,
					autoScroll:true,
					closeAction:'destroy',
					buttonAlign :'center',
					layout:'hbox',
					items : [
						{
							xtype:'image',
							imgCls:'clone_arrow',
							width:21,
							height:33,
							margin:'15 0 5 10',
							src:'/final/images/'+strSkin+'/clone_arrow.png',
						},{
							xtype:'container',
							layout:'vbox',
					defaults:{
						labelAlign:'top',
					},
							flex:1,
							items:[
								{
						xtype : 'label',
									margin:'10 20 5 2',
						html: '<div class="font_bold13">'+profileName+'</div>',
					},{
						xtype:'textfield',
						id : 'clone_templatename',
						name:'clone_templatename',
						cls: 'textbox',
						width:'100%',
									margin:'10 10 10 2',
						labelWidth:152,
						fieldLabel:templateNameLbl,
						labelSeparator:'',
						value : title
								}
							]
						}
					],
					dockedItems: [{
						xtype: 'toolbar',
						dock: 'bottom',
						cls:'egFooter',
						items: [
							'->',
						{
							xtype : 'button',
							buttonAlign:'center',
							text : screenLabelsObj['Clone'],
							margin:6,
							padding:'0 10 0 10',
							cls : 'buttonNewBig',
							buttonAlign : 'center',
							handler : function(btn)
							{
								var clone_templatename=Ext.getCmp('clone_templatename').getValue();
								meC.cloneTemplate(clone_templatename,existingTemplateName,btn,isDefaultTemplate,false);
							}
						},'->'
						]
					}],
					listeners: {        
						'close':function(win){
										Ext.getCmp('cloneTemplate').defaultState();
									  
								  }
					}
				});
				createClone.show();
	},
	cloneTemplate: function(cloneTemplateName,existingTemplateName,createBtn,isDefaultTemplate,isSharedTemplate)
	{
		cloneTemplateName.trim();
		var meC=this;
		createBtn.setDisabled(true);
		if (this.checkBlankSpc(cloneTemplateName)) {
			Ext.Msg.show({
				title : templatesAlertLbl,
				msg : templateBlankNameAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});
			createBtn.setDisabled(false);
			return;
		}
		if (this.checkSpace(cloneTemplateName)) {
			Ext.Msg.show({
				title : templatesAlertLbl,
				msg : templateBlankNameAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});
			createBtn.setDisabled(false);
			return;
		}
	/*	if (cloneTemplateName != null && cloneTemplateName.length > 32) {
			Ext.Msg.show({
				title : templatesAlertLbl,
				msg : maxTmpltLengthAlert,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});
			createBtn.setDisabled(false);
			return;
		}*/
		if(cloneTemplateName != null && cloneTemplateName.indexOf(' ') == 0 )
		{
				Ext.Msg.show({
						title : templatesAlertLbl,
						msg : templateNameStartsWithSpacMsg,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
				});
						createBtn.setDisabled(false);
					return;
		}
		if (this.checkSpecialCharacter(cloneTemplateName)) {
			Ext.Msg.show({
				title : templatesAlertLbl,
				msg : templateSplCharacterAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});
			createBtn.setDisabled(false);
			return;
		}
		var dIdx="-1";
		var defaultAction = publicJson['action'];
		if(defaultAction!=null && defaultAction=='loadMyTemplateListPage')
		{
			var templateBuilderlistViewObj = Ext.getCmp('dataViewId');
			if(!Ext.isEmpty(templateBuilderlistViewObj))
			{
				var existingTemplateStore = templateBuilderlistViewObj.getStore();
				var dispTempName=cloneTemplateName;
				if(isSharedTemplate)
				{
					if(dispTempName!=null && dispTempName.indexOf("|USRSEP|")>0)
					{
						var disparray = dispTempName.split("|USRSEP|");
						dispTempName = disparray[0];
					}
				}
				var profRecord = existingTemplateStore.findRecord('templateName', dispTempName, 0, false, false, true);
				dIdx = existingTemplateStore.indexOf(profRecord);
			}
		}
		else
		{
			var templateBuildercomboobj = Ext.getCmp('templateListCombo');
			if(!Ext.isEmpty(templateBuildercomboobj))
			{
				var existingTemplateStore = templateBuildercomboobj.getStore();
				var dataLength = existingTemplateStore.data.length;
				var temp = [];
				for(var i = 0;i<dataLength;i++)
				{
					var disp = existingTemplateStore.getAt(i).get('valueField');
					if(disp!=null && disp.indexOf("|USRSEP|")>0)
					{
						var disparray = disp.split("|USRSEP|");
						disp = disparray[0];
					}
					temp.push(disp);
				}
				 dIdx = temp.indexOf(cloneTemplateName);
			}
			/*if(!Ext.isEmpty(templateBuildercomboobj))
			{
				var existingTemplateStore = templateBuildercomboobj.getStore();
				var profRecord = existingTemplateStore.findRecord('templateName', cloneTemplateName, 0, false, false, true);
				dIdx = existingTemplateStore.indexOf(profRecord);
			}*/
		}
		if (dIdx > -1) {
			 Ext.Msg.show({
				title: templatesAlertLbl,
				msg: templateExistAlertMsg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				createBtn.setDisabled(false);
				return;
		}

		Ext.Ajax.request({
			url: '/final/servlet/com.eg.EgTemplateBuilderController',
			method: 'POST',
			params: 'action=cloneTemplate&prevTemplateName='+encodeURIComponent(existingTemplateName)+'&profileName=' + encodeURIComponent(cloneTemplateName)+'&screenWidth=' + (Ext.getBody().getViewSize().width) + '&isDefaultTemplate='+isDefaultTemplate+'&screenHeight=' + (Ext.getBody().getViewSize().height),
			scope: this,
			success: function (response) {
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				Ext.getCmp('callCloneWindow').close();
				if (jsonData['update'] == 'success') {
					meC.goToTemplateListPage();
				}

			}
		});
	},
	checkBlankSpc : function(templateName) {
		templateName.replace(/^[\s]+/, '').replace(/[\s]+$/, '').replace(/[\s]{2,}/, ' ');
		if (templateName.length == 0 || templateName == "") {
			return true;
		}
		return false;
	},
	checkSpecialCharacter : function(templateName) {
		var splChar = "%&+=\"?#:$!^~,|[]";
		for ( var i = 0; i < templateName.length; i++) {
			check_char = splChar.indexOf(templateName.charAt(i))
			// Returns value 1 if the special character listed
			// in splChar is found
			if (check_char >= 0) {
				return true;
			}
		}
		return false;
	},
	checkSpace : function(templateName)
	{
		if(templateName.replace(/\s/g,"") == ""){
			return true;
			}
			return false;
	},
	createTemplateView :function()
	{
		var url = 'comesFrom=templateBuilder&action=loadCreateTemplatePopup';
		this.loadCreateTemplateViewPopup('addTemplate',url);
	},
	loadCreateTemplateViewPopup:function(action,url){
		var meC = this;
		minwidgets = 0;
		widgetsforTemplate = 0;
		defaultSelectedLayout = '';
		tempSelectedLayout = '';
		var templateconfigurationObj=this.getCreateTemplate();
		if (Ext.isEmpty(templateconfigurationObj))
			templateconfigurationObj = Ext.widget('createTemplate');

			var paramsForLoad = '';
			if(url!=null && url!='')
			{
				paramsForLoad = url;
			}
			Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgMonitorRequestDispatcher',
				method : 'POST',
				params : paramsForLoad+'&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight='
						+ (Ext.getBody().getViewSize().height),
				scope : this,
				success : function(response) {
							var jsonText = response.responseText;
						if (jsonText != null && jsonText != '') {
							var jsonData = Ext.decode(jsonText);
							templateconfigurationObj.suspendEvents(true);
							var templateIcon = jsonData['templateComponentAccessDetails']['templateImg'];
							if(templateIcon!=null && templateIcon!="")
							{
								if(templateIcon.indexOf(":")>0 && templateIcon.startsWith("Default"))
								{
									templateIcon = templateIcon.substring(templateIcon.indexOf(":")+1);
									Ext.getCmp('imgcont').update('<div class="listViewImgDefault"><div style="width:64px;height:64px;overflow:hidden;position: absolute;top:0%;left: 0%;right: 0%;margin: auto;bottom: 0%;"><img id="templateImageIcon"  class= "'+templateIcon+'" src="/final/images/clear.png" border="0px"  style="position:absolute;top:0%;left: 0%;right: 0%;margin: auto;bottom: 0%;" border="0px" /><div id="settingOver" class="settingOver"></div></div></div>');

								// 	Ext.getCmp('imgcont').update('<div class="listViewImgDefault" style="background-position:center 50%;margin:auto auto;overflow:hidden;"><div id="templateImageIcon"  class= "'+templateIcon+'" style="position: absolute;top:0%;left: 0%;right: 0%;margin: auto;bottom: 0%;"/></div><div id="settingOver" class="settingOver"></div></div>');

								}
								else
								{
									Ext.getCmp('imgcont').update('<div class="listViewImgDefault"><div style="width:64px;height:64px;overflow:hidden;position: absolute;top:0%;left: 0%;right: 0%;margin: auto;bottom: 0%;"><img id="templateImageIcon"  src="'+templateIcon+'"  style="position:absolute;top:0%;left: 0%;right: 0%;margin: auto;bottom: 0%;" border="0px"/><div id="settingOver" class="settingOver"></div></div></div>');
								}
							}
							defaultSelectedLayout = jsonData['layoutOptions']['selectedLayout'];
							tempSelectedLayout = defaultSelectedLayout;
						/*	if(defaultSelectedLayout!=null && defaultSelectedLayout!='')
							{
								Ext.getCmp(defaultSelectedLayout+'Btn').pressed = true;
								minwidgets = jsonData['layoutOptions']['minimumWidgetsForTemplate'];
								widgetsforTemplate = jsonData['layoutOptions']['numberofWidgetsForTemplate'];
								var restrictedWidgetForLayout = jsonData['layoutOptions']['restrictedWidgetsForLayout'];
								//defaultWidgetsForLayout = jsonData['layoutOptions']['defaultWidgetsForLayout'];
								if(widgetsforTemplate!=null && minwidgets!=null && restrictedWidgetForLayout!=null)
								{
									Ext.getCmp('templateNumField').setValue(widgetsforTemplate);
									Ext.getCmp('templateNumField').hiddenMinVal = minwidgets;
									Ext.getCmp('templateNumField').setMinValue(restrictedWidgetForLayout);
								}

							} */
							var templateViewOptCombo = Ext.getCmp('templateViewOpt');
							var TemplateType=jsonData['templateComponentAccessDetails']['TemplateType'];
							meC.setValueWithOptionInList(templateViewOptCombo,jsonData['templateTypeOptions']['typeOptions'],'-1', '');
							if(TemplateType!=null && TemplateType!='')
							{
								templateViewOptCombo.setValue(TemplateType);
							}
							var filterOptsCombo = Ext.getCmp('infraTypeCombo');
							var selectedInfraType=jsonData['templateComponentAccessDetails']['selectedType'];
							meC.setValueWithOptionInList(filterOptsCombo,jsonData['templateComponentAccessDetails']['typeOptions'],'-1', '');
							if(selectedInfraType!=null && selectedInfraType!='')
							{
								filterOptsCombo.setValue(selectedInfraType);
							}
							var compsMultiselectComo = Ext.getCmp('templateInfraElementsCombo');
							var availCompTypes = jsonData['templateComponentAccessDetails']['availElements'];
							var selectedelements = jsonData['templateComponentAccessDetails']['selectedElements'];
							 if(availCompTypes!=null && !Ext.isEmpty(availCompTypes)){
								 compsMultiselectComo.getStore().loadRawData(availCompTypes);
							 }
							 if(selectedelements!=null && !Ext.isEmpty(selectedelements)){
								 compsMultiselectComo.setValue(selectedelements);
							 }
							 var templateForHomePage=Ext.getCmp('templateForHomePage');
							templateForHomePage.suspendEvents(false);
							var useThisTemplateForHomePage=jsonData['templateComponentAccessDetails']['UseThisTemplateForHomePage'];
							if(useThisTemplateForHomePage!=null && useThisTemplateForHomePage=="yes")
							{
								templateForHomePage.setValue(true);
							}
							templateForHomePage.resumeEvents();
							 var templateInfraElementsSingleCombo=Ext.getCmp('templateInfraElementsSingleCombo');
							if(!Ext.isEmpty(templateInfraElementsSingleCombo))
							{
								var singleCompTypeComboStore=templateInfraElementsSingleCombo.getStore();
								var selectedTyp="";
								if(!Ext.isEmpty(singleCompTypeComboStore))
								{
									singleCompTypeComboStore.loadRawData(availCompTypes);
									singleCompTypeComboStore.insert(0, {
										displayField : compTypAlertMsg,
										valueField : '-1'
									});
									var record1 = singleCompTypeComboStore.findRecord("valueField", "All");
									if(!Ext.isEmpty(record1))
									{
										singleCompTypeComboStore.suspendEvents(false);
										singleCompTypeComboStore.remove(record1);
										singleCompTypeComboStore.resumeEvents();
									}
									selectedTyp="-1";
								}
								else
								{
									singleCompTypeComboStore.insert(0, {
										displayField : notApplicable,
										valueField : '-1'
									});
									selectedTyp="-1";
								}
								if(!Ext.isEmpty(selectedelements))
								{
									selectedTyp=selectedelements[0];
									if(Ext.isEmpty(selectedTyp))
									{
										selectedTyp=availCompTypes[0].valueField;
									}
									templateInfraElementsSingleCombo.setValue(selectedTyp);
								}
								else
								{
									templateInfraElementsSingleCombo.setValue(selectedTyp);
								}
							}
							var templateViewOpt=Ext.getCmp('templateViewOpt');
							if(!Ext.isEmpty(templateViewOpt))
							{
								var selectedTemp_Type=templateViewOpt.getValue();
								if(TemplateType!=null && (TemplateType=='consolidated-server' || TemplateType=='singleserver'))
								{
									compsMultiselectComo.hide();
									Ext.getCmp('multiSearchCompType').hide();
									Ext.getCmp('templateCompExpand').hide();
									filterOptsCombo.setValue('components');
									filterOptsCombo.setDisabled(true);
									templateInfraElementsSingleCombo.show();
								}
								else
								{
									templateInfraElementsSingleCombo.hide();
									compsMultiselectComo.show();
									Ext.getCmp('multiSearchCompType').show();
									Ext.getCmp('templateCompExpand').show();
									filterOptsCombo.setDisabled(false);
								}
							}
							if(action!=null && action == 'addTemplate')
							{
								templateconfigurationObj.setTitle(createtemplateTitle);
								/*var privateSharingBtnObj=Ext.getCmp('privateId2');
								privateSharingBtnObj.pressed=true;*/
								templateconfigurationObj.templateAction = 'Add';
								//Ext.getCmp('sharedUsersObj2').hide();
								var privateSharingBtnObj=Ext.getCmp('customPrivateId');
								Ext.getCmp('customSharingLbl').update('<div class="formLabelDivFont">'+jsonData['screenLabels']['monitor.dashboard.Sharing']+'</div>');
								privateSharingBtnObj.setText('<div class="dashboardSharedButtonText">'+jsonData['screenLabels']['monitor.common.Private']+'</div>');
								Ext.getCmp('customPublicId').setText('<div class="dashboardSharedButtonText">'+jsonData['screenLabels']['monitor.common.Public']+'</div>');
								Ext.getCmp('customShareId').setText('<div class="dashboardSharedButtonText">'+jsonData['screenLabels']['monitor.common.Share to']+'</div>');
								Ext.getCmp('customSharingGridLbl').update('<div class="formLabelDivFont">'+jsonData['screenLabels']['monitor.common.Share to - Available Users']+'</div>');
								privateSharingBtnObj.pressed=true;
								var sharedUsersSelGrid = Ext.getCmp('customCheckComp');
								sharedUsersSelGrid.getStore().loadRawData(jsonData['validUsers']);
							}
							
							if(action!=null && action == 'modifyTemplate')
							{
								templateconfigurationObj.setTitle(editTemplateTitle);
								var templateNamObj = Ext.getCmp('templateName');
								var profileName = jsonData['userSharingDetails']['profileName'];
								templateNamObj.setValue(profileName);
								var templateDescriptionObj = Ext.getCmp('templateDescription');
								templateDescriptionObj.setValue(jsonData['templateDescription']);
								var sharedPref = jsonData['userSharingDetails']['sharePref'];
								var privateId = Ext.getCmp('customPrivateId');
								var PublicId = Ext.getCmp('customPublicId');
								var shareId = Ext.getCmp('customShareId');
								Ext.getCmp('customSharingLbl').update('<div class="formLabelDivFont">'+jsonData['screenLabels']['monitor.dashboard.Sharing']+'</div>');

								privateId.setText('<div class="dashboardSharedButtonText">'+jsonData['screenLabels']['monitor.common.Private']+'</div>');
								PublicId.setText('<div class="dashboardSharedButtonText">'+jsonData['screenLabels']['monitor.common.Public']+'</div>');
								shareId.setText('<div class="dashboardSharedButtonText">'+jsonData['screenLabels']['monitor.common.Share to']+'</div>');
								Ext.getCmp('customSharingGridLbl').update('<div class="formLabelDivFont">'+jsonData['screenLabels']['monitor.common.Share to - Available Users']+'</div>');
								var sharedUsersObj = Ext.getCmp('customSharedUsersObj');
								sharedUsersObj.removeAll();
								var selectedUsrs = jsonData['userSharingDetails']['sharedUsers'];
								var sharingCompArr=[];
								sharingCompArr.push({
									xtype:'container',
									html: '<div class="formLabelDivFont padding4">'+jsonData['screenLabels']['monitor.common.Share to - Available Users']+'</div>',
								},{
									xtype:'gridpanel',
									store : new Ext.data.Store({
										fields : ['displayField','valueField','readWrite'],
										data : jsonData['validUsers']
									}),
									createGridButton:function (value,id,store,view,rowIndex,dataIndex) {
										new Ext.form.field.Checkbox({
											checked: value,
											margin:0,
											hidden : true,
											ui:'readWrite_checkbt',
											setToolTip:function(value){
												var me=this;
												readOnlyText = readOnlyLbl;
												switch(value){
													case true:
														readOnlyText = readWriteLbl;
													break;
													case false:
														readOnlyText = readOnlyLbl;
													break;
												}
												if(!Ext.isEmpty(store)){
													store.suspendEvents();
													var record = store.getAt(rowIndex);
													record.set(dataIndex, this.checked);
													store.resumeEvents();
												}
												me.getEl().set({"data-qtip": readOnlyText});
											},
											listeners:{
												afterRender:function(chk){
													this.setToolTip(this.checked);
												},
												change:function(chk,newValue, oldValue,eOpts,c){
													this.checked = newValue;
													chk.setToolTip(this.checked);
													// event
												}
											},
											renderTo:id,
										});
										return value;
									},
									ui:'multiSelectWithCheckbox',
									hideHeaders: true,
									columns: [
										{
											text:'',
											dataIndex:'displayField',
											width:152,
										},
										{
											dataIndex:'readWrite',
											width:20,
											padding:'0 0 0 0',
											margin:0,
											renderer:function(value,metaData,record,rowIndex,colIndex,store,view,returnval){
												var me = this,
												dataIndex = view.ownerCt.columns[colIndex].dataIndex;
												metaData['tdAttr'] = 'id="'+dataIndex+rowIndex+'"';
												var id = ''+dataIndex+rowIndex+'';
												Ext.defer(function(){me.createGridButton(value,id,store,view,rowIndex,dataIndex)},50);
												return Ext.String.format('<div id="{0}"></div>', id);
											}
										},
									],
									id:'customCheckComp',
									name:'customCheckComp',
									height:90,
									width:200,
									padding:0,
									margin:0,
									selModel: Ext.create('Ext.selection.CheckboxModel',{
										checkOnly:true,
										headerWidth:18
									}),
									border:true,
									listeners : {
										'viewready' : function(thisGrid)
										{
											if (!Ext.isEmpty(selectedUsrs) && (selectedUsrs != null && selectedUsrs != "undefined")) {
												for(var usrs in selectedUsrs)
												{
													var record1 = thisGrid.getStore().findRecord("valueField", selectedUsrs[usrs]);
													thisGrid.getSelectionModel().select(record1,true);
												}
											}
										}
									}
								});
								sharedUsersObj.add(sharingCompArr);
								if (sharedPref != null && sharedPref == 'Private') {
									privateId.pressed=true;
									PublicId.pressed=false;
									shareId.pressed=false;
								}
								else if (sharedPref != null && sharedPref == 'Public') {						
									privateId.pressed=false;
									PublicId.pressed=true;
									shareId.pressed=false;
								}
								else if (sharedPref != null && sharedPref == 'Share') {
									privateId.pressed=false;
									PublicId.pressed=false;
									shareId.pressed=true;
									Ext.apply(sharedUsersObj,{
										style:{'display':'block'}
									});
									sharedUsersObj.show();
								}
							/*	Ext.apply(Ext.getCmp('sharedUsersObj2'),{
									style:{'visibility':'visible'}
								});*/
								/*var sharedPref = jsonData['userSharingDetails']['sharePref'];
								if (sharedPref != null && sharedPref == 'Private') {
									Ext.getCmp('privateId2').pressed=true;
									Ext.getCmp('PublicId2').pressed=false;
									Ext.getCmp('shareId2').pressed=false;
								}
								else if (sharedPref != null && sharedPref == 'Public') {
									Ext.getCmp('privateId2').pressed=false;
									Ext.getCmp('PublicId2').pressed=true;
									Ext.getCmp('shareId2').pressed=false;
								}
								else if (sharedPref != null && sharedPref == 'Share') {
									Ext.getCmp('privateId2').pressed=false;
									Ext.getCmp('PublicId2').pressed=false;
									Ext.getCmp('shareId2').pressed=true;

									var sharedUsersObj= Ext.getCmp('sharedUsersObj2');
									var selectedUsrs = jsonData['userSharingDetails']['sharedUsers'];
									sharedUsersObj.removeAll();
									var sharingCompArr=new Array();
												sharingCompArr.push({
													xtype:'container',
													html: '<div class="font_bold12 padding4">Share to - Available Users</div>',
												},{
													xtype:'gridpanel',
													store : new Ext.data.Store({
														fields : ['displayField','valueField'],
														data : jsonData['validUsers']
													}),
													ui:'multiSelectWithCheckbox',
													hideHeaders: true,
													columns: [
														{
															text:'',
															dataIndex:'displayField',
															width:152,
														}
													],
													id:'checkComp',
													name:'checkComp',
													height:90,
													width:200,
													padding:0,
													margin:0,
													selModel: Ext.create('Ext.selection.CheckboxModel',{
													checkOnly:true
													}),
													border:true,
													listeners : {
														'viewready' : function(thisGrid)
														{
															if (!Ext.isEmpty(selectedUsrs) && (selectedUsrs != null && selectedUsrs != "undefined")) {
																for(var usrs in selectedUsrs)
																{
																	var record1 = thisGrid.getStore().findRecord("valueField", selectedUsrs[usrs]);
																	thisGrid.getSelectionModel().select(record1,true);
																}
															}
														}
													}
										});
												sharedUsersObj.add(sharingCompArr);
											Ext.apply(Ext.getCmp('sharedUsersObj2'),{
												style:{'visibility':'visible'}
											});
														//Ext.getCmp('checkComp').selectedUsrs = selectedUsrs;
								}*/
								var createTemplateBtn = Ext.getCmp('CreateTemplateBtn');
								createTemplateBtn.setText(jsonData['screenLabels']['monitor.common.Update']);
								templateconfigurationObj.templateAction = 'Modify';
								templateconfigurationObj.profileName = profileName;
							}
							templateconfigurationObj.show();
							templateconfigurationObj.resumeEvents();
							templateconfigurationObj.doComponentLayout();
							jsonData=null;
							delete jsonData;
						}
				},
				failure : function(response, opts) {
					console.log("EXCEPTION IN LOADING");
				}

			});
	},
	onLayoutSelect : function(btn)
	{
			var layOut = btn.value;
			tempSelectedLayout = layOut;
			if(layOut!=null)
			{
				if(layOut == defaultSelectedLayout)
				{
					Ext.getCmp('templateNumField').setValue(widgetsforTemplate);
					Ext.getCmp('templateNumField').hiddenMinVal = minwidgets;
					//Ext.getCmp('templateNumField').setMinValue(minwidgets);
				}
				else
				{
					var templateLayoutObj=Ext.getCmp('templateLayoutObj');
					var prof = '';
					if(templateLayoutObj!=null && !Ext.isEmpty(templateLayoutObj))
					{
						var profName = templateLayoutObj.profileName;
						if(profName!=null || profName!='undefined')
						{
							prof = profName;
						}
					}
					var paramsForRqst = 'action=getDefaultWidgetCount&selectedlayOut='+encodeURIComponent(layOut)+'&profileName='+prof;
						Ext.Ajax.request({
						url : '/final/servlet/com.eg.EgTemplateBuilderController',
						method : 'POST',
						params : paramsForRqst + '&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
						scope : this,
						async : true,
						success : function(response) {
							var jsonText = response.responseText;
							if (jsonText != null && jsonText != '') {
								var jsonData = Ext.decode(jsonText);
								var defWidgetsCount = jsonData['defaultWidgetsCount']['defaultWidgetsForLayout'];
								var minwidgetsforlayout = jsonData['defaultWidgetsCount']['minimumWidgetsForLayout'];
								var restrictedWidgetForLayout = jsonData['defaultWidgetsCount']['restrictedWidgetsForLayout'];
								if(defWidgetsCount!=null && minwidgetsforlayout!=null && restrictedWidgetForLayout!=null)
								{
									Ext.getCmp('templateNumField').setValue(defWidgetsCount);
									Ext.getCmp('templateNumField').hiddenMinVal = minwidgetsforlayout;
									Ext.getCmp('templateNumField').setMinValue(restrictedWidgetForLayout);
								}
							
								isLayoutChanged=true;

								jsonData=null;
								delete jsonData;
							}
							jsonText=null;
							delete jsonText;
						},
						failure : function(response, opts) {
								console.log("EXCEPTION IN LOADING");
							}
					});
				}
			}
		},
	onGraphTypeSelect : function(btn)
	{
		var mec = this;
		var isServiceHealthConfigured = false;
		var isDDConfigured = false;
		var graphName =  btn.value;
		var selectedBtnGrp = btn.btnGrp;
		tempSelectedGraph = graphName;
		if(tempSelectedGraph!=null && tempSelectedGraph!='')
		{
			var gridObj = Ext.getCmp('configTableGrid');
			if(selectedBtnGrp != availBtnGrp)
			{
				gridObj.getStore().removeAll();
			}
			availBtnGrp = selectedBtnGrp;
			var userDefinedWidgetWindowObj = this.getUserDefinedWidgetWindow();
			userDefinedWidgetWindowObj.chartType=tempSelectedGraph;
			var blockIdOfGraph = userDefinedWidgetWindowObj.blockId;
			var internalid = userDefinedWidgetWindowObj.internalId;
			var profileName = Ext.getCmp('templateLayoutObj').profileName;
			var configForm = userDefinedWidgetWindowObj.getComponent('configForm').getForm();
			var testCombo = configForm.findField('testCombo');
			testCombo.suspendEvents(true);
			testCombo.getStore().removeAt(0);
			testCombo.getStore().insert(0, {
				displayField : screenLabelsObj['Please Select a Test'],
				valueField : '-1'
				});
			if(tempSelectedGraph != 'DDTable')
			{
				testCombo.setValue('-1');
			}
			testCombo.resumeEvents();
			var mesLbl = Ext.getCmp('measureLbl');
			if(tempSelectedGraph == 'TopNGaugeChart' || tempSelectedGraph == 'TopNDigitalChart' || tempSelectedGraph == 'DDTable' || tempSelectedGraph == 'TopN')
			{
				if(tempSelectedGraph == 'DDTable')
				{
					var summarizeDDColumnComboObj = Ext.getCmp('summarizeDDColumnCombo');
					if(!Ext.isEmpty(summarizeDDColumnComboObj))
					{
						summarizeDDColumnComboObj.hide();
					}
					var graphicalOptsObj = Ext.getCmp('graphicalTypeId');
					if(!Ext.isEmpty(graphicalOptsObj))
					{
						graphicalOptsObj.show();
					}
									
					Ext.getCmp('addtoGridBtn').hide();
					configForm.findField('testCombo').show();
					Ext.getCmp('selectionDetailsLbl').hide();
					Ext.getCmp('oneMetricTxt').hide();
				}
				else
				{
					var summarizeDDColumnComboObj = Ext.getCmp('summarizeDDColumnCombo');
					if(!Ext.isEmpty(summarizeDDColumnComboObj))
					{
						summarizeDDColumnComboObj.hide();
					}
					var graphicalOptsObj = Ext.getCmp('graphicalTypeId');
					if(!Ext.isEmpty(graphicalOptsObj))
					{
						graphicalOptsObj.hide();
					}
					
					Ext.getCmp('graphicalTypeId').hide();
					if(!mesLbl.isVisible())
					{
						Ext.getCmp('addtoGridBtn').hide();
					}
					else
					{
						Ext.getCmp('addtoGridBtn').show();
					}
					configForm.findField('testCombo').show();
					Ext.getCmp('selectionDetailsLbl').show();
					Ext.getCmp('oneMetricTxt').show();
				}				

				var categoryOptsObj = configForm.findField('categoryOpts');
				var healthTestObj = configForm.findField('healthCenterTestScrollCombo');
				var compContinerObj = configForm.findField('healthCenterCompContiner');
				compContinerObj = Ext.getCmp('healthCenterCompContiner');
				var healthCenterCompTypeComboObj = configForm.findField('healthCenterCompTypeCombo');

				if(!Ext.isEmpty(categoryOptsObj))
				{
					categoryOptsObj.hide();
				}
				if(!Ext.isEmpty(healthTestObj))
				{
					healthTestObj.hide();
				}
				if(!Ext.isEmpty(compContinerObj))
				{
					compContinerObj.hide();
				}
				if(!Ext.isEmpty(healthCenterCompTypeComboObj))
				{
					healthCenterCompTypeComboObj.hide();
				}			
				
				//gridObj.height = 120;
				configForm.findField('measurelist').hide();
				configForm.findField('metricsSearchTextBox').hide();
				var measureCombo = configForm.findField('measureListCombo');
				measureCombo.suspendEvents(true);
				var measureComboStore = measureCombo.getStore();
				measureComboStore.removeAll();
				measureComboStore.insert(0, {
					displayField : screenLabelsObj['Please Choose Measure'],
					valueField : '-1'
					});
				measureCombo.setValue('-1');
				measureComboStore.resumeEvents();
				if(mesLbl.isVisible())
				{
					measureCombo.show();
				}
			}
			else if(tempSelectedGraph != null && tempSelectedGraph =='servicehealth')
			{
				var summarizeDDColumnComboObj = Ext.getCmp('summarizeDDColumnCombo');
				if(!Ext.isEmpty(summarizeDDColumnComboObj))
				{
					summarizeDDColumnComboObj.hide();
				}
				var graphicalOptsObj = Ext.getCmp('graphicalTypeId');
				if(!Ext.isEmpty(graphicalOptsObj))
				{
					graphicalOptsObj.hide();
				}
			
				var healthCenterComponentComboObj = Ext.getCmp('healthCenterComponentCombo');
				if(!Ext.isEmpty(healthCenterComponentComboObj))
				{
					healthCenterComponentComboObj.suspendEvents(true);
					healthCenterComponentComboObj.getStore().removeAll();
					healthCenterComponentComboObj.getStore().insert(0,{
						displayField:notApplicable,
						valueField: '-1'
					});
					healthCenterComponentComboObj.resumeEvents();
					healthCenterComponentComboObj.setValue('-1');
					
				
				}
				var healthCenterComponentComboLblObj = Ext.getCmp('healthCenterComponentComboLbl');
				Ext.getCmp('selectionDetailsLbl').hide();
				Ext.getCmp('oneMetricTxt').hide();
				configForm.findField('measurelist').hide();
				configForm.findField('metricsSearchTextBox').hide();
				configForm.findField('measureListCombo').hide();
				configForm.findField('testCombo').hide();
				var measureLblObj = configForm.findField('measureLbl');
				measureLblObj = Ext.getCmp('measureLbl');
				healthCenterComponentComboLblObj.setText('Zones');
				if(!Ext.isEmpty(measureLblObj))
				{
					measureLblObj.hide();
				}
				Ext.getCmp('addtoGridBtn').hide();
				var categoryOptsObj = configForm.findField('categoryOpts');
				var healthTestObj = configForm.findField('healthCenterTestScrollCombo');
				var compContinerObj = configForm.findField('healthCenterCompContiner');
				compContinerObj = Ext.getCmp('healthCenterCompContiner');
				
				if(!Ext.isEmpty(categoryOptsObj))
				{
					categoryOptsObj.show();
				}
				if(!Ext.isEmpty(healthTestObj))
				{
					healthTestObj.show();
				}
			}
			else
			{
				var summarizeDDColumnComboObj = Ext.getCmp('summarizeDDColumnCombo');
				if(!Ext.isEmpty(summarizeDDColumnComboObj))
				{
					summarizeDDColumnComboObj.hide();
				}
				var graphicalOptsObj = Ext.getCmp('graphicalTypeId');
				if(!Ext.isEmpty(graphicalOptsObj))
				{
					graphicalOptsObj.hide();
				}
	
				var mesLbl = Ext.getCmp('measureLbl');
				if(!mesLbl.isVisible())
				{
					Ext.getCmp('addtoGridBtn').hide();
				}
				else
				{
					Ext.getCmp('addtoGridBtn').show();
				}
				configForm.findField('testCombo').show();
				Ext.getCmp('selectionDetailsLbl').show();
				var categoryOptsObj = configForm.findField('categoryOpts');
				var healthTestObj = configForm.findField('healthCenterTestScrollCombo');
				var compContinerObj = configForm.findField('healthCenterCompContiner');
				compContinerObj = Ext.getCmp('healthCenterCompContiner');
				var healthCenterCompTypeComboObj = configForm.findField('healthCenterCompTypeCombo');

				if(!Ext.isEmpty(categoryOptsObj))
				{
					categoryOptsObj.hide();
				}
				if(!Ext.isEmpty(healthTestObj))
				{
					healthTestObj.hide();
				}
				if(!Ext.isEmpty(compContinerObj))
				{
					compContinerObj.hide();
				}
				if(!Ext.isEmpty(healthCenterCompTypeComboObj))
				{
					healthCenterCompTypeComboObj.hide();
				}
				
				Ext.getCmp('oneMetricTxt').hide();
				//gridObj.height = 180;
				configForm.findField('measureListCombo').hide();
				var measureMultiCombo = configForm.findField('measurelist');
				measureMultiCombo.suspendEvents(true);
				var measureMultiComboStore = measureMultiCombo.getStore();
				measureMultiComboStore.removeAll();
				measureMultiComboStore.insert(0, {
					displayField : notApplicable,
					valueField : '-1'
				});
				measureMultiCombo.setValue('-1');
				measureMultiCombo.resumeEvents();
				if(mesLbl.isVisible())
				{
					measureMultiCombo.show();
					configForm.findField('metricsSearchTextBox').show();
				}

			}
			if(tempSelectedGraph!=null && tempSelectedGraph == 'DDTable')
			{
				var selectedGraph = '';
				var graphicalOptsObj = Ext.getCmp('graphicalTypeId');
				if(!Ext.isEmpty(graphicalOptsObj))
				{
					selectedGraph = graphicalOptsObj.getValue();
				}
				if(Ext.getCmp('measureListCombo').isVisible())
				{
					var summarizeDDColumnComboObj = Ext.getCmp('summarizeDDColumnCombo');
					if(!Ext.isEmpty(summarizeDDColumnComboObj))
					{
						if(selectedGraph != null && selectedGraph != 'Table')
						{
							summarizeDDColumnComboObj.show();
						}
					}
					Ext.getCmp('ddcolumnsLbl').show();
					Ext.getCmp('ddcolumnsMultiSelect').show();
				}
			}
			else
			{
				var summarizeDDColumnComboObj = Ext.getCmp('summarizeDDColumnCombo');
				if(!Ext.isEmpty(summarizeDDColumnComboObj))
				{
					summarizeDDColumnComboObj.hide();
				}
				Ext.getCmp('ddcolumnsLbl').hide();
				Ext.getCmp('ddcolumnsMultiSelect').hide();
			}
		
			var confguredWidgetName =userDefinedWidgetWindowObj.confguredWidgetName;
			var configuredDataValue =userDefinedWidgetWindowObj.configuredDataValue;
			var configuredGridData = configuredDataValue['gridData'];
			if((tempSelectedGraph==confguredWidgetName) && (configuredGridData!=null && !Ext.isEmpty(configuredGridData)))
			{
				var configTableGrid = Ext.getCmp('configTableGrid');
				configTableGrid.suspendEvents(true);
				var gridStore = configTableGrid.getStore();
				gridStore.removeAll();

				for(var index = 1; index < configTableGrid.columns.length; index++)
				{
					if(configTableGrid.columns[index].text == 'DD Columns' || configTableGrid.columns[index].text == 'Chart Type')
					{
						configTableGrid.headerCt.remove(index);
						configTableGrid.getView().refresh();
						break;
					}
				}

				for(var index = 1; index < configTableGrid.columns.length; index++)
				{
					if(configTableGrid.columns[index].text == 'Component Type')
					{
						configTableGrid.headerCt.remove(index);
						configTableGrid.getView().refresh();
						break;
					}
				}

				for(var index = 1; index < configTableGrid.columns.length; index++)
				{
					if(configTableGrid.columns[index].text == 'Descriptor')
					{
						configTableGrid.headerCt.remove(index);
						configTableGrid.getView().refresh();
						break;
					}
				}

				var containsMeasure = false;
				for(var indexvar = 1; indexvar < gridObj.columns.length; indexvar++)
				{
					if(gridObj.columns[indexvar].text == 'Measure' )
					{
						containsMeasure = true;
					}
				}
				if(!containsMeasure)
				{

					var column3 = Ext.create('Ext.grid.column.Column', {
						text: screenLabelsObj['Measure'],
						dataIndex:'measure',
						cls: 'x-form-item-label',
						flex:.6,
						editor: {
								allowBlank: false
								},
						renderer: function(value, metaData) {
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
								return value;
							}
					});
					
					gridObj.headerCt.insert(2,column3);
				}	
				
				var gridData=configuredGridData;
				var dispType=confguredWidgetName;
				if (gridData!=null && !Ext.isEmpty(gridData)) {
					if(dispType!=null && dispType == 'CombinationChart')
					{
						configTableGrid.hideChartType = false;
						var column = Ext.create('Ext.grid.column.Column', {
							text: screenLabelsObj['Chart Type'],
							dataIndex: 'chartType',
							field: {
							xtype: 'scrollcombo',
							editable : false,
							selectOnTab: true,
							displayField: 'displayField',
							valueField: 'valueField',
							store : Ext.create('Ext.data.Store', {
										fields: ['displayField', 'valueField'],
								data: [{'displayField' : screenLabelsObj['line'], 'valueField' : 'line'},{'displayField' : screenLabelsObj['column'],'valueField' : 'column'},{'displayField' : screenLabelsObj['Area'],'valueField' : 'Area'}]
							}),
							lazyRender: true
							}
						});
						configTableGrid.headerCt.insert(
							configTableGrid.columns.length-1, // that's index column
							column);

						configTableGrid.getView().refresh();
					}
					if(dispType!=null && dispType == 'DDTable')
					{
						var column = Ext.create('Ext.grid.column.Column', {
							text: screenLabelsObj['DD Columns'],
							dataIndex: 'ddval',
							renderer: function(value, metaData) {
							metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
							return value;
							}
						});
						configTableGrid.headerCt.insert(
							configTableGrid.columns.length-1, // that's index column
							column);

						configTableGrid.getView().refresh();
					}

					if(dispType!=null && dispType == 'servicehealth')
					{
						var healthTestObj = configForm.findField('healthCenterTestScrollCombo');
						healthTestObj.hide();
						isServiceHealthConfigured = true;
						var containsComponentType = false;
						var containsDescriptors = false;
						for(var indexvar = 1; indexvar < gridObj.columns.length; indexvar++)
						{
							if(gridObj.columns[indexvar].text == 'Component Type')
							{
								containsComponentType = true;
							}
							if(gridObj.columns[indexvar].text == 'Descriptor' )
							{
								containsDescriptors = true;
							}
						}
			
						if(!containsComponentType)
						{
							var column1 = Ext.create('Ext.grid.column.Column', {
								text: 'Component Type',
								dataIndex:'componentType',
								flex:.4,
								hidden:false,
								renderer: function(value, metaData) {
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									return value;
								}
							});

							gridObj.headerCt.insert(
								1, 
								column1);
						}

						for(var indexvar = 1; indexvar < gridObj.columns.length; indexvar++)
						{
							if(gridObj.columns[indexvar].text == 'Measure')
							{
								gridObj.headerCt.remove(indexvar);
								gridObj.getView().refresh();
								break;
							}
						}

						if(!containsDescriptors)
						{
							var column3 = Ext.create('Ext.grid.column.Column', {
								text: 'Descriptor',
								dataIndex:'Descriptor',
								flex:.4,
								hidden:false,
								renderer: function(value, metaData) {
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									return value;
								}
							});

							gridObj.headerCt.insert(
							3, 
							column3);
						}	
						gridObj.getView().refresh();

					}
					gridStore.add(gridData);
					configTableGrid.show();
					configTableGrid.resumeEvents();
					configTableGrid.doComponentLayout();
				} else {
					for(var index = 1; index < configTableGrid.columns.length; index++)
					{
						if(configTableGrid.columns[index].text == 'DD Columns' || configTableGrid.columns[index].text == 'Chart Type' )
						{
							configTableGrid.headerCt.remove(index);
							configTableGrid.getView().refresh();
							break;
						}
					}
					for(var index = 1; index < configTableGrid.columns.length; index++)
					{
						if(configTableGrid.columns[index].text == 'Component Type')
						{
							configTableGrid.headerCt.remove(index);
							configTableGrid.getView().refresh();
							break;
						}
					}
					for(var index = 1; index < configTableGrid.columns.length; index++)
					{
						if(configTableGrid.columns[index].text == 'Descriptor')
						{
							configTableGrid.headerCt.remove(index);
							configTableGrid.getView().refresh();
							break;
						}
					}
					Ext.getCmp('configTableGrid').show();
				}
			}
			else if(tempSelectedGraph==confguredWidgetName) 
			{
				if(tempSelectedGraph == 'DDTable')
				{
					Ext.getCmp('configTableGrid').hide();
					isDDConfigured = true;
					var selectedChartType = '';
					var graphicalOptsObj = Ext.getCmp('graphicalTypeId');
					if(!Ext.isEmpty(graphicalOptsObj) && configuredDataValue.hasOwnProperty('chartDataCombo') && configuredDataValue.hasOwnProperty('selectedChartType'))
					{
						selectedChartType = configuredDataValue['selectedChartType'];
						graphicalOptsObj.suspendEvents(true);
						graphicalOptsObj.getStore().removeAll();
						graphicalOptsObj.getStore().loadRawData(configuredDataValue['chartDataCombo']);
						graphicalOptsObj.setValue(configuredDataValue['selectedChartType']);
						graphicalOptsObj.resumeEvents();
						graphicalOptsObj.show();
					}
					//var testCombo = configForm.findField('testCombo');
					testCombo.isModification = true;
					
				}
				else 
				{				
					var summarizeDDColumnComboObj = Ext.getCmp('summarizeDDColumnCombo');
					if(!Ext.isEmpty(summarizeDDColumnComboObj))
					{
						summarizeDDColumnComboObj.hide();
					}
					var graphicalOptsObj = Ext.getCmp('graphicalTypeId');
					if(!Ext.isEmpty(graphicalOptsObj))
					{
						graphicalOptsObj.hide();
					}
					
					Ext.getCmp('configTableGrid').hide();
					isServiceHealthConfigured = true;

					var categoryOptsObj = configForm.findField('categoryOpts');
					var selectedCategoryValue = '-1';

					if(configuredDataValue.hasOwnProperty('categoryCombo') && configuredDataValue.hasOwnProperty('selectedCategory'))
					{
						categoryOptsObj.suspendEvents(true);
						categoryOptsObj.getStore().removeAll();
						categoryOptsObj.getStore().loadRawData(configuredDataValue['categoryCombo']);
						categoryOptsObj.setValue(configuredDataValue['selectedCategory']);
						categoryOptsObj.resumeEvents();
						selectedCategoryValue = configuredDataValue['selectedCategory'];
					}
					else
					{
						if(configuredDataValue.hasOwnProperty('categoryCombo'))
						{
							categoryOptsObj.suspendEvents(true);
							categoryOptsObj.getStore().removeAll();
							categoryOptsObj.getStore().loadRawData(configuredDataValue['categoryCombo']);
							categoryOptsObj.setValue('-1');
							categoryOptsObj.resumeEvents();
						}
					}			
				
					var healthTestObj = configForm.findField('healthCenterTestScrollCombo');
					healthTestObj.hide();

					var compContinerObj =  Ext.getCmp('healthCenterCompContiner');
					var healthCenterComponentComboObj =  Ext.getCmp('healthCenterComponentCombo');
					var healthCenterCompTypeComboObj =  Ext.getCmp('healthCenterCompTypeCombo');

					if(selectedCategoryValue != null && (selectedCategoryValue == 'Zone' || selectedCategoryValue == 'Segment' || selectedCategoryValue == 'Service'))
					{
						compContinerObj.show();
						healthCenterCompTypeComboObj.hide();
						if(!Ext.isEmpty(healthCenterComponentComboObj))
						{
							if(configuredDataValue.hasOwnProperty('availableOptions') && configuredDataValue.hasOwnProperty('selectedFields'))
							{
								var availableOptions = configuredDataValue['availableOptions'];
								if(availableOptions.hasOwnProperty('optionsForType'))
								{
									healthCenterComponentComboObj.suspendEvents(true);
									healthCenterComponentComboObj.getStore().removeAll();
									healthCenterComponentComboObj.getStore().loadRawData(availableOptions['optionsForType']);
									healthCenterComponentComboObj.setValue(configuredDataValue['selectedFields']);
									healthCenterComponentComboObj.resumeEvents();
									//healthCenterComponentComboObj.show();
								}
							}
						}
					}
					else if(selectedCategoryValue != null && selectedCategoryValue == 'Components')
					{
						compContinerObj.hide();
						//healthCenterComponentComboObj.hide();
						healthCenterCompTypeComboObj.show();
						if(!Ext.isEmpty(healthCenterCompTypeComboObj))
						{
							if(configuredDataValue.hasOwnProperty('availableOptions') && configuredDataValue.hasOwnProperty('selectedFields'))
							{
								var availableOptions = configuredDataValue['availableOptions'];
								if(availableOptions.hasOwnProperty('availCompTypes'))
								{
									healthCenterCompTypeComboObj.suspendEvents(true);
									healthCenterCompTypeComboObj.getStore().removeAll();
									healthCenterCompTypeComboObj.getStore().loadRawData(availableOptions['availCompTypes']);
									if(selectedCategoryValue != 'Descriptors')
									{
										healthCenterCompTypeComboObj.getStore().insert(1,{
											displayField:'All types',
											valueField: 'allServers'
										});
									}
									healthCenterCompTypeComboObj.setValue(configuredDataValue['selectedFields']);
									healthCenterCompTypeComboObj.resumeEvents();
									healthCenterCompTypeComboObj.show();
								}
							}
						}
					}
					else if(selectedCategoryValue != null && selectedCategoryValue == 'vms|desktop|users')
					{
						Ext.getCmp('selectionDetailsLbl').hide();
						if(!Ext.isEmpty(healthTestObj))
						{
							healthTestObj.hide();
						}
						if(!Ext.isEmpty(compContinerObj))
						{
							compContinerObj.show();
						}

						if(configuredDataValue.hasOwnProperty('availableOptions') && configuredDataValue.hasOwnProperty('selectedFields'))
						{
							var availableOptions = configuredDataValue['availableOptions'];
							if(availableOptions.hasOwnProperty('availCompTypes'))
							{
								if(!Ext.isEmpty(healthCenterCompTypeComboObj))
								{
									healthCenterCompTypeComboObj.suspendEvents(true);
									healthCenterCompTypeComboObj.getStore().removeAll();
									healthCenterCompTypeComboObj.getStore().loadRawData(availableOptions['availCompTypes']);
									
									/*healthCenterCompTypeComboObj.getStore().insert(1,{
										displayField:'All types',
										valueField: 'allServers'
									});*/
									
									var isContainsValue = false;

									for(var k=0;k<availableOptions['availCompTypes'].length;k++)
									{
										var opt = availableOptions['availCompTypes'][k];
										var valueField = opt.valueField;
										
										if(valueField==configuredDataValue['selectedFields'])
										{
											isContainsValue = true;
											break;
										}
									}
									if(configuredDataValue['selectedFields'] != null &&configuredDataValue['selectedFields'] == 'allServers')
									{
										isContainsValue = true;
									}						

									if(isContainsValue)
									{
										healthCenterCompTypeComboObj.setValue(configuredDataValue['selectedFields']);
									}
									else
									{
										healthCenterCompTypeComboObj.setValue('-1');
									}									
									healthCenterCompTypeComboObj.resumeEvents();
									healthCenterCompTypeComboObj.show();
								}
							}
						}

						if(configuredDataValue.hasOwnProperty('availableOptions') && configuredDataValue.hasOwnProperty('selectedFields'))
						{
							if(!Ext.isEmpty(healthCenterComponentComboObj))
							{
								if(configuredDataValue.hasOwnProperty('availableVmOptions') && configuredDataValue.hasOwnProperty('selectedvms'))
								{
									var availableOptions = configuredDataValue['availableVmOptions'];
									if(availableOptions.hasOwnProperty('descriptorsList'))
									{
										healthCenterComponentComboObj.suspendEvents(true);
										healthCenterComponentComboObj.getStore().removeAll();
										healthCenterComponentComboObj.getStore().loadRawData(availableOptions['descriptorsList']);

										healthCenterComponentComboObj.getStore().insert(0,{
											displayField : allVms,
											valueField : 'allVms'
										});

										healthCenterComponentComboObj.setValue(configuredDataValue['selectedvms']);
										healthCenterComponentComboObj.resumeEvents();
									}
								}
							}
						}
					}
				}
			}
			else
			{
				var graphicalOptsObj = Ext.getCmp('graphicalTypeId');
				if(!Ext.isEmpty(graphicalOptsObj))
				{
					graphicalOptsObj.hide();
				}
				
				var gridStore = Ext.getCmp('configTableGrid').getStore();
				gridStore.removeAll();
				
				if(tempSelectedGraph != null && (tempSelectedGraph =='servicehealth' || tempSelectedGraph == 'DDTable'))
				{
					Ext.getCmp('configTableGrid').hide();
				}
				else
				{
					Ext.getCmp('configTableGrid').show();
				}
				
				if(tempSelectedGraph == 'CombinationChart')
				{
					var chartAdded = false;
					for(var index = 1; index < gridObj.columns.length; index++)
					{
						if(gridObj.columns[index].text == 'Chart Type')
						{
							chartAdded = true;
							break;
						}
					}
					if(!chartAdded)
					{
						for(var indexvar = 1; indexvar < gridObj.columns.length; indexvar++)
						{
							if(gridObj.columns[indexvar].text == 'DD Columns')
							{

								gridObj.headerCt.remove(indexvar);
								gridObj.getView().refresh();
								break;
							}
						}
						var column = Ext.create('Ext.grid.column.Column', {
								text: screenLabelsObj['Chart Type'],
								dataIndex: 'chartType',
								field: {
									xtype: 'scrollcombo',
									editable : false,
									selectOnTab: true,
									displayField: 'displayField',
									valueField: 'valueField',
									store : Ext.create('Ext.data.Store', {
									fields: ['displayField', 'valueField'],
									data: [{'displayField' : screenLabelsObj['line'], 'valueField' : 'line'},{'displayField' : screenLabelsObj['column'],'valueField' : 'column'},{'displayField' : screenLabelsObj['Area'],'valueField' : 'Area'}]
									}),
										lazyRender: true
										}
									});
									gridObj.headerCt.insert(
										3, // that's index column
										column);
									gridObj.getView().refresh();
					}
				}
				else
				{
					for(var index = 1; index < gridObj.columns.length; index++)
					{
						if(gridObj.columns[index].text == 'Chart Type')
						{
							gridObj.headerCt.remove(index);
							gridObj.getView().refresh();
							break;
						}
					}
				}
				if(tempSelectedGraph == 'DDTable')
				{
					var ddcolumnAdded = false;
					for(var indexvar = 1; indexvar < gridObj.columns.length; indexvar++)
					{
						if(gridObj.columns[indexvar].text == 'DD Columns')
						{
							ddcolumnAdded = true;
							break;
						}
					}
					if(!ddcolumnAdded)
					{
						for(var index = 1; index < gridObj.columns.length; index++)
						{
							if(gridObj.columns[index].text == 'Chart Type')
							{
								gridObj.headerCt.remove(index);
								gridObj.getView().refresh();
								break;
							}
						}
						var column = Ext.create('Ext.grid.column.Column', {
										text: screenLabelsObj['DD Columns'],
										dataIndex: 'ddval',
										renderer: function(value, metaData) {
										metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
										return value;
										}
									});
									gridObj.headerCt.insert(
										3, // that's index column
										column);
									gridObj.getView().refresh();
					}
				}
				else
				{
					for(var indexvar = 1; indexvar < gridObj.columns.length; indexvar++)
					{
						if(gridObj.columns[indexvar].text == 'DD Columns')
						{

							gridObj.headerCt.remove(indexvar);
							gridObj.getView().refresh();
							break;
						}
					}
				}

				if(tempSelectedGraph == 'servicehealth')
				{				
					
					var containsComponentType = false;
					var containsDescriptors = false;
					for(var indexvar = 1; indexvar < gridObj.columns.length; indexvar++)
					{
						if(gridObj.columns[indexvar].text == 'Component Type' )
						{
							containsComponentType = true;
						}
						if(gridObj.columns[indexvar].text == 'Descriptor' )
						{
							containsDescriptors = true;
						}
					}
				
					if(!containsComponentType)
					{
						var column1 = Ext.create('Ext.grid.column.Column', {
							text: 'Component Type',
							dataIndex:'componentType',
							flex:.4,
							hidden:false,
							renderer: function(value, metaData) {
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
								return value;
							}
						});

						gridObj.headerCt.insert(
							1, 
							column1);
					}

					for(var indexvar = 1; indexvar < gridObj.columns.length; indexvar++)
					{
						if(gridObj.columns[indexvar].text == 'Measure')
						{
							gridObj.headerCt.remove(indexvar);
							gridObj.getView().refresh();
							break;
						}
					}

					if(!containsDescriptors)
					{
						var column3 = Ext.create('Ext.grid.column.Column', {
							text: 'Descriptor',
							dataIndex:'Descriptor',
							flex:.4,
							hidden:false,
							renderer: function(value, metaData) {
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
								return value;
							}
						});

						gridObj.headerCt.insert(
						3, 
						column3);
					}	

					gridObj.getView().refresh();

				}
				else
				{
					for(var indexvar = 1; indexvar < gridObj.columns.length; indexvar++)
					{
						if(gridObj.columns[indexvar].text == 'Component Type')
						{
							gridObj.headerCt.remove(indexvar);
							gridObj.getView().refresh();
						}
					}

					for(var indexvar = 1; indexvar < gridObj.columns.length; indexvar++)
					{
						if(gridObj.columns[indexvar].text == 'Descriptor')
						{
							gridObj.headerCt.remove(indexvar);
							gridObj.getView().refresh();
						}
					}

					var containsMeasure = false;
					for(var indexvar = 1; indexvar < gridObj.columns.length; indexvar++)
					{
						if(gridObj.columns[indexvar].text == 'Measure' )
						{
							containsMeasure = true;
						}
					}
					if(!containsMeasure)
					{
						var column3 = Ext.create('Ext.grid.column.Column', {
							text: screenLabelsObj['Measure'],
							dataIndex:'measure',
							cls: 'x-form-item-label',
							flex:.6,
							editor: {
									allowBlank: false
									},
							renderer: function(value, metaData) {
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									return value;
								}
						});
						
						gridObj.headerCt.insert(2,column3);
					}	
					gridObj.getView().refresh();
				}
			}
			var paramsForReqst = 'action=getAdvanceControls&comesFrom=templateBuilder&selectedGraph='+encodeURIComponent(graphName)+'&blockId='+encodeURIComponent(blockIdOfGraph)+'&profileName='+encodeURIComponent(profileName)+'&from=graphSelect';
			if(internalid!=null && internalid!='')
			{
				paramsForReqst = paramsForReqst + '&internalId='+ encodeURIComponent(internalid);
			}

			Ext.Ajax.request({
						url : '/final/servlet/com.eg.EgTemplateBuilderController',
						method : 'POST',
						params :paramsForReqst + '&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
						scope : this,
						async : true,
						success : function(response) {
							var jsonTextForgraph = response.responseText;
							if (jsonTextForgraph != null && jsonTextForgraph != '') {
								var jsonDataForGraph = Ext.decode(jsonTextForgraph);
								if(!Ext.isEmpty(testCombo))
								{
									var isModification = testCombo.isModification;
									testCombo.suspendEvents(true);
									testCombo.getStore().removeAll();
									testCombo.getStore().loadRawData(jsonDataForGraph['tests']);
									if(!isModification)
									{
										testCombo.setValue('-1');
									}
									testCombo.isModification = false;
									testCombo.resumeEvents();
								}
								if(tempSelectedGraph != null && tempSelectedGraph =='servicehealth' && !isServiceHealthConfigured)
								{
									var categoryOptsObj = configForm.findField('categoryOpts');
									categoryOptsObj.suspendEvents(true);
									categoryOptsObj.getStore().removeAll();
									categoryOptsObj.getStore().loadRawData(jsonDataForGraph['categoryCombo']);
									categoryOptsObj.setValue('-1');
									categoryOptsObj.resumeEvents();

									var selectedValue = categoryOptsObj.getValue();
									var compContinerObj =  Ext.getCmp('healthCenterCompContiner');
									healthTestObj.hide();
								}

								if(tempSelectedGraph == 'DDTable')
								{
									if(configuredDataValue.hasOwnProperty('selectedTest') && configuredDataValue.hasOwnProperty('selectedMeasure')&& configuredDataValue.hasOwnProperty('selectedDDColumns'))
									{
										var testCombo = configForm.findField('testCombo');
										testCombo.isModification = true;
										testCombo.setValue(configuredDataValue['selectedTest']);

										var selectedTest = configuredDataValue['selectedTest'];
										var selectedMeasure = configuredDataValue['selectedMeasure'];
										var selectedDDColumns = configuredDataValue['selectedDDColumns'];
										var summarizedDDColumn = configuredDataValue['summarizedDDColumn'];
										tempBuilderApp.getController("Main").onManualTestComboChange(selectedChartType,testCombo,selectedTest,selectedMeasure,selectedDDColumns,summarizedDDColumn);
									}
								}

								if(tempSelectedGraph != null && tempSelectedGraph =='DDTable' && !isDDConfigured)
								{
									var graphicalOptsObj = Ext.getCmp('graphicalTypeId');
									if(!Ext.isEmpty(graphicalOptsObj))
									{
										graphicalOptsObj.suspendEvents(true);
										graphicalOptsObj.getStore().removeAll();
										graphicalOptsObj.getStore().loadRawData(jsonDataForGraph['chartDataCombo']);
										graphicalOptsObj.setValue('Table');
										graphicalOptsObj.resumeEvents();
										graphicalOptsObj.show();
									}
								}			

								if(!isServiceHealthConfigured && tempSelectedGraph != 'DDTable')
								{
									Ext.getCmp('configTableGrid').show();
								}

								Ext.getCmp('advancedOptionWidgetSlider').removeAll();
								/*if(tempSelectedGraph!=null && (tempSelectedGraph=='liveMeasuresBox' || tempSelectedGraph=='TopNGaugeChart' || tempSelectedGraph=='TopN' || tempSelectedGraph=='HeatMapChart' || tempSelectedGraph=='TopNDigitalChart' || tempSelectedGraph=='TopNTabularView' || tempSelectedGraph=='TopNBarChart' || tempSelectedGraph=='PieChart'))
								{
									Ext.getCmp('advancedOptionWidgetSlider').add(defaultAdvanced);
								} */

								if((tempSelectedGraph==confguredWidgetName))
								{
									var configuredData=configuredDataValue;
									var AggregateOptions = configuredData['AggregateOptions'];
									var configAggrOptions = AggregateOptions['AggrConfiguration'];
									var showAggoptions = configAggrOptions['ShowAggOptions'];
									var AdvancedControls = configuredData['advanceControlArr'];
									var excludeIncludeControls = configuredData['excludeIncludeOptions'];
									var removeAggr = false;
									if(dispType!=null && AdvancedControls!=null && (dispType == "PieChart" || dispType == "activityChart"))
									{
										for(var k=0;k<AdvancedControls.length;k++)
										{
											var opt = AdvancedControls[k];
											if(opt.id!=null && opt.id == "ChartDistribution")
											{
												if(opt.selectedValue!=null && opt.selectedValue == "Multiple")
												{
													removeAggr = true;
												}
											}
										}
									}
									if(showAggoptions!=null && showAggoptions == 'yes')
									{
										Ext.getCmp('advancedOptionWidgetSlider').add(defaultAggr);
									}
									var isAggregationEnabled ='no';
									var descActionComboOptions = AggregateOptions['descactionComboOptions'];
									if(descActionComboOptions!=null && !Ext.isEmpty(descActionComboOptions))
									{
											/*if(tempSelectedGraph!=null && (tempSelectedGraph=='liveMeasuresBox' || tempSelectedGraph=='TopNGaugeChart' || tempSelectedGraph=='TopN' || tempSelectedGraph=='HeatMapChart' || tempSelectedGraph=='TopNDigitalChart' || tempSelectedGraph=='TopNTabularView' || tempSelectedGraph=='TopNBarChart' || tempSelectedGraph=='PieChart'))
											{
												Ext.getCmp('actionOnDescCombo').getStore().loadRawData(descActionComboOptions);
											} */
									}
									if(showAggoptions!=null && showAggoptions == 'yes')
									{
										var aggCombooptions = AggregateOptions['AggrComboOptions'];
										if(aggCombooptions!=null)
										{
											Ext.getCmp('AggrfnCombo').getStore().loadRawData(aggCombooptions);
										}
									}
									if(configAggrOptions!=null && !Ext.isEmpty(configAggrOptions))
									{
										if(showAggoptions!=null && showAggoptions == 'yes')
										{
											isAggregationEnabled = configAggrOptions['isAaggregationEnabled'];
											var Aggfn = '';
											if(isAggregationEnabled!=null && isAggregationEnabled.indexOf("|")>0)
											{
												Aggfn = isAggregationEnabled.substring(isAggregationEnabled.indexOf("|")+1);
												isAggregationEnabled = isAggregationEnabled.substring(0,isAggregationEnabled.indexOf("|"));
											}
											if(isAggregationEnabled == 'Yes')
											{
												var showaggOptObj = Ext.getCmp('showAggOpt');
												showaggOptObj.suspendEvents(false);
												showaggOptObj.setValue({
													showAgg: 'yes'
												});
												Ext.getCmp('AggrfnCombo').show();
												/*var aggCombooptions = jsonData['AggregateOptions']['AggrComboOptions'];
												if(aggCombooptions!=null)
												{
													Ext.getCmp('AggrfnCombo').getStore().loadRawData(aggCombooptions);
												}*/
												Ext.getCmp('AggrfnCombo').setValue(Aggfn);
											}
											else
											{
												var showaggOptObj = Ext.getCmp('showAggOpt');
												showaggOptObj.suspendEvents(false);
												showaggOptObj.setValue({
													showAgg: 'no'
												});
											/*	if(tempSelectedGraph!=null && (tempSelectedGraph=='liveMeasuresBox' || tempSelectedGraph=='TopNGaugeChart' || tempSelectedGraph=='TopN' || tempSelectedGraph=='HeatMapChart' || tempSelectedGraph=='TopNDigitalChart' || tempSelectedGraph=='TopNTabularView' || tempSelectedGraph=='TopNBarChart' || tempSelectedGraph=='PieChart'))
												{
													Ext.getCmp('actionOnDescCombo').setValue('avg');
												}		*/
											}
										}
										var actionOnDesc = configAggrOptions['actiononDescriptor'];
										if(actionOnDesc!=null && actionOnDesc.indexOf("|")>0)
										{
											var descriptorVal= actionOnDesc.substring(actionOnDesc.indexOf("|")+1);
											 var descAction = actionOnDesc.substring(0,actionOnDesc.indexOf("|"));
											/**** Ext.getCmp('actionOnDescCombo').setValue(descAction);
											/*if(descriptorVal!=null && descriptorVal.indexOf("$!") > 0)
											{
												descriptorVal = descriptorVal.replace("$!",",");
											}*/
										/*	if(tempSelectedGraph!=null && (tempSelectedGraph=='liveMeasuresBox' || tempSelectedGraph=='TopNGaugeChart' || tempSelectedGraph=='TopN' || tempSelectedGraph=='HeatMapChart' || tempSelectedGraph=='TopNDigitalChart' || tempSelectedGraph=='TopNTabularView' || tempSelectedGraph=='TopNBarChart' || tempSelectedGraph=='PieChart'))
											{
												Ext.getCmp('actionOnDescCombo').setValue(descAction);
											}				  */
											if(descriptorVal!=null)
											{
												while(descriptorVal.indexOf("$!") > 0)
												{
													descriptorVal = descriptorVal.replace("$!",",");
												}
											}
										/*	if(tempSelectedGraph!=null && (tempSelectedGraph=='liveMeasuresBox' || tempSelectedGraph=='TopNGaugeChart' || tempSelectedGraph=='TopN' || tempSelectedGraph=='HeatMapChart' || tempSelectedGraph=='TopNDigitalChart' || tempSelectedGraph=='TopNTabularView' || tempSelectedGraph=='TopNBarChart' || tempSelectedGraph=='PieChart'))
											{
													Ext.getCmp('descriptorTextField').setValue(descriptorVal);
											}		*/
										}
										else
										{
										/*	if(tempSelectedGraph!=null && (tempSelectedGraph=='liveMeasuresBox' || tempSelectedGraph=='TopNGaugeChart' || tempSelectedGraph=='TopN' || tempSelectedGraph=='HeatMapChart' || tempSelectedGraph=='TopNDigitalChart' || tempSelectedGraph=='TopNTabularView' || tempSelectedGraph=='TopNBarChart' || tempSelectedGraph=='PieChart'))
											{
												Ext.getCmp('actionOnDescCombo').setValue('Include');
												Ext.getCmp('descriptorTextField').setValue('*');
											}	  */
										}
									}
									else
									{
										if(showAggoptions!=null && showAggoptions == 'yes')
										{
											var showaggOptObj = Ext.getCmp('showAggOpt');
											showaggOptObj.suspendEvents(false);
											showaggOptObj.setValue({
												showAgg: 'no'
											});
											Ext.getCmp('AggrfnCombo').setValue('avg');
										}
									/*	if(tempSelectedGraph!=null && (tempSelectedGraph=='liveMeasuresBox' || tempSelectedGraph=='TopNGaugeChart' || tempSelectedGraph=='TopN' || tempSelectedGraph=='HeatMapChart' || tempSelectedGraph=='TopNDigitalChart' || tempSelectedGraph=='TopNTabularView' || tempSelectedGraph=='TopNBarChart' || tempSelectedGraph=='PieChart'))
										{
											Ext.getCmp('actionOnDescCombo').setValue('Include');
											Ext.getCmp('descriptorTextField').setValue('*');
										}		 */
									}
									if(removeAggr)
									{
										Ext.getCmp('showAggOpt').hide();
										Ext.getCmp('AggrfnCombo').hide();
									}
									if(AdvancedControls!=null && !Ext.isEmpty(AdvancedControls))
									{
										Ext.getCmp('advancedOptionWidgetSlider').add(this.createFilters(AdvancedControls));
										if(removeAggr)
										{
											var legendDispOptsObj=Ext.getCmp('Legend Display');
											if(!Ext.isEmpty(legendDispOptsObj))
											{
												legendDispOptsObj.hide();
											}
										}
										Ext.getCmp('advancedOptionWidgetSlider').doLayout();
									}	

									if(tempSelectedGraph!=null && tempSelectedGraph!='servicehealth')
									{
										var defaultExcludeIncludeAdvanced  = tempBuilderApp.getController("Main").createExcludeIncludeSettingsLayout();	 		
										Ext.getCmp('advancedOptionWidgetSlider').add(defaultExcludeIncludeAdvanced);
				
										Ext.getCmp('advancedOptionWidgetSlider').add(tempBuilderApp.getController("Main").loadExcludeIncludeDefaultData(excludeIncludeControls,tempSelectedGraph));
									}
									
									if(tempSelectedGraph!=null && tempSelectedGraph=='DDTable')
									{
										var timelineObj=Ext.getCmp('Timeline');
										if(!Ext.isEmpty(timelineObj))
										{
											timelineObj.hide();
										}
									}
									
									Ext.getCmp('advancedOptionWidgetSlider').doLayout();

								}else
								{
									var configAggrOptions = jsonDataForGraph['AggregateOptions']['AggrConfiguration'];
									var showAggoptions = configAggrOptions['ShowAggOptions'];
									if(showAggoptions!=null && showAggoptions == 'yes' )
									{
										if(tempSelectedGraph == "BarChart"|| tempSelectedGraph == "TabularView" || tempSelectedGraph == "PieChart"|| tempSelectedGraph=='activityChart')
										{
											Ext.getCmp('advancedOptionWidgetSlider').add(defaultAggr);
										}

									}
									var isAggregationEnabled ='no';
									var descActionComboOptions = jsonDataForGraph['AggregateOptions']['descactionComboOptions'];
									if(descActionComboOptions!=null && !Ext.isEmpty(descActionComboOptions))
									{
										/*if(tempSelectedGraph!=null && (tempSelectedGraph=='liveMeasuresBox' || tempSelectedGraph=='TopNGaugeChart' || tempSelectedGraph=='TopN' || tempSelectedGraph=='HeatMapChart' || tempSelectedGraph=='TopNDigitalChart' || tempSelectedGraph=='TopNTabularView' || tempSelectedGraph=='TopNBarChart' || tempSelectedGraph=='PieChart'))
										{
											Ext.getCmp('actionOnDescCombo').getStore().loadRawData(descActionComboOptions);
										}	 */
									}
									if(showAggoptions!=null && showAggoptions == 'yes')
									{
										if(tempSelectedGraph == "BarChart"|| tempSelectedGraph == "TabularView" || tempSelectedGraph == "PieChart" || tempSelectedGraph=='activityChart')
										{
											var aggCombooptions = jsonDataForGraph['AggregateOptions']['AggrComboOptions'];
											if(aggCombooptions!=null)
											{
												Ext.getCmp('AggrfnCombo').getStore().loadRawData(aggCombooptions);
											}
										}
									}
									/*if(configAggrOptions!=null && !Ext.isEmpty(configAggrOptions))
									{
										if(showAggoptions!=null && showAggoptions == 'yes')
										{
											if(tempSelectedGraph == "BarChart"|| tempSelectedGraph == "TabularView" || tempSelectedGraph == "PieChart")
											{
												isAggregationEnabled = configAggrOptions['isAaggregationEnabled'];
												var Aggfn = '';
												if(isAggregationEnabled!=null && isAggregationEnabled.indexOf("|")>0)
												{
													 Aggfn = isAggregationEnabled.substring(isAggregationEnabled.indexOf("|")+1);
													isAggregationEnabled = isAggregationEnabled.substring(0,isAggregationEnabled.indexOf("|"));
												}
												if(isAggregationEnabled == 'Yes')
												{
													var showaggOptObj = Ext.getCmp('showAggOpt');
													showaggOptObj.suspendEvents(false);
													showaggOptObj.setValue({
													showAgg: 'yes'
													});
													Ext.getCmp('AggrfnCombo').show();
													Ext.getCmp('AggrfnCombo').setValue(Aggfn);
												}
												else
												{
													var showaggOptObj = Ext.getCmp('showAggOpt');
													showaggOptObj.suspendEvents(false);
													showaggOptObj.setValue({
														showAgg: 'no'
													});
													Ext.getCmp('AggrfnCombo').setValue('avg');
												}
											}
										}
										var actionOnDesc = configAggrOptions['actiononDescriptor'];
										if(actionOnDesc!=null && actionOnDesc.indexOf("|")>0)
										{
											var descriptorVal= actionOnDesc.substring(actionOnDesc.indexOf("|")+1);
											var descAction = actionOnDesc.substring(0,actionOnDesc.indexOf("|"));
											Ext.getCmp('actionOnDescCombo').setValue(descAction);
											Ext.getCmp('descriptorTextField').setValue(descriptorVal);
										}
										else
										{
											Ext.getCmp('actionOnDescCombo').setValue('Include');
											Ext.getCmp('descriptorTextField').setValue('*');
										}
									}*/
									//else
									//{
										if(showAggoptions!=null && showAggoptions == 'yes')
										{
											if(tempSelectedGraph == "BarChart"|| tempSelectedGraph == "TabularView" || tempSelectedGraph == "PieChart" || tempSelectedGraph == "activityChart")
											{
												var showaggOptObj = Ext.getCmp('showAggOpt');
												showaggOptObj.suspendEvents(false);
												showaggOptObj.setValue({
												showAgg: 'no'
												});
												Ext.getCmp('AggrfnCombo').setValue('avg');
											}
										}
										/*	if(tempSelectedGraph!=null && (tempSelectedGraph=='liveMeasuresBox' || tempSelectedGraph=='TopNGaugeChart' || tempSelectedGraph=='TopN' || tempSelectedGraph=='HeatMapChart' || tempSelectedGraph=='TopNDigitalChart' || tempSelectedGraph=='TopNTabularView' || tempSelectedGraph=='TopNBarChart' || tempSelectedGraph=='PieChart'))
											{
												Ext.getCmp('actionOnDescCombo').setValue('Include');
												Ext.getCmp('descriptorTextField').setValue('*');
											}						 */
									//}
									var advancedControls = jsonDataForGraph['AdvancedControlsArr']['advanceControls'];
									if(advancedControls!=null && !Ext.isEmpty(advancedControls))
									{
										Ext.getCmp('advancedOptionWidgetSlider').add(this.createFilters(advancedControls));
										Ext.getCmp('advancedOptionWidgetSlider').doLayout();
									}
									if(tempSelectedGraph!=null && tempSelectedGraph!='servicehealth')
									{
										var excludeIncludeControls = jsonDataForGraph['ExcludeAndIncludeOptions'];
										var defaultExcludeIncludeAdvanced  = tempBuilderApp.getController("Main").createExcludeIncludeSettingsLayout();	 		
										Ext.getCmp('advancedOptionWidgetSlider').add(defaultExcludeIncludeAdvanced);
					
										Ext.getCmp('advancedOptionWidgetSlider').add(tempBuilderApp.getController("Main").loadExcludeIncludeDefaultData(excludeIncludeControls,tempSelectedGraph));
									}
									
									if(tempSelectedGraph!=null && tempSelectedGraph=='DDTable')
									{
										var graphicalOptsObj = Ext.getCmp('graphicalTypeId');
										if(!Ext.isEmpty(graphicalOptsObj))
										{
											
											var selectedGraphicalType = graphicalOptsObj.getValue();
											if(selectedGraphicalType != null && selectedGraphicalType == 'Bar Chart')
											{
												var viewTypeObj=Ext.getCmp('ViewType');
												if(!Ext.isEmpty(viewTypeObj))
												{
													viewTypeObj.show();
												}
											}
											else
											{
												var viewTypeObj=Ext.getCmp('ViewType');
												if(!Ext.isEmpty(viewTypeObj))
												{
													viewTypeObj.hide();
												}
											}

											if(selectedGraphicalType != null && (selectedGraphicalType == 'Table' || selectedGraphicalType == 'Bar Chart'))
											{
												
												var timelineObj=Ext.getCmp('Timeline');
												if(!Ext.isEmpty(timelineObj))
												{
													timelineObj.hide();
												}
												var showSummaryObj=Ext.getCmp('showChartSummary');
												if(!Ext.isEmpty(showSummaryObj))
												{
													showSummaryObj.hide();
												}
											}
											else
											{
												var timelineObj=Ext.getCmp('Timeline');
												if(!Ext.isEmpty(timelineObj))
												{
													timelineObj.show();
												}
												var showSummaryObj=Ext.getCmp('showChartSummary');
												if(!Ext.isEmpty(showSummaryObj))
												{
													showSummaryObj.show();
												}
											}
										}
									}
									
									Ext.getCmp('advancedOptionWidgetSlider').doLayout();

								}
								var categoryOptsObj = configForm.findField('categoryOpts');
								jsonDataForGraph=null;
								delete jsonDataForGraph;
							}
							jsonTextForgraph=null;
							delete jsonTextForgrapht;
						},
						failure : function(response, opts) {
								console.log("EXCEPTION IN LOADING Advanced Controls");
							}
					});
		}
	},
	createFilters : function(jsonData){
	var itemsArray=new Array();
	for(var i=0;i<jsonData.length;i++)
	{
		var filter=jsonData[i];
		var item = this.createFilterItem(filter);
		if(!Ext.isEmpty(item)){
			itemsArray.push(item);
		}
	}
		return itemsArray;
	},
	createFilterItem : function(filter){
			var item=null;
			switch(filter.type){
				case "combo": item=this.createCombo(filter);
								break;
				case "Checkbox": item=this.createCheckBoxfield(filter);
								break;
				case "Radio": item=this.createRadioButtonfield(filter);
								break;
				case "ColorCombo": item=this.createColorCombo(filter);
								break;
				case "Switch": item=this.createSwitchfield(filter);
								break;
				case "ImageIcon": item=this.createImageIconfield(filter);
								break;
			}
			return item;
	},


	createImageIconfield : function(filter)
	{
		var imgIconVal = '';
		var imgHtml = '';
		var isDisabled=false;
		
		if((filter.showIconStatus!=null && filter.showIconStatus == 'no'))
		{
			isDisabled=true;
		}			
		if(filter.enableImg!=null && filter.enableImg == 'false')
		{
			isDisabled=true;
		}			
		if(filter.selectedImg!=null)
		{
			imgIconVal=filter.selectedImg;
		}

		if(imgIconVal!=null && imgIconVal!="")
		{
			if(imgIconVal.indexOf(":")>0 && imgIconVal.startsWith("Default"))
			{
				imgIconVal = imgIconVal.substring(imgIconVal.indexOf(":")+1);
								
				if(imgIconVal.indexOf('_')>-1)
				{
					imgIconVal = imgIconVal.substring(0,imgIconVal.lastIndexOf('_')+1)+'32';
				}
				imgHtml= '<div id="customUserDefinedImgDefault" class="userDefinedImgDefault" style="padding:5px"><div id="digitalChartImgIcon"  class= "'+imgIconVal+'" width="32px" height="32px" border="0px"/><div class="settingOver"></div></div>';
			}
			else
			{			
				imgIconVal = '/final/images/icon-library/'+loginUser+'/'+imgIconVal;				
				imgHtml='<div id="customUserDefinedImgDefault" class="userDefinedImgDefault" style="padding:5px"><img id="digitalChartImgIcon"  src="'+imgIconVal+'" width="100%" height="100%" border="0px"/><div class="settingOver"></div></div>';				
			}
		}
		else
		{
			imgIconVal = '/final/images/'+strSkin+'/listViewWidgetDefaultSmall.png';
			imgHtml='<div id="customUserDefinedImgDefault" class="userDefinedImgDefault" style="padding:5px"><img id="digitalChartImgIcon"  src= "'+imgIconVal+'" width="32px" height="32px" border="0px"/><div id="settingOver" class="settingOver"></div></div>';
		}

		//var templateIcon = '/final/images/'+strSkin+'/listViewWidgetDefault.png';
		var ImgIconVal ={
			xtype: 'container',
			id : filter.id,
			name : filter.id,
			margin:'0 10 10 10',
			width:42,
			height:42,
			disabled : isDisabled,
			html:imgHtml,
			listeners:{
				afterrender:function(cmp){
					this.setImageTriggerEvents(cmp);
				}
			},
			setImageTriggerEvents : function(cmp)
			{
				Ext.get(cmp.el).select('.userDefinedImgDefault').on('mouseenter',function(){
				//var isIconEnabled=Ext.getCmp('showIcon').getValue();
				//if(isIconEnabled!=null && isIconEnabled==true)
				//{
						Ext.get(cmp.el).select('.settingOver').update('<div class="userDefinedImgDefaultOver" style="display:block;padding:5px;"><table border="0px" cellpadding="0px" cellspacing="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><a href="javascript:void(0)" id="customChangeImg"><span style="width:20px;height:20px;display:inline-block" class="iconOneClickImgDefaultChange"></span><br/></a></td></tr></table></div>');
						Ext.get(cmp.el).select('#customChangeImg').on('click',function(){
						var imgUploadWindow = Ext.create('TemplateBuilder.view.IconLibrary',{
							from:'digitialChartWidget',
							windowId:'windowId',
							custUploadPath:'manager/tomcat/webapps/final/images/icon-library/'+loginUser+'/',
							profileName:''
						}).show();
						imgUploadWindow.on('close', function() {
							imgUploadWindow.destroy();
							imgUploadWindow = 'closed';
						});
					},Ext.get('customChangeImg'));
				//	}
				});
				Ext.get(cmp.el).select('.settingOver').on('mouseleave',function(){
					Ext.get(cmp.el).select('.settingOver').update('');
				});
			}
		}
		return ImgIconVal;

	},
	createSwitchfield : function(filter)
	{
		var isHidden=false;
		var marginValue='10 0 0 10';
		var widthValue=400;
		var isEnabled = false;
		var isDisabled = false;
		if(filter.label!=null && filter.label == 'ChartSummaryEnabled')
		{
			filter.label = screenLabelsObj['Enable History View'];
		}
		if(filter.label!=null && filter.label == 'UseStateColorForFonts')
		{
			filter.label = screenLabelsObj['Apply State Color For Font'];
		}
		if(filter.label!=null && filter.label == 'UseStateColorForBackground')
		{
			filter.label = screenLabelsObj['Apply State Color For Background'];
		}
	/*	if(filter.label!=null && filter.label == 'ResizeFont')
		{
			filter.label = 'Resize Font';
		}*/
		if(filter.label!=null && (filter.label == 'ShowGaugeCircle' || filter.label == 'Enable Full Dial'))
		{
			filter.label = screenLabelsObj['Enable Full Dial'];
			if(!isHighchartForGauge)
			{
				isHidden=true;
			}
		}
		if(filter.label!=null && (filter.label == 'UseStateColorForGauge' || filter.label == 'Apply State Color For Gauge'))
		{
			filter.label = screenLabelsObj['Apply State Color For Gauge'];
			if(!isHighchartForGauge)
			{
				isHidden=true;
			}
		}
		if(filter.label!=null && filter.label == 'ShowIcon')
		{
			filter.label = screenLabelsObj['Show Icon'];
			if(filter.HistoricalSelValue!=null && filter.HistoricalSelValue == 'false')
			{
				 isDisabled=true;
			}			
		}
		if(filter.label!=null && (filter.label == 'EnableMeasureStateColor' || filter.label == 'Apply State Color'))
		{
			//filter.label = 'Apply Measure State Color';
			filter.label = screenLabelsObj['Apply State Color'];
			widthValue=220;
			marginValue='10 0 5 10';
			if(!Ext.isEmpty(Ext.getCmp('showAggOpt')))
			{
				var showAggOpt = Ext.getCmp('showAggOpt').getChecked();
				if(showAggOpt!=null && !Ext.isEmpty(showAggOpt))
				{
					var showAggOptVal = showAggOpt[0].inputValue;
					if (showAggOptVal != null && showAggOptVal == 'yes') {
						isHidden=true;
					}
				}
			}
		}
		if(filter.selectedValue!=null && filter.selectedValue == 'yes')
		{
			 isEnabled = true;
		}
		var SwitchfieldVal = {
				xtype : 'switchfield',
				disabled : isDisabled,
				name: filter.id,
				id: filter.id,
				fieldLabel:filter.label,
				inputValue: 'Yes',
				uncheckedValue:'No',
				margin:'5 10 10 10',
				width :400,
				labelWidth:152,
				vertical: false,
				checked:isEnabled,
				hidden:isHidden
		};
	return SwitchfieldVal;
	},
	createRadioButtonfield : function(filter)
	{
		var tempController = this;
		var filoptions = filter.filOptions;
		var tmpNames = filoptions.split(',');
		var itemArray =new Array();
		var selected  =false;
		if(!Ext.isEmpty(filter.id) && (filter.id=='Stacked' && filter.selectedValue=='Yes'))
		{
			if(!Ext.isEmpty(Ext.getCmp('showAggOpt')))
			{
				Ext.getCmp('showAggOpt').hide();
			}
			if(!Ext.isEmpty(Ext.getCmp('AggrfnCombo')))
			{
				Ext.getCmp('AggrfnCombo').show();
			}
		}
		for(var i=0; i<tmpNames.length;i++)
		{
			var isChecked = false;
			if(!selected && filter.selectedValue!=null && filter.selectedValue == tmpNames[i])
			{
				isChecked = true;
			}
			if(!selected && filter.selectedValue =='default' && i == 0)
			{
				isChecked = true;
			}
			var itemtmp = { boxLabel: tmpNames[i],
								cls:'radiobt',
								name: filter.id+'rb',
								inputValue: tmpNames[i],
								checked : isChecked
							};
			itemArray.push(itemtmp);
		}
		/*if(filter.label!=null && filter.label == 'showLegendStyle')
		{
			filter.label = 'Legend Style';
		}
		else*/ if(filter.label!=null && filter.label == 'showDistprcnt')
		{
			filter.label = screenLabelsObj['Show Distribution As Pct(%)'];
		}else if(filter.label!=null && filter.label == 'ShowValues')
		{
			filter.label = screenLabelsObj['Show Values'];
		}
		else if(filter.label!=null && filter.label == 'WeightedAverage')
		{
			filter.label = screenLabelsObj['Weighted Average'];
		}
		else if(filter.label!=null && filter.label == 'ViewType')
		{
			filter.label = screenLabelsObj['View Type'];
		}
		var radioGrpfield = {
				xtype: 'radiogroup',
				columns:3,
				vertical: true,
				name: filter.id,
				id: filter.id,
				fieldLabel:filter.label,
				width :320,
				labelAlign:'top',
				labelSeparator:'',
				margin : '0 10 10 10',
				defaults:{
							margin : '0 5 0 0',
							columnWidth:100,
						},
					items : itemArray,

			 listeners: {
                change: function (cb, nv, ov) {
                    tempController.onChangeViewType(cb);
                }
            }
		};
	return radioGrpfield;
	},
	createColorCombo : function(filter)
	{
		if(filter.selectedValue!=null && filter.selectedValue == 'default')
		{
			filter.selectedValue = filter.filOptions[0].valueField;
		}
		if(filter.label!=null && filter.label == "ColorPalette")
		{
			filter.label=screenLabelsObj['Color Picker'];
		}
		var colorComboStore = Ext.create('Ext.data.Store',{
				fields:['displayColor','displayField','valueField'],
				proxy:{
					type: 'memory',
					reader: {
						type: 'json',
						root:'filOptions'
					}
				},
				data:filter
			});
		var colorCombo = {
						xtype:'combo',
						editable : false,
						width:210,
						store:colorComboStore,
						cls: 'dropdown colorPalette',
						displayField:'displayField',
						valueField:'valueField',
						displayColor: 'displayColor',
						trigerAction:'all',
						labelAlign:'top',
						labelSeparator:'',
						margin : '0 10 10 10',
						typeAhead: false,
						fieldLabel:filter.label,
						//value:filter.selectedValue,
						//itemId:filter.id,
						queryMode:'local',
						id:'colorPlt',
						name:'colorPlt',
						listeners:
							{
								afterrender: function()
								{
									this.setValue(filter.selectedValue);
								}
							},
						displayTpl: Ext.create('Ext.XTemplate', [
										'<tpl for=".">',
											'<div>',
												'<tpl for="displayColor">',
													'<tpl for="colorCode">',
														'<span style="padding:4px 4px;background:{value};margin:3px 1px 0px 0px;border:1px solid #2c2c2c;"></span>',
													'</tpl>',
												'</tpl>',
												'<span style="margin-left:10px;padding:0px">{displayField}</span>',
												'<input type="text" id="palleteID" style="display:none" value={valueField} />',
											'</div>',
										'</tpl>'
								]),
							listConfig: {
										// Custom rendering template for each item
										itemTpl:new Ext.XTemplate(
											'<tpl for=".">',
												'<tpl for="displayColor">',
													'<tpl for="colorCode">',
														'<span style="padding:4px 4px;background:{value};margin:3px 1px 0px 0px;float:left;border:1px solid #2c2c2c"></span>',
													'</tpl>',
												'</tpl>',
												'<span style="margin-left:10px;padding:0px">{displayField}</span>',
											'</tpl>'
										)
									},
							fieldSubTpl: [
										'<div class="{hiddenDataCls}" role="presentation"></div>',
											'<ul><li id="{id}" type="{type}" ',
												'<tpl if="size">size="{size}" </tpl>',
												'<tpl if="tabIdx">tabIndex="{tabIdx}" </tpl>',
												'<div class="{fieldCls} {typeCls}" autocomplete="off"></div>',
												'<div class="{clearCls}" role="presentation"></div>',
											'</li></ul>',
										{
											compiled: true,
											disableFormats: true
										}
									],
							setRawValue: function(value) {
										var me = this;
										value = Ext.value(value, '');
										me.rawValue = value;
										if (me.inputEl) {
											me.inputEl.dom.innerHTML = value;
										}
										return value;
									}
					}
		return colorCombo;
	},
	createCheckBoxfield : function(filter)
	{
		if(filoptions == 'default')
		{
			var labelAlign = 'left';
		}
		else
		{
			labelAlign = 'top';
		}
		var filoptions = filter.filOptions;
		var selectedOption = filter.selectedValue;
		selectedOption = selectedOption.split('$');
		var tmpNames = filoptions.split(',');
		var itemArray =new Array();
		for(var i=0; i<tmpNames.length;i++)
		{
			var isChecked = false;
			if(selectedOption.indexOf(tmpNames[i]) > -1)
			{
				isChecked = true;
			}
			var boxlable = tmpNames[i];
			var tmpId = tmpNames[i]+'Opt';
			if(tmpNames[i] == 'default')
			{
				boxlable = '';
				tmpId = filter.label+'Opt';
			}
			var itemtmp = { boxLabel: boxlable,
							name: tmpId,
							id:tmpId,
							inputValue: 'yes',
							checked : isChecked,
							margin : '0 5 0 0',
							columnWidth:100,
							};
				itemArray.push(itemtmp);
		}
		if(filter.label!=null && filter.label == 'showChartSummary')
		{
			filter.label = screenLabelsObj['Show Summary'];
		}
		var checkBoxGrpfield = {
				xtype: 'checkboxgroup',
				//columns: tmpNames.length,
				columns:3,
				vertical: true,
				labelAlign:'top',
				labelSeparator:'',
				margin :'0 10 10 10',
				name: filter.id,
				id: filter.id,
				width:320,
				fieldLabel:filter.label,
				defaults:{
					allowBlank:false,
					labelAlign:top,
					labelSeparator:'',
					margin : '0 5 0 0',
					columnWidth:100,
					cls:'checkbt'
				},
				items:itemArray
		};
	return checkBoxGrpfield;
	},
	createCombo : function(filter)
	{
		var marginValue= '10 10 10 10';
		var isHidden=false;
		var comboWidth = 100;
		if(filter.selectedValue!=null && filter.selectedValue == 'default')
		{
			filter.selectedValue = filter.filOptions[0].value;
		}
		var comboStore = Ext.create('Ext.data.Store',{
				fields:['value','name'],
				proxy:{
					type: 'memory',
					reader: {
						type: 'json',
						root:'filOptions'
					}
				},
				data:filter
			});
		/* CODE FOR CHECKING GRAPH OF WIDGET CHANGE */
		if(filter.label!=null && filter.label == "GraphicalType")
		{
			isTopNWidget = true;
			topNVal =filter.selectedValue;
		}
		/* END OF CHECKING GRAPH OF WIDGET CHANGE */
		var isDisabled=false;
		if(filter.label!=null && filter.label == "SummaryGraphType")
		{
			comboWidth=150;
			filter.label = screenLabelsObj['Chart Type']+":";
			if(filter.selHistoricalView!=null && filter.selHistoricalView == "false")
			{
				isDisabled=true;
			}else{
				isDisabled=false;
			}
		}
		else if(filter.label!=null && filter.label == "Aggregation_Function")
		{
			filter.label=screenLabelsObj['Aggregation Function'];
			comboWidth=150;
		}
		else if(filter.label!=null && (filter.label == "SetStateColorOn" || filter.label == 'Select an option'))
		{
			//filter.label="Apply State Color On";
			filter.label=screenLabelsObj['Select an option'];
			comboWidth=165;
			marginValue=  '-15 10 10 10';
			if(filter.ShowSetColorASValue!=null && filter.ShowSetColorASValue == "false")
			{
				isHidden=true;
				isDisabled=true;
			}else{
				isHidden=false;
				isDisabled=false;
			}
			if(!Ext.isEmpty(Ext.getCmp('showAggOpt')))
			{
				var showAggOpt = Ext.getCmp('showAggOpt').getChecked();
				if(showAggOpt!=null && !Ext.isEmpty(showAggOpt))
				{
					var showAggOptVal = showAggOpt[0].inputValue;
					if (showAggOptVal != null && showAggOptVal == 'yes') {
						isHidden=true;
						isDisabled=true;
					}
				}
			}
		}		
		var Combo ={
				xtype:'scrollcombo',
					editable : false,
					//disabled : isDisabled,
					store:comboStore,
					cls : 'dropdown',
					displayField:'name',
					valueField:'value',
					trigerAction:'all',
					fieldLabel:filter.label,
					value:filter.selectedValue,
					itemId:filter.id,
					labelAlign:'top',
					width:comboWidth,
					labelSeparator:'',
					margin : '0 10 10 10',
					queryMode:'local',
					id:filter.id,
					name:filter.id,
					disabled : isDisabled,
					hidden : isHidden
		}
		return Combo;
	},
	uploadwidgetImage : function(from)
	{
		var fileName1 = Ext.getCmp('FILE_1').getValue();
		var fileHidObj=Ext.getCmp('hiddenFile_dstFile');
		var meC=this;
		var fileName1 = Ext.getCmp('FILE_1').getValue();
		if(fileName1!=null && fileName1!="undefined")
			fileName1=fileName1.toLowerCase();

		if(fileName1.lastIndexOf(".png") == -1 && fileName1.lastIndexOf(".jpg") == -1 && fileName1.lastIndexOf(".gif") == -1)
		{
			Ext.Msg.show({
				title: templatesAlertLbl,
				msg: invalidImageTypeAlert,
				buttons: Ext.Msg.OK,
				icon: Ext.Msg.WARNING
			});
			Ext.getCmp('FILE_1').reset();
			Ext.getCmp('FILE_1').focus();
			return;
		}
		Ext.Msg.show({
			title:templatesAlertLbl,
			msg:uploadWidgetImageMsgAlert+"?",
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn:function(buttonId)
			{
				if(buttonId =="yes")
				{
					var fileName = Ext.getCmp('FILE_1').getValue();


					var frmMain = Ext.getCmp('fileUploadFormId').getForm();
					if (frmMain.isValid())
					{
						if(fileName!=null && fileName.lastIndexOf("/")>0 && fileName.lastIndexOf("clear.png") == -1)
						{
							fileName=fileName.substring(fileName.lastIndexOf("/")+1);
						}
						else if(fileName!=null && fileName.lastIndexOf("\\")>0 && fileName.lastIndexOf("clear.png") == -1)
						{
							fileName=fileName.substring(fileName.lastIndexOf("\\")+1);
						}
						var fileHidObj=Ext.getCmp('FILE_1_dstFile');
						if(fileHidObj!=null)
						{
							fileHidObj.setValue("manager/tomcat/webapps/final/images/icon-library/"+loginUser+"/"+fileName);
						}
						var urlForFile ="/final/servlet/com.eg.EgFileUpload?&requestFrom=EgTemplateList.jsp&uploadFor=widgetImg&uploadDir=manager/tomcat/webapps/final/images/icon-library/"+loginUser+"/"+fileName+"&fileExt=jpg&fileUpload=yes";
						Ext.getCmp('fileUploadFormId').submit({
							url: urlForFile,
							method: 'POST',
							success: function (form, action) {
								var windowIdObj=Ext.getCmp('widgetWindowId');
								if(!Ext.isEmpty(windowIdObj))
								{
									windowIdObj.destroy();
									windowIdObj=null;
									delete windowIdObj;
								}
								var iconLibwindowIdObj=Ext.getCmp('iconLibWindow');
								if(!Ext.isEmpty(iconLibwindowIdObj))
								{
									iconLibwindowIdObj.destroy();
									iconLibwindowIdObj=null;
									delete iconLibwindowIdObj;
								}
								var windowIdObj=Ext.getCmp('windowId');
								if(!Ext.isEmpty(windowIdObj))
								{
									windowIdObj.destroy();
									windowIdObj=null;
									delete windowIdObj;
								}
								var jsonText = action.response.responseText;
								if (fileName.indexOf(' ')>0)
								{
									for (var i = 0; i < fileName.length; i++) {
										fileName= fileName.replace(' ', '');
								   }
								}
								var jsonText = action.response.responseText;
								if (fileName.indexOf(' ')>0)
								{
									for (var i = 0; i < fileName.length; i++) {
										fileName= fileName.replace(' ', '');
								   }
								}
								fileName="/final/images/icon-library/"+loginUser+"/"+fileName;

								if(from!=null && from == 'widgetUpload')
								{ 
								Ext.getCmp('userDefinedWidgetIcon').update('<div id="userDefinedImgDefault" class="userDefinedImgDefault" style="padding:5px"><img id="widgetImageIcon"  src= "'+fileName+'" width="100%" height="100%" border="0px"/><div id="settingOver" class="settingOver"></div></div>');
								Ext.get('userDefinedImgDefault').on('mouseenter',function(){
								Ext.get('settingOver').update('<a href="javascript:void(0)" id="changeImg"><div class="userDefinedImgDefaultOver" style="display:block"></div></a>');
								
								Ext.get('changeImg').on('click',function(){
								var imgUploadWindow = Ext.create('TemplateBuilder.view.IconLibrary',{
									from:'widgetUpload',
									windowId:'widgetWindowId',
									custUploadPath:'manager/tomcat/webapps/final/images/icon-library/'+loginUser+'/',
								}).show()
								
									imgUploadWindow.on('close', function() {
									imgUploadWindow.destroy();
									imgUploadWindow = 'closed';
								});
									},Ext.get('changeImg'))
								});
								
								Ext.get('settingOver').on('mouseleave',function(){
									Ext.get('settingOver').update('');
								});
								}else{
									var val= Ext.getCmp('imgIcon');
									Ext.getCmp('imgIcon').update('<div id="customUserDefinedImgDefault" class="userDefinedImgDefault" style="padding:5px"><img id="digitalChartImgIcon"  src= "'+fileName+'" width="100%" height="100%" border="0px"/><div id="customSettingOver" class="settingOver"></div></div>');
									Ext.get('customUserDefinedImgDefault').on('mouseenter',function(){
									Ext.get('customSettingOver').update('<a href="javascript:void(0)" id="customUserDefinedImgDefault1"><div class="userDefinedImgDefaultOver" style="display:block"></div></a>');
									
									Ext.get('customUserDefinedImgDefault1').on('click',function(){
									var imgUploadWindow = Ext.create('TemplateBuilder.view.IconLibrary',{
										from:'digitialChartWidget',
										windowId:'windowId',
										custUploadPath:'manager/tomcat/webapps/final/images/icon-library/'+loginUser+'/',
									}).show()
									
										imgUploadWindow.on('close', function() {
										imgUploadWindow.destroy();
										imgUploadWindow = 'closed';
									});
										},Ext.get('customUserDefinedImgDefault1'))
									});
									
									Ext.get('customSettingOver').on('mouseleave',function(){
										Ext.get('customSettingOver').update('');
									});
								}
							},
							failure: function(form, action) // if result page doest not contain success:true, this method fires
							{

							}
						});
					}
				}
			}});
	},
	uploadDefaultImage : function(profileName,from,defaultClass)
	{
		var mec = this;
		if(from!=null && from == 'widgetUpload')
		{
			profileName = Ext.getCmp('templateLayoutObj').profileName;
			if(defaultClass!=null && (defaultClass.endsWith(".png") || defaultClass.endsWith(".jpg") || defaultClass.endsWith(".gif")))
			{
				Ext.getCmp('userDefinedWidgetIcon').update('<div id="userDefinedImgDefault" class="userDefinedImgDefault" style="padding:5px"><img id="widgetImageIcon"  src= "'+defaultClass+'" width="100%" height="100%" border="0px"/><div id="settingOver" class="settingOver"></div></div>');
			}
			else
			{	if(defaultClass.indexOf('_')>-1)
				{
					defaultClass = defaultClass.substring(0,defaultClass.lastIndexOf('_')+1)+'32';
				}
				Ext.getCmp('userDefinedWidgetIcon').update('<div id="userDefinedImgDefault" class="userDefinedImgDefault" style="padding:5px"><div id="widgetImageIcon"  class= "'+defaultClass+'"  style="width:32px;height:32px"  border="0px"/><div id="settingOver" class="settingOver"></div></div>');
			}
			Ext.get('userDefinedImgDefault').on('mouseenter',function(){
			Ext.get('settingOver').update('<a href="javascript:void(0)" id="changeImg"><div class="userDefinedImgDefaultOver" style="display:block"></div></a>');
			
			Ext.get('changeImg').on('click',function(){
			var imgUploadWindow = Ext.create('TemplateBuilder.view.IconLibrary',{
				from:'widgetUpload',
				windowId:'widgetWindowId',
				custUploadPath:'manager/tomcat/webapps/final/images/icon-library/'+loginUser+'/',
			}).show()
			
				imgUploadWindow.on('close', function() {
				imgUploadWindow.destroy();
				imgUploadWindow = 'closed';
			});
				},Ext.get('changeImg'))
			});
			
			Ext.get('settingOver').on('mouseleave',function(){
				Ext.get('settingOver').update('');
			});
			var windowIdObj=Ext.getCmp('iconLibWindow');
			if(!Ext.isEmpty(windowIdObj))
			{
				windowIdObj.destroy();
				windowIdObj=null;
				delete windowIdObj;
			}
		}
		else if(from!=null && from == 'templateUpload')
		{
			if(defaultClass!=null && (defaultClass.endsWith(".png") || defaultClass.endsWith(".jpg") || defaultClass.endsWith(".gif")))
			{
				Ext.getCmp('imgcont').update('<div id="listViewImgDefault" class="listViewImgDefault"><img id="templateImageIcon"  src="'+defaultClass+'"  style="position:absolute;top:0%;left:0%;right:0%;margin:auto;bottom:0%;width:64px;height:64px" border="0px"/><div id="settingOver" class="settingOver"></div></div>');
			}
			else
			{
				Ext.getCmp('imgcont').update('<div id="listViewImgDefault" class="listViewImgDefault"><div id="templateImageIcon"  Class= "'+defaultClass+'"   style="position: absolute;top:0%;left: 0%;right: 0%;margin: auto;bottom: 0%;"/></div><div id="settingOver" class="settingOver"></div></div>');
			}
			var windowIdObj=Ext.getCmp('iconLibWindow');
			if(!Ext.isEmpty(windowIdObj))
			{
				windowIdObj.destroy();
				windowIdObj=null;
				delete windowIdObj;
			}
			Ext.get('listViewImgDefault').on('mouseenter',function(){
			Ext.get('settingOver').update('<div class="listViewImgDefaultOver" style="display:block"><table border="0px" cellpadding="0px" cellspacing="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><a href="javascript:void(0)" id="changeImg"><span style="width:20px;height:20px;display:block" class="iconOneClickImgDefaultChange"></span><span class="changeImageIconText">Change Image</span></a></td></tr></table></div>');

			Ext.get('changeImg').on('click',function(){
				var profileName=Ext.getCmp('templateName').getValue();
				var imgUploadWindow = Ext.create('TemplateBuilder.view.IconLibrary',{
					from:'templateUpload',
					windowId:'windowId',
					custUploadPath:'manager/tomcat/webapps/final/images/icon-library/'+loginUser+'/',
					profileName:profileName
				}).show()
				imgUploadWindow.on('close', function() {
					imgUploadWindow.destroy();
					imgUploadWindow = 'closed';
				});
			},Ext.get('changeImg'))
		});
		Ext.get('settingOver').on('mouseleave',function(){
			Ext.get('settingOver').update('');
		});
		}
		else if(from!=null && from =='digitialChartWidget')
		{
			if(Ext.getCmp('imgIcon')!=null)
			{
				if(defaultClass!=null && (defaultClass.endsWith(".png") || defaultClass.endsWith(".jpg") || defaultClass.endsWith(".gif")))
				{
					Ext.getCmp('imgIcon').update('<div id="customUserDefinedImgDefault" class="userDefinedImgDefault" style="padding:5px"><img id="digitalChartImgIcon"  src="'+defaultClass+'" width="100%" height="100%" border="0px"/><div id="customSettingOver" class="settingOver"></div></div>');
				}
				else
				{
					var digitalChartImgContObj=Ext.getCmp('imgIcon');
					digitalChartImgContObj.iconClass=defaultClass;
					if(defaultClass.indexOf('_')>-1)
					{
						defaultClass = defaultClass.substring(0,defaultClass.lastIndexOf('_')+1)+'32';
					}
					digitalChartImgContObj.update('<div id="customUserDefinedImgDefault" class="userDefinedImgDefault" style="padding:5px"><div id="digitalChartImgIcon"  class= "'+defaultClass+'"   style="width:32px; height:32px" /><div id="customSettingOver" class="settingOver"></div></div>');
				}
			}
			var windowIdObj=Ext.getCmp('iconLibWindow');
			if(!Ext.isEmpty(windowIdObj))
			{
				windowIdObj.destroy();
				windowIdObj=null;
				delete windowIdObj;
			}
			
			if(Ext.get('customUserDefinedImgDefault')!=null)
			{
				Ext.get('customUserDefinedImgDefault').on('mouseenter',function(){
				Ext.get('customSettingOver').update('<div class="userDefinedImgDefaultOver" style="display:block;padding:5px;"><table border="0px" cellpadding="0px" cellspacing="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><a href="javascript:void(0)" id="customChangeImg"><span style="width:20px;height:20px;display:inline-block" class="iconOneClickImgDefaultChange"></span></a></td></tr></table></div>');
				Ext.get('customChangeImg').on('click',function(){
					var imgUploadWindow = Ext.create('TemplateBuilder.view.IconLibrary',{
						from:'digitialChartWidget',
						windowId:'windowId',
						custUploadPath:'manager/tomcat/webapps/final/images/icon-library/'+loginUser+'/',
						profileName:''
					}).show()
					imgUploadWindow.on('close', function() {
						imgUploadWindow.destroy();
						imgUploadWindow = 'closed';
					});
				},Ext.get('customChangeImg'))
				});
				Ext.get('customSettingOver').on('mouseleave',function(){
				Ext.get('customSettingOver').update('');
				});
			}
		}
		else if(from!=null && from == 'templateList')
		{
			if(defaultClass!=null && (defaultClass.endsWith(".png") || defaultClass.endsWith(".jpg") || defaultClass.endsWith(".gif")))
			{
				if(defaultClass!=null && defaultClass.lastIndexOf("/")>0)
				{
					defaultClass = defaultClass.substring(defaultClass.lastIndexOf("/")+1);
				}
				else if(defaultClass!=null && defaultClass.lastIndexOf("\\")>0)
				{
					defaultClass = defaultClass.substring(defaultClass.lastIndexOf("\\")+1);
				}
			}
			var paramsForRqst = 'action=uploadDefaultImage&from='+encodeURIComponent(from)+'&profileName='+encodeURIComponent(profileName)+'&defaultClass='+encodeURIComponent(defaultClass);
			Ext.Ajax.request({
			url : '/final/servlet/com.eg.EgTemplateBuilderController',
			method : 'POST',
			params : paramsForRqst + '&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
			scope : this,
			async : true,
			success : function(response) {
				var jsonText = response.responseText;
				if (jsonText != null && jsonText != '') {
					var jsonData = Ext.decode(jsonText);
					if(jsonData!=null && jsonData['updated'] == 'true')
					{
						var windowIdObj=Ext.getCmp('iconLibWindow');
						if(!Ext.isEmpty(windowIdObj))
						{
							windowIdObj.destroy();
							windowIdObj=null;
							delete windowIdObj;
						}
						var panelViewId = Ext.getCmp('templateBuilderListPageView');
						if(panelViewId!=null && !Ext.isEmpty(panelViewId) )
						{
							panelViewId.removeAll();
							panelViewId.setLoading(false);
							panelViewId.doLayout();
						}
						mec.goToTemplateListPage();
					}
					jsonData=null;
					delete jsonData;
				}
				jsonText=null;
				delete jsonText;
			},
			failure : function(response, opts) {
					console.log("EXCEPTION IN LOADING");
				}
		});
		}
	},
	expandMe : function(btn) {
		var comBoId = '';
		var expandPopupAlertMsg = '';
		var btnId = btn.getId();
		if(btnId == 'templateCompExpand')
		{
			comBoId = 'templateInfraElementsCombo';
			expandPopupAlertMsg = compTypAlertMsg;
		}
		var CmpClone = Ext.getCmp(comBoId);
		var cloneStore = Ext.clone(CmpClone.getStore());
		btn.setDisabled(true);
		var meC = this;
		var expandWindow = Ext.create('Ext.window.Window', {
			title : $('#'+comBoId + 'Lbl').text(),
			cls:'expandWindowPopupShadow',
			height:350,
			header:{
				height:34,
				style:{'padding-bottom':'4px !important'},
			},
			padding:'0 10 5 10',
			width : 260,
			frame:true,
			border:true,
			ghost:false,
			id: btnId+'View',
			closeAction : 'destroy',
			buttonAlign : 'center',
			btnObjId : btnId,
			comboBxId : comBoId,
			items :[{
					xtype: 'container',
					width:240,
					layout:{
						type:'vbox',
						align:'stretch',
					},
					margin: 0,
					items: [
					{
						xype: 'container',
						cls: 'multisearchlist',
						style:{'top':'0px'},
						items: [{
							xtype: 'customtrigger',
							width:225,
							id: 'compSearch',
							emptyText:screenLabelsObj['Search'],
							listeners :
							{
								'change' : function(triggerField, newValue, oldValue, eOpts) {
									if(!Ext.isEmpty(cloneStore))
									{
										if(newValue=="*")
										{
											cloneStore.clearFilter();
										}
										else
										{
											if(newValue.lastIndexOf("*")==(newValue.length-1))
											{
												newValue = newValue.substr(0,(newValue.length-1));
											}
											cloneStore.clearFilter();
											if (newValue) {
												var matcher = new RegExp(Ext.String.escapeRegex(newValue), "i");
												cloneStore.filter({
													filterFn: function(record) {
														return matcher.test(record.get('displayField')) ;
													}
												});
											}
										triggerField.focus();
										}
									}
								}

							}
						}]
					},{
						xtype: 'multiselect',
						width:240,
						height:240,
						border : 0,
						layout : 'fit',
						autoScroll : true,
						scroll : true,
						labelAlign : 'left',
						baseCls : 'egmultiselect',
						multiSelect : true,
						id : comBoId + '_Clone',
						name : comBoId + '_Clone',
						store : cloneStore,
						value : CmpClone.getValue(),
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						listConfig : {
							simpleSelect : true,
							id : comBoId + '_maximize',
							name : comBoId + '_maximize'
						}
					}
				]
			}],
			buttons : [{
				text : screenLabelsObj['SELECT'],
				id : 'expand',
				margin:'0 0 10 0',
				padding:'0 4 0 4',
				//cls : 'buttonNew',
				cls : 'quickMenuWhiteButton',
				name : 'expand',
				handler : function() {
					var maxComboObj = Ext.getCmp(this.up('window').comboBxId + '_Clone');
					if (maxComboObj.getValue() != '') {
						var thisBtnObj = Ext.getCmp(this.up('window').btnObjId);
						if (thisBtnObj != null) {
							thisBtnObj.setDisabled(false);
						}
							CmpClone.setValue(maxComboObj.getValue());
						expandWindow.destroy();
					} else {
						Ext.MessageBox.show({
							title : templatesAlertLbl,
							msg : expandPopupAlertMsg,
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING
						});
						return;
					}
				}
			} ],
			listeners : {
				'destroy' : function() {
					var thisBtnObj = Ext.getCmp(this.btnObjId);
					if (thisBtnObj != null) {
						thisBtnObj.setDisabled(false);
					}
				}
			}
		}).show();
		this.getMain().doLayout();
	},
	addMeasuresToGrid : function(btn)
	{
		var meC = this;
		var userDefinedWidgetWindowObj = this.getUserDefinedWidgetWindow();
		var configForm = userDefinedWidgetWindowObj.getComponent('configForm').getForm();
		if(tempSelectedGraph != null && tempSelectedGraph == 'servicehealth')
		{
			var compTypeComboValue = configForm.findField('healthCenterCompTypeCombo').getValue();
		
			if (compTypeComboValue != null && compTypeComboValue == '-1') 
			{
				Ext.Msg.show({
					title : templatesAlertLbl,
					msg : compTypAlertMsg,
					buttons : Ext.MessageBox.OK,
					icon : Ext.MessageBox.WARNING
				});
				return;
			}

			var healthCenterTestScrollComboValue = configForm.findField('healthCenterTestScrollCombo').getValue();
					
			if(Ext.isEmpty(healthCenterTestScrollComboValue) || healthCenterTestScrollComboValue == '' || healthCenterTestScrollComboValue == '-1')
			{
				Ext.Msg.show({
					title : templatesAlertLbl,
					msg : testAlertMsg,
					buttons : Ext.MessageBox.OK,
					icon : Ext.MessageBox.WARNING
				});
				return;
			}

			var healthCenterDescriptorsValue = configForm.findField('healthCenterComponentCombo').getValue();
			
			if ((healthCenterDescriptorsValue != null && healthCenterDescriptorsValue == '') || (healthCenterDescriptorsValue == '-1')) {
				Ext.Msg.show({
					title : templatesAlertLbl,
					msg : descriptorAlertMsg,
					buttons : Ext.MessageBox.OK,
					icon : Ext.MessageBox.WARNING
				});
				return;
			}

			var selectedTest = configForm.findField('healthCenterTestScrollCombo').getValue();
			var displayTest = configForm.findField('healthCenterTestScrollCombo').getRawValue();
			var descriptors = configForm.findField('healthCenterComponentCombo').getValue();

			var compTypeDisplayValue = configForm.findField('healthCenterCompTypeCombo').getRawValue();
			var gridObj = this.getComparisontable();
			var gridStore = gridObj.getStore();
			var configuredData = [];

			var checkAllDescriptors = false;
			
			for ( var desc in descriptors) {
				var selectedDesc = descriptors[desc];
				var isAllDescriptors = false;
				if (selectedDesc != null && selectedDesc == 'allDescriptors') {
					isAllDescriptors = true;
					checkAllDescriptors = true;
				}
				if (selectedDesc == "-1" || selectedDesc == "")
					selectedDesc = "+";
				var tempDesc = "+";
				var dispDesc = "+";
				if (selectedDesc != null && selectedDesc != "+" && selectedDesc.indexOf("+") == 0 && selectedDesc.length > 1) {
					tempDesc = selectedDesc.substring(1);
				}
					
				if(isAllDescriptors)
				{
					tempDesc = "AllInfos";
					dispDesc = allDescriptors;
				}else{

					dispDesc = tempDesc;
				}

				if(checkAllDescriptors && !isAllDescriptors)
				{
					Ext.Msg.show({
						title : templatesAlertLbl,
						msg : allDescriptorsAlertMsg,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
					});
					return;
				}

				//var hidVal = selectedComp+ "|$|" +dispComp+ "!@!" + selectedTest + "|$|" + displayTest+ "!@!" + tempDesc;
				var hidVal = compTypeComboValue+ "|@|" +compTypeDisplayValue+ "|@|" + selectedTest + "|@|" + displayTest+ "|@|" + tempDesc;

				var getIdx = gridStore.find('hidVal', hidVal, 0, false, true, true);

				if (getIdx == -1) {
					configuredData.push({
						componentType : compTypeDisplayValue,
						test : displayTest,
						Descriptor : dispDesc,
						measure : '',
						hidVal : hidVal,
						chartType : 'line',
						ddHidVal : '',
						ddval : ''
					});
				} else {
					Ext.Msg.show({
						title : templatesAlertLbl,
						msg : 'selection already exists',
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
					});
					return;
				}
			}
			gridStore.add(configuredData);
			gridObj.doLayout();
		}
		else
		{

			var measureCombo ='';
			if(tempSelectedGraph == 'TopNGaugeChart' || tempSelectedGraph == 'TopNDigitalChart' || tempSelectedGraph == 'DDTable' || tempSelectedGraph == 'TopN')
			{
				measureCombo = configForm.findField('measureListCombo');
			}
			else
			{
				measureCombo = configForm.findField('measurelist');
			}
			var testCombo = configForm.findField('testCombo');
			var selectedTest = testCombo.getValue();
			var displayTest = testCombo.getRawValue();
			var measures = measureCombo.getValue();
			if (selectedTest != null && (selectedTest == '' ||selectedTest == '-1')) {
				Ext.Msg.show({
						title : templatesAlertLbl,
						msg : testAlertMsg,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
					});
					return;
			} else if (measures != null && (measures == '' || measures == '-1')) {
				Ext.Msg.show({
						title : templatesAlertLbl,
						msg : measureAlertMsg,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
					});
					return;
			}
			var ddColumnsCombo  = configForm.findField('ddcolumnsMultiSelect');
			var ddColumns = null;
			if(tempSelectedGraph == 'DDTable')
			{
				ddColumns = ddColumnsCombo.getValue();
				if (ddColumns != null && (ddColumns == '' ||ddColumns == '-1')) {
				Ext.Msg.show({
						title : templatesAlertLbl,
						msg : noDDColSelectedAlertMsg,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
					});
					return;
				}
			}
			var measureComboStore = measureCombo.getStore();
			var gridObj = this.getComparisontable();
			var gridStore = gridObj.getStore();
			var NumOfrecords =  gridStore.getCount();
			var configuredData = new Array();
			if(tempSelectedGraph == 'TopNGaugeChart' || tempSelectedGraph == 'TopNDigitalChart' || tempSelectedGraph == 'DDTable' ||tempSelectedGraph == 'TopN')
			{
				if(NumOfrecords!=null && NumOfrecords>0)
				{
					gridStore.removeAll();
				}
				var measRecord = measureComboStore.findRecord(measureCombo.valueField, measures, 0, false, true, true);
				var mIdx = measureComboStore.indexOf(measRecord);
				var dispMeas = measureComboStore.getAt(mIdx).get('displayField');
				var hidVal =selectedTest + ":" + measures ;
				hidVal = hidVal +"!!!"+dispMeas;
				var mesurehidVal = measures;
				var ddColumnVals = '';
				var dispDDColumns ='';
				if(tempSelectedGraph == 'DDTable')
				{
					for ( var ddcol in ddColumns) {
						var selectedDDCol = ddColumns[ddcol];
						var ddColsComboStore = ddColumnsCombo.getStore();
						var ddColRecord = ddColsComboStore.findRecord(ddColumnsCombo.valueField, selectedDDCol, 0, false, true, true);
						var mIdx = ddColsComboStore.indexOf(ddColRecord);
						var dispDDCol = ddColsComboStore.getAt(mIdx).get('displayField');
						dispDDColumns = dispDDColumns + "," + dispDDCol ;
						ddColumnVals = ddColumnVals + "," + selectedDDCol + ":" + dispDDCol;
						}
						if (ddColumnVals != null && ddColumnVals.indexOf(',') == 0) {
						ddColumnVals = ddColumnVals.substr(1);
					}
					if (dispDDColumns != null && dispDDColumns.indexOf(',') == 0) {
						dispDDColumns = dispDDColumns.substr(1);
					}
				}
				var getIdx = gridStore.find('hidVal', hidVal, 0, false, true, true);
				if (getIdx == -1) {
					configuredData.push({
						test : displayTest,
						measure : dispMeas,
						hidVal : hidVal,
						chartType : 'line',
						ddHidVal : ddColumnVals,
						ddval : dispDDColumns
									});
				} else {
						Ext.Msg.show({
						title : templatesAlertLbl,
						msg : 'selection already exists',
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
						});
						return;
					}
			}
			else
			{
				if(tempSelectedGraph == 'liveMeasuresBox')
				{
					if(NumOfrecords!=null && NumOfrecords>0)
					{
						if(testCombo.previousTestSelection!=selectedTest)
						{
							gridStore.removeAll();
						}
					}
				}
				var dispMeasStr = '';
				var hidval ='';
				var mesurehidVal ='';
				if(tempSelectedGraph != null)
				{
					if(tempSelectedGraph == 'CombinationChart')
					{
						for ( var meas in measures)
						{
							var selectedMeas = measures[meas];
							var measRecord = measureComboStore.findRecord(measureCombo.valueField, selectedMeas, 0, false, true, true);
							var mIdx = measureComboStore.indexOf(measRecord);
							var dispMeas = measureComboStore.getAt(mIdx).get('displayField');
							var hidVal =selectedTest + ":" + selectedMeas ;
							hidVal =hidVal+"!!!"+dispMeas;
							var tmpIdx = gridStore.find('hidVal', hidVal, 0, false, true, true);
							if(tmpIdx > -1)
							{
								Ext.Msg.show({
								title : templatesAlertLbl,
								msg : 'selection already exists',
								buttons : Ext.MessageBox.OK,
								icon : Ext.MessageBox.WARNING
								});
								return;
							}
						if (tmpIdx == -1) {
							configuredData.push({
								test : displayTest,
								measure : dispMeas,
								hidVal : hidVal,
								chartType : 'line',
								ddHidVal : '',
								ddval : ''
											});
						} else {
								Ext.Msg.show({
								title : templatesAlertLbl,
								msg : 'selection already exists',
								buttons : Ext.MessageBox.OK,
								icon : Ext.MessageBox.WARNING
								});
								return;
							}
						}
					}
					else
					{
						var isexist = false; 
						var records = gridStore.getRange();
						var testRecord = gridStore.findRecord('test',displayTest, 0, false, true, true);
						var testIdx = gridStore.indexOf(testRecord);
						for ( var meas in measures)
						{
							var selectedMeas = measures[meas];
							var measRecord = measureComboStore.findRecord(measureCombo.valueField, selectedMeas, 0, false, true, true);
							var mIdx = measureComboStore.indexOf(measRecord);
							var dispMeas = measureComboStore.getAt(mIdx).get('displayField');
							Ext.each(records,function(record){
								var testarr = record.data.test;
								var measarr = record.data.measure;
								if(testarr == displayTest)
								{
									measarr = measarr.split(',');
									for(var g = 0;g<measarr.length;g++)
									{
										if(measarr[g] == dispMeas)
										{
											isexist = true;
											break;
										}
									}
								}
							});
							mesurehidVal = mesurehidVal+'$!'+selectedMeas;
							dispMeasStr = dispMeasStr+','+dispMeas;
						}
						if(isexist)
						{
							Ext.Msg.show({
										title : templatesAlertLbl,
										msg : 'selection already exists',
										buttons : Ext.MessageBox.OK,
										icon : Ext.MessageBox.WARNING
										});
										return;
						}
						if(dispMeasStr!=null && dispMeasStr.indexOf(',') == 0)
						{
							dispMeasStr = dispMeasStr.substring(1);
						}
						if(mesurehidVal!=null && mesurehidVal.indexOf('$!') == 0)
						{
							mesurehidVal = mesurehidVal.substring(2);
						}
						hidval = selectedTest+":"+mesurehidVal;
						var dispMeasSave = dispMeasStr;
						while(dispMeasSave.indexOf(',')>0)
						{
							dispMeasSave = dispMeasSave.replace(',',"^^")
						}
						hidval = hidval+"!!!"+dispMeasSave;
						var hidIndex = gridStore.find('hidVal', hidval, 0, false, true, true);
						if(hidIndex > -1)
						{
							Ext.Msg.show({
							title : templatesAlertLbl,
							msg : 'selection already exists',
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING
							});
							return;
						}
						var getIdx = gridStore.find('hidVal', hidval, 0, false, true, true);
						if (getIdx == -1) {
							if(testIdx > -1)
							{
								var existingMeas = gridStore.getAt(testIdx).get('measure');
								var existHidVal = gridStore.getAt(testIdx).get('hidVal');
								dispMeasSave = existHidVal.substring(existHidVal.indexOf("!!!")+3)+"^^"+dispMeasSave;
								existHidVal = existHidVal.substring(0,existHidVal.indexOf("!!!"));
								testRecord.set("measure", existingMeas+','+dispMeasStr);
								//testRecord.set("hidVal", existHidVal+'$!'+mesurehidVal);
								testRecord.set("hidVal", existHidVal+'$!'+mesurehidVal+"!!!"+dispMeasSave);
								//testRecord.set("hidVal", existHidVal+'$!'+mesurehidVal);
								testRecord.commit();
							}
							else
							{
								configuredData.push({
								test : displayTest,
								measure : dispMeasStr,
								hidVal : hidval,
								chartType : 'line',
								ddHidVal : '',
								ddval : ''
											});
							}
							
						} else {
								Ext.Msg.show({
								title : templatesAlertLbl,
								msg : 'selection already exists',
								buttons : Ext.MessageBox.OK,
								icon : Ext.MessageBox.WARNING
								});
								return;
							}
					}
				}
			}
			gridStore.add(configuredData);
			gridObj.doLayout();
			testCombo.previousTestSelection=selectedTest;
		}
		
	},
	setValueWithOptionInList : function(comboObj, list, value, defaultMsg) {
		var comboStre = comboObj.getStore();
		comboStre.removeAll();
		comboObj.suspendEvents(false);
		comboStre.loadRawData(list);
		if (defaultMsg != null && defaultMsg != '') {
			comboStre.insert(0, {
				displayField : defaultMsg,
				valueField : '-1'
			});
			comboObj.setValue(value);
		} else {
			var valueAssigned = false;
			for ( var listCounter = 0; listCounter < list.length; listCounter++) {
				if (list[listCounter].valueField == value && value != "" && value != null) {
					comboObj.setValue(value);
					valueAssigned = true;
				}
			}
			if (!valueAssigned) {
				comboObj.setValue(list[0].valueField);
			}
		}
		comboObj.resumeEvents();
	},
	setValueWithMultiSelectOptionInList : function(comboObj, list, value, defaultMsg,defaultValue) {
		var comboStre = comboObj.getStore();
		comboStre.removeAll();
		comboObj.suspendLayout = true;
		comboObj.suspendEvents(false);
		comboStre.loadRawData(list);
		if (defaultMsg != null && defaultMsg != '') {
			if ((value != null && value == 'allDescriptors') || (defaultValue!=null && defaultValue=='allDescriptors')) {
				comboStre.insert(0, {
					displayField : defaultMsg,
					valueField : 'allDescriptors'
				});
			} else if (value != null && value == 'allServers') {
				comboStre.insert(0, {
					displayField : defaultMsg,
					valueField : 'allServers'
				});
			} else if ((value != null && value == 'allVms') || (defaultValue!=null && defaultValue=='allVms')) {
				comboStre.insert(0, {
					displayField : defaultMsg,
					valueField : 'allVms'
				});
			} else {
				comboStre.insert(0, {
					displayField : defaultMsg,
					valueField : '-1'
				});
			}
		}
		comboObj.setValue(value);
		comboObj.resumeEvents();
		comboObj.suspendLayout = false;
		comboObj.doLayout();
	},
	getOptionsForType : function() {
	var templateconfigurationObj=this.getCreateTemplate();
		if (Ext.isEmpty(templateconfigurationObj))
			templateconfigurationObj = Ext.widget('createTemplate');

	var selectedType = Ext.getCmp('infraTypeCombo').getValue();
		var paramsForRc = null;
		if(selectedType!=null)
		{
			if (selectedType == "components") {
				paramsForRc = 'C=true&&calljson=true&F=getServerTypesJSONForTemplate';
			}
			else
			{
				 paramsForRc = 'C=true&P0={' + selectedType + '}&P1=None&calljson=true&F=getOptionsForTypeJSON';
			}
		}
		var meC = this;
		Ext.Ajax.request({
			url : '/final/servlet/com.eg.EgMonRemoteScriptingServlet',
			method : 'POST',
			params : paramsForRc + '&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
			scope : this,
			async : true,
			success : function(response) {
				var jsonText = response.responseText;
				if (jsonText != null && jsonText != '') {
					var jsonData = Ext.decode(jsonText);
					var compsMultiselectComo = Ext.getCmp('templateInfraElementsCombo');
					meC.setValueWithMultiSelectOptionInList(compsMultiselectComo,jsonData['optionsForType'],'','','');
					jsonData=null;
					delete jsonData;
				}
				jsonText=null;
				delete jsonText;
			},
			failure : function(response, opts) {
					console.log("EXCEPTION IN LOADING");
				}
		});
	},
	saveTemplate : function(createBtn)
	{
		var meC = this;
		var templateconfigurationObj=this.getCreateTemplate();
		if (Ext.isEmpty(templateconfigurationObj))
			templateconfigurationObj = Ext.widget('createTemplate');

		var profileName = '';
		var previousProfileName = '';
		if (templateconfigurationObj.templateAction == 'Modify') {
			previousProfileName = templateconfigurationObj.profileName;
		}
		 profileName = Ext.getCmp('templateName').getValue();
		 var templateImageIconObj=$('#templateImageIcon');
		 var fileName = templateImageIconObj[0].src;
		 var imgPath = null;
		if(fileName!=null && fileName.lastIndexOf("/")>0 && fileName.lastIndexOf("clear.png") == -1)
		{
			imgPath = fileName.substring(0,fileName.lastIndexOf("/"));
			fileName=fileName.substring(fileName.lastIndexOf("/")+1);
		}
		else if(fileName!=null && fileName.lastIndexOf("\\")>0 && fileName.lastIndexOf("clear.png") == -1)
		{
			imgPath = fileName.substring(0,fileName.lastIndexOf("\\"));
			fileName=fileName.substring(fileName.lastIndexOf("\\")+1);
		}
		else
		{
			fileName = templateImageIconObj[0].className;
		}
		 createBtn.setDisabled(true);
		 profileName.trim();
		 if (this.checkBlankSpc(profileName)) {
			Ext.Msg.show({
				title : templatesAlertLbl,
				msg : templateBlankNameAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});
			createBtn.setDisabled(false);
			return;
		}
		if (this.checkSpace(profileName)) {
			Ext.Msg.show({
				title : templatesAlertLbl,
				msg : templateBlankNameAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});
			createBtn.setDisabled(false);
			return;
		}
	/*	if (profileName != null && profileName.length > 32) {
			Ext.Msg.show({
				title : templatesAlertLbl,
				msg : maxTmpltLengthAlert,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});
			createBtn.setDisabled(false);
			return;
		}*/
		if(profileName != null && profileName.indexOf(' ') == 0 )
		{
				Ext.Msg.show({
						title : templatesAlertLbl,
						msg : templateNameStartsWithSpacMsg,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
				});
						createBtn.setDisabled(false);
					return;
		}
		if (this.checkSpecialCharacter(profileName)) {
			Ext.Msg.show({
				title : templatesAlertLbl,
				msg : templateSplCharacterAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});
			createBtn.setDisabled(false);
			return;
		}
		var dIdx=-1;
		var defaultAction = publicJson['action'];
		if(defaultAction!=null && defaultAction=='loadMyTemplateListPage')
		{
			var templateBuilderlistViewObj = Ext.getCmp('dataViewId');
			if(!Ext.isEmpty(templateBuilderlistViewObj))
			{
				var existingTemplateStore = templateBuilderlistViewObj.getStore();
				var profRecord = existingTemplateStore.findRecord('templateName', profileName, 0, false, false, true);
				dIdx = existingTemplateStore.indexOf(profRecord);
			}
		}
		else
		{
			var templateBuildercomboobj = Ext.getCmp('templateListCombo');
			if(!Ext.isEmpty(templateBuildercomboobj))
			{
				var existingTemplateStore = templateBuildercomboobj.getStore();
				var profRecord = existingTemplateStore.findRecord('templateName', profileName, 0, false, false, true);
				dIdx = existingTemplateStore.indexOf(profRecord);
			}
		}
		if (dIdx > -1) {
				if(templateconfigurationObj.templateAction=='Modify')
				{
					if(previousProfileName!=profileName)
					{
						Ext.Msg.show({
						title: templatesAlertLbl,
						msg: templateExistAlertMsg,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
						});
						createBtn.setDisabled(false);
						return;
					}
				}
				else
				{
					 Ext.Msg.show({
					title: templatesAlertLbl,
					msg: templateExistAlertMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					createBtn.setDisabled(false);
					return;
				}
		}
		var templateDescription = Ext.getCmp('templateDescription').getValue();
		/*if (templateDescription != null && templateDescription.length > 32) {
			Ext.Msg.show({
				title : templatesAlertLbl,
				msg : maxTemplateDescripLengthAlert,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});
			createBtn.setDisabled(false);
			return;
		}*/
		var infraType = Ext.getCmp('infraTypeCombo').getValue();
		var componentTypes = Ext.getCmp('templateInfraElementsCombo').getValue();
	/*	if(componentTypes==null || componentTypes=='' || componentTypes=='-1')
		{
			Ext.Msg.show({
				title : templatesAlertLbl,
				msg : compTypAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});
			createBtn.setDisabled(false);
			return;
		}*/
		var actionParam='addProfile';
		if(templateconfigurationObj.templateAction!=null && templateconfigurationObj.templateAction=='Modify')
		{
			actionParam='modifyProfile';
		}
		var privateId=Ext.getCmp('customPrivateId');
		var publicId=Ext.getCmp('customPublicId');
		var shareId=Ext.getCmp('customShareId');
		var access_type='Private';
		if(!Ext.isEmpty(privateId) && privateId.pressed==true)
		{
			access_type='Private';
		}
		else if(!Ext.isEmpty(publicId) && publicId.pressed==true)
		{
			access_type='Public';
		}
		else if(!Ext.isEmpty(shareId) && shareId.pressed==true)
		{
			access_type='Share';
		}
		templateDescription=this.filterEncode(templateDescription);
		var paramsForSave = 'action='+actionParam+'&profileName=' + encodeURIComponent(profileName) + "&templateDescription="
				+ encodeURIComponent(templateDescription) + '&from=templateCreation&DBtype=multiple&access_type=' + encodeURI(access_type);
				//paramsForSave = paramsForSave + '&access_type=' + encodeURI(access_type);
				if (templateconfigurationObj.templateAction=='Modify') {
			paramsForSave = paramsForSave + '&prevTemplateName=' + encodeURIComponent(previousProfileName);
		}
		var templateViewOpt = Ext.getCmp('templateViewOpt');
		var templateOpt = templateViewOpt.getValue();
		if(!Ext.isEmpty(templateOpt))
		{
			if(templateOpt!=null && (templateOpt=='consolidated-server' || templateOpt=='singleserver'))
			{	
				var compsSingleselectCombo = Ext.getCmp('templateInfraElementsSingleCombo');
				var associatedElement=compsSingleselectCombo.getValue();
				if(associatedElement==null || associatedElement=='' || associatedElement=='-1')
				{
					Ext.Msg.show({
						title : templatesAlertLbl,
						msg : compTypAlertMsg,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
					});
					createBtn.setDisabled(false);
					return;
				}
				paramsForSave=paramsForSave+ '&infraType='+infraType +'&TemplateType='+encodeURIComponent(templateOpt)+'&associatedElements='+encodeURIComponent(associatedElement);
			}
			else
			{
				if(componentTypes==null || componentTypes=='' || componentTypes=='-1')
				{
					Ext.Msg.show({
						title : templatesAlertLbl,
						msg : compTypAlertMsg,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
					});
					createBtn.setDisabled(false);
					return;
				}
				if(componentTypes!=null && componentTypes!='')
				{
					var isAllcompTypesSelected=false;
					var isAllAndIndividualComptypeisSelected=false;
					var selectedComptpessArr=Ext.getCmp('templateInfraElementsCombo').boundList.getSelectionModel().getSelection();
					for ( var comp in selectedComptpessArr) {
						var selectedComptype = componentTypes[comp];
						if (selectedComptype != null && selectedComptype == 'ALL') {
							isAllcompTypesSelected = true;
							continue;
						}
						else
						{
							if(isAllcompTypesSelected)
							{
								isAllAndIndividualComptypeisSelected=true;
								break;
							}
						}
					}
					if(isAllAndIndividualComptypeisSelected)
					{
						Ext.Msg.show({
							title : templatesAlertLbl,
							msg : allindividualTypesAlertMsg,
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING
						});
						createBtn.setDisabled(false);
						return;
					}
					var temp =Ext.getCmp('templateInfraElementsCombo').boundList.getSelectionModel().getSelection();
					var compTypesForSave='';
					for ( var comp in componentTypes) {
						var selectedComp = componentTypes[comp];
						compTypesForSave = compTypesForSave+","+selectedComp;
					}
					if(compTypesForSave!= null && compTypesForSave.indexOf(",") == 0)
					{
						compTypesForSave = compTypesForSave.substring(1);
					}
					if(infraType!=null && compTypesForSave!=null)
					{
						var associatedElements = compTypesForSave;
						paramsForSave=paramsForSave+ '&infraType='+infraType +'&associatedElements='+encodeURIComponent(associatedElements);
					}
				}
				paramsForSave=paramsForSave+'&TemplateType='+encodeURIComponent(templateOpt);
			}
		}
		var sharedUsers='';
		var readWriteAccessUsers='';
		if (access_type == 'Share') {
			var sharedUsersArr=Ext.getCmp('customCheckComp').getSelectionModel().getSelection();
			for ( var user in sharedUsersArr) {
				var record1=sharedUsersArr[user];
				sharedUsers=sharedUsers+","+record1.get('valueField');
				var readWriteAccess=record1.get('readWrite');
				if(readWriteAccess!=null && readWriteAccess==true)
				{
					readWriteAccessUsers=readWriteAccessUsers+","+record1.get('valueField');
				}
			}
			if (sharedUsers==null || sharedUsers=='') {
				Ext.Msg.show({
					title : templatesAlertLbl,
					msg : dashboardSharingAlertMsg,
					buttons : Ext.MessageBox.OK,
					icon : Ext.MessageBox.WARNING
				});
				createBtn.setDisabled(false);
				return;
			}
			if(sharedUsers!=null && sharedUsers.indexOf(",")==0)
				sharedUsers=sharedUsers.substring(1);

			if(readWriteAccessUsers!=null && readWriteAccessUsers.indexOf(",")==0)
				readWriteAccessUsers=readWriteAccessUsers.substring(1);

			paramsForSave = paramsForSave + "&s_user=" + encodeURIComponent(sharedUsers);

			if(readWriteAccessUsers!=null && readWriteAccessUsers.length>0)
			{
				paramsForSave = paramsForSave + "&allowed_user_to_edit_shared_ashboard="+encodeURIComponent(readWriteAccessUsers);
			}
		}
		if(fileName!=null)
		{
			if(imgPath!=null && !imgPath.endsWith("/final/images/"+strSkin+""))
			{
				fileName = "Custom:"+fileName;
				paramsForSave = paramsForSave + "&imgIcon=" + encodeURIComponent(fileName);
			}
			else if(imgPath == null)
			{
				fileName = "Default:"+fileName;
				paramsForSave = paramsForSave + "&imgIcon=" + encodeURIComponent(fileName);
			}
		}
		if(isMonitorHome)
		{
			paramsForSave=paramsForSave+"&setMonitorHome=true";
		}
	/*	var currentwidgets = Ext.getCmp('templateNumField').getValue();
		var minwidgetsForlayout = Ext.getCmp('templateNumField').hiddenMinVal;
		var layoutName = tempSelectedLayout; */
		/*if (currentwidgets < minwidgetsForlayout) {
			Ext.Msg.show({
				title : templatesAlertLbl,
				msg : 'minimum  '+minwidgetsForlayout+'  widgets required for this Layout. '+preferCustomLayoutAlert,
				buttons : Ext.Msg.YESNO,
				icon : 'iconConfirmation',
				fn:function(buttonId)
				{
					if(buttonId == 'yes')
					{
						layoutName = 'Custom';
						currentwidgets = 0;
						paramsForSave = paramsForSave + "&layout="+encodeURIComponent(layoutName) + "&widgetsCount="+currentwidgets;
						Ext.Ajax.request({
						url : '/final/servlet/com.eg.EgTemplateBuilderController',
						method : 'POST',
						params : paramsForSave + '&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
						scope : this,
						success : function(response) {
						var jsonText = response.responseText;
						if (jsonText != null && jsonText != '') {
						var jsonData = Ext.decode(jsonText);
						if (jsonData['update'] == 'success') {
							var viewUrl = "/final/servlet/com.eg.EgMonitorRequestDispatcher?comesFrom=templateBuilder&action=loadTemplateConfigView&profileName="+encodeURIComponent(profileName);
							this.goToPage(viewUrl,'loadTemplateConfigView');
											}
									}
						},
						failure : function(response, opts) {
								createBtn.setDisabled(false);
							}
						});
					}
					else
					{
						createBtn.setDisabled(false);
						return;
					}
				}
			});
		}*/
		//else
		//{
		//	paramsForSave = paramsForSave + "&layout="+encodeURIComponent(layoutName) + "&widgetsCount="+currentwidgets;
			var templateForHomePage=Ext.getCmp('templateForHomePage').getValue();
			var useThisTemplateForHomePage='no';
			if(templateForHomePage!=null && templateForHomePage==true)
			{
				useThisTemplateForHomePage='yes';
			}
			paramsForSave=paramsForSave+'&useThisTemplateForHomePage='+encodeURIComponent(useThisTemplateForHomePage);
			Ext.getCmp('custom_layouts').defaultState();
			Ext.Ajax.request({
						url : '/final/servlet/com.eg.EgTemplateBuilderController',
						method : 'POST',
						params : paramsForSave + '&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
						scope : this,
						success : function(response) {
						var jsonText = response.responseText;
						if (jsonText != null && jsonText != '') {
						var jsonData = Ext.decode(jsonText);
						if (jsonData['update'] == 'success') {
							var viewUrl = "/final/servlet/com.eg.EgMonitorRequestDispatcher?comesFrom=templateBuilder&action=loadTemplateConfigView&profileName="+encodeURIComponent(profileName);
							this.goToPage(viewUrl,'loadTemplateConfigView');
													}
											}
										},
						failure : function(response, opts) {
								createBtn.setDisabled(false);
							}
						});
		//}
	},
	showIconLibrary:function(){
		Ext.create('TemplateBuilder.view.IconLibrary').show();
	},
	loadCompsForSelection : function(combo)
	{
		var templateOpt = combo.getValue();
		if(!Ext.isEmpty(templateOpt))
		{
			var compsSingleselectCombo = Ext.getCmp('templateInfraElementsSingleCombo');
			var compsMultiselectComo = Ext.getCmp('templateInfraElementsCombo');
			var multiSearchCompType = Ext.getCmp('multiSearchCompType');
			var infraTypeCombo = Ext.getCmp('infraTypeCombo');
			if(templateOpt=='cross-application')
			{
			/*	var availCompTypes = jsonData['templateComponentAccessDetails']['availElements'];
				var selectedelements = jsonData['templateComponentAccessDetails']['selectedElements'];
				 if(availCompTypes!=null && !Ext.isEmpty(availCompTypes)){
					 compsMultiselectComo.getStore().loadRawData(availCompTypes);
				 }
				 if(selectedelements!=null && !Ext.isEmpty(selectedelements)){
					 compsMultiselectComo.setValue(selectedelements);
				 }*/
				 Ext.getCmp('templateCompExpand').show();
 				 compsSingleselectCombo.hide();
				 infraTypeCombo.setDisabled(false);
				 compsMultiselectComo.show();
				 multiSearchCompType.show();
				 //Ext.getCmp('compTypeFilterComboObj').show();
				var compTypeFilterComboObject = Ext.getCmp('compTypeFilterComboObj');
				if(!Ext.isEmpty(compTypeFilterComboObject))
				{
					compTypeFilterComboObject.show();
				}
 				 //Ext.getCmp('excludeCompLbl').hide();
				var excludeCompLblObj = Ext.getCmp('excludeCompLbl');
				if(!Ext.isEmpty(excludeCompLblObj))
				{
					excludeCompLblObj.hide();
				}
			}
			else
			{
				var compsSingleselectCombo = Ext.getCmp('templateInfraElementsSingleCombo');
				/*if(!Ext.isEmpty(compsSingleselectCombo))
				{
					var availCompTypes = jsonData['templateComponentAccessDetails']['availElements'];
					var selectedelements = jsonData['templateComponentAccessDetails']['selectedElements'];
					 if(availCompTypes!=null && !Ext.isEmpty(availCompTypes)){
						 compsSingleselectCombo.getStore().loadRawData(availCompTypes);
					 }
					 if(selectedelements!=null && !Ext.isEmpty(selectedelements)){
						 compsSingleselectCombo.setValue(selectedelements);
					 }
				}*/
				compsMultiselectComo.hide();
				 Ext.getCmp('templateCompExpand').hide();
				 multiSearchCompType.hide();
 				 infraTypeCombo.setValue('components');
 				 infraTypeCombo.setDisabled(true);
				 compsSingleselectCombo.show();

				var compTypeFilterComboObject = Ext.getCmp('compTypeFilterComboObj');
				if(!Ext.isEmpty(compTypeFilterComboObject))
				{
					compTypeFilterComboObject.hide();
				}
				var excludeCompLblObj = Ext.getCmp('excludeCompLbl');
				if(!Ext.isEmpty(excludeCompLblObj))
				{
					excludeCompLblObj.show();
				}
				 
			}
		}
	},
	addWidgetFromWidgetGallery : function(widgetName,template_name,displayType,widgetBtnId)
	{
		return addWidgetFromWidgetGallery(widgetName,template_name,displayType,widgetBtnId,false,'');
	},
	addWidgetFromWidgetGallery : function(widgetName,template_name,displayType,widgetBtnId,updateWidgetGallery,widgetTabType)
	{
		var dynBlkId = '';
		maxBlockId = parseInt(maxBlockId);
		maxBlockId = maxBlockId+1;
		var blockTitle=displayType;
		var isStaticwidget=false;
		var isDefWidget=true;
		if (widgetName != null && widgetName == "Alarms") {
			widgetName="currentalarms";
			dynBlkId = "currentalarms";
			displayType=widgetName;
			blockTitle=alertsTitle;
			updateWidgetGallery=false;
			isStaticwidget=true;
		}
		else if (widgetName != null && widgetName == "TIER_HEALTH") {
			widgetName="tierhealth";
			dynBlkId = "tierhealth";
			blockTitle=tierHealthTitle;
			displayType=widgetName;
			updateWidgetGallery=false;
			isStaticwidget=true;
		
		} else if (widgetName != null && widgetName == "SERVICE_HEALTH") {
			widgetName = "servicehealth";
			dynBlkId = "servicehealth";
			blockTitle=healthPieChartTitle;
			displayType=widgetName;
			updateWidgetGallery=false;
			isStaticwidget=true;
		}
		else if (widgetName != null && widgetName == "NETWORK_HEALTH") {
			lastvisible='';
			widgetName = "networkhealth";
			dynBlkId = "networkhealth";
			blockTitle=networkhealthPieChartTitle;
			displayType=widgetName;
			updateWidgetGallery=false;
			isStaticwidget=true;
		}
		 else if (widgetName != null && widgetName == "news") {
			dynBlkId = "news";
			blockTitle=newsTitle;
			displayType=widgetName;
			updateWidgetGallery=false;
			isStaticwidget=true;
		}
		else if (widgetName != null && widgetName == "weather") {
			dynBlkId = "weather";
			blockTitle=weatherTitle;
			displayType=widgetName;
			updateWidgetGallery=false;
			isStaticwidget=true;
		}
		else if (widgetName != null && widgetName == "USEREXPERIENCE") {
			dynBlkId = 'USEREXPERIENCE';
			blockTitle="User Experience - RUM";
			displayType='mapwidget';
			updateWidgetGallery=false;
			isStaticwidget=true;
		}
		else if (widgetName != null && widgetName == "Citrix-USERLATENCY") {
			dynBlkId = 'Citrix-USERLATENCY';
			blockTitle="User Experience - Citrix";
			displayType='mapwidget';
			updateWidgetGallery=false;
			isStaticwidget=true;
		}
		else
		{
			if (widgetName != null && widgetName == "VMAlerts") {
				isDefWidget=true;
			}
			else
			{
				isDefWidget=false;
			}
			dynBlkId=widgetName;
			blockTitle=widgetName;
		}
		
		var meC = this;
		var sizeX=4;
		var sizeY=5;
		if (displayType != null && (displayType == "CombinedTimelineChart" || displayType == "TimelineChart" || displayType == "areaChart"  || displayType=='combinationChart' || displayType == "TimelineChart" || displayType == "BarChart")) {
			sizeX=4;
		} else if (displayType != null && (displayType == "TabularView" || displayType == "DDTable")) {
			sizeX=4;
		} else if (displayType != null && (displayType == "dialChart" || displayType == "digitalChart")) {
			sizeX=2;
		} else if (displayType != null && (displayType == "pieChart" || displayType == "activityChart")) {
			sizeX=4;
			sizeY=6;
		}
		else if (displayType != null && displayType == "liveMeasuresBox") {
			sizeX=4;
		}
		else if(displayType != null && displayType=='VMAlerts')
		{
			sizeX=4;
			sizeY=5;
		}
		else if (displayType != null && (displayType == "CombinedTimelineChart" || displayType == "TimelineChart" || displayType == "areaChart" || displayType == "combinationChart" || displayType == "BarChart")) {
				sizeY=6;
		}
		else if (displayType != null && displayType == "weather" || displayType == "networkhealth") {
			sizeX=4;
			sizeY=9;
		}
		else if (displayType != null && displayType == "mapwidget") {
			sizeX=5;
			sizeY=7;
		}
		else if (displayType != null && (displayType == "currentalarms" || displayType == "tierhealth" || displayType == "servicehealth" || displayType == "news")) {
			sizeX=4;
			sizeY=6;
		}
		//var rmvBtnObj=Ext.get(widgetBtnId+"_remove");
		//var addBtnObj=Ext.get(widgetBtnId+"_add");
		var newWidget = {
							'x'  :   0,
							'y'  :   0,
							'width'  :   sizeX,
							'height'  :   sizeY,
							'id':'block'+maxBlockId,
							'widgetType':'',
							'noResize':false,
							'internalId' : '',
							'widget_name' : 'block'+maxBlockId,
							 'widgetNum' : 'Widget '+maxBlockId,
							'isDefaultWidget' : isDefWidget,
							'autoPosition'  :  true
		};
		Ext.getCmp('gridstackpanelObj')._addWidget(newWidget,'addWidget',blockTitle, '', '');
		var templateLayoutObj = Ext.getCmp('templateLayoutObj');
		var templateName = templateLayoutObj.profileName;
		widgetName=meC.filterEncode(widgetName);
		var paramsForAddWidget='action=addWidgetFromWidgetGallery&profileName='+encodeURIComponent(templateName)+'&widgetName='+encodeURIComponent(widgetName)+'&widgetId='+encodeURIComponent(dynBlkId)+"&displayType="+encodeURIComponent(displayType)+"&srcTemplateName="+encodeURIComponent(template_name);
		var gridStackObj=this.getGridstackpanel();
		var posStrVal=gridStackObj.getTBPanelPositions();
		var blockPosMatch = 'block'+maxBlockId+':'+dynBlkId;
		if(posStrVal!=null && posStrVal!='')
		{
			paramsForAddWidget=paramsForAddWidget+'&layoutConfig='+encodeURIComponent(posStrVal)+'&blockPosMatch='+encodeURIComponent(blockPosMatch);
		}
		var gridStackPnlArr = gridStackObj._serialization();
		var numberOfWidgets = gridStackPnlArr.length;
		paramsForAddWidget=paramsForAddWidget+"&gridsterLength="+ encodeURIComponent(numberOfWidgets);
		gridStackObj=null;
		delete gridStackObj;
	/*	if(!Ext.isEmpty(addBtnObj))
		{
			addBtnObj.hide();
		}
		if(!Ext.isEmpty(rmvBtnObj))
		{
			rmvBtnObj.show();
		}*/
			var addBtnObj=Ext.get(widgetBtnId+"_addBtn");
		if(!Ext.isEmpty(addBtnObj))
		{			
			if(isStaticwidget)
			{
				addBtnObj.removeCls('addToWidgetBtn');
				addBtnObj.addCls('widgetRemoveButton');
				//addBtnObj.dom.innerHTML='Remove To Dashboard';
			}
			else
			{
				addBtnObj.removeCls('myWidgetTableBtn_add');
				addBtnObj.addCls('myWidgetTableBtn_added');
				addBtnObj.dom.innerHTML='<img class="stateIconWhiteHealthy" src="../images/Light/stateIconsWhite.png">';
			}
		}
		var meC=this;
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.EgTemplateBuilderController',
			method: 'POST',
			params: paramsForAddWidget,
			scope: this,
			success: function(response) {
				var configPanl = Ext.getCmp('block'+maxBlockId);
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				configPanl.isDefaultWidget=isDefWidget;
				if(updateWidgetGallery)
				{
					var widgetGalleryWinObj=Ext.getCmp('addWidgetwindowNew');
					if(!Ext.isEmpty(widgetGalleryWinObj))
					{
						widgetGalleryWinObj.updateWidgetGalleryData(widgetTabType,'');
					}
				}
//				rmvBtnObj.dom.setAttribute('widgetintid',dynBlkId);
				meC.showDataForBlock(configPanl,jsonData,dynBlkId);
				/* Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : widgetAddedAlertMsg,
					buttons : Ext.MessageBox.OK,
					icon : Ext.MessageBox.WARNING
				});*/
				meC.flashMsgBox(widgetAddedAlertMsg);
			}
		});
	},
	flashMsgBox:function(msg){
	Ext.create('Ext.window.Window', {
				floating:true,
				plain:true,
				ui:'flash-msg',
				resizable:false,
				frame:false,
				header:false,
				border:false,
				closeAction:'destroy',
				bodyPadding:10,
				html:'<div style="margin-top:10px;">'+msg+'</div>',
				//width: 159,
			  height:53,
			listeners:{
				show:function(win){
					win.getEl().setOpacity(0);
					win.getEl().fadeIn({duration: 1000,callback:function(){
						Ext.defer(function(){
							win.hide();
						},5000)
					}});
					  win.hide();
				},
				hide : function(win) {
                    win.getEl().fadeOut({duration: 1000, callback: function() {
                        win.close();
                    }});
            }
			}
			}).show();
	},
	deleteTemplateWidget : function(widgetInternalId,widgetBtnId,templateName)
	{
		return deleteWidget(widgetInternalId,widgetBtnId,templateName,false,'');
	},
	deleteTemplateWidget : function(widgetInternalId,widgetBtnId,templateName,updateWidgetGallery,widgetTabType)
	{
		var meC=this;
		var isStaticwidget=false;
		var mePortlet=Ext.getCmp(widgetInternalId);
		var isStaticwidget=false;
		if (widgetInternalId != null && widgetInternalId == "Alarms") {
			widgetInternalId = "currentalarms";
			updateWidgetGallery=false;
			isStaticwidget=true;
		} else if (widgetInternalId != null && widgetInternalId == "TIER_HEALTH") {
			widgetInternalId = "tierhealth";
			updateWidgetGallery=false;
			isStaticwidget=true;
		} else if (widgetInternalId != null && widgetInternalId == "SERVICE_HEALTH") {
			widgetInternalId = "servicehealth";
			updateWidgetGallery=false;
			isStaticwidget=true;
		}
		else if (widgetInternalId != null && widgetInternalId == "NETWORK_HEALTH") {
			widgetInternalId = "networkhealth";
			updateWidgetGallery=false;
			isStaticwidget=true;
		}
		 else if (widgetInternalId != null && widgetInternalId == "news") {
			widgetInternalId = "news";
			updateWidgetGallery=false;
			isStaticwidget=true;
		}
		else if (widgetInternalId != null && widgetInternalId == "weather") {
			widgetInternalId = "weather";
			updateWidgetGallery=false;
			isStaticwidget=true;
		}
		Ext.Msg.show({
			title: templatesAlertLbl,
			msg: deleteBlockMsg + '?',
			buttons: Ext.Msg.YESNO,
			width:300,
			icon:'iconConfirmation',
			fn: function(buttonId) {
				if (buttonId == "yes") {
					var paramsForDeleteBlock = 'action=removeWidgetFromWidgetGallery&profileName=' + Ext.getCmp('templateLayoutObj').profileName + '&keyToDelete=' + widgetInternalId;
					Ext.defer(function(){
						var gridStackObj1=Ext.getCmp('gridstackpanelObj');
						var pnlPositions=gridStackObj1.getTBPanelPositions();
						var gridStackPnlArr = gridStackObj1._serialization();
						var numberOfWidgetsVal = gridStackPnlArr.length;
						var numberOfWidgets=9;
						if(!Ext.isEmpty(numberOfWidgetsVal))
						{
							numberOfWidgets=parseInt(numberOfWidgetsVal)-1;
						}
						paramsForDeleteBlock=paramsForDeleteBlock+"&layoutConfig="+encodeURIComponent(pnlPositions)+"&gridsterLength="+ encodeURIComponent(numberOfWidgets);
						var addBtnObj=Ext.get(widgetBtnId+"_addBtn");
						if(!Ext.isEmpty(addBtnObj))
						{
							if(isStaticwidget)
							{
								addBtnObj.removeCls('widgetRemoveButton');
								addBtnObj.addCls('addToWidgetBtn');
								//addBtnObj.dom.innerHTML='+ Add to Dashboard';
							}
							else
							{
								addBtnObj.removeCls('myWidgetTableBtn_added');
								addBtnObj.addCls('myWidgetTableBtn_add');
								//addBtnObj.dom.innerHTML='Add';
							}
						}
						Ext.Ajax.request({
						url: '/final/servlet/com.eg.EgTemplateBuilderController',
						method: 'POST',
						params: paramsForDeleteBlock,
						scope: this,
						success: function(response) {
							//freePnlObj.close();
							var jsonText = response.responseText;
								if (jsonText != null && jsonText != '') {
									var jsonDta = Ext.decode(jsonText);
									if(jsonDta!=null && !Ext.isEmpty(jsonDta))
									{
										var configData = jsonDta["configData"];
										if(configData!=null && !Ext.isEmpty(configData))
										{
											widgetsforTemplateView = configData["maxWidgetsForTemplate"];
											widgetsforTemplateView = parseInt(widgetsforTemplateView);
											maxBlockId = configData["maxBlockId"];
											maxBlockId = parseInt(maxBlockId);
										}
										var deletedWidgetId=jsonDta["deletedWidgetId"]
										var gridStackObj=meC.getGridstackpanel();
										gridStackObj._removeWidget(deletedWidgetId);
										if(updateWidgetGallery)
										{
											var widgetGalleryWinObj=Ext.getCmp('addWidgetwindowNew');
											if(!Ext.isEmpty(widgetGalleryWinObj))
											{
												widgetGalleryWinObj.updateWidgetGalleryData(widgetTabType,'');
											
											}
										}
										//var rmvBtnObj=Ext.get(widgetBtnId+"_remove");
										//var addBtnObj=Ext.get(widgetBtnId+"_add");
										//if(!Ext.isEmpty(rmvBtnObj))
										//{
										//	rmvBtnObj.hide();
										//}
										//if(!Ext.isEmpty(addBtnObj))
									//	{
										//	addBtnObj.show();
									//	}
									}
								}
							}
						}
					)},200);
				}
				else
				{
					mePortlet=null;
					delete mePortlet;
				}
			}
		});
	},
	 filterEncode:function(text)
	{
		//['%;()=]
		var filterEncodeChar = ['[',']','(',')','=','%'];
		var filterDecodeText = ['|lsbr|','|rsbr|','|lbr|','|rbr|','|eq|','|per|'];
		try
		{
			if(text != null && text != undefined && !Ext.isEmpty(text))
			{
				for(var a in filterEncodeChar)
				{
					var encode_char = filterEncodeChar[a];
					var decode_char = filterDecodeText[a];
					do
					{
						text=text.replace(encode_char,decode_char);
					}
					while (text.indexOf(encode_char)>-1);
				}
			}
		}
		catch (e)
		{
		}
		return text;
	},
	createExcludeIncludeSettingsLayout: function ()	  
	{
			var defaultExcludeIncludeSettings  = [
				{	
					xtype:'fieldcontainer',
					layout:'hbox',
					id:'excludeIncludeOpt',
					width: 380,
					name:'excludeIncludeOpt',
					defaultType:'textfield',
					margin : '0 0 0 10',
					labelAlign:'top',
					labelSeparator:'',
					flex:1,
					defaults:{
						margin : '0 0 0 0',
					},
					items:[
						{
							xtype: 'scrollcombo',
							id : 'serverdescripCombo',
							name : 'serverdescripCombo',
							cls: 'dropdown',
							fieldLabel: ExcluedIncludeLbl,
							width: 150,
							labelSeparator:'',
							labelAlign:'top',
							margin:'0 10 10 0',
							store: Ext.create('Ext.data.Store', {
								fields: ['displayField','valueField'],
								data: []
							}),
							editable:false,
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							value : notApplicable	 ,
							listeners :
							{
								'select' : function(combo) {
									tempBuilderApp.getController("Main").onTypeCombochange(combo);
								}
							}
						},{
							xtype: 'scrollcombo',
							id : 'compTypeCombo',
							name : 'compTypeCombo',
							cls: 'dropdown',
							labelAlign: 'top',
							labelSeparator:'',
							fieldLabel: compType,
							width: 210,
							margin:'0 0 10 10',
							padding: 0,
							store: Ext.create('Ext.data.Store', {
								fields: ['displayField','valueField'],
								data: []
							}),
							editable:false,
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							value : notApplicable,
							listeners :
							{
								'select' : function(combo) {
									tempBuilderApp.getController("Main").loadComponentsForCompType(combo);
								}
							}
						}
					]},
						{
							xtype: 'fieldcontainer',
							layout:'hbox',
							width:430,
							margin:'0 0 10 0',
							items:[{
										xtype: 'scrollcombo',
										id : 'testComboValue',
										name : 'testComboValue',
										cls: 'dropdown',
										labelAlign: 'top',
										labelSeparator:'',
										hidden:true,
										fieldLabel: testLbl,
										width: 200,
										margin:'0 10 10 10',
										store: Ext.create('Ext.data.Store', {
											fields: ['displayField','valueField'],
											data: []
										}),
										editable:false,
										displayField: 'displayField',
										valueField: 'valueField',
										queryMode: 'local',
										value : notApplicable,
										listeners :
										{
											'select' : function(combo) {
											tempBuilderApp.getController("Main").loadDescForSelectedTest(combo);
											}
										}
								}]
							},
							{
                                xtype: 'radiogroup',
                                width: 200,
                                column: 2,
                                labelWidth: 135,
                                height: 20,
								margin:'0 10 10 10',
								fieldLabel: 'Action on descriptors',
								labelAlign:'top',
                                id: 'excIncludeRadioOpt',
                                name: 'descRadioOpt',
                                hidden: true,
                                items: [{
                                    boxLabel: 'Exclude',
                                    name: 'descOpt',
                                    inputValue: 'Exclude',
                                    cls: 'radiobt'
                                }, {
                                    boxLabel: 'Include',
                                    name: 'descOpt',
                                    inputValue: 'Include',
                                    cls: 'radiobt'
                                }],
								listeners: {
									  change: function(field, newValue, oldValue) {
										var value = newValue.descOpt;
																				
										var descriptorItemSelObj=Ext.getCmp('descriptorItemSel');
										var updateExcludeIncludeObj=Ext.getCmp('updateExcludeInclude');
										var descMultiselectObj=Ext.getCmp('descMultiselect');

										if(value!= null && value=='Exclude')
										{
											
											if(!Ext.isEmpty(descMultiselectObj))
											{
												if(descMultiselectObj.getStore().getAt(0).data.valueField == 'allDescriptors')
												{
													descMultiselectObj.getStore().removeAt(0);

													descMultiselectObj.getStore().insert(0, {
														displayField : 'None',
														valueField :  'None'
													});
													descMultiselectObj.resumeEvents();
												}
												else if(descMultiselectObj.getStore().getAt(0).data.valueField != '-1')
												{
													descMultiselectObj.getStore().insert(0, {
														displayField : 'None',
														valueField :  'None'
													});
													descMultiselectObj.resumeEvents();
												}
											}
											if(!Ext.isEmpty(updateExcludeIncludeObj))
											{
												updateExcludeIncludeObj.setText(screenLabelsObj['Exclude']);
											}
										}
										else if(value!= null && value=='Include')
										{
											if(!Ext.isEmpty(descMultiselectObj))
											{
												if(descMultiselectObj.getStore().getAt(0).data.valueField == 'None')
												{
													descMultiselectObj.getStore().removeAt(0);

													if(descMultiselectObj.getStore().getRange().length > 1)
													{
														descMultiselectObj.getStore().insert(0, {
															displayField : 'All Descriptors',
															valueField : 'allDescriptors'
														});
														descMultiselectObj.resumeEvents();
													}
												}
												else if(descMultiselectObj.getStore().getAt(0).data.valueField != '-1' && descMultiselectObj.getStore().getRange().length > 1)
												{
													descMultiselectObj.getStore().insert(0, {
														displayField : 'All Descriptors',
														valueField : 'allDescriptors'
													});
													descMultiselectObj.resumeEvents();
												}
											}
											if(!Ext.isEmpty(updateExcludeIncludeObj))
											{
												updateExcludeIncludeObj.setText(screenLabelsObj['Include']);
											}
										}
										
									}
								}
                            },
							{
								xtype: 'fieldcontainer',
								layout:'vbox',
								width:430,
								cls:'templateBuilderItemSelector addRemove',
								margin:'0 0 10 0',
								items:[
									{
											xtype: 'itemselector',
											cls:'itemselector ',
											id :'compFilterItmSel',
											name :'compFilterItmSel',
											buttons: ['add', 'remove'],
											buttonsText: {
												add: screenLabelsObj['Add'],
												remove: screenLabelsObj['Remove']
											},
											imagePath: '/final/images/',
											multiSelect: true,
											margin:'0 0 10 10',
											height: 180,
											width: 420,
											scroll : true,
											toTitle:unManagedItem1,
											fromTitle:managedItem1,
											editable:false,
											displayField: 'displayField',
											valueField: 'valueField',
											store: Ext.create('Ext.data.Store', {
												fields: ['displayField','valueField'],
												data: []
											}),
											hidden: false
								},
								{   xtype: 'container',
									margin:'0 0 10 10',
									id:'descriptorItemSel',
									hidden: true,
									settedValues:'',
									items : [
									{
										xtype: 'label',
										cls:'x-form-item',
										id: 'multiselectLbl',
										name: 'multiselectLbl',
										labelAlign:'top',
										text:'Descriptors',
										labelClsExtra: 'icon-properties item-label-icon',
									},
									{	
										xtype:'container',
										height: 160,
										width: 195,
										layout:{type:'vbox',align:'stretch'},
										cls:'darkbox',
										margin: '5 5 0 0',
										id:'MultiSelectOuterBox',
										items:[{
											xtype:'trigger',
											margin : '5',
											id : 'SearchTextBox',
											name : 'SearchTextBox',
											width : 228,
											cls: 'whitedropdown_search',
											emptyText : 'search',
											controltStoreObj : null,
											listeners :
											{
												'change' : function(triggerField, newValue, oldValue, eOpts) {
													var me = this;
													var controlObjStore = me.controltStoreObj;
													if(controlObjStore==null)
													{
														me.controltStoreObj = Ext.getCmp('descMultiselect').getStore();
														controlObjStore=me.controltStoreObj;
													}
													if(newValue=="*")
													{
														controlObjStore.clearFilter();
													}
													else
													{
														if(newValue.lastIndexOf("*")==(newValue.length-1))
														{
															newValue = newValue.substr(0,(newValue.length-1));
														}
														controlObjStore.clearFilter();
														if (newValue) {
															var matcher = new RegExp(Ext.String.escapeRegex(newValue), "i");
															controlObjStore.filter({
																filterFn: function(record) {
																	return matcher.test(record.get('displayField')) ;
																}
															});
														}
													 triggerField.focus();
													}
												 }
											}},
											{
												xtype: 'multiselect',
												id: "descMultiselect",
												baseCls: 'egmultiselect',
												name: "descMultiselect",
												multiSelect: true,
												height: 130,
												width: 195,
												store: Ext.create('Ext.data.Store', {
													fields: ['displayField', 'valueField'],
													data: []
												}),
												listConfig: {
													id: 'ListC1',
													simpleSelect: true
												},
												editable: false,
												displayField: 'displayField',
												valueField: 'valueField',
												queryMode: 'local'
										}]
									}]
								},
								{
									xtype : 'button',
										buttonAlign:'center',
										text : screenLabelsObj['Exclude']+'&#47;'+screenLabelsObj['Include'],
										margin:'0 0 0 10',
										id:'updateExcludeInclude',
										cls : 'buttonNew small',
										buttonAlign : 'center'	, 
										listeners: {
											click: function(){
													tempBuilderApp.getController("Main").saveExcludeIncludeWidgetConfig();
											}
										}
							}]	
					}]
			return 	 defaultExcludeIncludeSettings;
	},
	filterEncode: function(text)
	{
		//['%;()=]
		var filterEncodeChar = ['[',']','(',')','=','%','\'','&'];
		var filterDecodeText = ['|lsbr|','|rsbr|','|lbr|','|rbr|','|eq|','|per|','|squot|','|ampsnd|'];
		try
		{
			if(text != null && text != undefined && !Ext.isEmpty(text))
			{
				for(var a in filterEncodeChar)
				{
					var encode_char = filterEncodeChar[a];
					var decode_char = filterDecodeText[a];
					do
					{
						text=text.replace(encode_char,decode_char);
					}
					while (text.indexOf(encode_char)>-1);
				}
			}
		}
		catch (e)
		{
		}
		return text;
	},
	changePreDefinedLayout :  function(selectedLayout)
	{
		var layoutConfigArr=[];
		if(publicJson!=null && publicJson.hasOwnProperty('templateConfigDetails'))
		{
			var selectedLayoutConfig='';
			var isSelectedLayoutConfigFound=false;
			if(!Ext.isEmpty(publicJson['templateConfigDetails']) && publicJson['templateConfigDetails'].hasOwnProperty('preDefinedLayouts'))
			{
				var preDefinedLayoutsConfig=publicJson['templateConfigDetails']['preDefinedLayouts'];
				if(!Ext.isEmpty(preDefinedLayoutsConfig))
				{
					for(var pIdx in preDefinedLayoutsConfig)
					{
						var layoutConfigObj=preDefinedLayoutsConfig[pIdx];
						if(!Ext.isEmpty(layoutConfigObj) && layoutConfigObj['valueField']==selectedLayout)
						{
							isSelectedLayoutConfigFound=true;
							selectedLayoutConfig=layoutConfigObj['layoutSettings']
							break;
						}
					}
				}
				if(isSelectedLayoutConfigFound)
				{
					var meC = this;
					var mainPageView = this.getMain();
					Ext.getCmp('templateMainPanel').getHeader().show();

					var templateconfigurationObj=this.getCreateTemplate();
					if (Ext.isEmpty(templateconfigurationObj))
						templateconfigurationObj = Ext.widget('createTemplate');

					if(templateconfigurationObj!=null && !Ext.isEmpty(templateconfigurationObj))
					{
						templateconfigurationObj.close();
					}
					publicJson['action'] = 'loadTemplateConfigView';
					var isShared = publicJson['templateConfigDetails']['isSharedTemplate'];
					if(isShared!=null && isShared == 'true')
					{
						isShared = true;
					}
					else
					{
						isShared = false;
					}
					var isDefault = publicJson['templateConfigDetails']['isDefaultTemplate'];

					if(isDefault!=null && isDefault == 'true')
					{
						isDefault = true;
					}
					else
					{
						isDefault = false;
					}
					var gridStackObj=Ext.getCmp('gridstackpanelObj');//_'+profName);
					if(!Ext.isEmpty(gridStackObj))
					{
						gridStackObj._removeAllWidget();
					}
					Ext.getCmp('listPageHeaderMenu').hide();
					Ext.getCmp('searchTemplate').hide();
					mainPageView.remove('templateBuilderListPageView',true);
					mainPageView.remove('dataViewId',true);
					mainPageView.clearManagedListeners();
					mainPageView.removeAll('dataViewId',true);
					mainPageView.remove('templateLayout',true);
					mainPageView.remove('templateLayoutObj',true);
					Ext.EventManager.removeAll('templateLayoutObj');
					Ext.EventManager.removeAll('templateBuilderListPageView');
					Ext.EventManager.removeAll('dataViewId');
					mainPageView.add({
						xtype : 'templateLayout',
						profileName : publicJson['templateConfigDetails']['profileName'],
						isSharedTemplate : isShared,
						isDefaultTemplate : isDefault,
						layoutchoosen: publicJson['templateConfigDetails']['layout']
					});
					Ext.getCmp('templateListCombo').show();
					Ext.getCmp('templateConfigTools').hide();
					var templateConfigTools=this.getTemplategeneralsettings();
					if(publicJson['templateConfigDetails']['isSharedTemplate'] == "false" && !isMonitorHome)
					{
						if(!isDefault)
						{
							Ext.getCmp('templateConfigTools').show();
						}
					}
					else
					{
						Ext.getCmp('templateConfigTools').hide();
					}
					var templateTools = this.getTemplatetools();
					templateTools.show();
					templateTools.getComponent('listBtnContainer').show();
					templateTools=null;
					delete templateTools;
					this.loadTemplateListCombo(publicJson['templateComboList'],publicJson['templateConfigDetails']['profileName']);
					mainPageView.doLayout();
					//this.loadTemplateConfigurationView();
					this.loadTemplateConfigurationView('changePreDefinedLayout',selectedLayout,selectedLayoutConfig);

					var paramsForSave='&action=savePredefinedTemplateLayout&profileName=' + encodeURIComponent(publicJson['templateConfigDetails']['profileName'])
									+ '&predef_layout=' + encodeURIComponent(selectedLayout);

					var gridStackObj=Ext.getCmp('gridstackpanelObj');
					var posStrVal=gridStackObj.getTBPanelPositions();
					if(posStrVal!=null && posStrVal!='')
					{
						paramsForSave=paramsForSave+'&layoutConfig='+encodeURIComponent(posStrVal);
					}
					Ext.Ajax.request({
							url : '/final/servlet/com.eg.EgTemplateBuilderController',
							method : 'POST',
							params : paramsForSave,
							scope : this,
							success : function(response) {
								var jsonText = response.responseText;
									if (!Ext.isEmpty(jsonText)) {
									}
							}
						});
				}
			}
		}
	},
	saveCustomColumn : function(columnCount,winObj) {
		var meC = this;
		var mainPageView = this.getMain();
	//	var profileName = Ext.getCmp('templateLayoutObj').profileName;
		var gridStackObj=this.getGridstackpanel();
		winObj.setDisabled(true);
		Ext.Ajax.request({
			url : '/final/servlet/com.eg.EgTemplateBuilderController',
			method : 'POST',
			params : '&action=saveCustomLayoutColumn&profileName=' + encodeURIComponent(publicJson['templateConfigDetails']['profileName'])
					+ '&column=' + encodeURIComponent(columnCount),
			scope : this,
			success : function(response) {
				var jsonText = response.responseText;
				if (jsonText != null && jsonText != '') {
					// var jsonData = Ext.decode(jsonText);
					publicJson = Ext.decode(jsonText);

					var templateconfigurationObj=this.getCreateTemplate();
					if (Ext.isEmpty(templateconfigurationObj))
						templateconfigurationObj = Ext.widget('createTemplate');

					if(templateconfigurationObj!=null && !Ext.isEmpty(templateconfigurationObj))
					{
						templateconfigurationObj.close();
					}
					publicJson['action'] = 'loadTemplateConfigView';
					var isShared = publicJson['templateConfigDetails']['isSharedTemplate'];
					if(isShared!=null && isShared == 'true')
					{
						isShared = true;
					}
					else
					{
						isShared = false;
					}
					var isDefault = publicJson['templateConfigDetails']['isDefaultTemplate'];

					if(isDefault!=null && isDefault == 'true')
					{
						isDefault = true;
					}
					else
					{
						isDefault = false;
					}
					var gridStackObj=Ext.getCmp('gridstackpanelObj');//_'+profName);
					if(!Ext.isEmpty(gridStackObj))
					{
						gridStackObj._removeAllWidget();
					}
					Ext.getCmp('listPageHeaderMenu').hide();
					Ext.getCmp('searchTemplate').hide();
					mainPageView.remove('templateBuilderListPageView',true);
					mainPageView.remove('dataViewId',true);
					mainPageView.clearManagedListeners();
					mainPageView.removeAll('dataViewId',true);
					mainPageView.remove('templateLayout',true);
					mainPageView.remove('templateLayoutObj',true);
					Ext.EventManager.removeAll('templateLayoutObj');
					Ext.EventManager.removeAll('templateBuilderListPageView');
					Ext.EventManager.removeAll('dataViewId');
					mainPageView.add({
						xtype : 'templateLayout',
						profileName : publicJson['templateConfigDetails']['profileName'],
						isSharedTemplate : isShared,
						isDefaultTemplate : isDefault,
						layoutchoosen: publicJson['templateConfigDetails']['layout']
					});
					
					Ext.getCmp('templateListCombo').show();
					Ext.getCmp('templateConfigTools').hide();
					var templateConfigTools=this.getTemplategeneralsettings();
					if(publicJson['templateConfigDetails']['isSharedTemplate'] == "false" && !isMonitorHome)
					{
						if(!isDefault)
						{
							Ext.getCmp('templateConfigTools').show();
						}
					}
					else
					{
						Ext.getCmp('templateConfigTools').hide();
					}
					var templateTools = this.getTemplatetools();
					templateTools.show();
					templateTools.getComponent('listBtnContainer').show();
					templateTools=null;
					delete templateTools;
					this.loadTemplateListCombo(publicJson['templateComboList'],publicJson['templateConfigDetails']['profileName']);
					mainPageView.doLayout();
					this.loadTemplateConfigurationView();
					winObj.setDisabled(false);
				}
			}
		});
	},
	onChangeDDChartType : function(chartTypeComboObj)
	{
		var selectedChartTypeValue = chartTypeComboObj.getValue();
		var summarizeDDColumnObj = Ext.getCmp('summarizeDDColumnCombo');
		var ddColumnsComboLbl = Ext.getCmp('ddcolumnsLbl');
		var viewTypeObj = Ext.getCmp('ViewType');
		var timeLineObj = Ext.getCmp('Timeline');
		var showChartSummarySwitchVal = Ext.getCmp('showChartSummary');
		var mesLbl = Ext.getCmp('measureLbl');
		if(selectedChartTypeValue != null && selectedChartTypeValue == 'Bar Chart')
		{
			if(showChartSummarySwitchVal!=null &&  !Ext.isEmpty(showChartSummarySwitchVal))
			{
				showChartSummarySwitchVal.hide();
			}
			if(timeLineObj != null && !Ext.isEmpty(timeLineObj))
			{
				timeLineObj.hide();
			}
		
			if(!Ext.isEmpty(summarizeDDColumnObj) && !Ext.isEmpty(viewTypeObj))
			{
				if(mesLbl.isVisible())
				{
					summarizeDDColumnObj.show();
					summarizeDDColumnObj.setValue('-1');
				}
				viewTypeObj.show();

				if(ddColumnsComboLbl != null && !Ext.isEmpty(ddColumnsComboLbl))
				{
					var viewTypeVal = '';
					var viewTypeOpt = viewTypeObj.getChecked();
					if(viewTypeOpt!=null && !Ext.isEmpty(viewTypeOpt))
					{
						viewTypeVal = viewTypeOpt[0].inputValue;
					}
				
					if(viewTypeVal!=null && viewTypeVal == 'Vertical')
					{
						summarizeDDColumnObj.setFieldLabel('Summarize DD Data By (X axis)');
						ddColumnsComboLbl.setText('DD Columns (Y axis)');
					}
					else if(viewTypeVal!=null && viewTypeVal == 'Horizontal')
					{
						summarizeDDColumnObj.setFieldLabel('Summarize DD Data By (Y axis)');
						ddColumnsComboLbl.setText('DD Columns (X axis)');
					}
				}
			}			
		}
		else if(selectedChartTypeValue != null && (selectedChartTypeValue == 'Time Line' || selectedChartTypeValue == 'Area'))
		{
			if(showChartSummarySwitchVal!=null &&  !Ext.isEmpty(showChartSummarySwitchVal))
			{
				showChartSummarySwitchVal.show();
			}
			if(viewTypeObj != null && !Ext.isEmpty(viewTypeObj))
			{
				viewTypeObj.hide();
			}
			if(timeLineObj != null && !Ext.isEmpty(timeLineObj))
			{
				timeLineObj.show();
			}
			
			if(!Ext.isEmpty(ddColumnsComboLbl) && !Ext.isEmpty(summarizeDDColumnObj))
			{
				summarizeDDColumnObj.setFieldLabel('Summarize DD Data By');
				ddColumnsComboLbl.setText('DD Columns');
			}
			
			if(mesLbl.isVisible())
			{
				if(!Ext.isEmpty(summarizeDDColumnObj))
				{
					summarizeDDColumnObj.show();
					summarizeDDColumnObj.setValue('-1');
				}
			}
		}
		else
		{
			if(showChartSummarySwitchVal!=null &&  !Ext.isEmpty(showChartSummarySwitchVal))
			{
				showChartSummarySwitchVal.hide();
			}
			if(timeLineObj != null && !Ext.isEmpty(timeLineObj))
			{
				timeLineObj.hide();
			}
			if(!Ext.isEmpty(summarizeDDColumnObj) && !Ext.isEmpty(viewTypeObj))
			{
				summarizeDDColumnObj.hide();
				viewTypeObj.hide();
			}

			if(ddColumnsComboLbl != null && !Ext.isEmpty(ddColumnsComboLbl))
			{
				ddColumnsComboLbl.setText('DD Columns');
			}
		}	
	},

	onChangeViewType : function(radioObj)
	{
		var graphicalTypeObj = Ext.getCmp('graphicalTypeId');
		var selectedChartTypeValue = graphicalTypeObj.getValue();
		var ddColumnsComboLbl = Ext.getCmp('ddcolumnsLbl');
		var summarizeDDColumnObj = Ext.getCmp('summarizeDDColumnCombo');

		if(selectedChartTypeValue != null && selectedChartTypeValue == 'Bar Chart')
		{
			var showViewTypeOptObj = radioObj.getChecked();
			var viewType = showViewTypeOptObj[0].inputValue;
			if(ddColumnsComboLbl != null && !Ext.isEmpty(ddColumnsComboLbl))
			{			
				if(viewType!=null && viewType == 'Vertical')
				{
					summarizeDDColumnObj.setFieldLabel('Summarize DD Data By (X axis)');
					ddColumnsComboLbl.setText('DD Columns (Y axis)');
				}
				else if(viewType!=null && viewType == 'Horizontal')
				{
					summarizeDDColumnObj.setFieldLabel('Summarize DD Data By (Y axis)');
					ddColumnsComboLbl.setText('DD Columns (X axis)');
				}
			}
		}
	},

	onManualTestComboChange : function(selectedChartType,combo,selectedTest,selectedMeasure,selectedDDColumns,summarizedDDColumn)
	{
		var thisC = this;
		var measureMultiselect = Ext.getCmp('measureListCombo');
		var measurelistCombo = Ext.getCmp('measurelist');
		var userDefinedWidgetWindowObj = this.getUserDefinedWidgetWindow();
		var configForm = userDefinedWidgetWindowObj.getComponent('configForm').getForm();
		if(selectedTest!=null)
		{
			tempSelectedGraph = 'DDTable';
			if(selectedTest != "-1") {
				Ext.Ajax.request({
					url : '/final/servlet/com.eg.EgTemplateBuilderController',
					method : 'POST',
					params : 'action=getMeasuresForTest&comesFrom=widgetConfiguration&selectedTest='+encodeURIComponent(selectedTest)+'&selectedGraph='+tempSelectedGraph,
					scope : this,
					success : function(response) {
						var jsonText = response.responseText;
						if (jsonText != null && jsonText != '') {
							var jsonDtaForMeas = Ext.decode(jsonText);
							var measuresList = null;
							measuresList = jsonDtaForMeas['Measures']['ddMeasureOpts'];
															
							if(measuresList!=null && !Ext.isEmpty(measuresList))
							{
								if(tempSelectedGraph!=null && tempSelectedGraph!='')
								{
									Ext.getCmp('addtoGridBtn').hide();
									Ext.getCmp('measureLbl').show();

									if(tempSelectedGraph == 'DDTable')
									{
										configForm.findField('measurelist').hide();
										configForm.findField('metricsSearchTextBox').hide();
													
										var measureCombo = configForm.findField('measureListCombo');
										measureCombo.suspendEvents(true);
										var measureComboStore = measureCombo.getStore();
										measureComboStore.removeAll();
										measureComboStore.loadRawData(measuresList);
										measureComboStore.insert(0, {
											displayField : 'Please Choose Measure',
											valueField : '-1'
										});
										
										measureCombo.setValue(selectedMeasure);
										measureComboStore.resumeEvents();
										measureCombo.show();										
									}
								}
							}
							else
							{
								if(tempSelectedGraph!=null && tempSelectedGraph == 'DDTable')
								{
									var measureCombo  = configForm.findField('measureListCombo');
									measureCombo.suspendEvents(true);
									var measureComboStore = measureCombo.getStore();
									measureComboStore.removeAll();
									measureComboStore.insert(0, {
										displayField : notApplicable,
										valueField : '-1'
									});
									measureCombo.setValue('-1');
									measureCombo.resumeEvents();
									measureCombo.show();
									var ddcolumnsCombo  = configForm.findField('ddcolumnsMultiSelect');
									ddcolumnsCombo.suspendEvents(true);
									var ddcolumnsComboStore = ddcolumnsCombo.getStore();
									ddcolumnsComboStore.removeAll();
									ddcolumnsComboStore.insert(0, {
										displayField : notApplicable,
										valueField : '-1'
									});
									ddcolumnsCombo.setValue('-1');
									ddcolumnsCombo.resumeEvents();
									ddcolumnsCombo.show();
								}
							}
						}
					}
				});
				/*var measureComboObj  = configForm.findField('measureListCombo');
				Ext.defer(function(){
					measureComboObj.isManualLoading = true;
					thisC.loadManualDDColumns(measureComboObj,selectedDDColumns,summarizedDDColumn);
				},200)*/
					
			}
			else
			{
				var measureMultiCombo = configForm.findField('measurelist');
				measureMultiCombo.suspendEvents(true);
				var measureMultiComboStore = measureMultiCombo.getStore();
				measureMultiComboStore.removeAll();
				measureMultiComboStore.insert(0, {
					displayField : notApplicable,
					valueField : '-1'
				});
				measureMultiCombo.setValue('-1');
				measureMultiCombo.resumeEvents();
			}
		}
		var measureComboObj  = configForm.findField('measureListCombo');
		Ext.defer(function(){
			measureComboObj.isManualLoading = true;
			thisC.loadManualDDColumns(measureComboObj,selectedDDColumns,summarizedDDColumn);
		},200)
		userDefinedWidgetWindowObj =null;
		delete userDefinedWidgetWindowObj;
	}
});