var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {
        clicksToEdit: 1
    });

Ext.define('TemplateBuilder.view.ComparisonTable',{
	extend:'Ext.grid.Panel',
	requires:['Ext.selection.CellModel','Ext.selection.CheckboxModel'],
	alias:'widget.comparisontable',
	id : 'configTableGrid',
	name : 'configTableGrid',
	colspan:3,
	border:false,
	ui:"newGridPanel mydashboard_grid  dsRestColumnGrid",
	width:600,
	frame:false,
	height:170,
	stripeRows:false,
	forceFit : false,
	stateful: false,
	hideChartType: true,
	margin:'5 10 10 0',
	//title:'Selection Details',
	header:false,
	viewConfig: {
		deferEmptyText: false
	},
			emptyText : '<table width="100%" height="110px" border="0"><tr><td align="center" valign="middle"><div class="iconInformation"></div><div styel="margin:10px auto">'+noConfigAvailableMsg+'</div></td></tr></table>',
	//emptyText : '<table width="98%" height="70" style="margin-top:30px"><tr><td align="center"><div class="alert22"/></td></tr><tr><td align="center"><div>'+noConfigAvailableMsg+'</div></td></tr></table>',
	initComponent : function()
	{
		var thisGrid = this;
		this.selModel =  new Ext.selection.CheckboxModel({
				checkOnly: true,
				headerWidth: 36,
//				border:true,
				injectCheckbox: 0
			});
		//this.getStore().removeAll();
		this.columns = [
				{
					text: screenLabelsObj['Test'],
					dataIndex:'test',
					flex:.4,
					renderer: function(value, metaData) {
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
								return value;
						}
				},
				{
					text: screenLabelsObj['Measure'],
					dataIndex:'measure',
					cls: 'x-form-item-label',
					flex:.6,
					editor: {
							allowBlank: false
							},
					renderer: function(value, metaData) {
							metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
							return value;
						}
				},
			{
			header: '<div class="iconDeleteAll" style="margin:1px auto 0px auto" data-qclass="yellowTip" data-qtip="'+toolDeleteAll+'"></div>',
            xtype: 'actioncolumn',
			enableColumnHide:false,
			menuDisabled:true,
			renderer: function(value, metaData) {
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+toolDelete+'"';
								return value;
							},
            width:36,
			padding:0,
			margin:0,
			border:true,
            items: [{
                iconCls: 'iconDelete',
				width:24,
				height:20,
                handler: function(grid, rowIndex, colIndex) {
					Ext.Msg.show({
										title:templatesAlertLbl,
										msg:metricsDeleteAlertMsg,
										buttons: Ext.Msg.YESNO,
										icon: Ext.Msg.QUESTION,
										fn:function(buttonId)
										{
											if(buttonId =="yes")
											{
												var rec = grid.getStore().getAt(rowIndex);
												grid.store.remove(rec);
											}
										}
									});
                }
            }],
			listeners:{
				'headerclick':function( ct, column, e, t, eOpts ){
					var thisGrid = this.up('grid'),
					thisGridStore = thisGrid.getStore(),
					thisGridSelections = thisGrid.getSelectionModel(),
					noOfrecords = thisGridStore.getCount();
					if ( noOfrecords > 0 )
								{
									var selection = thisGridSelections.getSelection();
									if(selection.length==0)
									{
										 Ext.Msg.show({
											title: templatesAlertLbl,
											msg: noConfigSelectedAlertMsg,
											buttons: Ext.MessageBox.OK,
											icon: Ext.MessageBox.WARNING
										});
										return;
									}
									Ext.Msg.show({
										title:templatesAlertLbl,
										msg:metricsDeleteAlertMsg,
										buttons: Ext.Msg.YESNO,
										icon: Ext.Msg.QUESTION,
										fn:function(buttonId)
										{
											if(buttonId =="yes")
											{

													var chkTotal = (thisGrid.selModel.selected.getCount() === thisGrid.getStore().getCount());
													if(chkTotal){
													thisGridStore.remove(selection);
													}else{
													for (var i=0; i< selection.length ; i++ )
													{
														thisGridStore.remove(selection[i]);
													}
													}
													thisGrid.selModel.toggleUiHeader();


											}
										}
									});
								}
								else
								{
									 Ext.Msg.show({
										title: 'Alert',
										msg: noConfigAvailableMsg,
										buttons: Ext.MessageBox.OK,
										icon: Ext.MessageBox.WARNING
									});
									return;
								}



				}
			}
        }
        ];
		this.callParent();
	},
	listeners:{
		render: function()
		{
			var blkId=this.blockId;
			var meCompGrid=this;
			this.on('validateedit',function(editor, e1,eOpts) {
			if(e1.field=='measure')
			{
				var editor = editor.getEditor(e1.record, e1.column);
				var edv = editor.getValue();
				if(edv=='')
				{
					Ext.Msg.show({
						title: templatesAlertLbl,
						msg: mesureEmptyAlert,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				if (meCompGrid.checkSpecialCharacter(edv)) {
					Ext.Msg.show({
						title : templatesAlertLbl,
						msg : measureSplCharacterAlertMsg,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
					});
					return false;
				}
				if((edv!=null && edv!=e1.originalValue) && (e1.grid.store.find('measure', edv, 0, false, true, true)!=-1))
				{
					Ext.Msg.show({
						title: templatesAlertLbl,
						msg: measureNameExistsMsg,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					
					return false;
				}
				/*else if(e1.originalValue.indexOf(',')>0)
				{
					if(edv.indexOf(',') == -1)
					{
						Ext.Msg.show({
						title: templatesAlertLbl,
						msg: 'We have to maintain same measure count',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
						});
						return false;
					}
					var orginalstrArr = e1.originalValue.split(',');
					var edvstrArr = edv.split(',');
					if(edvstrArr.length !=orginalstrArr.length)
					{
						Ext.Msg.show({
						title: templatesAlertLbl,
						msg: 'We have to maintain same measure count',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
						});
						return false;
					}
				}*/
				else
				{
					var orginalstrArr = e1.originalValue.split(',');
					var edvstrArr = edv.split(',');
					if(edvstrArr.length !=orginalstrArr.length)
					{
						Ext.Msg.show({
					title: templatesAlertLbl,
					msg: maintainsMeasCountAlert,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
					}
				}
			}
		});
		this.on('edit', function(editor, e) {
				// commit the changes right after editing finished
			if(e.field=='measure')
			{
				var editedStr=e.value;
				e.record.data['measure'] = editedStr;
				var hidval = e.record.data['hidVal'];
				var modifiedHidval = hidval.substring(0,hidval.indexOf("!!!"));
				while(editedStr.indexOf(',')>0)
				{
					editedStr = editedStr.replace(',',"^^")
				}
				modifiedHidval = modifiedHidval + "!!!" + editedStr
				e.record.data['hidVal']= modifiedHidval;
				e.grid.getStore().sync();
				e.grid.getView().refresh();
			}
			});
		
		}
	},
	plugins: [cellEditing],
	store:Ext.create('Ext.data.ArrayStore',{
						fields: [
									{name: 'componentType',type : 'string'},
									{name: 'test',type : 'string'},
									{name: 'Descriptor',type : 'string'},
									{name: 'measure', type: 'string'},
									{name: 'hidVal', type: 'string'},
									{name: 'chartType', type: 'string'},
									{name: 'ddHidVal', type: 'string'},
									{name: 'ddval', type: 'string'}
								 ],
								data:[]
							}),
	selModel: {
            selType: 'cellmodel'
        },
		checkSpecialCharacter : function(dataStr) {
		var splChar = "$-!~^";
		for ( var i = 0; i < dataStr.length; i++) {
			var check_char = splChar.indexOf(dataStr.charAt(i))
			// Returns value 1 if the special character listed
			// in splChar is found
			if (check_char >= 0) {
				return true;
			}
		}
		return false;
	}
})