Ext.define('TemplateBuilder.view.Dashboardlayouts', {
    extend: 'Ext.form.FieldContainer',
    alias: 'widget.preconfiguredlayouts',
    defaults: {
        overCls: 'x-customradio-over',
        cls: 'x-customradio',
        width: 75,
        height: 90,
        listeners: {
            change: function (chk, newValue, oldValue, eOpts) {
                if (newValue) {
					if(!Ext.isEmpty(chk.inputValue))
					{
						tempBuilderApp.getController("Main").changePreDefinedLayout(chk.inputValue);
//						myDashApp.getController("Main").savePreDefinedLayoutStyle(chk.inputValue);
					}
				}

            }
        }
    },
    initComponent: function () {
        var self = this,
            items = [],
			checked =false,
			selectedTemplate = Ext.getCmp('gridstackpanelObj').selectTemplate;
        for (var i = 1; i < 11; i++) {
			if(('layoutstyle-' + i) === selectedTemplate ){
				checked = true;
			}else{
				checked = false;
			}
            items.push({
                name: 'dashboard_layout',
                inputValue: 'layoutstyle-' + i,
                radioType: 'icon',
                id: 'layoutstyle-' + i, 
				tooltipText:'Template-' + i,
                iconCls: 'ds-layoutstyle-' + i,
				checked:checked
            });
        }
        self.items = items;
        self.callParent();
    },
    flex: 1,
    labelSeparator: '',
    fieldLabel: 'Predefined Templates',
    ui: 'dashbaord_layout-field',
    labelCls: 'newFont_normal20 new_font',
    labelAlign: 'top',
    defaultType: 'customradio',
    layout: {
        type: 'column'
    }
});