Ext.override(Ext.Component,
{
    setLoading : function(load, targetEl) {
        var me = this,config;
        if (me.rendered){
            Ext.destroy(me.loadMask);
            me.loadMask = null;
            if (load !== false && !me.collapsed) {
                if (Ext.isObject(load)) {
                    config = Ext.apply({}, load);
                } else if (Ext.isString(load)) {
                    config = {msg: load};
                } else {
                    config = {};
                }
				
            if (targetEl){
				me.loadMask = new Ext.LoadMask(me.getTargetEl(), config);
				}else{
				me.loadMask = new Ext.LoadMask(me.el, config);
				}
				me.loadMask.show();
            }
        }
        return me.loadMask;
    }
});
Ext.define('headerbutton', {
    extend: 'Ext.AbstractPlugin',
    alias: 'plugin.headericons',
    iconCls: '',
    init: function(panel) {
        this.panel = panel;
        this.callParent();
        panel.on('render', this.onHeaderIcons, this);

    },
    onHeaderIcons: function() {
        this.header = this.panel.getHeader();
        this.header.insert(0, this.headerButtons);
   }
});
var dbStore = Ext.create('Ext.data.Store', {
    fields: ['valueField', 'displayField'],
    data: []
});
Ext.define('TemplateBuilder.view.Main', {
	alias: 'widget.main',
    extend: 'Ext.panel.Panel',
    //title:'Template list',
	//cls: 'balckouterpanel dashboard_title',
	ui:'newOuterPanel',
    layout: {
        type: "fit",
        align: "stretch"
    },
    frame: true,
    requires: ['TemplateBuilder.view.ListView',
				'TemplateBuilder.view.TemplateLayout',
				'utilities.gridstackPanel',
				'TemplateBuilder.view.TemplateGeneralSettings',
				'TemplateBuilder.view.TemplateTools',
				'utilities.Toggleswitch',
				'TemplateBuilder.view.PreDefinedLayouts'

				],
	id: 'templateMainPanel',
    border: false,
    margin: '8 8 0 8',
    padding: 0,
    flex: 1,
	bodyPadding:0,
    autoScroll: false,
    frame: false,
    scroll: false,
    header: {
        height: 41,
		margin:0,
        padding: '0 10 0 0',
    },
	height :560,
	tools: [
			{
				xtype:'trigger',
				id : 'searchTemplate',
				name : 'searchTemplate',
				labelWidth:40,
				margin: '4px 0px 0px 0px',
				fieldLabel:'',
				cls: 'whitedropdown_search',
				emptyText:addTemplateLbl,
				hidden : true,
				listeners: {
					change: function(trig,newVal,oldVal,eOpts) {
						Ext.getCmp('selectAllTemplates').setValue(false);
						trig.onTextFieldChange(trig,newVal,oldVal,eOpts);
					}
				},
				onTextFieldChange : function(triggerField, newValue, oldValue, eOpts)
				{
					var dataViewId = Ext.getCmp('dataViewId');
					if(!Ext.isEmpty(dataViewId))
					{
						if(newValue=="*")
						{
							dataViewId.store.clearFilter();
						}
						else
						{
							if(newValue.lastIndexOf("*")==(newValue.length-1))
							{
								newValue = newValue.substr(0,(newValue.length-1));
							}
							dataViewId.store.suspendEvents(true); // This is used for good performance
							dataViewId.store.clearFilter();
							dataViewId.store.resumeEvents(); // This is used for good performance
							if (newValue) {
								var matcher = new RegExp(Ext.String.escapeRegex(newValue), "i");
								dataViewId.store.filter({
									filterFn: function(record) {
										var templateName = record.get('templateName');
										var match= matcher.test(templateName) ;
										return match;
									}
								});
							}
						triggerField.focus();
						}
					}
				}
		},
		{
			xtype: 'templatetools',
			hidden: true
		}
			],
	initComponent: function() {
            this.plugins = [{
                ptype: "headericons",
				height:41,
                headerButtons: [
					{
					xtype:'container',
					cls:'myDashboardsList_con',
					padding: '0 0',
					height:41,
					 margin: '0 10 0 0',
					items:[{
                    xtype: 'scrollcombo',
                    id: 'templateListCombo',
                    name: 'templateListCombo',
					hidden : true,
                    margin: '8 10 0 10',
                    ui:'transparent-dropdown',
					width: 180,
					listConfig: {
                        cls: 'blklist',
						minWidth:200
                    },
                    editable: false,
                    displayField: 'displayField',
                    valueField: 'valueField',
					pickerOffset :[-10,8],
                    store: dbStore,
                    queryMode: 'local',
                    tpl: new Ext.XTemplate(
                        '<ul >',
                        '<tpl for=".">',
                        '<tpl if="this.shouldShowSHeader(valueField)"><li class="heading"><h3>Shared</h3><li></tpl>',
                        '<tpl if="this.shouldShowPHeader(valueField)"><li class="heading"><h3>Personal</h3><li></tpl>',
                        '<li class="x-boundlist-item">{displayField}<li>',
                        '</tpl>',
                        '</ul>', {
                            shouldShowSHeader: function(key) {
                                if (key.indexOf('USRSEP') >= 0 && k <= 0) {
                                    k++;
                                    i++;
                                    return true;
                                } else {
                                    i++;
                                }
                                if (i >= dbStore.getCount()) {
                                    i = 0;
                                    k = 0;
                                }
                            },
                            shouldShowPHeader: function(key) {
                                if (key.indexOf('USRSEP') < 0 && j <= 0) {
                                    j++;

                                    return true;
                                } else {
                                    j++;
                                }
                                if (j >= dbStore.getCount()) {
                                    j = 0;
                                }
                            }
                        }
                    )
                }]
				},
				
				{
					xtype: 'container',
					dock: 'top',
					ui:'footer',
					id : 'listPageHeaderMenu',
					flex : 1,
					height:39,
					layout:'hbox',
					//style:{'padding':'4px 0px 4px 0px !important'},
					hidden : true,
					items : [
						{
							xtype:'checkbox',
							boxLabel  : '',
							cls:'checkbt',
							margin:'10px 2px 8px 10px',
							name : 'selectAllTemplates',
							inputValue: 'selectAll',
							id : 'selectAllTemplates',
							hidden:true
						},{
							xtype: 'button',
							width: 16,
							height:16,
							padding:0,
							margin:'11 0 8 0',
							overCls: 'buttonOver',
							id: 'DeleteListOfTemplates',
							iconCls: 'iconDelete',
							style : {'border':'0px !important','background':'transparent;'},
							hidden:true,
							listeners: {
								afterrender: function () {
									Ext.create('Ext.tip.ToolTip', {
										target: this.id,
										anchor: 'top',
										cls: 'yellowTip',
										trackMouse: true,
										html: toolDelete
									});
								}
							}
						},
						{
							xtype:'tbseparator',
							hidden:true,
							id:'tmplheadrtab',
							height:22,
							margin:'8px 5px 0px 4px',
						},
						{
							xtype: 'container',
							margin:'0px 0px 0 0px',
							padding:'12 10 0 3',
							html: '<div class="bigHeaderFont" style="color:#ffffff;">'+availTemplateLbl+'</div>',
						},{
							xtype:'button',
							cls:'buttonNew',
							margin:'9px 0 6px 5px',
							id:'createTemplateButton',
							iconCls:'iconAddDashboardPlus',
							text:createNewLbl,
							listeners: {
								afterrender: function () {
									Ext.create('Ext.tip.ToolTip', {
										target: this.id,
										anchor: 'top',
										cls: 'yellowTip',
										trackMouse: true,
										html: addTemplateLbl
									});
								}
							},
							action:'addNew'
						},
						/*{
							xtype:'button',
							cls:'buttonNew',
							margin:'9px 0 6px 5px',
							id:'iconLibrary',
							text:'Icon Library',
							action:'addIcon'
						}*/
					]
				},
				{
					xtype: 'templategeneralsettings',
					hidden:true
				}
				]
            }];

        this.callParent();
    }
	/*items:
	[{
		xtype:'templateBuilderList'
	}]*/
});