Ext.define('TemplateBuilder.view.PreDefinedLayouts', {
    extend: 'Ext.window.Window',
    requires:'TemplateBuilder.view.Dashboardlayouts',
    alias: 'widget.predefinedlayouts',
    bodyPadding: 0,
    ui: 'dashboard-layout-settings',
    width: Ext.getBody().getViewSize().width - 20,
    closeAction: 'destroy',
    header: false,
    resizable: false,
    layout: {
        type: 'fit'
    },
	onEsc: function(){
	  Ext.getCmp('custom_layouts').defaultState();
	  Ext.destroy(this);
	},
    draggable: false,
    id: 'layout_window',
    listeners: {
        afterrender: function (win) {			
            Ext.EventManager.onWindowResize(function () {
                win.setWidth(Ext.getBody().getViewSize().width - 20);
            });

        }
    },
    items:[{
        xtype: 'panel',
        closeAction: 'destroy',
		header : {
			padding : '7 5 4 5'
		},
        flex: 1,
        layout: {
            type: 'hbox'
        },
        doClose: function () {
            Ext.destroy(this.up('window'));
            Ext.destroy(this);
            Ext.getCmp('custom_layouts').defaultState();
        },
        bodyPadding: '10 20 20 20',
        ui: 'dashboard-layout-settings',

        closable: true,
        items: [{
                xtype: 'fieldcontainer',
                width: 280,
				layout:{
					type:'hbox'
				},
                ui:'dashbaord_layout-field',
				fieldLabel: 'Custom Template',
				labelSeparator :'',
				labelCls:'newFont_normal20 new_font',
				labelAlign: 'top',
                items: [
				{
					xtype:'imagecomponent',
					width:140,
					id:'custom-layout-image',
					margin:'11 0 0 0',
					height:50,
					src: '../images/'+strSkin+'/ds-column-layout-3.png',
					autoEl: 'div'
				},	
				{
                    xtype: 'customspinner',
					//id : 'CustomLayoutCnt',
                   // labelWidth:200,
					margin:'5 0 0 20',
                    labelStyle:'white-space: nowrap',
                    labelAlign: 'top',
					ui:'big-spinner',
                    fieldLabel: 'Columns:',
                    labelCls:'newFont_normal18 new_font',
                    labelSeparator :'',
                    editable: false,
                    width:65,
                    value: 3,
					maxValue: 5,
                    minValue: 1,
					listeners:{
						'afterrender' : function(incObj)
						{
							if(publicJson['templateConfigDetails']!=null && publicJson['templateConfigDetails'].hasOwnProperty('dashboardLayoutType'))
							{
								if(publicJson['templateConfigDetails']['dashboardLayoutType']!=null && publicJson['templateConfigDetails']['dashboardLayoutType']=="Custom")
								{
									incObj.setValue(parseInt(publicJson['templateConfigDetails']['customLayoutColumn']));
									Ext.getCmp('custom-layout-image').setSrc('../images/'+strSkin+'/ds-column-layout-'+publicJson['templateConfigDetails']['customLayoutColumn']+'.png');
								}
							}
						},
						//TODO move to CTRL
						spindown:function(spinner){
							var val = parseInt(spinner.getValue(), 10),
							orginalVal = val-1;
							if(orginalVal < spinner.minValue){
								return;
							}else{
							Ext.getCmp('custom-layout-image').setSrc('../images/'+strSkin+'/ds-column-layout-'+orginalVal+'.png');
							tempBuilderApp.getController("Main").saveCustomColumn(orginalVal,this.up('window'));
							//myDashApp.getController("Main").saveCustomColumn(orginalVal,this.up('window'));
							}

							///console.log('-->',Ext.getCmp('gridstackpanelObj').gridStackObjRef().setGridWidth(gridWidth, doNotPropagate));
							/*if(orginalVal < spinner.minValue){
								return;
							}else{
								Ext.getCmp('custom-layout-image').setSrc('../images/'+strSkin+'/ds-column-layout-'+orginalVal+'.png');
								if(orginalVal == spinner.minValue){
									spinner.setFieldLabel('Column:');
								}
								Ext.getCmp('gridstackpanelObj').gridStackObjRef().setGridWidth(orginalVal,false);
								//Ext.getCmp('gridstackpanelObj')._updateWidgets(Ext.getCmp('gridstackpanelObj').getData(), orginalVal);
								myDashApp.getController("Main").saveCustomColumn(orginalVal);
								console.log('down',orginalVal);
							}*/
						},
						spinup:function(spinner){
							var val = parseInt(spinner.getValue(), 10),
							orginalVal = val+1;
							if(orginalVal > spinner.maxValue){
								return;
							}else{
								Ext.getCmp('custom-layout-image').setSrc('../images/'+strSkin+'/ds-column-layout-'+orginalVal+'.png');
								tempBuilderApp.getController("Main").saveCustomColumn(orginalVal,this.up('window'));
								//myDashApp.getController("Main").saveCustomColumn(orginalVal,this.up('window'));
							/*	Ext.getCmp('custom-layout-image').setSrc('../images/'+strSkin+'/ds-column-layout-'+orginalVal+'.png');
								spinner.setFieldLabel('Columns:');
								Ext.getCmp('gridstackpanelObj').gridStackObjRef().setGridWidth(orginalVal,false);
								//Ext.getCmp('gridstackpanelObj')._updateWidgets(Ext.getCmp('gridstackpanelObj').getData(), orginalVal);
								myDashApp.getController("Main").saveCustomColumn(orginalVal);
								console.log('up',val+1);*/
							}
							
						}
					}
                }]

            },
            {
                xtype:'preconfiguredlayouts'
            }
        ]

    }]
});