Ext.define('TemplateBuilder.view.TemplateGeneralSettings', {
    extend: 'Ext.container.Container',
    alias: 'widget.templategeneralsettings',
	id: 'templateConfigTools',
	name: 'templateConfigTools',
	hidden:false,
	requires: ['utilities.ScrollCombo','Ext.ux.CustomSpinner', 'utilities.CustomRadio','TemplateBuilder.view.PreDefinedLayouts'],
    bodyStyle: {
        'background': 'none'
    },
    defaults: {
        cls: 'dashboardHeaderIcons',
		margin:'0 2 0 2'
    },
	ui:'chart-controllers',
	layout : {
		type : 'hbox',
		align : 'stretch'
	},
    items: [
	{
        xtype: 'button',
        width: 120,
		height:30,
        padding: '5 0 5 0',
		cls:'newAddWidgetBnt',
		border:0,
		style:{'background':'none'},
		html:'<div class="newFont_normal15 addWigetClr">'+screenLabelsObj['Add a Widget']+'</div>',
        overCls: 'buttonOver',
		
        buttonId: 'AddWidget',
       // iconCls: 'iconOneClickHeaderAddWidget',
			icon: '../images/'+strSkin+'/newConfigAddIcon.png', 
        listeners: {
            afterrender: function () {
               /* Ext.create('Ext.tip.ToolTip', {
                    target: this.id,
                    anchor: 'top',
                    cls: 'yellowTip',
                    trackMouse: true,
                    html:screenLabelsObj['Add Widget']
                });*/
            }
        }
    },
    	{
		xtype:'tbseparator',
		width: 2,
		height: 30,
		margin:0,
		id: '',
		buttonId: 'tbsettingseperator',
		cls:'myDashboardFloatingMenuSeperator',
	},
	//layout setting button
	{
		xtype: 'button',
		margin: 0,
		padding: 0,
		toggleGroup: true,
		enableToggle: true,
		buttonId: 'custom_layouts',
		id: 'custom_layouts',
		buttonId: 'custom_layouts', 
		iconCls: 'iconDashboardLayoutSettings',
		overCls: 'buttonOver myDashboard dashboardLayoutSettingsOver',
		pressedCls: 'buttonPressedDashboard',
		defaultState: function () {
			var btn = this;
			btn.setText('');
			if (btn.pressed) {
				btn.toggle(false);
				btn.fireEvent('mouseout',btn);
			}else{
				Ext.destroy(Ext.getCmp('layout_window'));
			}

			},
			listeners: {
				afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
						target: this.id,
						anchor: 'top',
						cls: 'yellowTip',
						trackMouse: true,
						html: 'Layouts'
					});
				},
				click: function (btn) {
					
					if(btn.pressed){
						console.log('---->',Ext.getCmp('gridstackpanelObj').selectTemplate)
						Ext.create('TemplateBuilder.view.PreDefinedLayouts',{
							width: Ext.getBody().getViewSize().width - 16,
							y: btn.el.getY() + 30
						}).show();
					}else{
						Ext.destroy(Ext.getCmp('layout_window'));
					}
					
				},
				mouseover: function (btn) {
					btn.setText("<span class='newFont_normal14' style='margin: 0 5px ; color:#ffffff;'>Layout</span>");
				},
				mouseout: function (btn) {
					if (btn.pressed) {
						btn.setText("<span class='newFont_normal14' style='margin: 0 5px ; color:#ffffff;'>Layout</span>");
					} else {
						btn.setText("");
						btn.removeCls('buttonOver');
					}
				}
			}
	},
	{
		xtype:'tbseparator',
		width: 2,
		height: 30,
		margin:0,
		id: '',
		cls:'myDashboardFloatingMenuSeperator',
	},
	{
		xtype: 'button',
		//width: 20,
		//height:30,
		margin: 0,
		padding:0,
		cls:'dashboardHeaderIcons',
		iconCls: 'iconOneClickHeaderWidgetLibraryNew',
		overCls: 'buttonOver myDashboard',
		pressedCls: 'buttonPressedDashboard',
		buttonId: 'Widgets_Gallery',
		id : 'Widgets_Gallery',
		toggleGroup :true,
		enableToggle: true,
		name : 'Widgets_Gallery',
		defaultState : function() {
			var btn = this;
			btn.setText('');
			if (btn.pressed)
			{
				//alert(btn.pressed);
				btn.toggle(false);
				btn.removeCls('buttonOver');
			}

		},
		listeners: {
				afterrender: function () {
				/*Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					 html: screenLabelsObj['Widget Gallery']
				});*/
			},
			 mouseover: function(btn) {
					btn.setText("<div class='newFont_normal15' style='margin: -2px 5px 0; color:#ffffff;'>"+screenLabelsObj['Widget Gallery']+"</div>");
				},
				mouseout: function(btn ){
					if (btn.pressed)
					{
					btn.setText("<div class='newFont_normal15' style='margin: -2px 5px 0 ; color:#ffffff;'>"+screenLabelsObj['Widget Gallery']+"</div>");
					}
					else{
							btn.setText("");
							btn.removeCls('buttonOver');
					}
				}
		}
	},
	/*{
        xtype: 'button',
        width: 20,
		height:20,
       // overCls: 'buttonOver',
        buttonId: 'Widgets_Gallery',
        iconCls: 'iconOneClickHeaderWidgetLibraryNew',
        listeners: {
            afterrender: function () {
                Ext.create('Ext.tip.ToolTip', {
                    target: this.id,
                    anchor: 'top',
                    cls: 'yellowTip',
                    trackMouse: true,
                    html: 'Widget Gallery'
                });
            }
        }
    },*/
		{
		xtype:'tbseparator',
		width: 2,
		height: 30,
		margin:0,
		id: '',
		cls:'myDashboardFloatingMenuSeperator',
	},
	{
		xtype: 'button',
		//width: 20,
		//height:30,
		margin: 0,
		padding:0,
		cls:'dashboardHeaderIcons',
		buttonId: 'ModifyTemplate',
		id : 'ModifyTemplate',
		name : 'modifyButton',
		cls:'dashboardHeaderIcons',
		iconCls: 'iconOneClickHeaderSettings',		
		overCls: 'buttonOver myDashboard',
		pressedCls: 'buttonPressedDashboard',
		id : 'ModifyTemplate',
		toggleGroup :true,
		enableToggle: true,
		name : 'modifyButton',
		defaultState : function() {
			var btn = this;
			btn.setText('');
			if (btn.pressed)
			{
				//alert(btn.pressed);
				btn.toggle(false);
				btn.removeCls('buttonOver');
			}

		},
		listeners: {
				afterrender: function () {
				/*Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: screenLabelsObj['Edit Template']
				});*/
			},
			 mouseover: function(btn) {
					btn.setText("<div class='newFont_normal15' style='margin: -2px 5px 0 ; color:#ffffff;'>"+screenLabelsObj['Edit Template']+"</div>");
				},
				mouseout: function(btn ){
					if (btn.pressed)
					{
					btn.setText("<div class='newFont_normal15' style='margin: -2px 5px 0 ; color:#ffffff;'>"+screenLabelsObj['Edit Template']+"</div>");
					}
					else{
							btn.setText("");
							btn.removeCls('buttonOver');
					}
				}
		}
	},
	/*{
		xtype: 'button',
        width: 20,
		height:20,
		//overCls: 'buttonOver',
		buttonId: 'ModifyTemplate',
		id : 'modifyButton',
		name : 'modifyButton',
		cls:'dashboardHeaderIcons',
		iconCls: 'iconOneClickHeaderSettings',
		listeners: {
			afterrender: function () {
				Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: 'Edit Template'
				});
			}
		}
	},*/
		{
		xtype:'tbseparator',
		width: 2,
		height: 30,
		margin:0,
		id: '',
		cls:'myDashboardFloatingMenuSeperator',
	},
	{
		xtype: 'button',
        //width: 20,
		//height:25,
		margin: 0,
		padding: 0,
		defaultState : function() {
			var btn = this;
			btn.setText('');
			if (btn.pressed)
			{
				//alert(btn.pressed);
				btn.toggle(false);
				btn.removeCls('buttonOver');
			}

		},
		cls:'dashboardHeaderIcons',
		overCls: 'buttonOver myDashboard',
		pressedCls: 'buttonPressedDashboard',
		id : 'cloneTemplate',
		buttonId: 'Clone Template',
		toggleGroup :true,
		enableToggle: true,
		iconCls: 'iconOneClickHeaderClone',
		defaultState : function() {
			var btn = this;
			btn.setText('');
			if (btn.pressed)
			{
				//alert(btn.pressed);
				btn.toggle(false)
			}

		},
		listeners: {
			afterrender: function () {
				/*Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: screenLabelsObj['Clone Template']
				});*/
			},
			
			 mouseover: function(btn) {
					btn.setText("<div class='newFont_normal15' style='margin: -2px 5px 0 ; color:#ffffff;'>"+screenLabelsObj['Clone Template']+"</div>");
				},
				
				mouseout: function(btn ){
					if (btn.pressed)
					{
					btn.setText("<div class='newFont_normal15' style='margin: -2px 5px 0 ; color:#ffffff;'>"+screenLabelsObj['Clone Template']+"</div>");
					}
					else{
							btn.setText("");
							btn.removeCls('buttonOver');
					}
				}
		}
	},
	/*{
		xtype: 'button',
        width: 20,
		height:20,
		cls:'dashboardHeaderIcons',
		//overCls: 'buttonOver',
		buttonId: 'Clone Template',
		iconCls: 'iconOneClickHeaderClone',
		listeners: {
			afterrender: function () {
				Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: 'Clone Template'
				});
			}
		}
	},*/
		{
		xtype:'tbseparator',
		width: 2,
		height: 30,
		margin:0,
		id: '',
		cls:'myDashboardFloatingMenuSeperator',
	},
	{
        xtype: 'button',
       // width: 20,
		//height:25,
		margin: 0,
		padding: 0,
        overCls: 'buttonOver myDashboard',
		pressedCls: 'buttonPressedDashboard',
		id: 'deleteTemplate',
		cls:'dashboardHeaderIcons',
        buttonId: 'Delete Template',
		iconCls: 'iconOneClickHeaderDelete',
		itemId: 'iconOneClickHeaderDelete',       
		toggleGroup :true,
		enableToggle: true,
		defaultState : function() {
			var btn = this;
			btn.setText('');
			if (btn.pressed)
			{
				//alert(btn.pressed);
				btn.toggle(false);
				btn.removeCls('buttonOver');
			}

		},
        listeners: {
            afterrender: function () {
                /*Ext.create('Ext.tip.ToolTip', {
                    target: this.id,
                    anchor: 'top',
                    cls: 'yellowTip',
                    trackMouse: true,
                    html: screenLabelsObj['Delete Template']
                });*/
            },
			
			mouseover: function(btn) {
					btn.setText("<div class='newFont_normal15' style='margin: -2px 5px 0; color:#ffffff;'>"+screenLabelsObj['Delete Template']+"</div>");
				},
				mouseout: function(btn ){
					if (btn.pressed)
					{
					btn.setText("<div class='newFont_normal15' style='margin: -2px 5px 0 ; color:#ffffff;'>"+screenLabelsObj['Delete Template']+"</div>");
					}
					else{
							btn.setText("");
							btn.removeCls('buttonOver');
					}
				}
        }
    },
	/*{
		xtype: 'button',
        width: 20,
		height:20,
		//overCls: 'buttonOver',
		cls:'dashboardHeaderIcons',
		buttonId: 'Delete Template',
		iconCls: 'iconOneClickHeaderDelete',
		listeners: {
			afterrender: function () {
				Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: 'Delete Template'
				});
			}
		}
	},*/
		{
		xtype:'tbseparator',
		width: 2,
		height: 30,
		margin:0,
		id: '',
		cls:'myDashboardFloatingMenuSeperator',
	},
	]
});
