Ext.define('TemplateBuilder.view.TemplateLayout', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.templateLayout',
	requires:['TemplateBuilder.view.Portlet','utilities.gridstackPanel'],
	border:false,
	frame:false,
	bodyPadding:'0 0 0 0',
	margin:0,
	cls:'OneClickConfigMainBody',
    id: 'templateLayoutObj',
    autoScroll: true,
	profileName : '',
	mode : 'edit',
	
	isSharedTemplate :false,
	isDefaultTemplate : false,
	layoutchoosen:'',
	isHomePage : "false",
    initComponent: function () {
        var me = this;
        this.layout = {
            type: 'fit'
        };
		me.items = {
			xtype: "gridstackpanel",
			id : 'gridstackpanelObj',
			name : 'gridstackpanelObj',
			portlet:function(obj,action,widgetTitle,widgetImgsrc,imgIcon){
				var me = this;
				if($('#noData')){
					$('#noData').remove();
				}
				
				var 	portlet,objArray;
				//@ checking wheather its getting obj is array or array object 
				if(Ext.isArray(obj)){
					objArray = obj;
				}else{
					objArray = [];
					objArray.push(obj);
				}

				var isSharedTemplate=false;
				var isDefaultTemplate=false;
				//var internalId = '';
				var user  = loginUser;
				if(publicJson!=null && publicJson['templateConfigDetails'].hasOwnProperty('isSharedTemplate'))
				{
					if(publicJson['templateConfigDetails']['isSharedTemplate'] == "true")
					{
						isSharedTemplate=true;
						user = null;
					}
				}
				 if(publicJson!=null && publicJson['templateConfigDetails'].hasOwnProperty('isDefaultTemplate'))
				{
					if(publicJson['templateConfigDetails']['isDefaultTemplate'] == "true")
					{
						isDefaultTemplate=true;
						user = null;
					}
				}
				var widgetBtnArr = new Array();
				

				_.each(objArray, function (node) {
					
						var blockID = node.id,
						renderToID = node.id+'_inner',
						width =Ext.get(renderToID).getWidth(),
						height =Ext.get(renderToID).getHeight();
						//Loading portlet toolbar items;
						me.loadPortletToolbarItems(node);

						var internId=obj.internalId;

						if (action != null && action == 'addWidget') {
							internId='';
							widgetBtnArr.push({
								xtype: 'container',
								baseCls: 'OneClickConfigButton',
								action: 'configme',
								flex: 1,
								html: '<div style="height:100%;width:100%;display:table;"><div style="display:table-cell;vertical-align:middle;text-align:center;" align="center"><img onclick="javascript:configPopup(\''+node.id+'\',\''+action+'\',\''+user+'\');"  class="'+widgetImgsrc+' mouse" src="/final/images/clear.png" border="0px" width="42px" height="42px" /><div style="text-align:center;"><br/><span class="widgetName mouse newFont_normal13"><a class="" onclick="javascript:configPopup(\''+node.id+'\',\''+action+'\',\''+user+'\');">'+ConfigTitle+'</a></span></div></div></div>'
							});
						}
						var isDefWidget=false;
						if(node!=null && node.hasOwnProperty('isDefaultWidget'))
						{
							isDefWidget=obj.isDefaultWidget;
						}

						portlet = Ext.create('TemplateBuilder.view.Portlet',{
														action : action,
														closeAction:'destroy',
														title:'&nbsp;&nbsp;',
														renderTo:renderToID,
														headerAsText  : false,
														relationTo:node.id,
														id:blockID,
														width:width,
														height:height,
														internalId : internId,
														isDefaultWidget : isDefWidget,
														items: widgetBtnArr,
														isSharedTemplate : isSharedTemplate,
														isDefaultTemplate:isDefaultTemplate
											});
									});
				
				
								return portlet;
				
			
						
			},
			getResizePositions : function(event)
			{
				var profName = me.profileName;
				var meGridstackPnl=this;
				var layoutchoosen = meGridstackPnl.layoutchoosen;
				if(layoutchoosen!=null && layoutchoosen == 'Custom')
				{
					meGridstackPnl.widgetResize =true;
				}
				if(meGridstackPnl.widgetResize)
				{
					Ext.defer(function(){
                        var cPanlId =event.target.id;
						if(cPanlId!=null && cPanlId.indexOf("_outer")>-1) // To avoid ID Conflict without outer gridstack widget & ExtJS Panel
						{
							cPanlId=cPanlId.substring(0,cPanlId.indexOf("_outer"));
						}
                       var pnlPositions = meGridstackPnl.getTBPanelPositions();
					   var adjWidth=$('#'+cPanlId+'_inner').outerWidth(true);
					   var adjHeight=$('#'+cPanlId+'_inner').outerHeight(true);
						
					tempBuilderApp.getController("Main").saveFluidTemplateWindowResizeConfig(profName, pnlPositions);
					},200);
				}
			},
			getDragPositions: function()
			{
				var profName = me.profileName;
				var meGridstackPnl=this;
				if(meGridstackPnl.layoutchoosen!=null && meGridstackPnl.layoutchoosen == 'Custom')
				{
					meGridstackPnl.widgetResize =true;
				}
				if(meGridstackPnl.widgetResize)
				{
						 Ext.defer(function(){
							   var pnlPositions = meGridstackPnl.getTBPanelPositions();
								tempBuilderApp.getController("Main").saveFluidTemplateWindowResizeConfig(profName, pnlPositions);
							},200);
				}
			},
			layoutchoosen:this.layoutchoosen
		}
		this.callParent();
	},
	listeners : {
		'afterrender' : function(templateLayoutObj)
		{
			var templateMainPanelObj = Ext.getCmp('templateMainPanel');
			templateMainPanelObj.header.clearManagedListeners();
			if(!Ext.isEmpty(templateLayoutObj))
			{
				var isSharedTemplate=templateLayoutObj.isSharedTemplate;
				if(templateMainPanelObj.header){
						var templateConfigToolsObj=Ext.getCmp('templateConfigTools');
						templateConfigToolsObj.clearManagedListeners();

						var templateToolsArr=templateConfigToolsObj.items.items;
						var isHidePnlSettings=true;
						var disableIcon=true;
						for(var p in templateToolsArr)
						{
							var pnl=templateToolsArr[p];
								pnl.show();
						}
						templateMainPanelObj.header.mon(templateMainPanelObj.header.el,'mouseover',function(){
						for(var p in templateToolsArr)
						{
							var pnl=templateToolsArr[p];
							pnl.show();
						}
						},templateMainPanelObj.header);
						templateMainPanelObj.header.mon(templateMainPanelObj.header.el,'mouseout',function(){
						for(var p in templateToolsArr)
						{
							var pnl=templateToolsArr[p];
							pnl.show();
						}
						},templateMainPanelObj.header);
						templateConfigToolsObj.doComponentLayout();
						templateConfigToolsObj=null;
						delete templateConfigToolsObj;
						templateMainPanelObj=null;
						delete templateMainPanelObj;
					}
			}
		}
	}

});