
Ext.define('TemplateBuilder.view.UserDefinedWidgetSlider',{
	alias:'widget.userDefinedWidgetSlider',
	extend:'Ext.panel.Panel',
	title:'<div class="x-form-item-label padding4" style="padding:4px 4px 4px 10px">'+screenLabelsObj['Graphical Type']+'</div>',
	scroll:false,
	autoScroll:false,
	bodyPadding:0,
	frame:false,
	bodyStyle:{'position':'relative','overflow':'visible'},
	bodyCls:'iconChooseTempOuter',
	margin:0,
	ui:'plain',
	hidden:false,
	itemToSet:1,
	profileName:'',
	blockId:null,
	data:[],
	height:350,
	width:strSkin =="Light"?268:270,
	//width:270,
	widthofDockedItems:40,
	effect:'easeIn',
	layout:{
		type:'hbox',
		align:'stretch'
	},
	setData:function(data){
		var me = this;
		if(this.data != null){
			me.data = data;
		}
	},
	getData:function(){
		return this.setData(this.data);
	},
	onShow:function(){
		var me = this;
		me.fireEvent('loadData',me);
		me.callParent();
	},
	onRender:function(){
			var me = this;
			if(me.hidden == false){
					me.onShowData();
						}
			me.callParent();
	},
	onShowData:function(){

	var me = this;
	var itemsArry =[];
	me.buttonWidth = Math.round((me.width - me.widthofDockedItems) / me.itemToSet);
	me.incrementBy =  Math.round(me.buttonWidth * me.itemToSet);
	me.decrementBy = Math.round(me.buttonWidth * me.itemToSet);
	me.moveIt = 0;
	me.orgin =0;
	if(me.data == null || me.getData() == "undefined" ){
			Ext.defer(function(){
				me.body.update('NO DATA FOUND');
			},100,me);
	}
	if(me.data != null && !Ext.isEmpty(me.data)){
		dataLength = me.data.length;
		var totalCount = dataLength;
		var perContainer = 12;
		var containerCount = Math.ceil(totalCount/perContainer);
		var j=0;
		var k = 0;
		var templength = dataLength;
		var limt = perContainer;
		for (var i=0;i < containerCount;i++ )
		{
			itemsBT ={
				xtype:'container',
				width:me.buttonWidth -1,
				padding:0,
				layout:'column',
				border:false,
				margin:0,
				height:me.height,
			}
			var newCont = [];
			for (var t=0; t<perContainer;t++ )
			{
				if(k==totalCount)
				{
					break;
				}
				var internName = me.data[k].internalName;
				var btnGrp = '';
				if(internName == 'TopNGaugeChart' || internName == 'TopNDigitalChart' || internName == 'TopN')
				{
					btnGrp = 'gaugedigitalGrp';
				}
				else if(internName == 'TabularView' || internName == 'LineGraph' || internName == 'TimelineChart' || internName == 'AreaChart' || internName == 'BarChart' || internName == 'HeatMapChart' || internName == 'PieChart'|| internName == 'activityChart')
				{
					btnGrp = 'MultiRowConfigGrp';
				}
				else if(internName == 'CombinationChart')
				{
					btnGrp = 'combConfigGrp';
				}
				else if(internName == 'DDTable')
				{
					btnGrp = 'ddColumnConfigGrp';
				}
				else if(internName == 'liveMeasuresBox')
				{
					btnGrp = 'singleTestGrp';
				}
				tmpCon ={
					xtype:'button',
					width:73,
					padding:0,
					id:me.data[k].internalName+'_cont',
					value:me.data[k].internalName,
					btnGrp:btnGrp,
					cls:'addTemplateButton',
					enableToggle:true,
					toggleGroup:'widgetGroup',
					html:'<div style="height:78px;padding-top:10px;"><div style="height:36px"><img src="/final/images/clear.png" class='+me.data[k].imgClsName+'></div><div class="addWidgetButtonText">'+me.data[k].graphName+'</div></div>',
					height:81,
					handler:function(){
						tempBuilderApp.getController("Main").onGraphTypeSelect(this);
						}
				}
				newCont.push(tmpCon);
				k=k+1;
			}
			itemsBT.items =  newCont;
			itemsArry.push(itemsBT);
			if(k==totalCount)
			{
				break;
			}
			continue;
		}
	}else{

	}

	me.suspendLayouts();
	me.add({
		xtype:'container',
		cls:'iconChooseTempContainer',
		layout:{type:'hbox'},
		items:itemsArry
	});

	me.resumeLayouts();

	me.initToolbar();
	},
	initEvents : function() {
        var me = this;
        me.callParent();
        me.on('loadData', me.onShowData, me);
    },
	initComponent:function(){
	var me = this;
	this.addEvents({
                "loadData" : true
            });
	me.callParent();
	},
	initToolbar:function(){
		var me = this;
		if(!Ext.isEmpty(me.data)){
			Ext.ComponentQuery.query('button[itemId ="next"]')[0].disable();
			if (me.data.length <= 12)
			{
				Ext.ComponentQuery.query('button[itemId ="previous"]')[0].disable();
			}
			if(me.data.length == me.itemToSet){
				Ext.ComponentQuery.query('button[itemId ="next"]')[0].disable();
			}
			if(me.data.length == me.itemToSet){
				Ext.ComponentQuery.query('button[itemId ="previous"]')[0].disable();
			}
		}
	},
	getBodyOffsetleft:function(){
		return this.body.dom.offsetLeft;
	},
	getBodyWidth:function(){
		return this.body.getWidth();
	},
	getSliderId:function(){
		return this.getComponent(0).id;
	},
	getSliderWidth:function(){
		return Ext.get(this.getSliderId()).getWidth();
	},
	getSliderOffsetLeft:function(){
		return Ext.get(this.getSliderId()).dom.offsetLeft;
	},
	getSliderOffsetWidth:function(){
		return Ext.get(this.getSliderId()).dom.offsetWidth;
	},
	animate:function(orgin,effect){
			effect = this.effect || effect;
			Ext.get(this.getSliderId()).animate({
						 to: {
							 marginLeft: orgin
						 },
						  easing: effect
					 });
	},
	slideMovement:function(button){
				var me = this;
				var last_gap_be = me.getSliderWidth() % me.incrementBy;
				var last_gap_bes = me.getSliderWidth() % me.decrementBy;
				me.effect = 'easeIn';
				if(button.itemId == 'previous'){

						me.moveIt += me.incrementBy;
						me.orgin = - me.moveIt;
						Ext.ComponentQuery.query('button[itemId ="next"]')[0].enable();
						condition = - me.getSliderOffsetWidth() + me.getBodyWidth() + last_gap_be;
						if(me.orgin <= condition){
							me.effect = 'backOut';
							me.orgin = me.getSliderOffsetLeft() - last_gap_be;
							button.disable();
						}
				}else{

					me.moveIt -= me.decrementBy;
					me.orgin = - me.moveIt;
					Ext.ComponentQuery.query('button[itemId ="previous"]')[0].enable();
					if(me.orgin >= 0){
							me.effect = 'backOut';
							me.orgin = 0;
							button.disable();
					}
				}
				me.animate(me.orgin,me.effect);

	},
	dockedItems: [{
		xtype: 'toolbar',
		dock: 'left',
		items: [
			'->',
			{
				xtype: 'button',
				itemId:'next',
				cls:'iconChooseTempNextBut',
				iconCls:'iconChooseTempLeftArrow',
				text: '',
				style:{
					'background':"none",
					'border':"0px",
					'height':"20px !important",
				},
				height:24,
				getParent: function(){return this.up('panel')},
				handler:function(btn,event){
					btn.getParent().slideMovement(btn);
				}
			},
			'->'
		]
	},{
		xtype:'toolbar',
		dock:'right',
		items:[
			'->',
			{
				xtype: 'button',
				itemId:'previous',
				cls:'iconChooseTempPreviousBut',
				iconCls:'iconChooseTempRightArrow',
				text: '',
				style:{
					'background':"none",
					'border':"0px",
					'height':"20px !important",
				},
				height:24,
				getParent: function(){ return this.up('panel')},
				handler:function(btn,event){
					btn.getParent().slideMovement(btn);
				}
			},
			'->'
		]
	}]

});

