
Ext.define('TemplateBuilder.view.UserDefinedWidgetWindow', {
	alias: 'widget.userDefinedWidgetWindow',
	extend:'Ext.window.Window',
	height : 540,
	width:934,
	///height:strSkin=="Light"?510:500,
	//width:strSkin=="Light"?954:934,
	autoScroll:false,
	scroll:false,
	resizable:false,
	header:{
		height:50,
		padding:'0 10',
		margin:0
	},
	ui:'newPopupWindow   widgetOptionsWindowHeader',
	ghost:false,
	cls:'myDashboardwindow',
	frame:false,
	id:'userDefinedWindowaa',
	padding:0,
	bodyPadding:0,
	margin:0,
	blockId :null,
	internalId :null,
	widgetAction :'',
	isFluidWindowConfigPopup : false,
	border:true,
	modal:true,
	confguredWidgetName:'',
	chartType:'',
	configuredDataValue:null,
	defaultExcludeIncludeOpt:null,
	chartName:'',
	title:'Layout Settings',
	requires: [
			'Ext.ux.form.ItemSelector',
			'utilities.ScrollCombo',
			'utilities.CustomGrid',
			'utilities.Utilities',
			'Ext.ux.form.MultiSelect',
			'utilities.Multiselector',
			'utilities.CustomTrigger',
			'Ext.ux.TabScrollerMenu',
			'TemplateBuilder.view.UserDefinedWidgetSlider',
		'Ext.selection.CellModel','Ext.selection.CheckboxModel'
	],
	tools:[
		{
			xtype : 'button',
			iconCls : 'iconHelp',
			listeners: {
				afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
						target: this.id,
						anchor: 'top',
						cls: 'yellowTip',
						trackMouse: true,
						html: helpTooltip
					});
				}
			},
			style : {
				'background' : 'none',
				'border' : '0px',
				'margin':'0 1 0 0',
			},
			handler : function()
			{
				HelpWin();
			}
		}
	],
	closeAction : 'destroy',
	profileName : '',
	layout:{type:'fit'},

	initComponent: function () {
		var windowWidget = this;
		var thisBlockId = windowWidget.blockId;
		windowWidget.suspendEvents(true);
		var profilename = Ext.getCmp('templateLayoutObj').profileName;
		windowWidget.createCommonBlockLayout(profilename,thisBlockId);
		windowWidget.resumeEvents();
        windowWidget.callParent();
    },
	loadDefaultDataForCommonLayout: function (thisBlockId,thisInternalId) {
		 var mePopup = this;
		 defaultSelectedGraph = '';
		 tempSelectedGraph = '';
		 associatedGrp ='';
		 availBtnGrp ='';
		 widgtgrpArr ='';
		 isTopNWidget = false;
		 topNVal = '';
        var metricsFormPanelObj = this.getComponent('configForm');
        var metricsForm = metricsFormPanelObj.getForm();
		var editViewPage='templateLayoutObj';
		 var profileName = Ext.getCmp('templateLayoutObj').profileName;
		 var thisWind = null;
		 reGenerateCompsFromExclude=false;
		if(mePopup.isFluidWindowConfigPopup)
		{
			thisWind = new Ext.LoadMask(this.getEl(), {
            msg: "Loading.."
			});
			thisWind.show();
		}
		var paramsTorender = 'comesFrom=templateBuilder&action=loadWidgetConfigPopup&profileName=' + encodeURIComponent(profileName) + '&blockId=' + encodeURIComponent(thisBlockId) +'&internalId='+ encodeURIComponent(thisInternalId) +'&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height);
		Ext.Ajax.request({
            url: '/final/servlet/com.eg.EgMonitorRequestDispatcher',
            method: 'POST',
            params: paramsTorender,
            scope: this,
            success: function (response) {
				 var jsonText = response.responseText;
                if (jsonText != null && jsonText != '') {
					if(mePopup.isFluidWindowConfigPopup && thisWind!=null)
					{
						thisWind.hide();
					}
					var jsonData = Ext.decode(jsonText);
					var configuredData = jsonData['configuredDetails'];
					var dispType = configuredData['DisplayType'];
					this.suspendEvents(true);

					Ext.suspendLayouts();
					var testCombo = metricsForm.findField('testCombo');
					testCombo.suspendEvents(true);
					testCombo.getStore().loadRawData(jsonData['tests']);
					if(dispType != 'DDTable')
					{
						testCombo.setValue('-1');
					}
					//testCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Test']);
					testCombo.resumeEvents();
					metricsForm.findField('measurelist').hide();
					metricsForm.findField('metricsSearchTextBox').hide();
					metricsForm.findField('measureListCombo').hide();
					Ext.getCmp('measureLbl').hide();
					metricsForm.findField('ddcolumnsMultiSelect').hide();
					Ext.getCmp('ddcolumnsLbl').hide();
					Ext.getCmp('addtoGridBtn').hide();
					
					var grapdata = jsonData['configuredDetails']['graphicalLibArr'];
					if(!Ext.isEmpty(createSlider)){
						Ext.destroy(createSlider);
					}
					
					var graphTypeObj =  configuredData['DisplayType'];
					if(graphTypeObj!=null && !Ext.isEmpty(graphTypeObj))
					{
						this.confguredWidgetName= graphTypeObj;
						this.configuredDataValue=configuredData;
					}else{
						this.confguredWidgetName= '';
						this.configuredDataValue='';
					}
				
					var createSlider = new Ext.create('TemplateBuilder.view.UserDefinedWidgetSlider',{
							profileName:profileName,
							blockId:thisBlockId,
							data:grapdata,
							id:thisBlockId+'_slider',
							listeners:{
								render:function(){
									var graphTypeObj =  configuredData['DisplayType'];
										if(graphTypeObj!=null && !Ext.isEmpty(graphTypeObj))
										{
											Ext.getCmp(graphTypeObj+'_cont').pressed = true;
											tempSelectedGraph = graphTypeObj;
											grapForWidget = graphTypeObj;
											availBtnGrp = Ext.getCmp(graphTypeObj+'_cont').btnGrp;
										}
										else
										{
											var graph = grapdata[0]['internalName'];
											Ext.getCmp(graph+'_cont').pressed = true;
											tempSelectedGraph = graph;
											availBtnGrp = Ext.getCmp(graph+'_cont').btnGrp;
										}
								}
							}
					});
					Ext.getCmp('loadSlider').removeAll();
					Ext.getCmp('loadSlider').add(createSlider);

					//Ext.getCmp(thisBlockId+'_slider').setData(configuredData['graphicalLibArr']);

					Ext.getCmp(thisBlockId+'_slider').show();
					var imgIcon = configuredData['imgClassname'];
					if(imgIcon!=null && imgIcon!="")
					{
						if(imgIcon.indexOf(":")>0 && imgIcon.startsWith("Default"))
						{
							imgIcon = imgIcon.substring(imgIcon.indexOf(":")+1);
							Ext.getCmp('userDefinedWidgetIcon').update('<div id="userDefinedImgDefault" class="userDefinedImgDefault" style="background-position:center 50%;margin:auto auto;overflow:hidden"  ><div id="widgetImageIcon"  class= "'+imgIcon+'" border="0px" style="position: absolute;top:0%;left: 0%;right: 0%;margin: auto;bottom: 0%;width:32px;height:32px"></div><div id="settingOver" class="settingOver"></div></div>');
						}
						else
						{
							imgIcon = '/final/images/icon-library/'+loginUser+'/'+imgIcon;
							Ext.getCmp('userDefinedWidgetIcon').update('<div id="userDefinedImgDefault" class="userDefinedImgDefault" ><img id="widgetImageIcon"  src= "'+imgIcon+'" width="100%" height="100%" border="0px"/><div id="settingOver" class="settingOver"></div></div>');
						}
					}
					else
					{
						imgIcon = '/final/images/'+strSkin+'/listViewWidgetDefaultSmall.png';
						var widgetImageIconObj=$('#widgetImageIcon');
						Ext.getCmp('userDefinedWidgetIcon').update('<div id="userDefinedImgDefault" class="userDefinedImgDefault" style="padding:5px"><img id="widgetImageIcon"  src= "'+imgIcon+'" width="32px" height="32px" border="0px"/><div id="settingOver" class="settingOver"></div></div>');
					}
					Ext.get('userDefinedImgDefault').on('mouseenter',function(){
					Ext.get('settingOver').update('<a href="javascript:void(0)" id="changeImg"><div class="userDefinedImgDefaultOver" style="display:block;padding:5px;"><table border="0px" cellpadding="0px" cellspacing="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><span style="width:20px;height:20px;display:inline-block" class="iconOneClickImgDefaultChange"></span></td></tr></table></div></a>');

					Ext.get('changeImg').on('click',function(){
					var imgUploadWindow = Ext.create('TemplateBuilder.view.IconLibrary',{
						from:'widgetUpload',
						windowId:'widgetWindowId',
						custUploadPath:'manager/tomcat/webapps/final/images/icon-library/'+loginUser+'/',
					}).show()

						imgUploadWindow.on('close', function() {
						imgUploadWindow.destroy();
						imgUploadWindow = 'closed';
					});
						},Ext.get('changeImg'))
					});

					Ext.get('settingOver').on('mouseleave',function(){
						Ext.get('settingOver').update('');
					});

					if(thisInternalId!=null && thisInternalId!='')
					{
						if(thisInternalId.indexOf('|GRP|')>0)
						{
							thisInternalId = thisInternalId.substring(0,thisInternalId.indexOf('|GRP|'));
						}
						Ext.getCmp('WidgetNametextField').hide();
						Ext.getCmp('userDefinedWidgetNameLbl').setText(thisInternalId);
						Ext.getCmp('userDefinedWidgetNameLbl').show();
						$('#iconRename').show();
					}
					else
					{
						Ext.getCmp('WidgetNametextField').show();
						Ext.getCmp('userDefinedWidgetNameLbl').setText('');
						Ext.getCmp('WidgetNametextField').setValue('');
						Ext.getCmp('userDefinedWidgetNameLbl').hide();
						$('#iconRename').hide();
					}
					var widgetDescription = configuredData['Description'];
					if(widgetDescription!=null && widgetDescription!='undefined')
					{
						Ext.getCmp('widgetDescrText').setValue(widgetDescription);
					}
					else
					{
						Ext.getCmp('widgetDescrText').setValue('');
					}
					var addedToWidgetLibrary = configuredData['AddedToWidgetLibrary'];
					var addToWidgetLibRadioBtnOpt=metricsForm.findField('addToWidgetLibRadioBtn');
					addToWidgetLibRadioBtnOpt.suspendEvents(false);
					if(addedToWidgetLibrary==null || addedToWidgetLibrary=="undefined" || addedToWidgetLibrary=="")
					{
						addedToWidgetLibrary = "no";
					}
					addToWidgetLibRadioBtnOpt.setValue({
									addToWidgetGrprb : addedToWidgetLibrary
								});
					addToWidgetLibRadioBtnOpt.resumeEvents();
					addToWidgetLibRadioBtnOpt.show();
					addToWidgetLibRadioBtnOpt=null;
					delete addToWidgetLibRadioBtnOpt;
					Ext.getCmp('NewGrptxtField').setValue('');
					var GrpsCombo = metricsForm.findField('widgetGrpCombo');
					GrpsCombo.suspendEvents(false);
					if(GrpsCombo!=null && !Ext.isEmpty(GrpsCombo) && addedToWidgetLibrary == 'yes')
					{
						 associatedGrp = configuredData['AssociatedGrp'];
						/*if(associatedGrp!=null && !Ext.isEmpty(associatedGrp))
						{
							console.log("associatedGrp:",associatedGrp);
							GrpsCombo.setValue(associatedGrp);
						}*/
					}
					GrpsCombo.resumeEvents();
					var configTableGrid = Ext.getCmp('configTableGrid');
					configTableGrid.suspendEvents(true);
                    var gridStore = configTableGrid.getStore();
					gridStore.removeAll();
					var gridData = configuredData['gridData'];
					
					var isMultiPieChart = false;
					if(dispType == null || dispType == 'undefined' || dispType=='')
					{
						dispType = grapdata[0]['internalName'];
					}

					if(dispType != null && dispType != 'servicehealth')
					{
						Ext.getCmp('testCombo').show();
						//metricsForm.findField('testCombo').show();
						metricsForm.findField('testCombo').resumeEvents();
					}

					var showGrid = true;

					if(dispType == 'DDTable')
					{
						showGrid = false;
						var categoryOptsObj = metricsForm.findField('categoryOpts');
						var healthTestObj = metricsForm.findField('healthCenterTestScrollCombo');
						var healthCenterCompTypeComboObj = metricsForm.findField('healthCenterCompTypeCombo');
						var compContinerObj = metricsForm.findField('healthCenterCompContiner');
						compContinerObj =  Ext.getCmp('healthCenterCompContiner');

						if(!Ext.isEmpty(categoryOptsObj))
						{
							categoryOptsObj.hide();
						}
						if(!Ext.isEmpty(healthTestObj))
						{
							healthTestObj.hide();
						}
						if(!Ext.isEmpty(compContinerObj))
						{
							compContinerObj.hide();
						}
						if(!Ext.isEmpty(healthCenterCompTypeComboObj))
						{
							healthCenterCompTypeComboObj.hide();
						}
						Ext.getCmp('oneMetricTxt').hide();
						Ext.getCmp('selectionDetailsLbl').hide();

						var selectedChartType = '';

						var graphicalOptsObj = Ext.getCmp('graphicalTypeId');
						if(!Ext.isEmpty(graphicalOptsObj) && configuredData.hasOwnProperty('chartDataCombo') && configuredData.hasOwnProperty('selectedChartType'))
						{
							selectedChartType = configuredData['selectedChartType'];
							graphicalOptsObj.suspendEvents(true);
							graphicalOptsObj.getStore().removeAll();
							graphicalOptsObj.getStore().loadRawData(configuredData['chartDataCombo']);
							graphicalOptsObj.setValue(configuredData['selectedChartType']);
							graphicalOptsObj.resumeEvents();
							graphicalOptsObj.show();
						}

						if(configuredData.hasOwnProperty('selectedTest') && configuredData.hasOwnProperty('selectedMeasure')&& configuredData.hasOwnProperty('selectedDDColumns'))
						{
							testCombo.isModification = true;
							testCombo.setValue(configuredData['selectedTest']);

							var selectedTest = configuredData['selectedTest'];
							var selectedMeasure = configuredData['selectedMeasure'];
							var selectedDDColumns = configuredData['selectedDDColumns'];
							var summarizedDDColumn = configuredData['summarizedDDColumn'];
							Ext.defer(function(){
								
								tempBuilderApp.getController("Main").onManualTestComboChange(selectedChartType,testCombo,selectedTest,selectedMeasure,selectedDDColumns,summarizedDDColumn);			
							},100)
						}
					}
					else if(dispType == 'TopNGaugeChart' || dispType == 'TopNDigitalChart' || dispType == 'TopN')
					{
						var categoryOptsObj = metricsForm.findField('categoryOpts');
						var healthTestObj = metricsForm.findField('healthCenterTestScrollCombo');
						var healthCenterCompTypeComboObj = metricsForm.findField('healthCenterCompTypeCombo');
						var compContinerObj = metricsForm.findField('healthCenterCompContiner');
						compContinerObj =  Ext.getCmp('healthCenterCompContiner');

						var graphicalOptsObj = Ext.getCmp('graphicalTypeId');
						var summarizeDDColumnObj = Ext.getCmp('summarizeDDColumnCombo');
						if(!Ext.isEmpty(graphicalOptsObj))
						{
							graphicalOptsObj.hide();
						}
						if(!Ext.isEmpty(summarizeDDColumnObj))
						{
							summarizeDDColumnObj.hide();
						}

						if(!Ext.isEmpty(categoryOptsObj))
						{
							categoryOptsObj.hide();
						}
						if(!Ext.isEmpty(healthTestObj))
						{
							healthTestObj.hide();
						}
						if(!Ext.isEmpty(compContinerObj))
						{
							compContinerObj.hide();
						}
						if(!Ext.isEmpty(healthCenterCompTypeComboObj))
						{
							healthCenterCompTypeComboObj.hide();
						}
						
						Ext.getCmp('oneMetricTxt').show();
						//configTableGrid.height = 120;
					}
					else if(dispType != null && dispType == 'servicehealth')
					{
						var graphicalOptsObj = Ext.getCmp('graphicalTypeId');
						var summarizeDDColumnObj = Ext.getCmp('summarizeDDColumnCombo');
						if(!Ext.isEmpty(graphicalOptsObj))
						{
							graphicalOptsObj.hide();
						}
						if(!Ext.isEmpty(summarizeDDColumnObj))
						{
							summarizeDDColumnObj.hide();
						}
						Ext.getCmp('oneMetricTxt').hide();
						metricsForm.findField('measurelist').hide();
						metricsForm.findField('metricsSearchTextBox').hide();
						metricsForm.findField('measureListCombo').hide();
						Ext.getCmp('testCombo').hide();
						metricsForm.findField('testCombo').resumeEvents();
						
						var selectedCategory = '';
						var categoryOptsObj = metricsForm.findField('categoryOpts');
						var healthTestObj = metricsForm.findField('healthCenterTestScrollCombo');
						var compContinerObj = metricsForm.findField('healthCenterCompContiner');
						compContinerObj =  Ext.getCmp('healthCenterCompContiner');
						var healthCenterComponentComboObj =  Ext.getCmp('healthCenterComponentCombo');
						var healthCenterCompTypeComboObj = metricsForm.findField('healthCenterCompTypeCombo');

						if(!Ext.isEmpty(categoryOptsObj))
						{
							if(configuredData.hasOwnProperty('categoryCombo') && configuredData.hasOwnProperty('selectedCategory'))
							{
								selectedCategory = configuredData['selectedCategory'];
								categoryOptsObj.suspendEvents(true);
								categoryOptsObj.getStore().removeAll();
								categoryOptsObj.getStore().loadRawData(configuredData['categoryCombo']);

								if(selectedCategory == 'Descriptors')
								{
									categoryOptsObj.setValue('-1');
								}
								else
								{
									categoryOptsObj.setValue(configuredData['selectedCategory']);
								}
								categoryOptsObj.resumeEvents();
								categoryOptsObj.show();
							}
						}

						if(selectedCategory != null && (selectedCategory == 'Zone' || selectedCategory == 'Segment' || selectedCategory == 'Service'))
						{
							showGrid = false;
							Ext.getCmp('selectionDetailsLbl').hide();
							if(!Ext.isEmpty(healthTestObj))
							{
								healthTestObj.hide();
							}
							if(!Ext.isEmpty(healthCenterCompTypeComboObj))
							{
								healthCenterCompTypeComboObj.hide();
							}
							if(!Ext.isEmpty(compContinerObj))
							{
								compContinerObj.show();
							}
							if(!Ext.isEmpty(healthCenterComponentComboObj))
							{
								if(configuredData.hasOwnProperty('availableOptions') && configuredData.hasOwnProperty('selectedFields'))
								{
									var availableOptions = configuredData['availableOptions'];
									if(availableOptions.hasOwnProperty('optionsForType'))
									{
										healthCenterComponentComboObj.suspendEvents(true);
										healthCenterComponentComboObj.getStore().removeAll();
										healthCenterComponentComboObj.getStore().loadRawData(availableOptions['optionsForType']);
										healthCenterComponentComboObj.setValue(configuredData['selectedFields']);
										healthCenterComponentComboObj.resumeEvents();
									}
								}
							}
						}
						else if(selectedCategory != null && selectedCategory == 'Components')
						{
							showGrid = false;
							Ext.getCmp('selectionDetailsLbl').hide();
							if(!Ext.isEmpty(healthTestObj))
							{
								healthTestObj.hide();
							}
							if(!Ext.isEmpty(compContinerObj))
							{
								compContinerObj.hide();
							}

							if(configuredData.hasOwnProperty('availableOptions') && configuredData.hasOwnProperty('selectedFields'))
							{
								var availableOptions = configuredData['availableOptions'];
								if(availableOptions.hasOwnProperty('availCompTypes'))
								{
									if(!Ext.isEmpty(healthCenterCompTypeComboObj))
									{
										healthCenterCompTypeComboObj.suspendEvents(true);
										healthCenterCompTypeComboObj.getStore().removeAll();
										healthCenterCompTypeComboObj.getStore().loadRawData(availableOptions['availCompTypes']);
										
										healthCenterCompTypeComboObj.getStore().insert(1,{
											displayField:'All types',
											valueField: 'allServers'
										});
										
										var isContainsValue = false;

										for(var k=0;k<availableOptions['availCompTypes'].length;k++)
										{
											var opt = availableOptions['availCompTypes'][k];
											var valueField = opt.valueField;
											
											if(valueField==configuredData['selectedFields'])
											{
												isContainsValue = true;
												break;
											}
										}
										if(configuredData['selectedFields'] != null &&configuredData['selectedFields'] == 'allServers')
										{
											isContainsValue = true;
										}						

										if(isContainsValue)
										{
											healthCenterCompTypeComboObj.setValue(configuredData['selectedFields']);
										}
										else
										{
											healthCenterCompTypeComboObj.setValue('-1');
										}									
										healthCenterCompTypeComboObj.resumeEvents();
										healthCenterCompTypeComboObj.show();
									}
								}
							}
						}
						else if(selectedCategory != null && selectedCategory == 'Descriptors')
						{
							showGrid = true;
							Ext.getCmp('selectionDetailsLbl').show();
							if(!Ext.isEmpty(healthTestObj))
							{
								healthTestObj.hide();
							}
							if(!Ext.isEmpty(healthCenterCompTypeComboObj))
							{
								healthCenterCompTypeComboObj.hide();
							}
							if(!Ext.isEmpty(compContinerObj))
							{
								compContinerObj.hide();
							}
						}
						else if(selectedCategory != null && selectedCategory == 'vms|desktop|users')
						{
							showGrid = false;
							Ext.getCmp('selectionDetailsLbl').hide();
							if(!Ext.isEmpty(healthTestObj))
							{
								healthTestObj.hide();
							}
							if(!Ext.isEmpty(compContinerObj))
							{
								compContinerObj.show();
							}

							if(configuredData.hasOwnProperty('availableOptions') && configuredData.hasOwnProperty('selectedFields'))
							{
								var availableOptions = configuredData['availableOptions'];
								if(availableOptions.hasOwnProperty('availCompTypes'))
								{
									if(!Ext.isEmpty(healthCenterCompTypeComboObj))
									{
										healthCenterCompTypeComboObj.suspendEvents(true);
										healthCenterCompTypeComboObj.getStore().removeAll();
										healthCenterCompTypeComboObj.getStore().loadRawData(availableOptions['availCompTypes']);
										
										/*healthCenterCompTypeComboObj.getStore().insert(1,{
											displayField:'All types',
											valueField: 'allServers'
										});*/
										
										var isContainsValue = false;

										for(var k=0;k<availableOptions['availCompTypes'].length;k++)
										{
											var opt = availableOptions['availCompTypes'][k];
											var valueField = opt.valueField;
											
											if(valueField==configuredData['selectedFields'])
											{
												isContainsValue = true;
												break;
											}
										}
										if(configuredData['selectedFields'] != null &&configuredData['selectedFields'] == 'allServers')
										{
											isContainsValue = true;
										}						

										if(isContainsValue)
										{
											healthCenterCompTypeComboObj.setValue(configuredData['selectedFields']);
										}
										else
										{
											healthCenterCompTypeComboObj.setValue('-1');
										}									
										healthCenterCompTypeComboObj.resumeEvents();
										healthCenterCompTypeComboObj.show();
									}
								}
							}

							if(configuredData.hasOwnProperty('availableOptions') && configuredData.hasOwnProperty('selectedFields'))
							{
								if(!Ext.isEmpty(healthCenterComponentComboObj))
								{
									if(configuredData.hasOwnProperty('availableVmOptions') && configuredData.hasOwnProperty('selectedvms'))
									{
										var availableOptions = configuredData['availableVmOptions'];
										if(availableOptions.hasOwnProperty('descriptorsList'))
										{
											healthCenterComponentComboObj.suspendEvents(true);
											healthCenterComponentComboObj.getStore().removeAll();
											healthCenterComponentComboObj.getStore().loadRawData(availableOptions['descriptorsList']);

											healthCenterComponentComboObj.getStore().insert(0,{
												displayField : allVms,
												valueField : 'allVms'
											});

											healthCenterComponentComboObj.setValue(configuredData['selectedvms']);
											healthCenterComponentComboObj.resumeEvents();
										}
									}
								}
							}
						}
					}
					else
					{
						var graphicalOptsObj = Ext.getCmp('graphicalTypeId');
						var summarizeDDColumnObj = Ext.getCmp('summarizeDDColumnCombo');
						if(!Ext.isEmpty(graphicalOptsObj))
						{
							graphicalOptsObj.hide();
						}
						if(!Ext.isEmpty(summarizeDDColumnObj))
						{
							summarizeDDColumnObj.hide();
						}
						var categoryOptsObj = metricsForm.findField('categoryOpts');
						var healthTestObj = metricsForm.findField('healthCenterTestScrollCombo');
						var compContinerObj = metricsForm.findField('healthCenterCompContiner');
						compContinerObj =  Ext.getCmp('healthCenterCompContiner');
						var healthCenterCompTypeComboObj = metricsForm.findField('healthCenterCompTypeCombo');

						if(!Ext.isEmpty(categoryOptsObj))
						{
							categoryOptsObj.hide();
						}
						if(!Ext.isEmpty(healthTestObj))
						{
							healthTestObj.hide();
						}
						if(!Ext.isEmpty(compContinerObj))
						{
							compContinerObj.hide();
						}
						if(!Ext.isEmpty(healthCenterCompTypeComboObj))
						{
							healthCenterCompTypeComboObj.hide();
						}
						
						Ext.getCmp('oneMetricTxt').hide();
						//configTableGrid.height = 180;
					}

					if (gridData!=null && !Ext.isEmpty(gridData)) {
						if(dispType!=null && dispType == 'CombinationChart')
						{
							configTableGrid.hideChartType = false;
							var column = Ext.create('Ext.grid.column.Column', {
								text: 'Chart Type',
								dataIndex: 'chartType',
								field: {
								xtype: 'scrollcombo',
								editable : false,
								selectOnTab: true,
								displayField: 'displayField',
								valueField: 'valueField',
								store : Ext.create('Ext.data.Store', {
											fields: ['displayField', 'valueField'],
									data: [{'displayField' : 'line', 'valueField' : 'line'},{'displayField' : 'column','valueField' : 'column'},{'displayField' : 'Area','valueField' : 'Area'}]
								}),
								lazyRender: true
								}
							});
							configTableGrid.headerCt.insert(
								configTableGrid.columns.length-1, // that's index column
								column);

							configTableGrid.getView().refresh();
						}
						if(dispType!=null && dispType == 'DDTable')
						{
							var column = Ext.create('Ext.grid.column.Column', {
								text: 'DD Columns',
								dataIndex: 'ddval',
								renderer: function(value, metaData) {
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
								return value;
								}
							});
							configTableGrid.headerCt.insert(
								configTableGrid.columns.length-1, // that's index column
								column);

							configTableGrid.getView().refresh();
						}
						if(dispType!=null && dispType == 'servicehealth')
						{

							for(var index = 1; index < configTableGrid.columns.length; index++)
							{
								if(configTableGrid.columns[index].text == 'Component Type')
								{
									configTableGrid.headerCt.remove(index);
									configTableGrid.getView().refresh();
									break;
								}
							}
							for(var index = 1; index < configTableGrid.columns.length; index++)
							{
								if(configTableGrid.columns[index].text == 'Descriptor')
								{
									configTableGrid.headerCt.remove(index);
									configTableGrid.getView().refresh();
									break;
								}
							}

							var containsComponentType = false;
							var containsDescriptors = false;
							for(var indexvar = 1; indexvar < configTableGrid.columns.length; indexvar++)
							{
								if(configTableGrid.columns[indexvar].text == 'Component Type' )
								{
									containsComponentType = true;
								}
								if(configTableGrid.columns[indexvar].text == 'Descriptor' )
								{
									containsDescriptors = true;
								}
							}
							
							if(!containsComponentType)
							{
								var column1 = Ext.create('Ext.grid.column.Column', {
									text: 'Component Type',
									dataIndex:'componentType',
									flex:.4,
									hidden:false,
									renderer: function(value, metaData) {
										metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
										return value;
									}
								});

								configTableGrid.headerCt.insert(
									1, 
									column1);
							}

							

							if(!containsDescriptors)
							{
								var column3 = Ext.create('Ext.grid.column.Column', {
									text: 'Descriptor',
									dataIndex:'Descriptor',
									flex:.4,
									hidden:false,
									renderer: function(value, metaData) {
										metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
										return value;
									}
								});

								configTableGrid.headerCt.insert(
								3, 
								column3);
							}	
							configTableGrid.getView().refresh();

							for(var indexvar = 1; indexvar < configTableGrid.columns.length; indexvar++)
							{
								if(configTableGrid.columns[indexvar].text == 'Measure')
								{
									configTableGrid.headerCt.remove(indexvar);
									configTableGrid.getView().refresh();
									break;
								}
							}

						}
						gridStore.add(gridData);
						configTableGrid.show();
						configTableGrid.resumeEvents();
						configTableGrid.doComponentLayout();
					} else {
						for(var index = 1; index < configTableGrid.columns.length; index++)
						{
							if(configTableGrid.columns[index].text == 'DD Columns' || configTableGrid.columns[index].text == 'Chart Type' )
							{
								configTableGrid.headerCt.remove(index);
								configTableGrid.getView().refresh();
								break;
							}
						}
						for(var index = 1; index < configTableGrid.columns.length; index++)
						{
							if(configTableGrid.columns[index].text == 'Component Type')
							{
								configTableGrid.headerCt.remove(index);
								configTableGrid.getView().refresh();
								break;
							}
						}
						for(var index = 1; index < configTableGrid.columns.length; index++)
						{
							if(configTableGrid.columns[index].text == 'Descriptor')
							{
								configTableGrid.headerCt.remove(index);
								configTableGrid.getView().refresh();
								break;
							}
						}

						var containsMeasure = false;
						for(var indexvar = 1; indexvar < configTableGrid.columns.length; indexvar++)
						{
							if(configTableGrid.columns[indexvar].text == 'Measure' )
							{
								containsMeasure = true;
							}
						}
						if(!containsMeasure)
						{

							var column3 = Ext.create('Ext.grid.column.Column', {
								text: screenLabelsObj['Measure'],
								dataIndex:'measure',
								cls: 'x-form-item-label',
								flex:.6,
								editor: {
										allowBlank: false
										},
								renderer: function(value, metaData) {
										metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
										return value;
									}
							});
							
							configTableGrid.headerCt.insert(2,column3);
						}	
						Ext.getCmp('configTableGrid').show();
					}
				
				//configTableGrid.hide();
						Ext.getCmp('advancedOptionWidgetSlider').removeAll();
					//	Ext.getCmp('advancedOptionWidgetSlider').add(defaultAdvanced);
						var AggregateOptions = configuredData['AggregateOptions'];
						var configAggrOptions = AggregateOptions['AggrConfiguration'];
						var showAggoptions = configAggrOptions['ShowAggOptions'];
						var AdvancedControls = configuredData['advanceControlArr'];
						var excludeIncludeControls = configuredData['excludeIncludeOptions'];
						var removeAggr = false;
						if(dispType!=null && AdvancedControls!=null && (dispType == "PieChart" || dispType == "activityChart"))
						{
							for(var k=0;k<AdvancedControls.length;k++)
							{
								var opt = AdvancedControls[k];
								if(opt.id!=null && opt.id == "ChartDistribution")
								{
									if(opt.selectedValue!=null && opt.selectedValue == "Multiple")
									{
										removeAggr = true;
									}
								}
							}
						}
						if(showAggoptions!=null && showAggoptions == 'yes')
						{
							Ext.getCmp('advancedOptionWidgetSlider').add(defaultAggr);
						}
						var isAggregationEnabled ='no';
						var descActionComboOptions = AggregateOptions['descactionComboOptions'];
						if(descActionComboOptions!=null && !Ext.isEmpty(descActionComboOptions))
						{
							//	Ext.getCmp('actionOnDescCombo').getStore().loadRawData(descActionComboOptions);
						}
						if(showAggoptions!=null && showAggoptions == 'yes')
						{
							var aggCombooptions = AggregateOptions['AggrComboOptions'];
							if(aggCombooptions!=null)
							{
								Ext.getCmp('AggrfnCombo').getStore().loadRawData(aggCombooptions);
							}
						}
						if(configAggrOptions!=null && !Ext.isEmpty(configAggrOptions))
						{
							if(showAggoptions!=null && showAggoptions == 'yes')
							{
								isAggregationEnabled = configAggrOptions['isAaggregationEnabled'];
								var Aggfn = '';
								if(isAggregationEnabled!=null && isAggregationEnabled.indexOf("|")>0)
								{
									Aggfn = isAggregationEnabled.substring(isAggregationEnabled.indexOf("|")+1);
									isAggregationEnabled = isAggregationEnabled.substring(0,isAggregationEnabled.indexOf("|"));
								}
								if(isAggregationEnabled == 'Yes')
								{
									var showaggOptObj = Ext.getCmp('showAggOpt');
									showaggOptObj.suspendEvents(false);
									showaggOptObj.setValue({
										showAgg: 'yes'
									});
									Ext.getCmp('AggrfnCombo').show();
									/*var aggCombooptions = jsonData['AggregateOptions']['AggrComboOptions'];
									if(aggCombooptions!=null)
									{
										Ext.getCmp('AggrfnCombo').getStore().loadRawData(aggCombooptions);
									}*/
									Ext.getCmp('AggrfnCombo').setValue(Aggfn);
								}
								else
								{
									var showaggOptObj = Ext.getCmp('showAggOpt');
									showaggOptObj.suspendEvents(false);
									showaggOptObj.setValue({
										showAgg: 'no'
									});
								//	Ext.getCmp('actionOnDescCombo').setValue('avg');
								}
							}
							var actionOnDesc = configAggrOptions['actiononDescriptor'];
							if(actionOnDesc!=null && actionOnDesc.indexOf("|")>0)
							{
								var descriptorVal= actionOnDesc.substring(actionOnDesc.indexOf("|")+1);
								 var descAction = actionOnDesc.substring(0,actionOnDesc.indexOf("|"));
								// Ext.getCmp('actionOnDescCombo').setValue(descAction);
								/*if(descriptorVal!=null && descriptorVal.indexOf("$!") > 0)
								{
									descriptorVal = descriptorVal.replace("$!",",");
								}*/
								if(descriptorVal!=null)
								{
									while(descriptorVal.indexOf("$!") > 0)
									{
										descriptorVal = descriptorVal.replace("$!",",");
									}
								}
							//	 Ext.getCmp('descriptorTextField').setValue(descriptorVal);
							}
							else
							{
							//	Ext.getCmp('actionOnDescCombo').setValue('Include');
							//	Ext.getCmp('descriptorTextField').setValue('*');
							}
						}
						else
						{
							if(showAggoptions!=null && showAggoptions == 'yes')
							{
								var showaggOptObj = Ext.getCmp('showAggOpt');
								showaggOptObj.suspendEvents(false);
								showaggOptObj.setValue({
									showAgg: 'no'
								});
								Ext.getCmp('AggrfnCombo').setValue('avg');
							}
						//	Ext.getCmp('actionOnDescCombo').setValue('Include');
						//	Ext.getCmp('descriptorTextField').setValue('*');
						}
						if(removeAggr)
						{
							Ext.getCmp('showAggOpt').hide();
							Ext.getCmp('AggrfnCombo').hide();
						}
						if(AdvancedControls!=null && !Ext.isEmpty(AdvancedControls))
						{
							Ext.getCmp('advancedOptionWidgetSlider').add(tempBuilderApp.getController("Main").createFilters(AdvancedControls));
							if(removeAggr)
							{
								var legendDispOptsObj=Ext.getCmp('Legend Display');
								if(!Ext.isEmpty(legendDispOptsObj))
								{
									legendDispOptsObj.hide();
								}
							}
							Ext.getCmp('advancedOptionWidgetSlider').doLayout();

							if(dispType!=null && dispType == 'DDTable')
							{
								var summarizeDDColumnObj = Ext.getCmp('summarizeDDColumnCombo');
								var ddColumnsComboLbl = Ext.getCmp('ddcolumnsLbl');
								var viewTypeObj = Ext.getCmp('ViewType');
								var timeLineObj = Ext.getCmp('Timeline');
								var showChartSummarySwitchVal = Ext.getCmp('showChartSummary');
								var mesLbl = Ext.getCmp('measureLbl');

								if(selectedChartType != null && selectedChartType == 'Bar Chart')
								{
									if(showChartSummarySwitchVal!=null &&  !Ext.isEmpty(showChartSummarySwitchVal))
									{
										showChartSummarySwitchVal.hide();
									}
									if(timeLineObj != null && !Ext.isEmpty(timeLineObj))
									{
										timeLineObj.hide();
									}
									
									if(!Ext.isEmpty(summarizeDDColumnObj) && !Ext.isEmpty(viewTypeObj))
									{
										if(mesLbl.isVisible())
										{
											summarizeDDColumnObj.show();
											summarizeDDColumnObj.setValue('-1');
										}
										viewTypeObj.show();

										if(ddColumnsComboLbl != null && !Ext.isEmpty(ddColumnsComboLbl))
										{
											var viewTypeVal = '';
											var viewTypeOpt = viewTypeObj.getChecked();
											if(viewTypeOpt!=null && !Ext.isEmpty(viewTypeOpt))
											{
												viewTypeVal = viewTypeOpt[0].inputValue;
											}
										
											if(viewTypeVal!=null && viewTypeVal == 'Vertical')
											{
												summarizeDDColumnObj.setFieldLabel('Summarize DD Data By (X axis)');
												ddColumnsComboLbl.setText('DD Columns (Y axis)');
											}
											else if(viewTypeVal!=null && viewTypeVal == 'Horizontal')
											{
												summarizeDDColumnObj.setFieldLabel('Summarize DD Data By (Y axis)');
												ddColumnsComboLbl.setText('DD Columns (X axis)');
											}
										}
									}			
								}
								else if(selectedChartType != null && (selectedChartType == 'Time Line' || selectedChartType == 'Area'))
								{
									if(showChartSummarySwitchVal!=null &&  !Ext.isEmpty(showChartSummarySwitchVal))
									{
										showChartSummarySwitchVal.show();
									}
									if(viewTypeObj != null && !Ext.isEmpty(viewTypeObj))
									{
										viewTypeObj.hide();
									}
									if(timeLineObj != null && !Ext.isEmpty(timeLineObj))
									{
										timeLineObj.show();
									}
									
									if(!Ext.isEmpty(ddColumnsComboLbl) && !Ext.isEmpty(summarizeDDColumnObj))
									{
										summarizeDDColumnObj.setFieldLabel('Summarize DD Data By');
										ddColumnsComboLbl.setText('DD Columns');
									}
									
									if(mesLbl.isVisible())
									{
										if(!Ext.isEmpty(summarizeDDColumnObj))
										{
											summarizeDDColumnObj.show();
											summarizeDDColumnObj.setValue('-1');
										}
									}
								}
								else
								{
									if(showChartSummarySwitchVal!=null &&  !Ext.isEmpty(showChartSummarySwitchVal))
									{
										showChartSummarySwitchVal.hide();
									}
									if(timeLineObj != null && !Ext.isEmpty(timeLineObj))
									{
										timeLineObj.hide();
									}
									if(!Ext.isEmpty(summarizeDDColumnObj) && !Ext.isEmpty(viewTypeObj))
									{
										summarizeDDColumnObj.hide();
										viewTypeObj.hide();
									}

									if(ddColumnsComboLbl != null && !Ext.isEmpty(ddColumnsComboLbl))
									{
										ddColumnsComboLbl.setText('DD Columns');
									}
								}	
							}
						}

						var defaultExcludeIncludeAdvanced  = tempBuilderApp.getController("Main").createExcludeIncludeSettingsLayout();	 
						if(dispType!=null && dispType != 'servicehealth')
						{
							Ext.getCmp('advancedOptionWidgetSlider').add(defaultExcludeIncludeAdvanced);
						}
	
						Ext.getCmp('advancedOptionWidgetSlider').add(tempBuilderApp.getController("Main").loadExcludeIncludeDefaultData(excludeIncludeControls,dispType));

						if(excludeIncludeControls!=null && !Ext.isEmpty(excludeIncludeControls))
						{
							this.defaultExcludeIncludeOpt= excludeIncludeControls;
							
						}else{
							this.defaultExcludeIncludeOpt= '';
						}
						
						if(dispType!=null && dispType!='')
						{
							chartName = dispType;
						}
												
					this.resumeEvents();
					Ext.resumeLayouts(true);
					if(!showGrid)
						{
							configTableGrid.hide();
						}
					if(configuredData["widgetsForUserArr"]!=null && !Ext.isEmpty(configuredData["widgetsForUserArr"]))
					{
						currWidgetsForUser = configuredData['widgetsForUserArr'];
					}
					jsonData=null;
					delete jsonData;
					AdvancedControls =null;
					delete AdvancedControls;
				}
				jsonText=null;
				delete jsonText;
			},
			failure : function()
			{
				console.log("Exception in widget config loading");
			}
		}
		);
	},
	createCommonBlockLayout: function (profilename,thisBlockId)
	{
		var componentarr = new Array();

		var compmultiselectLable ={
			xtype: 'label',
			id: 'healthCenterComponentComboLbl',
			name: 'healthCenterComponentComboLbl',
			margin:'0px 10px 0px 0px',
			
			text:'Components',
			
		};

		var compmultiselectcont ={
			xtype:'container',
			layout:{type:'vbox',align:'stretch'},
			width : 230,
			cls:'darkbox',
			height:125,
			id:'compTypeHealthBOX',
			items:[{
				xtype:'trigger',
				margin : '10',
				id : 'healthCenterComponentSearchTextBox',
				name : 'healthCenterComponentSearchTextBox',
				width : 178,
				cls: 'whitedropdown_search',
				emptyText : 'Search',
				componentStore : null,
				hidden : false,
				listeners :
				{
					'change' : function(triggerField, newValue, oldValue, eOpts) {
						var me = this;
						var compntStore = me.componentStore;
						if(compntStore==null)
						{
							me.componentStore = this.up('form').getForm().findField('healthCenterComponentCombo').getStore();
							compntStore = me.componentStore;
						}
						if(newValue=="*")
						{
							compntStore.clearFilter();
						}
						else
						{
							if(newValue.lastIndexOf("*")==(newValue.length-1))
							{
								newValue = newValue.substr(0,(newValue.length-1));
							}
							compntStore.clearFilter();
							if (newValue) {
								var matcher = new RegExp(Ext.String.escapeRegex(newValue), "i");
								compntStore.filter({
									filterFn: function(record) {
										return matcher.test(record.get('displayField')) ;
									}
								});
							}
						 triggerField.focus();
						}
					 }
				}
			},{
				xtype: 'multiselect',
				id: 'healthCenterComponentCombo',
				baseCls: 'egmultiselect',
				name: 'healthCenterComponentCombo',
				multiSelect: true,
				height:82,
				hidden: false,
				store: Ext.create('Ext.data.Store', {
					fields: ['displayField', 'valueField','editedCompName'],
					data: []
				}),
				editable: false,
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				listConfig: {
					id: 'componentListC',
					itemTpl: new Ext.XTemplate(
						'<tpl for=".">',
						'<div id="{valueField}"  style="text-align:left">{displayField}</div>',
						'</tpl>'
					),
					listeners: {
					}
				}
			}]
		};

		var compexpandsel =  {
			xtype: 'button',
			iconCls: 'iconMultiselectExpand',
			hidden: false,
			id: 'healthCenterComponentExpandSelector',
			margin: '20 0 5 7',
			listeners: {
				afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
						target: this.id,
						anchor: 'top',
						cls: 'yellowTip',
						trackMouse: true,
						html: componentDispLbl
					});
				}
			},
			style: {
				background: 'none',
				border: '0px'
			}
		};

		componentarr.push(compmultiselectLable);
		componentarr.push(compmultiselectcont);
		//componentarr.push(compexpandsel);

		var thisWin= this;
		this.items = [
		{
			xtype: 'form',
            itemId: 'configForm',
			layout:{type:'hbox',align:'stretch'},
			id:'userDefinedWindow',
			items:[{
				xtype:'container',
				id : 'createWidgetMain',
/*
			animateMe:function(){
				var container = this;

				container.el.animate({
					to:{
						left:-700
					},
					listeners:{

						afteranimate:function(){
							container.el.sequenceFx( );
							container.el.animate({
								to:{
									left:800
								}
							})
						}
					}
				});
			},
*/
			width:920,
			layout:{
				type : 'vbox',
				align : 'stretch'
			},
			bodyPadding:0,
			items:[
				{
					xtype:'container',
					margin:'0 5 0 5',
					border:true,
					layout:{
						type : 'hbox',
						align : 'stretch'
					},
					defaults:{
						labelAlign:'top',
						labelSeparator:'',
					},
					items:[
						{
							xtype: 'container',
							id : 'userDefinedWidgetIcon',
							name : 'userDefinedWidgetIcon',
							margin : '10 15 0 5',
							width:42,
							height:42,
							//html:'<div class="userDefinedImgDefault"><img id="widgetImageIcon"  src="../images/'+strSkin+'/userDefinedWidgetIstamName.png" width="42px" height="42px" border="0px"/><div class="settingOver"></div></div>',
							html:'',
							/*listeners:{
								afterrender:function(cmp){
									Ext.get(cmp.el).select('.userDefinedImgDefault').on('mouseenter',function(){
										//alert("mouse entered");
										Ext.get(cmp.el).select('.settingOver').update('<a href="javascript:void(0)" id="changeImg"><div class="userDefinedImgDefaultOver" style="display:block"></div></a>');
										Ext.get(cmp.el).select('#changeImg').on('click',function(){
											var imgUploadWindow = Ext.create('TemplateBuilder.view.IconLibrary',{
												from:'widgetUpload',
												windowId:'widgetWindowId',
												custUploadPath:'manager/tomcat/webapps/final/images/icon-library/'+loginUser+'/'
											}).show();
											imgUploadWindow.on('close', function() {
												imgUploadWindow.destroy();
												imgUploadWindow = 'closed';
											});
										},Ext.get('changeImg'))
									});

									Ext.get(cmp.el).select('.settingOver').on('mouseleave',function(){
										Ext.get(cmp.el).select('.settingOver').update('');
									});
								}
							},*/


						},
						{
							xtype: 'fieldcontainer',
							width: 204,
							margin : '10 5 10 5',
							layout:{
								type : 'vbox'
							},
							labelAlign:'top',
							labelSeparator:'',
							items: [
								{
									xtype: 'label',
									itemId : 'userDefinedWidgetImageLbl',
									id:'userDefinedWidgetImageLbl',
									html: '<div style="float:left" class="x-form-item-label">'+screenLabelsObj['Widget Name']+'</div><div id ="iconRename" style="float:left;margin-left:20px" class="iconRename"></div>',
								},
								{
									xtype:'textfield',
									cls: 'textbox',
									id:'WidgetNametextField',
									itemId:'WidgetNametextField',
									width:172,
									hidden:false,
									margin : '1 5 0 0',
									//blankText:'Citrix',
								},
								{
									xtype: 'label',
									itemId : 'userDefinedWidgetNameLbl',
									id:'userDefinedWidgetNameLbl',
									width:200,
									hidden:true,
									text:screenLabelsObj['Widget Name'],
									margin : '10 5 0 0',
									cls:'font_bold13',
								},
							]
						},
						{
							xtype: 'radiogroup',
							fieldLabel: screenLabelsObj['Add to widget library'],
							vertical: false,
							width:187,
							hidden : true,
							id:'addToWidgetLibRadioBtn',
							columns: 2,
							margin : '10 5 10 5',
							items: [
							{
								boxLabel: screenLabelsObj['Yes'],
								cls:'radiobt',
								name: 'addToWidgetGrprb',
								inputValue: 'yes',
								columnWidth:80,
							},{
								boxLabel: screenLabelsObj['No'],
								cls:'radiobt',
								name: 'addToWidgetGrprb',
								inputValue: 'no',
								columnWidth:80,
							}]
						},
						{
							xtype:'fieldcontainer',
							layout:'hbox',
							fieldLabel:screenLabelsObj['Widget Group Name'],
							defaultType:'textfield',
							hidden : true,
							id:'WidgetGrpFieldCont',
							itemId:'WidgetGrpFieldCont',
							name : 'WidgetGrpFieldCont',
							margin : '10 10 0 5',
							defaults:{
								//allowBlank:false,
								flex:1,
							},
							items:[
								{
									xtype:'scrollcombo',
									width:200,
									value:'',
									cls: 'dropdown',
									margin: '0 10 10 0',
									editable:false,
									id:'widgetGrpCombo',
									name : 'widgetGrpCombo',
									displayField:'displayField',
									valueField: 'valueField',
									store:Ext.create('Ext.data.Store',{
										fields:['valueField','displayField'],
										data:[]
									}),
									queryMode: 'local',
								},{
									xtype:'textfield',
									cls: 'textbox',
									id:'NewGrptxtField',
									name:'NewGrptxtField',
									hidden : true,
									autofocus: true,
									margin : '0 5 0 10',
									width:187,
									emptyText : screenLabelsObj['Enter New Group'],
									value:'',
									enableKeyEvents : true,
										listeners: {
											show: function(field) {
												field.focus(false, 100);
											}}
								},
							]
						}]
				},







				{
					xtype:'container',
					layout:{
						type : 'hbox',
						align : 'stretch'
					},
					flex:1,
					margin:'5 0 0 0',
					items:[
					{
						xtype:'container',
						layout:{
							type : 'vbox',
						},
						items:[{
								xtype:'textareafield',
								cls: 'text-area widgetDescrText',
								rows:1,
								labelAlign:'top',
								width:235,
								id:'widgetDescrText',
								itemId:'widgetDescrText',
								labelSeparator:'',
								fieldLabel:screenLabelsObj['Description'],
								enforceMaxLength: true,
								maxLength:100,
								margin:'0 0 0 10',
								height:20
							},{
								xtype:'container',
								id:'loadSlider',
								margin:'40 0 0 0',
								padding: 0,
								width:290
							}
						]
					},
					{
						xtype:'container',
						cls:'',
						//flex:.7,
						width:630,
						layout: {
							type:'column',
							//columns: 3,
							pack:'start',
							tableAttrs: {
								style: {
									width: '100%'
								},
							},
							tdAttrs:{
								align:'left',
								valign:'top',
							},
						},
						defaults:{
							labelAlign:'top',
							labelSeparator:'',
								type:'column',
						},

						items:[
							{
								xtype: 'scrollcombo',
								id: 'categoryOpts',
								name: 'categoryOpts',
								hidden : false,
								selectOnTab: true,
								editable : false,
								labelAlign: 'top',
								width: 172,
								margin:'0 20 10 0',
								fieldLabel :'Category',
								displayField: 'displayField',
								valueField: 'valueField',
								store: Ext.create('Ext.data.Store', {
									fields: ['displayField', 'valueField'],
									data: []
								}),
								//lazyRender: true,
								editable:false,
								queryMode: 'local'
							},
							{
								xtype: 'scrollcombo',
								cls: 'dropdown',
								labelAlign: 'top',
								fieldLabel: 'Component Type',
								id: 'healthCenterCompTypeCombo',
								name: 'healthCenterCompTypeCombo',
								hidden: false,
								width: 200,
								margin:'0 20 10 0',
								store: Ext.create('Ext.data.Store', {
									fields: ['displayField', 'valueField'],
									data: []
								}),
								editable: false,
								displayField: 'displayField',
								valueField: 'valueField',
								queryMode: 'local'
							},
							{
								xtype: 'scrollcombo',
								cls: 'dropdown',
								fieldLabel: 'Test',
								labelAlign: 'top',
								id: 'healthCenterTestScrollCombo',
								name: 'healthCenterTestScrollCombo',
								hidden: false,
								width: 200,
								margin:'0 0 10 0',
								store: Ext.create('Ext.data.Store', {
									fields: ['displayField', 'valueField'],
									data: []
								}),
								editable: false,
								displayField: 'displayField',
								valueField: 'valueField',
								queryMode: 'local'
							},
							{
								xtype: 'container',
								layout:{type:'column',align:'left'},
								width: 250,
								flex:1,
								id:'healthCenterCompContiner',
								hidden:false,
								margin: '0 0 10 0',	
								items: componentarr
						   },
							{
								xtype: 'scrollcombo',
								id: 'graphicalTypeId',
								name: 'graphicalTypeId',
								hidden : true,
								selectOnTab: true,
								editable : false,
								labelAlign: 'top',
								width: 172,
								margin:'0 20 10 0',
								fieldLabel :'Graphical Type',
								displayField: 'displayField',
								valueField: 'valueField',
								store: Ext.create('Ext.data.Store', {
									fields: ['displayField', 'valueField'],
									data: []
								}),
								editable:false,
								queryMode: 'local'
							},
						
						{
							xtype:'scrollcombo',
							editable : false,
							queryMode: 'local',
							fieldLabel : screenLabelsObj['Test'],
							id : 'testCombo',
							name: 'testCombo',
							previousTestSelection : '',
							isModification:false,
							width:180,
							margin:'0 0 10 0',
							store: new Ext.data.Store(
							{
								fields: ['displayField', 'valueField'],
								data: []
							}),
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local'
						},
						{
							xtype:'container',
							layout:{
								type: 'vbox'
							},
							defaults:{
								margin:'0 0 5 10',
								labelSeparator:'',
							},
							//flex:2,
							items:[
							{
									xtype:'label',
									//html:'<div style="font-weight:bold">Measure list</div>',
									cls:'x-form-item-label',
									text: screenLabelsObj['Measure'],
									hidden : true,
									style:{'line-height':'1.4em'},
									margin:'0 0 0 10',
									padding:'0 0 4 0',
									id:'measureLbl'
							},
							{
								xtype:'scrollcombo',
								editable : false,
								queryMode: 'local',
								id : 'measureListCombo',
								name: 'measureListCombo',
								hidden:true,
								width:200,
								store: new Ext.data.Store(
								{
									fields: ['displayField', 'valueField'],
									data: []
								}),
								displayField: 'displayField',
								valueField: 'valueField',
								queryMode: 'local'
							},{
								xtype:'trigger',
								margin:'0 0 5 10',
								id : 'metricsSearchTextBox',
								name : 'metricsSearchTextBox',
								width : 300,
								cls: 'whitedropdown_search',
								emptyText : screenLabelsObj['Search Metric(s)'],
								metricsListStore : null,
								hidden :true,
								listeners :
								{
									'change' : function(triggerField, newValue, oldValue, eOpts) {
										var me = this;
										var metListStore = me.metricsListStore;
										if(metListStore==null)
										{
											me.metricsListStore = this.up('form').getForm().findField('measurelist').getStore();
											metListStore=me.metricsListStore;
										}
										if(newValue=="*")
										{
											metListStore.clearFilter();
										}
										else
										{
											if(newValue.lastIndexOf("*")==(newValue.length-1))
											{
												newValue = newValue.substr(0,(newValue.length-1));
											}
											metListStore.clearFilter();
											if (newValue) {
												var matcher = new RegExp(Ext.String.escapeRegex(newValue), "i");
												metListStore.filter({
													filterFn: function(record) {
														return matcher.test(record.get('displayField')) ;
													}
												});
											}
											triggerField.focus();
										}
									 }
								}
							},{
									xtype: 'multiselect',
									height:100,
									width:300,
									scroll: false,
									hidden:true,
									autoScroll: false,
									labelAlign:'left',
									//allowBlank: false,
									id: 'measurelist',
									name: 'measurelist',
									value: '',
									store: new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : [],
										listeners:{
										/*
												'load': function(store, records)
												{
													var compsObj = Ext.getCmp('components');

													if ( !Ext.isEmpty( store ) && !Ext.isEmpty( compsObj ) )
													{
														var getNAIndex = store.findExact('valueField', 'Not Applicable', 0);
														if ( getNAIndex == -1 )
														{
															var getModel = store.getAt(0);
															var getFirstValueField = getModel.get('valueField');
															compsObj.setValue(getFirstValueField);
														}
													}
												}
										*/
										}
									}),
									displayField: 'displayField',
									valueField: 'valueField',
									queryMode: 'local'
								},{
									xtype:'button',
									text: screenLabelsObj['ADD'],
									cls: 'buttonNew',
									id: 'addtoGridBtn',
									padding:'0 6 0 6',
									margin:'15 0 5 10',
									name: 'addtoGridBtn',
									border:true,
									//style:{'border':'1px solid'},
									hidden : true
								}]
							},
							{
								xtype: 'scrollcombo',
								id: 'summarizeDDColumnCombo',
								name: 'summarizeDDColumnCombo',
								hidden : true,
								selectOnTab: true,
								editable : false,
								labelAlign: 'top',
								width: 240,
								margin:'0 20 10 0',
								fieldLabel :'Summarize DD Data By',
								displayField: 'displayField',
								valueField: 'valueField',
								store: Ext.create('Ext.data.Store', {
									fields: ['displayField', 'valueField'],
									data: []
								}),
								editable:false,
								queryMode: 'local'
							},										
							{
							xtype:'container',
							layout:{
								type: 'vbox'
							},
							defaults:{
								margin:'0 0 5 10',
								labelSeparator:'',
							},
							width:260,
							//flex:2,
							items:[
							{
									xtype:'label',
									//html:'<div style="font-weight:bold">Measure list</div>',
									text: screenLabelsObj['DD Columns'],
									cls:'formLabelDivFont',
									hidden : true,
									id:'ddcolumnsLbl',
									width:200
							},
							{
									xtype: 'multiselect',
									height:80,
									width:190,
									scroll: false,
									hidden:true,
									autoScroll: false,
									labelAlign:'left',
									//allowBlank: false,
									id:'ddcolumnsMultiSelect',
									name: 'disclist',
									value: '',
									store: new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : [],
										listeners:{
										/*
												'load': function(store, records)
												{
													var compsObj = Ext.getCmp('components');

													if ( !Ext.isEmpty( store ) && !Ext.isEmpty( compsObj ) )
													{
														var getNAIndex = store.findExact('valueField', 'Not Applicable', 0);
														if ( getNAIndex == -1 )
														{
															var getModel = store.getAt(0);
															var getFirstValueField = getModel.get('valueField');
															compsObj.setValue(getFirstValueField);
														}
													}
												}
										*/
										}
									}),
									displayField: 'displayField',
									valueField: 'valueField',
									queryMode: 'local'
								}]
							},{
								xtype:'container',
								margin:'10 0 0 0',
								//colspan:3,
								width: 600,
								hidden:true,
								id: 'oneMetricTxt',
								name: 'oneMetricTxt',
								html:'<div class="font_normal11">* '+screenLabelsObj['Only one metric is supported with this widget']+' </div>',
							},
							{
								xtype:'label',
								//html:'<div style="font-weight:bold">Measure list</div>',
								cls:'x-form-item-label',
								width: 600,
								text: screenLabelsObj['Selection Details'],
								hidden : false,
								//colspan:3,
								id:'selectionDetailsLbl',
								margin:'0 10 0 8',
							},
							{
								xtype: 'comparisontable',
								hidden: true
							}
						]
					}]
				}]
			},{
			xtype:'button',
			text:'',
			cls:'advancedOptionGrayButton',
			iconCls:'advancedOptionGrayButtonIcon',
			margin:'10 0 0 -18',
			width:20,
			height:50,
			handler:function(){
				tempBuilderApp.getController("Main").loadExcludeIncludeDefaultData(thisWin.defaultExcludeIncludeOpt,'');
				
				tempBuilderApp.getController("Main").reloadAdvanceOptions(chartName);

				Ext.getCmp('advancedOptionWidgetSlider1').loadMask('createWidgetMain',true);
				Ext.get('advancedOptionWidgetSlider1').animate({
					to:{
						left:'470'
						//left:'370'
					},
					listeners:
					{
						beforeanimate: function() {},
						afteranimate : function() {
							var aniObj = this;
							Ext.get('getAdvancedOptionWidgetButton').on('click',function(){
								Ext.get('advancedOptionWidgetSlider1').animate({
									to:{
										left:'990'
									},
									listeners:{
										afteranimate : function() {},
										beforeanimate : function() {
											Ext.getCmp('advancedOptionWidgetSlider1').loadMask('createWidgetMain',false);
										}
									},
									single : true
								});
							});
						}
					},
					single : true
				});
			}
		},{
			xtype:'container',
			cls:'templateAdvancedOptionSlider',
			id:'advancedOptionWidgetSlider1',
			loadMask:function(cmpId,show){
				var myMask = new Ext.LoadMask(Ext.get(cmpId), {msg:""});
				if(show == true){
					myMask.show();
				}else{
					myMask.hide();
					}
				return myMask;
			},
			layout:{type:'column'},
			width:455,
			height:'100%',
			margin:'0 0 0 60',
			padding: '10 0 0 0',
			html:'<div class="advanceEffectButton"><div id="getAdvancedOptionWidgetButton" class="advancedOptionGreenButton"></div></div>',
			defaults:{
				margin:'0px 10px 10px 10px',
				//width:350,
			},
			items:[{
				xtype:'container',
				cls:'templateAdvancedOptionSlider scroll',
				id:'advancedOptionWidgetSlider',
				loadMask:function(cmpId,show){
					var myMask = new Ext.LoadMask(Ext.get(cmpId), {msg:""});
					if(show == true){
						myMask.show();
					}else{
						myMask.hide();
						}
					return myMask;
				},
				layout:{type:'column'},
				width:'440',
				height:'100%',
				margin:'0 0 0 0',
				padding: '10 0 0 0',
				scroll:true,
				autoScroll:true,
				defaults:{
					margin:'0px 10px 10px 10px',
					width:370,
				},

				items: []	
				}
			
			]
		}

	/*,{
			xtype:'container',
			width:150,
			height:150,
			border:true,
			layout:'absolute',
			focusOnToFront:true,
			floating:true,
			//renderTo:Ext.get('createWidgetMain'),
			style:{'background':'#e3e3e3','border':'1px solid red','z-index':'9999 !important'},
			listeners:{


				'afterrender': function(cont){
					cont.setPosition(200,200);
					cont.setHeight(200);
					cont.setWidth(200);
					cont.setHeight(200);
				}
			}
		}*/

		]
	}
	]
},
	listeners:{
		render:function(win){
			if(this.rendered == true){
				var thisBlockId = this.blockId;
				var thisInternalId = this.internalId;
				this.loadDefaultDataForCommonLayout(thisBlockId,thisInternalId);
			}
		},
		afterrender:function(win){
			var thisWndow = this;
			var getWindowObj = Ext.get('createWidgetMain');
			var windowBox = Ext.create('Ext.container.Container', {
				renderTo: Ext.get('userDefinedWindow'),
				cls:'widgetPaperCurve',
				items:[{
					xtype:'button',
					id:'form_sumbit_button',
					cls:'widgetSaveButton',
					width:30,
					height:30,
					style:{'border':'0px'},
					addAnimation:function(){
						thisWndow.tools.close.disabled = true;
						getWindowObj.animate({
							duration: 1500,
							to: {
								opacity: 0
							},
							listeners: {
								beforeanimate: function() {
									//Ext.getCmp('advancedOptionWidgetSlider').loadMask('createWidgetMain', false);
									var widgetSaved = Ext.create('Ext.window.Window', {
										id: 'widgetSavedText',
										html: '<div class="font_bold13">'+screenLabelsObj['Widget Saved Successfuly']+'</div>',
										border: false,
										ui: 'nothing',
										header: false,
										closeAction: 'destory',
										floatable: true,
										renderTo: Ext.get('userDefinedWindow'),
										height: 100,
									}).show();
								},
								afteranimate: function() {
									if(temparray.length == 0)
									{
										getWindowObj.stopAnimation();
										win.doClose();
									}

								}
							}
						}).animate({
							duration: 1500,
							to: {
								opacity: 1
							},
							listeners: {
								beforeanimate: function() {
									//Ext.destroy(Ext.getCmp('widgetSavedText'));
									Ext.getCmp('widgetSavedText').doClose();
								},
								afteranimate: function() {
									thisWndow.tools.close.disabled = false;
								}
							}
						});
					},
					handler:function(btn){
						var form = win.getComponent(0).getForm();
						Ext.get('advancedOptionWidgetSlider1').animate({
							to: {
								left: '970'
							},listeners:{
								afteranimate: function() {
									Ext.getCmp('advancedOptionWidgetSlider1').loadMask('createWidgetMain',false);
								}
							}
						});
						var block = thisWndow.blockId;
						tempBuilderApp.getController("Main").saveWidgetConfiguration(block);
					}
				}]
			});
		}
	}
});



