var pagingBar2 = Ext.define('pagingBar2',{
		extend:'Ext.toolbar.Paging',
		alias:'widget.pagingbar2',
		getPagingItems: function() {
		var me = this;
		return [{
			itemId: 'first',
			tooltip: me.firstText,
			overflowText: me.firstText,
			iconCls: Ext.baseCSSPrefix + 'tbar-page-first',
			disabled:true,
			hidden:true,
			handler: me.moveFirst,
			scope: me
		},{
			itemId: 'prev',
			tooltip: me.prevText,
			overflowText: me.prevText,
			overCls:'sss',
			//iconCls: Ext.baseCSSPrefix + 'tbar-page-prev',
			iconCls:'iconWidgetLibLeftArrow',
			disabled:false,
			height:24,
			width:16,
			padding:0,
			hidden:false,
			handler: me.movePrevious,
			scope: me
		},
		{
			xtype: 'numberfield',
			hidden:true,
			itemId: 'inputItem',
			name: 'inputItem',
			cls: Ext.baseCSSPrefix + 'tbar-page-number',
			allowDecimals: false,
			minValue: 1,
			hideTrigger: true,
			enableKeyEvents: true,
			keyNavEnabled: false,
			selectOnFocus: true,
			submitValue: false,
			// mark it as not a field so the form will not catch it when getting fields
			isFormField: false,
			width: me.inputItemWidth,
			margins: '-1 2 3 2',
			listeners: {
				scope: me,
				keydown: me.onPagingKeyDown,
				blur: me.onPagingBlur
			}
		},{
			xtype: 'tbtext',
			hidden:true,
			itemId: 'afterTextItem',
			text: Ext.String.format(me.afterPageText, 1)
		}, {
            itemId: 'next',
            tooltip: me.nextText,
            overflowText: me.nextText,
           //iconCls: Ext.baseCSSPrefix + 'tbar-page-next',
			iconCls:'iconWidgetLibRightArrow',
			overCls:'sss',
            disabled: true,
			hidden:false,
			height:24,
			width:16,
			padding:0,
            handler: me.moveNext,
            scope: me
        },{
			itemId: 'last',
			hidden:true,
			tooltip: me.lastText,
			overflowText: me.lastText,
			iconCls: Ext.baseCSSPrefix + 'tbar-page-last',
			disabled: true,
			handler: me.moveLast,
			scope: me
		},{
			itemId: 'refresh',
			hidden:true,
			tooltip: me.refreshText,
			overflowText: me.refreshText,
			iconCls: Ext.baseCSSPrefix + 'tbar-loading',
			handler: me.doRefresh,
			scope: me
		}];
	}
});
Ext.define('TemplateBuilder.view.WidgetLibrary', {
	alias: 'widget.widgetLibrary',
	extend:'Ext.window.Window',
	height:strSkin == "Light"?381:371,
	width:strSkin == "Light"?605:585,
	autoScroll:false,
	scroll:false,
	closeAction:'destroy',
	resizable:false,
	header:{
		height:33,
		padding:'0 10',
		margin:0
	},
	ghost:false,
	cls:'myDashboardwindow',
	ui:'newPopupWindow  newplainHeader',
	frame:false,
	padding:0,
	bodyPadding:0,
	margin:0,
	border:false,
	modal:true,
	title:'<div><div style="float:left;margin:2px">WIDGET LIBRARY</div><div style="float:left;margin:1px 0px 0px 5px"><img src="/final/images/spacer.gif" id="addWidgtFrmWidgtLib" class="iconOneClickHeaderAddWidget2 mouse" data-qtip="Add Widget"/></div></div>',
	url:'',
	windowMode:'big',
	loadDynamicStore:function(){
			var me = this;


		me.dynamicStore = Ext.create('Ext.data.Store',{
			fields: [
				{name:'grpName', type:'string'},
				{name:'grpIcon', type:'string' },
				{name:'grpOwner', type:'string' },
				{name:'enableDelete', type:'boolean' },
				{name:'isSelected', type:'boolean' },
				{name:'subset', type:'array'}
			],
			proxy: {
				type: 'ajax',
				url: me.url,
				reader: {
					type :'json',
					root: 'result',
					totalProperty: 'totalCount'
				}
			},
			pageSize:pageCountSize
		});
	  me.dynamicStore.load();
	},
	initComponent:function(){
		var me = this;
		var getMode = me.url;
		if (me.windowMode == "big")
		{
			if (strSkin == "Light")
			{
				me.height=560;
			}
			else
			{
				me.height=550;
			}
			winInnerContainerHeight=515;
			winInnerSubsetHeight=495;
			pageCountSize=11;
		}
		else{
			if (strSkin == "Light")
			{
				me.height=381;
			}
			else
			{
				me.height=371;
			}
			winInnerContainerHeight=335;
			winInnerSubsetHeight=315;
			pageCountSize=7;
		}

		me.loadDynamicStore();
		Ext.apply(me,{
			items:{
				xtype:'container',
				height:winInnerContainerHeight,
				cls:'formOuter',
				style:{'overflow':'hidden'},
				margin:10,
				items:[{
					xtype:'dataview',
					id:'widgetLibraryId2',
					store: me.dynamicStore,
					itemSelector:'.mainX',
					tpl : new Ext.XTemplate(
						'<div style="height:'+winInnerContainerHeight+'px;overflow:hidden;">',
							'<ul>',
								'<tpl for=".">',
										'<li class="mainX">',
										'<div style="width:210px;height:45px;" class="widgetLibraryButton">',
											'<table border="0px" cellpadding="0px" cellspacing="0px" width="100%" height="100%">',
												'<tr>',
													'<td align="center" valign="middle">',
														'<div style="float:left">{grpName}</div>',
														'<div style="float:left;margin-left:10px;" class="{grpIcon}"  data-qtip="{grpOwner}"></div>',
														'<tpl if="enableDelete">',
														'<div style="float:right;margin-right:10px;height:16px" id="deleteIconShowHide" ><img src="/final/images/spacer.gif" class="iconDelete"  data-qtip="Delete" onClick="javascript:deleteWidgetGroup(\'{grpName}\',\'{grpOwner}\');"/></div>',
														'</tpl>',
													'</td>',
												'</tr>',
											'</table>',
										'</div>',
										'<div style="width:350px;height:'+winInnerSubsetHeight+'px;float:right;" class="widgetLibraryItems">',
											'<tpl for="subset">',
												'<div style="width:340px;padding:10px" class="x-item">',
													'<table border="0px" cellpadding="0px" cellspacing="0px" width="100%" height="100%">',
														'<tr>',
															'<td align="left" valign="middle" width="50px">',
																'<tpl if="!isDefaultImg">',
																'<div class = "widget_pla ceHolder">',
																'<img src={subsetIcon} width="32px" height="32px" class="png"/>',
																'</div>',
																'</tpl>',
																'<tpl if="isDefaultImg">',
																	'<div style="float:left;" class="{subsetIcon}"></div>',
																'</tpl>',
															'</td>',
															'<td align="left" valign="middle">',
																'<div class="widgetLibraryIconNameFont">{subsetName}</div>',
																'<div class="font_normal11">{shortSummary}</div>',
															'</td>',
															'<td align="center" valign="middle"  width="100px">',
																'<tpl if="add" >',
																	'<button id="{subsetName}_add" widgetintid="{widgetId}" class="widgetAddButton" onClick="javascript:addWidgetFromWidgetGallery(\'{widgetInternalId}\',\'{template_name}\',\'{displayType}\',\'{subsetName}\');" style="display:block;">Add</button>',
																	'<button id="{subsetName}_remove" widgetintid="{widgetId}" class="widgetRemoveButton" onClick="javascript:removeWidget(\'{widgetId}\',\'{subsetName}\');" style="display:none;">Remove</button>',
																'<tpl elseif="added" >',
																/*	'<button id="\'{subsetName}\'" class="widgetAddButtonDisabled">Add</button>',
																'<tpl else>',*/
																	'<button id="{subsetName}_add" widgetintid="{widgetId}" class="widgetAddButton" onClick="javascript:addWidgetFromWidgetGallery(\'{widgetInternalId}\',\'{template_name}\',\'{displayType}\',\'{subsetName}\');" style="display:none;">Add</button>',
																	'<button id="{subsetName}_remove" widgetintid="{widgetId}" class="widgetRemoveButton" onClick="javascript:removeWidget(\'{widgetId}\',\'{subsetName}\');" style="display:block;">Remove</button>',
																'</tpl>',
															'</td>',
														'</tr>',
													'</table>',
												'</div>',
											'</tpl>',
										'</div>',
										'<div style="clear:both"></div>',
									'</li>',
								'</tpl>',
							'</ul>',
						'</div>'
					),
					listeners: {
						'containerclick':function(){
							return false;
						},
						'refresh':function(){
							this.getSelectionModel().select(0);
						},
						'viewready':function(){
							if(this.getStore().getCount() < this.getStore().pageSize){
								Ext.select('.pagingbarShowHideFunction').hide();
							}
							this.el.on('click',function(evt,target){
							},null,{delegate:'button'});
						}
					}
				},{
						xtype: 'pagingbar2',
						store: me.dynamicStore, // same store GridPanel is using
						displayInfo: true,
						cls:"pagingbarShowHideFunction",
						width:40,
						padding:0,
						margin:0,
						style:{'position':'absolute','z-index':'20','bottom':'0px','left':'160px'},
						floatable:true,
				}]
			}
		})
		this.callParent();
	},

	tools:[
		{
			xtype : 'button',
			iconCls : 'iconHelp',
			listeners: {
				afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
						target: this.id,
						anchor: 'top',
						cls: 'yellowTip',
						trackMouse: true,
						html: 'Help'
					});
				}
			},
			style : {
				'background' : 'none',
				'border' : '0px',
				'margin':'0 1 0 0',
			},
			handler : function()
			{
				HelpWin();
			}
		}
	],
	closeAction : 'destroy',
	dashBoardAction : '',
	profileName : '',
	layout:{type:'fit'},
	listeners: {        
		'close':function(win){
						Ext.getCmp('Widgets_Gallery').defaultState();
                      
                  }
    },
});