var icaSelectionModel = Ext.create('Ext.selection.CheckboxModel', {
	selType: 'checkboxmodel',
	mode: 'MULTI',
	checkOnly: true,
	renderer : function(val, meta, record, rowIndex, colIndex, store,view)
	{
		meta.tdCls = Ext.baseCSSPrefix + 'grid-cell-special ' + Ext.baseCSSPrefix + 'grid-cell-row-checker';
		return '<div class="' + Ext.baseCSSPrefix + 'grid-row-checker">&#160;</div>';
	},
	selectAll: function(){
		var rowIndex=0;
		var icaGrid = Ext.getCmp('icaSessionGrid');
		if(!Ext.isEmpty(icaGrid) && icaGrid != null && icaGrid != undefined){
			while(typeof(icaGrid.getStore().getAt(rowIndex))!='undefined') {
				var record = icaGrid.getStore().getAt(rowIndex);
				icaGrid.getSelectionModel().select(rowIndex, true);
				rowIndex++;
			}
			var view = icaGrid.getView();
			var headerCt = view.headerCt;
			var hdSelectStatus = this.selected.getCount() === this.store.getCount();
			var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
			if (checkHd) {
				checkHd.el.addCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
			}
		}
	},
	deselectAll: function(){
		var rowIndex=0;
		var icaGrid = Ext.getCmp('icaSessionGrid');
		if(!Ext.isEmpty(icaGrid) && icaGrid != null && icaGrid != undefined){
			while(typeof(icaGrid.getStore().getAt(rowIndex))!='undefined') {
				var record = icaGrid.getStore().getAt(rowIndex);
				icaGrid.getSelectionModel().deselect(rowIndex, true);
				rowIndex++;
			}
			var view = icaGrid.getView();
			var headerCt = view.headerCt;
			var hdSelectStatus = this.selected.getCount() === this.store.getCount();
			var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
			if (checkHd) {
				checkHd.el.removeCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
			}
		}
	}
});
var vpnSelectionModel = Ext.create('Ext.selection.CheckboxModel', {
	selType: 'checkboxmodel',
	mode: 'MULTI',
	checkOnly: true,
	renderer : function(val, meta, record, rowIndex, colIndex, store,view)
	{
		meta.tdCls = Ext.baseCSSPrefix + 'grid-cell-special ' + Ext.baseCSSPrefix + 'grid-cell-row-checker';
		return '<div class="' + Ext.baseCSSPrefix + 'grid-row-checker">&#160;</div>';
	},
	selectAll: function(){
		var rowIndex=0;
		var vpnGrid = Ext.getCmp('vpnSessionGrid');
		if(!Ext.isEmpty(vpnGrid) && vpnGrid != null && vpnGrid != undefined){
			while(typeof(vpnGrid.getStore().getAt(rowIndex))!='undefined') {
				var record = vpnGrid.getStore().getAt(rowIndex);
				vpnGrid.getSelectionModel().select(rowIndex, true);
				rowIndex++;
			}
			var view = vpnGrid.getView();
			var headerCt = view.headerCt;
			var hdSelectStatus = this.selected.getCount() === this.store.getCount();
			var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
			if (checkHd) {
				checkHd.el.addCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
			}
		}
	},
	deselectAll: function(){
		var rowIndex=0;
		var vpnGrid = Ext.getCmp('vpnSessionGrid');
		if(!Ext.isEmpty(vpnGrid) && vpnGrid != null && vpnGrid != undefined){
			while(typeof(vpnGrid.getStore().getAt(rowIndex))!='undefined') {
				var record = vpnGrid.getStore().getAt(rowIndex);
				vpnGrid.getSelectionModel().deselect(rowIndex, true);
				rowIndex++;
			}
			var view = vpnGrid.getView();
			var headerCt = view.headerCt;
			var hdSelectStatus = this.selected.getCount() === this.store.getCount();
			var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
			if (checkHd) {
				checkHd.el.removeCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
			}
		}
	}
});
Ext.Loader.setConfig({
	enabled:true,
    disableCaching:false,
	preserveScripts:true,
	garbageCollect:true

});

Ext.Loader.setPath('utilities', '../scripts/utilities');
Ext.Loader.setPath('Ext.ux', '../scripts/ux');

Ext.application({
	name: 'TerminateSessions',
	autoCreateViewport: true,
	appFolder: '../monitor/eg_scripts/TerminateSessions',
	controllers:['TerminateSessions.controller.Main']
});
