Ext.define('TerminateSessions.controller.Main', {
	extend	:'Ext.app.Controller',
	views	:['TerminateSessions'],
	refs	:[
		{
			selector:'terminateSessionsView', 
			ref		:'terminateSessionsView'
		}
	],
	init	:function() {
		this.control({
			'terminateSessionsView button[id="showSessions"]': {
				'click': this.loadSessions
			},
			'terminateSessionsView button[id="delSession"]': {
				'click': this.deleteICASessions
			},
		});
	},
	loadSessions: function(){
		var username = '';
		var userObj = Ext.getCmp('uname');
		if(!Ext.isEmpty(userObj) && userObj != null && userObj != undefined)
			username = userObj.getValue();
		if(Ext.isEmpty(username) || username == null){
			Ext.MessageBox.show(
			{
				title :'Terminate User Sessions',
				msg : emptyUserValue,
				icon : 'iconInformation',
				buttons : Ext.Msg.OK,
				width : 300
			});
			return false;
		}
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		myMask.show();
		var resultPanelObj = Ext.getCmp('sessionGridPanel');
		Ext.Ajax.request({
			url:'Netscalersessions.jsp?user='+username,
			method:'POST',
			scope:this,
			success:function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					resultPanelObj.removeAll();
					publicJSON = Ext.decode(response.responseText);

					var icaColumnDetails = publicJSON.ICACOLUMNS;
					var vpnColumnDetails = publicJSON.VPNCOLUMNS;
					var errorColumnDetails = publicJSON.ERRORCOLUMNS;
					var icaDataArrayStore = publicJSON.ICASessionData;
					var vpnDataArrayStore = publicJSON.VPNSessionData;
					var errorDataArrayStore = publicJSON.ErrorData;

					var emptyPanel = Ext.getCmp('searchid');
					if(!Ext.isEmpty(emptyPanel) && emptyPanel!=null && emptyPanel!=undefined)
						emptyPanel.destroy();

					myMask.hide();
					Ext.getCmp('delSession').show();

					if(!Ext.isEmpty(icaDataArrayStore))
						this.createGrid(icaColumnDetails,icaDataArrayStore,"ica",icaSelectionModel);
					if(!Ext.isEmpty(vpnDataArrayStore))
						this.createGrid(vpnColumnDetails,vpnDataArrayStore,"vpn",vpnSelectionModel);
					if(!Ext.isEmpty(errorDataArrayStore))
						this.createGrid(errorColumnDetails,errorDataArrayStore,"error",'');
					if(Ext.isEmpty(icaDataArrayStore) && Ext.isEmpty(vpnDataArrayStore) && Ext.isEmpty(errorDataArrayStore)){
						var msgs = publicJSON.errormsg;
						resultPanelObj = Ext.getCmp('sessionGridPanel');
						resultPanelObj.removeAll();
						resultPanelObj.add({
							xtype: 'container',
							id: 'searchid',
							margin: '200 0 10 0',
							//border: true,
							frame: true,
							style: {
								'text-align': 'center'
							},
							html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style=""></div><div style="font-size:12px">'+msgs+'! </div></td></tr></table>'
						});
						resultPanelObj.show();
						Ext.getCmp('delSession').hide();
					}
					if(Ext.isEmpty(icaDataArrayStore) && Ext.isEmpty(vpnDataArrayStore) && !Ext.isEmpty(errorDataArrayStore))
						Ext.getCmp('delSession').hide();
				}
			},
			failure : function(response)
			{ 
				myMask.hide();
				window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		}); 
	},
	deleteICASessions: function(){
		var me = this;
		var icagridsel = '';
		var icagrid = Ext.getCmp('icaSessionGrid');
		if(!Ext.isEmpty(icagrid) && icagrid != null && icagrid != undefined)
			icagridsel = icagrid.getSelectionModel().getSelection();
		var vpngrid = '';
		if(!Ext.isEmpty(Ext.getCmp('vpnSessionGrid')) && Ext.getCmp('vpnSessionGrid') != null && Ext.getCmp('vpnSessionGrid') != undefined)
			vpngrid = Ext.getCmp('vpnSessionGrid').getSelectionModel().getSelection();
		var values='';
		var array = new Array();
		var selectedICAVal = "";
		var selectedVPNVal = "";
		if (icagridsel == "" && vpngrid == ""){
			Ext.MessageBox.show(
			{
				title :'Terminate User Sessions',
				msg : emptySelect,
				icon : 'iconInformation',
				buttons : Ext.Msg.OK,
				width : 300
			});
			return false;
		}
		for (var i=0; i < vpngrid.length ; i++) {
			values = vpngrid[i];
			selectedVPNVal += values.get('COLUMN_0')+","+values.get('COLUMN_1')+",";
		}

		if(!Ext.isEmpty(icagrid) && icagrid != null && icagrid != undefined){
			var dataStorelen = icagrid.getStore().getProxy().data.length;
			var deleteAllICASession = 'false';
			if(dataStorelen == icagridsel.length){
				deleteAllICASession = 'true';
				for (var i=0; i < icagridsel.length ; i++) {
					values = icagridsel[i];
					if(i == 0)
						selectedICAVal = values.get('COLUMN_0')+",";
					selectedICAVal += values.get('COLUMN_2')+",";
				}
			}
			else{
				for (var i=0; i < icagridsel.length ; i++) {
					values = icagridsel[i];
					selectedICAVal += values.get('COLUMN_0')+","+values.get('COLUMN_2')+","+values.get('sessionID')+",";
				}
			}
		}

		Ext.Msg.show({
			title : 'Terminate User Sessions',
			msg : deleteCnfMsg,
			icon : 'iconConfirmation',
			buttons : Ext.Msg.YESNO,
			width : 300,
			fn : function(buttonText) {
				if (buttonText == "yes") {
					var resultPanelObj = Ext.getCmp('sessionGridPanel');
					var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Trying to kill sessions...'});
					myMask.show();
					Ext.Ajax.request({
						url:'Netscalersessions.jsp?deleteSession=true&selectedICAVal='+selectedICAVal+'&deleteAllICASession='+deleteAllICASession+'&selectedVPNVal='+selectedVPNVal,
						method:'POST',
						scope:this,
						success:function(response){
							if(response.status == 200 && !Ext.isEmpty(response.responseText))
							{
								resultPanelObj.removeAll();
								publicJSON = Ext.decode(response.responseText);

								var icaColumnDetails = publicJSON.ICACOLUMNS;
								var vpnColumnDetails = publicJSON.VPNCOLUMNS;
								var errorColumnDetails = publicJSON.ERRORCOLUMNS;
								var icaDataArrayStore = publicJSON.ICASessionData;
								var vpnDataArrayStore = publicJSON.VPNSessionData;
								var errorDataArrayStore = publicJSON.ErrorData;

								myMask.hide();
								Ext.getCmp('delSession').hide();

								if (!Ext.isEmpty(icaDataArrayStore) && icaDataArrayStore != null && icaDataArrayStore.length > 0)
									me.createGrid(icaColumnDetails,icaDataArrayStore,"ica","");

								if (!Ext.isEmpty(vpnDataArrayStore) && vpnDataArrayStore != null && vpnDataArrayStore.length > 0)
									me.createGrid(vpnColumnDetails,vpnDataArrayStore,"vpn","");

								if (!Ext.isEmpty(errorDataArrayStore) && errorDataArrayStore != null && errorDataArrayStore.length > 0)
									me.createGrid(errorColumnDetails,errorDataArrayStore,"error","");

								if(Ext.isEmpty(icaDataArrayStore) && Ext.isEmpty(vpnDataArrayStore) && Ext.isEmpty(errorDataArrayStore)){
									var msgs = publicJSON.errormsg;
									if(msgs.indexOf("nitro exception:") >= 0)
										msgs = msgs.substring(msgs.indexOf("nitro exception:")+16);
									resultPanelObj.removeAll();
									resultPanelObj.add({
										xtype: 'container',
										id: 'searchid',
										margin: '200 0 10 0',
										//border: true,
										frame: true,
										style: {
											'text-align': 'center'
										},
										html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style=""></div><div style="font-size:12px">'+msgs+'! </div></td></tr></table>'
									});
									resultPanelObj.show();
								}
							}
						},
						failure : function(response)
						{ 
							myMask.hide();
							window.parent.location.href="/final/servlet/com.egurkha.Logout";
						}
					}); 
				}
			}
		});
	},
	createGrid: function(columnDetails,dataArrayStore,storeID,selectionModel){
		var fieldstoStore = new Array();
		var mainColumnsObjArray = new Array();
		var subColObjArray = new Array();
		var align='';
		var count = 0;
		var flexVal = 1;

		for (var key in columnDetails){
			subColObjArray = new Array();
			var mainColumn = key;
			if(storeID == 'error'){
				if(mainColumn == 'Error Message'){
					align='left';
					flexVal = 2;
				}
				else{
					align='center';
					flexVal = 1;
				}
			}
			else{
				if(mainColumn == 'User name'){
					align='left';
					flexVal = 1;
				}
				else if(mainColumn == 'Netscaler IP/Hostname' || mainColumn == 'XenApp/XenDesktop IP Address' || mainColumn == 'XenApp/XenDesktop Port'){
					align='center';
					flexVal = 1.5;
				}
				else{
					align='center';
					flexVal = 1;
				}
			}

			var subcolumn = columnDetails[key];
			var adujstedWidth=200;
			var dataidx = 'COLUMN_' + count;
			fieldstoStore.push(dataidx);
			if(count == 0)
				fieldstoStore.push('sessionID');
			if(!Ext.isEmpty(subcolumn)){
				mainColumn = mainColumn + '<div>'+subcolumn+'</div>';
			}
			mainColumnsObjArray.push({
				header: mainColumn,
				sortable:false,
				dataIndex: dataidx,
				align:align,
				flex:flexVal,
				renderer:function(val,metaData,record,rowIndex)
				{
					return val;
				}
			});
			count++;
		}

		var store = Ext.create('Ext.data.Store', {
			storeId: storeID+'SessionStore',
			//pageSize:userdataperpage,
			fields:fieldstoStore,
			/*proxy : {
				type : 'pagingmemory',
				reader : {
					type : 'json'
				}
			},*/
			data:dataArrayStore,
			autoLoad : true,
			remoteSort: true
		});
		var sessionGrid = Ext.create('utilities.CustomGrid', {
			id: storeID+'SessionGrid',
			name: storeID+'SessionGrid',
			cls: 'gridSkin',
			flex:1,
			//style:{'overflow-x':'hidden !important'},
			margin:10,
			layout:'fit',
			frame:false,
			selModel:selectionModel,
			//pageLimit:null,
			border: false,
			store: store,
			columns:mainColumnsObjArray
		});

		var resultPanelObj = Ext.getCmp('sessionGridPanel');
		var title = storeID.toUpperCase()+' Sessions';
		if(storeID == 'error')
			title = 'Error Details';
		resultPanelObj.add({
			xtype: 'container',
			id: storeID+'SessionGridTitle',
			margin:10,
			//border: true,
			frame: true,
			style: {
				'text-align': 'left'
			},
			html:'<table width="100%" height="100%"><tr><td align="left"><div style="font-size:12px;font-weight:bold">'+title+'</div></td></tr></table>'
		});
		resultPanelObj.add(sessionGrid);
		resultPanelObj.show();
		resultPanelObj.doLayout();
		Ext.getCmp(storeID+'SessionGrid').getSelectionModel().selectAll(false);
	}
});



