Ext.define('TerminateSessions.view.TerminateSessions',
{
	extend: 'Ext.form.Panel',
	alias: 'widget.terminateSessionsView',
	cls:'outerpanel',
	id: 'mainUser',
	title: 'Terminate User Sessions',
	margin:'8 8 0 8',
	header:{cls:'zonereporthead'},
	scroll:true,
	autoScroll:true,
	requires: [
		'Ext.ux.CheckColumn',
		'Ext.ux.RowExpander',
		'Ext.grid.*',
		'utilities.CustomGrid',
		'utilities.innerScrollContainer'
	],

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	items: [{
		xtype: 'container',
		cls:'formOuter',
		padding:'10 0 10 0',
		margin: '20 10 0 10',
		layout: {
			type: 'hbox',
			pack: 'center'
		},
		
		items: [
			{
				xtype:'textfield',
				cls:'textbox',
				fieldLabel:'User Name',
				labelSeparator: ' ',
				width:350,
				id: 'uname',
				columnWidth: 1,
				maxLength : 256,
				enforceMaxLength : true,
				name: 'uname'
			},
			{
				xtype: 'button',
				text: 'Find Sessions',
				margin:"0 10 0 20",
				width: 100,
				cls: 'button20',
				name: 'showSessions',
				id: 'showSessions'
			}
		]
	},
	{
		xtype: 'container',
		margin: '10 0 0 0',
		items : [
			{
				xtype: 'panel',
				id:'sessionGridPanel',
				frame: false,
				border:false,
				flex:1,
				margin:0,
				layout:{
					type:'vbox',
					align:'stretch'
				},
				scroll:false,
				autoScroll:false,
				items:[]
			}
		]
	},
	{
		xtype: 'container',
		layout: {
			type: 'hbox',
			pack: 'center'
		},
		margin: '20 0 20 0',
		items: [
			{
				xtype: 'button',
				text: 'Terminate Sessions',
				width: 150,
				cls: 'button20',
				name: 'delSession',
				id: 'delSession',
				hidden:true
			}
		]
	}]

});



