Ext.define('TerminateSessions.view.Viewport', {
	extend: 'Ext.container.Viewport',
	layout: 'fit',
	id: 'viewport',
	initComponent: function() {
		Ext.get('loadmask').remove();
		this.items = [
			{
				xtype: 'panel',
				id: 'viewportpanel',
				bodyPadding: 0,
				padding: 0,
				frame: false,
				border: false,
				layout: 'border',
				cls : 'content-frame',
				items: [
					{
						region: 'north',
						margin:'8 8 0 8',
						cls:'logotabsetBg',
						height: 38,
						items: [
							{
								xtype: 'container',
								border: false,
								layout: {
									type : 'hbox',
									pack : 'start',
									align: 'middle'
								},
								items: [
									{
										xtype:'container',
										html:'<img id="logoImg" src="'+logoImageName+'?_dc='+new Date()+'" border="0" />',
										margin:0,
										padding:'2 12 2 12',
										height:38,
										frame:false,
										width:129,
										style:{'border':'0px solid red'}
									},
									{
										xtype: 'tbfill'
									},
									{
										xtype:'container',
										html:'<a href="javascript:signOut(0)" class="indexTopLink" ><div class="iconSignoutIndex" style="float:left"></div></a>',
										border: true,
										cls:'circle',
										id:'signout',
										listeners: {
											afterrender: function () {
												Ext.create('Ext.tip.ToolTip', {
													target: this.id,
													anchor: 'top',
													id:'signout_tooltip',
													cls: 'yellowTip',
													trackMouse: true,
													html: 'Signout'
												});
											}
										},
										margin:'0 9 0 0',
										bodyPadding:'0',
										frame:false
									}
								]
							}
						]
					},
					{
						region: 'center',
						/*id: 'dataPanel',
						margin :'10 8 0 8',
						frame: false,
						border: false,
						hideCollapseTool: true,
						autoScroll : true,
						layout: {
							type: 'hbox',
							align: 'stretch'
						},
						flex: 1*/
						xtype:'terminateSessionsView'
					},
					{
						region: 'south',
						xtype: 'container',
						margins: '0 8 0 8',
						cls: 'footerIndex',
						layout: {
							type: 'hbox',
							align: 'stretch'
						},
						items : [
							{
								xtype: 'container',
								html:'&copy;&nbsp;eG Innovations, Inc&#46; All Rights Reserved - v '+version,
								margin: '6 0 5 0'
							}
						]
					}
				]
			}
		];
		this.callParent();
	}

});



