var infoTest;
var searchObj;
Ext.define('TrendGraphGenerator.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'settings', ref:'settings'},
		{selector:'utilitiestool', ref:'utilitiestool'},
		{selector:'trendgraphForm',ref:'trendgraphForm'},
		{selector : 'settingsForm',ref : 'settingsForm'},
		{selector : 'resultpanel',ref : 'resultpanel'}
	],
	init:function(){
        this.control({
            /*'main':{
                'boxready':this.afterMainRender
            },*/
            'trendgraphForm' : {
                'boxready' : this.loadForm
            },
            'settingsForm' : {
                'afterrender' : this.settingsFormRender
            },
            'main  scrollcombo[id="hostlist"]' : {
                'select' : this.component_onchange
            },
            'main  scrollcombo[id="complist"]' : {
				'select' : this.comptype_onchange
			},
            'main  scrollcombo[id="layerlist"]' : {
                'select' : this.layer_onchange
            },
            'main  scrollcombo[id="testlist"]' : {
                'select' : this.test_onchange
            },
            'main  scrollcombo[id="sitelist"]' : {
                'select' : this.site_onchange
            },
          /*  'settingsForm combo[id="er_timeline"]' : {
                'select' : this.changeTimeline
            },*/
		     'settingsForm scrollcombo[id="period"]':
			{
				'select' : this.updateTimelineOptions
			},
            'main utilitiestool':
            {
                'afterrender': this.hideTools
            },
            'main button[id="submit"]':
            {
                'click':this.showResult
            },
            'main trigger[name="filterOpt"]':
            {
                'keyup': this.filterMultiselect
            },
			'utilitiestool > #dataTool > button':{
				'click':this.showData
			},
			'utilitiestool > #upbutton':
			{
				'click':this.toggleForm
			},
			'main trigger[name="descriptionOpt"]':
			{
				'keyup': this.descriptorOptSelect
			},
        });
	},
	toggleForm:function(){
		var ornt = this.getTrendgraphForm();
		ornt.toggleCollapse(true);		
		if(ornt.collapsed)
        {		
            ornt.removeCls('formOuter');
        }
        else
        {
            ornt.addCls('formOuter');
        }		
	},
	hideTools:function()
	{
		
		this.getUtilitiestool().loadIcon(
			false, //save
			false, //print
			false, //mail
			true, //data
			false, //cvs
			false, // fav
			false,// schedule
			false, //daignosis
			false, //togglebutton
			false //close
			);
			Ext.getCmp('dataTool').setDisabled(true);
			Ext.getCmp('DataSeparator').hide();
			//Ext.getCmp("upbutton").setDisabled(true);
	},
	loadForm : function(thisObj) {
		var me = this;
        var form = thisObj.getForm();
        if (isSubmit != undefined && isSubmit == 'true') {
        	var compName = comp.substring(0,comp.lastIndexOf(":"));
			var compType = comp.substring(comp.lastIndexOf(":")+1);
            this.doFilter('sitelist', form, 'getUserSites', '&p0=' + site,site);
            if(site=='-1')
			{
				 this.doFilter('complist', form, 'getComponentTypesForSite','&P0=no' , compType);
			     this.doFilter('hostlist', form, 'getComponentsForType', '&P0=' + compType , comp);
			}
            else
			{
				 this.doFilter('complist', form, 'getComponentTypesForSite','&P0=' + site , compType);
			     this.doFilter('hostlist', form, 'getComponentsForType', '&P0=' + compType , comp);
			}
            this.doFilter('layerlist', form, 'getLayersForComponent', '&P0='+ comp, layer);
			this.doFilter('testlist', form, 'getTestListsForGraph', '&P0=' + site+ '&P1=' + comp + '&P2=' + layer, stest);
			this.doFilter('descriptionlist', form, 'getTestDescriptorsForGraph', '&P0=' + site + '&P1=' + comp + '&P2=' + layer+ '&P3=' +encodeURIComponent(test),'-');
            this.doFilter('msmt_host', form, 'selectMsmtHostForGraph', '&P0='+ site + '&P1=' + comp + '&P2=' + layer + '&P3='+ encodeURIComponent(test), msmt_host);
            this.doFilter('measurelist', form, 'getMeasuresForGraph1', '&P0='+ encodeURIComponent(test) + '&P1=' + layer + '&',measure);
            Ext.getCmp('settings').queryString = queryString;
            this.renderResult(queryString);
        
        }
        else 
        {

            this.loadServices(form);
			this.loadComponentTypes(form);
            this.loadComponents(form);

            this.setNotApplicable(form,'layerlist',defaultJSON.screenLabels['monitor.common.DefaultLayerOption']);
            this.setNotApplicable(form,'testlist',defaultJSON.screenLabels['monitor.common.DefaultTestOption']);
            this.setNotApplicable(form,'msmt_host',defaultJSON.screenLabels['monitor.common.DefaultMsmthostOption']);
            this.setNotApplicable(form,'measurelist',defaultJSON.screenLabels['monitor.common.DefaultMeasureOption']);
			this.setNotApplicable(form,'descriptionlist',chooseDescriptor);
        }
	/* setInterval(function()
		{
				me.showResult();

		},refreshFrequency);	*/
    },
    settingsFormRender : function() {
        var settingsForm = this.getSettingsForm().getForm();
        var screenLabels = defaultJSON['screenLabels'];
        var objectArr = new Array();
        objectArr['er_timeline'] = screenLabels['monitor.common.Timeline'];
        objectArr['er_stdate'] = screenLabels['monitor.common.From'];
        objectArr['er_sthr'] = screenLabels['monitor.common.Hr'];
        objectArr['er_enddate'] = screenLabels['monitor.common.To'];
        objectArr['er_endhr'] = screenLabels['monitor.common.Hr'];
        objectArr['er_mode'] = screenLabels['monitor.common.View'];
        this.loadScreenLabels(settingsForm, objectArr);

        var selectedData = defaultJSON.timelinedetails['timelineSelections'];
        var timelineCombo = defaultJSON.timelinedetails['timeline'];
        if (!Ext.isEmpty(timelineCombo)) {
            var timelineSelected = selectedData['selectedTimeline']
            this.setComboOptionsInList(settingsForm, 'er_timeline',
                    timelineCombo, timelineSelected);
        }

        var startDateSelected = selectedData['selectedStartDate'];
        if (!Ext.isEmpty(startDateSelected)) {

            Ext.getCmp('er_stdate').setValue(startDateSelected);
            Ext.getCmp('er_stdate').dataArray = startDateSelected;

        }
        var endDateSelected = selectedData['selectedEndDate'];
        if (!Ext.isEmpty(endDateSelected)) {

            Ext.getCmp('er_enddate').setValue(endDateSelected);
            Ext.getCmp('er_enddate').dataArray = endDateSelected;
        }

        var startHrSelected = selectedData['selectedStartHour'];
        if (!Ext.isEmpty(startHrSelected)) {
            settingsForm.findField('er_sthr').setValue(startHrSelected);
            settingsForm.findField('er_sthr').dataArray = startHrSelected;
        }

        var endHrSelected = selectedData['selectedEndHour'];
        if (!Ext.isEmpty(endHrSelected)) {
            settingsForm.findField('er_endhr').setValue(endHrSelected);
            settingsForm.findField('er_endhr').dataArray = endHrSelected;
        }
    //    this.changeTimeline();

        var graphSelected = selectedData['selectedMode'];
        if (!Ext.isEmpty(graphSelected)) {
            settingsForm.findField('er_mode').setValue(graphSelected);
        }

        var durationCombo = defaultJSON.timelinedetails['period'];
        
        if (!Ext.isEmpty(durationCombo)) {
            this.setComboOptionsInList(settingsForm, 'period', durationCombo,
                    'H');
        }

        var graphmodeCombo = defaultJSON['graphmode'];
        if (!Ext.isEmpty(durationCombo)) {
            this.setComboOptionsInList(settingsForm, 'graphmode', graphmodeCombo,'minmax');
        }

        if (isSubmit != undefined && isSubmit == 'true') {
           settingsForm.findField('er_stdate').setValue(starttime);
           settingsForm.findField('er_stdate').dataArray = endtime;
           settingsForm.findField('er_timeline').setValue(decodeURIComponent(time));
           settingsForm.findField('er_enddate').setValue(endtime);
           settingsForm.findField('er_enddate').dataArray = endtime;
           settingsForm.findField('er_sthr').setValue(starthr);
           settingsForm.findField('er_sthr').dataArray = starthr;
           settingsForm.findField('er_endhr').setValue(endhr);
           settingsForm.findField('er_endhr').dataArray = endhr;
           settingsForm.findField('er_mode').setValue(mode);
           settingsForm.findField('graphmode').setValue(gmode);

        }
        
    },
    changeTimeline : function(obj) {
        var getTimelineVal = Ext.getCmp('er_timeline').getValue();
        var stDateObj = Ext.getCmp('er_stdate');
        var endDateObj = Ext.getCmp('er_enddate');
        var stHrObj = Ext.getCmp('er_sthr');
        var endHrObj = Ext.getCmp('er_endhr');
        if (getTimelineVal == 'Any') {
            stDateObj.setDisabled(false);
            endDateObj.setDisabled(false);
            stHrObj.setDisabled(false);
            endHrObj.setDisabled(false);
        } else {
            stDateObj.setDisabled(true);
            endDateObj.setDisabled(true);
            stHrObj.setDisabled(true);
            endHrObj.setDisabled(true);
        }
        if(getTimelineVal!='Any')
        {
            var strtdt = Ext.Date.dateFormat(stDateObj.getValue(), mgrDateFormat);
            var enddt = Ext.Date.dateFormat(endDateObj.getValue(), mgrDateFormat);
            if (!Ext.isEmpty(obj)) {
                var param = 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method=getTime&P0='
                        + getTimelineVal
                        + '&P1='
                        + encodeURIComponent(strtdt)
                        + '&P2='
                        + encodeURIComponent(enddt)
                        + '&P3='
                        + stHrObj.getValue()
                        + '&P4='
                        + endHrObj.getValue()
                        + '&P5=' + encodeURIComponent(currentDateFormat);
                var me = this;
    
                Ext.Ajax.request({
                            url : '/final/servlet/com.eg.RemoteScriptingServlet',
                            params : param,
                            success : function(response) {
                               
                                var formdata = Ext.decode(response.responseText);
                                stDateObj.setValue(formdata[0]);
                                endDateObj.setValue(formdata[1]);
                                stHrObj.setValue(formdata[2]);
                                endHrObj.setValue(formdata[3]);
                            }
                        });
            }
        }
    },
    loadScreenLabels : function(form, ObjectArr) {
        var obj = '';
        for (var key in ObjectArr) {

            obj = !Ext.isEmpty(form.findField(key)) ? form.findField(key) : Ext
                    .getCmp(key);

            if (obj.getXType() != 'label') {
                form.findField(key).setFieldLabel(ObjectArr[key]);
            } else {
                Ext.getCmp(key).setText(ObjectArr[key]);
            }
        }
    },
    loadServices : function(form) {
        var param = 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method=getUserSites';
        var me = this;
        Ext.Ajax.request({
                    url : '/final/servlet/com.eg.RemoteScriptingServlet',
                    params : param,
                    success : function(response) {
                        var formdata = Ext.decode(response.responseText);
                        me.setComboOptionsInList(form, 'sitelist', formdata,'-1');
                    }
                });
    },
	loadComponentTypes:function(form) {
		var param = 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method=getComponentTypesForSite&P0=no';
		var me = this;
		Ext.Ajax.request({
			url : '/final/servlet/com.eg.RemoteScriptingServlet',
			params : param,
			success : function(response) {
				var formdata = Ext.decode(response.responseText);
				componentsRawData = formdata;
				me.setComboOptionsInList(form, 'complist', formdata,'-1');
			}
		});
	},
    loadComponents : function(form) {
        var param = 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method=getComponentsForType&P0=no';
        var me = this;
        Ext.Ajax.request({
                    url : '/final/servlet/com.eg.RemoteScriptingServlet',
                    params : param,
                    success : function(response) {

                        var formdata = Ext.decode(response.responseText);
                        componentsRawData = formdata;
                        me.setComboOptionsInList(form, 'hostlist', formdata,'-1');
                    }
                });
    },
    setComboOptionsInList : function(form, fieldName, list, value) {
        
        form.findField(fieldName).getStore().loadRawData(list);
        form.findField(fieldName).suspendEvents(false);
		
	//
		if(fieldName=='descriptionlist')
		{
			
			if(list.length>1){
			//enable the fields
			infoTest=true;
			var obj = Ext.getCmp("descriptionOpt");
			Ext.get('descriptionOpt-inputEl').setStyle('width', '130');
			//obj.getEl().show();
			var decObj = Ext.getCmp("descriptionlist");
			Ext.get('descriptionlist-inputEl').setStyle('width', '210');
			decObj.getEl().show();
			this.getMain().doLayout();
			
			}
			else{
			//disable the fields
			infoTest=false;
			var obj = Ext.getCmp("descriptionOpt");
			obj.getEl().hide();
			var decObj = Ext.getCmp("descriptionlist");
			decObj.getEl().hide();
			this.getMain().doLayout();
			}
			//descRawData = list;
		}
		//
		if(value=='-')
		{
			//value = form.findField(fieldName).getStore().getAt(1).get('valueField');
			try
			{
				value = form.findField(fieldName).getStore().getAt(1).get('valueField');
			}
			catch (err)
			{
				value = form.findField(fieldName).getStore().getAt(0).get('valueField');
			}
		}
		
		if(fieldName=='sitelist')
		{
			if(!value || value=='NULL')
				value="-1";
		}

		if(fieldName=='testlist')
		{
		form.findField(fieldName).setValue(value);
			var fname = form.findField(fieldName).getValue();
			if(!fname)
			{
				if(value.indexOf("-"))
					value = value.substring(0,value.indexOf("-"));
				form.findField(fieldName).setValue(value);
			}
		}
        form.findField(fieldName).setValue(value);
        form.findField(fieldName).resumeEvents();
    },
    setComboValue : function(form, fieldName, value) {
        form.findField(fieldName).suspendEvents(false);
        form.findField(fieldName).setValue(value);
        form.findField(fieldName).resumeEvents();
    },
    setNotApplicable : function(form, fieldname, option) {
        
        form.findField(fieldname).getStore().removeAll();

        form.findField(fieldname).getStore().loadRawData([{
                    "displayField" : option,
                    "valueField" : "-1"
                }]);
        form.findField(fieldname).setValue("-1");
    },
    component_onchange : function(thisObj) {

        var val = thisObj.getValue();
        var form = thisObj.up('.form').getForm();
        this.setNotApplicable(form, 'layerlist',
                defaultJSON.screenLabels['monitor.common.DefaultLayerOption']);
        this.setNotApplicable(form, 'testlist',
                defaultJSON.screenLabels['monitor.common.DefaultTestOption']);
        this
                .setNotApplicable(
                        form,
                        'msmt_host',
                        defaultJSON.screenLabels['monitor.common.DefaultMsmthostOption']);
        this
                .setNotApplicable(
                        form,
                        'measurelist',
                        defaultJSON.screenLabels['monitor.common.DefaultMeasureOption']);
		this.setNotApplicable(form,'descriptionlist',chooseDescriptor);
		Ext.getCmp("descriptionOpt").setValue("");
        var no_param = '&P0=' + val;

        this.doFilter('layerlist', form, 'getLayersForComponent', no_param,
                '-1');
    },
    layer_onchange : function(thisObj) {
        var val = thisObj.getValue();
        var form = thisObj.up('.form').getForm();

        this.setNotApplicable(form, 'testlist',
                defaultJSON.screenLabels['monitor.common.DefaultTestOption']);
        this
                .setNotApplicable(
                        form,
                        'msmt_host',
                        defaultJSON.screenLabels['monitor.common.DefaultMsmthostOption']);
        this
                .setNotApplicable(
                        form,
                        'measurelist',
                        defaultJSON.screenLabels['monitor.common.DefaultMeasureOption']);
		this.setNotApplicable(form,'descriptionlist',chooseDescriptor);
		Ext.getCmp("descriptionOpt").setValue("");

        var siteName = form.findField('sitelist').getValue();
        siteName = (siteName == '-1') ? 'NULL' : siteName;
        var hostName = form.findField('hostlist').getValue();

        var no_param = '&P0=' + siteName + '&P1=' + hostName + '&P2=' + val
                + '';

		this.doFilter('testlist', form, 'getTestListsForGraph', no_param, '-1');

    },
    test_onchange : function(thisObj) {
        var val = thisObj.getValue();
        var form = thisObj.up('.form').getForm();

        this.setNotApplicable(
                        form,
                        'msmt_host',
                        defaultJSON.screenLabels['monitor.common.DefaultMsmthostOption']);
        this.setNotApplicable(form,'measurelist',defaultJSON.screenLabels['monitor.common.DefaultMeasureOption']);
		this.setNotApplicable(form,'descriptionlist',chooseDescriptor);
		Ext.getCmp("descriptionOpt").setValue("");
        var siteName = form.findField('sitelist').getValue();
        siteName = (siteName == '-1') ? 'NULL' : siteName;
        var hostName = form.findField('hostlist').getValue();
        var layerName = form.findField('layerlist').getValue();

		//val = val.substring(0, val.indexOf('-'));

        var no_param = '&P0=' + siteName + '&P1=' + hostName + '&P2=' + val
                + '';
		this.doFilter('descriptionlist', form, 'getTestDescriptorsForGraph', '&P0=' + siteName + '&P1=' + hostName + '&P2=' + layerName+ '&P3=' +encodeURIComponent(val),'-');
        this.doFilter('msmt_host', form, 'selectMsmtHostForGraph', '&P0='
                        + siteName + '&P1=' + hostName + '&P2=' + layerName
                        + '&P3=' + encodeURIComponent(val), '-1');
        this.doFilter('measurelist', form, 'getMeasuresForGraph1', '&P0='
                        + encodeURIComponent(val) + '&P1=' + layerName + '&',
                form.findField('measurelist').getStore().getAt(0));
    },
    site_onchange : function(thisObj) {
        var val = thisObj.getValue();
        var form = thisObj.up('.form').getForm();
        this.setNotApplicable(form,'hostlist',defaultJSON.screenLabels['monitor.common.DefaultComponentOption']);
        this.setNotApplicable(form, 'layerlist',defaultJSON.screenLabels['monitor.common.DefaultLayerOption']);
        this.setNotApplicable(form, 'testlist',defaultJSON.screenLabels['monitor.common.DefaultTestOption']);
        this.setNotApplicable(form,'msmt_host',defaultJSON.screenLabels['monitor.common.DefaultMsmthostOption']);
        this.setNotApplicable(form,'measurelist',defaultJSON.screenLabels['monitor.common.DefaultMeasureOption']);
		this.setNotApplicable(form,'descriptionlist',chooseDescriptor);
		Ext.getCmp("descriptionOpt").setValue("");

        val = (val == '-1') ? 'no' : val;
		this.doFilter('complist', form, 'getComponentTypesForSite', '&P0=' + val + '', '-1');
        //this.doFilter('hostlist', form, 'getComponentsForSite', '&P0=' + val+ '', '-1');
    },
	comptype_onchange : function(thisObj){
		var val = thisObj.getValue();
		var form = thisObj.up('.form').getForm();
		this.setNotApplicable(form,'hostlist',defaultJSON.screenLabels['monitor.common.DefaultComponentOption']);
		this.setNotApplicable(form,'layerlist',defaultJSON.screenLabels['monitor.common.DefaultLayerOption']);
		this.setNotApplicable(form,'testlist',defaultJSON.screenLabels['monitor.common.DefaultTestOption']);
		this.setNotApplicable(form,'msmt_host',defaultJSON.screenLabels['monitor.common.DefaultMsmthostOption']);
		this.setNotApplicable(form,'measurelist',defaultJSON.screenLabels['monitor.common.DefaultMeasureOption']);
	
		var site_val = '';
		if(!Ext.isEmpty(Ext.getCmp('sitelist')) && Ext.getCmp('sitelist')!=null && Ext.getCmp('sitelist')!=undefined)
			site_val = Ext.getCmp('sitelist').getValue();
		
		val = (val == '-1') ? 'no' : val;
		site_val = (site_val == '-1') ? 'NULL' : site_val;
		var no_param = '&P0=' + site_val + '&P1=' + val;
		//if((!Ext.isEmpty(val)&& val!=null && val!=undefined && val=='-1') && ((!Ext.isEmpty(site_val)&& site_val!=null && site_val!=undefined && site_val!='-1')))
			//this.doFilter('hostlist', form, 'getComponentsForSiteDD', '&P0=' + site_val + '', '-1');
		//else
		this.doFilter('hostlist', form, 'getComponentsForType',no_param, '-1');		
	},
    doFilter : function(fieldname, form, method, no_param, val) {

        var param = 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method='
                + method + no_param;
        var me = this;
        Ext.Ajax.request({
                    url : '/final/servlet/com.eg.RemoteScriptingServlet',
                    params : param,
                    success : function(response) {
                        
                        var formdata = Ext.decode(response.responseText);
						if(fieldname=="descriptionlist")
						{
							descriptorRawData = formdata;
						}
                        me.setComboOptionsInList(form, fieldname,formdata, val);
                    }
                });
    },
    beforeFormSubmit : function() {
        var mainForm = this.getTrendgraphForm().getForm();
        var hostObj = mainForm.findField('hostlist');
        var layerObj = mainForm.findField('layerlist');
        var testObj = mainForm.findField('testlist');
        var msmt_Obj = mainForm.findField('msmt_host');
        var measureObj = mainForm.findField('measurelist');
		var descObj = mainForm.findField('descriptionlist');
		var valid=false;		
		
		var defVal="";
		if(descriptorRawData[0]!=null && descriptorRawData[0]!=undefined)
		{
			defVal=descriptorRawData[0].displayField;
		}
		
		for(var i=0;i<descriptorRawData.length;i++)
		{			
			if(descriptorRawData[i].displayField==descObj.getValue())
				valid=true;			
		}

        var msg = '';
        if (hostObj.getValue() == '-1' || hostObj.getValue()=='') {
            msg = chooseComp;
        } else if (layerObj.getValue() == '-1' || layerObj.getValue()=='') {
            msg = chooseLayer;
        } else if (testObj.getValue() == '-1' || testObj.getValue()=='') {
            msg = chooseTest;
        } else if (msmt_Obj.getValue() == '-1' || msmt_Obj.getValue()=='') {
            msg = chooseMsmtHost;
        } else if (measureObj.getValue() == '-1' || measureObj.getValue()=='') {
            msg = chooseMeasure;
		}
		else if((descObj.getValue() =='-1' || descObj.getValue() ==null || !valid)  && infoTest)
		{
			
			msg = chooseDescriptor;
		 if (!Ext.isEmpty(msg)) {
			  Ext.MessageBox.show({
                        title : 'Alert',
                        msg : msg,
                        buttons : Ext.MessageBox.OK,
                        icon : Ext.MessageBox.WARNING,
						fn : function (buttonId) {
						if(searchObj!=null)
						{
							searchObj.setValue("");
						}
						var compStore = descriptorRawData;
						var compObj = Ext.getCmp('descriptionlist');
						compObj.getStore().loadRawData(compStore);
						if ( compObj.getStore().findExact('valueField', '-1', 0) == -1 && valid)
						{
							compObj.getStore().insert(0, {'valueField': '-1', 'displayField': chooseDescriptor});
						}
						if ( !Ext.isEmpty( comp ) && comp!="null")
						{
							compObj.setValue(defVal);    
						}
						else
						{
							compObj.setValue(defVal);
						}
					}

                    });
			

            return false;
			} else {
            return true;
			}
			
		
        }

		var settingsForm = this.getSettingsForm().getForm();
		var endhr = parseInt(settingsForm.findField('er_endhr').getValue());
		//var endtime = formatDate(new Date(getDateFromFormat(settingsForm.findField('er_enddate').dataArray, mgrDisplayDateFormat)), "MM/dd/yyyy");
		var endtime = formatDate(settingsForm.findField('er_enddate').getValue(), "MM/dd/yyyy");
		var starthr = parseInt(settingsForm.findField('er_sthr').getValue());
		//var starttime = formatDate(new Date(getDateFromFormat(settingsForm.findField('er_stdate').dataArray, mgrDisplayDateFormat)), "MM/dd/yyyy");
		var starttime = formatDate(settingsForm.findField('er_stdate').getValue(), "MM/dd/yyyy");
		if(dateValidation(starttime,endtime,starthr,endhr,0,0)==-1)
		{
			msg ="From date should be lesser than to date";
		}
        if (!Ext.isEmpty(msg)) {
            Ext.MessageBox.show({
                        title : 'Alert',
                        msg : msg,
                        buttons : Ext.MessageBox.OK,
                        icon : Ext.MessageBox.WARNING
                    });
            return false;
        } else {
            return true;
        }
    },
    genQueryString : function(Arr) {
        var qStr = '';
        for (var key in Arr) {
            qStr += '&' + key + '=' +Arr[key];
        }
        Ext.getCmp('settings').queryString = qStr;
        return qStr;
    },
    showResult:function(){		
        var fromSubmit = true;
        if (!this.beforeFormSubmit()) {
            return;
        }

        var queryString = 'resultpage=trend';
        var mainForm = this.getTrendgraphForm().getForm();
        var settingsForm = this.getSettingsForm().getForm();
        //queryString = this.genHiddenQStr();
        var objectArr = new Array();
        objectArr['comp'] = mainForm.findField('hostlist').getValue();
        var compType = mainForm.findField('hostlist').getValue();
        compType = compType.substring(compType.lastIndexOf(':') + 1);
        objectArr['comptype'] = compType;

        var endhr= settingsForm.findField('er_endhr').dataArray;
		//objectArr['endhr']=endhr;

        var endtime= formatDate(new Date(getDateFromFormat(settingsForm.findField('er_enddate').dataArray, currentDateFormat)), "MM/dd/yyyy");
       // objectArr['endtime']=endtime;

        var host = mainForm.findField('hostlist').getValue();
        host = host.substring(0, host.indexOf(':'));
        objectArr['host'] = host;
        var hostlist = mainForm.findField('hostlist').getValue();
        var testlist = mainForm.findField('testlist').getValue();
		var info = mainForm.findField('descriptionlist').getValue();
		//var info = '*' + testlist.substring(testlist.indexOf('+') + 1);
		if(info==-2)
		{
			info="";
		}
		if(info.indexOf('*') > -1)
			info = info;
		else
			info = '*' + info;

        
		do
		{
			if (info.indexOf("&")>-1)
				info=info.replace('&','|amp|');
		} while(info.indexOf("&")>-1);

		do
		{
			if (info.indexOf("+")>-1)
				info=info.replace('+','|plus|');
		} while(info.indexOf("+")>-1);

		do
		{
			if (info.indexOf("%")>-1)
				info=info.replace('%','|pct|');
		} while(info.indexOf("%")>-1);

		do
		{
			if (info.indexOf("#")>-1)
				info=info.replace('#','|hash|');
		} while(info.indexOf("#")>-1);
            
            

        objectArr['hostlist'] = hostlist;
        objectArr['info'] = info;
        objectArr['layer'] = mainForm.findField('layerlist').getValue();
        objectArr['measure'] = mainForm.findField('measurelist').getValue();
        objectArr['mode'] = settingsForm.findField('er_mode').getValue();
        objectArr['msmt_host'] = mainForm.findField('msmt_host').getValue();
       
        var tmphostlist = hostlist.substring(hostlist.indexOf(':') + 1);
        var port = tmphostlist.substring(0, tmphostlist.indexOf(':'));

        objectArr['port'] = port;

        objectArr['site'] = mainForm.findField('sitelist').getValue();

        var starthr= settingsForm.findField('er_sthr').dataArray;
       // objectArr['starthr'] =starthr;

        var starttime = formatDate(new Date(getDateFromFormat(settingsForm.findField('er_stdate').dataArray, currentDateFormat)), "MM/dd/yyyy");
        //objectArr['starttime']=starttime;

		var desc = mainForm.findField('descriptionlist').getValue();
		var test = mainForm.findField('testlist').getValue();
		if(desc==-2)
		{
			desc="";
		}
		//var test = stest.substring(0, stest.indexOf('+') - 1);
		var stest = test +"-+"+desc;
        var time = settingsForm.findField('er_timeline').getValue();
        objectArr['period'] = settingsForm.findField('period').getValue();
        objectArr['graphmode'] = settingsForm.findField('graphmode').getValue();
        stest = stest.replace('+', '*');
		objectArr['stest'] = encodeURIComponent(stest);
		objectArr['test'] = encodeURIComponent(test);
        objectArr['time'] = encodeURIComponent(time);
        objectArr['gtype'] = "0";
        objectArr['gformat'] = "graph";
        

		if(new Date(starttime) > new Date(endtime))
		{
			//Ext.MessageBox.show({
			//	title: 'Alert',
			//	msg: "Start date should be lesser than end date",
			//	buttons: Ext.MessageBox.OK,
			//	icon: Ext.MessageBox.WARNING
			//});
			//return false;
		}
		if(new Date(starttime).valueOf() == new Date(endtime).valueOf())
		{	
			if(starthr  >endhr)
			{
				//Ext.MessageBox.show({
				//title: 'Alert',
				//msg: "Start date should be lesser than end date",
				//buttons: Ext.MessageBox.OK,
				//icon: Ext.MessageBox.WARNING
				//});
				//return false;
			}
		}
		var today = new Date();
		var currentDate = today.getMonth() + "/" + today.getDay() + "/" + today.getYear();
		if(today < new Date(starttime) )
		{
			//Ext.MessageBox.show({
				//title: 'Alert',
				//msg: "From date should be lesser than Current date",
				//buttons: Ext.MessageBox.OK,
				//icon: Ext.MessageBox.WARNING
				//});
				//return false;
		}
        if (stest.indexOf('\\') > -1) {
            var tmpTest = stest.split('\\');
            var encodeTest = '';
            for (var i = 0; i < tmpTest.length; i++) {
                if (i == (tmpTest.length - 1)) {
                    encodeTest += tmpTest[i];
                } else {
                    encodeTest += tmpTest[i] + '/';
                }
            }
            objectArr['encodetest'] = encodeTest;
        }
        objectArr['isSubmit'] = 'true';
        queryString += this.genQueryString(objectArr);
        this.renderResult(queryString);
    },
    renderResult : function(queryString){

	var settingsForm = this.getSettingsForm().getForm();

	var starttime =settingsForm.findField('er_stdate').getValue();
	var endtime = settingsForm.findField('er_enddate').getValue();

	

	var stdate =new Date(settingsForm.findField('er_stdate').getValue());
	var enddate =new Date(settingsForm.findField('er_enddate').getValue());

	 var stmonth = stdate.getMonth();
	 stmonth++;
     stmonth =stmonth < 10 ? '0' + stmonth : stmonth; 
	 var startdate = stdate.getDate();
     startdate = startdate < 10 ? '0' + startdate : startdate; 
	 var styear = stdate.getFullYear();
	 starttime = stmonth+"/"+startdate+"/"+styear;

	 
	 var entmonth = enddate.getMonth();
	 entmonth++;
	 entmonth = entmonth < 10 ? '0' + entmonth : entmonth; 
	 var edate = enddate.getDate();
     edate = edate < 10 ? '0' + edate : edate; 

	 var endyear = enddate.getFullYear();


	  endtime = entmonth+"/"+edate+"/"+endyear;

		var starthr = settingsForm.findField('er_sthr').getValue();
		var endhr = settingsForm.findField('er_endhr').getValue();
		queryString +="&starttime="+starttime+"&endtime="+endtime+"&starthr="+starthr+"&endhr="+endhr;
		M=this.getMain();
		var n = new Ext.LoadMask(M, {
		msg: "Loading..."
		});
		n.show();
        var me = this;
        Ext.Ajax.request({
            url : '/final/servlet/com.eg.EgMonitorResultDispatcher',
            params : queryString,
            success : function(response) {
				n.hide();
                var jsontext = response.responseText;
                var resultsData = Ext.decode(jsontext);
                var resultObj = me.getResultpanel();
                
                resultObj.removeAll();
                resultObj.show();
                var xmlData = '';
                var swfPath = '';
               
                if ( !Ext.isEmpty( resultsData ) && !Ext.isEmpty(resultsData['XML_DATA']))
                {
                    xmlData = resultsData['XML_DATA'];
                    swfPath = resultsData['SWF_PATH'];
					if(!Ext.isEmpty(resultObj.getHeader()))
					{
						resultObj.getHeader().el.show();
					}
					//resultObj.getHeader().el.show();
				    var panelHeight=resultObj.getHeight();
					resultObj.add({
                        xtype: 'panel',
                        width: '100%',
                        height: panelHeight-40,
                        html: '<div style="border: 0px solid red;width:100%;height:100%" id="trendChart"></div>'
                    });
                }
                else
                {
					if(!Ext.isEmpty(resultObj.getHeader()))
					{
						resultObj.getHeader().el.hide();
					}
					resultObj.add({
						xtype: 'panel',							
						width: '100%',
						height: 350,
						html: '<div style="text-align:center"><div class="iconInformation" style="margin:12% auto 0 auto;"></div><div>'+noMeasures+'</div></div>'
					});					
                }
                resultObj.doLayout();
                if ( !Ext.isEmpty( xmlData ) )
                {
					if(fusionChartsApiEnabled)
					{
						if ( FusionCharts('chartObj') )
						{
							FusionCharts('chartObj').dispose();
						}	
						var myChart = new FusionCharts(swfPath,"chartObj", "100%", "100%","0","1");
						myChart.setXMLData(xmlData);
						myChart.setTransparent(true);
						myChart.render("trendChart");
					}
					else
					{
						xmlData['chartTypeH'] = true;
						xmlData['chartExport'] = true;
						xmlData['titleBold'] = true;
						resultObj.setTitle(xmlData['panelTitle']);
						var lineChart = {};
						lineChart = jQuery.extend(true, {}, createLineChart('trendChart',(resultObj.getHeight()-50),(resultObj.getWidth() -150)), lineChart);//350
						lineChart.setData(xmlData, currentDateFormat,'' ,'line',true);
						lineChart.drawChart();
					}
                }
                resultObj.doLayout();
				Ext.getCmp('dataTool').setDisabled(false);
            }
        });
    },
    showData : function(thisObj){
   
    	if (!this.beforeFormSubmit()) {
            return;
        }
		var mainForm = this.getTrendgraphForm().getForm();
    	var settingsForm = this.getSettingsForm().getForm();
    	
    	var graphmode = settingsForm.findField('graphmode').getValue();
    	var reqFrom='';
        if (graphmode=='avg')
            reqFrom='&requestFrom=Avg';
        else if (graphmode=='sum')
            reqFrom='&requestFrom=Sum';
            
    	var data_qrstring;
		
		var queryParam = Ext.getCmp('settings').queryString;
		if(queryParam.indexOf("startime") == -1)
		{
			var settingsForm = this.getSettingsForm().getForm();
			var starttime =settingsForm.findField('er_stdate').getValue();
			var endtime = settingsForm.findField('er_enddate').getValue();
			var stdate =new Date(settingsForm.findField('er_stdate').getValue());
			var enddate =new Date(settingsForm.findField('er_enddate').getValue());
		    var stmonth = stdate.getMonth();
			stmonth++;
			stmonth =stmonth < 10 ? '0' + stmonth : stmonth; 
			var startdate = stdate.getDate();
			startdate = startdate < 10 ? '0' + startdate : startdate; 
			var styear = stdate.getFullYear();
			starttime = stmonth+"/"+startdate+"/"+styear;	 
			var entmonth = enddate.getMonth();
			entmonth++;
			entmonth = entmonth < 10 ? '0' + entmonth : entmonth; 
			var edate = enddate.getDate();
			edate = edate < 10 ? '0' + edate : edate;
			var endyear = enddate.getFullYear();
		    endtime = entmonth+"/"+edate+"/"+endyear;
			var starthr = settingsForm.findField('er_sthr').getValue();
			var endhr = settingsForm.findField('er_endhr').getValue();
			queryParam += "&starttime="+starttime+"&endtime="+endtime+"&starthr="+starthr+"&endhr="+endhr; 
		}
		if(graphmode=='minmax')
    	{
    		data_qrstring = 'TrendGraph?'+queryParam;
    	}
    	else
    	{
    		data_qrstring = 'AvgTrendGraph?'+queryParam+reqFrom;
    	}
    	data_qrstring=data_qrstring+"&rType=Data";
    	
    	Ext.widget('print',{title:'DATA VIEW'}).show();
        var printContentDiv = Ext.select('#printContentDiv');
        printContentDiv.set(
        {
        src :  "../servlet/com.eg."+data_qrstring
        });
    	
    },
    filterMultiselect:function(obj, event)
    {
        var findVal = obj.getValue();
        var compStore = componentsRawData;
        var compObj = Ext.getCmp('hostlist');
        var isRecordFound = false;
        if ( Ext.isEmpty( obj.getValue() ) )
        {
            compObj.getStore().loadRawData(compStore);
            if ( compObj.getStore().findExact('valueField', '-1', 0) == -1 )
            {
                compObj.getStore().insert(0, {'valueField': '-1', 'displayField': chooseComp});
            }
            if ( !Ext.isEmpty( comp ) && comp!="null")
            {
                compObj.setValue(comp);    
            }
            else
            {
                compObj.setValue('-1');
            }
//          compObj.setValue(compStore[0]['valueField']);
        }
        else
        {
			if(findVal!=null)
				findVal=findVal.toLowerCase();

            var genStore = new Ext.data.Store({
                                    fields : ['displayField', 'valueField'],
                                    data : []                               
                                });
            for ( var i = 1; i < compStore.length ; i++ )
            {
                var getRecord = compStore[i]['displayField'];
				if(getRecord!=null)
					getRecord=getRecord.toLowerCase();

                if ( getRecord.indexOf(findVal) > -1 )
                {
                    isRecordFound = true;
                    genStore.add({
                        'displayField': compStore[i]['displayField'],
                        'valueField': compStore[i]['valueField']
                    });
                }
            }
            if ( isRecordFound )
            {
                compObj.getStore().removeAll(); 
                for ( var i = 0; i < genStore.getCount() ; i++ )
                {
                    var getRecord = genStore.getAt(i);
                    compObj.getStore().add(getRecord);
                }
                compObj.setValue(genStore.getAt(0).get('valueField'));
            }
            else
            {
                compObj.getStore().removeAll();
                compObj.getStore().add({
                    'displayField': 'Not Applicable!',
                    'valueField': '-1'
                });
                compObj.setValue('-1');
            }
            obj.focus();
        }
        if (isRecordFound ||  parseInt( event.getCharCode() ) == 13 )
        {
            this.component_onchange(Ext.getCmp('hostlist'));
//            this.hideResult();
        }
    },
    hideResult: function()
    {
        this.getResultpanel().hide();
    },
		updateTimelineOptions : function(comboObj) {
		var settingsForm = this.getSettingsForm().getForm();

		var getTimelineVal = Ext.getCmp('er_timeline').getValue();
		var stDateObj = settingsForm.findField('er_stdate');
		var endDateObj = settingsForm.findField('er_enddate');
		var stHrObj = settingsForm.findField('er_sthr');
		var endHrObj =settingsForm.findField('er_endhr');
		if (getTimelineVal == 'Any') {
			stDateObj.setDisabled(false);
			endDateObj.setDisabled(false);
			stHrObj.setDisabled(false);
			endHrObj.setDisabled(false);
		} else {
			stDateObj.setDisabled(true);
			endDateObj.setDisabled(true);
			stHrObj.setDisabled(true);
			endHrObj.setDisabled(true);
		}

		var objectArr = new Array();
		objectArr['endhr'] = endHrObj.dataArray;
		objectArr['endtime'] =formatDate(new Date(getDateFromFormat(endDateObj.dataArray, mgrDisplayDateFormat)), "MM/dd/yyyy");		
		objectArr['starthr'] = stHrObj.dataArray;
		objectArr['starttime'] =formatDate(new Date(getDateFromFormat(stDateObj.dataArray, mgrDisplayDateFormat)), "MM/dd/yyyy");
		var time = getTimelineVal;
		objectArr['period'] = settingsForm.findField('period').getValue();		
		objectArr['time'] = encodeURIComponent(time);
		var isDurationChanged=false;
		if(comboObj.getId()=="period")
		{
			objectArr['isPeriodChanged']='true';
			isDurationChanged=true;
			if(objectArr['period']=='H')
			{
				objectArr['time']= '24 hours';
			}
			else if(objectArr['period']=='D')
			{
				objectArr['time']= '1 week';
			}
			else if(objectArr['period']=='M')
			{
				objectArr['time']= '6 months';
			}			
		}
		var timelinequeryString = this.genQueryString(objectArr);	
					
		var me = this;
		Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgMonitorRequestDispatcher',
				params : 'comesFrom=summarygraph&isDurationChanged=true&'+timelinequeryString,
				success : function(response) {

					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					if(!Ext.isEmpty(jsonData))
					{
						var selectedData = jsonData.timelinedetails['timelineSelections'];
						var timelineCombo = jsonData.timelinedetails['timeline'];
						if (!Ext.isEmpty(timelineCombo)) {
							var timelineSelected = selectedData['selectedTimeline']
							me.setComboOptionsInList(settingsForm, 'er_timeline',
									timelineCombo, timelineSelected);
						}
						var startDateSelected = selectedData['selectedStartDate'];
						if (!Ext.isEmpty(startDateSelected)) 
						{
							stDateObj.setValue(startDateSelected);
							stDateObj.dataArray = selectedData['startDateInMgrDateFormat'];

						}
						var endDateSelected = selectedData['selectedEndDate'];
						if (!Ext.isEmpty(endDateSelected)) {

							endDateObj.setValue(endDateSelected);
							endDateObj.dataArray = selectedData['endDateInMgrDateFormat'];
						}

						var startHrSelected = selectedData['selectedStartHour'];
						if (!Ext.isEmpty(startHrSelected)) {
							stHrObj.setValue(startHrSelected);
							stHrObj.dataArray =selectedData['startHrInMgrDate'];
						}

						var endHrSelected = selectedData['selectedEndHour'];
						if (!Ext.isEmpty(endHrSelected)) {
							endHrObj.setValue(endHrSelected);
							endHrObj.dataArray = selectedData['endHourInMgrDate'];
						}
					//	this.changeTimeline();

						var graphSelected = selectedData['selectedMode'];
						if (!Ext.isEmpty(graphSelected)) {
							settingsForm.findField('er_mode').setValue(graphSelected);
						}

						me.showResult();
					}
				}
			});
		},
	descriptorOptSelect :function(obj, event)
	{
		searchObj = obj;	
		var findVal = obj.getValue();
		var mainForm = this.getTrendgraphForm().getForm();
		var compStore = descriptorRawData;
		var compObj = Ext.getCmp('descriptionlist');
		var isRecordFound = false;
		if ( Ext.isEmpty( obj.getValue() ) )
		{
			compObj.getStore().loadRawData(compStore);
			if ( compObj.getStore().findExact('valueField', '-1', 0) == -1 )
			{
				compObj.getStore().insert(0, {'valueField': '-1', 'displayField': chooseDescriptor});
			}
			if ( !Ext.isEmpty( comp ) && comp!="null")
			{
				compObj.setValue(comp);    
			}
			else
			{
				compObj.setValue('-1');
			}
			//compObj.setValue(compStore[0]['valueField']);
		}
		else
		{
			var genStore = new Ext.data.Store({
									fields : ['displayField', 'valueField'],
									data : []                               
								});
			if(findVal!=null)
				findVal=findVal.toLowerCase();
		for ( var i = 1; i < compStore.length ; i++ )
		{
			var getRecord = compStore[i]['displayField'];
			if(getRecord!=null)
				getRecord=getRecord.toLowerCase();
			if ( getRecord.indexOf(findVal) > -1 )
			{
				isRecordFound = true;
				genStore.add({
					'displayField': compStore[i]['displayField'],
					'valueField': compStore[i]['valueField']
				});
			}
		}
		if ( isRecordFound )
		{
			compObj.getStore().removeAll(); 
			for ( var i = 0; i < genStore.getCount() ; i++ )
			{
				var getRecord = genStore.getAt(i);
				compObj.getStore().add(getRecord);
			}
			compObj.setValue(genStore.getAt(0).get('valueField'));
		}
		else
		{
			compObj.getStore().removeAll();
			compObj.getStore().add({
				'displayField': 'Not Applicable!',
				'valueField': '-1'
			});
			compObj.setValue('-1');
			if(findVal=="")
			{
				this.setNotApplicable(form,'descriptionlist',chooseDescriptor);
			}
		}
		obj.focus();
	 }
	}
});
function dateValidation(starttime,endtime,starthr,endhr,startmin,tomin)
{	
	var styear = parseInt(starttime.substring((starttime.lastIndexOf("/")+1)));		
	var stday = parseInt(starttime.substring((starttime.indexOf("/")+1),starttime.lastIndexOf("/")));
	var stmon = parseInt(starttime.substring(0,starttime.indexOf("/")));
	var endyear = parseInt(endtime.substring((endtime.lastIndexOf("/")+1)));
	var endday = parseInt(endtime.substring((endtime.indexOf("/")+1),endtime.lastIndexOf("/")));
	var endmon = parseInt(endtime.substring(0,endtime.indexOf("/")));
	var state=0;	
	if(styear > endyear)			
		state=-1;		
	else if(styear == endyear)			
		if(stmon > endmon)				
			state=-1;				
		else if(stmon == endmon)
			if(stday > endday)						
				state=-1;
			else if(stday == endday)
				if(starthr > endhr)
					state = -1;
				else if(starthr == endhr)
					if(startmin >= tomin)
						state = -1;
	
	return state;
}