Ext.define("TrendGraphGenerator.view.TrendGraphForm", {
    extend: "Ext.form.Panel",
    alias: "widget.trendgraphForm",
	cls:'formOuter',
	bodyPadding:5,
    requires: ["Ext.ux.form.MultiSelect"],
    initComponent: function () {     
        this.buttonAlign = "center";
        this.callParent();
    },
    collapseMode: "mini",	
    layout: "column",
	 defaults: {
            labelAlign: "top",         
            labelSeparator: ""
        },
    items: [{
            xtype: "scrollcombo",
            cls: "dropdown",
            width: 230,
			margin:'0 10 10 10',
            editable: false,
            id: "sitelist",
            name: "sitelist",
            fieldLabel: serviceLbl,
            store: new Ext.data.Store({
                fields: ["displayField", "valueField"],
                data: []
            }),
            displayField: "displayField",
            valueField: "valueField",
            queryMode: "local"
        }, {
            fieldLabel: filterBylbl+" (Optional)",
            xtype: "triggerfield",
            id: "filterOpt",
            name: "filterOpt",
			hidden:true,
            enableKeyEvents: true,
            labelAlign: "top",
            cls: "whitedropdown_search",
            width: 150,			
			margin:'0 10 10 10',
        },{
			xtype:'scrollcombo',
			width:230,
			margin:'0 10 10 10',
			cls: 'dropdown',
			fieldLabel:componentTypeLbl,
			id:'complist',
			name:'complist',
			editable : true,
			store: new Ext.data.Store({
				fields : ['displayField', 'valueField'],
				data : []
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local'
			//hidden: true
		},{
            xtype: "scrollcombo",
             width: 230,
			margin:'0 10 10 10',
            cls: "dropdown",
            id: "hostlist",
            name: "hostlist",
            fieldLabel: componentLbl,
            editable: true,
            store: new Ext.data.Store({
                fields: ["displayField", "valueField"],
                data: []
            }),
            displayField: "displayField",
            valueField: "valueField",
            queryMode: "local"
        }, {
            xtype: "scrollcombo",
             width: 230,
			margin:'0 10 10 10',
            cls: "dropdown",
            editable: true,
            id: "layerlist",
            name: "layerlist",
            fieldLabel: layerLbl,
            store: new Ext.data.Store({
                fields: ["displayField", "valueField"],
                data: []
            }),
            displayField: "displayField",
            valueField: "valueField",
            queryMode: "local"
        }, {
            xtype: "scrollcombo",
             width: 230,
			margin:'0 10 10 10',
            cls: "dropdown",
            id: "testlist",
            name: "testlist",
            fieldLabel: testLbl,
            editable: true,
            typeAhead: true,
            listConfig: {
                emptyText: '<li style="padding:0 10px 0 8px">No record found</li>'
            },
            store: new Ext.data.Store({
                fields: ["displayField", "valueField"],
                data: []
            }),
            displayField: "displayField",
            valueField: "valueField",
            queryMode: "local"
        }, 
		{
			fieldLabel: 'Search',
			xtype: 'triggerfield',
			id:'descriptionOpt',
			name:'descriptionOpt',
			hidden:true,
			enableKeyEvents : true,
			labelAlign: 'top',
			cls: 'whitedropdown_search',
			width: 150,
			margin:10
		},
		{
			xtype:'scrollcombo',
			width: 230,
			margin:'0 10 10 10',
			cls: 'dropdown',
			fieldLabel:'Descriptor',
			id:'descriptionlist',
			name:'descriptionlist',
			hidden:true,
			editable : true,
			typeAhead:true,
			listConfig:{
				emptyText:'<li style="padding:0 10px 0 8px">No record found</li>'
			},
			store: new Ext.data.Store({
				fields : [{name:'displayField',convert:function(value, record){
								return Ext.String.htmlDecode(value);
							}},'valueField'],
				data : []
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local'
		},
		{
            xtype: "scrollcombo",
            width: 230,
			margin:'0 10 10 10',
            cls: "dropdown",
            id: "msmt_host",
            name: "msmt_host",
            fieldLabel: MsmtHostLbl,
            editable: false,
            typeAhead: true,
            listConfig: {
                emptyText: '<li style="padding:0 10px 0 8px">No record found</li>'
            },
            store: new Ext.data.Store({
                fields: ["displayField", "valueField"],
                data: []
            }),
            displayField: "displayField",
            valueField: "valueField",
            queryMode: "local"
        }, {
            xtype: "scrollcombo",
             width: 230,
			margin:'0 10 10 10',
            cls: "dropdown",
            id: "measurelist",
            name: "measurelist",
            fieldLabel: measuresLbl,
            editable: true,
            typeAhead: true,
            listConfig: {
                emptyText: '<li style="padding:0 10px 0 8px">No record found</li>'
            },
            store: new Ext.data.Store({
                fields: ["displayField", "valueField"],
                data: []
            }),
            displayField: "displayField",
            valueField: "valueField",
            queryMode: "local"
        },
		{
		xtype:'button',
        text: graphBtn,
        cls: "button20",
        id: "submit",
        name: "submit",
        margin:'20px 0px 0px 10px',		
    }
		]
 
});