// Code to load combo box in form.loadRecord()
// This method is the overridden version of default setValue() method of 'combo'

Ext.form.field.ComboBox.override({
    setValue:function(value){
		var combo = this;
        if (value instanceof Array || value instanceof Object){
			delete this.store;
			this.store = Ext.create('Ext.data.Store',{
				fields:['display','value']
			});
			this.getStore().on('load',function(store){
				combo.suspendEvents();
				combo.setValue(store.getAt(0).get('value'));
				combo.resumeEvents();
			});
			this.getStore().loadRawData(value);
		}
		else {
			this.callOverridden(arguments);
		}
	}
});
var lineRefresh = '';
var barRefresh = '';
function ajax(url){
	Ext.Ajax.request({
		url:url,
		success:function(response){
			return response;
		},
		failure:function(){
			return false;
		}
	});
}

function showFullview(index,event,graphId)
{
	var graphTypeVal="";
	if(graphId==1)
		graphTypeVal="analysisBargraph";

	VLiveGraph.app.getController('VirtualMain').showFullview(index,graphTypeVal);
}

function loadMaximizedView(url)
{
	VLiveGraph.app.getController('VirtualMain').enlargeTheGraph(url);
}
function execute(refUrl,refWidth,refHeight,panelId){
	VLiveGraph.app.getController('VirtualMain').refresh(refUrl,refWidth,refHeight,panelId);
}
function executeBarRefresh(){
	VLiveGraph.app.getController('VirtualMain').refreshBar();
}
Ext.Loader.setConfig({
	enabled: true,
	disableCaching: false
});

Ext.Loader.setPath('Ext.ux','/final/scripts/ux');
Ext.Loader.setPath('utilities', '/final/scripts/utilities');

Ext.application({
	name:'VLiveGraph',
	appFolder:'/final/monitor/eg_scripts/VLiveGraph/app',
	controllers:['VirtualMain'],
	requires:['Ext.data.NodeStore','Ext.tree.Panel'],

	launch:function(){
		VLiveGraph.app = this;
		Ext.create('Ext.container.Viewport',{
			layout: 'fit',
			items:[{
				xtype:'main'
			}]
		});
	}
});