Ext.define('VLiveGraph.controller.VirtualMain',{
	extend:'Ext.app.Controller',
	commonUrl:null,
	gType:null,
	views:['Main','GraphContainer','VirtualLGHeader','FullViewGraph'],
	requires: ['utilities.ZoomGraphPanel','VLiveGraph.view.FullViewGraph'],
	refs:[{
		selector:'main',
		ref:'main'
	},{
		selectior:'virtuallgheader',
		ref:'virtuallgheader'
	}
	,{
		selectior:'graphcontainer',
		ref:'graphcontainer'
	},{
		selectior:'fullviewgraph',
		ref:'fullviewgraph'
	},
	{ref : 'zoomGraphComboMode',selector : 'zoomgraphpanel  combo[itemId= "mode"]'},
	{ref : 'zoomGraphComboTimeline',selector : 'zoomgraphpanel  combo[itemId= "timeline"]'},
	{ref : 'zoomGraphComboFromhr',selector : 'zoomgraphpanel combo[itemId= "fromhr"]'},
	{ref : 'zoomGraphComboTohr',selector : 'zoomgraphpanel combo[itemId= "tohr"]'},
	{ref : 'zoomGraphFromDate',selector : 'zoomgraphpanel datefield[itemId= "from"]'},
	{ref : 'zoomGraphToDate',selector : 'zoomgraphpanel datefield[itemId= "to"]'},
	{ref : 'zoomGraphComboShow',selector : 'zoomgraphpanel combo[itemId= "priority"]'},
	{ref:'zoomGraphPanel',selector:'zoomgraphpanel'},
	{ref:'comptype',selector:'graphcontainer combo[id="comptype"]'},
	{ref:'compName',selector:'graphcontainer combo[id="compName"]'},
	{ref:'graphMode',selector:'graphcontainer combo[id="graphMode"]'},
	{ref:'graphType',selector:'graphcontainer combo[id="graphType"]'},
	],
	init:function(){
		this.control({
			'main':{
				'afterrender':this.afterMainRender
			},
			'graphcontainer combo[id="comptype"]':
			{
				select: this.changeForResultType
			},
			'graphcontainer combo[id="compName"]':
			{
				select: this.changeForResult
			},
			'graphcontainer combo[id="graphMode"]':
			{
				select: this.changeForResult
			},
			'graphcontainer combo[id="graphType"]':
			{
				select: this.changeForResult
			},
			'zoomgraphpanel combo[itemId= "mode"]':{
				select:this.displayZoomGraph
			},
			'zoomgraphpanel combo[itemId= "timeline"]':{
				select:this.timelineChangeHandler
			},
			'zoomgraphpanel combo[itemId= "priority"]':{
				select:this.displayZoomGraph
			},
			'zoomgraphpanel button[itemId="timelineAny"]':{
				render: function(component){
					var me=this;
					component.getEl().on('click', function(e){
						me.displayZoomGraph();
					});
				}
			},
			'zoomgraphpanel tool[itemId=minimizePanelDiv]':{
				click:this.bigGraphOnClick
			},
			'zoomgraphpanel button[id="ddIcon"]':
			{
				'click': this.displayBigDDData
			}
		});
	},
	changeForResultType: function(combo,records)
	{
		var zoomGraphPanel =this.getZoomGraphPanel();
		if(!Ext.isEmpty(zoomGraphPanel)){
			this.bigGraphOnClick();
		}

		var me = this;

		var ctObj=Ext.getCmp("comptype");
		var cnObj=Ext.getCmp("compName");
		var gmObj=Ext.getCmp("graphMode");
		var gtObj=Ext.getCmp("graphType");
		var url=defaultVLUrl;
		if ( !Ext.isEmpty( ctObj ))
		{
			var selected_ct=ctObj.getValue();
			if ( Ext.isEmpty( selected_ct ) )
			{
				selected_ct=records[0].get('valueField');
			}

			var selected_cn="-1";

			var selected_gm=gmObj.getValue();
			if ( Ext.isEmpty( selected_gm ) )
			{
				selected_gm=records[0].get('valueField');
			}

			if ( Ext.isEmpty( selected_gm ) )
			{
				selected_gm="3D";
			}

			var selected_gt=gtObj.getValue();
			if ( Ext.isEmpty( selected_gt ) )
			{
				selected_gt=records[0].get('valueField');
			}
			
			url="/final/monitor/livegraph/EgVmwareLiveGraphDisplay.jsp?comptype="+encodeURI(selected_ct)+"&er_component="+encodeURI(selected_cn)+"&mode="+encodeURI(selected_gm)+"&er_view="+selected_gt;
		}
		if ( !Ext.isEmpty( isVirtualLV ) && isVirtualLV==true && !Ext.isEmpty( url ))
		{
			Ext.Ajax.request({
				url: url,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var jsonData = null;
						if ( !Ext.isEmpty( jsonText ) )
						{
							jsonData = Ext.decode( jsonText );
							if(jsonData.jsonData != undefined && jsonData.jsonData.ComponentNameData != undefined && jsonData.jsonData.ComponentNameData.length > 1)
								sel_CompName=jsonData.jsonData.ComponentNameData[1].valueField;
							else
								me.openVLGraphView(jsonData);
							temp_url="/final/monitor/livegraph/EgVmwareLiveGraphDisplay.jsp?comptype="+encodeURI(selected_ct)+"&er_component="+encodeURI(sel_CompName)+"&mode="+encodeURI(selected_gm)+"&er_view="+selected_gt;
							Ext.Ajax.request({
							url: temp_url,
							method: 'POST',
								success: function( response )
								{
									var temp_jsonText = response.responseText;
									var temp_jsonData = null;
									if ( !Ext.isEmpty( temp_jsonText ) )
									{
											temp_jsonData = Ext.decode( temp_jsonText );
											me.openVLGraphView(temp_jsonData);
									}
									else
									{
											me.openVLGraphView(temp_jsonData);
									}		
								}
							});
						//me.openVLGraphView(jsonData);
						}
						else
						{
							me.openVLGraphView(jsonData);
						}
					}
				},
				failure:function(){
					alert('Failure');
				}
			});
		}
	},
	changeForResult: function(combo,records)
	{
		var zoomGraphPanel =this.getZoomGraphPanel();
		if(!Ext.isEmpty(zoomGraphPanel)){
			this.bigGraphOnClick();
		}

		var me = this;
		var ctObj=Ext.getCmp("comptype");
		var cnObj=Ext.getCmp("compName");
		var gmObj=Ext.getCmp("graphMode");
		var gtObj=Ext.getCmp("graphType");
		var url=defaultVLUrl;
		if ( !Ext.isEmpty( ctObj ) && !Ext.isEmpty( cnObj ))
		{
			var selected_ct=ctObj.getValue();
			if ( Ext.isEmpty( selected_ct ) )
			{
				selected_ct=records[0].get('valueField');
			}

			var selected_cn=cnObj.getValue();
			if ( Ext.isEmpty( selected_cn ) )
			{
				selected_cn=records[0].get('valueField');
			}

			var selected_gm=gmObj.getValue();
			if ( Ext.isEmpty( selected_gm ) )
			{
				selected_gm=records[0].get('valueField');
			}

			if ( Ext.isEmpty( selected_gm ) )
			{
				selected_gm="3D";
			}

			var selected_gt=gtObj.getValue();
			if ( Ext.isEmpty( selected_gt ) )
			{
				selected_gt=records[0].get('valueField');
			}
			
			url="/final/monitor/livegraph/EgVmwareLiveGraphDisplay.jsp?comptype="+encodeURI(selected_ct)+"&er_component="+encodeURI(selected_cn)+"&mode="+encodeURI(selected_gm)+"&er_view="+selected_gt;
		}
		if ( !Ext.isEmpty( isVirtualLV ) && isVirtualLV==true && !Ext.isEmpty( url ))
		{
			Ext.Ajax.request({
				url: url,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var jsonData = null;
						if ( !Ext.isEmpty( jsonText ) )
						{
							jsonData = Ext.decode( jsonText );
							me.openVLGraphView(jsonData);
						}
						else
						{
							me.openVLGraphView(jsonData);
						}
					}
					else
					{
						window.opener.location.href='/final/servlet/com.egurkha.Logout?errmsg=1';
						self.close();
					}
				}
			});
		}
	},
	afterMainRender: function()
	{
		var me = this;
		if ( !Ext.isEmpty( isVirtualLV ) && isVirtualLV==true && !Ext.isEmpty( defaultVLUrl ))
		{
			Ext.Ajax.request({
				url: defaultVLUrl,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var jsonData = null;
						if ( !Ext.isEmpty( jsonText ) )
						{
							jsonData = Ext.decode( jsonText );
							me.openVLGraphView(jsonData);
						}
						else
						{
							me.openVLGraphView(jsonData);
						}
					}
				}
			});
		}
	},
	openVLGraphView:function(jsonResultData){
		var showLegends = jsonResultData.LegendInChart;
		showLegends = showLegends.toLowerCase();
		var isChecked = (showLegends == 'false' || showLegends == 'no' )?0:1;
		var isHiddenCheckBox = jsonResultData.showLegendChk;
		if ( Ext.isEmpty( jsonResultData ) || (!Ext.isEmpty( jsonResultData.noData )) )
		{
			var disp_txt= ndf;
			if(!Ext.isEmpty( jsonResultData.noData ))
				disp_txt = jsonResultData.noData;

			var temp='<div style="margin:auto;text-align:center;border:0px solid red"><div class="iconInformation" style="margin:auto;text-align:center"></div><div style="text-align:center" >'+disp_txt+'</div></div>';

			var newPanel =  ({
				xtype:'container',
				layout: 'fit',
				items: [{
				 html: temp
				}]
			 });

			this.getMain().add(newPanel);
		}
		else if ( !Ext.isEmpty( jsonResultData.view ) )
		{
			var vghObj=Ext.getCmp('vgh');
			if ( !Ext.isEmpty( vghObj ) )
			{
				vghObj.remove('comptype');
				vghObj.remove('compName');
				if ( !Ext.isEmpty( jsonResultData.jsonData.Mode ) )
				{
					vghObj.remove('graphMode');
				}
				vghObj.remove('graphType');
				vghObj.remove('showLegend');
			}

			var tempCombo=new Ext.form.field.ComboBox({
				xtype: 'scrollcombo',
				fieldLabel:jsonResultData.jsonData.ComponentType,
				id:'comptype',
				editable: false,
				name:'comptype',
				cls:'dropdown',
				labelAlign:'left',
				labelSeparator:'',
				labelWidth:100,
				width:270,
				displayField : 'displayField',
				valueField : 'valueField',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : jsonResultData.jsonData.ComponentTypeData
				}),
				queryMode : 'local',
				value:jsonResultData.jsonData.selectedCompType
			});
			vghObj.add(tempCombo);

			var tempCombo=new Ext.form.field.ComboBox({
				xtype: 'scrollcombo',
				fieldLabel:jsonResultData.jsonData.ComponentName,
				id:'compName',
				editable: false,
				name:'compName',
				labelSeparator:'',
				cls:'dropdown',
				labelWidth:100,
				width:300,
				labelAlign:'left',
				/*store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : jsonResultData.jsonData.ComponentNameData
				}),*/
				store:Ext.create('Ext.data.Store',{
				fields:['state',{name:'displayField',convert:function(value, record){
						return decodeURI(value);
					}},'valueField'],
				data : jsonResultData.jsonData.ComponentNameData
				}),
				displayField : 'displayField',
				valueField : 'valueField',
				queryMode : 'local',
				value:jsonResultData.jsonData.selectedCompName,
				margin:'2 15 0 10',
				tpl: Ext.create('Ext.XTemplate',
					//'<ul style="display:inline-block;white-space:nowrap">',
					'<ul style="white-space:nowrap">',
					'<tpl for=".">',
						'<li class="x-boundlist-item"><img src="/final/images/spacer.gif" style="padding-left:18px;vertical-align:middle" class="state_{state}"/>{displayField}</li>',
					'</tpl>',
					'</ul>'
				)
			});

			$('#compName-inputEl').removeClass('state_'+jsonResultData.jsonData.selectedCompState);
			vghObj.add(tempCombo);
			$('#compName-inputEl').addClass('state_'+jsonResultData.jsonData.selectedCompState);
			
			if ( !Ext.isEmpty( jsonResultData.jsonData.Mode ) )
			{
				var tempCombo=new Ext.form.field.ComboBox({
					xtype: 'scrollcombo',
					fieldLabel:jsonResultData.jsonData.Mode,
					id:'graphMode',
					name:'graphMode',
					editable: false,
					labelWidth:45,
					labelSeparator:'',
					cls:'dropdown',
					labelAlign:'left',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : '2D'
					}),
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local',
					hidden: true,
					value:'2D'
				});
				vghObj.add(tempCombo);
			}

			var tempCombo=new Ext.form.field.ComboBox({
				xtype: 'scrollcombo',
				fieldLabel:jsonResultData.jsonData.GraphType,
				id:'graphType',
				name:'graphType',
				editable: false,
				cls:'dropdown',
				margin:'0 0 0 0',
				labelSeparator:'',
				labelWidth:45,
				labelAlign:'left',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : jsonResultData.jsonData.GraphTypeData
				}),
				displayField : 'displayField',
				valueField : 'valueField',
				queryMode : 'local',
				value:jsonResultData.jsonData.selectedGraphType
			});
			vghObj.add(tempCombo);

			var legendChkBox = new Ext.form.field.Checkbox({				
					xtype:'checkboxgroup',
					//cls: 'checkbt',
					//	columnWidth: 0.33,
					id: 'er_chart_checkbox',	
					//fieldLabel: 'Show Legends',
					margin:'2 0 0 30',
					//items: [{
						boxLabel: 'Show Legends',
						inputValue: 'true',
						itemId: 'showLegend',
						cls: 'showLegend checkbt',
						checked:isChecked,
						hidden:isHiddenCheckBox
						// }]				
			});
			vghObj.add(legendChkBox);
			//code added
			var selectedGraphType = jsonResultData.jsonData.selectedGraphType;
			var graphModeObj=Ext.getCmp("graphMode");
			var showLegendObj=Ext.getCmp('showLegend');
			if(selectedGraphType =='TopN/LastN')
				graphModeObj.hide();
			else
				graphModeObj.hide();
			//code ended

			/*var ctObj=Ext.getCmp('comptype');
			ctObj.setFieldLabel(jsonResultData.jsonData.ComponentType);
			var combArr = jsonResultData.jsonData.ComponentTypeData;
			ctObj.getStore().loadRawData(combArr);
			ctObj.setValue(jsonResultData.jsonData.selectedCompType);

			var cmObj=Ext.getCmp('compName');
			cmObj.setFieldLabel(jsonResultData.jsonData.ComponentName);
			var combcArr = jsonResultData.jsonData.ComponentNameData;
			cmObj.getStore().loadRawData(combcArr);
			cmObj.setValue(jsonResultData.jsonData.selectedCompName);

			var gmObj=Ext.getCmp('graphMode');
			if ( !Ext.isEmpty( jsonResultData.jsonData.Mode ) )
			{
				gmObj.setFieldLabel(jsonResultData.jsonData.Mode);
				var combmArr = jsonResultData.jsonData.ModeData;
				gmObj.getStore().loadRawData(combmArr);
				gmObj.setValue(jsonResultData.jsonData.selectedMode);
			}

			var gtObj=Ext.getCmp('graphType');
			gtObj.setFieldLabel(jsonResultData.jsonData.GraphType);
			var combgArr = jsonResultData.jsonData.GraphTypeData;
			gtObj.getStore().loadRawData(combgArr);
			gtObj.setValue(jsonResultData.jsonData.selectedGraphType);*/
			if ( !Ext.isEmpty( jsonResultData.view ) && jsonResultData.view =='TopN/LastN')
			{
				var gcObj=Ext.getCmp('graphContainer');
				var mHObj=Ext.getCmp('mHeaderId');
				if ( !Ext.isEmpty( gcObj ))
				{
					gcObj.removeAll();
				}

				if ( !Ext.isEmpty( mHObj ))
				{
					mHObj.removeAll();
					mHObj.hide();
				}
				
				var itemsArray=jsonResultData.jsonData.TopNData;
				if(!Ext.isEmpty(itemsArray))
				{
					barRefresh = setInterval("executeBarRefresh()",refreshRate);
					clearInterval(lineRefresh);

					for(var item=0; item< itemsArray.length ; item++)
					{
						var itemJson=itemsArray[item];
						temp='<div style="float:left;width:100%;height:100%">';
						if ( !Ext.isEmpty( itemJson.errData ))
						{
							temp=temp+'<div style="margin:12% 0 1% 6%;;text-align:center;border:0px solid red"><div class="iconInformation" style="margin:auto;text-align:center"></div><div style="text-align:center" >'+itemJson.errData+'</div></div>';
						}
						else if (!Ext.isEmpty( itemJson.measureTitle ))
						{
							if ( !Ext.isEmpty( itemJson.measureErrData ))
							{
								temp=temp+'<div style="padding:5px;border:0px solid red"><b>'+itemJson.measureTitle+'</b></div><div style="text-align:center;border:0px solid red;padding:12% 0 1% 6%;width:100%"><center><div class="iconInformation" style="text-align:center;"></div><div style="text-align:center" >'+itemJson.measureErrData+'</div></center></div>';
							}
							else if ( !Ext.isEmpty( itemJson.chartCId ))
							{
								temp=temp+'<div style="border:0px solid red;width:100%;margin:auto;padding:3;display:inline-block;"><div style="text-align:center;"><b>'+itemJson.measureTitle+'</b></div><div id="'+itemJson.divId+'" style="height:100%;"></div></div>';
							}
						}
						temp=temp+"</div>";
						var cUrl="";
						var errHtml = '<center><div style="margin:12% 0 auto 0"><img class="iconInformation" src="/final/images/spacer.gif"/><div >No measures available</div></div></center>';

						if (!Ext.isEmpty( itemJson.fullViewURL ))
						{
							cUrl=itemJson.fullViewURL;
						}
						
						if(isFusionChartValue)
						{
							var newPanel = new Ext.Panel ({
								id:itemJson.chartCId,
								layout: 'fit',
								cls:'block1',
								border:true,
								frame:true,
								margin:5,
								padding:'5 0 0 0',
								height:200,
								clickUrl:cUrl,
								html: temp
							 });

							gcObj.add(newPanel);

							if (!Ext.isEmpty( itemJson.chartCId ))
							{
								var cid=itemJson.fcId;
								var iid=itemJson.divId;

								if  ( FusionCharts(cid ) )
										FusionCharts( cid ).dispose();
								var myChart = new FusionCharts(itemJson.movie,cid, "100%", "160","0","1");
								myChart.setXMLData(itemJson.dataXML);
								myChart.setTransparent(true);
								myChart.render(iid);
							}
						}
						else
						{
							var skinColor = (strSkin == 'Light')?"#ffffff":'#404040';
							var newPanel = new Ext.Panel ({
								id:itemJson.chartCId,
								layout: 'fit',
								cls:'containerOnlyShadow ',
								border:true,
								frame:true,
								margin:5,
								padding:'5 0 0 0',
								height:275,
								autoScroll:true,
								style:{'background':skinColor+' !important'},
								title:itemJson['title'],
								clickUrl:cUrl,
								html: temp,
								chartData:itemJson,
								measTitle:itemJson.measureTitle,
								listeners:{
									'afterrender': function(curInst){
										try
										{

											var panelWidth = ( $( window ).width() / 2 ) - 100;
											try
											{
												var panelHeight = Ext.getCmp(itemJson.chartCId).getHeight();
											}
											catch (ert)
											{
												var panelHeight = 275;
											}
											


											curInst.chartData['fromPage']='vlive';
											curInst.chartData['measureTitle']=curInst.measTitle;
											curInst.chartData['tick']=false;
											curInst.chartData['isStateBar']=false;
											curInst.chartData['title']="";

											//var barChart = {};
											//barChart = jQuery.extend(true, {}, createBar(curInst.id,curInst.chartData.chartHeight,panelWidth), barChart);
											//barChart.setData(curInst.chartData,'','','bar',curInst.chartData.fullViewURL);
											//barChart.drawChart();
											
											//getHighChartForBar(curInst.id,curInst.chartData,panelWidth,curInst.chartData.chartHeight,curInst.chartData.fullViewURL);
											if(!Ext.isEmpty(curInst.chartData.measureErrData)){
												var temp='<center style="background:'+skinColor+' !important"><div style="margin:auto;padding:12 3 3 10;display:inline-block;"><div class="f12-bold" style="text-align:center;"><b>'+curInst.chartData.measureTitle+'</b></div></div></center>';
												//temp=temp+'<center><div style="margin:25% 0 auto 0;text-align:center;border:0px solid red"><div class="iconInformation" style="margin:auto;text-align:center"></div><div style="text-align:center" >'+curInst.chartData.measureErrData+'</div></div></center>';
												temp=temp+'<center style="background:'+skinColor+' !important"><div style="display:table;height:88%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>'+curInst.chartData.measureErrData+'</div></div></div></center>';
												curInst.update(temp);
											}
											else
											{
													try
													{
														getHighChartForBar(curInst.id,curInst.chartData,panelWidth,panelHeight,curInst.chartData.fullViewURL);		
													}
													catch (e1)
													{
														console.log("=-=-=-=+++>:",e1)
													}
												
											}
										}
										catch (err )
										{
											Ext.getCmp(itemJson.chartCId).update(errHtml);
										}
								
									}
								}

						 });
							//gcObj.remove(newPanel);
							gcObj.add(newPanel);
							
						}

						if (!Ext.isEmpty( itemJson.chartCId ))
						{
							var cid=itemJson.fcId;
							var iid=itemJson.divId;

							/*if  ( FusionCharts(cid ) )
									FusionCharts( cid ).dispose();
							var myChart = new FusionCharts(itemJson.movie,cid, "100%", "160","0","1");
							myChart.setXMLData(itemJson.dataXML);
							myChart.setTransparent(true);
							myChart.render(iid);*/

							
						}
					}
				}
				/*else
				{
					alert('empty');
					temp='<div class="centerDiv">';
					temp=temp+'<div style="margin:auto;text-align:center;border:0px solid red"><div class="iconInformation" style="margin:auto;text-align:center"></div><div style="text-align:center" >No Measures Available</div></div>';
					temp=temp+"</div>";
					gcObj.update(temp);
				}*/
			}
			else if ( !Ext.isEmpty( jsonResultData.view ) && jsonResultData.view =='Live Data')
			{
				var gcObj=Ext.getCmp('graphContainer');			
				var gcEObj=Ext.getCmp('graphContainerErr');			
				var mHObj=Ext.getCmp('mHeaderId');
				if ( !Ext.isEmpty( gcObj ))
				{
					//gcObj.removeAll();
					gcObj.removeAll();
				}

				if ( !Ext.isEmpty( mHObj ))
				{
					mHObj.show();
					mHObj.removeAll();
				}

				var itemsArray=jsonResultData.jsonData.LiveData;
				if(!Ext.isEmpty(itemsArray))
				{
					var itemJson=itemsArray[0];
					if ( !Ext.isEmpty( itemJson.errData ))
					{

						
						gcObj.hide();

						temp='<div style="float:left;">';
						if (!Ext.isEmpty( itemJson.lgHeader ))
						{
							temp=temp+'<div style="margin:auto;padding:3 3 3 10;display:inline-block;"><div style="text-align:center;"><b>'+itemJson.lgHeader+'</b></div></div>';
						}
						temp=temp+"</div>";

						temp='<div style="float:left;width:100%;height:100%;">';
						temp=temp+'<div style="margin:20% 0 auto 0;text-align:center;border:0px solid red"><div class="iconInformation" style="margin:auto;text-align:center"></div><div style="text-align:center" >'+itemJson.errData+'</div></div>';
						temp=temp+"</div>";
						
						var newPanel =({
							xtype:'container',
							style:{'border':'0px solid green'},
							layout: 'fit',
							cls:'block1',
							height:'100%',
							html: temp
						 });

						//gcObj.add(newPanel);
						gcEObj.show();
						gcEObj.add(newPanel);

					}
					else if (!Ext.isEmpty( itemJson.lgHeader ))
					{
						
						gcEObj.hide();
						gcObj.show();
						temp='<div style="float:left;">';
						if (!Ext.isEmpty( itemJson.lgHeader ))
						{
							//temp=temp+'<div style="margin:auto;padding:3 3 3 10;display:inline-block;"><div style="text-align:center;"><b>'+itemJson.lgHeader+'</b></div></div>';
							
						}
						temp=temp+"</div>";
						
						var newMiddlePanel =({
							xtype:'container',
							layout: 'fit',
							height:200,
							html: temp
						 });

						if ( !Ext.isEmpty( mHObj ))
						{
							mHObj.add(newMiddlePanel);
						}

						for(var item=1; item< itemsArray.length ; item++)
						{
							itemJson=itemsArray[item];
							if (!Ext.isEmpty( itemJson.gDataUrl ))
							{
								
								temp='<div style="float:left;">';
								temp=temp+"</div>";
								var skinColor = (strSkin == 'Light')?"#ffffff":'#404040';
								var newPanel = new Ext.Panel ({
									id:itemJson.chId,
									chartUrl:itemJson.gDataUrl,
									layout: 'fit',
									cls:'containerOnlyShadow ',
									border:true,
									frame:true,
									margin:5,
									style:{'background':skinColor+' !important'},
									height:355,
									html: temp,
									listeners:{
										'afterrender': function(thisObj)
										{
											var panelRefWidth = ( $('#'+itemJson.chId ).width() ) - 50;
											var panelRefHeight = ( $('#'+itemJson.chId ).height() );

											lineRefresh = setInterval("execute('"+thisObj.chartUrl+"','"+panelRefWidth+"','"+panelRefHeight+"','"+thisObj.id+"')",refreshRate);
											clearInterval(barRefresh);
											Ext.Ajax.request({
												url: thisObj.chartUrl,
												method: 'POST',
												async:true,
												success: function( response )
												{
													if ( response.status == 200 )
													{
														var jsonText = response.responseText;
														var jsonData = null;
														if ( !Ext.isEmpty( jsonText ) )
														{
															jsonData = Ext.decode( jsonText );
															if ( !Ext.isEmpty( jsonData.DataSet ) )
															{
																jsonData['enableTitle'] = true;
																jsonData['useHtml'] = true;
																var panelWidth = ( $('#'+thisObj.id ).width() ) - 50;
																var panelHeight = ( $('#'+thisObj.id ).height() );
																if(!Ext.isEmpty( jsonData['title']))
																{
																	//thisObj.setTitle(jsonData['title']);
																}
																//var lineChart = {};
																//lineChart = jQuery.extend(true, {}, getHighCharts(thisObj.id,panelHeight,panelWidth,thisObj.chartUrl), lineChart);
																//lineChart.setData(jsonData,mgr_disp_dateFormat,thisObj.chartUrl,'','right');
																//lineChart.drawChart();
																//console.log("jsonData--->",jsonData);

																getHighChartForTimeLine(thisObj.id,jsonData,panelWidth,panelHeight,thisObj.chartUrl);
															}
															else
															{
																
																temp='<center style="background:'+skinColor+' !important"><div style="margin:auto;padding:12 3 3 10;display:inline-block;"><div class="f12-bold" style="text-align:center;"><b>'+jsonData.title+'</b></div></div></center>';
																
																//temp=temp+'<center><div style="margin:25% 0 auto 0;text-align:center;border:0px solid red"><div class="iconInformation" style="margin:auto;text-align:center"></div><div style="text-align:center" >'+ndf+'</div></div></center>';
																temp=temp+'<center style="background:'+skinColor+' !important"><div style="display:table;height:88%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>'+ndf+'</div></div></div></center>';

																thisObj.update(temp);
															}
														}
														else
														{
															
															temp='<center><div style="margin:auto;padding:12 3 3 10;display:inline-block;"><div class="f12-bold" style="text-align:center;"><b>'+jsonData.title+'</b></div></div></center>';
															//temp=temp+'<center><div style="margin:25% 0 auto 0;text-align:center;border:0px solid red"><div class="iconInformation" style="margin:auto;text-align:center"></div><div style="text-align:center" >'+ndf+'</div></div></center>';
															temp=temp+'<center><div style="display:table;height:88%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>'+ndf+'</div></div></div></center>';
															thisObj.update(temp);
														}
													}
													else
													{
														
														temp='<center><div style="margin:auto;padding:12 3 3 10;display:inline-block;"><div class="f12-bold" style="text-align:center;"><b>'+jsonData.title+'</b></div></div></center>';
														//temp=temp+'<center><div style="margin:25% 0 auto 0;text-align:center;border:0px solid red"><div class="iconInformation" style="margin:auto;text-align:center"></div><div style="text-align:center" >'+ndf+'</div></div></center>';
														temp=temp+'<center><div style="display:table;height:88%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>'+ndf+'</div></div></div></center>';
														thisObj.update(temp);
													}
												}
											});
											
										}
									}
								 });
								gcObj.remove(newPanel);
								gcObj.add(newPanel);

							}
						}
					}
				}
			}
		}
	},
	zoomLoaded:function(){
		var imgPanel=this.getZoomGraphImgPanel();
		if(!Ext.isEmpty(imgPanel)){
			imgPanel.handleScrollBars(imgPanel);
		}
	},
	zoomClose:function(){
		this.bigGraphOnClick();
	},
	bigGraphOnClick : function(){
		var zoomGraphPanel =this.getZoomGraphPanel();
		if(!Ext.isEmpty(zoomGraphPanel)){
			zoomGraphPanel.destroy();
		}
		var gcObj=Ext.getCmp('graphContainer');
		gcObj.show();
		var fvObj=Ext.getCmp('fvId');
		fvObj.removeAll();
		fvObj.hide();
	},
	timelineChangeHandler:function(combo){
		var timelineValue=combo.getValue();
		if(timelineValue=="Any"){
			this.enableDisableDateFields(true);
		}else{
			this.enableDisableDateFields(false);
		}

		var format=currentDateFormat_js;
		var starttime="";
		var startTimeField=this.getZoomGraphFromDate();
		if(!Ext.isEmpty(startTimeField) && !Ext.isEmpty(startTimeField.getValue())){
				starttime=Ext.Date.format(startTimeField.getValue(),mgr_dateFormat);
		}
		var endtime="";
		var endTimeField=this.getZoomGraphToDate();
		if(!Ext.isEmpty(endTimeField) && !Ext.isEmpty(endTimeField.getValue())){
			endtime=Ext.Date.format(endTimeField.getValue(),mgr_dateFormat);
		}
		var startHr="";
		var fromCombo=this.getZoomGraphComboFromhr();
		if(!Ext.isEmpty(fromCombo) && !Ext.isEmpty(fromCombo.getValue())){
			startHr=fromCombo.getValue();
		}
		var endHr="";
		var toCombo=this.getZoomGraphComboTohr();
		if(!Ext.isEmpty(toCombo) && !Ext.isEmpty(toCombo.getValue())){
			endHr=toCombo.getValue();
		}
		var paramValues='F=getTimeJSON&P0=['+timelineValue+']&P1=['+starttime+']&P2=['+endtime+']&P3=['+startHr+']&P4=['+endHr+']&P5=['+format+']&C=1&calljson=true';
		Ext.Ajax.request({
			url: remoteURL,
			scope:this,
			method: 'POST',
			params: paramValues,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					var jsonDataOut = Ext.decode(jsonText);
					this.setTime(jsonDataOut.getTime);
				}
			}
		});
	},
	enableDisableDateFields:function(enable){
		var startTimeField=this.getZoomGraphFromDate();
		var endTimeField=this.getZoomGraphToDate();
		var fromCombo=this.getZoomGraphComboFromhr();
		var toCombo=this.getZoomGraphComboTohr();
		if(enable){
			startTimeField.setDisabled(false);
			endTimeField.setDisabled(false);
			fromCombo.setDisabled(false);
			toCombo.setDisabled(false);
		}else{
			startTimeField.setDisabled(true);
			endTimeField.setDisabled(true);
			fromCombo.setDisabled(true);
			toCombo.setDisabled(true);
		}
	},
	setTime:function(timeVal){
		var startTimeField=this.getZoomGraphFromDate();
		var endTimeField=this.getZoomGraphToDate();
		var fromCombo=this.getZoomGraphComboFromhr();
		var toCombo=this.getZoomGraphComboTohr();

		var arrOptions = timeVal.split('\t');
		time_line_obj=new Object();
		time_line_obj.starttime=arrOptions[0];
		startTimeField.setValue(arrOptions[0]);
		time_line_obj.endtime=arrOptions[1];
		endTimeField.setValue(arrOptions[1]);

		if(!Ext.isEmpty(arrOptions[2]) && arrOptions[2].length==1)
		{
			time_line_obj.starthr="0"+arrOptions[2];
			fromCombo.setValue("0"+arrOptions[2]);
		}
		else
		{
			time_line_obj.starthr=arrOptions[2];
			fromCombo.setValue(arrOptions[2]);
		}

		if(!Ext.isEmpty(arrOptions[2]) && arrOptions[3].length==1)
		{
			time_line_obj.endhr="0"+arrOptions[3];
			toCombo.setValue("0"+arrOptions[3]);
		}
		else
		{
			time_line_obj.endhr=arrOptions[3];
			toCombo.setValue(arrOptions[3]);
		}
		this.displayZoomGraph();
	},
	displayZoomGraph : function(){
		var zoomGraphPanel =this.getZoomGraphPanel();
		if(!Ext.isEmpty(zoomGraphPanel) && !Ext.isEmpty(zoomGraphPanel.jsonData)){
			var jsonData=zoomGraphPanel.jsonData;
			var mode="";
			var show="";
			var starttime="";
			var endtime="";
			var startHr=""
			var endHr="";
			var time_line="";
			var dateError = '';
			var modeCombo=this.getZoomGraphComboMode();
			if(!Ext.isEmpty(modeCombo) && !Ext.isEmpty(modeCombo.getValue())){
				mode=modeCombo.getValue();
			}
			var showCombo=this.getZoomGraphComboShow();
			if(!Ext.isEmpty(showCombo) && !Ext.isEmpty(showCombo.getValue())){
				show=showCombo.getValue();
			}
			var startTimeField=this.getZoomGraphFromDate();
			if(!Ext.isEmpty(startTimeField)){
				if(!Ext.isEmpty(startTimeField.getValue())){
					starttime=Ext.Date.format(startTimeField.getValue(),mgr_dateFormat);
				}else{
					if(!Ext.isEmpty(time_line_obj)){
						starttime=time_line_obj.starttime;
					}else{
						starttime=Ext.Date.format(startTimeField.getValue(),mgr_dateFormat);
					}
				}
			}
			var endTimeField=this.getZoomGraphToDate();
			if(!Ext.isEmpty(endTimeField)){
				if(!Ext.isEmpty(endTimeField.getValue())){
					endtime=Ext.Date.format(endTimeField.getValue(),mgr_dateFormat);
				}else{
					if(!Ext.isEmpty(time_line_obj)){
						endtime=time_line_obj.endtime;
					}else{
						endtime=Ext.Date.format(endTimeField.getValue(),mgr_dateFormat);
					}
				}
			}

			var fromCombo=this.getZoomGraphComboFromhr();
			if(!Ext.isEmpty(fromCombo)){
				if(!Ext.isEmpty(fromCombo.getValue())){
					startHr=fromCombo.getValue();
				}else{
					if(!Ext.isEmpty(time_line_obj)){
						startHr=time_line_obj.starthr;
					}else{
						startHr=fromCombo.getValue();
					}
				}
			}

			var toCombo = this.getZoomGraphComboTohr();
			if(!Ext.isEmpty(toCombo)){
				if(!Ext.isEmpty(toCombo.getValue())){
					endHr=toCombo.getValue();
				}else{
					if(!Ext.isEmpty(time_line_obj)){
						endHr=time_line_obj.endhr;
					}else{
						endHr=toCombo.getValue();
					}
				}
			}
			var dateError = startTimeField.getName();
			if(starttime > endtime){
				Ext.Msg.alert('Error', dateError);
				return;
			}
			if(starttime == endtime){
				if(startHr >= endHr){
					Ext.Msg.alert('Error', dateError);
						return;
				}
			}
			var timelineCombo=this.getZoomGraphComboTimeline();
			if(!Ext.isEmpty(timelineCombo) && !Ext.isEmpty(timelineCombo.getValue())){
				time_line=timelineCombo.getValue();
			}

			var graphUrl="";
			var graphType="";
			if(!Ext.isEmpty(this.commonUrl)){
				graphUrl=this.commonUrl;
				graphType=this.gType;
			}
			else if(!Ext.isEmpty(main_commonUrl)){
				graphUrl=main_commonUrl;
				graphType=main_gType;
			}
			var me=this;
			var imgPath=graphUrl.substring(0,graphUrl.indexOf("?"));
			var imgParam=graphUrl.substring(graphUrl.indexOf("?")+1,graphUrl.length);
			if(imgParam.indexOf("&priority=")<0)
			{
				imgParam=imgParam+"&priority="+show;
			}
			var queryParam = imgParam.split('&');

			var new_url='';
			for(var k=0;k<queryParam.length;k++)
			{
				var param_value=queryParam[k];
				if(!Ext.isEmpty(param_value)){
					var pvtoken=param_value.split("=");
					if(!Ext.isEmpty(pvtoken) && pvtoken[0]=='mode'){
						new_url=new_url+"&mode="+mode;
					}
					else if(!Ext.isEmpty(pvtoken) && pvtoken[0]=='starttime'){
						new_url=new_url+"&starttime="+starttime;
					}
					else if(!Ext.isEmpty(pvtoken) && pvtoken[0]=='endtime'){
						new_url=new_url+"&endtime="+endtime;
					}
					else if(!Ext.isEmpty(pvtoken) && pvtoken[0]=='starthr'){
						new_url=new_url+"&starthr="+startHr;
					}
					else if(!Ext.isEmpty(pvtoken) && pvtoken[0]=='endhr'){
						new_url=new_url+"&endhr="+endHr;
					}
					else if(!Ext.isEmpty(pvtoken) && (pvtoken[0]=='time_line' || pvtoken[0]=='timeLine')){
						new_url=new_url+"&time_line="+time_line;
					}
					else if(!Ext.isEmpty(pvtoken) && pvtoken[0]=='priority'){
						new_url=new_url+"&priority="+show;
					}
					else
					{
						new_url=new_url+"&"+param_value;
					}
				}
			}

			var pageUrl = timelineEncodedURL+"&graphType="+graphType+"&"+new_url+"&isZoomGraph=true&come_from=vmwareLiveGraph&graphId="+this.graphId;

			var scrWid=documentView.getWidth();
			var scrHei=documentView.getHeight();
			pageUrl=pageUrl+"&screenWidth="+scrWid+"&screenHeight="+scrHei;

			Ext.Ajax.request({
				url : pageUrl,
				scope:this,
				success: function(response){
					var jsonText = response.responseText;
					if ( !Ext.isEmpty( jsonText ) )
					{
						var jsonData = Ext.decode(jsonText);
						zoomGraphPanel.removeAll();
						zoomGraphPanel.createItems(jsonData);
					}
				},
				failure:function(){
					//alert('---problem---');
				}
			});
		}
	},
	displayBigGraph : function(thisObj,graphType){
		var graphUrl="";
		if ( !Ext.isEmpty( thisObj ) && !Ext.isEmpty( thisObj.clickUrl ) ) 
		{
			graphUrl =thisObj.clickUrl;
			this.commonUrl=graphUrl;
			this.gType=graphType;

			main_commonUrl=graphUrl;
			main_gType=graphType;
		}
		else if ( !Ext.isEmpty( thisObj )) 
		{
			graphUrl =thisObj;
			this.commonUrl=thisObj;
			this.gType=graphType;

			main_commonUrl=graphUrl;
			main_gType=graphType;
		}
		
		var me=this;
		var imgPath=graphUrl.substring(0,graphUrl.indexOf("?"));
		var imgParam=graphUrl.substring(graphUrl.indexOf("?")+1,graphUrl.length);
		
		var zoomGraphPanel = Ext.create('utilities.ZoomGraphPanel',{
			title:'Graph',
			style:{'box-shadow': 'none','-webkit-box-shadow': 'none','-moz-box-shadow': 'none' },
			cls:'block1',
			border:true,
			frame:true,
			region:'center',
			monitorResize: true,
			autoScroll:false,
			margin:10,
		});
		
		var pageUrl = timelineEncodedURL+"&graphType="+graphType+"&"+imgParam+"&isZoomGraph=true&come_from=vmwareLiveGraph&graphId="+this.graphId;
		
		var scrWid=documentView.getWidth();
		var scrHei=documentView.getHeight();
		pageUrl=pageUrl+"&screenWidth="+scrWid+"&screenHeight="+scrHei;
		Ext.Ajax.request({
			url : pageUrl,
			scope:this,
			success: function(response){
				var jsonText = response.responseText;
				if ( !Ext.isEmpty( jsonText ) )
				{
					var jsonData = Ext.decode(jsonText);
					zoomGraphPanel.createItems(jsonData);
					var gcObj=Ext.getCmp('graphContainer');
					gcObj.hide();
					var fvObj=Ext.getCmp('fvId');
					fvObj.show();
					fvObj.add(zoomGraphPanel);
				}
			},
			failure:function(){
				//alert('---problem---');
			}
		});
	},
	showFullview:function (index,graphType)
	{
		var thisObj=Ext.getCmp("vLGFC"+index);
		if(Ext.isEmpty(thisObj))
		{
			thisObj=Ext.getCmp("chartIdInx"+index);
		}
		this.displayBigGraph(thisObj,graphType);
	},
	enlargeTheGraph:function(bgUrl)
	{
		if (!Ext.isEmpty( bgUrl )) 
		{
			var gcObj=Ext.getCmp('graphContainer');
			gcObj.hide();

			var fvObj=Ext.getCmp('fvId');
			fvObj.show();

			var zoomGraphPanel = Ext.create('utilities.ZoomGraphPanel',{
				title:vlzoomheader,
				cls:'block1',
				region:'center',
				border:true,
				frame:true,
				style:{'box-shadow': 'none','-webkit-box-shadow': 'none','-moz-box-shadow': 'none' },
				monitorResize: true,
				margin:10,
				height:'100%',
				bgUrl:bgUrl,
				html:'',
				listeners:{
					'afterrender': function(thisObj)
					{
						Ext.Ajax.request({
							url : thisObj.bgUrl,
							scope:this,
							success: function(response){
								var jsonText = response.responseText;
								if ( !Ext.isEmpty( jsonText ) )
								{
									jsonData = Ext.decode( jsonText );
		
									if ( !Ext.isEmpty( jsonData ) )
									{
										zoomGraphPanel.createGraphItems(jsonData);
									}
									else
									{
										temp='<div style="float:left;">';
										temp=temp+'<div style="margin:auto;text-align:center;border:0px solid red"><div class="iconInformation" style="margin:auto;text-align:center"></div><div style="text-align:center" >'+ndf+'</div></div>';
										temp=temp+"</div>";
										thisObj.update(temp);
									}
								}
								else
								{
									temp='<div style="float:left;">';
									temp=temp+'<div style="margin:auto;text-align:center;border:0px solid red"><div class="iconInformation" style="margin:auto;text-align:center"></div><div style="text-align:center" >'+ndf+'</div></div>';
									temp=temp+"</div>";
									thisObj.update(temp);
								}
							},
							failure:function(){
								alert('---problem---');
							}
						});
					}
				}
			});

			fvObj.add(zoomGraphPanel);
		}
	},
	refreshBar:function(){
		var ctObj=Ext.getCmp("comptype");
		var cnObj=Ext.getCmp("compName");
		var gmObj=Ext.getCmp("graphMode");
		var gtObj=Ext.getCmp("graphType");
		var reURL = "/final/monitor/livegraph/EgVmwareLiveGraphDisplay.jsp?comptype="+ctObj.getValue()+"&er_component="+cnObj.getValue()+"&mode="+gmObj.getValue()+"&er_view="+gtObj.getValue();
		this.refreshBarInterval(reURL);
	},
	refreshBarInterval: function(refreshURL)
	{
		var me=this;
		Ext.Ajax.request({
			url : refreshURL,
			method : 'POST',
			scope:this,
			success : function(response, opts){
				var jsonText = response.responseText;
				if ( !Ext.isEmpty( jsonText ) )
				{
					var gcObj=Ext.getCmp('graphContainer');
					if ( !Ext.isEmpty( gcObj ))
					{
						var graphItems = gcObj.items.items;
						try
						{
							var jsonBarDatas = Ext.decode(jsonText);
							var itemsArray=jsonBarDatas.jsonData.TopNData;
							if(!Ext.isEmpty(itemsArray))
							{
								for(var i=0;i<itemsArray.length;i++)
								{
									var graphIdObj = graphItems[i];
									var itemJson=itemsArray[i];
									var panelId = itemJson.chartCId;
									if(graphIdObj!=null && graphIdObj.id==panelId)
									{
										try
										{
											if(jQuery('#'+graphIdObj.id)!=null && jQuery('#'+graphIdObj.id)!=undefined)
											{
												jQuery('#'+graphIdObj.id).highcharts().destroy();
											}
										}
										catch (e)
										{
										}

										if ( !Ext.isEmpty( itemJson ) )
										{
											var panelWidth = ( $( window ).width() / 2 ) - 100;
											//var panelHeight = $(window).height()-330;
											try
											{
												var panelHeight = Ext.getCmp(itemJson.chartCId).getHeight();
											}
											catch (ert)
											{
												var panelHeight = 275;
											}
											itemJson['fromPage']='vlive';
											itemJson['measureTitle']=itemJson.measureTitle;
											itemJson['tick']=false;
											itemJson['isStateBar']=false;
											//var barChart = {};
											//barChart = jQuery.extend(true, {}, createBar(panelId,itemJson.chartHeight,panelWidth), barChart);
											//barChart.setData(itemJson,'','','bar',itemJson.fullViewURL);
											//barChart.drawChart();

											//getHighChartForBar(panelId,itemJson,panelWidth,itemJson.chartHeight,itemJson.fullViewURL);
											getHighChartForBar(panelId,itemJson,panelWidth,panelHeight,itemJson.fullViewURL);
										}
										else
										{
											
											temp='<center><div style="margin:auto;padding:12 3 3 10;display:inline-block;"><div class="f12-bold" style="text-align:center;"><b>'+itemJson.title+'</b></div></div></center>';
											//temp=temp+'<center><div style="margin:25% 0 auto 0;text-align:center;border:0px solid red"><div class="iconInformation" style="margin:auto;text-align:center"></div><div style="text-align:center" >'+ndf+'</div></div></center>';
											temp=temp+'<center><div style="display:table;height:88%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>'+ndf+'</div></div></div></center>';
											graphIdObj.update(temp);
										}
									}
								}
							}
						}
						catch(e)
						{
							//temp=temp+'<center><div style="margin:25% 0 auto 0;text-align:center;border:0px solid red"><div class="iconInformation" style="margin:auto;text-align:center"></div><div style="text-align:center" >'+ndf+'</div></div></center>';
							temp=temp+'<center><div style="display:table;height:88%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>'+ndf+'</div></div></div></center>';
							graphIdObj.update(temp);
						}
					}
				}
			},
			failure : function(){
				if (!Ext.isEmpty(this))
					this.showResult(null);
				else
					window.location.href="/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=service&isServiceBusiDash=true&isFromMenu=true";
			}
		});
	},
	refresh:function(refUrl,refWidth,refHeight,panelId){
		var ctObj=Ext.getCmp("comptype");
		var cnObj=Ext.getCmp("compName");
		var gmObj=Ext.getCmp("graphMode");
		var gtObj=Ext.getCmp("graphType");
		var refreshURL = "/final/monitor/livegraph/EgVmwareLiveGraphDisplay.jsp?comptype="+ctObj.getValue()+"&er_component="+cnObj.getValue()+"&mode="+gmObj.getValue()+"&er_view="+gtObj.getValue();
		this.refreshPageInterval(refUrl,refWidth,refHeight,panelId);
	},
	refreshPageInterval: function(refreshURL,refWidth,refHeight,panelId)
	{
		var me=this;
		Ext.Ajax.request({
			url : refreshURL,
			method : 'POST',
			async:false,
			scope:this,
			success : function(response, opts){
				var jsonText = response.responseText;
				if ( !Ext.isEmpty( jsonText ) )
				{
					var jsonData = Ext.decode(jsonText);
					var gcObj=Ext.getCmp('graphContainer');
					if ( !Ext.isEmpty( gcObj ))
					{
						var graphItems = gcObj.items.items;
						for(var i=0;i<graphItems.length;i++)
						{
							var graphIdObj = graphItems[i];
							if(graphIdObj!=null && graphIdObj.id==panelId)
							{
								try
								{
									if(jQuery('#'+graphIdObj.id)!=undefined && jQuery('#'+graphIdObj.id)!=null)
									{	
										var garphObj = '#'+graphIdObj.id;
										var chartObj = jQuery(garphObj).highcharts();
										if(chartObj != undefined && chartObj != null)
										{
											var seriesLength = chartObj.series.length;
											for(var t = seriesLength - 1; t > -1; t--)
											{
												try
												{
													chartObj.series[t].remove();	
												}
												catch (e)
												{
												}												
											}
											if ( graphIdObj != null ) 
											{
												if ( !Ext.isEmpty( jsonData.DataSet ) )
												{
													jsonData['enableTitle'] = true;
													jsonData['useHtml'] = true;

													try
													{
														var checkboxObj = Ext.getCmp("er_chart_checkbox");
														checkboxObj.setValue(true);
													}
													catch (er)
													{
													}
													

													if(!Ext.isEmpty( jsonData['title']))
													{
														//thisObj.setTitle(jsonData['title']);
													}
													var browserWidth = $( window ).width();
													var browserHeight = $( window ).height()-300;
													browserWidth = browserWidth/2;
													var datesetEntry = jsonData['DataSet'];
													for(var t=0;t<datesetEntry.length;t++)
													{
														chartObj.addSeries(datesetEntry[t]);
													}
													$(chartObj.series).each(function(){
														this.legendSymbol.attr('x',10);
														this.legendSymbol.attr('y',7);
														this.legendSymbol.attr('width',6);
														this.legendSymbol.attr('height',6);
													});
													chartObj.redraw();
												}
												else
												{
													
													temp='<center><div style="margin:auto;padding:12 3 3 10;display:inline-block;"><div class="f12-bold" style="text-align:center;"><b>'+jsonData.title+'</b></div></div></center>';
													//temp=temp+'<center><div style="margin:25% 0 auto 0;text-align:center;border:0px solid red"><div class="iconInformation" style="margin:auto;text-align:center"></div><div style="text-align:center" >'+ndf+'</div></div></center>';
													temp=temp+'<center><div style="display:table;height:88%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>'+ndf+'</div></div></div></center>';
													graphIdObj.update(temp);
												}
											}
										}
										else
										{
											if ( graphIdObj != null ) 
											{
												if ( !Ext.isEmpty( jsonData.DataSet ) )
												{
													jsonData['enableTitle'] = true;
													jsonData['useHtml'] = true;

													try
													{
														var checkboxObj = Ext.getCmp("er_chart_checkbox");
														checkboxObj.setValue(true);
													}
													catch (er)
													{
													}
													

													if(!Ext.isEmpty( jsonData['title']))
													{
														//thisObj.setTitle(jsonData['title']);
													}
													var browserWidth = $( window ).width();
													var browserHeight = $( window ).height()-300;
													browserWidth = browserWidth/2;
													getHighChartForTimeLine(graphIdObj.id,jsonData,browserWidth-100,browserHeight,refreshURL);
												}
												else
												{
													
													temp='<center><div style="margin:auto;padding:12 3 3 10;display:inline-block;"><div class="f12-bold" style="text-align:center;"><b>'+jsonData.title+'</b></div></div></center>';
													//temp=temp+'<center><div style="margin:25% 0 auto 0;text-align:center;border:0px solid red"><div class="iconInformation" style="margin:auto;text-align:center"></div><div style="text-align:center" >'+ndf+'</div></div></center>';
													temp=temp+'<center><div style="display:table;height:88%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>'+ndf+'</div></div></div></center>';
													graphIdObj.update(temp);
												}
											}
										}
									}
								}
								catch (e)
								{
								}
							}
						}
					}
				}
			},
			failure : function(){
				if (!Ext.isEmpty(this))
					this.showResult(null);
				else
					window.location.href="/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=service&isServiceBusiDash=true&isFromMenu=true";
			}
		});
	}
});