Ext.define('VirtualDashboard.controller.SummaryTab', {
	extend: 'Ext.app.Controller',
	requires:['utilities.ZoomGraphPanel'],
	views:['VirtualDashboard.view.SummaryTab','VirtualDashboard.view.VirtualTabPanel','VirtualDashboard.view.Summary.SummaryOverview','VirtualDashboard.view.Summary.SummaryHealth','VirtualDashboard.view.Summary.HostStatus','VirtualDashboard.view.Summary.HostGlance','VirtualDashboard.view.Summary.VMStatus','VirtualDashboard.view.Summary.VMGlance','VirtualDashboard.view.Summary.ClusterView','VirtualDashboard.view.Summary.ClusterOverview','VirtualDashboard.view.Summary.ClusterHealth'],
	       refs:[{
	    	   ref:'vmGlance',
	    	   selector:'vmglance'
	       },{
	    	   ref:'hostGlance',
	    	   selector:'hostglance'
	       },{
	    	   ref:'summaryHealth',
	    	   selector:'summaryhealthview'
	       },{
	    	   ref:'summaryTab',
	    	   selector:'summarytab'
	       },{
	    	   ref:'summaryOverview',
	    	   selector:'summaryoverview'
	       },{
	    	   ref:'hostStatus',
	    	   selector:'hoststatus'
	       },{
	    	   ref:'vmStatus',
	    	   selector:'vmstatus'
	       },{
	    	   ref:'summaryHealthGrid',
	    	   selector:'summaryhealthview grid'
	       },{
	    	   ref:'virtualTabPanel',
	    	   selector: 'virtualtabpanel'
	       },{
				ref : 'zoomGraphComboMode',
				selector : 'ZoomGraphPanel  combo[itemId= "mode"]'
			},{
				ref : 'zoomGraphComboTimeline',
				selector : 'ZoomGraphPanel  combo[itemId= "timeline"]'
			},{
				ref : 'zoomGraphComboFromhr',
				selector : 'ZoomGraphPanel combo[itemId= "fromhr"]'
			},{
				ref : 'zoomGraphComboTohr',
				selector : 'ZoomGraphPanel combo[itemId= "ToHr"]'
			},{
				ref : 'zoomGraphFromDate',
				selector : 'ZoomGraphPanel datefield[itemId= "from"]'
			},{
				ref : 'zoomGraphToDate',
				selector : 'ZoomGraphPanel datefield[itemId= "to"]'
			},{
				ref : 'zoomGraphPanel',
				selector : 'ZoomGraphPanel'
			},{
			ref : 'zoomGraphImgPanel',
			selector : 'ZoomGraphPanel > scrollpanel'
			}],
	       init: function() {
	    	   this.control({	    		      		  
	    		   'vmglance combo[action=vmMeasures]':{
	    			   select: function( combo, records, eOpts ){
						   var org_url=this.getVmGlance().realUrl;
	    				   this.getVmGlance().removeAll();
	    				   //this.getVmGlance().url="/final/monitor/vmGlance.jsp?user=yes&type=VmVdi_i_server&measure="+combo.getValue();
						   this.getVmGlance().url=org_url+"&measure="+combo.getValue();
	    				   var vmPanel = this.getVmGlance();
	    				   if(!Ext.isEmpty(vmPanel.getEl())){
	    					   vmPanel.getEl().mask("Loading...","maskCenter");
	    				   }
	    				   this.getVmGlance().createUI();
	    			   }
	    		   },
	    		   'hostglance combo[action=hostMeasures]':{
	    			   select: function( combo, records, eOpts ){
						   var org_url=this.getHostGlance().realUrl;
	    				   this.getHostGlance().removeAll();
	    				   //this.getHostGlance().url="/final/monitor/hostGlance.jsp?user=yes&type=VmVdi_i_server&measure="+combo.getValue();
						   this.getHostGlance().url=org_url+"&measure="+combo.getValue();
	    				   var hostPanel = this.getHostGlance();
	    				   if(!Ext.isEmpty(hostPanel.getEl())){
	    					   hostPanel.getEl().mask("Loading...","maskCenter");
	    				   }
	    				   this.getHostGlance().createUI();
	    			   }
	    		   },
	    		   'summaryhealthview grid':{
	    			   afterrender: this.displayAlarmPopup,
	    			   columnresize: function(ct, column, width, eOpts ){
	    				  this.getSummaryHealthGrid().doLayout();
	    			   }
	    		   },
	    		   'hoststatus grid':{
	    			   afterrender: this.displayHostStatusPopup
	    		   },
	    		   'vmstatus grid':{
	    			   afterrender: this.displayVMStatusPopup
	    		   },
	    		   'summaryhealthview panel toolbar image[action=previous]':{
	    			   click: this.displayPreviousAlarm
	    		   },
	    		   'summaryhealthview panel toolbar image[action=next]':{
	    			   click: this.displayNextAlarm
	    		   },
	    		   'summaryoverview button[action=display-overview]':{
	    			   click: this.overviewButtonClicked
	    		   }
	    	   });
	       },	       
		   
	       overviewButtonClicked: function(btn){
	    	   var type=VirtualDashboard.app.getController('Main').selectedComponent;	    	
	    	   changeTab(btn.linkUrl,true,type,requestParams.s_priority);
	    	   
	    	   var activeTab = requestParams.activeTab;
	    	   activeTab = activeTab.toLowerCase();

	    	   var tabPanel = this.getVirtualTabPanel();	    	   
	    	   var activeComponent = tabPanel.down('panel[itemId='+activeTab+']');
	    	   tabPanel.setActiveTab(activeComponent);
	    	   changeTab(btn.linkUrl,true,type,requestParams.s_priority);
				var selectioncomboId = Ext.getCmp('comboSelectionId');
				var tabID = '';
				if(!Ext.isEmpty(tabPanel.getActiveTab()) && tabPanel.getActiveTab()!=undefined)
					tabID = tabPanel.getActiveTab().itemId;
				if (tabID=='summarytab' || tabID=='eventstab' || tabID=='clustertab')
				{
					selectioncomboId.hide();
				}
				else
				{
					selectioncomboId.show();
				}
	    	   tabPanel.getActiveTab().createTabUI();
	       },

	       displayAlarmPopup : function(){
			   var me=this;
				  if(me.getSummaryHealth().data.GridData.Details!=undefined && !Ext.isEmpty(me.getSummaryHealth().data.GridData.Details)){				   
					try
					 {
					   //var target=['health-grid-cell-1','health-grid-cell-2','health-grid-cell-3','health-grid-cell-4'];
					   var target='summaryHealthGrid';
					   if(me.getSummaryHealth().data.GridData.Details!=undefined && !Ext.isEmpty(me.getSummaryHealth().data.GridData.Details))
					   {
							Ext.getCmp(target).getEl().on('click', function() {
								tooltip=me.createTooltipDisplay(me.getSummaryHealth().data.GridData.Details, "summaryhealth");
								me.createStateTooltip(target,tooltip);	
							});								  
					   }
					 }
				   catch (err)
				   {
					   //console.log(err);
				   }
			   }	    				 	    						   
	       },
	       
	       displayHostStatusPopup : function(){
			   var me=this;
			   Ext.Function.defer(function() {
			   try
			   {
				   if(me.getHostStatus().rows!=null && me.getHostStatus().rows!=undefined && !Ext.isEmpty(me.getHostStatus().rows) && me.getHostStatus().hostGrid!=null && me.getHostStatus().hostGrid!=undefined)
				   {
					   Ext.getBody().on('click', function(obj){
						   var targetId = obj.target.id;
							var hosttGridObj = '';
							if(!Ext.isEmpty(me.getHostStatus()) && me.getHostStatus()!=null && me.getHostStatus()!=undefined)
								hosttGridObj = me.getHostStatus();
							for (var i in hosttGridObj.hostGrid)
							{
								try
								{
								   var obj = hosttGridObj.hostGrid[i];
								   var state = obj.name;
								   var tip_id = obj.id;
								   var details = obj.details;
								   if(tip_id == targetId){
									   tooltip=me.createTooltipDisplay(details,"hoststatus");
										me.createStateTooltip(tip_id,tooltip);									
								   }
							   }
							   catch (ert)
							   {
								   //console.log("ert-==->",ert)
							   }
							}
					   });				  	    					  
				   }
				}
				catch(err)
			    {
					//console.log(err)
			    }
			   }, 100);		   
	       },	       
	       
	       displayVMStatusPopup : function(){
				var me=this;
				Ext.getBody().on('click', function(obj){
				var targetId = obj.target.id;
				var vmStatusObj = me.getVmStatus();
				if((!Ext.isEmpty(vmStatusObj) && vmStatusObj!=undefined) && (!Ext.isEmpty(vmStatusObj.vmGrid) && vmStatusObj.vmGrid!=null && me.getVmStatus().vmGrid!=undefined))
				{
				   for (var i in me.getVmStatus().vmGrid)
					{
					   try
					   {
						   var obj = me.getVmStatus().vmGrid[i];
						   var state = obj.name;
						   var tip_id = obj.id;
						   var details = obj.details;
						   if(tip_id == targetId){
							   tooltip=me.createTooltipDisplay(details,"vmstatus");
								me.createStateTooltip(tip_id,tooltip);									
						   }
					   }
					   catch (ert)
					   {
						   //console.log("ert-==->",ert)
					   }
					}
				}
				});				 	   
	       },
	       
		   /*-------------- Current alarms grid tooltip-----------------*/
	       createStateTooltip: function (target,tooltip){
			   if(!Ext.isEmpty(Ext.getCmp('windowEle'))){
					Ext.getCmp('windowEle').destroy();
			   }
				var stateTooltip = Ext.create('Ext.window.Window', {
					//title:'Current Alarms',
					title:summaryCATitle,
					border:true,
					modal:true,
					width : 1000,  
					items : tooltip,
					id:'windowEle',
					listeners:{
					   'afterrender':function()
						{
						   try
						   {
							tooltip.getStore().reload();
						   }
						   catch (ert)
						   {
							   //console.log("ert=-=->",ert)
						   }
							
						},
						show: function(win)
						{
							if (this.modal)
							{
								var dom = Ext.dom.Query.select('.x-mask');
				
								var el = Ext.fly(dom[dom.length-1]);
				
								el.addCls('windowModal');
							}
						},
						hide: function(win)
						{
							if (this.modal)
							{
								var dom = Ext.dom.Query.select('.x-mask');
								var el = Ext.fly(dom[dom.length-1]);
								el.removeCls('windowModal');
							}
						}
					}
			   });
			   stateTooltip.show();
	       },       
	       displayPreviousAlarm : function(){
			   var x=0;  				
			   var alarmStr=this.getSummaryTab().data.AlarmString;
			   var alarm_array = alarmStr.split(',');
			   var count= this.getSummaryHealth().data.GridData.Count;

			   if(count <= 0)
			   {
				   x = alarm_array.length-1;
			   }
			   else
			   {
				   x = count-1;
			   }

			   var alarm_id=alarm_array[x];
			   if(alarm_id==null || alarm_id=='undefined' || alarm_id==undefined)
			   {
				   if(alarm_array.length>0)
				   {
					   alarm_id=alarm_array[0];
					   x=0;
				   }
				   else
				   {
					   alarm_id="";
					   x=0;
				   }
			   }
			   this.getSummaryHealth().url="/final/monitor/summaryHealth.jsp?user=yes&alarm="+alarm_id+"&count="+x;    				
			   if(!Ext.isEmpty(this.getSummaryHealth().getEl())){
				   this.getSummaryHealth().getEl().mask("Loading...","maskCenter");
			   }
			   this.getSummaryHealth().createUI();		 
	       },
	       
	       displayNextAlarm : function(){
			   var x=0;  				
			   var alarmStr=this.getSummaryTab().data.AlarmString;
			   var alarm_array = alarmStr.split(',');
			   var count= this.getSummaryHealth().data.GridData.Count;
			   if(count > (alarm_array.length-1))
			   {
				   x=(alarm_array.length-1);
			   }
			   else if(count < (alarm_array.length-1))
			   {
				   x=parseInt(count)+1;
			   }
			   else
			   {
				   x=0;
			   }

			   var alarm_id=alarm_array[x];
			   if(alarm_id==null || alarm_id=='undefined' || alarm_id==undefined)
			   {
				   if(alarm_array.length>0)
				   {
					   alarm_id=alarm_array[0];
					   x=0;
				   }
				   else
				   {
					   alarm_id="";
					   x=0;
				   }
			   }
			   this.getSummaryHealth().url="/final/monitor/summaryHealth.jsp?user=yes&alarm="+alarm_id+"&count="+x;
			   if(!Ext.isEmpty(this.getSummaryHealth().getEl())){
				   this.getSummaryHealth().getEl().mask("Loading...","maskCenter");
			   }
			   this.getSummaryHealth().createUI();		   
	       },
		
	       createTooltipDisplay :  function(jsonData, grid)
			{
				if(!Ext.isEmpty(jsonData))
				{
				   if(Ext.isEmpty(jsonData.Nodetails)){
					   var statusStore=Ext.create('VirtualDashboard.store.Summary.SummaryHealth',{
						   data:jsonData.Details
					   });
					   var columns=new Array();
					   if(grid==="hoststatus"){
						   columns.push({
							   text:jsonData.Headers[0].Header,
							   dataIndex:'Description',
							   flex:3,
							   menuDisabled :true
						   },{
							   text:jsonData.Headers[1].Header,
							   dataIndex:'StartTime',
							   flex:2,
							   menuDisabled :true
						   });
					   }
					   else if(grid==="vmstatus"){
						   columns.push({
							   text:jsonData.Headers[0].Header,
							   dataIndex:'Component',
							   flex:2,
							   menuDisabled :true
						   },{
							   text:jsonData.Headers[1].Header,
							   dataIndex:'Description',
							   flex:5,
							   menuDisabled :true
						   },{
							   text:jsonData.Headers[2].Header,
							   dataIndex:'StartTime',
							   flex:3,
							   menuDisabled :true
						   });
					   }
					   else if(grid==="summaryhealth"){
						   columns.push(/*{
							   text:jsonData.Headers[0].Header,
							   dataIndex:'State',
							   menuDisabled :true,
							   flex:1.2,
							   renderer:function(value,metaData,record,rowIndex,colIndex){								
								   return '<img src="/final/images/clear.png" class="state_'+record.raw.state+'"/>';
							   } 
						   },{
							   text:jsonData.Headers[1].Header,
							   dataIndex:'Component',
							   flex:2,
							   menuDisabled :true
						   },*/{
							   text:jsonData.Headers[2].Header,
							   dataIndex:'Description',
							   flex:5,
							   menuDisabled :true
						   },/*{
							   text:jsonData.Headers[3].Header,
							   dataIndex:'Test',
							   flex:2,
							   menuDisabled :true
						   },*/{
							   text:jsonData.Headers[4].Header,
							   dataIndex:'StartTime',
							   flex:3,
							   menuDisabled :true
						   });
					   }
					   var infoGrid= Ext.create('utilities.CustomGrid',{
							width:'100%',
							border:false,
							maxHeight:200,
							padding:0,
							margin:0,
							scroll:true,
							autoScroll:true,
							cls:'gridSkin',
							store:statusStore,
							columns: columns,
							forceFit:true
					   });
					   return infoGrid;					   
				   }
				   else{
					   var infoPanel = Ext.create('Ext.panel.Panel',{
						   border:false,
						   html: jsonData.Nodetails
					   });
					   return infoPanel;
				   }
				}

	       }
});