Ext.define('VirtualDashboard.view.ClusterTab', {
	extend: 'Ext.panel.Panel',
	alias:'widget.clustertab',
	border:false,
	url:null,
	mask:null,
	data:null,
	layout:{type:'vbox',align:'stretch'},
	requires: ['utilities.ScrollPanel','VirtualDashboard.view.Summary.ClusterView','VirtualDashboard.view.Summary.ClusterOverview','VirtualDashboard.view.Summary.ClusterHealth'],
	createTabUI : function(url){
		var me = this;
		//me.removeAll();
		Ext.Ajax.request({
			url : url,
			method : 'GET',
			scope : this,
			timeout:280000,
			success : function(response, opts) {
				var jsonText = null;
				jsonText = response.responseText;
				var jsonData = null;
				jsonData = Ext.decode(jsonText);

				delete jsonText;
				Ext.destroy(jsonText);
				jsonText = null;

				var resultItems=me.items.items;
				for(var item=resultItems.length-1; item>-1 ; item--)
				{
					resultItems[item].destroy();
				}

				me.removeAll();

				me.data=jsonData;
				me.url=url;
				var type = (requestParams.nodeName!='') ? requestParams.nodeName : VirtualDashboard.app.getController('Main').selectedComponent;

				var compType=Ext.getCmp('cmpTypeID').getValue();
				if(!Ext.isEmpty(compType) && compType!=undefined  && compType!=null && compType!=type)
					type=compType;

				if(type.indexOf("^") != -1)
					type = type.ReplaceAll('^','$cap$');
				var upperPanel = Ext.create('Ext.container.Container',{
					layout: 'fit',
					id:'clusterUpperPanelId',
					height:112,
					items: [{
						xtype:'clusteroverview',
						id:'clusterOverviewId',
						url:'/final/monitor/clusteroverview.jsp?user=yes&type='+encodeURI(type),
						healthUrl:'/final/monitor/clusterHealth.jsp?user=yes&type='+encodeURI(type)
					}]
				});
				me.add(upperPanel);

				var lowerPanel = Ext.create('widget.scrollpanel',{
					layout:{type:'vbox',align:'stretch'},
					//title:'Graph',
					//cls:'block1',
					cls:'shadow_panel',
					frame:false,
					border:true,
					padding:0,
					margin:'0 8 8 8',
					id:'clusterLowerPanelId',
					flex:1,
					items:[{
						xtype:'clusterview',
						id:'clusterviewId',
						data:me.data
					}]
				});
				me.add(lowerPanel);

				//me.doLayout();

				if(!Ext.isEmpty(me.mask)){
					me.mask.hide();
				}

				delete jsonData;
				Ext.destroy(jsonData);
				jsonData = null;
			},
			failure:function(){
				//alert('failure')
			}
		});
	},
	createTabUIForRefresh : function(url){
		var me = this;
		//me.removeAll();
		Ext.Ajax.request({
			url : url,
			method : 'GET',
			scope : this,
			timeout:280000,
			success : function(response, opts) {
				var jsonText = null;
				jsonText = response.responseText;
				var jsonData = null;
				jsonData = Ext.decode(jsonText);
				if(Ext.isIE){
					delete jsonText;
				}
				me.data=jsonData;
				me.url=url;
				var type = (requestParams.nodeName!='') ? requestParams.nodeName : VirtualDashboard.app.getController('Main').selectedComponent;
				
				var compType=Ext.getCmp('cmpTypeID').getValue();
				if(!Ext.isEmpty(compType) && compType!=undefined  && compType!=null && compType!=type)
					type=compType;
				if(type.indexOf("^") != -1)
					type = type.ReplaceAll('^','$cap$');
				var clusterUpperPanelIdObj=Ext.getCmp('clusterUpperPanelId');
				if(!Ext.isEmpty(clusterUpperPanelIdObj))
				{
					var clusterOverviewIdObj=Ext.getCmp('clusterOverviewId');
					if(!Ext.isEmpty(clusterOverviewIdObj))
					{
						clusterOverviewIdObj.url='/final/monitor/clusteroverview.jsp?user=yes&type='+encodeURI(type);
						clusterOverviewIdObj.healthUrl='/final/monitor/clusterHealth.jsp?user=yes&type='+encodeURI(type);
						clusterOverviewIdObj.refreshUI();
					}
				}

				var clusterLowerPanelIdObj=Ext.getCmp('clusterLowerPanelId');
				if(!Ext.isEmpty(clusterLowerPanelIdObj))
				{
					var clusterviewIdObj=Ext.getCmp('clusterviewId');
					if(!Ext.isEmpty(clusterviewIdObj))
					{
						clusterviewIdObj.data=me.data;
						clusterviewIdObj.refreshUI();
					}
				}
			},
			failure:function(){
				//alert('failure')
			}
		});
	}
});
