Ext.define('VirtualDashboard.view.EventsTab', {
	extend: 'Ext.panel.Panel',
	alias:'widget.eventstab',
	requires:['utilities.ErrorPanel'],
	cls:'block1',
	border:false,
	layout : 'fit',
	url:null,
	title:'',
	mask:null,
	createTabUI : function(tabUrl){
				var me = this;
				var temp_url=tabUrl+"&monCmdComeFrom=vmdashboard&fromPage=vm";
				Ext.Ajax.request({
		    		url : temp_url,
		    		method : 'POST',
		    		scope : this,
		    		success : function(response, opts) {
						var jsonText = null;
		    			jsonText = response.responseText;
						var jsonData = null;
		    			jsonData = Ext.decode(jsonText);

						jsonText = null;
						delete jsonText;
						Ext.destroy(jsonText);

						//this.removeAll();

						var resultItems=this.items.items;
						for(var item=resultItems.length-1; item>-1 ; item--)
						{
							resultItems[item].destroy();
						}

						me.url=tabUrl;
						//me.setTitle(jsonData.labels.title);
						//VirtualDashboard.app.getController('Main').updateUpperToolbarText(jsonData.labels.title);
						
						this.jsonData = jsonData;
						if(Ext.isEmpty(jsonData.labels.error) && !Ext.isEmpty(jsonData.headers)){
							this.createGrid(jsonData);
						}
						else{
							this.createErrorPanel(jsonData);
						}

						jsonData = null;
						delete jsonData;
						Ext.destroy(jsonData);
		    		}
		    	});
	},
	createGrid : function(jsonData){
		if(!Ext.isEmpty(jsonData.data)){
			
			var eventsStore = Ext.create('Ext.data.Store', {
				fields : ['compName','description','alarmTime','descLink','compNameLink','alarmLink','diagnosisImage','graphClick','diagnosisClick','graphImage','state'],
			    proxy: {
			        type: 'memory',
			        reader: {
			            type: 'json',
			            root: 'data'
			        }
			    },
			    data : jsonData.data
			});
		}
			var eventsGrid = {
					xtype:'customgrid',
					//xtype:'Ext.grid.Panel',
					//header:false,
					autoHeight:true,
					cls : 'gridSkin',
					id:'eventgrid',
					margin:8,
					autoScroll:true,
					width:'100%',
					//forceFit:true,
					store: eventsStore,
					autoDestory:true,
					scroll:true,
					columns:[{
						header : jsonData.headers[0],
						dataIndex:'compName',
						draggable:false,
						renderer : function(value,metaData,record,rowIndex,colIndex){
							var htmlStr= '<img style="dispaly:inline-block;vertical-align:top;margin-top:2px;" class="state_'+record.get('state')+'" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=="/>&nbsp<a  href="'+record.get('compNameLink')+'"; return false;>'+record.get('compName')+'</a>';
							return htmlStr;
						},
						//flex : 0.8
						flex : .25
					},{
						header:jsonData.headers[1],
						description:'description',
						draggable:false,
						renderer : function(value,metaData,record,rowIndex,colIndex){
							var htmlStr= '<a href="'+record.get('descLink')+'";>'+record.get('description')+'</a>';
							return htmlStr;
						},
						//flex : 1.4
						flex : .6
					},{
						header:jsonData.headers[2],
						dataIndex:'alarmTime',
						draggable:false,
						renderer : function(value,metaData,record,rowIndex,colIndex){
							var htmlStr= '<a href="'+record.get('alarmLink')+'";>'+record.get('alarmTime')+'</a>';
							return htmlStr;
						},
						//flex : 0.6
						minWidth:130,
						flex : .1
					},{
						scope : this,
						draggable:false,
						renderer : function(value,metaData,record,rowIndex,colIndex){
							if(!Ext.isEmpty(record.get('diagnosisImage'))){
								var htmlStr= '<a href="javascript:void(0)" title="'+this.jsonData.labels.graphHover+'"><img class="iconLineChart" onclick=showGraph("'+record.data.graphClick+'"); src="/final/images/clear.png"/></a>&nbsp&nbsp&nbsp;<a title="'+
								this.jsonData.labels.diagnosisHover+'" href="javascript:void(0);"><img class="iconDiagnosis" onclick=showDiagnosis("'+record.data.diagnosisClick+'"); src="/final/images/clear.png"/></a>';
							}
							else{
								var htmlStr= '<a href="javascript:void(0)" title="'+this.jsonData.labels.graphHover+'"><img class="iconLineChart" onclick=showGraph("'+record.data.graphClick+'"); src="/final/images/clear.png"/></a>';
							}
							return htmlStr;
						},
						//flex : 0.4
						minWidth:65,
						flex : .05
					}]
			};
			
			this.add(eventsGrid);
		},
		createErrorPanel : function(jsonData){
			/*var errorPanel = {
					xtype : 'errorpanel',
					width : '100%',
					margin : 5,
					errorMsg : '<table height="100%" width="100%"><tr><td style="margin:auto;padding-top:200px"><center><div class="iconExclamation"></div><b>' + jsonData.labels.error+ '</b></center><td></tr></table>',
					style : 'margin-top:-300px'
			}*/

			var errorPanel = {
					xtype : 'errorpanel',
					width : '100%',
					height : 500,
					margin : 5,
					padding:200,
					style:{'text-align':'center'},
					imageCls:'iconNoalarms',
					errorMsg :'<div><b>' + jsonData.labels.error+ '</b></div>',
				}
			this.add(errorPanel);
		}
});