Ext.define('VirtualDashboard.view.ResourcesTab', {
	extend: 'Ext.panel.Panel',
	alias:'widget.resourcestab',
	bodyCls:'top-left-radius top-right-radius bottom-left-radius bottom-right-radius virtual-tab-panel-body',
	requires : ['VirtualDashboard.view.UpperResourcesPanel','VirtualDashboard.view.Lowergraphpanel','VirtualDashboard.view.VirtualMachinesResourcesPanel','VirtualDashboard.view.VirtualMachinesPoweredonResourcesPanel','VirtualDashboard.view.VirtualMachinesChildResourcePoolsPanel'],
	border:false,
	url:null,
	layout: {
		type: 'vbox',
		align :'stretch'
	},
	mask:null,
	createTabUI : function(url){
		var me = this;

		var resultItems=me.items.items;
		for(var item=resultItems.length-1; item>-1 ; item--)
		{
			resultItems[item].destroy();
		}

		me.removeAll();

		this.add({
			xtype:'upperresourcespanel',
			upperGridUrl : requestParams.upperUrl
		},
		{
			xtype:'virtualmachinesresourcespanel',
			scroll:true,
			autoScroll:true,
			title:'VMMACHINE'
		},
		{
			xtype:'virtualmachinespoweredonresourcespanel',
			scroll:true,
			autoScroll:true,
			title:'virtualmachinespoweredonresourcespanel'
		},
		{
			xtype:'vmchildresourcesourcespanel',
			scroll:true,
			autoScroll:true,
			title:'vmchildresourcesourcespanel',
		},
		{
			xtype:'lowergraphpanel',
			margin:'3 11 8 11',
			lowerGridUrl :requestParams.lowerUrl
		});

		if(!Ext.isEmpty(me.mask)){
			me.mask.hide();
		}
	},
	createTabUIForRefresh : function(url,o_t_value,o_m_value,o_timeline,o_fromDate,o_fromHr,o_toDate,o_toHr,o_mode){
		var me = this;

		var resultItems=me.items.items;
		for(var item=resultItems.length-1; item>-1 ; item--)
		{
			resultItems[item].destroy();
		}

		me.removeAll();

		this.add({
			xtype:'upperresourcespanel',
			upperGridUrl : requestParams.upperUrl
		},{
			xtype:'virtualmachinesresourcespanel',
			scroll:true,
			autoScroll:true,
			title:'VMMACHINE'
		},{
			xtype:'virtualmachinespoweredonresourcespanel',
			scroll:true,
			autoScroll:true,
			title:'virtualmachinespoweredonresourcespanel'
		},{
			xtype:'vmchildresourcesourcespanel',
			scroll:true,
			autoScroll:true,
			title:'vmchildresourcesourcespanel'
		},{
			xtype:'lowergraphpanel',
			lowerGridUrl :requestParams.lowerUrl,
			t_value: o_t_value,
			m_value: o_m_value,
			timeline: o_timeline,
			fromDate: o_fromDate,
			fromHr: o_fromHr,
			toDate: o_toDate,
			toHr: o_toHr,
			mode: o_mode
		});
		if(!Ext.isEmpty(me.mask)){
			me.mask.hide();
		}
	}
});