Ext.define('VirtualDashboard.view.Summary.ClusterHealth', {
	extend: 'Ext.panel.Panel',
	alias:'widget.clusterhealthview',
	url:null,
	layout:{type:'hbox',align:'stretch'},
	margin:'0 0 0 0',
	data:null,
	//autoScroll:true,
	//scroll:true,
	flex:2,
	baseCls:{background:'none'},
	height:90,
	items:[],
	onRender: function(){
		var me=this;
		if(!Ext.isEmpty(me.getEl())){
			me.getEl().mask("Loading...","maskCenter");
		}
		this.createUI();
		this.callParent();
	},
	createUI: function(){
		var me=this;
		var itemsArray="";
		Ext.Ajax.request({
			url : me.url,
			method : 'GET',
			scope : this,
			timeout:1280000,
			success : function(response, opts) {
				var jsonText = null;
				jsonText = response.responseText;
				var jsonData = null;
				jsonData = Ext.decode(jsonText);
				//console.log(jsonData);

				delete jsonText;
				Ext.destroy(jsonText);
				jsonText = null;

				var resultItems=me.items.items;
				for(var item=resultItems.length-1; item>-1 ; item--)
				{
					resultItems[item].destroy();
				}

				me.removeAll();

				me.data=jsonData;

				//me.url=url;
				//me.setTitle(jsonData.ScreenLabels.Title);

				if(!Ext.isEmpty(jsonData.ErrorMsg)){
					var searchNoList = Ext.create('utilities.ErrorPanel',{
						id:'clusterHealthErrId',
						bodyStyle:{'background':'none'},
						width:'100%',
						errorMsg : '<div style="text-align:center;margin:0px 20%;"><div class="iconInformation" style="margin:5% auto 0px auto"></div><div class="list-empty-text">'+jsonData.ErrorMsg+'</div></div>'
					});
					me.add(searchNoList);
				}
				else if(!Ext.isEmpty(jsonData.InfrastructureItems))
				{
					itemsArray=jsonData.InfrastructureItems;

					for(var item=0; item< itemsArray.length ; item++){
						var itemJson=itemsArray[item];
						var graphData = itemJson.sparkXMLValue;
						var infrastructureComponent ={
								xtype:'container',
								id:'InfrastructureHealth'+item,
								cls:'fancy_border',
								height:150,
								flex:1,
								layout:'vbox',
								padding:2,
								items:[
									{
										xtype:'container',
										id:'chId'+item,
										border:false,
										padding:5,
										height:85,
										margin:'0 0 0 0',
										width:'100%',
										//xtype:'label',
									//xmlData:itemJson.sparkXMLValue,
										itemNumber:item,
										idString:'menuItem'+item,
										listeners : {
											afterrender : function(label){

												var className="cpu32";
												if(itemJson.displayText!=null && itemJson.displayText!=undefined && itemJson.displayText.toLowerCase().indexOf("cpu")>-1)
												{
													className="cpu32";
												}
												else if(itemJson.displayText!=null && itemJson.displayText!=undefined && itemJson.displayText.toLowerCase().indexOf("memory")>-1)
												{
													className="memory32";
												}
												else if(itemJson.displayText!=null && itemJson.displayText!=undefined && itemJson.displayText.toLowerCase().indexOf("datastore")>-1)
												{
													className="trans_datatransfer";
												}
												else if(itemJson.displayText!=null && itemJson.displayText!=undefined && itemJson.displayText.toLowerCase().indexOf("disk")>-1)
												{
													className="diskReadWrite";
												}
												var htmlContent = "";
												htmlContent += '<div class="font_no" style="width:100%;text-align:right">'+itemJson.displayMeaValue+'</div><div style="clear:both"></div><div class="'+className+'" style="position:absolute;left:5px;top:34px"></div>';
												if(itemJson.sparkXMLValue == undefined)
												{
												
													htmlContent +='<div><table align="right"><tr><td><img style="margin-top:3px;" src="/final/images/spacer.gif" class="iconAlert"></td><td><div style="font-family:LucidaGrandeRegular!important;font-size:11px;width:auto;margin:4px 0px 0px 2px">No Data</div></td></tr></table></div>';
												}
												else
												{
													htmlContent +='<div id = "menuItem'+label.itemNumber+'" style="width:auto;float:right;display:block;"></div>';
													htmlContent +='<div id="clusterHealthChart_'+item+'" style="height:8px;margin-top:2px;float:right;clear:both;" class="measure_count handSymbol"></div>';
												}
												
												htmlContent += '<div style="height:1px;clear:both"><div class="font_text" style="width:67%;text-align:right;position:relative;bottom:-15px !important;display:block;float:right;">'+itemJson.displayText+'</div></div>';
												
												label.update(htmlContent);

												if(!Ext.isEmpty(graphData) && graphData!=null && graphData != undefined && graphData !='-'){
													var sparkPath = itemJson.spark_path;
													getSparkCharts("clusterHealthChart_"+item,'60','15',graphData,sparkPath);
												}
											}
										}
									}
								]

						};
						me.add(infrastructureComponent);
					}

					if(itemsArray.length > 0)
					{
						var last = itemsArray.length -1;
						//Ext.getCmp('Infrastructure0').addCls('first');
						Ext.getCmp('InfrastructureHealth'+last).addCls('last');
					}
					else if (itemsArray.length -1  == 0)
					{
						//Ext.getCmp('Infrastructure0').addCls('first');
					}
				}

				if(!Ext.isEmpty(me.getEl())){
					me.getEl().unmask();
				}

				delete jsonData;
				Ext.destroy(jsonData);
				jsonData = null;
			},
			failure: function()
			{
				//alert("failure");
			}
		});
	},
	refreshUI: function(){
		var me=this;
		var itemsArray="";
		Ext.Ajax.request({
			url : me.url,
			method : 'GET',
			scope : this,
			timeout:1280000,
			success : function(response, opts) {
				var jsonText = null;
				jsonText = response.responseText;
				var jsonData = null;
				jsonData = Ext.decode(jsonText);
				if(Ext.isIE){
					delete jsonText;
				}
				me.data=jsonData;
				//me.removeAll();

				if(!Ext.isEmpty(jsonData.ErrorMsg)){
					me.removeAll();
					var searchNoList = Ext.create('utilities.ErrorPanel',{
						id:'clusterHealthErrId',
						errorMsg : '<div style="text-align:center;"><div class="iconInformation" style="margin:5% auto 0px auto"></div><div class="list-empty-text">'+jsonData.ErrorMsg+'</div></div>'
					});
					me.add(searchNoList);
				}
				else if(!Ext.isEmpty(jsonData.InfrastructureItems))
				{
					var clusterHealthErrIdObj=Ext.getCmp('clusterHealthErrId');
					if(!Ext.isEmpty(clusterHealthErrIdObj))
					{
						me.remove(clusterHealthErrIdObj);
					}

					itemsArray=jsonData.InfrastructureItems;

					for(var item=0; item< itemsArray.length ; item++)
					{
						var itemJson=itemsArray[item];
						var graphData = itemJson.sparkXMLValue;
						var chIdObj=Ext.getCmp('chId'+item);
						if(!Ext.isEmpty(chIdObj))
						{
							//chIdObj.xmlData=itemJson.sparkXMLValue;
							chIdObj.itemNumber=item;
							chIdObj.idString='menuItem'+item;
							chIdObj.listeners={
								afterrender : function(label){

									var className="cpu32";
									if(itemJson.displayText!=null && itemJson.displayText!=undefined && itemJson.displayText.toLowerCase().indexOf("cpu")>-1)
									{
										className="cpu32";
									}
									else if(itemJson.displayText!=null && itemJson.displayText!=undefined && itemJson.displayText.toLowerCase().indexOf("memory")>-1)
									{
										className="memory32";
									}
									else if(itemJson.displayText!=null && itemJson.displayText!=undefined && itemJson.displayText.toLowerCase().indexOf("datastore")>-1)
									{
										className="trans_datatransfer";
									}
									else if(itemJson.displayText!=null && itemJson.displayText!=undefined && itemJson.displayText.toLowerCase().indexOf("disk")>-1)
									{
										className="diskReadWrite";
									}

									var htmlContent = '<div class="font_no" style="width:100%;text-align:right">'+itemJson.displayMeaValue+'</div><div style="clear:both"></div><div class="'+className+'" style="position:absolute;left:2px;top:47px"></div> <div id = "menuItem'+label.itemNumber+'" style="float:right;"></div><div style="clear:both"></div><div id="clusterHealthChart_'+item+'" style="height:8px;margin-top:2px;float:right;clear:both;" class="measure_count handSymbol"></div><div style="border:0px solid red;width:67%;font-size:12px;text-align:right;position:absolute;right:5px;bottom:4px"><b>'+itemJson.displayText+'</div></div>';
									
									label.update(htmlContent);
									
									if(!Ext.isEmpty(graphData) && graphData!=null && graphData != undefined && graphData !='-'){
										var sparkPath = itemJson.spark_path;
										getSparkCharts("clusterHealthChart_"+item,'60','15',graphData,sparkPath);
									}

									
								}
							}
						}
					}

					if(itemsArray.length > 0)
					{
						var last = itemsArray.length -1;
						Ext.getCmp('InfrastructureHealth'+last).addCls('last');
					}
					//else if (itemsArray.length -1  == 0)
					//{
						//Ext.getCmp('Infrastructure0').addCls('first');
					//}
				}
			},
			failure: function()
			{
				//alert("failure");
			}
		});
	}
});
