Ext.define('VirtualDashboard.view.Summary.ClusterOverview', {
	extend: 'Ext.container.Container',
	alias:'widget.clusteroverview',
	url:null,
	layout:{type:'hbox',align:'stretch'},
	cls:'searchTopPanel',
	margin:'0 0 0 0',
	padding:0,
	frame:true,
	title:'',
	data:null,
	healthUrl:null,
	//style:{'border':'1px solid violet'},
	requires:['VirtualDashboard.view.Summary.ClusterHealth'],
	onRender: function(){
		var me=this;
		if(!Ext.isEmpty(me.getEl())){
			me.getEl().setWidth(900);
			me.getEl().setHeight(90);
			me.getEl().mask("Loading...","maskCenter");
		}
		this.createUI();
		this.doLayout();
		this.callParent();
	},

	createUI : function(){
		var me=this;
		Ext.Ajax.request({
			url : me.url,
			method : 'GET',
			scope : this,
			timeout:1280000,
			success : function(response, opts) {
				var jsonText = null;
				jsonText = response.responseText;
				var jsonData = null;
				jsonData = Ext.decode(jsonText);

				delete jsonText;
				Ext.destroy(jsonText);
				jsonText = null;

				var resultItems=me.items.items;
				for(var item=resultItems.length-1; item>-1 ; item--)
				{
					resultItems[item].destroy();
				}

				me.removeAll();

				//VirtualDashboard.app.getController('Main').updateUpperToolbarText(jsonData.ScreenLabels.Title);
				//me.setTitle(jsonData.ScreenLabels.Title);

				me.data=jsonData;

				if(!Ext.isEmpty(jsonData.ErrorMsg)){
					var noData = Ext.create('utilities.ErrorPanel',{
						flex:1,
						id:'clusterOverviewErrId',
						bodyStyle:{'background':'transparent'},
						errorMsg : '<div style="text-align:center"><div class="iconInformation" style="margin:3% auto 0px auto"></div><div class="list-empty-text">'+jsonData.ErrorMsg+'</div></div>'
					});
					me.add(noData);
				}
				else if(!Ext.isEmpty(jsonData.InfrastructureItems))
				{
					var outerContainer = Ext.create('Ext.container.Container',{id:'coIOTitleId',flex:1,margin:10,cls:'frameset',layout:'hbox',html:'<div class="title"><b>'+summaryIOTitle+'</b></div>'});
					var imageClass = new Array("totalVMs32","poweredOnVMs32","resourcePool32", "cpu32","memory32"); //add class
					for(var item=0; item< jsonData.InfrastructureItems.length ; item++){
						var offSetVal = -55;
						var ancoffset = 120;
						var comp=jsonData.InfrastructureItems[item];
						if(jsonData.InfrastructureItems.length > 3)
							offSetVal = -85;
						if (comp.text == 'Physical Servers' || item == 0){
							offSetVal = -55;
							ancoffset = 80;
						}
						var infrastructureComponent = Ext.create('Ext.container.Container',{
							flex:.35,
							cls:'fancy_border',
							id:'coInfrastructureOverview'+item,
							layout: 'hbox',
							width:160,
							height:88,
							padding:'0 4',

							items:[{
								xtype:'label',
								id:'coInfrastructureLabel'+item,
								margin: '37 5 0 5',
								padding:0,
								//html:'<div class="'+imageClass[item]+'"></div><div style="width:64px;height:65px;position:absolute;left:0px;" class="'+comp.img+'32" ></div>'
								html:'<div style="border:0px solid yellow;width:64px;height:65px;bottom:25px;left:5px"  class="'+imageClass[item]+'" ></div>'
							},{
								xtype : 'container',
								id:'coInfraDataId'+item,
								cls : 'component-list-left-component',
								height : 82,
								padding:'0 5',
								flex:1,
								border : false,
								action:'display-overview',
								//id: comp.text,
								comp_count:comp.count,
								linkUrl: comp.tabChangeParam,
								details:comp.details,
								offsetVal:offSetVal,
								anchoroffsetVal:ancoffset,
								html : '<div class="font_no" style="position:absolute;top:16px;right:2px">'
									+  comp.count + '</div>'
									+ '<div class="font_text" style="position:absolute;bottom:13px;right:2px;text-align:right">'
									+ comp.text + '</div>',
									listeners:{
										'afterrender': function(curObj){
											if(this.comp_count == null || this.comp_count == "-" || this.comp_count == "")
												return;											
											var tooltip= me.createServerGrid(curObj.details);
											stateTooltip = Ext.create('Ext.tip.ToolTip', {
												//target : comp.text,
												target : curObj.id,
												itemId:curObj.id+'ctip',
												margin:0,
												cls:'innerTooltip',
												anchor: 'top',
												anchorOffset:curObj.anchoroffsetVal,
												trackMouse:false,
												constrainPosition:true,
												mouseOffset:[curObj.offsetVal,0],
												border:0,
												padding:5,
												autoDestroy:true,
												maxWidth : 500,
												minWidth : 300,
												showDelay:0,
												layout : {
														type : 'fit'
													},
												items : tooltip,
												listeners:{
													'show':function(){
														var itemInside = this.getLayout().getLayoutItems( )[0];
														if(itemInside.getXType() == 'customgrid'){
															tooltip.getStore().reload()
														}else{
															//console.log('Im Panel')
														}

													},
													'afterrender': function(){
														this.mon(this.el, 'mouseover', function () {
															this.clearTimer('hide');
															this.clearTimer('dismiss');
														}, this);
														this.mon(this.el, 'mouseout', function () {
															this.clearTimer('show');
															if (this.autoHide !== false) {
																this.delayHide();
															}
														}, this);
													}
												}
											});
										}
									}
							}]
						});
						outerContainer.add(infrastructureComponent);

						//me.add(infrastructureComponent);
					}

					if(jsonData.InfrastructureItems.length > 0)
					{
						var last = jsonData.InfrastructureItems.length -1;
						//Ext.getCmp('Infrastructure0').addCls('first');
						//Ext.getCmp('Infrastructure'+last).addCls('last');
					}
					else if (jsonData.InfrastructureItems.length -1  == 0)
					{
						//Ext.getCmp('Infrastructure0').addCls('first');
					}

					var summaryHealthPanel= {
							xtype:'clusterhealthview',
							id:'chvId',
							url: me.healthUrl,
							minWidth:360,
							//height:110,
							flex:1.5,
					};
					outerContainer.add(summaryHealthPanel);
					me.add(outerContainer);
					//me.doLayout();
				}
				if(!Ext.isEmpty(me.getEl())){
					me.getEl().unmask();
				}

				delete jsonData;
				Ext.destroy(jsonData);
				jsonData = null;
			}
		});
	},
	refreshUI : function(){
		var me=this;
		Ext.Ajax.request({
			url : me.url,
			method : 'GET',
			scope : this,
			timeout:1280000,
			success : function(response, opts) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				me.data=jsonData;
				if(!Ext.isEmpty(jsonData.ErrorMsg)){
					me.removeAll();
					var noData = Ext.create('utilities.ErrorPanel',{
						id:'clusterOverviewErrId',
						bodyStyle:{'background':'transparent'},
						errorMsg : '<div style="text-align:center"><div class="iconInformation" style="margin:3% auto 0px auto"></div><div class="list-empty-text">'+jsonData.ErrorMsg+'</div></div>'
					});
					me.add(noData);
				}
				else if(!Ext.isEmpty(jsonData.InfrastructureItems)){

					var clusterOverviewErrIdObj=Ext.getCmp('clusterOverviewErrId');
					if(!Ext.isEmpty(clusterOverviewErrIdObj))
					{
						me.remove(clusterOverviewErrIdObj);
					}

					var flg=true;
					var ioTitleIdObj=Ext.getCmp('coIOTitleId');
					if(!Ext.isEmpty(ioTitleIdObj))
					{
						flg=false;
					}

					var imageClass = new Array("totalVMs32","poweredOnVMs32","resourcePool32","cpu32","memory32"); //add class
					for(var item=0; item< jsonData.InfrastructureItems.length ; item++){

						var comp=jsonData.InfrastructureItems[item];

						var InfrastructureObj=Ext.getCmp('coInfrastructureOverview'+item);
						if(!Ext.isEmpty(InfrastructureObj))
						{

						}

						var islIdObj=Ext.getCmp('coInfrastructureLabel'+item);
						if(!Ext.isEmpty(islIdObj))
						{
							islIdObj.update('<div style="border:0px solid yellow;width:64px;height:65px;bottom:2px;left:10px"  class="'+imageClass[item]+'" ></div>');
						}

						var infraDataIdObj=Ext.getCmp('coInfraDataId'+item);
						if(!Ext.isEmpty(infraDataIdObj))
						{
							flg=false;
							var tipObj=null;
							try
							{
								tipObj=Ext.getComponent('coInfraDataId'+item+'ctip');
							}
							catch (e)
							{
								tipObj=Ext.getCmp('coInfraDataId'+item+'ctip');
							}

							if(!Ext.isEmpty(tipObj))
							{
								tipObj.destroy();
								tipObj = null;
							}
							infraDataIdObj.linkUrl=comp.tabChangeParam;
							infraDataIdObj.details=comp.details;

							Ext.get('coInfraDataId'+item).select('.font_text').update(comp.text);
							Ext.get('coInfraDataId'+item).select('.font_no').update(comp.count);

							infraDataIdObj.fireEvent('afterrender',infraDataIdObj);

						}
					}

					if(!Ext.isEmpty(jsonData.InfrastructureItems))
					{
						if(jsonData.InfrastructureItems.length > 0)
						{
							var last = jsonData.InfrastructureItems.length -1;
							Ext.getCmp('coInfrastructureOverview0').addCls('first');
							//Ext.getCmp('Infrastructure'+last).addCls('last');
						}
						else if (jsonData.InfrastructureItems.length -1  == 0)
						{
							Ext.getCmp('coInfrastructureOverview0').addCls('first');
						}
					}

					var chvIdObj=Ext.getCmp('chvId');
					if(!Ext.isEmpty(chvIdObj))
					{
						flg=false;
						chvIdObj.url=me.healthUrl;
						chvIdObj.refreshUI();
					}
				}
			}
		});
	},
	createServerGrid :  function(jsonData){
		if(Ext.isEmpty(jsonData.NoDetails)){
			var columns = new Array();
			var infoStore=Ext.create('VirtualDashboard.store.Summary.OverviewInfo',{
				data:jsonData.Details
			});
			if(jsonData.id==="Physical Servers" || jsonData.id==="Connected Servers" || jsonData.id==="Disconnected Servers"){
				if(jsonData.Headers.length==1)
				{
					columns.push({
						text:jsonData.Headers[0].Header,
						dataIndex:'Details',
						menuDisabled :true
					});
				}
				else
				{
					if(jsonData.id==="Connected Servers" || jsonData.id==="Disconnected Servers")
					{
						columns.push({
							text:jsonData.Headers[0].Header,
							dataIndex:'Component',
							menuDisabled :true
						},{
							text:jsonData.Headers[1].Header,
							dataIndex:'Details',
							menuDisabled :true
						});

					}
					else
					{
						columns.push({
							text:jsonData.Headers[0].Header,
							dataIndex:'Component',
							menuDisabled :true
						},{
							text:jsonData.Headers[1].Header,
							dataIndex:'PhysicalServer',
							menuDisabled :true
						});
					}
				}
			}
			else if(jsonData.id==="Total VMs-VmsinVC" || jsonData.id==="Powered On VMs-VmsinVC" || jsonData.id==="Status-VmsinVC"){
				columns.push({
					text:jsonData.Headers[0].Header,
					dataIndex:'Component',
					menuDisabled :true
				},{
					text:jsonData.Headers[1].Header,
					dataIndex:'HostIP',
					menuDisabled :true
				},{
					text:jsonData.Headers[2].Header,
					dataIndex:'',
					menuDisabled :true
				});
			}
			//else if(jsonData.id==="Total VMs" || jsonData.id==="Powered On VMs" || jsonData.id==="Status" || jsonData.id.indexOf("Clusters")>-1 || jsonData.id==="DataStore"){
			else if(jsonData.id==="Total VMs" || jsonData.id==="Powered on VMs" || jsonData.id==="Powered On VMs" || jsonData.id==="Status" || jsonData.id.indexOf("Clusters")>-1 || jsonData.id==="DataStore" || jsonData.id==="Datastore"){
				columns.push({
					text:jsonData.Headers[0].Header,
					dataIndex:'Details',
					menuDisabled :true
				});
			}
			else if(jsonData.id==="Datacenters"){
				columns.push({
					text:jsonData.Headers[0].Header,
					dataIndex:'Details',
					menuDisabled :true
				});
			}
			var infoGrid= Ext.create('utilities.CustomGrid',{
				border:false,
				scroll:true,
				autoScroll:false,
				maxHeight:300,
				//maxHeight:300,
				width:'auto',
				needtoFixColumn:true,
				cls:'gridSkin',
				store:infoStore,
				viewConfig: {
					//forceFit: true,
					//layout:'fit',
					style:{'overflow-x':'hidden !important','overflow-y':'auto !important'},
				},
				columns: columns,
				//layout:'fit'
				//layout:'auto'
				forceFit:true
			});
			return infoGrid;
		}
		else{
			var infoPanel = Ext.create('Ext.panel.Panel',{
				border:false,
				cls:'overview-nodetail',
				html: '<div style="text-align:center"><div class="iconInformation" style="margin:0px auto"></div><div>'+jsonData.NoDetails+'</div></div>'

			});
			return infoPanel;
		}
	}
});

