Ext.define('VirtualDashboard.view.Summary.HostGlance', {
	extend: 'Ext.panel.Panel',
	alias:'widget.hostglance',
	url:null,
	realUrl:null,
	border:false,
	//layout:'fit',
	cls:'datapanel',
	layout:{type:'vbox',align:'stretch'},
	margin:'8 8 8 8',
	frame:true,
	border:true,
	scroll:false,
	autoScroll:false,
	padding:0,
	data:null,
	//title:hostGlanceTitle,
	title:'',
	onRender: function(){
		var me=this;
		if(!Ext.isEmpty(me.getEl())){
			
			me.getEl().setWidth(600);
			me.getEl().setHeight(160);
			me.getEl().mask("Loading...","maskCenter");
		}
		this.createUI();
		this.callParent();
	},
	createUI: function(){
		var me=this;
		var temp_url=me.url+"&monCmdComeFrom=vmdashboard";
		Ext.Ajax.request({
			url : temp_url,
			method : 'GET',
			scope : this,
			timeout:1280000,
			success : function(response, opts) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);	
				me.data=jsonData;
				//me.removeAll();

				delete jsonText;
				Ext.destroy(jsonText);
				jsonText = null;


				var resultItems=me.items.items;
				for(var item=resultItems.length-1; item>-1 ; item--)
				{
					resultItems[item].destroy();
				}

				var titFlage=true;
				if(!Ext.isEmpty(jsonData.HostCombo)){
					var comboStore = Ext.create('Ext.data.Store',{
						fields:['name','value'],
						proxy:{
							type: 'memory',
							reader: {
								type: 'json',
								root:'items'
							}
						},
						data:jsonData.HostCombo
					});

					if(!Ext.isEmpty(jsonData.HostCombo.items)){
						
						var hostCombo={
								xtype:'container',
								height:28,
								cls:'header_con',
								border:true,
								items:[{ xtype:'combo',
								id:'hostComboId',
								editable : false,
								padding:'3 10 0 10',
								width:250,
								labelWidth:92,
								labelSeparator:'',
								//labelWidth:'',
								store:comboStore,
								cls : 'dropdown',
								displayField:'name',
								valueField:'value',
								fieldLabel: jsonData.HostCombo.label,
								action: jsonData.HostCombo.name,
								value: jsonData.HostCombo.selectvalue ? jsonData.HostCombo.selectvalue : jsonData.HostCombo.items[0].value}]
						};
						titFlage=false;
						me.add(hostCombo);
					}
				}
				
				if(!Ext.isEmpty(jsonData.NoDataError)){
					var noData = Ext.create('utilities.ErrorPanel',{
						id:'shgErrId',
						border:false,
						margin:'25% 0 0 0',
						errorMsg : '<center><div style="text-align:center;margin-top:40px"><div class="iconInformation" style="margin:0px auto"></div><div>'+jsonData.NoDataError+'</div></div></center>'
					});
					if(titFlage)
					{
						me.setTitle(hostGlanceTitle? hostGlanceTitle : "");
					}
					me.add(noData);
				}
				else if(!Ext.isEmpty(jsonData.GridInfo))
				{
					var glanceStore=Ext.create('VirtualDashboard.store.Summary.Glance',{
						data:jsonData.GridInfo
					});

					//var glanceGrid = Ext.create('utilities.CustomGrid',{
					var glanceGrid = Ext.create('Ext.grid.Panel',{
						id:'shgGridId',
						cls:'gridSkin vmgrid',
						forceFit:false,
						overflowX:'hidden',
						scroll:true,
						autoScroll:true,
						autoDestory:true,
						height:'100%',
						flex:1,
						border:false,
						store:glanceStore,
						columns:[{
							text:jsonData.GridHeaders[0].Header,
							dataIndex:'ComponentName',
							flex:.7,
							draggable:false,
							menuDisabled :true,
							scope:this,
							renderer:function(value,metaData,record,rowIndex,colIndex){
								return '<a href="'+record.raw.ComponentLink+'">'+value+'</a>';
							}
						},{
							text:jsonData.GridHeaders[2].Header+jsonData.GridHeaders[2].UnitForHeader,
							dataIndex:'Value',
							draggable:false,
							menuDisabled :true,
							flex:.3
						},{
							text:jsonData.GridHeaders[1].Header,
							dataIndex:'graphDataXml',
							menuDisabled :true,
							draggable:false,
							//flex:1,
							renderer:function(value,metaData,record,rowIndex,colIndex){
								if(!Ext.isEmpty(record.get("graphDataXml"))){
									return '<div id="hostglance_'+rowIndex+'" style="height:15px;margin-top:2px;" class="measure_count handSymbol"></div>';
								}else{
									return '-';
								}
							}
						}],
						listeners:{
						 'viewready': function(){
								var itemsArray=jsonData.GridInfo;
								if(!Ext.isEmpty(itemsArray))
								{
									for(var item=0; item< itemsArray.length ; item++)
									{
										var itemJson=itemsArray[item];
										var graphData = itemJson.graphDataXml;
										if( !Ext.isEmpty(graphData) && graphData!='-' )
										{
											var sparkPath = itemJson.SPARK_PATH;
											getSparkCharts("hostglance_"+item,'60','16',graphData,sparkPath);
										}
									}
								}
							},
							'sortchange':function(ct, column, direction, eOpts){
								var itemsArray=jsonData.GridInfo;
								//console.log("--direction---",direction);
								if(!Ext.isEmpty(itemsArray) && direction=='DESC')
								{
									for(var item=0; item< itemsArray.length ; item++)
									{
										var itemJson=itemsArray[item];
										var graphData = itemJson.graphDataXml;
										if( !Ext.isEmpty(graphData) && graphData!='-' )
										{
											var sparkPath = itemJson.SPARK_PATH;
											getSparkCharts("hostglance_"+item,'60','16',graphData,sparkPath);
										}
									}
								}
								else if(!Ext.isEmpty(itemsArray) && direction=='ASC')
								{
									var incr=0;
									for(var item=itemsArray.length-1; item>=0  ; item--)
									{
										var itemJson=itemsArray[item];
										var graphData = itemJson.graphDataXml;
										if( !Ext.isEmpty(graphData) && graphData!='-' )
										{
											var sparkPath = itemJson.SPARK_PATH;
											getSparkCharts("hostglance_"+incr,'60','16',graphData,sparkPath);
											incr++;
										}
									}
								}
							}
						}
					});
					me.add(glanceGrid);
				}
				//me.add(glanceGrid);
				if(!Ext.isEmpty(me.getEl())){
					me.getEl().unmask();
				}
			}
		});
	},
	refreshUI: function(){
		var me=this;
		Ext.Ajax.request({
			url : me.url,
			method : 'GET',
			scope : this,
			timeout:1280000,
			success : function(response, opts) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				me.data=jsonData;
				var titFlage=true;
				if(!Ext.isEmpty(jsonData.HostCombo))
				{
					var hostComboIdObj=Ext.getCmp('hostComboId');
					if(!Ext.isEmpty(hostComboIdObj))
					{
						if(!Ext.isEmpty(jsonData.HostCombo.items))
						{
							hostComboIdObj.show();

							hostComboIdObj.getStore().loadRawData(jsonData.HostCombo);
							hostComboIdObj.setValue(jsonData.HostCombo.selectvalue ? jsonData.HostCombo.selectvalue : jsonData.HostCombo.items[0].value);
							titFlage=false;
						}
					}
				}
				
				if(!Ext.isEmpty(jsonData.NoDataError)){

					if(titFlage)
					{
						//me.removeAll();
						var resultItems=me.items.items;
						for(var item=resultItems.length-1; item>-1 ; item--)
						{
							resultItems[item].destroy();
						}
					}
					else
					{
						var resultItems=me.items.items;
						for(var item=resultItems.length-1; item>-1 ; item--)
						{
							if(resultItems[item].id=='shgErrId')
							{
								resultItems[item].destroy();
							}
						}
					}

					var noData = Ext.create('utilities.ErrorPanel',{
						id:'shgErrId',
						border:false,
						errorMsg : '<center><div style="text-align:center;margin-top:40px"><div class="iconInformation" style="margin:0px auto"></div><div>'+jsonData.NoDataError+'</div></div></center>'
					});

					me.add(noData);

					if(titFlage)
					{
						me.setTitle(hostGlanceTitle? hostGlanceTitle : "");
					}
				}
				else if(!Ext.isEmpty(jsonData.GridInfo)){

					var shgErrIdObj=Ext.getCmp('shgErrId');
					if(!Ext.isEmpty(shgErrIdObj))
					{
						me.remove(shgErrIdObj);
					}

					var shgGridIdObj=Ext.getCmp('shgGridId');
					if(!Ext.isEmpty(shgGridIdObj))
					{
						shgGridIdObj.show();
						shgGridIdObj.getStore().loadRawData(jsonData.GridInfo);
						var itemsArray=jsonData.GridInfo;
						if(!Ext.isEmpty(itemsArray))
						{
							for(var item=0; item< itemsArray.length ; item++)
							{
								var itemJson=itemsArray[item];
								var graphData = itemJson.graphDataXml;
								if(!Ext.isEmpty(graphData) && graphData!='-')
								{
									var sparkPath = itemJson.SPARK_PATH;
									getSparkCharts("hostglance_"+item,'60','16',graphData,sparkPath);
								}
							}
						}
					}
					else
					{
						me.createUI();
					}
					//Ext.getCmp('shgGridId').getStore().loadRawData(jsonData.GridInfo);
				}
			}
		});
	}
	/*,
	returnChartHTML : function(sparkXML){
		var htmlstring = '<div style="width:100%;height:15px !important;>'
			+'<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width=100% height="20" id="StackedColumn3D" >'
			+'<param name="movie" value="/final/FusionCharts/swf/SparkLine.swf" />'
			+'<param name="FlashVars" value="&dataXML='+sparkXML+'&chartWidth=100%&chartHeight=20">'
			+'<param name="quality" value="high" />'
			+'<param name="WMode" value="Transparent">'
			+'<embed wmode="transparent" src="/final/FusionCharts/swf/SparkLine.swf" flashVars="&dataXML='+sparkXML+'" quality="high" width=100% height="20" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />'
			+'</object>'
			+'</div>';
			return htmlstring;
	}*/
});

