Ext.define('VirtualDashboard.view.Summary.SummaryHealth', {
	extend: 'Ext.panel.Panel',
	alias:'widget.summaryhealthview',
	//bodyCls:'top-left-radius top-right-radius bottom-left-radius bottom-right-radius summary-health',
	url:null,
	//layout:'fit',
	//padding: '5 10 5 5',
	margin:'5 10 5 10',
	frame:false,
	border:0,
	//bodyStyle:{'background':'transparent'},
	scroll:false,
	autoScroll:false,
	padding:0,
	//cls:'panelWithoutHeader',
	data:null,
	onRender: function(){
		var me=this;
		if(!Ext.isEmpty(me.getEl())){
			me.getEl().setWidth(600);
			me.getEl().setHeight(90);
			me.getEl().mask("Loading...","maskCenter");
		}
		this.createUI();
		this.callParent();
	},

	createUI: function(){
		var me=this;
		Ext.Ajax.request({
			url : me.url,
			method : 'GET',
			scope : this,
			timeout:1280000,
			success : function(response, opts) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				delete jsonText;
				Ext.destroy(jsonText);
				jsonText = null;

				me.data=jsonData;
				//me.removeAll();

				var resultItems=me.items.items;
				for(var item=resultItems.length-1; item>-1 ; item--)
				{
					//if(resultItems[item].id!='summaryHealthGrid')
					{
						resultItems[item].destroy();
					}
				}

				//me.setTitle(jsonData.ScreenLabels.Title);				
				if(!Ext.isEmpty(jsonData.NoAlarmError)){
					var searchNoList = Ext.create('utilities.ErrorPanel',{
						bodyStyle:{'background':'transparent'},
						style:{'background':'transparent'},
						margin:'25 0 0 0',
						autoDestory:true,
						errorMsg : '<center><div class="iconNoalarms"></div><div class="list-empty-text">'+jsonData.NoAlarmError+'</div></center>'
					});
					me.add(searchNoList);
				}
				else if(!Ext.isEmpty(jsonData.GridData))
				{
					var summaryHealthGridObj=Ext.getCmp('summaryHealthGrid');
					if(!Ext.isEmpty(summaryHealthGridObj))
					{
						summaryHealthGridObj.getStore().loadRawData(jsonData.GridData.GridInfo);
						VirtualDashboard.app.getController('SummaryTab').displayAlarmPopup();
					}
					else
					{
						var healthStore=Ext.create('VirtualDashboard.store.Summary.SummaryHealth',{
							data:jsonData.GridData.GridInfo
						});
						//var healthGrid = Ext.create('utilities.CustomGrid',{
						var navTools = Ext.create('Ext.panel.Panel',{
						padding:0,
						margin:0,
						dockedItems:[{
								xtype:'toolbar',
								//style:{'background':'#e9e9e9'},
								items:[/*{
									xtype:'label',
									html:'<b>'+jsonData.ScreenLabels.Title+'</b>',
								},'->',*/'->',{
									xtype:'label',
									id: 'shGridTitleId',
									text:jsonData.GridData.GridTitle,
									padding:'0 15 0 15',
								},{
									xtype:'image',
									id: 'shPreviousId',
									action:'previous', 
									//src:'/final/images/clear.png',
									cls:'iconLeftArrow',
									style:{'cursor':'pointer'},
									listeners : {
										render : function(image, eOpts){
											var maintenanceTooltip = Ext.create('Ext.tip.ToolTip', {
												//cls : 'alarmTip',
												target : image.getId(),
												html : jsonData.GridData.PreviousAlarmTitle
											});
											image.getEl().on('click', function(){
												this.fireEvent('click', image);
											}, image);
										}						
									} 
								},{
									xtype:'image',
									id: 'shNextId',
									action:'next',
									//src:'/final/images/clear.png',
									cls:'iconTreeRightArrow',
									style:{'cursor':'pointer'},
									listeners : {
										render : function(image, eOpts){
											var maintenanceTooltip = Ext.create('Ext.tip.ToolTip', {
												//cls : 'alarmTip',
												target : image.getId(),
												html : jsonData.GridData.NextAlarmTitle
											});
											image.getEl().on('click', function(){
												this.fireEvent('click', image);
											}, image);
										}						
									} 
								}]
							}]
						});
						var healthGrid = Ext.create('Ext.grid.Panel',{
							id:'summaryHealthGrid',
							cls:'gridSkin mouse',
							overflowX:'hidden',
							margin:'3',
							frame:false,
							style:{'border':'0px solid green!important'},
							border:true,
							forceFit:false,
							autoDestory:true,
							//title:
							
							store:healthStore,
							columns:[{
								text: jsonData.GridData.GridHeaders[0].Header,
								dataIndex:'Type',
								flex:.6,
								menuDisabled :true,
								draggable:false,
								scope:this,
								renderer:function(value,metaData,record,rowIndex,colIndex){
									return '<div class="state_'+record.raw.stateIcon+'"</div><div style="margin-left:22px" id="health-grid-cell-1" class="healthinfo-left">'+value+'</div>';
								} 
							},{
								text: jsonData.GridData.GridHeaders[1].Header,
								dataIndex:'Component',
								menuDisabled :true,
								draggable:false,
								flex:.7,
								renderer:function(value,metaData,record,rowIndex,colIndex){								
									return '<div class="grid-ellipsis" id="health-grid-cell-2" style="display:inline-block;vertical-align:top;">'
									+value+'</div>';
								} 
							},{
								text: jsonData.GridData.GridHeaders[2].Header,
								dataIndex:'Description',
								menuDisabled :true,
								draggable:false,
								flex:1,
								renderer:function(value,metaData,record,rowIndex,colIndex){								
									return '<div class="grid-ellipsis" id="health-grid-cell-3" style="display:inline-block;vertical-align:top;">'
									+value+'</div>';
								} 
							},{
								text: jsonData.GridData.GridHeaders[3].Header,
								dataIndex:'StartTime',
								flex:0.7,
								menuDisabled :true,
								draggable:false,
								renderer:function(value,metaData,record,rowIndex,colIndex){								
									return '<div class="grid-ellipsis" id="health-grid-cell-4" style="display:inline-block;vertical-align:top;">'
									+value+'</div>';
								} 
							}]
						});
						
						me.add(navTools,healthGrid);
					}
				}
				if(!Ext.isEmpty(me.getEl())){
					me.getEl().unmask();
				}

				delete jsonData;
				Ext.destroy(jsonData);
				jsonData = null;
			},
			failure: function()
			{
				//alert("failure"); 
			}
		});
	},
	refreshUI: function(){
		var me=this;
		Ext.Ajax.request({
			url : me.url,
			method : 'GET',
			scope : this,
			timeout:1280000,
			success : function(response, opts) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				me.data=jsonData;
				//me.removeAll();
				if(!Ext.isEmpty(jsonData.NoAlarmError)){

					me.removeAll();

					var searchNoList = Ext.create('utilities.ErrorPanel',{
						id:'shErrId',
						bodyStyle:{'background':'transparent'},
						style:{'background':'transparent'},
						margin:'25 0 0 0',
						errorMsg : '<center><div class="iconNoalarms"></div><div class="list-empty-text">'+jsonData.NoAlarmError+'</div></center>'
					});
					me.add(searchNoList);

				}else if(!Ext.isEmpty(jsonData.GridData)){

					var shGridTitleIdObj=Ext.getCmp('shGridTitleId');
					if(!Ext.isEmpty(shGridTitleIdObj))
					{
						shGridTitleIdObj.show();
						shGridTitleIdObj.text=jsonData.GridData.GridTitle;
					}

					var shPreviousIdObj=Ext.getCmp('shPreviousId');
					if(!Ext.isEmpty(shPreviousIdObj))
					{
						shPreviousIdObj.show();
						shPreviousIdObj.listeners ={
							render : function(image, eOpts){
								var maintenanceTooltip = Ext.create('Ext.tip.ToolTip', {
									cls : 'alarmTip',
									target : image.getId(),
									html : jsonData.GridData.PreviousAlarmTitle
								});
								image.getEl().on('click', function(){
									this.fireEvent('click', image);
								}, image);
							}
						}
					}

					var shNextIdObj=Ext.getCmp('shNextId');
					if(!Ext.isEmpty(shNextIdObj))
					{
						shNextIdObj.show();
						shNextIdObj.listeners ={
							render : function(image, eOpts){
								var maintenanceTooltip = Ext.create('Ext.tip.ToolTip', {
									cls : 'alarmTip',
									target : image.getId(),
									html : jsonData.GridData.NextAlarmTitle
								});
								image.getEl().on('click', function(){
									this.fireEvent('click', image);
								}, image);
							}
						}
					}

					var summaryHealthGridObj=Ext.getCmp('summaryHealthGrid');
					if(!Ext.isEmpty(summaryHealthGridObj))
					{
						summaryHealthGridObj.show();
						summaryHealthGridObj.getStore().loadRawData(jsonData.GridData.GridInfo);
						VirtualDashboard.app.getController('SummaryTab').displayAlarmPopup();
					}
					else
					{
						me.createUI();
					}
				}
			},
			failure: function()
			{ 
				//alert("failure"); 
			}
		});
	}
});
