var stateTooltip;
var borderColor = '';
if(strSkin.toLowerCase() === "light"){
	borderColor = '1px solid #e3e3e3 !important';
}
Ext.define('VirtualDashboard.view.Summary.SummaryOverview', {
	extend: 'Ext.container.Container',
	alias:'widget.summaryoverview',
	url:null,
	layout:{type:'hbox',align:'stretch'},
	data:null,
	healthUrl:null,
	margin:0,
	padding:0,
	frame:true,
	cls:'searchTopPanel',
	
	title:'',
	requires:['VirtualDashboard.view.Summary.SummaryHealth'],
	onRender: function(){
		var me=this;
		if(!Ext.isEmpty(me.getEl())){
			me.getEl().setWidth(1100);
			me.getEl().setHeight(160);
			me.getEl().mask("Loading...","maskCenter");
		};
		this.createUI();
		this.doLayout();
		this.callParent();
	},
	mask:null,	
	createUI : function(){
		var me=this;
		/*if(!Ext.isEmpty(me.getEl())){
			me.getEl().mask("Loading...","maskCenter");
		};*/
		Ext.Ajax.request({
			url : me.url,
			method : 'GET',
			scope : this,
			timeout:1280000,
			success : function(response, opts) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				delete jsonText;
				Ext.destroy(jsonText);
				jsonText = null;

				//me.setTitle(jsonData.ScreenLabels.Title);
				//me.removeAll();

				/*var ioTitleIdObj=Ext.getCmp('soIOTitleId');
				if(!Ext.isEmpty(ioTitleIdObj))
				{
					var ioTitleIdObjItems=ioTitleIdObj.items.items;
					for(var item=ioTitleIdObjItems.length-1; item>-1 ; item--)
					{
						ioTitleIdObjItems[item].destroy();
					}
				}

				var caTitleIdObj=Ext.getCmp('soCATitleId');
				if(!Ext.isEmpty(caTitleIdObj))
				{
					var caTitleIdObjItems=caTitleIdObj.items.items;
					for(var item=caTitleIdObjItems.length-1; item>-1 ; item--)
					{
						caTitleIdObjItems[item].destroy();
					}
				}*/

				var resultItems=me.items.items;
				for(var item=resultItems.length-1; item>-1 ; item--)
				{
					//if(resultItems[item].id!='soCATitleId')
					{
						resultItems[item].remove(true);
						resultItems[item].destroy();
					}
				}

				//VirtualDashboard.app.getController('Main').updateUpperToolbarText(jsonData.ScreenLabels.Title);
				me.data=jsonData;

				if(!Ext.isEmpty(jsonData.ErrorMsg)){
					var noData = Ext.create('Ext.container.Container',{
						border:false,
						width:'100%',
						style:{'border':'0px solid red'},
						html : '<div style="text-align:center"><div class="iconInformation" style="margin:2% auto 0 auto"></div><div class="list-empty-text">'+jsonData.ErrorMsg+'</div></div>'
					});
					me.add(noData);
				}
				else if(!Ext.isEmpty(jsonData.InfrastructureItems))
				{
					var infrastructureComponentOuterContainer = Ext.create('Ext.container.Container',{
						id:'soIOTitleId',
						cls:'frameset',
						margin:'15 8 8 8',
						layout: 'hbox',
						style:{'border':borderColor,'box-shadow':'none !important'},
						autoDestory:true,
						html:'<div style="border:1px !important;" class="title"><b>'+summaryIOTitle+'</b></div>'
						}); 

					//var caTitleIdObj=Ext.getCmp('soCATitleId');
					var currentAlarmOuterContainer = null;
					//if(Ext.isEmpty(caTitleIdObj))
					{
						currentAlarmOuterContainer = Ext.create('Ext.container.Container',{
							id:'soCATitleId',
							flex:1,
							cls:'frameset',
							margin:'15 8 8 0',
							layout: 'hbox',
							style:{'border':borderColor,'box-shadow':'none !important'},
							autoDestory:true,
							html:'<div style="border:1px !important;" class="title"><b>'+summaryCATitle+'</b></div>'
						}); 
					}

					var offSetVal = -55;
					for(var item=0; item< jsonData.InfrastructureItems.length ; item++){
						var comp=jsonData.InfrastructureItems[item];
						var dyn_wid = 160;
						if (comp.text.length < 11){
							dyn_wid = 130;
							offSetVal = -90;
						}

						if(jsonData.InfrastructureItems.length == 1){
							dyn_wid = 180;
						}
						var infrastructureComponent = Ext.create('Ext.container.Container',{
							ui:'plain',
							width:dyn_wid,
							height:88,
							padding:'0 4',
							id:'soInfrastructureOverview'+item,
							cls:'fancy_border',
							layout: 'hbox',
							autoDestory:true,
							items:[{
								xtype:'label',
								margin: '37 5 0 5',
								itemId:'soInfrastructureLabel'+item,
								width:33,
								padding:0,
								html:'<div style="border:0px solid yellow;width:64px;height:65px;bottom:2px;left:10px" class="'+comp.img+'32"></div>'
								//html:'<div style="border:0px solid yellows;width:64px;height:65px" class="virtual-centers-system"></div>'
							},{
								xtype : 'button',
								//cls : 'component-list-left-component',
								style:{'position':'relative','background':'none','font-weight':'bold','font-size':'17px'},
								height : 84,
								padding:'0 5',
								flex:1,
								border : false,
								action:'display-overview',
								//id: comp.text,
								id: 'soInfraDataId'+item,
								linkUrl: comp.tabChangeParam,
								details:comp.details,
								offsetVal:offSetVal,
								html : '<div style="position:absolute;top:16px;right:0px" class="font_no">'
									+  comp.count + '</div>'
									+ '<div class="font_text" style="position:absolute;bottom:13px;right:0px">'
									+ comp.text + '</div>',
								listeners:{
									'afterrender': function(currObj){
										var tooltip= me.createServerGrid(currObj.details);
										stateTooltip = Ext.create('Ext.tip.ToolTip', {
											//target : comp.text,
											target : currObj.id,
											itemId:currObj.id+'tip',
											//ui:'whitethemes',
											anchor: 'top',
											margin:0,
											cls:'innerTooltip',
											border:0,
											style:{'border':'0px solid yellow'},
											padding:5,
											trackMouse:false,
											constrainPosition:true,
											autoDestroy:true,
											maxWidth : 500,
											minWidth : 300,
											anchorOffset:120,
											mouseOffset:[currObj.offsetVal,0],
											showDelay:0,
											layout : {
												type : 'fit'
											},
											items :  [{
													xtype:'container',
													floating:true,
													focusOnToFront:true,
													margin:'-30 0 0 0',
													html:'<div class="innerTooltipArrow" style="z-index:10000;position:absolute;border:1px solid red"></div>'},
													tooltip
											],
											listeners:{
												'show':function(){
													var itemInside = this.getLayout().getLayoutItems( )[0];
													if(itemInside.getXType() == 'customgrid'){
														tooltip.getStore().reload()
													}else{
														//console.log('Im Panel')
													}
												},
												'afterrender': function(){
													this.mon(this.el, 'mouseover', function () {
														this.clearTimer('hide');
														this.clearTimer('dismiss');
													}, this);
													this.mon(this.el, 'mouseout', function () {
														this.clearTimer('show');
														if (this.autoHide !== false) {
															this.delayHide();
														}
													}, this);
												}
											}
										});
										
									}
								}
							}]
						});
						
						infrastructureComponentOuterContainer.add(infrastructureComponent);
					}

					me.add(infrastructureComponentOuterContainer);

					if(!Ext.isEmpty(jsonData.InfrastructureItems)){
					if(jsonData.InfrastructureItems.length > 0){
						var last = jsonData.InfrastructureItems.length -1;
						Ext.getCmp('soInfrastructureOverview0').addCls('first');
						Ext.getCmp('soInfrastructureOverview'+last).addCls('last');
						}else if (jsonData.InfrastructureItems.length -1  == 0)
						{
							Ext.getCmp('soInfrastructureOverview0').addCls('first');
						}
					}

					var shvIdObj=Ext.getCmp('shvId');
					if(!Ext.isEmpty(shvIdObj))
					{
						flg=false;
						shvIdObj.url=me.healthUrl;
						//shvIdObj.refreshUI();
						shvIdObj.createUI();
					}
					else if(!Ext.isEmpty(currentAlarmOuterContainer))
					{
						var summaryHealthPanel= {
								xtype:'summaryhealthview',
								id:'shvId',
								autoDestory:true,
								url: me.healthUrl,
								minWidth:360,
								//height:80,
								flex:1
						};

						currentAlarmOuterContainer.add(summaryHealthPanel);
						me.add(currentAlarmOuterContainer);
					}
				}
				if(!Ext.isEmpty(me.getEl())){
					me.getEl().unmask();
				}

				delete jsonData;
				Ext.destroy(jsonData);
				jsonData = null;
			}
		});
	},
	refreshUI : function(){
		var me=this;
		Ext.Ajax.request({
			url : me.url,
			method : 'GET',
			scope : this,
			timeout:1280000,
			success : function(response, opts) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				//alert("jsonData--->"+jsonData);
				//me.removeAll();

				me.data=jsonData;

				if(!Ext.isEmpty(jsonData.ErrorMsg)){

					//me.removeAll();
					var resultItems=me.items.items;
					for(var item=resultItems.length-1; item>-1 ; item--)
					{
						resultItems[item].destroy();
					}

					var noData = Ext.create('Ext.container.Container',{
						border:false,
						width:'100%',
						style:{'border':'0px solid red'},
						html : '<div style="text-align:center"><div class="iconInformation" style="margin:2% auto 0 auto"></div><div class="list-empty-text">'+jsonData.ErrorMsg+'</div></div>'
					});
					me.add(noData);

				}
				else if(!Ext.isEmpty(jsonData.InfrastructureItems))
				{
					var flg=true;
					var ioTitleIdObj=Ext.getCmp('soIOTitleId');
					if(!Ext.isEmpty(ioTitleIdObj))
					{
						flg=false;
						//ioTitleIdObj.cls='frameset';
						//ioTitleIdObj.margin='15 10 10 10';
						//ioTitleIdObj.update('<div class="title"><b>'+summaryIOTitle+'</b></div>');
					}

					var caTitleIdObj=Ext.getCmp('soCATitleId');
					if(!Ext.isEmpty(caTitleIdObj))
					{
						flg=false;
						//caTitleIdObj.update('<div class="title"><b>'+summaryCATitle+'</b></div>');
					}

					for(var item=0; item< jsonData.InfrastructureItems.length ; item++)
					{
						var comp=jsonData.InfrastructureItems[item];
						
						var InfrastructureObj=Ext.getCmp('soInfrastructureOverview'+item);
						if(!Ext.isEmpty(InfrastructureObj))
						{
							//InfrastructureObj.layout='hbox';
							//InfrastructureObj.width=160;
							//InfrastructureObj.height=91;
						}

						var islIdObj=Ext.getCmp('soInfrastructureLabel'+item);
						if(!Ext.isEmpty(islIdObj))
						{
							//islIdObj.margin='50 5 0 5';
							//islIdObj.padding=0;
							
							islIdObj.update('<div style="border:0px solid yellow;width:64px;height:65px;bottom:2px;left:10px" class="'+comp.img+'32"></div>');
						}

						var infraDataIdObj=Ext.getCmp('soInfraDataId'+item);
						
						if(!Ext.isEmpty(infraDataIdObj))
						{
							flg=false;
							var tipObj=null;
							try
							{
								tipObj=Ext.getComponent('soInfraDataId'+item+'tip');
							}
							catch(e)
							{
								tipObj=Ext.getCmp('soInfraDataId'+item+'tip');
							}

							if(!Ext.isEmpty(tipObj))
							{
								tipObj.destroy();
								tipObj = null;
							}
							
							infraDataIdObj.details=comp.details;
							infraDataIdObj.linkUrl=comp.tabChangeParam;
							Ext.get(infraDataIdObj.id).select('.font_no').update(comp.count);
							Ext.get(infraDataIdObj.id).select('.font_text').update(comp.text);
							
							//infraDataIdObj.doComponentLayout();
							//infraDataIdObj.removeListener( infraDataIdObj.getEl(), 'afterrender');
							infraDataIdObj.fireEvent('afterrender',infraDataIdObj);
							
						}
					}

					if(!Ext.isEmpty(jsonData.InfrastructureItems)){
						if(jsonData.InfrastructureItems.length > 0)
						{
							var last = jsonData.InfrastructureItems.length -1;
							Ext.getCmp('soInfrastructureOverview0').addCls('first');
							Ext.getCmp('soInfrastructureOverview'+last).addCls('last');
						}
						else if (jsonData.InfrastructureItems.length -1  == 0)
						{
							Ext.getCmp('soInfrastructureOverview0').addCls('first');
						}
					}
					
					var shvIdObj=Ext.getCmp('shvId');
					if(!Ext.isEmpty(shvIdObj))
					{
						flg=false;
						shvIdObj.url=me.healthUrl;
						shvIdObj.refreshUI();
					}

					if(flg)
					{
						me.createUI();
					}
				}
			}
		});
	},
	createServerGrid :  function(jsonData){
		if(Ext.isEmpty(jsonData.NoDetails)){
			var columns = new Array();
			var infoStore=Ext.create('VirtualDashboard.store.Summary.OverviewInfo',{
				data:jsonData.Details
			});
			if(jsonData.id==="Physical Servers"){			
				columns.push({
					text:jsonData.Headers[0].Header,
					dataIndex:'Component',
					width:80,
					menuDisabled :true
				},{
					text:jsonData.Headers[1].Header,
					dataIndex:'PhysicalServer',
					flex:1,
					menuDisabled :true
				});
			}
			else if(jsonData.id==="Total VMs-VmsinVC" || jsonData.id==="Powered On VMs-VmsinVC" || jsonData.id==="Status-VmsinVC"){
				columns.push({
					text:jsonData.Headers[0].Header,
					dataIndex:'Component',
					menuDisabled :true
				},{
					text:jsonData.Headers[1].Header,
					dataIndex:'HostIP',
					menuDisabled :true
				},{
					text:jsonData.Headers[2].Header,
					dataIndex:'VirtualMachine',
					menuDisabled :true
				}
				);
			}
			else if(jsonData.id==="Total VMs" || jsonData.id==="Powered on VMs" || jsonData.id==="Powered On VMs" || jsonData.id==="Status" || jsonData.id.indexOf("Clusters")>-1 || jsonData.id==="DataStore" || jsonData.id==="Datastore"){
				columns.push({
					text:jsonData.Headers[0].Header,
					dataIndex:'Component',
					flex:.6,
					menuDisabled :true
				},{
					text:jsonData.Headers[1].Header,
					dataIndex:'Details',
					flex:1,
					menuDisabled :true
				});
			}
			else if(jsonData.id==="Datacenters"){
				columns.push({
					text:jsonData.Headers[0].Header,
					dataIndex:'Details',
					menuDisabled :true
				});
			}
			var infoGrid= Ext.create('utilities.CustomGrid',{
				border:false,
				scroll:true,
				autoScroll:false,
				maxHeight:300,				
				cls:'gridSkin',
				needtoFixColumn:true,
				style:{'overflow-x':'hidden','border':'0px solid red'},
				store:infoStore,
				columns: columns,
				width:'auto',
				//width:290,
				//forceFit:true
   
			});
			return infoGrid;
		}
		else{
			var infoPanel = Ext.create('Ext.panel.Panel',{
				border:false,
				cls:'overview-nodetail',
				padding:'8',
				html: '<div style="text-align:center"><div class="iconInformation" style="margin:0px auto"></div><div>'+jsonData.NoDetails+'</div></div>'
			});
			return infoPanel;
		}
	}
});
