Ext.define('VirtualDashboard.view.Summary.VMGlance', {
	extend: 'Ext.panel.Panel',
	alias:'widget.vmglance',
	url:null,
	flex:1,
	realUrl:null,
	layout:{type:'vbox',align:'stretch'},
	border:false,
	//cls:'panelWithoutHeader',
	cls:'datapanel',
	margin:'8 8 8 0',
	frame:true,
	scroll:true,
	autoScroll:false,
	padding:0,
	//height:'100%',
	data: null,
	//title:vmGlanceTitle,
	title:'',
	id:'vmGlanceId',
	onRender: function(){
		var me=this;
		if(!Ext.isEmpty(me.getEl())){
			
			me.getEl().setWidth(600);
			me.getEl().setHeight(160);
			me.getEl().mask("Loading...","maskCenter");
		}
		this.createUI();		
		this.callParent();
	},
	
	createUI: function(){
		var me=this;
		var temp_url=me.url+"&monCmdComeFrom=vmdashboard";
		Ext.Ajax.request({
			url :temp_url+"&isOnlyVmCase="+isOnlyVmCase,
			method : 'GET',
			scope : this,
			timeout:1280000,
			success : function(response, opts) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				me.data=jsonData;
				var titFlage=true;
				me.removeAll();
				if(!Ext.isEmpty(jsonData.VMCombo)){
					var comboStore = Ext.create('Ext.data.Store',{
						fields:['name','value'],
						proxy:{
							type: 'memory',
							reader: {
								type: 'json',
								root:'items'
							}
						},
						data:jsonData.VMCombo
					});

					if(!Ext.isEmpty(jsonData.VMCombo.items)){
						var VMCombo={
							xtype:'container',
							height:28,
							cls:'header_con',
							
							border:true,
							items:[{
								xtype:'combo',
								id:'vmComboId',
								labelSeparator:'',
								editable : false,
								padding:'3 10 0 10',
								//labelWidth:'',
								width:250,
								labelWidth:72,
								store:comboStore,				
								cls : 'dropdown',
								displayField:'name',
								valueField:'value',
								fieldLabel:jsonData.VMCombo.label,
								action: jsonData.VMCombo.name,
								value: jsonData.VMCombo.selectvalue ? jsonData.VMCombo.selectvalue : jsonData.VMCombo.items[0].value
						}]
						};
						titFlage=false;
						me.add(VMCombo);
					}
				}
				/*var glancePanel= Ext.create('Ext.container.Container',{
					width:'100%',
					layout:'fit',
					cls:'block1',
					scroll:false,
					autoScroll:false,
					//flex:1,	
					//bodyCls:'bottom-left-radius bottom-right-radius',
					dockedItems:[{
						xtype:'toolbar',
						items:[{
							xtype:'label',
							flex:1,
							text:jsonData.GridHeaders[0].Header
						},{
							xtype:'panel',
							height:21,
							width:1,
							style:'border-left: 5px solid #ABACAE;border-right: 1px solid #DBDBDB; !important;'
						},{
							xtype:'label',
							flex:1,
							text:jsonData.GridHeaders[2].Header+jsonData.GridHeaders[2].UnitForHeader
						},{
							xtype:'panel',
							height:21,
							width:1,
							style:'border-left: 1px solid #ABACAE;border-right: 1px solid #DBDBDB; !important;'
						},{
							xtype:'label',
							flex:1,
							text:jsonData.GridHeaders[1].Header
						}]					
					}]
				});*/
				
				if(!Ext.isEmpty(jsonData.NoDataError)){
					var noData = Ext.create('utilities.ErrorPanel',{
						id:'svgErrId',
						border:false,
						margin:'25% 0 0 0',
						errorMsg : '<center><div style="text-align:center;margin-top:40px"><div class="iconInformation" style="margin:0px auto"></div><div>'+jsonData.NoDataError+'</div></div></center>'							
					});

					if(titFlage)
					{
						me.setTitle(vmGlanceTitle? vmGlanceTitle : "");
					}

					me.add(noData);
				}
				else if(!Ext.isEmpty(jsonData.GridInfo)){
					var glanceStore=Ext.create('VirtualDashboard.store.Summary.Glance',{
						data:jsonData.GridInfo
					});

					//var glanceGrid = Ext.create('utilities.CustomGrid',{
					var glanceGrid = Ext.create('Ext.grid.Panel',{
						//hideHeaders : true,
						id:'svgGridId',
						cls:'gridSkin vmgrid',
						overflowX:'hidden',
						scroll:true,
						autoScroll:true,
						border:false,
						flex:1,
						store:glanceStore,
						columns:[{
							text:jsonData.GridHeaders[0].Header,
							dataIndex:'ComponentName',
							flex:.7,
							menuDisabled :true,
							draggable:false,
							scope:this,
							renderer:function(value,metaData,record,rowIndex,colIndex){
								return '<a href="'+record.raw.ComponentLink+'">'+value+'</a>';
							}
						},{
							text:jsonData.GridHeaders[2].Header+jsonData.GridHeaders[2].UnitForHeader,
							dataIndex:'Value',
							menuDisabled :true,
							draggable:false,
							flex:.3
						},{
							text:graph,
							dataIndex:'graphDataXml',
							menuDisabled :true,
							draggable:false,
							//flex:.8,
							renderer:function(value,metaData,record,rowIndex,colIndex){
								var graphData = record.get("graphDataXml");
								if(!Ext.isEmpty(graphData) && graphData!='-'){
									//var htmlDisp =me.returnChartHTML(record.get("graphDataXml"));
									//return '<div style="height:20px">'+htmlDisp+'</div>';
									return '<div id="VmGlance_graphDataXml_'+rowIndex+'" style="height:15px;margin-top:2px;" class="measure_count handSymbol"></div>';
								}else{
									return '-';
								}
							}
						}],
						listeners:{
						 'viewready': function(){
								var itemsArray=jsonData.GridInfo;
								if(!Ext.isEmpty(itemsArray))
								{
									for(var item=0; item< itemsArray.length ; item++)
									{
										var itemJson=itemsArray[item];
										var graphData = itemJson.graphDataXml;
										if ( !Ext.isEmpty(graphData) && graphData != '-' )
										{
											var sparkPath = itemJson.SPARK_PATH;
											getSparkCharts("VmGlance_graphDataXml_"+item,'80','16',graphData,sparkPath);
										}
									}
								}
							},
							'sortchange':function(ct, column, direction, eOpts){
								var itemsArray=jsonData.GridInfo;
								//console.log("--direction---",direction);
								if(!Ext.isEmpty(itemsArray) && direction=='DESC')
								{
									for(var item=0; item< itemsArray.length ; item++)
									{
										var itemJson=itemsArray[item];
										var graphData = itemJson.graphDataXml;
										if( !Ext.isEmpty(graphData) && graphData!='-' )
										{
											var sparkPath = itemJson.SPARK_PATH;
											getSparkCharts("VmGlance_graphDataXml_"+item,'80','16',graphData,sparkPath);
										}
									}
								}
								else if(!Ext.isEmpty(itemsArray) && direction=='ASC')
								{
									var incr=0;
									for(var item=itemsArray.length-1; item>=0  ; item--)
									{
										var itemJson=itemsArray[item];
										var graphData = itemJson.graphDataXml;
										if( !Ext.isEmpty(graphData) && graphData!='-' )
										{
											var sparkPath = itemJson.SPARK_PATH;
											getSparkCharts("VmGlance_graphDataXml_"+incr,'80','16',graphData,sparkPath);
											incr++;
										}
									}
								}
							}
						}
					});
					me.add(glanceGrid);
					me.doComponentLayout();
				}
				
				//me.add(glancePanel);
				if(!Ext.isEmpty(me.getEl())){
					me.getEl().unmask();
				}
			}
		});
	},
	refreshUI: function(){
		var me=this;
		Ext.Ajax.request({
			url : me.url,
			method : 'GET',
			scope : this,
			timeout:1280000,
			success : function(response, opts) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				me.data=jsonData;
				var titFlage=true;
				if(!Ext.isEmpty(jsonData.VMCombo))
				{
					var vmComboIdObj=Ext.getCmp('vmComboId');
					if(!Ext.isEmpty(vmComboIdObj))
					{
						if(!Ext.isEmpty(jsonData.VMCombo.items))
						{
							vmComboIdObj.show();

							vmComboIdObj.getStore().loadRawData(jsonData.VMCombo);
							vmComboIdObj.setValue(jsonData.VMCombo.selectvalue ? jsonData.VMCombo.selectvalue : jsonData.VMCombo.items[0].value);
							titFlage=false;
						}
					}
				}

				if(!Ext.isEmpty(jsonData.NoDataError)){

					if(titFlage)
					{
						//me.removeAll();
						var resultItems=me.items.items;
						for(var item=resultItems.length-1; item>-1 ; item--)
						{
							resultItems[item].destroy();
						}
					}
					else
					{
						var resultItems=me.items.items;
						for(var item=resultItems.length-1; item>-1 ; item--)
						{
							if(resultItems[item].id=='svgErrId')
							{
								resultItems[item].destroy();
							}
						}
					}

					var noData = Ext.create('utilities.ErrorPanel',{
						id:'svgErrId',
						border:false,
						errorMsg : '<center><div style="text-align:center;margin-top:40px"><div class="iconInformation" style="margin:0px auto"></div><div>'+jsonData.NoDataError+'</div></div></center>'
					});

					me.add(noData);

					if(titFlage)
					{
						me.setTitle(vmGlanceTitle? vmGlanceTitle : "");
					}
				}
				else if(!Ext.isEmpty(jsonData.GridInfo)){

					var svgErrIdObj=Ext.getCmp('svgErrId');
					if(!Ext.isEmpty(svgErrIdObj))
					{
						me.remove(svgErrIdObj);
					}

					var svgGridIdObj=Ext.getCmp('svgGridId');
					if(!Ext.isEmpty(svgGridIdObj))
					{
						svgGridIdObj.show();
						svgGridIdObj.getStore().loadRawData(jsonData.GridInfo);
						var itemsArray=jsonData.GridInfo;
						if(!Ext.isEmpty(itemsArray))
						{
							for(var item=0; item< itemsArray.length ; item++)
							{
								var itemJson=itemsArray[item];
								var graphData = itemJson.graphDataXml;
								if ( !Ext.isEmpty(graphData) && graphData != '-' )
								{
									var sparkPath = itemJson.SPARK_PATH;
									getSparkCharts("VmGlance_graphDataXml_"+item,'80','15',graphData,sparkPath);
								}
							}
						}
					}
					else
					{
						me.createUI();
					}
					//Ext.getCmp('svgGridId').getStore().loadRawData(jsonData.GridInfo);
				}
			}
		});
	}
	/*,
	returnChartHTML : function(sparkXML){
		var htmlstring = '<div style=" width:100%; height:20px">'
			+'<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width=100% height="20" id="StackedColumn3D" >'
			+'<param name="movie" value="/final/FusionCharts/swf/SparkLine.swf" />'
			+'<param name="FlashVars" value="&dataXML='+sparkXML+'&chartWidth=100%&chartHeight=20">'
			+'<param name="quality" value="high" />'
			+'<param name="WMode" value="Transparent">'
			+'<embed wmode="transparent" src="/final/FusionCharts/swf/SparkLine.swf" flashVars="&dataXML='+sparkXML+'" quality="high" width=100% height="20" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />'
			+'</object>'
			+'</div>';
			return htmlstring;
	}*/
});
