Ext.define('VirtualDashboard.view.Summary.VMStatus', {
	extend: 'Ext.panel.Panel',
	alias:'widget.vmstatus',
	//bodyCls:'bottom-left-radius bottom-right-radius summary-grids',
	url:null,
	realUrl:null,
	cls:'datapanel',
	layout:{type:'vbox',align:'stretch'},
	margin:'0 8 0 0',
	border:false,
	frame:true,
	scroll:false,
	autoScroll:false,
	padding:0,
	high:new Array(),
	intermediate:new Array(),
	low:new Array(),
	vmGrid:[],
	rows:0,
	countH:0,
	countI:0,
	//height:160,
	countL:0,
	title:vmStatusTitle,
	onRender: function(){
		var me=this;
		if(!Ext.isEmpty(me.getEl())){		
			me.getEl().setWidth(600);
			me.getEl().setHeight(160);
			me.getEl().mask("Loading...","maskCenter");
		}
		this.createUI();
		this.callParent();
	},
	
	createUI : function(){
		var me=this;
		var temp_url=me.url+"&monCmdComeFrom=vmdashboard";
		Ext.Ajax.request({
			url : temp_url+"&isOnlyVmCase="+isOnlyVmCase,
			method : 'GET',
			scope : this,
			timeout:1280000,
			success : function(response, opts) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				delete jsonText;
				Ext.destroy(jsonText);
				jsonText = null;

				/*me.addDocked({
					xtype:'toolbar',
					items:[{
						xtype:'label',
						flex:2,
						text:jsonData.ScreenLabels[0].Header
					},{
						xtype:'panel',
						height:21,
						width:1,
						style:'margin-left:1px !important;border-left: 1px solid #ABACAE;border-right: 1px solid #DBDBDB; !important;'
					},{
						xtype:'label',
						flex:1,
						text:jsonData.ScreenLabels[1].Header
					}]					
				});*/

				var resultItems=me.items.items;
				for(var item=resultItems.length-1; item>-1 ; item--)
				{
					//if(resultItems[item].id!='summaryVMStatusGrid')
					{
						resultItems[item].destroy();
					}
				}

				if(!Ext.isEmpty(jsonData.NoAlarmError)){
					var noAlarm = Ext.create('utilities.ErrorPanel',{
						id:'summaryVMStatusErrId',
						flex:1,
						margin:'50% 0 0 0',
						border:false,
						errorMsg : '<center><div style="text-align:center;margin-top:20px"><div class="iconNoalarms" style="margin:0px auto"></div><div>'+jsonData.NoAlarmError+'</div></div></center>'
					});
					me.add(noAlarm);
				}
				else
				{
					var summaryVMStatusGridObj=Ext.getCmp('summaryVMStatusGrid');
					if(!Ext.isEmpty(summaryVMStatusGridObj))
					{
						summaryVMStatusGridObj.getStore().loadRawData(jsonData.GridInfo);
						VirtualDashboard.app.getController('SummaryTab').displayVMStatusPopup();
					}
					else
					{
						var statusStore=Ext.create('VirtualDashboard.store.Summary.Status',{
							data:jsonData.GridInfo,
							autoDestory:true,
						});
						this.vmGrid = [];
						this.rows = 0;
						//var statusGrid = Ext.create('utilities.CustomGrid',{
						var statusGrid = Ext.create('Ext.grid.Panel',{
							//hideHeaders : true,
							border:false,
							id:'summaryVMStatusGrid',
							style:{'border-color':'#adadad!important','border-width':'1px 0px 0px 0px !important','border-style':'solid','box-shadow':'none','-webkit-box-shadow':'none'},
							cls:'gridSkin',
							style:{'overflow-x':'hidden'},
							forceFit:false,
							overflowX:'hidden',
							scroll:true,
							autoScroll:false,
							autoDestory:true,
							height:'100%',
							flex:1,
							cls:'gridSkin',						
							//bodyCls:'bottom-left-radius bottom-right-radius',
							store:statusStore,
							 listeners:{
								'sortchange': function(){
									try
									{
										VirtualDashboard.app.getController('SummaryTab').displayVMStatusPopup();
									}
									catch (e)
									{
									}
									
								}
							},
							columns:[{
								text:jsonData.ScreenLabels[0].Header,
								dataIndex:'ComponentName',
								draggable:false,
								flex:4,
								menuDisabled :true,
								sortable: true,
								scope:this,
								renderer:function(value,metaData,record,rowIndex,colIndex){
									return '<div style="width:100%;"><a href="'+record.raw.ComponentLink+'">'+value+'</a></div>';
								}
							},{
								header:alarmCount,
								menuDisabled: true,
								draggable:false,
								resizable: true,
								sortable: true,
								flex:2,
								renderer:function(value,metaData,record,rowIndex,colIndex){
									return (parseInt(record.raw.HighComponent) + parseInt(record.raw.IntermediateComponent) + parseInt(record.raw.LowComponent));
								}
							},{
								text:jsonData.ScreenLabels[1].Header,
								dataIndex:'CurrentAlarm',
								menuDisabled :true,
								draggable:false,
								sortable: false,
								flex:5,
								scope:this,
								renderer:function(value,metaData,record,rowIndex,colIndex){
									var htmlStr='<div style="display:inline-block;padding:2px 8px 0px 4px;width:100%;margin-bottom:-3px"><div style="width:100%;" class="outer12 mouse">';
									this.rows+=1;
									var isHigh = false;
									var isIntermediate = false;
									var isLow = false;
									var parts = 0;
									if(!Ext.isEmpty(record.raw.HighComponent) && record.raw.HighComponent != '0' && record.raw.HighComponent != 0){
										parts++;
										isHigh = true;
									}
									if(!Ext.isEmpty(record.raw.IntermediateComponent) && record.raw.IntermediateComponent != '0' && record.raw.IntermediateComponent != 0){
										parts++;
										isIntermediate = true;
									}
									if(!Ext.isEmpty(record.raw.LowComponent) && record.raw.LowComponent != '0' && record.raw.LowComponent != 0){
										parts++;
										isLow = true;
									}

									var highId = 'v_high-comp_'+this.rows;
									var intermediateId = 'v_intermediate-comp_'+this.rows;
									var lowId = 'v_low-comp_'+this.rows;

									var highClass = '';
									var intermediateClass = '';
									var lowClass = '';

									if(isHigh && isLow){
										highClass = 'innerLeft12';
										intermediateClass = 'innerMid12';
										lowClass = 'innerRight12';
									}
									else if(!isHigh && isIntermediate && isLow){
										intermediateClass = 'innerLeft12';
										lowClass = 'innerRight12';
									}
									else if(isHigh && isIntermediate && !isLow){
										highClass = 'innerLeft12';
										intermediateClass = 'innerRight12';
									}
									else if(isHigh && !isIntermediate && !isLow){
										highClass = 'innerLeftRight12';
									}
									else if(!isHigh && isIntermediate && !isLow){
										intermediateClass = 'innerLeftRight12';
									}
									else if(!isHigh && !isIntermediate && isLow){
										lowClass = 'innerLeftRight12';
									}

									var eachWidth = parseInt(100/parts);

									if(!Ext.isEmpty(record.raw.HighComponentDetails)){
										this.countH+=1;
										htmlStr += '<div id="'+highId+'" style="width:'+eachWidth+'%;" class="HIGH_bg '+highClass+'">'+record.raw.HighComponent+'</div>';
										this.high[this.countH]=record.raw.HighComponentDetails;
										var obj = new Object();
										obj.name='high';
										obj.id=highId;
										obj.details=record.raw.HighComponentDetails;
										this.vmGrid.push(obj);
									}
									if(!Ext.isEmpty(record.raw.IntermediateComponentDetails)){
										this.countI+=1;
										htmlStr += '<div id="'+intermediateId+'" style="width:'+eachWidth+'%;" class="INTERMEDIATE_bg '+intermediateClass+'">'+record.raw.IntermediateComponent+'</div>';
										this.intermediate[this.countI]=record.raw.IntermediateComponentDetails;
										var obj = new Object();
										obj.name='intermediate';
										obj.id=intermediateId;
										obj.details=record.raw.IntermediateComponentDetails;
										this.vmGrid.push(obj);
									}
									if(!Ext.isEmpty(record.raw.LowComponentDetails)){
										this.countL+=1;
										htmlStr += '<div id="'+lowId+'" style="width:'+eachWidth+'%;" class="LOW_bg '+lowClass+'">'+record.raw.LowComponent+'</div>';
										this.low[this.countL]=record.raw.LowComponentDetails;
										var obj = new Object();
										obj.name='low';
										obj.id=lowId;
										obj.details=record.raw.LowComponentDetails;
										this.vmGrid.push(obj);
									}
									htmlStr += '</div></div>';
									return htmlStr;
								}
							}]
						});
						
						me.add(statusGrid);
					}
				}
				if(!Ext.isEmpty(me.getEl())){
					me.getEl().unmask();
				}

				delete jsonData;
				Ext.destroy(jsonData);
				jsonData = null;
			}
		});
	},
	refreshUI : function(){
		var me=this;
		Ext.Ajax.request({
			url : me.url,
			method : 'GET',
			scope : this,
			timeout:1280000,
			success : function(response, opts) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				if(!Ext.isEmpty(jsonData.NoAlarmError)){

					me.removeAll();

					var noAlarm = Ext.create('utilities.ErrorPanel',{
						id:'summaryVMStatusErrId',
						margin:'0 0 0 0',
						border:false,
						errorMsg : '<center><div style="text-align:center;margin-top:20px"><div class="iconInformation" style="margin:0px auto"></div><div>'+jsonData.NoAlarmError+'</div></div></center>'
					});
					me.add(noAlarm);
				}
				else{

					var summaryVMStatusErrIdObj=Ext.getCmp('summaryVMStatusErrId');
					if(!Ext.isEmpty(summaryVMStatusErrIdObj))
					{
						me.remove(summaryVMStatusErrIdObj);
					}

					var summaryVMStatusGridObj=Ext.getCmp('summaryVMStatusGrid');
					if(!Ext.isEmpty(summaryVMStatusGridObj))
					{
						summaryVMStatusGridObj.show();
						summaryVMStatusGridObj.getStore().loadRawData(jsonData.GridInfo);
						VirtualDashboard.app.getController('SummaryTab').displayVMStatusPopup();
					}
					else
					{
						me.createUI();
					}
				}
			}
		});
	},
	returnChartHTML : function(high,intermediate,low,rowNo){
		var htmlstring='<div><li id="v_high-comp_'+rowNo+'" style="float:left;text-align:center;width:25px;height:18px;" class="highStateComponent">'+high
		+'<li id="v_intermediate-comp_'+rowNo+'" style="float:left;text-align:center;width:25px;height:18px;" class="intermediateStateComponent">'+intermediate
		+'<li id="v_low-comp_'+rowNo+'" style="float:left;text-align:center;width:25px;height:18px;" class="lowStateComponent">'+low+'</div>';
		return htmlstring;
	}
});