var borderColor = '';
if(strSkin.toLowerCase() === "light"){
	borderColor = '1px solid #e3e3e3 !important';
}
Ext.define('VirtualDashboard.view.SummaryTab', {
	extend: 'Ext.panel.Panel',
	alias:'widget.summarytab',
	border:false,
	url:null,
	mask:null,
	data:null,
	padding:0,
	margin:0,
	layout:{type:'vbox',align:'stretch'},
	requires: ['VirtualDashboard.view.Summary.SummaryOverview','VirtualDashboard.view.Summary.HostStatus','VirtualDashboard.view.Summary.HostGlance','VirtualDashboard.view.Summary.VMStatus','VirtualDashboard.view.Summary.VMGlance'],
	createTabUI : function(url){
		var me = this;
		//me.removeAll();

		Ext.Ajax.request({
			url : url+"&isOnlyVmCase="+isOnlyVmCase,
			method : 'GET',
			scope : this,
			timeout:280000,
			success : function(response, opts) {
				var jsonText = null;
				jsonText = response.responseText;
				var jsonData = null;
				jsonData = Ext.decode(jsonText);

				delete jsonText;
				Ext.destroy(jsonText);
				jsonText = null;

				var resultItems=me.items.items;
				for(var item=resultItems.length-1; item>-1 ; item--)
				{
					resultItems[item].remove(true);
					resultItems[item].destroy();
				}

				me.removeAll();

				me.data=jsonData;
				me.url=url;
				var type = (requestParams.nodeName!='') ? requestParams.nodeName : VirtualDashboard.app.getController('Main').selectedComponent;
				
				var compType=Ext.getCmp('cmpTypeID').getValue();
				if(!Ext.isEmpty(compType) && compType!=undefined  && compType!=null && compType!=type)
					type=compType;

				var types="";
				if(!Ext.isEmpty(type))
				{
					types=type.split("$cap$");
					if((type.indexOf("ZONE$cap$")>-1) && types.length<=2)
					{
						type=type+"$cap$"+VirtualDashboard.app.getController('Main').selectedComponent;
					}
				}
				if(type.indexOf("^") != -1)
					type = type.ReplaceAll('^','$cap$');
				var upperPanel = Ext.create('Ext.container.Container',{
					layout: 'fit',
					height:112,
					id:'upperPanelId',
					items: [{
						xtype:'summaryoverview',
						id:'summaryOverviewId',
						url:'/final/monitor/summaryOverview.jsp?user=yes&type='+type,
						healthUrl: jsonData.SummaryHealthUrl
					}]
				});
				me.add(upperPanel);
				
				var middlePanel = Ext.create('Ext.container.Container',{
					layout:{type:'hbox',align:'stretch'},
					flex:5,
					id:'middlePanelId',
					items:[{
						xtype:'hoststatus',
						id:'hostStatusId',
						style:{'border':borderColor},
						flex:1,
						url:'/final/monitor/hostStatus.jsp?user=yes&type='+type,
						realUrl:'/final/monitor/hostStatus.jsp?user=yes&type='+type
					},{
						xtype:'vmstatus',
						id:'vmStatusId',
						style:{'border':borderColor},
						flex:1,
						url:'/final/monitor/vmStatus.jsp?user=yes&type='+type,
						realUrl:'/final/monitor/vmStatus.jsp?user=yes&type='+type
					}]
				});
				me.add(middlePanel);
				
				var lowerPanel = Ext.create('Ext.container.Container',{
					layout:{type:'hbox',align:'stretch'},
					flex:5,
					id:'lowerPanelId',
					items:[{
						xtype:'hostglance',
						id:'hostGlanceId',
						style:{'border':borderColor},
						flex:1,
						url:'/final/monitor/hostGlance.jsp?user=yes&type='+type,
						realUrl:'/final/monitor/hostGlance.jsp?user=yes&type='+type
					},{
						xtype:'vmglance',
						id:'vmGlanceId',
						style:{'border':borderColor},
						flex:1,
						url:'/final/monitor/vmGlance.jsp?user=yes&type='+type,
						realUrl:'/final/monitor/vmGlance.jsp?user=yes&type='+type
					}]
				});
				me.add(lowerPanel);

				if(!Ext.isEmpty(me.mask)){
					me.mask.hide();
				}

				delete jsonData;
				Ext.destroy(jsonData);
				jsonData = null;
			},
			failure:function(){
				//alert('failure')
			}
		});
	},
	createTabUIForRefresh : function(url){
		var me = this;
		//me.removeAll();
		Ext.Ajax.request({
			url : url,
			method : 'GET',
			scope : this,
			timeout:280000,
			success : function(response, opts) {
				var jsonText = null;
				jsonText = response.responseText;

				var jsonData = null;
				jsonData = Ext.decode(jsonText);
				
				delete jsonText;
				Ext.destroy(jsonText);
				jsonText = null;

				me.data=jsonData;
				me.url=url;
				var type = (requestParams.nodeName!='') ? requestParams.nodeName : VirtualDashboard.app.getController('Main').selectedComponent;
				
				var compType=Ext.getCmp('cmpTypeID').getValue();
				if(!Ext.isEmpty(compType) && compType!=undefined  && compType!=null && compType!=type)
					type=compType;

				var types="";
				if(!Ext.isEmpty(type))
				{
					types=type.split("^");
					if((type.indexOf("ZONE^")>-1) && types.length<=2)
					{
						type=type+"^"+VirtualDashboard.app.getController('Main').selectedComponent;
					}
				}

				if(type.indexOf("^") != -1)
					type = type.ReplaceAll('^','$cap$');
				var upperPanelIdObj=Ext.getCmp('upperPanelId');
				if(!Ext.isEmpty(upperPanelIdObj))
				{
					var summaryOverviewIdObj=Ext.getCmp('summaryOverviewId');
					if(!Ext.isEmpty(summaryOverviewIdObj))
					{
						summaryOverviewIdObj.url='/final/monitor/summaryOverview.jsp?user=yes&type='+type;
						summaryOverviewIdObj.healthUrl=jsonData.SummaryHealthUrl;
						//summaryOverviewIdObj.refreshUI();
						summaryOverviewIdObj.createUI();
					}
				}

				var middlePanelIdObj=Ext.getCmp('middlePanelId');
				if(!Ext.isEmpty(middlePanelIdObj))
				{
					var hostStatusIdObj=Ext.getCmp('hostStatusId');
					if(!Ext.isEmpty(hostStatusIdObj))
					{
						hostStatusIdObj.url='/final/monitor/hostStatus.jsp?user=yes&type='+type;
						hostStatusIdObj.realUrl='/final/monitor/hostStatus.jsp?user=yes&type='+type;
						//hostStatusIdObj.refreshUI();
						hostStatusIdObj.createUI();
					}

					var vmStatusIdObj=Ext.getCmp('vmStatusId');
					if(!Ext.isEmpty(vmStatusIdObj))
					{
						vmStatusIdObj.url='/final/monitor/vmStatus.jsp?user=yes&type='+type;
						vmStatusIdObj.realUrl='/final/monitor/vmStatus.jsp?user=yes&type='+type;
						//vmStatusIdObj.refreshUI();
						vmStatusIdObj.createUI();
					}
				}

				var lowerPanelIdObj=Ext.getCmp('lowerPanelId');
				if(!Ext.isEmpty(lowerPanelIdObj))
				{
					var hostGlanceIdObj=Ext.getCmp('hostGlanceId');
					if(!Ext.isEmpty(hostGlanceIdObj))
					{
						hostGlanceIdObj.url='/final/monitor/hostGlance.jsp?user=yes&type='+type;
						hostGlanceIdObj.realUrl='/final/monitor/hostGlance.jsp?user=yes&type='+type;
						hostGlanceIdObj.refreshUI();
					}

					var vmGlanceIdObj=Ext.getCmp('vmGlanceId');
					if(!Ext.isEmpty(vmGlanceIdObj))
					{
						vmGlanceIdObj.url='/final/monitor/vmGlance.jsp?user=yes&type='+type;
						vmGlanceIdObj.realUrl='/final/monitor/vmGlance.jsp?user=yes&type='+type;
						vmGlanceIdObj.refreshUI();
					}
				}
				delete jsonData;
				Ext.destroy(jsonData);
				jsonData = null;
			},
			failure:function(){
				//alert('failure')
			}
		});
	}
});
