Ext.define('VirtualDashboard.view.Topgraphpanel',{
	extend : 'utilities.ScrollPanel',
	//extend : 'Ext.panel.Panel',
	alias:'widget.topgraphpanel',
	requires : ['VirtualDashboard.view.Chartpanel','VirtualDashboard.view.Bottomgridpanel'],
	
	flex:1,
	scroll:true,
	id:'topgraphpanel',
	bodyStyle:{'background':'none'},
	border :false,
	graphUrl : null,
	lowerGridUrl : null,
	creategrid :function(jsonData , source)
	{
		var me = this;
		if(!Ext.isEmpty(jsonData) && !Ext.isEmpty(jsonData.Headers))
		{
			var fieldsArray = new Array();
			if(!Ext.isEmpty(jsonData.Headers))
			{
				for(var i=0 ; i<jsonData.Headers.length ; i++){
					fieldsArray.push("value"+i);
				}
			}
			var tempStore = Ext.create('Ext.data.Store', {
				fields : fieldsArray,
				proxy: {
					type: 'memory',
					 reader: {
						 type: 'json',
						 root: 'items'
					 }
				 },
				 data :jsonData.items
			 });
			var columnsArray = new Array();
			
			if(!Ext.isEmpty(jsonData.Headers))
			{
				for(var i=0 ; i<jsonData.Headers.length ; i++){
					var tempwidth;
					if(i==1)
						tempwidth=jsonData.Headers[i].width-0.3+'%';
					else
						tempwidth=jsonData.Headers[i].width+'%';
					columnsArray.push({  
						text: jsonData.Headers[i].name,
						//flex:1,
						width :tempwidth,
						dataIndex: "value"+i,
						menuDisabled :true,
						renderer : function(value,metaData,record,rowIndex,colIndex){
							if(colIndex == 0){
								return '<div style="margin-top:3px;height:10px;width:10px;background-color:#'+value+';"></div>';
							} else {
								return value;
							}
						}
					});
				}
			}
			var Table = {
				xtype :'customgrid',
				//xtype :'Ext.grid.Panel',
				id:'topGraphPanelGraphGridId',
				cls:'gridSkin',
				store : tempStore,
				border :true,
				width: 600,
				columns : columnsArray,
				forcefit: false,
				margin:'3'
			};
		}
		var chartOption = VirtualDashboard.app.getController('VirtualTab').getChartType();
		var imgDiv = '';
		var graph = '';
		var divHeight=300,containerHeight=260;
		isMeasureGraph=false;
		if(this.event == "collapse")
		{
			isMeasureGraph=true;
			divHeight = 400;
			//containerHeight = 450;
			containerHeight = 420;
			this.doComponentLayout();
		}
		if(chartOption != "" && chartOption.indexOf("highchart") > -1)
		{
			imgDiv = '<table style="text-align:center;height:10px;width:100%"><tr><td><center><div id="mainChartid" style="height:'+divHeight+'px;width:100%;"></div></center></td></tr></table>';
		}
		else
		{
			imgDiv = '<table style="text-align:center;height:250px;width:100%"><tr><td><center><img src="'+source+'"/></center></td></tr></table>';
		}
		graph ={
			xtype:'container',
			id:'topGraphPanelGraphId',
			border : false,
			layout:{
				type:'vbox',
				align:'center'
			},
			height:containerHeight,
			margin:'0 0 10 0',
			//style:'overflowY:auto',
			autoScroll: false,
			scroll:false,
			html:imgDiv,
			//html:'<table style="text-align:center;height:10px;width:100%"><tr><td><center><div id="mainChartid" style="height:'+divHeight+'px;width:100%"></div></center></td></tr></table>',
			listeners:{
				'boxready': function(currObj){
					if(getBrowser()=='ie' || getBrowser()=='edge' || getBrowser()=='firefox')
					{
						currObj.setHeight(containerHeight);
						currObj.update(imgDiv);
					}
				},
				'afterrender': function(currObj){
					if(chartOption.indexOf("highchart") > -1)
					{
						Ext.defer(function(){
							bigHighChart(source,"mainChartid^mainChartDataid",divHeight-20,800,'',true,'right','up');
						},100);
					}
				}
			}
		}
		var TablePanel ={
				xtype:'container',
				id:'mainChartDataid',
				border : false,
				layout:{
					type:'vbox',
					align:'center'
				},
				margin:'8 0 8 0',
				items:[Table]
		}

		if(!Ext.isEmpty(graph) && !Ext.isEmpty(TablePanel))
		{
			me.add([graph,TablePanel]);
		}

		me.doComponentLayout();

		var topGraphPanelGraphIdObj=Ext.getCmp('topGraphPanelGraphId');
		if(!Ext.isEmpty(topGraphPanelGraphIdObj))
		{
			//topGraphPanelGraphIdObj.setHeight(containerHeight);
			//topGraphPanelGraphIdObj.update(imgDiv);
		}

		if(chartOption.indexOf("highchart") > -1)
		{
			//bigHighChart(source,"mainChartid^mainChartDataid",divHeight-20,800,'',true,'right');
		}
	},
	createDataGrid :function(jsonData)
	{
		if(!Ext.isEmpty(jsonData.Headers))
		{
			var fieldsArray = new Array();
			if(!Ext.isEmpty(jsonData.Headers))
			{
				for(var i=0 ; i<jsonData.Headers.length ; i++){
					fieldsArray.push("value"+i);
				}
			}

			var tempStore = Ext.create('Ext.data.Store', {
				fields : fieldsArray,
				proxy: {
					type: 'memory',
					 reader: {
						 type: 'json',
						 root: 'items'
					 }
				 },
				 data :jsonData.items
			 });
			var columnsArray = new Array();

			if(!Ext.isEmpty(jsonData.Headers))
			{
				for(var i=0 ; i<jsonData.Headers.length ; i++){
					var tempwidth;
					if(i==1)
						tempwidth=jsonData.Headers[i].width-0.3+'%';
					else
						tempwidth=jsonData.Headers[i].width+'%';
					columnsArray.push({  
						text: jsonData.Headers[i].name,
						//flex:1,
						width :tempwidth,
						dataIndex: "value"+i,
						menuDisabled :true,
						flex:3,
						renderer : function(value,metaData,record,rowIndex,colIndex){
							if(colIndex == 0){
								return '<div style="height:10px;width:15px;background-color:#'+value+';"></div>';
							} else {
								return value;
							}
						}
					});
				}
			}
			var Table = {
						//xtype :'customgrid',
						xtype :'Ext.grid.Panel',
						cls:'gridSkin',
						store : tempStore,
						scroll:false,
						autScroll:false,
						border :true,
						//width: 600,
						columns : columnsArray
						//forcefit: true,
						//margin:'20 50 20 50'
				};
		}

		var TablePanel ={
				xtype:'container',
				border : false,
				
				layout:{
					type:'anchor',
					align:'center'
				},
				margin:'20 0 10 0',
				items:[Table]
		}
		return TablePanel;
	}
});