Ext.define('VirtualDashboard.view.VirtualTabPanel', {
	extend: 'Ext.tab.Panel',
	requires : ['VirtualDashboard.view.SummaryTab','VirtualDashboard.view.VirtualTab','VirtualDashboard.view.EventsTab','VirtualDashboard.view.ResourcesTab','VirtualDashboard.view.ClusterTab'],
	alias:'widget.virtualtabpanel',
	cls:'tablayout tabborder',
	margin:'8 10 0 0',
	maintainFlex:true,
	frame:true,
	border:true,
	tabsInfo:null,
	initComponent : function() {
		var mask = null;
		var wholeViewport = document.getElementsByTagName("body")[0];
		if(!Ext.isEmpty(Ext.get(wholeViewport))){
			mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
			mask.show();
		}
	 var itemsArray=new Array();
	 if(!Ext.isEmpty(this.tabsInfo)){
		 for(var i=0;i<this.tabsInfo.length;i++){
			 var type=this.tabsInfo[i].type;
			 var cmpXtype=this.getTabXtype(this.tabsInfo[i].type);
			 itemsArray.push({
				 xtype:cmpXtype,
				 title:this.tabsInfo[i].name,
				 itemId:type.toLowerCase(),
				 changeTabId :this.tabsInfo[i].id,
				 mask:mask
			 });
		 }
	 }
	 this.items=itemsArray;
	 this.callParent();
	},
	
	getTabXtype:function(type){
		var cmpXtype='summarytab';
		switch(type.toLowerCase()){
			case 'summarytab': cmpXtype='summarytab';
				           break;
			case 'clustertab': cmpXtype='clustertab';
				           break;
			case 'virtualtab': cmpXtype='virtualtab';
	           			   break;
			case 'hoststab': cmpXtype='virtualtab';
	           			    break;
			case 'eventstab': cmpXtype='eventstab';
							break;
			case 'datastoretab': cmpXtype='virtualtab';
							break;
			case 'virtualcentertab': cmpXtype='virtualtab';
							break;	
			case 'resourcestab': cmpXtype='resourcestab';
							break;		
		}
		return cmpXtype;
	}
	
});
