Ext.define('VirtualDashboard.view.VirtualTreePanel', {
	extend: 'Ext.panel.Panel',
	alias:'widget.virtualtreepanel',
	scroll:false,
	autoScroll:false,
	//flex:1,
	margin:'8 0 0 8',
	layout:'fit',
	url : null,
	cls:'treePanelDesign',
	hideCollapseTool:true,
	frame:true,

	initComponent : function(){
		var me=this;
		
		Ext.Ajax.request({
			url : me.url,
			method : 'GET',
			timeout:1280000,
			success : function(response, opts){
				var jsonText = null;
				jsonText = response.responseText;
				var jsonData = null;
				jsonData = Ext.decode(jsonText);
				if(Ext.isIE){
					delete jsonText;
				}
				jsonData["expanded"] = true;
				jsonData["cls"] = "list-tree-root-expand-collapse";
				var treePanelStore = Ext.create('Ext.data.TreeStore', {
					root : jsonData
				});
				//var treePanel = Ext.create('utilities.ScrollableTreePanel',{
				var treePanel = Ext.create('utilities.TreeScrollPanel',{
					id:'virtualTreeId',
					margin:'0 0 0 0',
					//flex:1,
					store : treePanelStore,
					scroll:true,
					autoScroll:true,
					cls:'treePanelDesign',
					border : false,
					useArrows:true,
					stateId:'virtual-tree-panel-stateId',
					rootVisible :false,
					layout:'fit'
				});
				me.add(treePanel);
				me.doLayout();
				if(!Ext.isEmpty(requestParams.treeTool) && !Ext.isEmpty(requestParams.treeTool.imageTitle))
				{
					me.addTool({
						xtype:'image',
						id:'vTreeImgId',
						src : '/final/images/clear.png',
						cls:'iconDisplaySettings',
						action:'showDisplaySettings',
						listeners : {
							render : function(image, eOpts){
								var maintenanceTooltip = Ext.create('Ext.tip.ToolTip', {
									//cls : 'iconClose yellowTip',
									anchor:'top',
									target : image.getId(),
									html : requestParams.treeTool.imageTitle
								});
								image.getEl().on('click', function(){
									this.fireEvent('click', image);
								}, image);
							}
						}
					});
				}
				var htmlstring='<div><div class="'+jsonData.iconCls+'" style="display:inline-block;vertical-align:middle;float:left;margin-right:3px"></div><a style="padding-left:5px;display:block" href="javascript:void(0);" onclick="callTabData(\''+jsonData.link+'\')">'+jsonData.text+'</a></div>';
				me.setTitle(htmlstring);

				if(!Ext.isEmpty(requestParams.treeTool) && !Ext.isEmpty(requestParams.treeTool.title))
				{
					var win= Ext.create('Ext.window.Window',{
						id:'dispSettingsId',
						closeAction:'hide',
						header:true,
						draggable:false,
						padding:'3 5 5 5',
						action:'dispSettings',
						renderTo:'virtualTreePanelId',
						resizable:false,
						width:190,
						title:requestParams.treeTool.title,
						items:[{
							id:'dispSettingsHCId',
							xtype:'checkbox',
							padding:5,
							cls:'display-setting checkbt',
							boxLabel  : requestParams.treeTool.items[0].name,
							boxLabelAlign:'after',
							action:'hostAndCluster',
							value: requestParams.treeTool.items[0].value,
							checked: requestParams.treeTool.items[0].checked=="checked" ? true : false
						},{
							xtype:'checkbox',
							id:'dispSettingsSVId',
							padding:5,
							cls:'display-setting checkbt',
							boxLabel  : requestParams.treeTool.items[1].name,
							boxLabelAlign:'after',
							action:'showVms',
							value: requestParams.treeTool.items[1].value,
							checked: requestParams.treeTool.items[1].checked=="checked" ? true : false
						}]
					});
					me.add(win);
				}
			},
			failure : function(response, opts){
				//alert("Failure");
			}
		});
		this.callParent();
	},
	refreshTreeUI: function(){
		var me=this;
		Ext.Ajax.request({
			url : me.url,
			method : 'GET',
			timeout:1280000,
			success : function(response, opts){
				var jsonText = null;
				jsonText = response.responseText;
				var jsonData = null;
				jsonData = Ext.decode(jsonText);
				if(Ext.isIE){
					delete jsonText;
				}
				jsonData["expanded"] = true;
				jsonData["cls"] = "list-tree-root-expand-collapse";

				var virtualTreeIdObj=Ext.getCmp('virtualTreeId');
				if(!Ext.isEmpty(virtualTreeIdObj))
				{
					virtualTreeIdObj.setRootNode(jsonData);
					VirtualDashboard.app.getController('Main').virtualTreeRefresh();
				}

				var vTreeImgIdObj=Ext.getCmp('vTreeImgId');
				if(!Ext.isEmpty(vTreeImgIdObj))
				{
					vTreeImgIdObj.src='/final/images/clear.png';
					vTreeImgIdObj.cls='iconDisplaySettings';
					vTreeImgIdObj.action='showDisplaySettings';
					vTreeImgIdObj.fireEvent('afterrender',vTreeImgIdObj);
					vTreeImgIdObj.listeners ={
						'afterrender' : function(image, eOpts){
							var maintenanceTooltip = Ext.create('Ext.tip.ToolTip', {
								cls : 'iconClose yellowTip',
								anchor:'top',
								target : image.getId(),
								html : requestParams.treeTool.imageTitle
							});
							image.getEl().on('click', function(){
								this.fireEvent('click', image);
							}, image);
						}
					}
				}

				var htmlstring='<div><div class="'+jsonData.iconCls+'" style="display:inline-block;vertical-align:middle;float:left;margin-right:3px"></div><a style="padding-left:5px;display:block" href="javascript:void(0);" onclick="callTabData(\''+jsonData.link+'\')">'+jsonData.text+'</a></div>';
				me.setTitle(htmlstring);

				var dispSettingsIdObj=Ext.getCmp('dispSettingsId');
				if(!Ext.isEmpty(dispSettingsIdObj))
				{
					var dispSettingsHCIdObj=Ext.getCmp('dispSettingsHCId');
					if(!Ext.isEmpty(dispSettingsHCIdObj))
					{
						dispSettingsHCIdObj.padding=10;
						dispSettingsHCIdObj.cls='display-setting checkbt';
						dispSettingsHCIdObj.boxLabel=requestParams.treeTool.items[0].name;
						//dispSettingsHCIdObj.boxLabelAlign='after';
						//dispSettingsHCIdObj.action='hostAndCluster';
						//dispSettingsHCIdObj.setValue=requestParams.treeTool.items[0].value;
						//dispSettingsHCIdObj.checked=requestParams.treeTool.items[0].checked=="checked" ? true : false;
					}

					var dispSettingsSVIdObj=Ext.getCmp('dispSettingsSVId');
					if(!Ext.isEmpty(dispSettingsSVIdObj))
					{
						dispSettingsSVIdObj.padding=10;
						dispSettingsSVIdObj.cls='display-setting checkbt';
						dispSettingsSVIdObj.boxLabel=requestParams.treeTool.items[1].name;
						//dispSettingsSVIdObj.boxLabelAlign='after';
						//dispSettingsSVIdObj.action='showVms';
						//dispSettingsSVIdObj.setValue(requestParams.treeTool.items[1].value);
						//dispSettingsSVIdObj.checked=requestParams.treeTool.items[1].checked=="checked" ? true : false;
					}
				}
			},
			failure : function(response, opts){
				//alert("Failure");
			}
		});
		//this.callParent();
	}
});
