Ext.define('VirtualServers.view.Main', {
	extend: 'utilities.OuterPanel',
	//extend: 'Ext.panel.Panel',
	alias: 'widget.main',
	//title: 'VIRTUAL SERVERS',
	bodyPadding: '0 0 0 0',
	id: 'virtualservers',
	autoScroll:true,
	scroll:true,
	margin:"8 8 0 8",
	frame:false,
	constrainAlign:true,
	padding:"0",
	cls:"outerpanel",
	bodyPadding:"0",

	tools: [{
			xtype : 'button',
			cls:'iconAutomaticScrollRun',
			id:'iconAutomaticScrollRun',
			//text:'Click to Automatic Scroll 111',
			margin: '0px 4px 0px 4px',
			ui: 'action',
			hidden:true,
			border:true,
			style: {
				border: '0px'
			},
			handler:function(){
				scrollFlag=true;
				pageScroll();
				Ext.getCmp('iconAutomaticScrollRun').hide();
				//Ext.getCmp('iconAutomaticScrollStop').show();
			},
			listeners: {
				afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
						target: this.id,
						anchor: 'top',
						cls: 'yellowTip',
						trackMouse: true,
						autoDestroy:true,
						html: 'Click to Automatic Scroll'
					});
				}
			}
		},
		{
			xtype : 'button',
			cls:'iconAutomaticScrollStop',
			id:'iconAutomaticScrollStop',
			margin: '0px 4px 0px 4px',
			ui: 'action',
			hidden:true,
			style: {
				border: '0px'
			},
			handler:function(){
				scrollFlag=false;
				stopScroll();
				Ext.getCmp('iconAutomaticScrollStop').hide();
				//Ext.getCmp('iconAutomaticScrollRun').show();
			},
			listeners: {
				afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
						target: this.id,
						anchor: 'top',
						cls: 'yellowTip',
						trackMouse: true,
						autoDestroy:true,
						html: 'Stop the Scroll'
					});
				}
			}
		},
		{
			xtype:'tbseparator',
			cls:'removeLineForTvMode',
			hidden:true,
		},
		{
			xtype : 'button',
			cls:'iconAutomaticScrollJumpToTop',
			id:'iconAutomaticScrollJumpToTop',
			margin: '0px 4px 0px 4px',
			ui: 'action',
			hidden:true,
			style: {
				border: '0px'
			},
			handler:function(){
				scrollFlag=false;
				jumpScroll();
				Ext.getCmp('iconAutomaticScrollStop').hide();
				//Ext.getCmp('iconAutomaticScrollRun').show();
			},
			listeners: {
				afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
						target: this.id,
						anchor: 'top',
						cls: 'yellowTip',
						trackMouse: true,
						autoDestroy:true,		//
						html: 'Jump to top'
					});
				}
			}
		},
		{
			xtype:'tbseparator',
			cls:'removeLineForTvMode',
			hidden:true,
		},{
			xtype:'commonbackbutton',
			hidden: hideBackButton,
			text:backbtnTxt
			/*handler:function(){
				alert('main back');
				window.history.go(-1);
			}*/
	}],
	/*layout:{
		type : 'column',
		column: 5
	},*/
	//layout:{type:'hbox',align:'stretch'},
	layout:{
		type : 'vbox',align:'stretch',pack:'center'
	},
	requires: [
		'utilities.EmptyPanel',
		'utilities.CommonPanel',
		'utilities.ScrollCombo',
		'utilities.CommonBackButton',
		'utilities.ErrorPanel'
	],
	config:{
		emptyPanel:null
	},
	initComponent:function(){
		this.callParent();
		this.initConfig();
		var me = this;
		if(!Ext.isEmpty(me) && !Ext.isEmpty(me.items))
		{
			var dockedItems = me.getDockedItems('toolbar');
			if(!Ext.isEmpty(dockedItems))
			{
				for(var dockedCounter = 0 ; dockedCounter < dockedItems.length ; dockedCounter++)
				{
					me.removeDocked(dockedItems[dockedCounter]);
				}
			}

			var resultItems=me.items.items;
			if(!Ext.isEmpty(resultItems))
			{
				for(var item=resultItems.length-1; item>-1 ; item--)
				{
					resultItems[item].destroy();
				}
			}
		}
		var emptyPanel = Ext.create('utilities.EmptyPanel',{
			items:[{
				xtype:'container',
				padding:50,
				style:{'text-align':'center'},
				html:'<div class = "iconInformation" style="margin:0 auto"></div><div>Please enter user name and press submit</div>',
				listeners:{
					boxready:function(){
						var scrollRun = Ext.getCmp('iconAutomaticScrollRun');
						if (!Ext.isEmpty(scrollRun) )
						{
							scrollRun.hide();
						}
						ScrollJumpToTop = Ext.getCmp('iconAutomaticScrollJumpToTop');
						if (!Ext.isEmpty(ScrollJumpToTop) )
						{
							ScrollJumpToTop.hide();
						}
						Ext.Element.select('.removeLineForTvMode').hide();
					}
				}
			}],
			listeners:{
				boxready:function(){
					var scrollRun = Ext.getCmp('iconAutomaticScrollRun');
					if (!Ext.isEmpty(scrollRun) )
					{
						scrollRun.hide();
					}
					ScrollJumpToTop = Ext.getCmp('iconAutomaticScrollJumpToTop');
					if (!Ext.isEmpty(ScrollJumpToTop) )
					{
						ScrollJumpToTop.hide();
					}
					Ext.Element.select('.removeLineForTvMode').hide();
				}
			}
		});
		this.setEmptyPanel(emptyPanel);

		var virtualUrl = '';
		if(virtualChoice == 'virtualservers')
			virtualUrl = '/final/monitor/EgDispvmwareHostsData.jsp';
		else if(virtualChoice == 'publicclouds')
			virtualUrl = '/final/monitor/EgDispCloudHostsData.jsp';
		else if(virtualChoice == 'VMwareDesktop')
			virtualUrl = '/final/monitor/EgVmwareDesktopData.jsp?'+virtualURL;

		if(virtualChoice != 'LayerModel')
		{
			Ext.Ajax.request({
				url:virtualUrl,
				method:'post',
				success:function(response){
					var jsonData = Ext.decode(response.responseText);
					var componentData = null;
					var vmsData = null;
					if(!Ext.isEmpty(jsonData.virtualServers))
						componentData = jsonData.virtualServers;
					else if(!Ext.isEmpty(jsonData.cloudServers))
						componentData = jsonData.cloudServers;
					else if(!Ext.isEmpty(jsonData.vmwareDesktop))
						vmsData = jsonData.vmwareDesktop;

					if(!Ext.isEmpty(jsonData.screenLabels))
						me.setTitle(jsonData.screenLabels.Title);

					if(!Ext.isEmpty(vmsData) && !Ext.isEmpty(jsonData.otherLinks))
					{
						var layerBtn = null;
						var liveBtn = null;
						var searchTxt = null;
						
						if(!Ext.isEmpty(jsonData.otherLinks.LIVE_GRAPH))
						{
							searchTxt = {
								xtype:'trigger',
								fieldLabel:'',
								cls: 'whitedropdown_search',
								emptyText:jsonData.otherLinks.USER_NAME_SEARCH,
								id:'USER_NAME_SEARCHID',
								labelSeparator:'',
								labelAlign:"left",
								margin:'0 10 0 0',
								border:true,
								enableKeyEvents: true,
								value: jsonData.otherLinks.SEARCH_VALUE,
										onTriggerClick: function() {
										var infoNameSearch= Ext.getCmp('USER_NAME_SEARCHID').getValue();
										VirtualServers.app.getController("Main").infoSearch(infoNameSearch);
										
									}
								}
								
							layerBtn = Ext.create('Ext.button.Button', {
								cls:'button20',
								ui:'dummy',
								margin:'0 10 0 0',
								border:false,
								width:150,
								text    : jsonData.otherLinks.COMPONENT_LAYERS,
								listeners: {
									click: function(){
										window.location.href=jsonData.otherLinks.COMPONENT_LAYERS_URL;
									}
								}
							});

							liveBtn = Ext.create('Ext.button.Button', {
								cls:'button20',
								//iconCls:'icon-arrow-left',
								border:false,
								ui:'dummy',
								margin:'0 10 0 0',
								width:90,
								text    : jsonData.otherLinks.LIVE_GRAPH,
								listeners: {
									click: function(){
										window.openWindow(jsonData.otherLinks.LIVE_GRAPH_URL, "virtualLiveGraph","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes,location=no");
									}
								}
							});
						}
						else if(!Ext.isEmpty(jsonData.otherLinks.COMPONENT_LAYERS))
						{
							layerBtn = Ext.create('Ext.button.Button', {
								cls:'button20',
								ui:'dummy',
								margin:'0 10 0 0',
								border:false,
								width:130,
								text    : jsonData.otherLinks.COMPONENT_LAYERS,
								listeners: {
									click: function(){
										window.location.href=jsonData.otherLinks.COMPONENT_LAYERS_URL;
									}
								}
							});
						}
						else if(!Ext.isEmpty(jsonData.otherLinks.USER_NAME_SEARCH))
						{
							searchTxt = {
								xtype:'trigger',
								fieldLabel:'',
								cls: 'whitedropdown_search',
								emptyText:jsonData.otherLinks.USER_NAME_SEARCH,
								id:'USER_NAME_SEARCHID',
								labelSeparator:'',
								labelAlign:"left",
								margin:'0 10 0 0',
								border:true,
								enableKeyEvents: true,
								value: jsonData.otherLinks.SEARCH_VALUE,
									onTriggerClick: function() {
									var infoNameSearch= Ext.getCmp('USER_NAME_SEARCHID').getValue();
									VirtualServers.app.getController("Main").infoSearch(infoNameSearch);
								}
							}
						}
						
						me.addDocked({
							xtype: 'toolbar',
							dock: 'top',
							padding:'4 0 6 0',
							cls:'virtualServerHeader',
							items: ['->', searchTxt, layerBtn, liveBtn]
						});
					}

					if(!Ext.isEmpty(vmsData) && !Ext.isEmpty(jsonData.searchJson))
					{
						var errorPanel = {
							xtype : 'errorpanel',
							width : '100%',
							height : '500',
							margin : 5,
							errorMsg : '<div class="searchDiv" style="border:0px solid green;height:40px;"><table border="0" cellspacing="0" cellpadding="2" width="100%" id="cell_border3" height="100%"><tr><td align="left" valign="middle"><table align="left" cellspacing="0" cellpadding="2" border="0" ><tr><th class="eg_bodybg" id="eg_darktextbold" nowrap="nowrap"><font id="eg_color3">&nbsp;'+ jsonData.searchJson.Search_Display+ '</font></th><td class="eg_bodybg"><input type="text" name="servername" size="12" style="width: 180px;" value="'+jsonData.searchJson.Search_Server+'" maxlength="128" ></td><td class="eg_bodybg"><input type="image" src="/final/monitor/eg_images/arrow_1.gif" onClick="javascript:valform();" value="SEARCH" name="searchbutton" id="eg_input"></td><td class="eg_bodybg" id="eg_blankspace" width="2" nowrap="nowrap">&nbsp;</td></tr></table></td><td><sup>* </sup>'+jsonData.searchJson.Search_Str+'</td></tr></table></div>',
							style : 'margin-top:-300px'
						}
						me.add(errorPanel);

						errorPanel = null;
						delete errorPanel;
					}

					if(!Ext.isEmpty(componentData))
					{
						var createView = [];
						var defaultBoxWidth = 240;
						var width = Math.round(Ext.get(me.body.id).getWidth()/defaultBoxWidth);

						
						for(i=0;i<componentData.length;i++){
							createView.push({
								xtype:'commoncomponent',
								name:componentData[i].componentName,
								componentName:componentData[i].componentName,
								componentType:componentData[i].componentType,
								componentTypeDispName:componentData[i].componentTypeDispName,
								imageName:componentData[i].imageName,
								drillDownUrl:componentData[i].link,
								state:componentData[i].state,
								category:componentData[i].category,
								skin:componentData[i].skin,
								
								border:true,
								listeners:{
									render:function(thisObj){
										thisObj.el.on('click',function(){
											thisObj.fireEvent('click',thisObj);
										});
									},
									boxready:function(){
										if ($('#virtualservers-body')[0].scrollHeight > $('#virtualservers-body').innerHeight())
										{
											//Ext.Element.select('.removeLineForTvMode').show();
											//Ext.getCmp('iconAutomaticScrollRun').show();
											//Ext.getCmp('iconAutomaticScrollJumpToTop').show();
										}
										else
										{
											Ext.getCmp('iconAutomaticScrollRun').hide();
											Ext.Element.select('.removeLineForTvMode').hide();
											Ext.getCmp('iconAutomaticScrollJumpToTop').hide();
										}
									}
								},
							});
						}
						//me.add(createView);
						me.add({
								xtype:'panel',
								cls:'tablepanel',
								
								bodyPadding:10,
								layout: {
									type: 'table',
									columns: width,
									tableAttrs: {
											style: {
												width: '100%'
											}
										}
								},
								defaults: {
									bodyStyle: 'padding:20px'
								},
								listeners:{
									resize:function(){
										var width = Math.round(Ext.get(me.body.id).getWidth()/defaultBoxWidth);
										this.layout.columns = width;
										this.updateLayout();
									}	
								},
								style:{'border':'0px solid red'},
								border:false,
								scroll:false,
								autoScroll:false,
								items:createView
							});
						strTopology = null;

						createView = null;
						delete createView;
					}
					else if(!Ext.isEmpty(jsonData.error)){
						var errorPanel = {
								xtype : 'errorpanel',
								width : '100%',
								height : 500,
								padding:200,
								style:{'text-align':'center','border':'0px'},
								imageCls:'iconInformation',
								errorMsg :'<div><b>'+jsonData.error+'</b></div>',
								listeners:{
									boxready:function(){
										var scrollRun = Ext.getCmp('iconAutomaticScrollRun');
										if (!Ext.isEmpty(scrollRun) )
										{
											scrollRun.hide();
										}
										ScrollJumpToTop = Ext.getCmp('iconAutomaticScrollJumpToTop');
										if (!Ext.isEmpty(ScrollJumpToTop) )
										{
											ScrollJumpToTop.hide();
										}
										Ext.Element.select('.removeLineForTvMode').hide();
									}
								}
							}
							me.add(errorPanel);

							errorPanel = null;
						strTopology = null;
							delete errorPanel;
					}
					else if(!Ext.isEmpty(vmsData))
					{
						if(!Ext.isEmpty(vmsData[0].NoDataImg))
						{
							var errorPanel = {
								xtype : 'errorpanel',
								width : '100%',
								height : 500,
								padding:200,
								style:{'text-align':'center','border':'0px'},
								imageCls:'iconInformation',
								errorMsg :'<div>'+ vmsData[0].NoDataText+'</div>',
								listeners:{
									boxready:function(){
										var scrollRun = Ext.getCmp('iconAutomaticScrollRun');
										if (!Ext.isEmpty(scrollRun) )
										{
											scrollRun.hide();
										}
										ScrollJumpToTop = Ext.getCmp('iconAutomaticScrollJumpToTop');
										if (!Ext.isEmpty(ScrollJumpToTop) )
										{
											ScrollJumpToTop.hide();
										}
										Ext.Element.select('.removeLineForTvMode').hide();
									}
								}
							}
							me.add(errorPanel);

							errorPanel = null;
							strTopology = null;
							delete errorPanel;
						}
						else
						{
							var temp="";
							//var createView=[];


							for(i=0;i<vmsData.length;i++)
							{
								var vmStateImgString = vmsData[i].VmStateImg;
								var VmURLString = vmsData[i].VmURL;
								var VmImgString = vmsData[i].VmImg;
								var VmDispNameString = vmsData[i].VmDispName;
								var VmDispNameTip = vmsData[i].VmDispNameTooltip;
								if(!Ext.isEmpty(VmDispNameString) && VmDispNameString.length > 60){
									VmDispNameString = VmDispNameString.substring(0,61)+"...";
								}
								if(!Ext.isEmpty(VmURLString))
								{
									//temp=temp+'<div style="padding:10px;width:220px;height:110px;float:left;"><a href="'+VmURLString+'"><div class="server_'+vmStateImgString+'"><img src="/final/images/component_icons/VDI_desktop.png"/></div><div class="virtualCloudText" data-qclass="yellowTip" data-qtip="'+VmDispNameString+'">'+VmDispNameString+'</div></a></div>';

									//temp=temp+'<div style="padding:10px;width:220px;height:110px;float:left;"><a href="'+VmURLString+'" style="display:block;text-align:center;"><div style="margin:5px auto 0px auto;display:inline-block;width:48px;height:48px;border:0px solid red;" align="center"><div style="position:relative;top:0px;left:0px;border:0px solid green;"><img src="/final/images/'+strSkin+'/component_icons/desktop.png"/><div style="position:absolute;top:28px;left:28px;" class="state20_'+vmStateImgString.toUpperCase()+'"></div></div></div><div class="virtualCloudTextforVm" data-qclass="yellowTip" data-qtip="'+VmDispNameTip+'">'+VmDispNameString+'</div></a></div>';

									temp=temp+'<div style="padding:10px;width:220px;height:110px;float:left;"><a href="'+VmURLString+'" style="display:block;text-align:center;"><div style="margin:5px auto 0px auto;display:inline-block;width:48px;height:48px;border:0px solid red;" align="center"><div style="position:relative;top:0px;left:0px;border:0px solid green;"><img src="'+VmImgString+'"/><div style="position:absolute;top:28px;left:28px;" class="state20_'+vmStateImgString.toUpperCase()+'"></div></div></div><div class="virtualCloudTextforVm" data-qclass="yellowTip" data-qtip="'+VmDispNameTip+'">'+VmDispNameString+'</div></a></div>';
								}
								else
								{
									//temp=temp+'<div style="padding:10px;width:220px;height:110px;float:left;"><a href="javascript:void(0)"><div class="server_'+vmStateImgString+'"><img src="/final/images/component_icons/VDI_desktop.png"/></div><div class="virtualCloudText" data-qclass="yellowTip" data-qtip="'+VmDispNameString+'">'+VmDispNameString+'</div></a></div>';

									//temp=temp+'<div style="padding:10px;width:220px;height:110px;float:left;"><a href="javascript:void(0)" style="display:block;text-align:center;"><div style="margin:5px auto 0px auto;display:inline-block;width:48px;height:48px;border:0px solid red;" align="center"><div style="position:relative;top:0px;left:0px;border:0px solid green;"><img src="/final/images/'+strSkin+'/component_icons/desktop.png"/><div style="position:absolute;top:28px;left:28px;" class="state20_'+vmStateImgString.toUpperCase()+'"></div></div></div><div class="virtualCloudTextforVm" data-qclass="yellowTip" data-qtip="'+VmDispNameTip+'">'+VmDispNameString+'</div></a></div>';

									temp=temp+'<div style="padding:10px;width:220px;height:110px;float:left;"><a href="javascript:void(0)" style="display:block;text-align:center;"><div style="margin:5px auto 0px auto;display:inline-block;width:48px;height:48px;border:0px solid red;" align="center"><div style="position:relative;top:0px;left:0px;border:0px solid green;"><img src="'+VmImgString+'"/><div style="position:absolute;top:28px;left:28px;" class="state20_'+vmStateImgString.toUpperCase()+'"></div></div></div><div class="virtualCloudTextforVm" data-qclass="yellowTip" data-qtip="'+VmDispNameTip+'">'+VmDispNameString+'</div></a></div>';
								}
							}

							var resultItems=me.items.items;

							for(var item=resultItems.length-1; item>-1 ; item--)
							{
								resultItems[item].destroy();
							}


							me.update(temp);
							strTopology = null;
							/*var createView = [];
							for(i=0;i<vmsData.length;i++){
								createView.push({
									xtype:'commoncomponent',
									vmware:true,
									VmStateImg:vmsData[i].VmStateImg,
									VmURL:vmsData[i].VmURL,
									VmImg:vmsData[i].VmImg,
									VmDispName:vmsData[i].VmDispName,
									NoDataImg:vmsData[i].NoDataImg,
									NoDataImg:vmsData[i].NoDataImg,
								});
							}
							me.add(createView);

							createView = null;
							delete createView;*/

						}
					}
					else{
						//alert('No data found');
						var errorPanel = {
								xtype : 'errorpanel',
								width : '100%',
								flex:1,
								height : 500,
								padding:200,
								style:{'text-align':'center','border':'0px'},
								imageCls:'iconInformation',
								errorMsg :'<div>'+noDataFound+'</div>',
								listeners:{
									boxready:function(){
										var scrollRun = Ext.getCmp('iconAutomaticScrollRun');
										if (!Ext.isEmpty(scrollRun) )
										{
											scrollRun.hide();
										}
										ScrollJumpToTop = Ext.getCmp('iconAutomaticScrollJumpToTop');
										if (!Ext.isEmpty(ScrollJumpToTop) )
										{
											ScrollJumpToTop.hide();
										}
										Ext.Element.select('.removeLineForTvMode').hide();
									}
								}
							}
							me.add(errorPanel);

							errorPanel = null;
							strTopology = null;
							delete errorPanel;
					}
				},
				failure:function(error){
					//alert('Failure in Virtual Server request');
					var errorPanel = {
						xtype : 'errorpanel',
						width : '100%',
						height : 500,
						padding:200,
						style:{'text-align':'center','border':'0px'},
						imageCls:'iconInformation',
						errorMsg :'<div>'+noDataFound+'</div>',
						listeners:{
							boxready:function(){
								var scrollRun = Ext.getCmp('iconAutomaticScrollRun');
								if (!Ext.isEmpty(scrollRun) )
								{
									scrollRun.hide();
								}
								ScrollJumpToTop = Ext.getCmp('iconAutomaticScrollJumpToTop');
								if (!Ext.isEmpty(ScrollJumpToTop) )
								{
									ScrollJumpToTop.hide();
								}
								Ext.Element.select('.removeLineForTvMode').hide();
							}
						}
					}
					me.add(errorPanel);

					errorPanel = null;
					delete errorPanel;
				}
			});
		}

		virtualUrl = null;
		delete virtualUrl;

		emptyPanel = null;
		delete emptyPanel;
	}
});



/*  Script for automatic scroll options start here   */

var scrolldelay;

function pageScroll(){

	var getMainBody = Ext.getCmp('virtualservers').body;

		getMainBody.scrollBy(0,150);
		scrolldelay = setTimeout('pageScroll()', 3000);
		if($('#virtualservers-body').scrollTop()+$('#virtualservers-body').innerHeight() >= $('#virtualservers-body')[0].scrollHeight)
		{
			if (window.parent.tvModePlayAction!=undefined && window.parent.tvModePlayAction=='pause')
			{
				stopScroll();
				setTimeout('startTvModePlayAction()',3000);
			}
			else
			{
				clearTimeout(scrolldelay);
				scrolldelay=setTimeout('beforeContinueScroll()',3000);
			}
		}
}

function startTvModePlayAction(){
	jumpScroll();
	window.parent.startTvModePlayAction();
}

function beforeContinueScroll(){
	var pane=Ext.getCmp('virtualservers');
	if (!Ext.isEmpty(pane))
	{
		$('#virtualservers-body').scrollTop(0);
		scrolldelay = setTimeout('pageScroll()',3000);
	}
}

function stopScroll(){
	clearTimeout(scrolldelay);
}

function jumpScroll(){
	var pane=Ext.getCmp('virtualservers');
	if (!Ext.isEmpty(pane))
	{
		clearTimeout(scrolldelay);
		$('#virtualservers-body').scrollTop(0); // horizontal and vertical scroll targets
	}
}

	scrolldelay = null;
	delete scrolldelay;

/*  Script for automatic scroll options  end here   */

